/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.mservice.impl.paywriteback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.AbstractPayBillWriteBackService;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.BillWriteBackOperateEnum;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.BillWriteBackParam;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.RefundEntryInfo;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.RefundPayBillInfo;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.RefundRenoteOrCancelParam;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.SourceBillInfo;

public class PaymentApplyBillWriteBackService
extends AbstractPayBillWriteBackService {
    private static final Log logger = LogFactory.getLog(PaymentApplyBillWriteBackService.class);
    private static final String[] UnBillstatus = new String[]{"G", "H"};

    @Override
    protected void doSaveExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.setApplyLockAddAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
        this.DBTxBizUpdate(sourceBill);
    }

    @Override
    protected void doUnSubmitExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.setApplyLockAddAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
        this.DBTxBizUpdate(sourceBill);
    }

    @Override
    protected void doUnAuditExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.setApplyLockAddAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
        this.DBTxBizUpdate(sourceBill);
    }

    @Override
    protected void doSubmitExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.setApplyLockAddAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
        this.DBTxBizUpdate(sourceBill);
    }

    @Override
    protected void doAuditExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.doAuditValidateExecute(param, sourceBill);
    }

    @Override
    protected void doPayExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        DynamicObject contract = this.setApplyPayAddAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
        this.DBTxBizAndContractUpdate(sourceBill, contract);
    }

    @Override
    protected void doCancelPayExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        DynamicObject contract = this.setApplyPaySubtractAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
        this.DBTxBizAndContractUpdate(sourceBill, contract);
    }

    @Override
    protected void doDeleteExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.setApplyLockSubtractAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
        this.DBTxBizUpdate(sourceBill);
    }

    @Override
    protected void doChargebackExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.setApplyLockSubtractAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
        this.DBTxBizUpdate(sourceBill);
    }

    @Override
    protected void doRefundExecute(RefundRenoteOrCancelParam param) {
        List<DynamicObject> sourceBillList = this.refundToApplyBill(param);
        List<DynamicObject> contract = this.batchUpdateContractEntity(param, sourceBillList, false);
        Set<DynamicObject> payItem = this.collectItemBook(sourceBillList);
        this.DBTxBizAndContractBatchUpdate(sourceBillList.toArray(new DynamicObject[0]), contract.toArray(new DynamicObject[0]), payItem.toArray(new DynamicObject[0]));
    }

    @Override
    protected void doCancelRefundExecute(RefundRenoteOrCancelParam param) {
        List<DynamicObject> sourceBillList = this.cancelRefundToApplyBill(param);
        List<DynamicObject> contract = this.batchUpdateContractEntity(param, sourceBillList, true);
        Set<DynamicObject> payItem = this.collectItemBook(sourceBillList);
        this.DBTxBizAndContractBatchUpdate(sourceBillList.toArray(new DynamicObject[0]), contract.toArray(new DynamicObject[0]), payItem.toArray(new DynamicObject[0]));
    }

    @Override
    protected void doRenoteExecute(RefundRenoteOrCancelParam param) {
        List<DynamicObject> sourceBillList = this.refundToApplyBill(param);
        List<DynamicObject> contract = this.batchUpdateContractEntity(param, sourceBillList, false);
        Set<DynamicObject> payItem = this.collectItemBook(sourceBillList);
        this.DBTxBizAndContractBatchUpdate(sourceBillList.toArray(new DynamicObject[0]), contract.toArray(new DynamicObject[0]), payItem.toArray(new DynamicObject[0]));
    }

    @Override
    protected void doCancelRenoteExecute(RefundRenoteOrCancelParam param) {
        List<DynamicObject> sourceBillList = this.cancelRefundToApplyBill(param);
        List<DynamicObject> contract = this.batchUpdateContractEntity(param, sourceBillList, true);
        Set<DynamicObject> payItem = this.collectItemBook(sourceBillList);
        this.DBTxBizAndContractBatchUpdate(sourceBillList.toArray(new DynamicObject[0]), contract.toArray(new DynamicObject[0]), payItem.toArray(new DynamicObject[0]));
    }

    protected List<DynamicObject> refundToApplyBill(RefundRenoteOrCancelParam param) {
        List<DynamicObject> sourceBillList = this.setRefundAmountToSourceBill(param, true);
        this.reFundAndReNoteAmountValidate(param, sourceBillList);
        return sourceBillList;
    }

    protected List<DynamicObject> cancelRefundToApplyBill(RefundRenoteOrCancelParam param) {
        List<DynamicObject> sourceBillList = this.setRefundAmountToSourceBill(param, false);
        this.cancelReFundAndReNoteAmountValidate(param, sourceBillList);
        return sourceBillList;
    }

    @Override
    protected void doSaveAndSubmitValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.setApplyLockAddAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
    }

    @Override
    protected void doSubmitValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.amountValidate(param, sourceBill);
    }

    @Override
    protected void doAuditValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.setApplyLockAddAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
    }

    @Override
    protected void doPayValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.setApplyPayAddAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
    }

    @Override
    protected void doCancelPayValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.setApplyPaySubtractAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
    }

    @Override
    protected void doRefundAndReNoteValidateExecute(RefundRenoteOrCancelParam param) {
        this.refundToApplyBill(param);
    }

    @Override
    protected void doCancelRefundAndReNoteValidateExecute(RefundRenoteOrCancelParam param) {
        this.cancelRefundToApplyBill(param);
    }

    protected void setApplyLockAddAmount(BillWriteBackParam param, DynamicObject sourceBill) {
        BillWriteBackParam.BillInfo payBill = param.getBill();
        DynamicObjectCollection targetBillEntry = payBill.getTargetBill().getDynamicObjectCollection("entry");
        BigDecimal payAmount = payBill.getAmount();
        Map<Long, BigDecimal> map = targetBillEntry.stream().collect(Collectors.toMap(obj -> obj.getLong("e_sourcebillentryid"), obj -> obj.getBigDecimal("e_payableamt")));
        DynamicObjectCollection sourceEntities = sourceBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject sourceEntity : sourceEntities) {
            long entryId = sourceEntity.getLong("id");
            if (!map.containsKey(entryId)) continue;
            BigDecimal thisPayAbleAmount = sourceEntity.getBigDecimal("thispayableamount");
            BigDecimal otherPayAmount = this.getOtherPayAmountByEntryId(entryId, payBill.getBillId(), sourceBill.getPkValue());
            BigDecimal lockAmount = otherPayAmount.add(payAmount);
            sourceEntity.set("entrylockamount", (Object)lockAmount);
            sourceEntity.set("entryunlockamount", (Object)thisPayAbleAmount.subtract(lockAmount));
        }
    }

    protected BigDecimal getOtherPayAmountByEntryId(long entryId, long targetId, Object sourcePkValue) {
        QFilter qFilter = new QFilter("entry.e_sourcebillentryid", "=", (Object)entryId);
        qFilter.and(new QFilter("id", "!=", (Object)targetId));
        qFilter.and(new QFilter("billstatus", "not in", (Object)UnBillstatus));
        DynamicObjectCollection casBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,entry.e_payableamt", (QFilter[])new QFilter[]{qFilter});
        BigDecimal casAmount = casBills.stream().map(dyn -> dyn.getBigDecimal("entry.e_payableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"pmct_paymentapply", (Long[])new Long[]{(Long)sourcePkValue});
        HashSet targetPks = targetBills.getOrDefault("pmct_paymentregister", new HashSet());
        BigDecimal paymentAmount = BigDecimal.ZERO;
        if (!targetPks.isEmpty()) {
            DynamicObject[] paymentBills;
            for (DynamicObject paymentBill : paymentBills = BusinessDataServiceHelper.load((String)"pmct_paymentregister", (String)"id,entryentity,entryentity.thispaymentoftaxamount,entryentity.payapplyno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)targetPks.toArray())})) {
                DynamicObjectCollection entries = paymentBill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entries) {
                    DynamicObject applyEntry = entry.getDynamicObject("payapplyno");
                    if (applyEntry == null || !applyEntry.getPkValue().equals(entryId)) continue;
                    paymentAmount = paymentAmount.add(entry.getBigDecimal("thispaymentoftaxamount"));
                }
            }
        }
        return casAmount.add(paymentAmount);
    }

    protected void setApplyLockSubtractAmount(BillWriteBackParam param, DynamicObject sourceBill) {
        BillWriteBackParam.BillInfo payBill = param.getBill();
        DynamicObjectCollection targetBillEntry = payBill.getTargetBill().getDynamicObjectCollection("entry");
        BigDecimal payAmount = payBill.getAmount();
        Map<Long, BigDecimal> map = targetBillEntry.stream().collect(Collectors.toMap(obj -> obj.getLong("e_sourcebillentryid"), obj -> obj.getBigDecimal("e_payableamt")));
        DynamicObjectCollection sourceEntities = sourceBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject sourceEntity : sourceEntities) {
            if (!map.containsKey(sourceEntity.getLong("id"))) continue;
            BigDecimal lockAmount = sourceEntity.getBigDecimal("entrylockamount");
            BigDecimal unlockAmount = sourceEntity.getBigDecimal("entryunlockamount");
            sourceEntity.set("entrylockamount", (Object)lockAmount.subtract(payAmount));
            sourceEntity.set("entryunlockamount", (Object)unlockAmount.add(payAmount));
        }
    }

    protected DynamicObject setApplyPayAddAmount(BillWriteBackParam param, DynamicObject sourceBill) {
        BillWriteBackParam.BillInfo payBill = param.getBill();
        DynamicObjectCollection targetBillEntry = payBill.getTargetBill().getDynamicObjectCollection("entry");
        DynamicObject contract = null;
        BigDecimal payAmount = payBill.getAmount();
        Map<Long, BigDecimal> map = targetBillEntry.stream().collect(Collectors.toMap(obj -> obj.getLong("e_sourcebillentryid"), obj -> obj.getBigDecimal("e_payableamt")));
        DynamicObjectCollection sourceEntities = sourceBill.getDynamicObjectCollection("entryentity");
        BigDecimal allPayAmount = BigDecimal.ZERO;
        for (DynamicObject sourceEntity : sourceEntities) {
            if (map.containsKey(sourceEntity.getLong("id"))) {
                BigDecimal unPayAmount = sourceEntity.getBigDecimal("entryunpayamount");
                BigDecimal hasPayAmount = sourceEntity.getBigDecimal("entrypaidamount");
                sourceEntity.set("entryunpayamount", (Object)unPayAmount.subtract(payAmount));
                hasPayAmount = hasPayAmount.add(payAmount);
                sourceEntity.set("entrypaidamount", (Object)hasPayAmount);
                BigDecimal contractTaxRate = sourceEntity.getBigDecimal("conttaxrate");
                DynamicObject contCurrency = sourceEntity.getDynamicObject("contcurrency");
                sourceEntity.set("entrypaidexcltaxamount", (Object)hasPayAmount.divide(BigDecimal.ONE.add(contractTaxRate.divide(BigDecimal.valueOf(100L))), CurrencyHelper.getAmountAccuracy((DynamicObject)contCurrency), 4));
                BigDecimal payAbleAmount = sourceEntity.getBigDecimal("thispayableamount");
                if (payAbleAmount.compareTo(hasPayAmount) <= 0) {
                    sourceEntity.set("payoff", (Object)Boolean.TRUE);
                }
                contract = this.updateContractEntity(sourceEntity, true, payAmount);
            }
            allPayAmount = allPayAmount.add(sourceEntity.getBigDecimal("entrypaidamount"));
        }
        sourceBill.set("allpaidamount", (Object)allPayAmount);
        boolean isBillPayOff = sourceEntities.stream().allMatch(obj -> obj.getBoolean("payoff"));
        sourceBill.set("billpayoff", (Object)isBillPayOff);
        return contract;
    }

    protected DynamicObject updateContractEntity(DynamicObject sourceEntity, boolean isAdd, BigDecimal payAmount) {
        DynamicObject contract = sourceEntity.getDynamicObject("entrycontract");
        if (contract != null) {
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            DynamicObject contCurrency = sourceEntity.getDynamicObject("contcurrency");
            BigDecimal contractTaxRate = sourceEntity.getBigDecimal("conttaxrate");
            BigDecimal payNoTaxAmount = payAmount.divide(BigDecimal.ONE.add(contractTaxRate.divide(BigDecimal.valueOf(100L))), CurrencyHelper.getAmountAccuracy((DynamicObject)contCurrency), 4);
            if (isAdd) {
                contract.set("totalrealoftaxamount", (Object)contract.getBigDecimal("totalrealoftaxamount").add(payAmount));
                contract.set("totalrealamount", (Object)contract.getBigDecimal("totalrealamount").add(payNoTaxAmount));
            } else {
                contract.set("totalrealoftaxamount", (Object)contract.getBigDecimal("totalrealoftaxamount").subtract(payAmount));
                contract.set("totalrealamount", (Object)contract.getBigDecimal("totalrealamount").subtract(payNoTaxAmount));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u4e3a\u7a7a\uff0c\u53cd\u5199\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53cd\u5199\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u7684\u5408\u540c\u6570\u636e\u3002", (String)"PaymentApplyBillWriteBackService_2", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        }
        return contract;
    }

    protected DynamicObject setApplyPaySubtractAmount(BillWriteBackParam param, DynamicObject sourceBill) {
        BillWriteBackParam.BillInfo payBill = param.getBill();
        DynamicObjectCollection targetBillEntry = payBill.getTargetBill().getDynamicObjectCollection("entry");
        BigDecimal payAmount = payBill.getAmount();
        DynamicObject contract = null;
        Set map = targetBillEntry.stream().map(obj -> obj.getLong("e_sourcebillentryid")).collect(Collectors.toSet());
        DynamicObjectCollection sourceEntities = sourceBill.getDynamicObjectCollection("entryentity");
        BigDecimal allPayAmount = BigDecimal.ZERO;
        for (DynamicObject sourceEntity : sourceEntities) {
            if (map.contains(sourceEntity.getLong("id"))) {
                BigDecimal unPayAmount = sourceEntity.getBigDecimal("entryunpayamount");
                BigDecimal hasPayAmount = sourceEntity.getBigDecimal("entrypaidamount");
                sourceEntity.set("entryunpayamount", (Object)unPayAmount.add(payAmount));
                hasPayAmount = hasPayAmount.subtract(payAmount);
                sourceEntity.set("entrypaidamount", (Object)hasPayAmount);
                if (hasPayAmount.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal contractTaxRate = sourceEntity.getBigDecimal("conttaxrate");
                    DynamicObject contCurrency = sourceEntity.getDynamicObject("contcurrency");
                    sourceEntity.set("entrypaidexcltaxamount", (Object)hasPayAmount.divide(BigDecimal.ONE.add(contractTaxRate.divide(BigDecimal.valueOf(100L))), CurrencyHelper.getAmountAccuracy((DynamicObject)contCurrency), 4));
                } else {
                    sourceEntity.set("entrypaidexcltaxamount", (Object)BigDecimal.ZERO);
                }
                BigDecimal payAbleAmount = sourceEntity.getBigDecimal("thispayableamount");
                if (payAbleAmount.compareTo(hasPayAmount) > 0) {
                    sourceEntity.set("payoff", (Object)Boolean.FALSE);
                    sourceBill.set("billpayoff", (Object)Boolean.FALSE);
                }
                contract = this.updateContractEntity(sourceEntity, false, payAmount);
            }
            allPayAmount = allPayAmount.add(sourceEntity.getBigDecimal("entrypaidamount"));
        }
        sourceBill.set("allpaidamount", (Object)allPayAmount);
        return contract;
    }

    protected void amountValidate(BillWriteBackParam param, DynamicObject sourceBill) {
        BillWriteBackParam.BillInfo payBill = param.getBill();
        DynamicObjectCollection targetBillEntry = payBill.getTargetBill().getDynamicObjectCollection("entry");
        Map<Long, BigDecimal> map = targetBillEntry.stream().collect(Collectors.toMap(obj -> obj.getLong("e_sourcebillentryid"), obj -> obj.getBigDecimal("e_payableamt")));
        DynamicObjectCollection sourceEntities = sourceBill.getDynamicObjectCollection("entryentity");
        StringBuilder stringBuilder = new StringBuilder();
        boolean isError = false;
        String opKey = param.getOperate();
        for (DynamicObject sourceEntity : sourceEntities) {
            if (!map.containsKey(sourceEntity.getLong("id"))) continue;
            BigDecimal hasPayAmount = sourceEntity.getBigDecimal("entrypaidamount");
            BigDecimal unPayAmount = sourceEntity.getBigDecimal("entryunpayamount");
            BigDecimal payAbleAmount = sourceEntity.getBigDecimal("thispayableamount");
            BigDecimal lockAmount = sourceEntity.getBigDecimal("entrylockamount");
            BigDecimal unlockAmount = sourceEntity.getBigDecimal("entryunlockamount");
            if (opKey.equals("save") || opKey.equals("unaudit") || opKey.equals("unsubmit") || opKey.equals("submit")) {
                isError = this.saveAmountValidate(hasPayAmount, unPayAmount, payAbleAmount, lockAmount, unlockAmount, stringBuilder);
                continue;
            }
            if (opKey.equals(BillWriteBackOperateEnum.PAY.getValue())) {
                isError = this.payAmountValidate(hasPayAmount, unPayAmount, payAbleAmount, lockAmount, unlockAmount, stringBuilder);
                continue;
            }
            if (opKey.equals(BillWriteBackOperateEnum.CANCELPAY.getValue())) {
                isError = this.cancelPayAmountValidate(hasPayAmount, unPayAmount, payAbleAmount, lockAmount, unlockAmount, stringBuilder);
                continue;
            }
            if (!opKey.equals(BillWriteBackOperateEnum.DELETE.getValue()) && !opKey.equals(BillWriteBackOperateEnum.CHARGEBACK.getValue())) continue;
            isError = this.delAndChargeBackAmountValidate(hasPayAmount, unPayAmount, payAbleAmount, lockAmount, unlockAmount, stringBuilder);
        }
        if (isError) {
            throw new KDBizException(stringBuilder.toString());
        }
    }

    protected boolean saveAmountValidate(BigDecimal hasPayAmount, BigDecimal unPayAmount, BigDecimal needPayAmount, BigDecimal lockAmount, BigDecimal unlockAmount, StringBuilder stringBuilder) {
        boolean isError = false;
        if (hasPayAmount.compareTo(needPayAmount) != 0 && unPayAmount.compareTo(BigDecimal.ZERO) != 0) {
            if (needPayAmount.compareTo(BigDecimal.ZERO) >= 0 && (lockAmount.compareTo(needPayAmount) > 0 || unlockAmount.compareTo(BigDecimal.ZERO) < 0 || hasPayAmount.compareTo(needPayAmount) > 0 || unPayAmount.compareTo(BigDecimal.ZERO) < 0)) {
                isError = true;
                stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u3002", (String)"PaymentApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
            } else if (needPayAmount.compareTo(BigDecimal.ZERO) < 0 && (lockAmount.compareTo(needPayAmount) < 0 || unlockAmount.compareTo(BigDecimal.ZERO) > 0 || hasPayAmount.compareTo(needPayAmount) < 0 || unPayAmount.compareTo(BigDecimal.ZERO) > 0)) {
                isError = true;
                stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u3002", (String)"PaymentApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
            }
        }
        return isError;
    }

    protected boolean payAmountValidate(BigDecimal hasPayAmount, BigDecimal unPayAmount, BigDecimal needPayAmount, BigDecimal lockAmount, BigDecimal unlockAmount, StringBuilder stringBuilder) {
        boolean isError = false;
        if (needPayAmount.compareTo(BigDecimal.ZERO) >= 0 && (hasPayAmount.compareTo(needPayAmount) > 0 || unPayAmount.compareTo(BigDecimal.ZERO) < 0 || lockAmount.compareTo(BigDecimal.ZERO) < 0)) {
            isError = true;
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u3002", (String)"PaymentApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        } else if (needPayAmount.compareTo(BigDecimal.ZERO) < 0 && (hasPayAmount.compareTo(needPayAmount) < 0 || unPayAmount.compareTo(BigDecimal.ZERO) > 0 || lockAmount.compareTo(BigDecimal.ZERO) > 0)) {
            isError = true;
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u3002", (String)"PaymentApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        }
        return isError;
    }

    protected boolean cancelPayAmountValidate(BigDecimal hasPayAmount, BigDecimal unPayAmount, BigDecimal needPayAmount, BigDecimal lockAmount, BigDecimal unlockAmount, StringBuilder stringBuilder) {
        boolean isError = false;
        if (needPayAmount.compareTo(BigDecimal.ZERO) >= 0 && (unPayAmount.compareTo(needPayAmount) > 0 || hasPayAmount.compareTo(BigDecimal.ZERO) < 0 || lockAmount.compareTo(needPayAmount) > 0)) {
            isError = true;
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u3002", (String)"PaymentApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        } else if (needPayAmount.compareTo(BigDecimal.ZERO) < 0 && (unPayAmount.compareTo(needPayAmount) < 0 || hasPayAmount.compareTo(BigDecimal.ZERO) > 0 || lockAmount.compareTo(needPayAmount) < 0)) {
            isError = true;
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u3002", (String)"PaymentApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        }
        return isError;
    }

    protected boolean delAndChargeBackAmountValidate(BigDecimal hasPayAmount, BigDecimal unPayAmount, BigDecimal needPayAmount, BigDecimal lockAmount, BigDecimal unlockAmount, StringBuilder stringBuilder) {
        boolean isError = false;
        if (needPayAmount.compareTo(BigDecimal.ZERO) >= 0 && (lockAmount.compareTo(BigDecimal.ZERO) < 0 || unlockAmount.compareTo(needPayAmount) > 0)) {
            isError = true;
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u3002", (String)"PaymentApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        } else if (needPayAmount.compareTo(BigDecimal.ZERO) < 0 && (hasPayAmount.compareTo(BigDecimal.ZERO) > 0 || unPayAmount.compareTo(needPayAmount) < 0)) {
            isError = true;
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u3002", (String)"PaymentApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        }
        return isError;
    }

    protected void reFundAndReNoteAmountValidate(RefundRenoteOrCancelParam param, List<DynamicObject> sourceBillList) {
        List<RefundPayBillInfo> refundPayBillInfoList = param.getRefundPayInfos();
        for (RefundPayBillInfo refundPayBillInfo : refundPayBillInfoList) {
            List<RefundEntryInfo> refundEntryInfoList = refundPayBillInfo.getEntryInfos();
            HashMap<Long, BigDecimal> refundAmountMap = new HashMap<Long, BigDecimal>(10);
            for (RefundEntryInfo refundEntryInfo : refundEntryInfoList) {
                List<SourceBillInfo> sourceBillInfos = refundEntryInfo.getSourceInfos();
                long sourceEntryId = 0L;
                for (SourceBillInfo sourceBillInfo : sourceBillInfos) {
                    if (!"pmct_paymentapply".equals(sourceBillInfo.getSourceEntity())) continue;
                    sourceEntryId = (Long)sourceBillInfo.getSourceEntryPks().stream().findFirst().get();
                }
                refundAmountMap.put(sourceEntryId, refundEntryInfo.getRefundAmt());
            }
            for (DynamicObject source : sourceBillList) {
                DynamicObjectCollection sourceEntities = source.getDynamicObjectCollection("entryentity");
                for (DynamicObject sourceEntity : sourceEntities) {
                    if (!refundAmountMap.containsKey(sourceEntity.getPkValue())) continue;
                    BigDecimal hasPayAmount = sourceEntity.getBigDecimal("entrypaidamount");
                    BigDecimal unPayAmount = sourceEntity.getBigDecimal("entryunpayamount");
                    BigDecimal payAbleAmount = sourceEntity.getBigDecimal("thispayableamount");
                    BigDecimal unlockAmount = sourceEntity.getBigDecimal("entryunlockamount");
                    if (payAbleAmount.compareTo(BigDecimal.ZERO) >= 0 && (unlockAmount.compareTo(payAbleAmount) > 0 || hasPayAmount.compareTo(BigDecimal.ZERO) < 0 || unPayAmount.compareTo(payAbleAmount) > 0)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u3002", (String)"PaymentApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
                    }
                    if (payAbleAmount.compareTo(BigDecimal.ZERO) >= 0 || unlockAmount.compareTo(payAbleAmount) >= 0 && hasPayAmount.compareTo(BigDecimal.ZERO) <= 0 && unPayAmount.compareTo(payAbleAmount) >= 0) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u3002", (String)"PaymentApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
                }
            }
        }
    }

    protected void cancelReFundAndReNoteAmountValidate(RefundRenoteOrCancelParam param, List<DynamicObject> sourceBillList) {
        List<RefundPayBillInfo> refundPayBillInfoList = param.getRefundPayInfos();
        for (RefundPayBillInfo refundPayBillInfo : refundPayBillInfoList) {
            List<RefundEntryInfo> refundEntryInfoList = refundPayBillInfo.getEntryInfos();
            HashMap<Long, BigDecimal> refundAmountMap = new HashMap<Long, BigDecimal>(10);
            for (RefundEntryInfo refundEntryInfo : refundEntryInfoList) {
                List<SourceBillInfo> sourceBillInfos = refundEntryInfo.getSourceInfos();
                long sourceEntryId = 0L;
                for (SourceBillInfo sourceBillInfo : sourceBillInfos) {
                    if (!"pmct_paymentapply".equals(sourceBillInfo.getSourceEntity())) continue;
                    sourceEntryId = (Long)sourceBillInfo.getSourceEntryPks().stream().findFirst().get();
                }
                refundAmountMap.put(sourceEntryId, refundEntryInfo.getRefundAmt());
            }
            for (DynamicObject source : sourceBillList) {
                DynamicObjectCollection sourceEntities = source.getDynamicObjectCollection("entryentity");
                for (DynamicObject sourceEntity : sourceEntities) {
                    if (!refundAmountMap.containsKey(sourceEntity.getPkValue())) continue;
                    BigDecimal hasPayAmount = sourceEntity.getBigDecimal("entrypaidamount");
                    BigDecimal unPayAmount = sourceEntity.getBigDecimal("entryunpayamount");
                    BigDecimal payAbleAmount = sourceEntity.getBigDecimal("thispayableamount");
                    BigDecimal unlockAmount = sourceEntity.getBigDecimal("entryunlockamount");
                    if (payAbleAmount.compareTo(BigDecimal.ZERO) >= 0 && (unlockAmount.compareTo(BigDecimal.ZERO) < 0 || unPayAmount.compareTo(BigDecimal.ZERO) < 0 || hasPayAmount.compareTo(payAbleAmount) > 0)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u3002", (String)"PaymentApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
                    }
                    if (payAbleAmount.compareTo(BigDecimal.ZERO) >= 0 || unlockAmount.compareTo(payAbleAmount) <= 0 && unPayAmount.compareTo(BigDecimal.ZERO) <= 0 && hasPayAmount.compareTo(payAbleAmount) >= 0) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u4ed8\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u5e94\u4ed8\u542b\u7a0e\u91d1\u989d\u3002", (String)"PaymentApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
                }
            }
        }
    }

    protected List<DynamicObject> setRefundAmountToSourceBill(RefundRenoteOrCancelParam param, boolean isRefund) {
        List<RefundPayBillInfo> refundPayBillInfoList = param.getRefundPayInfos();
        HashMap<Object, DynamicObject> sourceBillMap = new HashMap<Object, DynamicObject>(10);
        for (RefundPayBillInfo refundPayBillInfo : refundPayBillInfoList) {
            if (!"cas_paybill".equals(refundPayBillInfo.getTargetBillType())) continue;
            List<RefundEntryInfo> refundEntryInfoList = refundPayBillInfo.getEntryInfos();
            Map<Object, BigDecimal> refundAmountMap = refundEntryInfoList.stream().collect(Collectors.toMap(RefundEntryInfo::getTargetEntryPk, RefundEntryInfo::getRefundAmt));
            Map<Long, DynamicObject> sourceEntityMap = this.getRefundSourceBillInfo(refundPayBillInfo);
            if (sourceEntityMap.isEmpty()) continue;
            for (RefundEntryInfo refundEntryInfo : refundEntryInfoList) {
                Long entryPKValue;
                DynamicObject sourceBill;
                List<SourceBillInfo> sourceBillInfos = refundEntryInfo.getSourceInfos();
                if (sourceBillInfos == null || sourceBillInfos.size() == 0 || (sourceBill = sourceEntityMap.get(entryPKValue = refundEntryInfo.getTargetEntryPk())) == null) continue;
                long sourceEntryId = 0L;
                for (SourceBillInfo sourceBillInfo : sourceBillInfos) {
                    if (!"pmct_paymentapply".equals(sourceBillInfo.getSourceEntity())) continue;
                    sourceEntryId = (Long)sourceBillInfo.getSourceEntryPks().stream().findFirst().get();
                }
                if (sourceBillMap.containsKey(sourceBill.getPkValue())) {
                    sourceBill = (DynamicObject)sourceBillMap.get(sourceBill.getPkValue());
                }
                if (isRefund) {
                    this.sourceEntryRefund(sourceBill, refundAmountMap.get(entryPKValue), sourceEntryId);
                } else {
                    this.sourceEntryCancelRefund(sourceBill, refundAmountMap.get(entryPKValue), sourceEntryId);
                }
                sourceBillMap.put(sourceBill.getPkValue(), sourceBill);
            }
        }
        return new ArrayList<DynamicObject>(sourceBillMap.values());
    }

    protected void sourceEntryRefund(DynamicObject sourceBill, BigDecimal refundAmount, Long sourceEntryId) {
        DynamicObjectCollection sourceEntities = sourceBill.getDynamicObjectCollection("entryentity");
        BigDecimal allPayAmount = BigDecimal.ZERO;
        for (DynamicObject sourceEntity : sourceEntities) {
            if (sourceEntryId.equals(sourceEntity.getLong("id"))) {
                BigDecimal unPayAmount = sourceEntity.getBigDecimal("entryunpayamount");
                BigDecimal hasPayAmount = sourceEntity.getBigDecimal("entrypaidamount");
                sourceEntity.set("entryunpayamount", (Object)unPayAmount.add(refundAmount.abs()));
                hasPayAmount = hasPayAmount.subtract(refundAmount.abs());
                sourceEntity.set("entrypaidamount", (Object)hasPayAmount);
                if (hasPayAmount.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal contractTaxRate = sourceEntity.getBigDecimal("conttaxrate");
                    DynamicObject contCurrency = sourceEntity.getDynamicObject("contcurrency");
                    sourceEntity.set("entrypaidexcltaxamount", (Object)hasPayAmount.divide(BigDecimal.ONE.add(contractTaxRate.divide(BigDecimal.valueOf(100L))), CurrencyHelper.getAmountAccuracy((DynamicObject)contCurrency), 4));
                } else {
                    sourceEntity.set("entrypaidexcltaxamount", (Object)BigDecimal.ZERO);
                }
                BigDecimal payAbleAmount = sourceEntity.getBigDecimal("thispayableamount");
                if (payAbleAmount.compareTo(hasPayAmount) > 0) {
                    sourceEntity.set("payoff", (Object)Boolean.FALSE);
                    sourceBill.set("billpayoff", (Object)Boolean.FALSE);
                }
            }
            allPayAmount = allPayAmount.add(sourceEntity.getBigDecimal("entrypaidamount"));
        }
        sourceBill.set("allpaidamount", (Object)allPayAmount);
    }

    protected void sourceEntryCancelRefund(DynamicObject sourceBill, BigDecimal refundAmount, Long sourceEntryId) {
        DynamicObjectCollection sourceEntities = sourceBill.getDynamicObjectCollection("entryentity");
        BigDecimal allPayAmount = BigDecimal.ZERO;
        for (DynamicObject sourceEntity : sourceEntities) {
            if (sourceEntryId.equals(sourceEntity.getLong("id"))) {
                BigDecimal unPayAmount = sourceEntity.getBigDecimal("entryunpayamount");
                BigDecimal hasPayAmount = sourceEntity.getBigDecimal("entrypaidamount");
                sourceEntity.set("entryunpayamount", (Object)unPayAmount.subtract(refundAmount.abs()));
                hasPayAmount = hasPayAmount.add(refundAmount.abs());
                sourceEntity.set("entrypaidamount", (Object)hasPayAmount);
                BigDecimal contractTaxRate = sourceEntity.getBigDecimal("conttaxrate");
                DynamicObject contCurrency = sourceEntity.getDynamicObject("contcurrency");
                sourceEntity.set("entrypaidexcltaxamount", (Object)hasPayAmount.divide(BigDecimal.ONE.add(contractTaxRate.divide(BigDecimal.valueOf(100L))), CurrencyHelper.getAmountAccuracy((DynamicObject)contCurrency), 4));
                BigDecimal payAbleAmount = sourceEntity.getBigDecimal("thispayableamount");
                if (payAbleAmount.compareTo(hasPayAmount) <= 0) {
                    sourceEntity.set("payoff", (Object)Boolean.TRUE);
                }
            }
            allPayAmount = allPayAmount.add(sourceEntity.getBigDecimal("entrypaidamount"));
        }
        sourceBill.set("allpaidamount", (Object)allPayAmount);
        boolean isBillPayOff = sourceEntities.stream().allMatch(obj -> obj.getBoolean("payoff"));
        sourceBill.set("billpayoff", (Object)isBillPayOff);
    }

    protected Map<Long, DynamicObject> getRefundSourceBillInfo(RefundPayBillInfo refundPayBillInfo) {
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(10);
        List<RefundEntryInfo> refundEntryInfoList = refundPayBillInfo.getEntryInfos();
        HashMap<Long, Long> pkIdMap = new HashMap<Long, Long>(10);
        for (RefundEntryInfo refundEntryInfo : refundEntryInfoList) {
            Long targetEntryPk = refundEntryInfo.getTargetEntryPk();
            List<SourceBillInfo> sourceBillInfos = refundEntryInfo.getSourceInfos();
            for (SourceBillInfo sourceBillInfo : sourceBillInfos) {
                if (!"pmct_paymentapply".equals(sourceBillInfo.getSourceEntity())) continue;
                pkIdMap.put(sourceBillInfo.getSourcePk(), targetEntryPk);
            }
        }
        if (!pkIdMap.isEmpty()) {
            DynamicObject[] payApplyBills;
            for (DynamicObject payApplyBill : payApplyBills = BusinessDataServiceHelper.load((Object[])pkIdMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_paymentapply"))) {
                resultMap.put((Long)pkIdMap.get(payApplyBill.getPkValue()), payApplyBill);
            }
        }
        return resultMap;
    }

    protected List<DynamicObject> batchUpdateContractEntity(RefundRenoteOrCancelParam param, List<DynamicObject> sourceBillList, boolean isAdd) {
        HashMap<Object, DynamicObject> contractMap = new HashMap<Object, DynamicObject>(10);
        HashSet contractIds = new HashSet();
        for (DynamicObject sourceBill : sourceBillList) {
            DynamicObjectCollection sourceBillEntry = sourceBill.getDynamicObjectCollection("entryentity");
            if (sourceBillEntry.size() <= 0) continue;
            contractIds.addAll(sourceBillEntry.stream().map(obj -> obj.getDynamicObject("entrycontract").getPkValue()).collect(Collectors.toSet()));
        }
        DynamicObject[] contracts = BusinessDataServiceHelper.load((Object[])contractIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
        if (contracts.length == 0) {
            return new ArrayList<DynamicObject>(10);
        }
        Map<Object, DynamicObject> contractObjMap = Arrays.stream(contracts).collect(Collectors.toMap(DataEntityBase::getPkValue, obj -> obj));
        List<RefundPayBillInfo> refundPayBillInfoList = param.getRefundPayInfos();
        for (RefundPayBillInfo refundPayBillInfo : refundPayBillInfoList) {
            List<RefundEntryInfo> refundEntryInfoList = refundPayBillInfo.getEntryInfos();
            HashMap<Long, BigDecimal> refundAmountMap = new HashMap<Long, BigDecimal>(10);
            for (RefundEntryInfo refundEntryInfo : refundEntryInfoList) {
                List<SourceBillInfo> sourceBillInfos = refundEntryInfo.getSourceInfos();
                long sourceEntryId = 0L;
                for (SourceBillInfo sourceBillInfo : sourceBillInfos) {
                    if (!"pmct_paymentapply".equals(sourceBillInfo.getSourceEntity())) continue;
                    sourceEntryId = (Long)sourceBillInfo.getSourceEntryPks().stream().findFirst().get();
                }
                refundAmountMap.put(sourceEntryId, refundEntryInfo.getRefundAmt());
            }
            for (DynamicObject source : sourceBillList) {
                DynamicObjectCollection sourceEntities = source.getDynamicObjectCollection("entryentity");
                for (DynamicObject sourceEntity : sourceEntities) {
                    if (!refundAmountMap.containsKey(sourceEntity.getPkValue())) continue;
                    DynamicObject contract = contractObjMap.get(sourceEntity.getDynamicObject("entrycontract").getPkValue());
                    if (contract != null) {
                        if (contractMap.containsKey(contract.getPkValue())) {
                            contract = (DynamicObject)contractMap.get(contract.getPkValue());
                        }
                        DynamicObject contCurrency = sourceEntity.getDynamicObject("contcurrency");
                        BigDecimal contractTaxRate = sourceEntity.getBigDecimal("conttaxrate");
                        BigDecimal payAmount = ((BigDecimal)refundAmountMap.get(sourceEntity.getPkValue())).abs();
                        BigDecimal payNoTaxAmount = payAmount.divide(BigDecimal.ONE.add(contractTaxRate.divide(BigDecimal.valueOf(100L))), CurrencyHelper.getAmountAccuracy((DynamicObject)contCurrency), 4);
                        if (isAdd) {
                            contract.set("totalrealoftaxamount", (Object)contract.getBigDecimal("totalrealoftaxamount").add(payAmount));
                            contract.set("totalrealamount", (Object)contract.getBigDecimal("totalrealamount").add(payNoTaxAmount));
                        } else {
                            contract.set("totalrealoftaxamount", (Object)contract.getBigDecimal("totalrealoftaxamount").subtract(payAmount));
                            contract.set("totalrealamount", (Object)contract.getBigDecimal("totalrealamount").subtract(payNoTaxAmount));
                        }
                        contractMap.put(contract.getPkValue(), contract);
                        continue;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u4e3a\u7a7a\uff0c\u53cd\u5199\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53cd\u5199\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u7684\u5408\u540c\u6570\u636e\u3002", (String)"PaymentApplyBillWriteBackService_2", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
                }
            }
        }
        return new ArrayList<DynamicObject>(contractMap.values());
    }

    @Override
    protected DynamicObject getSourceBill(BillWriteBackParam.BillInfo payBillInfo) {
        return BusinessDataServiceHelper.loadSingle((Object)payBillInfo.getSourceBillId(), (String)"pmct_paymentapply");
    }

    @Override
    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("currency").getLong("id");
    }

    @Override
    protected void collectItemBook(DynamicObject sourceBill) {
        ArrayList<DynamicObject> itemList = new ArrayList<DynamicObject>(10);
        DynamicObjectCollection entryEntity = sourceBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            DynamicObject payItem = entry.getDynamicObject("payitem");
            if (payItem == null) continue;
            BigDecimal paidAmount = this.getPaymentApplyPaidAmountByItemId(payItem.getLong("id"));
            payItem.set("paidamount", (Object)paidAmount);
            itemList.add(payItem);
        }
        SaveServiceHelper.save((DynamicObject[])itemList.toArray(new DynamicObject[0]));
    }

    protected Set<DynamicObject> collectItemBook(List<DynamicObject> sourceBillList) {
        HashSet<DynamicObject> itemSet = new HashSet<DynamicObject>(10);
        HashMap<Object, BigDecimal> sourceEntryAmtMap = new HashMap<Object, BigDecimal>(10);
        for (DynamicObject paymentApply : sourceBillList) {
            DynamicObjectCollection entryEntity = paymentApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                DynamicObject payItem = entry.getDynamicObject("payitem");
                if (payItem == null) continue;
                itemSet.add(payItem);
                sourceEntryAmtMap.put(entry.getPkValue(), entry.getBigDecimal("entrypaidamount"));
            }
        }
        this.setItemPaidAmountByItemId(itemSet, sourceEntryAmtMap);
        return itemSet;
    }

    private BigDecimal getPaymentApplyPaidAmountByItemId(Long itemId) {
        QFilter itemIdFilter = new QFilter("entryentity.payitem", "=", (Object)itemId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] list = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"id", (QFilter[])new QFilter[]{itemIdFilter, statusFilter});
        Object[] pkArray = Arrays.stream(list).map(dyn -> dyn.get("id")).toArray();
        DynamicObject[] paymentApplyList = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_paymentapply"));
        BigDecimal paidAmount = BigDecimal.ZERO;
        for (DynamicObject apply : paymentApplyList) {
            DynamicObjectCollection entryEntity = apply.getDynamicObjectCollection("entryentity");
            for (DynamicObject info : entryEntity) {
                DynamicObject payItem = info.getDynamicObject("payitem");
                if (payItem == null || payItem.getLong("id") != itemId.longValue()) continue;
                paidAmount = paidAmount.add(info.getBigDecimal("entrypaidamount"));
            }
        }
        return paidAmount;
    }

    private void setItemPaidAmountByItemId(Set<DynamicObject> itemSet, Map<Object, BigDecimal> sourceEntryAmtMap) {
        HashMap<Object, BigDecimal> payItemMap = new HashMap<Object, BigDecimal>(10);
        Set pkValues = itemSet.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter itemIdFilter = new QFilter("entryentity.payitem", "in", pkValues);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObjectCollection list = QueryServiceHelper.query((String)"pmct_paymentapply", (String)"id", (QFilter[])new QFilter[]{itemIdFilter, statusFilter});
        Object[] pkArray = list.stream().map(dyn -> dyn.get("id")).toArray();
        DynamicObject[] paymentApplyList = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_paymentapply"));
        for (DynamicObject apply : paymentApplyList) {
            DynamicObjectCollection entryEntity = apply.getDynamicObjectCollection("entryentity");
            for (DynamicObject info : entryEntity) {
                DynamicObject payItem = info.getDynamicObject("payitem");
                BigDecimal paidAmount = info.getBigDecimal("entrypaidamount");
                if (sourceEntryAmtMap.containsKey(info.getPkValue())) {
                    paidAmount = sourceEntryAmtMap.get(info.getPkValue());
                }
                if (payItem == null) continue;
                if (payItemMap.containsKey(payItem.getPkValue())) {
                    payItemMap.put(payItem.getPkValue(), ((BigDecimal)payItemMap.get(payItem.getPkValue())).add(paidAmount));
                    continue;
                }
                payItemMap.put(payItem.getPkValue(), paidAmount);
            }
        }
        for (DynamicObject item : itemSet) {
            if (!payItemMap.containsKey(item.getPkValue())) continue;
            item.set("paidamount", payItemMap.get(item.getPkValue()));
        }
    }
}

