/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.mservice.impl.paywriteback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.AbstractPayBillWriteBackService;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.BillWriteBackOperateEnum;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.BillWriteBackParam;

public class ReceiveApplyBillWriteBackService
extends AbstractPayBillWriteBackService {
    private static Log logger = LogFactory.getLog(ReceiveApplyBillWriteBackService.class);

    @Override
    protected void doReceiveExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        DynamicObject contract = this.updateIncomeApplyAddAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
        this.DBTxBizAndContractUpdate(sourceBill, contract);
    }

    @Override
    protected void doCancelReceiveExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        DynamicObject contract = this.updateIncomeApplySubtractAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
        this.DBTxBizAndContractUpdate(sourceBill, contract);
    }

    @Override
    protected void doReceiveValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.updateIncomeApplyAddAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
    }

    @Override
    protected void doCancelReceiveValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
        this.updateIncomeApplySubtractAmount(param, sourceBill);
        this.amountValidate(param, sourceBill);
    }

    private void amountValidate(BillWriteBackParam param, DynamicObject sourceBill) {
        BillWriteBackParam.BillInfo payBill = param.getBill();
        DynamicObjectCollection targetBillEntry = payBill.getTargetBill().getDynamicObjectCollection("entry");
        Map<Long, BigDecimal> map = targetBillEntry.stream().collect(Collectors.toMap(obj -> obj.getLong("e_sourcebillentryid"), obj -> obj.getBigDecimal("e_receivableamt")));
        DynamicObjectCollection sourceEntities = sourceBill.getDynamicObjectCollection("entryentity");
        StringBuilder stringBuilder = new StringBuilder();
        boolean isError = false;
        String opKey = param.getOperate();
        for (DynamicObject sourceEntity : sourceEntities) {
            if (!map.containsKey(sourceEntity.getLong("id"))) continue;
            BigDecimal hasReceiveAmount = sourceEntity.getBigDecimal("entryrecamount");
            BigDecimal unReceiveAmount = sourceEntity.getBigDecimal("entryunrecamount");
            BigDecimal payAbleAmount = sourceEntity.getBigDecimal("applyoftaxamount");
            BigDecimal lockAmount = sourceEntity.getBigDecimal("entrylockamount");
            BigDecimal unlockAmount = sourceEntity.getBigDecimal("entryunlockamount");
            if (opKey.equals(BillWriteBackOperateEnum.RECEIVE.getValue())) {
                isError = this.receiveAmountValidate(hasReceiveAmount, unReceiveAmount, payAbleAmount, lockAmount, unlockAmount, stringBuilder);
                continue;
            }
            if (!opKey.equals(BillWriteBackOperateEnum.CANCELRECEIVE.getValue())) continue;
            isError = this.cancelReceiveAmountValidate(hasReceiveAmount, unReceiveAmount, payAbleAmount, lockAmount, unlockAmount, stringBuilder);
        }
        if (isError) {
            throw new KDBizException(stringBuilder.toString());
        }
    }

    protected DynamicObject updateIncomeApplyAddAmount(BillWriteBackParam param, DynamicObject sourceBill) {
        BillWriteBackParam.BillInfo payBill = param.getBill();
        DynamicObjectCollection targetBillEntry = payBill.getTargetBill().getDynamicObjectCollection("entry");
        DynamicObject contract = null;
        BigDecimal recAmount = payBill.getAmount();
        Map<Long, BigDecimal> map = targetBillEntry.stream().collect(Collectors.toMap(obj -> obj.getLong("e_sourcebillentryid"), obj -> obj.getBigDecimal("e_receivableamt")));
        DynamicObjectCollection sourceEntities = sourceBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject sourceEntity : sourceEntities) {
            if (!map.containsKey(sourceEntity.getLong("id"))) continue;
            BigDecimal unReceiveAmount = sourceEntity.getBigDecimal("entryunrecamount");
            BigDecimal hasReceiveAmount = sourceEntity.getBigDecimal("entryrecamount");
            sourceEntity.set("entryunrecamount", (Object)unReceiveAmount.subtract(recAmount));
            hasReceiveAmount = hasReceiveAmount.add(recAmount);
            sourceEntity.set("entryrecamount", (Object)hasReceiveAmount);
            BigDecimal contractTaxRate = sourceEntity.getBigDecimal("conttaxrate");
            DynamicObject contCurrency = sourceEntity.getDynamicObject("contcurrency");
            sourceEntity.set("entryrecnotaxamount", (Object)hasReceiveAmount.divide(BigDecimal.ONE.add(contractTaxRate.divide(BigDecimal.valueOf(100L))), CurrencyHelper.getAmountAccuracy((DynamicObject)contCurrency), 4));
            BigDecimal payAbleAmount = sourceEntity.getBigDecimal("applyoftaxamount");
            if (payAbleAmount.compareTo(hasReceiveAmount) <= 0) {
                sourceEntity.set("isentryallrec", (Object)true);
            }
            contract = this.updateContractEntity(sourceEntity, true, recAmount);
        }
        boolean isBillPayOff = true;
        for (DynamicObject sourceEntity : sourceEntities) {
            if (sourceEntity.getBoolean("isentryallrec")) continue;
            isBillPayOff = false;
        }
        sourceBill.set("isbillreceive", (Object)isBillPayOff);
        return contract;
    }

    protected DynamicObject updateIncomeApplySubtractAmount(BillWriteBackParam param, DynamicObject sourceBill) {
        BillWriteBackParam.BillInfo payBill = param.getBill();
        DynamicObjectCollection targetBillEntry = payBill.getTargetBill().getDynamicObjectCollection("entry");
        DynamicObject contract = null;
        BigDecimal recAmount = payBill.getAmount();
        Map<Long, BigDecimal> map = targetBillEntry.stream().collect(Collectors.toMap(obj -> obj.getLong("e_sourcebillentryid"), obj -> obj.getBigDecimal("e_receivableamt")));
        DynamicObjectCollection sourceEntities = sourceBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject sourceEntity : sourceEntities) {
            if (!map.containsKey(sourceEntity.getLong("id"))) continue;
            BigDecimal unReceiveAmount = sourceEntity.getBigDecimal("entryunrecamount");
            BigDecimal hasReceiveAmount = sourceEntity.getBigDecimal("entryrecamount");
            sourceEntity.set("entryunrecamount", (Object)unReceiveAmount.add(recAmount));
            hasReceiveAmount = hasReceiveAmount.subtract(recAmount);
            sourceEntity.set("entryrecamount", (Object)hasReceiveAmount);
            BigDecimal contractTaxRate = sourceEntity.getBigDecimal("conttaxrate");
            DynamicObject contCurrency = sourceEntity.getDynamicObject("contcurrency");
            sourceEntity.set("entryrecnotaxamount", (Object)hasReceiveAmount.divide(BigDecimal.ONE.add(contractTaxRate.divide(BigDecimal.valueOf(100L))), CurrencyHelper.getAmountAccuracy((DynamicObject)contCurrency), 4));
            BigDecimal payAbleAmount = sourceEntity.getBigDecimal("applyoftaxamount");
            if (payAbleAmount.compareTo(hasReceiveAmount) > 0) {
                sourceEntity.set("isentryallrec", (Object)false);
                sourceBill.set("isbillreceive", (Object)false);
            }
            contract = this.updateContractEntity(sourceEntity, false, recAmount);
        }
        return contract;
    }

    protected boolean receiveAmountValidate(BigDecimal hasReceiveAmount, BigDecimal unReceiveAmount, BigDecimal needReceiveAmount, BigDecimal lockAmount, BigDecimal unlockAmount, StringBuilder stringBuilder) {
        boolean isError = false;
        if (needReceiveAmount.compareTo(BigDecimal.ZERO) >= 0 && (hasReceiveAmount.compareTo(needReceiveAmount) > 0 || unReceiveAmount.compareTo(BigDecimal.ZERO) < 0 || lockAmount.compareTo(BigDecimal.ZERO) < 0)) {
            isError = true;
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u8bf7\u6b3e\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u6536\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u8bf7\u6b3e\u542b\u7a0e\u91d1\u989d\u3002", (String)"ReceiveApplyBillWriteBackService_4", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        } else if (needReceiveAmount.compareTo(BigDecimal.ZERO) < 0 && (hasReceiveAmount.compareTo(needReceiveAmount) < 0 || unReceiveAmount.compareTo(BigDecimal.ZERO) > 0 || lockAmount.compareTo(BigDecimal.ZERO) > 0)) {
            isError = true;
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u8bf7\u6b3e\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u6536\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u8bf7\u6b3e\u542b\u7a0e\u91d1\u989d\u3002", (String)"ReceiveApplyBillWriteBackService_4", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        }
        return isError;
    }

    protected boolean cancelReceiveAmountValidate(BigDecimal hasReceiveAmount, BigDecimal unReceiveAmount, BigDecimal needReceiveAmount, BigDecimal lockAmount, BigDecimal unlockAmount, StringBuilder stringBuilder) {
        boolean isError = false;
        if (needReceiveAmount.compareTo(BigDecimal.ZERO) >= 0 && (unReceiveAmount.compareTo(needReceiveAmount) > 0 || hasReceiveAmount.compareTo(BigDecimal.ZERO) < 0 || lockAmount.compareTo(needReceiveAmount) > 0)) {
            isError = true;
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u8bf7\u6b3e\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u6536\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u8bf7\u6b3e\u542b\u7a0e\u91d1\u989d\u3002", (String)"ReceiveApplyBillWriteBackService_4", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        } else if (needReceiveAmount.compareTo(BigDecimal.ZERO) < 0 && (unReceiveAmount.compareTo(needReceiveAmount) < 0 || hasReceiveAmount.compareTo(BigDecimal.ZERO) > 0 || lockAmount.compareTo(needReceiveAmount) < 0)) {
            isError = true;
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0a\u6e38\u8bf7\u6b3e\u5355\u7684\u5df2\u9501\u5b9a\u542b\u7a0e\u91d1\u989d/\u5df2\u5b9e\u6536\u542b\u7a0e\u91d1\u989d\u5c06\u8d85\u51fa\u672c\u6b21\u8bf7\u6b3e\u542b\u7a0e\u91d1\u989d\u3002", (String)"ReceiveApplyBillWriteBackService_4", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        }
        return isError;
    }

    protected DynamicObject updateContractEntity(DynamicObject sourceEntity, boolean isAdd, BigDecimal payAmount) {
        DynamicObject contract = sourceEntity.getDynamicObject("entrycontract");
        if (contract != null) {
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
            DynamicObject contCurrency = sourceEntity.getDynamicObject("contcurrency");
            BigDecimal contractTaxRate = sourceEntity.getBigDecimal("conttaxrate");
            BigDecimal payNoTaxAmount = payAmount.divide(BigDecimal.ONE.add(contractTaxRate.divide(BigDecimal.valueOf(100L))), CurrencyHelper.getAmountAccuracy((DynamicObject)contCurrency), 4);
            if (isAdd) {
                contract.set("totalrealoftaxamount", (Object)contract.getBigDecimal("totalrealoftaxamount").add(payAmount));
                contract.set("totalrealamount", (Object)contract.getBigDecimal("totalrealamount").add(payNoTaxAmount));
            } else {
                contract.set("totalrealoftaxamount", (Object)contract.getBigDecimal("totalrealoftaxamount").subtract(payAmount));
                contract.set("totalrealamount", (Object)contract.getBigDecimal("totalrealamount").subtract(payNoTaxAmount));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u4e3a\u7a7a\uff0c\u53cd\u5199\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53cd\u5199\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u7684\u5408\u540c\u6570\u636e\u3002", (String)"ReceiveApplyBillWriteBackService_3", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        }
        return contract;
    }

    @Override
    protected DynamicObject getSourceBill(BillWriteBackParam.BillInfo payBillInfo) {
        return BusinessDataServiceHelper.loadSingle((Object)payBillInfo.getSourceBillId(), (String)"pmct_incomeapply");
    }

    @Override
    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("currency").getLong("id");
    }

    @Override
    protected void collectItemBook(DynamicObject sourceBill) {
        ArrayList<DynamicObject> itemList = new ArrayList<DynamicObject>();
        Object pkValue = sourceBill.getPkValue();
        DynamicObject incomeApply = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmct_incomeapply");
        DynamicObjectCollection entryEntity = incomeApply.getDynamicObjectCollection("entryentity");
        for (DynamicObject contractInfo : entryEntity) {
            DynamicObject incomeItem = contractInfo.getDynamicObject("incomeitem");
            if (incomeItem == null) continue;
            BigDecimal recAmount = this.getIncomeApplyPaidAmountByItemId(incomeItem.getLong("id"));
            incomeItem.set("paidamount", (Object)recAmount);
            itemList.add(incomeItem);
        }
        SaveServiceHelper.save((DynamicObject[])itemList.toArray(new DynamicObject[0]));
    }

    private BigDecimal getIncomeApplyPaidAmountByItemId(Long itemId) {
        QFilter itemIdFilter = new QFilter("entryentity.incomeitem", "=", (Object)itemId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] list = BusinessDataServiceHelper.load((String)"pmct_incomeapply", (String)"id", (QFilter[])new QFilter[]{itemIdFilter, statusFilter});
        Object[] pkArray = Arrays.stream(list).map(dyn -> dyn.get("id")).toArray();
        DynamicObject[] paymentApplyList = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incomeapply"));
        BigDecimal recAmount = BigDecimal.ZERO;
        for (DynamicObject apply : paymentApplyList) {
            DynamicObjectCollection entryEntity = apply.getDynamicObjectCollection("entryentity");
            for (DynamicObject info : entryEntity) {
                DynamicObject incomeItem = info.getDynamicObject("incomeitem");
                if (incomeItem == null || incomeItem.getLong("id") != itemId.longValue()) continue;
                recAmount = recAmount.add(info.getBigDecimal("entryrecamount"));
            }
        }
        return recAmount;
    }
}

