/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.mservice.impl.paywriteback.base;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.mservice.impl.caswriteback.BussinessBillWriteBackService;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.BillWriteBackOperateEnum;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.BillWriteBackParam;
import kd.pmgt.pmbs.mservice.impl.paywriteback.base.RefundRenoteOrCancelParam;

public abstract class AbstractPayBillWriteBackService
implements BussinessBillWriteBackService {
    private static final Log logger = LogFactory.getLog(AbstractPayBillWriteBackService.class);

    public void execute(Object params) {
        if (params instanceof List) {
            this.doExecute((List)params);
        } else if (params instanceof HashMap) {
            this.doReFundOpEvents((HashMap)params);
        }
    }

    protected void doExecute(List<Map<String, Object>> params) {
        logger.info("paybillwriteback start,params:{}", (Object)SerializationUtils.toJsonString(params));
        if (params == null || params.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u4e0a\u6e38\u5355\u636e\u5931\u8d25\uff0c\u83b7\u53d6\u4f20\u5165\u53c2\u6570\u5931\u8d25\u3002", (String)"AbstractPayBillWriteBackService_2", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        }
        Map<String, Object> dataMap = params.get(0);
        String operate = (String)(dataMap.get("operate") != null ? dataMap.get("operate") : dataMap.get("operation"));
        BillWriteBackParam writeBackParam = new BillWriteBackParam();
        writeBackParam.setOperate(operate);
        BillWriteBackParam.BillInfo billInfo = new BillWriteBackParam.BillInfo();
        DynamicObject info = (DynamicObject)dataMap.get("info");
        Long targetPk = (Long)dataMap.get("targetpk");
        if (info == null && (targetPk == null || targetPk == 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u4e0a\u6e38\u5355\u636e\u5931\u8d25\uff0c\u83b7\u53d6\u4e0a\u6e38\u5355\u636e\u6570\u636e\u5931\u8d25\u3002", (String)"AbstractPayBillWriteBackService_1", (String)"pmgt-pmbs-mservice", (Object[])new Object[0]));
        }
        if (info == null) {
            String targetEntity = (String)(dataMap.get("targetentity") != null ? dataMap.get("targetentity") : dataMap.get("targetbilltype"));
            info = BusinessDataServiceHelper.loadSingle((Object)targetPk, (String)targetEntity);
        }
        if (info != null) {
            billInfo.setBillId(info.getLong("id")).setBillNo(info.getString("billno")).setSourceBillId(info.getLong("sourcebillid")).setSourceBillType(info.getString("sourcebilltype")).setSourceBillNumber(info.getString("sourcebillnumber")).setBizDate(info.getDate("bizdate")).setCurrencypk(info.getDynamicObject("currency").getLong("id")).setTargetBill(info);
            if (billInfo.getSourceBillType().equals("pmct_incomeapply")) {
                billInfo.setAmount(info.getBigDecimal("actrecamt"));
            } else if (billInfo.getSourceBillType().equals("pmct_paymentapply")) {
                billInfo.setAmount(info.getBigDecimal("actpayamt"));
            }
            writeBackParam.setBill(billInfo);
            this.doExecute(writeBackParam);
        }
    }

    protected void doExecute(BillWriteBackParam param) {
        DynamicObject sourceBill = this.getSourceBill(param.getBill());
        BillWriteBackOperateEnum operateEnum = BillWriteBackOperateEnum.getByValue(param.getOperate());
        if (operateEnum == null) {
            this.doOtherExecute(param, sourceBill);
        } else {
            switch (operateEnum) {
                case SAVE: {
                    this.doSaveExecute(param, sourceBill);
                    break;
                }
                case SUBMIT: {
                    this.doSubmitExecute(param, sourceBill);
                    break;
                }
                case UNSUBMIT: {
                    this.doUnSubmitExecute(param, sourceBill);
                    break;
                }
                case AUDIT: {
                    this.doAuditExecute(param, sourceBill);
                    break;
                }
                case UNAUDIT: {
                    this.doUnAuditExecute(param, sourceBill);
                    break;
                }
                case PAY: {
                    this.doPayExecute(param, sourceBill);
                    break;
                }
                case CANCELPAY: {
                    this.doCancelPayExecute(param, sourceBill);
                    break;
                }
                case CHARGEBACK: {
                    this.doChargebackExecute(param, sourceBill);
                    break;
                }
                case DELETE: {
                    this.doDeleteExecute(param, sourceBill);
                    break;
                }
                case RECEIVE: {
                    this.doReceiveExecute(param, sourceBill);
                    break;
                }
                case CANCELRECEIVE: {
                    this.doCancelReceiveExecute(param, sourceBill);
                    break;
                }
                case SAVEVALIDATE: 
                case SUBMITVALIDATE: {
                    this.doSaveAndSubmitValidateExecute(param, sourceBill);
                    break;
                }
                case PAYVALIDATE: {
                    this.doPayValidateExecute(param, sourceBill);
                    break;
                }
                case CANCELPAYVALIDATE: {
                    this.doCancelPayValidateExecute(param, sourceBill);
                    break;
                }
                case RECEIVEVALIDATE: {
                    this.doReceiveValidateExecute(param, sourceBill);
                    break;
                }
                case CANCELRECEIVEVALIDATE: {
                    this.doCancelReceiveValidateExecute(param, sourceBill);
                    break;
                }
                default: {
                    this.doOtherExecute(param, sourceBill);
                }
            }
        }
    }

    private boolean isRefundOp(String operate) {
        return operate.equalsIgnoreCase(BillWriteBackOperateEnum.REFUND.getValue()) || operate.equalsIgnoreCase(BillWriteBackOperateEnum.RENOTE.getValue()) || operate.equalsIgnoreCase(BillWriteBackOperateEnum.CANCELREFUND.getValue()) || operate.equalsIgnoreCase(BillWriteBackOperateEnum.CANCELRENOTE.getValue()) || operate.equalsIgnoreCase(BillWriteBackOperateEnum.REFUNDVALIDATE.getValue()) || operate.equalsIgnoreCase(BillWriteBackOperateEnum.RENOTEVALIDATE.getValue()) || operate.equalsIgnoreCase(BillWriteBackOperateEnum.CANCELREFUNDVALIDATE.getValue()) || operate.equalsIgnoreCase(BillWriteBackOperateEnum.CANCELRENOTEVALIDATE.getValue());
    }

    private void doReFundOpEvents(HashMap<String, Object> params) {
        logger.info("refund paybillwriteback start,params:{}", (Object)SerializationUtils.toJsonString(params));
        String jsonStr = JSON.toJSONString(params);
        RefundRenoteOrCancelParam param = (RefundRenoteOrCancelParam)JSON.parseObject((String)jsonStr, RefundRenoteOrCancelParam.class);
        String operate = (String)params.get("operate");
        if (this.isRefundOp(operate)) {
            BillWriteBackOperateEnum operateEnum = BillWriteBackOperateEnum.getByValue(operate);
            if (operateEnum == null) {
                return;
            }
            switch (operateEnum) {
                case REFUND: {
                    this.doRefundExecute(param);
                    break;
                }
                case RENOTE: {
                    this.doRenoteExecute(param);
                    break;
                }
                case CANCELREFUND: {
                    this.doCancelRefundExecute(param);
                    break;
                }
                case CANCELRENOTE: {
                    this.doCancelRenoteExecute(param);
                    break;
                }
                case REFUNDVALIDATE: 
                case RENOTEVALIDATE: {
                    this.doRefundAndReNoteValidateExecute(param);
                    break;
                }
                case CANCELREFUNDVALIDATE: 
                case CANCELRENOTEVALIDATE: {
                    this.doCancelRefundAndReNoteValidateExecute(param);
                    break;
                }
            }
        }
    }

    protected void doSaveExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doSubmitExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doUnSubmitExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doAuditExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doUnAuditExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doPayExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doChargebackExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doCancelPayExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doRefundExecute(RefundRenoteOrCancelParam param) {
    }

    protected void doRenoteExecute(RefundRenoteOrCancelParam param) {
    }

    protected void doCancelRefundExecute(RefundRenoteOrCancelParam param) {
    }

    protected void doCancelRenoteExecute(RefundRenoteOrCancelParam param) {
    }

    protected void doDeleteExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doOtherExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doSaveValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doSubmitValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doAuditValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doSaveAndSubmitValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doPayValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doCancelPayValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doRefundAndReNoteValidateExecute(RefundRenoteOrCancelParam param) {
    }

    protected void doCancelRefundAndReNoteValidateExecute(RefundRenoteOrCancelParam param) {
    }

    protected void doReceiveExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doCancelReceiveExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doReceiveValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doCancelReceiveValidateExecute(BillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected abstract void collectItemBook(DynamicObject var1);

    protected abstract DynamicObject getSourceBill(BillWriteBackParam.BillInfo var1);

    protected abstract Long getSourceBillCurrencyId(DynamicObject var1);

    protected String getSourceBillNo(DynamicObject sourceBill) {
        return sourceBill.getString("billno");
    }

    protected void DBTxBizUpdate(DynamicObject sourceBill) {
        Exception var3 = null;
        try (TXHandle handle = TX.requiresNew();){
            SaveServiceHelper.update((DynamicObject)sourceBill);
        }
        catch (Exception var14) {
            var3 = var14;
            throw var14;
        }
    }

    protected void DBTxBizAndContractUpdate(DynamicObject sourceBill, DynamicObject contract) {
        Exception var3 = null;
        try (TXHandle handle = TX.requiresNew();){
            SaveServiceHelper.update((DynamicObject)sourceBill);
            SaveServiceHelper.update((DynamicObject)contract);
            this.collectItemBook(sourceBill);
        }
        catch (Exception var14) {
            var3 = var14;
            throw var14;
        }
    }

    protected void DBTxBizAndContractBatchUpdate(DynamicObject[] sourceBill, DynamicObject[] contract, DynamicObject[] payItem) {
        Exception var3 = null;
        try (TXHandle handle = TX.requiresNew();){
            SaveServiceHelper.update((DynamicObject[])sourceBill);
            SaveServiceHelper.update((DynamicObject[])contract);
            SaveServiceHelper.update((DynamicObject[])payItem);
        }
        catch (Exception var14) {
            var3 = var14;
            throw var14;
        }
    }
}

