/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.report.budget;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.budget.BudgetParam;
import kd.pmgt.pmbs.common.budget.BudgetRegModel;
import kd.pmgt.pmbs.common.budget.BudgetRegValue;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.mservice.impl.budget.ProjectBudgetServiceImpl;
import kd.pmgt.pmbs.report.AbstractPmbsReportFormPlugin;

public class ProjectBudgetViewReportFormPlugin
extends AbstractPmbsReportFormPlugin {
    private static final String[] MERGE_COLUMN = new String[]{"budgetamt", "sumbudamt", "occupyamt", "occupybalance", "usageamt", "usagebalance", "yeartotalusagebalance"};
    private static final String CONDITION_COLUMN = "budget";

    public void beforeQuery(ReportQueryParam queryParam) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)formShowParameter.getCustomParam("entityNumber");
        String dataEntity = (String)formShowParameter.getCustomParam("dataEntity");
        DynamicObject project = null;
        DynamicObject selectProject = null;
        BudgetSourceTypeEnum budgetSourceType = null;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (StringUtils.isNotBlank((CharSequence)entityNumber) && StringUtils.isNotBlank((CharSequence)dataEntity)) {
            ProjectBudgetServiceImpl budgetUpdateServiceImpl = new ProjectBudgetServiceImpl();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DynamicObject bill = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)dataEntity, (DynamicObjectType)dt)[0];
            BudgetParam budgetParam = budgetUpdateServiceImpl.initBudgetParam(bill, "queryProjectBudget");
            if (budgetParam == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u672a\u8fdb\u884c\u9884\u7b97\u6ce8\u518c\u914d\u7f6e\uff0c\u65e0\u6cd5\u8fdb\u884c\u9884\u7b97\u67e5\u770b\u3002\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e\u3002", (String)"ProjectBudgetViewReportFormPlugin_0", (String)"pmgt-pmbs-report", (Object[])new Object[0]));
            }
            List budgetRegModels = budgetParam.getBudgetRegModels();
            if (budgetRegModels.size() > 0) {
                Optional<BudgetRegModel> BudgetRegModePro = budgetRegModels.stream().filter(o -> StringUtils.equals((CharSequence)"PROJECT", (CharSequence)o.getFieldType().getNumber())).findFirst();
                if (!BudgetRegModePro.isPresent()) {
                    return;
                }
                String fieldRegKey = BudgetRegModePro.get().getFieldRegKey();
                if (StringUtils.isNotEmpty((CharSequence)fieldRegKey)) {
                    IFormView parentView = this.getView().getParentView();
                    String[] splits = fieldRegKey.split("\\.");
                    HashSet<Long> projectIds = new HashSet<Long>();
                    if (splits.length == 2) {
                        String entriesType = splits[0];
                        EntryGrid entryGrid = (EntryGrid)parentView.getControl(entriesType);
                        int[] selectRows = entryGrid.getSelectRows();
                        if (selectRows.length == 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u542b\u6709\u9879\u76ee\u4fe1\u606f\u7684\u5177\u4f53\u5206\u5f55\u884c\u3002", (String)"ProjectBudgetViewReportFormPlugin_1", (String)"pmgt-pmbs-report", (Object[])new Object[0]));
                        }
                        int[] nArray = selectRows;
                        int n = nArray.length;
                        for (int i = 0; i < n; ++i) {
                            int selectRow = nArray[i];
                            DynamicObject rowEntity = parentView.getModel().getEntryRowEntity(entriesType, selectRow);
                            selectProject = rowEntity.getDynamicObject(splits[1]);
                            if (selectProject != null) {
                                projectIds.add(Long.parseLong(selectProject.getPkValue().toString()));
                            }
                            if (projectIds.size() <= 1) continue;
                            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5206\u5f55\u884c\u4e2d\u5305\u542b\u591a\u4e2a\u9879\u76ee\u4fe1\u606f\uff0c\u8bf7\u4fee\u6539\u4e3a\u53ea\u5305\u542b\u4e00\u4e2a\u9879\u76ee\u3002", (String)"ProjectBudgetViewReportFormPlugin_2", (String)"pmgt-pmbs-report", (Object[])new Object[0]));
                        }
                    }
                    if (splits.length == 3) {
                        EntryGrid subEntryGrid = (EntryGrid)parentView.getControl(splits[1]);
                        int[] selectSubRows = subEntryGrid.getSelectRows();
                        if (selectSubRows.length == 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u542b\u6709\u9879\u76ee\u4fe1\u606f\u7684\u5177\u4f53\u5b50\u5206\u5f55\u884c\u3002", (String)"ProjectBudgetViewReportFormPlugin_3", (String)"pmgt-pmbs-report", (Object[])new Object[0]));
                        }
                        for (int selectRow : selectSubRows) {
                            DynamicObject subRowEntity = subEntryGrid.getView().getModel().getEntryRowEntity(splits[1], selectRow);
                            if (subRowEntity == null) continue;
                            selectProject = subRowEntity.getDynamicObject(splits[2]);
                            if (selectProject != null) {
                                projectIds.add(Long.parseLong(selectProject.getPkValue().toString()));
                            }
                            if (projectIds.size() <= 1) continue;
                            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5206\u5f55\u884c\u4e2d\u5305\u542b\u591a\u4e2a\u9879\u76ee\u4fe1\u606f\uff0c\u8bf7\u4fee\u6539\u4e3a\u53ea\u5305\u542b\u4e00\u4e2a\u9879\u76ee\u3002", (String)"ProjectBudgetViewReportFormPlugin_2", (String)"pmgt-pmbs-report", (Object[])new Object[0]));
                        }
                    }
                }
            }
            List budgetRegValues = budgetParam.getBudgetRegValues();
            ArrayList<Object> budgetList = new ArrayList<Object>();
            for (BudgetRegValue item : budgetRegValues) {
                if (item.getProjectValue() == null) continue;
                DynamicObject projectObj = item.getProjectValue();
                if (selectProject != null && !StringUtils.equals((CharSequence)projectObj.getPkValue().toString(), (CharSequence)selectProject.getPkValue().toString())) continue;
                project = item.getProjectValue();
                if (item.getBudgetValue() != null) {
                    budgetList.add(item.getBudgetValue().getPkValue());
                }
                budgetSourceType = item.getBudgetTypeValue();
            }
            if (project != null) {
                this.getView().getPageCache().put("projectId", project.getPkValue().toString());
            }
            QFilter projectFilter = new QFilter("project", "=", project == null ? Long.valueOf(0L) : project.getPkValue());
            qFilterList.add(projectFilter);
            if (!budgetList.isEmpty()) {
                QFilter budgetFilter = new QFilter(CONDITION_COLUMN, "in", budgetList);
                qFilterList.add(budgetFilter);
            }
        } else {
            qFilterList.add(new QFilter("1", "!=", (Object)"1"));
        }
        queryParam.setCustomFilter(qFilterList);
        if (project != null) {
            QFilter filter = new QFilter("pro", "=", project.getPkValue());
            DynamicObject[] projectApproval = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "projectapplydate", "projcetbugamt", "proyearbudgetamt"), (QFilter[])new QFilter[]{filter});
            filter = new QFilter("tproject", "=", project.getPkValue());
            filter.and("tbudgettype", "=", (Object)budgetSourceType.getValue());
            DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (String)String.join((CharSequence)",", "tbudgetamt", "tsumbudamt"), (QFilter[])new QFilter[]{filter});
            this.getModel().setValue("projectnum", (Object)project.getString("number"));
            this.getModel().setValue("projectname", (Object)project.getLocaleString("name").getLocaleValue());
            if (projectApproval.length != 0) {
                this.getModel().setValue("proyear", (Object)projectApproval[0].getDate("projectapplydate"));
                this.getModel().setValue("proamt", (Object)projectApproval[0].getBigDecimal("projcetbugamt"));
                this.getModel().setValue("proyearbudgetamt", (Object)projectApproval[0].getBigDecimal("proyearbudgetamt"));
            }
            if (totalBudgetCtrl != null) {
                this.getModel().setValue("probudgetamt", (Object)totalBudgetCtrl.getBigDecimal("tbudgetamt"));
                this.getModel().setValue("proyeartotalbudgetamt", (Object)totalBudgetCtrl.getBigDecimal("tsumbudamt"));
            }
        }
        super.beforeQuery(queryParam);
    }

    public void setMergeColums(List<String> columns) {
        Collections.addAll(columns, MERGE_COLUMN);
        columns.add(CONDITION_COLUMN);
        super.setMergeColums(columns);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        ReportColumn c = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = c.getFieldKey();
        if (fieldKey.equals(CONDITION_COLUMN)) {
            String s = packageDataEvent.getFormatValue().toString();
            String conditionPreValue = this.getPageCache().get("srstatusa_prevalue");
            if (conditionPreValue != null && !conditionPreValue.isEmpty() && !conditionPreValue.equals(s)) {
                Collections.addAll(packageDataEvent.getNoMergeKey(), MERGE_COLUMN);
            }
            this.getPageCache().put("srstatusa_prevalue", s);
        }
        super.packageData(packageDataEvent);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        String projectId = this.getView().getPageCache().get("projectId");
        ProBudgetCtrlEnums proBudgetCtrl = ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET;
        if (StringUtils.isNotEmpty((CharSequence)projectId)) {
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bd_project");
            proBudgetCtrl = ProBudgetControlHelper.getProjectBudgetControlType((DynamicObject)project);
        }
        for (DynamicObject item : rowData) {
            BigDecimal budgetAmt = item.getBigDecimal("budgetamt");
            BigDecimal sumBudAmt = item.getBigDecimal("sumbudamt");
            BigDecimal occupyAmt = item.getBigDecimal("occupyamt");
            BigDecimal occupyBalance = budgetAmt.subtract(occupyAmt);
            if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue())) {
                occupyBalance = sumBudAmt.subtract(occupyAmt);
            }
            item.set("occupybalance", (Object)occupyBalance);
            BigDecimal usageAmt = item.getBigDecimal("usageamt");
            BigDecimal usageBalance = budgetAmt.subtract(usageAmt);
            if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue())) {
                usageBalance = sumBudAmt.subtract(usageAmt);
            }
            item.set("usagebalance", (Object)usageBalance);
            BigDecimal yearTotalUsageBalance = item.getBigDecimal("sumbudamt");
            if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue())) {
                yearTotalUsageBalance = sumBudAmt.subtract(usageAmt);
            }
            item.set("yeartotalusagebalance", (Object)yearTotalUsageBalance);
            BigDecimal yearBudgetAmt = item.getBigDecimal("yearbudgetamt");
            BigDecimal yearUsageAmt = item.getBigDecimal("yearusageamt");
            BigDecimal yearUsageBalance = yearBudgetAmt.subtract(yearUsageAmt);
            item.set("yearusagebalance", (Object)yearUsageBalance);
        }
        super.processRowData(gridPK, rowData, queryParam);
    }
}

