/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.report.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.LinkQueryPkId;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.thread.PmgtThreadPools;
import kd.pmgt.pmbs.report.AbstractPmbsReportFormPlugin;
import org.jetbrains.annotations.NotNull;

public class ProjectBookReportFormTplPlugin
extends AbstractPmbsReportFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(ProjectBookReportFormTplPlugin.class);
    public static final String PROCESS_DATA = "processData";
    public static final String COLOR_GREEN = "0";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit proApp = (BasedataEdit)this.getControl("ebillname");
        proApp.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)beforeF7ViewDetailEvent.getPkId()));
        });
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)"org", (CharSequence)fieldName)) continue;
            long orgId = RequestContext.get().getOrgId();
            commonFilterColumn.setDefaultValue(String.valueOf(orgId));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        HashMap<String, String> customParam = new HashMap<String, String>(2);
        customParam.put("appid", this.getView().getFormShowParameter().getAppId());
        customParam.put("formid", ((ReportView)this.getView()).getFormId());
        queryParam.setCustomParam(customParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        block42: {
            super.processRowData(gridPK, rowData, queryParam);
            String processData = this.getPageCache().get(PROCESS_DATA);
            if (processData == null || StringUtils.equals((CharSequence)processData, (CharSequence)"true")) {
                return;
            }
            Set proIdSet = rowData.stream().filter(dyn -> dyn.getDynamicObject("rpro") != null).map(dyn -> dyn.getDynamicObject("rpro").getPkValue()).collect(Collectors.toSet());
            Set proAppIdSet = rowData.stream().map(dyn -> dyn.get("rbillname_id")).collect(Collectors.toSet());
            if (rowData.isEmpty()) break block42;
            long startTime = System.currentTimeMillis();
            DynamicObject[] proAppObjs = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"probudgetctrl,outamount,inamount,proproposal,proproposal.proinvestbudappamt,bugproname,pro", (QFilter[])new QFilter[]{new QFilter("id", "in", proAppIdSet)});
            logger.info("----search projectApproval DynamicObject time {}---", (Object)(System.currentTimeMillis() - startTime));
            Map<Object, BigDecimal> proAppIdToProposalMap = Arrays.stream(proAppObjs).filter(obj -> obj.getDynamicObject("proproposal") != null).collect(Collectors.toMap(obj -> obj.get("id"), obj -> obj.getBigDecimal("proproposal.proinvestbudappamt")));
            Map<Object, List<DynamicObject>> proAppIdToAppObjMap = Arrays.stream(proAppObjs).collect(Collectors.groupingBy(obj -> obj.get("id")));
            CompletableFuture<Map> proToBudgetFuture = CompletableFuture.supplyAsync(() -> {
                HashMap proToBudgetMap = new HashMap();
                if (proIdSet.size() == 0) {
                    return proToBudgetMap;
                }
                FilterInfo filterInfo = queryParam.getFilter();
                List filterItemInfoList = filterInfo.getFilterItems();
                QFilter filter = null;
                for (FilterItemInfo item : filterItemInfoList) {
                    String propName = item.getPropName();
                    Object value = item.getValue();
                    if ("org.id".equals(propName) && value instanceof Long) {
                        filter = new QFilter("org", "=", value);
                        continue;
                    }
                    if (!"org.id".equals(propName) || !(value instanceof List)) continue;
                    List selectedIdList = (List)value;
                    filter = new QFilter("org", "in", (Object)selectedIdList);
                }
                if (filter == null) {
                    return proToBudgetMap;
                }
                long beforeTime = System.currentTimeMillis();
                DynamicObjectCollection budgets = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"pmas_budget", (String)"totalamount,sourcetype,project,isvalid", (QFilter[])filter.toArray(), (String)"auditdate desc");
                logger.info("----search budget DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                beforeTime = System.currentTimeMillis();
                List budgetLists = budgets.stream().filter(o -> proIdSet.contains(o.get("project")) && o.getBoolean("isvalid")).collect(Collectors.toList());
                logger.info("----for budget DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                HashMap<Object, ArrayList<DynamicObject>> proToOutBudgetMap = new HashMap<Object, ArrayList<DynamicObject>>();
                HashMap<Object, ArrayList<DynamicObject>> proToInBudgetMap = new HashMap<Object, ArrayList<DynamicObject>>();
                for (DynamicObject budget : budgetLists) {
                    Object project = budget.get("project");
                    String sourceType = budget.getString("sourcetype");
                    if (StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)sourceType)) {
                        ArrayList<DynamicObject> inBudgetList = (ArrayList<DynamicObject>)proToInBudgetMap.get(project);
                        if (inBudgetList == null) {
                            inBudgetList = new ArrayList<DynamicObject>();
                        }
                        inBudgetList.add(budget);
                        proToInBudgetMap.put(project, inBudgetList);
                        continue;
                    }
                    ArrayList<DynamicObject> outBudgetList = (ArrayList<DynamicObject>)proToOutBudgetMap.get(project);
                    if (outBudgetList == null) {
                        outBudgetList = new ArrayList<DynamicObject>();
                    }
                    outBudgetList.add(budget);
                    proToOutBudgetMap.put(project, outBudgetList);
                }
                if (!proToOutBudgetMap.isEmpty()) {
                    proToBudgetMap.put("OUT", proToOutBudgetMap);
                }
                if (!proToInBudgetMap.isEmpty()) {
                    proToBudgetMap.put("IN", proToInBudgetMap);
                }
                return proToBudgetMap;
            }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
            CompletableFuture<Map> proIdToWarnLevelFuture = CompletableFuture.supplyAsync(() -> {
                QFilter projectFilter = new QFilter("project", "in", (Object)proIdSet);
                QFilter enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
                long beforeTime = System.currentTimeMillis();
                DynamicObject[] warnMessageObjs = BusinessDataServiceHelper.load((String)"pmbs_warnmessage", (String)"project,warnlevel", (QFilter[])new QFilter[]{projectFilter, enableFilter});
                logger.info("----search WarnMessage DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                Map<Object, List<DynamicObject>> projectToWarnMap = Arrays.stream(warnMessageObjs).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("project").getPkValue()));
                HashMap projectToWarnLevelMap = new HashMap(projectToWarnMap.size());
                for (Object proId : proIdSet) {
                    List<DynamicObject> warnValueList = projectToWarnMap.get(proId);
                    if (warnValueList == null || warnValueList.isEmpty()) {
                        projectToWarnLevelMap.put(proId, COLOR_GREEN);
                        continue;
                    }
                    int maxLevel = Integer.parseInt(COLOR_GREEN);
                    for (DynamicObject warnObj : warnValueList) {
                        String warnlevel = warnObj.getString("warnlevel");
                        int curLevel = Integer.parseInt(warnlevel);
                        if (curLevel <= maxLevel) continue;
                        maxLevel = curLevel;
                    }
                    projectToWarnLevelMap.put(proId, String.valueOf(maxLevel));
                }
                return projectToWarnLevelMap;
            }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
            CompletableFuture<Map> proIdToNowTeamFuture = CompletableFuture.supplyAsync(() -> {
                long beforeTime = System.currentTimeMillis();
                DynamicObject proLeaderRoleObj = BusinessDataServiceHelper.loadSingleFromCache((Object)"117VXH+9X6P2", (String)"perm_role");
                QFilter proFilter = new QFilter("project", "in", (Object)proIdSet);
                QFilter roleFilter = new QFilter("role", "=", proLeaderRoleObj.getPkValue());
                DynamicObject[] nowTeamObjs = BusinessDataServiceHelper.load((String)"pmas_nowteam", (String)"member,telno,project", (QFilter[])new QFilter[]{proFilter, roleFilter});
                logger.info("----search NowTeam DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                return Arrays.stream(nowTeamObjs).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("project").getPkValue()));
            }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
            CompletableFuture<Map> stageStatusFuture = CompletableFuture.supplyAsync(() -> {
                long beforeTime = System.currentTimeMillis();
                QFilter proAppFilter = new QFilter("proapproval", "in", (Object)proAppIdSet);
                QFilter statusPercentFilter = new QFilter("statuspercent", ">", (Object)0);
                DynamicObject[] stageStatusObjs = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"projectstage,project,proapproval", (QFilter[])new QFilter[]{proAppFilter, statusPercentFilter}, (String)"projectstage.serial desc");
                logger.info("----search ProStatus DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                return Arrays.stream(stageStatusObjs).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("proapproval").getPkValue()));
            }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
            HashSet<String> contStatusNumSet = new HashSet<String>(3);
            contStatusNumSet.add(ContractStatusEnum.INDRAFT.getValue());
            contStatusNumSet.add(ContractStatusEnum.INAUDIT.getValue());
            contStatusNumSet.add(ContractStatusEnum.APPROVED.getValue());
            CompletableFuture<Map> contractFuture = CompletableFuture.supplyAsync(() -> {
                long beforeTime = System.currentTimeMillis();
                QFilter contractQFilter = new QFilter("project", "in", (Object)proIdSet);
                contractQFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                contractQFilter.and("contractstatus.number", "not in", (Object)contStatusNumSet);
                DynamicObject[] outContracts = BusinessDataServiceHelper.load((String)"pmct_contracttpl", (String)"paydirection,totaloftaxamount,stdcurrency,project,totalrealoftaxamount", (QFilter[])new QFilter[]{contractQFilter});
                logger.info("----search Contract DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                return Arrays.stream(outContracts).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("project").getPkValue()));
            }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
            CompletableFuture<Map> incomeApplyFuture = CompletableFuture.supplyAsync(() -> {
                long beforeTime = System.currentTimeMillis();
                QFilter entryProFilter = new QFilter("entryentity.contpro", "in", (Object)proIdSet);
                QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                DynamicObject[] incomeApplys = BusinessDataServiceHelper.load((String)"pmct_incomeapply", (String)"entryentity,applyoftaxamount,contpro,entryentity.entrycontract,entryentity.entryrecamount", (QFilter[])new QFilter[]{billStatusFilter, entryProFilter});
                logger.info("----search IncomeApply DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                return Arrays.stream(incomeApplys).map(it -> it.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).filter(entry -> entry.getDynamicObject("contpro") != null).collect(Collectors.groupingBy(entry -> entry.getDynamicObject("contpro").getPkValue()));
            }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
            CompletableFuture<Map> contractSettleFuture = CompletableFuture.supplyAsync(() -> {
                long beforeTime = System.currentTimeMillis();
                QFilter proFilter = new QFilter("project", "in", (Object)proIdSet);
                QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                DynamicObject[] settleConts = BusinessDataServiceHelper.load((String)"pmct_contract_settle_tpl", (String)"settleoftaxamount,project,contract,contract.paydirection", (QFilter[])new QFilter[]{billStatusFilter, proFilter});
                logger.info("----search ContractSettle DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                return Arrays.stream(settleConts).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("project").getPkValue()));
            }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
            CompletableFuture<Map> payApplyFuture = CompletableFuture.supplyAsync(() -> {
                long beforeTime = System.currentTimeMillis();
                QFilter entryProFilter = new QFilter("entryentity.contpro", "in", (Object)proIdSet);
                QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                DynamicObject[] payApplies = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"entryentity,entrycontract,contpro,entryentity.thispayableamount,entryentity.entrypaidamount", (QFilter[])new QFilter[]{billStatusFilter, entryProFilter});
                logger.info("----search PaymentApply DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                return Arrays.stream(payApplies).map(it -> it.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).filter(entry -> entry.getDynamicObject("contpro") != null).collect(Collectors.groupingBy(entry -> entry.getDynamicObject("contpro").getPkValue()));
            }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
            CompletableFuture<Map> singlePayApplyFuture = CompletableFuture.supplyAsync(() -> {
                long beforeTime = System.currentTimeMillis();
                QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                QFilter proFilter = new QFilter("project", "in", (Object)proIdSet);
                DynamicObject[] singlePayApplys = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"curpaytotal,project", (QFilter[])new QFilter[]{billStatusFilter, proFilter});
                logger.info("----search ApplymentPay DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                return Arrays.stream(singlePayApplys).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("project").getPkValue()));
            }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
            CompletableFuture<Map> proCostSplitFuture = CompletableFuture.supplyAsync(() -> {
                long beforeTime = System.currentTimeMillis();
                QFilter proFilter = new QFilter("project", "in", (Object)proIdSet);
                QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                QFilter enableMultiProFilter = new QFilter("enablemultipro", "=", (Object)DefaultEnum.NO.getValue());
                DynamicObject[] proCostSplits = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)"totalcostamt,project", (QFilter[])new QFilter[]{billStatusFilter, proFilter, enableMultiProFilter});
                logger.info("----search ProCostSplitNoMultiPro DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                return Arrays.stream(proCostSplits).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("project").getPkValue()));
            }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
            CompletableFuture<Map> proCostSplitEntryFuture = CompletableFuture.supplyAsync(() -> {
                long beforeTime = System.currentTimeMillis();
                QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                QFilter enableMultiProFilter = new QFilter("enablemultipro", "=", (Object)DefaultEnum.YES.getValue());
                QFilter proCostQFilter = new QFilter("procostsplitentry.entryproject", "in", (Object)proIdSet);
                DynamicObject[] proCostSplitEntrys = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)"procostsplitentry, procostsplitentry.entryproject, procostsplitentry.costamt", (QFilter[])new QFilter[]{billStatusFilter, proCostQFilter, enableMultiProFilter});
                logger.info("----search ProCostSplitMultiPro DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                return Arrays.stream(proCostSplitEntrys).map(it -> it.getDynamicObjectCollection("procostsplitentry")).flatMap(Collection::stream).filter(entry -> entry.getDynamicObject("entryproject") != null).collect(Collectors.groupingBy(entry -> entry.getDynamicObject("entryproject").getPkValue()));
            }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
            CompletableFuture<Map> outBudgetRemindAmtFuture = CompletableFuture.supplyAsync(() -> {
                long beforeTime = System.currentTimeMillis();
                QFilter sourceFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
                QFilter parentFilter = new QFilter("parent", "=", (Object)0L);
                QFilter proFilter = new QFilter("project", "in", (Object)proIdSet);
                DynamicObject[] projectBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)String.join((CharSequence)",", "project", "remainamt"), (QFilter[])new QFilter[]{sourceFilter, parentFilter, proFilter});
                logger.info("----search ProjectBudget DynamicObject time {}---", (Object)(System.currentTimeMillis() - beforeTime));
                return Arrays.stream(projectBudgets).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("project").getPkValue()));
            }, arg_0 -> ((ThreadPool)PmgtThreadPools.PROJECT_REPORT_POOL).execute(arg_0));
            HashMap proIdToWarnLevelMap = null;
            Map proIdToNowTeamMap = null;
            Map proAppIdToStageMap = null;
            Map contractMap = null;
            Map proToIncomeApplyMap = null;
            Map proToContractSettleMap = null;
            Map proToPayApplyMap = null;
            Map proToSinglePayApplyMap = null;
            Map proToCostSplitMap = null;
            Map proToCostSplitEntryMap = null;
            Map proBudgetMap = null;
            Map proToBudgetMap = null;
            try {
                proIdToNowTeamMap = proIdToNowTeamFuture.get();
                proAppIdToStageMap = stageStatusFuture.get();
                contractMap = contractFuture.get();
                proToIncomeApplyMap = incomeApplyFuture.get();
                proToContractSettleMap = contractSettleFuture.get();
                proToPayApplyMap = payApplyFuture.get();
                proToSinglePayApplyMap = singlePayApplyFuture.get();
                proToCostSplitMap = proCostSplitFuture.get();
                proToCostSplitEntryMap = proCostSplitEntryFuture.get();
                proIdToWarnLevelMap = proIdToWarnLevelFuture.get();
                proBudgetMap = outBudgetRemindAmtFuture.get();
                proToBudgetMap = proToBudgetFuture.get();
                proIdToWarnLevelMap = proIdToWarnLevelMap == null ? new HashMap(0) : proIdToWarnLevelMap;
            }
            catch (InterruptedException e) {
                logger.error("ProjectBookReportFormTplPlugin.InterruptedException", (Throwable)e);
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u67e5\u8be2\u6570\u636e\u65f6\u4e2d\u65ad\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u62a5\u9519\u4fe1\u606f\u3002", (String)"ProjectBookReportFormTplPlugin_4", (String)"pmgt-pmbs-report", (Object[])new Object[0]));
                proIdToWarnLevelMap = proIdToWarnLevelMap == null ? new HashMap(0) : proIdToWarnLevelMap;
                proIdToNowTeamMap = proIdToNowTeamMap == null ? new HashMap(0) : proIdToNowTeamMap;
                proAppIdToStageMap = proAppIdToStageMap == null ? new HashMap(0) : proAppIdToStageMap;
                contractMap = contractMap == null ? new HashMap(0) : contractMap;
                proToIncomeApplyMap = proToIncomeApplyMap == null ? new HashMap(0) : proToIncomeApplyMap;
                proToContractSettleMap = proToContractSettleMap == null ? new HashMap(0) : proToContractSettleMap;
                proToPayApplyMap = proToPayApplyMap == null ? new HashMap(0) : proToPayApplyMap;
                proToSinglePayApplyMap = proToSinglePayApplyMap == null ? new HashMap(0) : proToSinglePayApplyMap;
                proToCostSplitMap = proToCostSplitMap == null ? new HashMap(0) : proToCostSplitMap;
                proToCostSplitEntryMap = proToCostSplitEntryMap == null ? new HashMap(0) : proToCostSplitEntryMap;
                proBudgetMap = proBudgetMap == null ? new HashMap(0) : proBudgetMap;
                proToBudgetMap = proToBudgetMap == null ? new HashMap(0) : proToBudgetMap;
            }
            catch (ExecutionException e2) {
                logger.error("ProjectBookReportFormTplPlugin.getMapError-ExecutionException", (Throwable)e2);
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u83b7\u53d6\u6570\u636e\u65f6\u62a5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u62a5\u9519\u4fe1\u606f\u3002", (String)"ProjectBookReportFormTplPlugin_5", (String)"pmgt-pmbs-report", (Object[])new Object[0]));
                proIdToWarnLevelMap = proIdToWarnLevelMap == null ? new HashMap(0) : proIdToWarnLevelMap;
                {
                    catch (Throwable throwable) {
                        proIdToWarnLevelMap = proIdToWarnLevelMap == null ? new HashMap(0) : proIdToWarnLevelMap;
                        proIdToNowTeamMap = proIdToNowTeamMap == null ? new HashMap(0) : proIdToNowTeamMap;
                        proAppIdToStageMap = proAppIdToStageMap == null ? new HashMap(0) : proAppIdToStageMap;
                        contractMap = contractMap == null ? new HashMap(0) : contractMap;
                        proToIncomeApplyMap = proToIncomeApplyMap == null ? new HashMap(0) : proToIncomeApplyMap;
                        proToContractSettleMap = proToContractSettleMap == null ? new HashMap(0) : proToContractSettleMap;
                        proToPayApplyMap = proToPayApplyMap == null ? new HashMap(0) : proToPayApplyMap;
                        proToSinglePayApplyMap = proToSinglePayApplyMap == null ? new HashMap(0) : proToSinglePayApplyMap;
                        proToCostSplitMap = proToCostSplitMap == null ? new HashMap(0) : proToCostSplitMap;
                        proToCostSplitEntryMap = proToCostSplitEntryMap == null ? new HashMap(0) : proToCostSplitEntryMap;
                        proBudgetMap = proBudgetMap == null ? new HashMap(0) : proBudgetMap;
                        proToBudgetMap = proToBudgetMap == null ? new HashMap(0) : proToBudgetMap;
                        throw throwable;
                    }
                }
                proIdToNowTeamMap = proIdToNowTeamMap == null ? new HashMap(0) : proIdToNowTeamMap;
                proAppIdToStageMap = proAppIdToStageMap == null ? new HashMap(0) : proAppIdToStageMap;
                contractMap = contractMap == null ? new HashMap(0) : contractMap;
                proToIncomeApplyMap = proToIncomeApplyMap == null ? new HashMap(0) : proToIncomeApplyMap;
                proToContractSettleMap = proToContractSettleMap == null ? new HashMap(0) : proToContractSettleMap;
                proToPayApplyMap = proToPayApplyMap == null ? new HashMap(0) : proToPayApplyMap;
                proToSinglePayApplyMap = proToSinglePayApplyMap == null ? new HashMap(0) : proToSinglePayApplyMap;
                proToCostSplitMap = proToCostSplitMap == null ? new HashMap(0) : proToCostSplitMap;
                proToCostSplitEntryMap = proToCostSplitEntryMap == null ? new HashMap(0) : proToCostSplitEntryMap;
                proBudgetMap = proBudgetMap == null ? new HashMap(0) : proBudgetMap;
                proToBudgetMap = proToBudgetMap == null ? new HashMap(0) : proToBudgetMap;
            }
            proIdToNowTeamMap = proIdToNowTeamMap == null ? new HashMap(0) : proIdToNowTeamMap;
            proAppIdToStageMap = proAppIdToStageMap == null ? new HashMap(0) : proAppIdToStageMap;
            contractMap = contractMap == null ? new HashMap(0) : contractMap;
            proToIncomeApplyMap = proToIncomeApplyMap == null ? new HashMap(0) : proToIncomeApplyMap;
            proToContractSettleMap = proToContractSettleMap == null ? new HashMap(0) : proToContractSettleMap;
            proToPayApplyMap = proToPayApplyMap == null ? new HashMap(0) : proToPayApplyMap;
            proToSinglePayApplyMap = proToSinglePayApplyMap == null ? new HashMap(0) : proToSinglePayApplyMap;
            proToCostSplitMap = proToCostSplitMap == null ? new HashMap(0) : proToCostSplitMap;
            proToCostSplitEntryMap = proToCostSplitEntryMap == null ? new HashMap(0) : proToCostSplitEntryMap;
            proBudgetMap = proBudgetMap == null ? new HashMap(0) : proBudgetMap;
            proToBudgetMap = proToBudgetMap == null ? new HashMap(0) : proToBudgetMap;
            Map proToOutBudgetMap = new HashMap();
            Map proToInBudgetMap = new HashMap();
            if (proToBudgetMap.get("OUT") != null) {
                proToOutBudgetMap = (Map)proToBudgetMap.get("OUT");
            }
            if (proToBudgetMap.get("IN") != null) {
                proToInBudgetMap = (Map)proToBudgetMap.get("IN");
            }
            HashMap proToOutSettleMap = new HashMap();
            HashMap proToInSettleMap = new HashMap();
            if (!proToContractSettleMap.isEmpty()) {
                Set contractSettleMapEntrySet = proToContractSettleMap.entrySet();
                for (Map.Entry contractSettleMapEntry : contractSettleMapEntrySet) {
                    List inSettles;
                    Object projectId = contractSettleMapEntry.getKey();
                    List settles = (List)contractSettleMapEntry.getValue();
                    List outSettles = settles.stream().filter(o -> StringUtils.equals((CharSequence)o.getString("contract.paydirection"), (CharSequence)PayDirectionEnum.OUT.getValue())).collect(Collectors.toList());
                    if (outSettles.size() > 0) {
                        ArrayList outSettleList = (ArrayList)proToOutSettleMap.get(projectId);
                        if (outSettleList == null) {
                            outSettleList = new ArrayList();
                        }
                        outSettleList.addAll(outSettles);
                        proToOutSettleMap.put(projectId, outSettleList);
                    }
                    if ((inSettles = settles.stream().filter(o -> StringUtils.equals((CharSequence)o.getString("contract.paydirection"), (CharSequence)PayDirectionEnum.IN.getValue())).collect(Collectors.toList())).size() <= 0) continue;
                    ArrayList inSettleList = (ArrayList)proToInSettleMap.get(projectId);
                    if (inSettleList == null) {
                        inSettleList = new ArrayList();
                    }
                    inSettleList.addAll(inSettles);
                    proToInSettleMap.put(projectId, inSettleList);
                }
            }
            HashMap proToOutContMap = new HashMap();
            HashMap proToInContMap = new HashMap();
            if (!contractMap.isEmpty()) {
                Set contractMapEntrySet = contractMap.entrySet();
                for (Map.Entry contractMapEntry : contractMapEntrySet) {
                    List inContracts;
                    Object projectId = contractMapEntry.getKey();
                    List contracts = (List)contractMapEntry.getValue();
                    List outContracts = contracts.stream().filter(o -> StringUtils.equals((CharSequence)o.getString("paydirection"), (CharSequence)PayDirectionEnum.OUT.getValue())).collect(Collectors.toList());
                    if (outContracts.size() > 0) {
                        ArrayList outContractList = (ArrayList)proToOutContMap.get(projectId);
                        if (outContractList == null) {
                            outContractList = new ArrayList();
                        }
                        outContractList.addAll(outContracts);
                        proToOutContMap.put(projectId, outContractList);
                    }
                    if ((inContracts = contracts.stream().filter(o -> StringUtils.equals((CharSequence)o.getString("paydirection"), (CharSequence)PayDirectionEnum.IN.getValue())).collect(Collectors.toList())).size() <= 0) continue;
                    ArrayList inContractList = (ArrayList)proToInContMap.get(projectId);
                    if (inContractList == null) {
                        inContractList = new ArrayList();
                    }
                    inContractList.addAll(inContracts);
                    proToInContMap.put(projectId, inContractList);
                }
            }
            startTime = System.currentTimeMillis();
            for (DynamicObject dyn2 : rowData) {
                List<DynamicObject> proAppObjList;
                DynamicObject proApp = dyn2.getDynamicObject("rbillname");
                Object proAppPkValue = proApp.getPkValue();
                DynamicObject pro = dyn2.getDynamicObject("rpro");
                if (pro != null) {
                    List nowTeamList;
                    List proCostSplitEntryList;
                    List singlePayApplyList;
                    List outSettleList;
                    List incomeApplyList;
                    List inSettleList;
                    List inContractList;
                    List outContractList;
                    Object proPkValue = pro.getPkValue();
                    dyn2.set("warnlevel", proIdToWarnLevelMap.get(proPkValue));
                    List curStageStatusList = (List)proAppIdToStageMap.get(proAppPkValue);
                    if (curStageStatusList != null && !curStageStatusList.isEmpty()) {
                        dyn2.set("projectstage", ((DynamicObject)curStageStatusList.get(0)).get("projectstage"));
                    }
                    dyn2.set("proposalamount", (Object)proAppIdToProposalMap.get(proAppPkValue));
                    List<DynamicObject> proAppObjList2 = proAppIdToAppObjMap.get(proAppPkValue);
                    if (proAppObjList2 != null && !proAppObjList2.isEmpty()) {
                        BigDecimal outBudgetAmt;
                        DynamicObject proAppObj = proAppObjList2.get(0);
                        List outBudgets = (List)proToOutBudgetMap.get(proPkValue);
                        if (outBudgets != null && !outBudgets.isEmpty()) {
                            String proBudgetCtrl = proAppObj.getString("probudgetctrl");
                            String sourceType = StringUtils.equals((CharSequence)proBudgetCtrl, (CharSequence)ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue()) ? BudgetSourceTypeEnum.OUT.getValue() : BudgetSourceTypeEnum.TOTAL.getValue();
                            outBudgetAmt = outBudgets.stream().filter(it -> StringUtils.equals((CharSequence)it.get("sourcetype").toString(), (CharSequence)sourceType)).map(it -> it.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        } else {
                            outBudgetAmt = proAppObj.getBigDecimal("outamount");
                        }
                        dyn2.set("outbudgetamount", (Object)outBudgetAmt);
                        List inBudgets = (List)proToInBudgetMap.get(proPkValue);
                        BigDecimal inBudgetAmt = BigDecimal.ZERO;
                        if (inBudgets != null && !inBudgets.isEmpty()) {
                            for (DynamicObject inBudget : inBudgets) {
                                inBudgetAmt = inBudgetAmt.add(inBudget.getBigDecimal("totalamount"));
                            }
                        } else {
                            inBudgetAmt = proAppObj.getBigDecimal("inamount");
                        }
                        dyn2.set("inbudgetamount", (Object)inBudgetAmt);
                        BigDecimal expIncomeAmount = inBudgetAmt.subtract(outBudgetAmt);
                        dyn2.set("expincomeamount", (Object)expIncomeAmount);
                        if (outBudgetAmt != null && outBudgetAmt.compareTo(BigDecimal.ZERO) != 0) {
                            dyn2.set("profitrate", (Object)expIncomeAmount.divide(outBudgetAmt, 10, 4).multiply(BigDecimal.valueOf(100L)));
                        }
                    }
                    if ((outContractList = (List)proToOutContMap.get(proPkValue)) != null && !outContractList.isEmpty()) {
                        BigDecimal outContAmount = outContractList.stream().map(it -> it.getBigDecimal("totaloftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        dyn2.set("outcontamount", (Object)outContAmount);
                    }
                    if ((inContractList = (List)proToInContMap.get(proPkValue)) != null && !inContractList.isEmpty()) {
                        BigDecimal totalOfTaxAmount = inContractList.stream().map(it -> it.getBigDecimal("totaloftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        dyn2.set("incontamount", (Object)totalOfTaxAmount);
                    }
                    if ((inSettleList = (List)proToInSettleMap.get(proPkValue)) != null && !inSettleList.isEmpty()) {
                        BigDecimal settleOfTaxAmount = inSettleList.stream().map(it -> it.getBigDecimal("settleoftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        dyn2.set("incontsettleamt", (Object)settleOfTaxAmount);
                    }
                    if ((incomeApplyList = (List)proToIncomeApplyMap.get(proPkValue)) != null && !incomeApplyList.isEmpty()) {
                        BigDecimal applyOfTaxAmount = incomeApplyList.stream().map(it -> it.getBigDecimal("applyoftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        dyn2.set("incomeapplyamt", (Object)applyOfTaxAmount);
                    }
                    if (incomeApplyList != null && !incomeApplyList.isEmpty()) {
                        BigDecimal incomeApplyPayAmount = incomeApplyList.stream().map(it -> it.getBigDecimal("entryrecamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        dyn2.set("incomeregistamt", (Object)incomeApplyPayAmount);
                    }
                    if ((outSettleList = (List)proToOutSettleMap.get(proPkValue)) != null && !outSettleList.isEmpty()) {
                        BigDecimal settleOfTaxAmount = outSettleList.stream().map(it -> it.getBigDecimal("settleoftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        dyn2.set("outcontsettleamt", (Object)settleOfTaxAmount);
                    }
                    BigDecimal applyoftaxamount = BigDecimal.ZERO;
                    List payApplyList = (List)proToPayApplyMap.get(proPkValue);
                    if (payApplyList != null && !payApplyList.isEmpty()) {
                        applyoftaxamount = applyoftaxamount.add(payApplyList.stream().map(it -> it.getBigDecimal("thispayableamount")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    }
                    if ((singlePayApplyList = (List)proToSinglePayApplyMap.get(proPkValue)) != null && !singlePayApplyList.isEmpty()) {
                        applyoftaxamount = applyoftaxamount.add(singlePayApplyList.stream().map(it -> it.getBigDecimal("curpaytotal")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    }
                    dyn2.set("payapplyamt", (Object)applyoftaxamount);
                    if (payApplyList != null && !payApplyList.isEmpty()) {
                        BigDecimal paymentOfTaxAmount = payApplyList.stream().map(it -> it.getBigDecimal("entrypaidamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        dyn2.set("payregistamt", (Object)paymentOfTaxAmount);
                    }
                    BigDecimal totalCostAmt = BigDecimal.ZERO;
                    List proCostSplitList = (List)proToCostSplitMap.get(proPkValue);
                    if (proCostSplitList != null && !proCostSplitList.isEmpty()) {
                        totalCostAmt = totalCostAmt.add(proCostSplitList.stream().map(it -> it.getBigDecimal("totalcostamt")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    }
                    if ((proCostSplitEntryList = (List)proToCostSplitEntryMap.get(proPkValue)) != null && !proCostSplitEntryList.isEmpty()) {
                        totalCostAmt = totalCostAmt.add(proCostSplitEntryList.stream().map(it -> it.getBigDecimal("costamt")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    }
                    dyn2.set("costamount", (Object)totalCostAmt);
                    List proBudgetList = (List)proBudgetMap.get(proPkValue);
                    if (proBudgetList != null && !proBudgetList.isEmpty()) {
                        BigDecimal outBudgetRemainAmt = proBudgetList.stream().map(it -> it.getBigDecimal("remainamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        dyn2.set("outbudgetremain", (Object)outBudgetRemainAmt);
                    }
                    if ((nowTeamList = (List)proIdToNowTeamMap.get(proPkValue)) == null || nowTeamList.isEmpty()) continue;
                    DynamicObject nowTeamObj = (DynamicObject)nowTeamList.get(0);
                    dyn2.set("proleader", (Object)nowTeamObj.getDynamicObject("member"));
                    dyn2.set("leaderconttype", (Object)nowTeamObj.getString("telno"));
                    continue;
                }
                List curStageStatusList = (List)proAppIdToStageMap.get(proAppPkValue);
                if (curStageStatusList != null && !curStageStatusList.isEmpty()) {
                    dyn2.set("projectstage", ((DynamicObject)curStageStatusList.get(0)).get("projectstage"));
                }
                if ((proAppObjList = proAppIdToAppObjMap.get(proAppPkValue)) == null || proAppObjList.isEmpty()) continue;
                DynamicObject proAppObj = proAppObjList.get(0);
                BigDecimal outBudgetAmt = proAppObj.getBigDecimal("outamount");
                dyn2.set("outbudgetamount", (Object)outBudgetAmt);
                BigDecimal inBudgetAmt = proAppObj.getBigDecimal("inamount");
                dyn2.set("inbudgetamount", (Object)inBudgetAmt);
                BigDecimal expIncomeAmount = inBudgetAmt.subtract(outBudgetAmt);
                dyn2.set("expincomeamount", (Object)expIncomeAmount);
                if (outBudgetAmt == null || outBudgetAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                dyn2.set("profitrate", (Object)expIncomeAmount.divide(outBudgetAmt, 10, 4).multiply(BigDecimal.valueOf(100L)));
            }
            logger.info("----handle data time {}---", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String filename = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObject entryProApp = entryRowEntity.getDynamicObject("ebillname");
        Object proAppPkValue = entryProApp.getPkValue();
        DynamicObject proAppObj = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"probudgetctrl,outamount,inamount,proproposal,bugproname", (QFilter[])new QFilter[]{new QFilter("id", "=", proAppPkValue)});
        if (filename.equals("ebillnametxt")) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", "pmas_pro_approval");
            map.put("pkId", proAppObj.getPkValue().toString());
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        } else {
            DynamicObject entryPro = entryRowEntity.getDynamicObject("epro");
            if (entryPro == null) {
                return;
            }
            Object proPkValue = entryPro.getPkValue();
            switch (filename) {
                case "ewarnlevel": {
                    QFilter projectFilter = new QFilter("project", "=", proPkValue);
                    QFilter enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
                    DynamicObject[] warnMessageObjs = BusinessDataServiceHelper.load((String)"pmbs_warnmessage", (String)"", (QFilter[])new QFilter[]{projectFilter, enableFilter});
                    this.hyperlinkSearch("pmbs_warnmessage", warnMessageObjs);
                    break;
                }
                case "eproposalamount": {
                    DynamicObject proproposal = proAppObj.getDynamicObject("proproposal");
                    if (proproposal == null) break;
                    proproposal = BusinessDataServiceHelper.loadSingle((Object)proproposal.getPkValue(), (String)"pmim_projectproposal");
                    this.hyperlinkSearch("pmim_projectproposal", new DynamicObject[]{proproposal});
                    break;
                }
                case "einbudgetamount": {
                    QFilter qFilter = new QFilter("isvalid", "=", (Object)DefaultEnum.YES.getValue());
                    qFilter.and("sourcetype", "=", (Object)"IN");
                    qFilter.and("project", "=", proPkValue);
                    DynamicObject[] inBudgets = BusinessDataServiceHelper.load((String)"pmas_inbudget", (String)"totalamount", (QFilter[])new QFilter[]{qFilter});
                    if (inBudgets != null) {
                        this.hyperlinkSearch("pmas_inbudget", inBudgets);
                        break;
                    }
                    this.hyperlinkSearch("pmas_pro_approval", new DynamicObject[]{proAppObj});
                    break;
                }
                case "eoutbudgetamount": {
                    String proBudgetCtrl = proAppObj.getString("probudgetctrl");
                    String sourceType = StringUtils.equals((CharSequence)proBudgetCtrl, (CharSequence)ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue()) ? BudgetSourceTypeEnum.OUT.getValue() : BudgetSourceTypeEnum.TOTAL.getValue();
                    String formBillId = StringUtils.equals((CharSequence)sourceType, (CharSequence)BudgetSourceTypeEnum.OUT.getValue()) ? "pmas_outbudget" : "pmas_totalbudget";
                    QFilter qFilter = new QFilter("isvalid", "=", (Object)DefaultEnum.YES.getValue());
                    qFilter.and("sourcetype", "=", (Object)sourceType);
                    qFilter.and("project", "=", proPkValue);
                    DynamicObject[] outBudgets = BusinessDataServiceHelper.load((String)formBillId, (String)"totalamount", (QFilter[])new QFilter[]{qFilter});
                    if (outBudgets != null) {
                        this.hyperlinkSearch(formBillId, outBudgets);
                        break;
                    }
                    this.hyperlinkSearch("pmas_pro_approval", new DynamicObject[]{proAppObj});
                    break;
                }
                case "eincontamount": {
                    Set<Object> contStatusIdSet = this.getContStatusIdSet();
                    QFilter qFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
                    qFilter.and("project", "=", proPkValue);
                    qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    qFilter.and("contractstatus", "in", contStatusIdSet);
                    DynamicObject[] inContracts = BusinessDataServiceHelper.load((String)"pmct_incontract", (String)"totaloftaxamount,stdcurrency", (QFilter[])new QFilter[]{qFilter});
                    this.hyperlinkSearch("pmct_incontract", inContracts);
                    break;
                }
                case "eoutcontamount": {
                    QFilter qFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
                    qFilter.and("project", "=", proPkValue);
                    qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    Set<Object> contStatusIdSet = this.getContStatusIdSet();
                    qFilter.and("contractstatus", "in", contStatusIdSet);
                    DynamicObject[] outContracts = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"totaloftaxamount,stdcurrency", (QFilter[])new QFilter[]{qFilter});
                    this.hyperlinkSearch("pmct_outcontract", outContracts);
                    break;
                }
                case "eincontsettleamt": {
                    QFilter inFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
                    QFilter proFilter = new QFilter("project", "=", proPkValue);
                    QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    DynamicObject[] inSettleConts = BusinessDataServiceHelper.load((String)"pmct_incontract_settle", (String)"settleoftaxamount", (QFilter[])new QFilter[]{inFilter, proFilter, billStatusFilter});
                    this.hyperlinkSearch("pmct_incontract_settle", inSettleConts);
                    break;
                }
                case "eincomeapplyamt": {
                    QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    QFilter qFilter = new QFilter("entryentity.contpro", "=", proPkValue);
                    DynamicObject[] incomeApplys = BusinessDataServiceHelper.load((String)"pmct_incomeapply", (String)"entrycontract, applyoftaxamount", (QFilter[])new QFilter[]{billStatusFilter, qFilter});
                    this.hyperlinkSearch("pmct_incomeapply", incomeApplys);
                    break;
                }
                case "eincomeregistamt": {
                    QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    QFilter qFilter = new QFilter("entryentity.contpro", "=", proPkValue);
                    DynamicObject[] incomeRegists = BusinessDataServiceHelper.load((String)"pmct_incomeregister", (String)"entrycontract,entryentity.receiptoftaxamount", (QFilter[])new QFilter[]{billStatusFilter, qFilter});
                    this.hyperlinkSearch("pmct_incomeregister", incomeRegists);
                    break;
                }
                case "eoutcontsettleamt": {
                    QFilter outFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
                    QFilter proFilter = new QFilter("project", "=", proPkValue);
                    QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    DynamicObject[] outSettleConts = BusinessDataServiceHelper.load((String)"pmct_outcontract_settle", (String)"settleoftaxamount", (QFilter[])new QFilter[]{outFilter, billStatusFilter, proFilter});
                    this.hyperlinkSearch("pmct_outcontract_settle", outSettleConts);
                    break;
                }
                case "epayapplyamt": {
                    QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    QFilter qFilter = new QFilter("entryentity.contpro", "=", proPkValue);
                    DynamicObject[] payApplys = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"entrycontract, entryentity.applyoftaxamount", (QFilter[])new QFilter[]{billStatusFilter, qFilter});
                    this.hyperlinkSearch("pmct_paymentapply", payApplys);
                    QFilter proFilter = new QFilter("project", "=", proPkValue);
                    DynamicObject[] singlePayApplys = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"curpaytotal", (QFilter[])new QFilter[]{billStatusFilter, proFilter});
                    this.hyperlinkSearch("pmct_applymentpay", singlePayApplys);
                    break;
                }
                case "epayregistamt": {
                    QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    QFilter qFilter = new QFilter("entryentity.contpro", "=", proPkValue);
                    DynamicObject[] payRegists = BusinessDataServiceHelper.load((String)"pmct_paymentregister", (String)"entrycontract, entryentity.thispaymentoftaxamount", (QFilter[])new QFilter[]{billStatusFilter, qFilter});
                    this.hyperlinkSearch("pmct_paymentregister", payRegists);
                    break;
                }
                case "ecostamount": {
                    QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    QFilter qFilter = new QFilter("procostsplitentry.entryproject", "=", proPkValue);
                    QFilter proFilter = new QFilter("project", "=", proPkValue);
                    DynamicObject[] proCostSplits = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)"totalcostamt,procostsplitentry, procostsplitentry.entryproject", (QFilter[])new QFilter[]{billStatusFilter, proFilter.or(qFilter)});
                    this.hyperlinkSearch("pmco_procostsplit", proCostSplits);
                    break;
                }
            }
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        ReportList list = (ReportList)this.getControl("reportlistap");
        ReportListModel reportModel = (ReportListModel)list.getReportModel();
        int rowCount = reportModel.getRowCount();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        entryentity.clear();
        this.getPageCache().put(PROCESS_DATA, "false");
        if (rowCount == 0) {
            this.getModel().updateEntryCache(entryentity);
            this.getView().updateView("entryentity");
            return;
        }
        String maxsize = System.getProperty("orm.opt.in.maxsize");
        int length = StringUtils.isEmpty((CharSequence)maxsize) ? rowCount : Integer.parseInt(maxsize);
        DynamicObjectCollection allProcessedData = new DynamicObjectCollection();
        for (int begin = 0; begin < rowCount; begin += length) {
            DynamicObjectCollection rowDataCol = reportModel.getRowData(begin, length);
            allProcessedData.addAll((Collection)rowDataCol);
        }
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        Map fields = dataEntityType.getFields();
        boolean hasCreateOrg = fields.containsKey("createorg");
        this.getPageCache().put(PROCESS_DATA, "true");
        for (DynamicObject rowData : allProcessedData) {
            DynamicObject entryRow = entryentity.addNew();
            entryRow.set("ebusinessorg", rowData.get("businessorg"));
            if (hasCreateOrg) {
                entryRow.set("ecreateorg", rowData.get("createorg"));
            }
            entryRow.set("eprokind", rowData.get("prokind"));
            entryRow.set("epronum", rowData.get("pronum"));
            entryRow.set("epro", rowData.get("rpro"));
            entryRow.set("ebillname", rowData.get("rbillname"));
            entryRow.set("ebillnametxt", rowData.get("billnametxt"));
            entryRow.set("eprojectstage", rowData.get("projectstage"));
            entryRow.set("eprojectstatus", rowData.get("projectstatus"));
            entryRow.set("eproposalamount", rowData.get("proposalamount"));
            entryRow.set("eoutbudgetamount", rowData.get("outbudgetamount"));
            entryRow.set("einbudgetamount", rowData.get("inbudgetamount"));
            entryRow.set("eexpincomeamount", rowData.get("expincomeamount"));
            entryRow.set("eprofitrate", rowData.get("profitrate"));
            entryRow.set("eincontamount", rowData.get("incontamount"));
            entryRow.set("eoutcontamount", rowData.get("outcontamount"));
            entryRow.set("eincontsettleamt", rowData.get("incontsettleamt"));
            entryRow.set("eincomeapplyamt", rowData.get("incomeapplyamt"));
            entryRow.set("eincomeregistamt", rowData.get("incomeregistamt"));
            entryRow.set("eoutcontsettleamt", rowData.get("outcontsettleamt"));
            entryRow.set("epayapplyamt", rowData.get("payapplyamt"));
            entryRow.set("epayregistamt", rowData.get("payregistamt"));
            entryRow.set("ecostamount", rowData.get("costamount"));
            entryRow.set("eoutbudgetremain", rowData.get("outbudgetremain"));
            entryRow.set("eproleader", rowData.get("proleader"));
            entryRow.set("eleaderconttype", rowData.get("leaderconttype"));
            entryRow.set("ebuildnature", rowData.get("buildnature"));
            entryRow.set("eindustrytype", rowData.get("industrytype"));
            entryRow.set("eindustry", rowData.get("industry"));
            entryRow.set("eoverseapro", rowData.get("roverseapro"));
            entryRow.set("eprojectarea", rowData.get("rprojectarea"));
            entryRow.set("einvestdirection", rowData.get("rinvestdirection"));
            entryRow.set("einvestkind", rowData.get("rinvestkind"));
            entryRow.set("ewarnlevel", rowData.get("warnlevel"));
        }
        this.getModel().updateEntryCache(entryentity);
        this.getView().updateView("entryentity");
    }

    @NotNull
    protected Set<Object> getContStatusIdSet() {
        DynamicObject[] contStatusObjs;
        HashSet<Object> contStatusIdSet = new HashSet<Object>(3);
        HashSet<String> contStatusNumSet = new HashSet<String>(3);
        contStatusNumSet.add(ContractStatusEnum.INDRAFT.getValue());
        contStatusNumSet.add(ContractStatusEnum.INAUDIT.getValue());
        contStatusNumSet.add(ContractStatusEnum.APPROVED.getValue());
        QFilter contStatusFilter = new QFilter("number", "not in", contStatusNumSet);
        for (DynamicObject contStatusObj : contStatusObjs = BusinessDataServiceHelper.load((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter})) {
            contStatusIdSet.add(contStatusObj.getPkValue());
        }
        return contStatusIdSet;
    }

    protected void hyperlinkSearch(String formId, DynamicObject[] list) {
        if (list == null || list.length <= 0) {
            return;
        }
        LinkQueryPkIdCollection xCollection = new LinkQueryPkIdCollection();
        for (DynamicObject sa : list) {
            xCollection.add((Object)new LinkQueryPkId(sa.getPkValue()));
        }
        ListShowParameter showListForm = new ListShowParameter();
        showListForm.setBillFormId(formId);
        showListForm.setLinkQueryPkIdCollection(xCollection);
        showListForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showListForm);
    }
}

