/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.report.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.report.form.ProjectBookReportFormTplPlugin;
import org.apache.commons.compress.utils.Lists;

public class ProjectBookReportQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(ProjectBookReportFormTplPlugin.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List filterItemInfoList = filterInfo.getFilterItems();
        List fastQFilters = Lists.newArrayList();
        if (filterInfo.getFastFilter() != null) {
            fastQFilters = filterInfo.getFastFilter().getQFilters();
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.addAll(fastQFilters);
        Map customParam = reportQueryParam.getCustomParam();
        String appid = (String)customParam.get("appid");
        String formid = (String)customParam.get("formid");
        long startTime = System.currentTimeMillis();
        List permOrgList = ProjectPermissionHelper.getAllPermOrgs((String)RequestContext.get().getUserId(), (String)appid, (String)formid, (String)"reportquery");
        logger.info("----search permOrg time {}---", (Object)(System.currentTimeMillis() - startTime));
        boolean isContainProstatus = false;
        for (FilterItemInfo item : filterItemInfoList) {
            QFilter filter = null;
            String propName = item.getPropName();
            Object value = item.getValue();
            if ("org.id".equals(propName) && value instanceof Long) {
                ArrayList<Long> orgList = new ArrayList<Long>(1);
                if (permOrgList.contains(value)) {
                    orgList.add((Long)value);
                }
                filter = orgList.isEmpty() ? new QFilter("org", "=", (Object)0L) : new QFilter("org", "in", orgList);
            } else if ("org.id".equals(propName) && value instanceof List) {
                List selectedIdList = (List)value;
                ArrayList<Long> orgList = new ArrayList<Long>(selectedIdList.size());
                for (Long orgId : selectedIdList) {
                    if (!permOrgList.contains(orgId)) continue;
                    orgList.add(orgId);
                }
                filter = orgList.isEmpty() ? new QFilter("org", "=", (Object)0L) : new QFilter("org", "in", orgList);
            } else {
                if ("prostatus.id".equals(propName)) {
                    isContainProstatus = true;
                }
                filter = new QFilter(propName, item.getCompareType(), item.getValue());
            }
            filterList.add(filter);
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter orgFilter = new QFilter("org", "in", (Object)permOrgList);
        QFilter profilter = new QFilter("pro", "!=", (Object)0);
        statusFilter.and(profilter).and(orgFilter);
        filterList.add(statusFilter);
        if (!isContainProstatus) {
            QFilter proStatusfilter = new QFilter("prostatus.number", "!=", (Object)ProjectStatusEnum.APPROVAL_FAIL.getValue());
            filterList.add(proStatusfilter);
        }
        String selectField = "currencyfield,id,org,pro,billno,billname,prostatus,kind,expincomeamount,proleader,leaderconttype,buildnature,overseapro,projectarea,industrykind,industry,investdirection,investkind,createorg";
        startTime = System.currentTimeMillis();
        DataSet proDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmas_pro_approval", (String)selectField, (QFilter[])filterList.toArray(new QFilter[filterList.size()]), (String)"auditdate desc");
        logger.info("----search projectApproval time {}---", (Object)(System.currentTimeMillis() - startTime));
        return proDataSet;
    }
}

