/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.budget;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.budget.ProjectBudgetUpdateService;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.budget.BudgetParam;
import kd.pmgt.pmbs.common.budget.BudgetRegValue;
import kd.pmgt.pmbs.common.enums.BudgetControlTargetEnum;
import kd.pmgt.pmbs.common.enums.BudgetControlTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;

public class ProjectBudgetUpdateServiceImpl
implements ProjectBudgetUpdateService {
    @Override
    public void occupyOccupy(BudgetParam budgetParam) {
        List budgetRegValues = budgetParam.budgetRegValues;
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            DynamicObject totalBudgetCtrlDetail;
            DynamicObject budget;
            boolean budgetCtrl;
            boolean isProCostControl;
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project)) || !(budgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl(Long.valueOf(project.getPkValue().toString())))) continue;
            String budgetType = budgetRegValue.getBudgetTypeValue().getValue();
            BigDecimal amount = budgetRegValue.getAmountValue();
            QFilter filter = new QFilter("tproject", "=", project.getPkValue()).and("tbudgettype", "=", (Object)budgetType);
            DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{filter});
            if (totalBudgetCtrl != null) {
                BigDecimal preOccupyAmt = totalBudgetCtrl.getBigDecimal("tpreoccupyamt");
                BigDecimal newPreOccupyAmt = preOccupyAmt.add(amount);
                totalBudgetCtrl.set("tpreoccupyamt", (Object)newPreOccupyAmt);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrl});
            }
            if ((budget = budgetRegValue.getBudgetValue()) != null && (totalBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue())})) != null) {
                BigDecimal sumPreOccupyAmt = totalBudgetCtrlDetail.getBigDecimal("preoccupyamt");
                BigDecimal newSumPreOccupyAmt = sumPreOccupyAmt.add(amount);
                totalBudgetCtrlDetail.set("preoccupyamt", (Object)newSumPreOccupyAmt);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrlDetail});
            }
            this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.TAKEOPERATION);
        }
    }

    @Override
    public void occupyEffect(BudgetParam budgetParam) {
        List budgetRegValues = budgetParam.budgetRegValues;
        String billId = budgetParam.bill.getPkValue().toString();
        String controlTarget = budgetParam.regBillInfo.getString("controltarget");
        BudgetControlTargetEnum controlTargetEnum = BudgetControlTargetEnum.getEnumByValue((Object)controlTarget);
        HashMap<String, BigDecimal> proTotalAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> budgetTotalAmtMap = new HashMap<String, BigDecimal>(16);
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            boolean budgetCtrl;
            boolean isProCostControl;
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project)) || !(budgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl(Long.valueOf(project.getPkValue().toString())))) continue;
            BigDecimal amount = budgetRegValue.getAmountValue();
            BigDecimal proTotalAmt = (BigDecimal)proTotalAmtMap.get(project.getPkValue().toString());
            if (proTotalAmt == null) {
                proTotalAmt = BigDecimal.ZERO;
            }
            proTotalAmtMap.put(project.getPkValue().toString(), proTotalAmt.add(amount));
            DynamicObject budget = budgetRegValue.getBudgetValue();
            if (budget == null) continue;
            BigDecimal budgetTotalAmt = (BigDecimal)budgetTotalAmtMap.get(budget.getPkValue().toString());
            if (budgetTotalAmt == null) {
                budgetTotalAmt = BigDecimal.ZERO;
            }
            budgetTotalAmtMap.put(budget.getPkValue().toString(), budgetTotalAmt.add(amount));
        }
        HashMap<String, BigDecimal> proPreOccupyAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> budgetPreOccupyAmtMap = new HashMap<String, BigDecimal>(16);
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            DynamicObject totalBudgetCtrlDetail;
            DynamicObject budget;
            boolean budgetCtrl;
            boolean isProCostControl;
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project)) || !(budgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl(Long.valueOf(project.getPkValue().toString())))) continue;
            String budgetType = budgetRegValue.getBudgetTypeValue().getValue();
            BigDecimal amount = budgetRegValue.getAmountValue();
            QFilter filter = new QFilter("tproject", "=", project.getPkValue()).and("tbudgettype", "=", (Object)budgetType);
            DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{filter});
            if (totalBudgetCtrl != null) {
                BigDecimal newPreOccupyAmount = totalBudgetCtrl.getBigDecimal("tpreoccupyamt");
                BigDecimal proTotalAmt = proTotalAmtMap.get(project.getPkValue().toString()) == null ? BigDecimal.ZERO : (BigDecimal)proTotalAmtMap.get(project.getPkValue().toString());
                BigDecimal lastOpAmount = this.getLastOpAmount(billId, null, controlTargetEnum.getValue(), project);
                if (lastOpAmount.compareTo(proTotalAmt) != 0) {
                    BigDecimal proPreOccupyAmt = (BigDecimal)proPreOccupyAmtMap.get(project.getPkValue().toString());
                    if (proPreOccupyAmt == null) {
                        newPreOccupyAmount = newPreOccupyAmount.subtract(lastOpAmount);
                        proPreOccupyAmtMap.put(project.getPkValue().toString(), newPreOccupyAmount);
                    }
                } else {
                    newPreOccupyAmount = newPreOccupyAmount.subtract(amount);
                }
                totalBudgetCtrl.set("tpreoccupyamt", (Object)newPreOccupyAmount);
                BigDecimal occupyAmt = totalBudgetCtrl.getBigDecimal("toccupyamt");
                BigDecimal newOccupyAmt = occupyAmt.add(amount);
                totalBudgetCtrl.set("toccupyamt", (Object)newOccupyAmt);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrl});
            }
            if ((budget = budgetRegValue.getBudgetValue()) != null && (totalBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue())})) != null) {
                BigDecimal newSumPreOccupyAmt = totalBudgetCtrlDetail.getBigDecimal("preoccupyamt");
                BigDecimal budgetTotalAmt = budgetTotalAmtMap.get(budget.getPkValue().toString()) == null ? BigDecimal.ZERO : (BigDecimal)budgetTotalAmtMap.get(budget.getPkValue().toString());
                BigDecimal lastOpAmount = this.getLastOpAmount(billId, budget, controlTargetEnum.getValue(), project);
                if (lastOpAmount.compareTo(budgetTotalAmt) != 0) {
                    BigDecimal budgetPreOccupyAmt = (BigDecimal)budgetPreOccupyAmtMap.get(budget.getPkValue().toString());
                    if (budgetPreOccupyAmt == null) {
                        newSumPreOccupyAmt = newSumPreOccupyAmt.subtract(lastOpAmount);
                        budgetPreOccupyAmtMap.put(budget.getPkValue().toString(), newSumPreOccupyAmt);
                    }
                } else {
                    newSumPreOccupyAmt = newSumPreOccupyAmt.subtract(amount);
                }
                totalBudgetCtrlDetail.set("preoccupyamt", (Object)newSumPreOccupyAmt);
                BigDecimal sumOccupyAmt = totalBudgetCtrlDetail.getBigDecimal("occupyamt");
                BigDecimal newSumOccupyAmt = sumOccupyAmt.add(amount);
                totalBudgetCtrlDetail.set("occupyamt", (Object)newSumOccupyAmt);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrlDetail});
            }
            this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.EXEC_OPERATION, BudgetControlTypeEnum.TAKEOPERATION);
        }
    }

    @Override
    public void occupyReturn(BudgetParam budgetParam) {
        List budgetRegValues = budgetParam.budgetRegValues;
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            DynamicObject totalBudgetCtrlDetail;
            DynamicObject budget;
            boolean budgetCtrl;
            boolean isProCostControl;
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project)) || !(budgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl(Long.valueOf(project.getPkValue().toString())))) continue;
            String budgetType = budgetRegValue.getBudgetTypeValue().getValue();
            BigDecimal amount = budgetRegValue.getAmountValue();
            QFilter filter = new QFilter("tproject", "=", project.getPkValue()).and("tbudgettype", "=", (Object)budgetType);
            DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{filter});
            if (totalBudgetCtrl != null) {
                BigDecimal preOccupyAmt = totalBudgetCtrl.getBigDecimal("tpreoccupyamt");
                BigDecimal newPreOccupyAmount = preOccupyAmt.add(amount);
                totalBudgetCtrl.set("tpreoccupyamt", (Object)newPreOccupyAmount);
                BigDecimal occupyAmt = totalBudgetCtrl.getBigDecimal("toccupyamt");
                BigDecimal newOccupyAmt = occupyAmt.subtract(amount);
                totalBudgetCtrl.set("toccupyamt", (Object)newOccupyAmt);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrl});
            }
            if ((budget = budgetRegValue.getBudgetValue()) != null && (totalBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue())})) != null) {
                BigDecimal sumPreOccupyAmt = totalBudgetCtrlDetail.getBigDecimal("preoccupyamt");
                BigDecimal newSumPreOccupyAmt = sumPreOccupyAmt.add(amount);
                totalBudgetCtrlDetail.set("preoccupyamt", (Object)newSumPreOccupyAmt);
                BigDecimal sumOccupyAmt = totalBudgetCtrlDetail.getBigDecimal("occupyamt");
                BigDecimal newSumOccupyAmt = sumOccupyAmt.subtract(amount);
                totalBudgetCtrlDetail.set("occupyamt", (Object)newSumOccupyAmt);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrlDetail});
            }
            this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.RETURN_OPERATION, BudgetControlTypeEnum.TAKEOPERATION);
        }
    }

    @Override
    public void occupyRelease(BudgetParam budgetParam) {
        List budgetRegValues = budgetParam.budgetRegValues;
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            DynamicObject totalBudgetCtrlDetail;
            DynamicObject budget;
            boolean budgetCtrl;
            boolean isProCostControl;
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project)) || !(budgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl(Long.valueOf(project.getPkValue().toString())))) continue;
            String budgetType = budgetRegValue.getBudgetTypeValue().getValue();
            BigDecimal amount = budgetRegValue.getAmountValue();
            QFilter filter = new QFilter("tproject", "=", project.getPkValue()).and("tbudgettype", "=", (Object)budgetType);
            DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{filter});
            if (totalBudgetCtrl != null) {
                BigDecimal preOccupyAmt = totalBudgetCtrl.getBigDecimal("tpreoccupyamt");
                BigDecimal newPreOccupyAmt = preOccupyAmt.subtract(amount);
                totalBudgetCtrl.set("tpreoccupyamt", (Object)newPreOccupyAmt);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrl});
            }
            if ((budget = budgetRegValue.getBudgetValue()) != null && (totalBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue())})) != null) {
                BigDecimal sumPreOccupyAmt = totalBudgetCtrlDetail.getBigDecimal("preoccupyamt");
                BigDecimal newSumPreOccupyAmt = sumPreOccupyAmt.subtract(amount);
                totalBudgetCtrlDetail.set("preoccupyamt", (Object)newSumPreOccupyAmt);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrlDetail});
            }
            this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.CLEAR_OPERATION, BudgetControlTypeEnum.TAKEOPERATION);
        }
    }

    @Override
    public void executeOccupy(BudgetParam budgetParam) {
        List budgetRegValues = budgetParam.budgetRegValues;
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            boolean budgetCtrl;
            boolean isProCostControl;
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project)) || !(budgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl(Long.valueOf(project.getPkValue().toString())))) continue;
            String budgetType = budgetRegValue.getBudgetTypeValue().getValue();
            BigDecimal amount = budgetRegValue.getAmountValue();
            Date bizDate = budgetRegValue.getBizDateValue();
            if (bizDate == null) continue;
            Instant instant = bizDate.toInstant();
            ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
            int year = zonedDateTime.getYear();
            int lastYear = year - 1;
            QFilter filter = new QFilter("tproject", "=", project.getPkValue()).and("tbudgettype", "=", (Object)budgetType);
            DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{filter});
            if (totalBudgetCtrl != null) {
                BigDecimal preOccupyUsageAmt = totalBudgetCtrl.getBigDecimal("tpreoccupyusageamt");
                BigDecimal newPreOccupyUsageAmt = preOccupyUsageAmt.add(amount);
                totalBudgetCtrl.set("tpreoccupyusageamt", (Object)newPreOccupyUsageAmt);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrl});
            }
            ProBudgetCtrlEnums proBudgetCtrl = ProBudgetControlHelper.getProjectBudgetControlType(project);
            DynamicObject budget = budgetRegValue.getBudgetValue();
            if (budget == null) {
                filter = new QFilter("yproject", "=", project.getPkValue()).and("ybudgettype", "=", (Object)budgetType).and("YEAR(yyear)", "=", (Object)year);
                DynamicObject yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{filter});
                if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue())) {
                    zonedDateTime = zonedDateTime.minusYears(1L);
                    filter = new QFilter("yproject", "=", project.getPkValue()).and("ybudgettype", "=", (Object)budgetType).and("YEAR(yyear)", "=", (Object)lastYear);
                    DynamicObject lastYearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{filter});
                    if (lastYearBudgetCtrl != null) {
                        BigDecimal lastYearBudgetAmt = lastYearBudgetCtrl.getBigDecimal("ybudgetamt");
                        BigDecimal lastYearPreUsageAmt = lastYearBudgetCtrl.getBigDecimal("ypreoccupyusageamt");
                        BigDecimal lastYearUsageAmt = lastYearBudgetCtrl.getBigDecimal("yusageamt");
                        BigDecimal lastYearAvailableBalance = lastYearBudgetAmt.subtract(lastYearPreUsageAmt).subtract(lastYearUsageAmt);
                        if (lastYearAvailableBalance.compareTo(amount) > 0) {
                            lastYearBudgetCtrl.set("ypreoccupyusageamt", (Object)lastYearPreUsageAmt.add(amount));
                            budgetRegValue.setBizDateValue(Date.from(zonedDateTime.toInstant()));
                            this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
                        } else {
                            if (lastYearAvailableBalance.compareTo(BigDecimal.ZERO) > 0) {
                                lastYearBudgetCtrl.set("ypreoccupyusageamt", (Object)lastYearBudgetAmt);
                                budgetRegValue.setBizDateValue(Date.from(zonedDateTime.toInstant()));
                                budgetRegValue.setAmountValue(lastYearAvailableBalance);
                                this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
                            }
                            if (yearBudgetCtrl != null) {
                                BigDecimal yearPreOccupyUsageAmt = yearBudgetCtrl.getBigDecimal("ypreoccupyusageamt");
                                BigDecimal diffAmt = amount.subtract(lastYearAvailableBalance);
                                BigDecimal newYearPreOccupyUsageAmt = yearPreOccupyUsageAmt.add(diffAmt);
                                yearBudgetCtrl.set("ypreoccupyusageamt", (Object)newYearPreOccupyUsageAmt);
                                budgetRegValue.setAmountValue(diffAmt);
                                budgetRegValue.setBizDateValue(bizDate);
                                this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
                            }
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{lastYearBudgetCtrl});
                    } else if (yearBudgetCtrl != null) {
                        BigDecimal yearPreOccupyUsageAmt = yearBudgetCtrl.getBigDecimal("ypreoccupyusageamt");
                        BigDecimal newYearPreOccupyUsageAmt = yearPreOccupyUsageAmt.add(amount);
                        yearBudgetCtrl.set("ypreoccupyusageamt", (Object)newYearPreOccupyUsageAmt);
                        this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
                    }
                } else if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue())) {
                    if (yearBudgetCtrl != null) {
                        BigDecimal yearPreOccupyUsageAmt = yearBudgetCtrl.getBigDecimal("ypreoccupyusageamt");
                        BigDecimal newYearPreOccupyUsageAmt = yearPreOccupyUsageAmt.add(amount);
                        yearBudgetCtrl.set("ypreoccupyusageamt", (Object)newYearPreOccupyUsageAmt);
                        this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
                    }
                } else {
                    this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
                }
                if (yearBudgetCtrl != null) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yearBudgetCtrl});
                }
            }
            if (budget == null) continue;
            filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue());
            DynamicObject tBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{filter});
            if (tBudgetCtrlDetail != null) {
                BigDecimal tPreOccupyUsageAmt = tBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                BigDecimal newTPreOccupyUsageAmt = tPreOccupyUsageAmt.add(amount);
                tBudgetCtrlDetail.set("preoccupyusageamt", (Object)newTPreOccupyUsageAmt);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tBudgetCtrlDetail});
            }
            filter = new QFilter("yproject", "=", project.getPkValue()).and("ybudgettype", "=", (Object)budgetType).and("YEAR(yyear)", "=", (Object)year);
            DynamicObject yBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{filter});
            filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue()).and("YEAR(year)", "=", (Object)year);
            DynamicObject yBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrldetail", (QFilter[])new QFilter[]{filter});
            if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue())) {
                zonedDateTime = zonedDateTime.minusYears(1L);
                filter = new QFilter("yproject", "=", project.getPkValue()).and("ybudgettype", "=", (Object)budgetType).and("YEAR(yyear)", "=", (Object)lastYear);
                DynamicObject lastYearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{filter});
                filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue()).and("YEAR(year)", "=", (Object)lastYear);
                DynamicObject lastYearBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrldetail", (QFilter[])new QFilter[]{filter});
                if (lastYearBudgetCtrlDetail != null) {
                    BigDecimal preOccupyUseAmt;
                    BigDecimal lastYearBudgetAmt = lastYearBudgetCtrlDetail.getBigDecimal("budgetamt");
                    BigDecimal lastYearPreUsageAmt = lastYearBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                    BigDecimal lastYearUsageAmt = lastYearBudgetCtrlDetail.getBigDecimal("usageamt");
                    BigDecimal lastYearAvailableBalance = lastYearBudgetAmt.subtract(lastYearPreUsageAmt).subtract(lastYearUsageAmt);
                    if (lastYearAvailableBalance.compareTo(amount) > 0) {
                        lastYearBudgetCtrlDetail.set("preoccupyusageamt", (Object)lastYearPreUsageAmt.add(amount));
                        if (lastYearBudgetCtrl != null) {
                            preOccupyUseAmt = lastYearBudgetCtrl.getBigDecimal("ypreoccupyusageamt").add(amount);
                            lastYearBudgetCtrl.set("ypreoccupyusageamt", (Object)preOccupyUseAmt);
                        }
                        budgetRegValue.setBizDateValue(Date.from(zonedDateTime.toInstant()));
                        this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
                    } else {
                        if (lastYearAvailableBalance.compareTo(BigDecimal.ZERO) > 0) {
                            lastYearBudgetCtrlDetail.set("preoccupyusageamt", (Object)lastYearAvailableBalance);
                            if (lastYearBudgetCtrl != null) {
                                preOccupyUseAmt = lastYearBudgetCtrl.getBigDecimal("ypreoccupyusageamt").add(lastYearAvailableBalance);
                                lastYearBudgetCtrl.set("ypreoccupyusageamt", (Object)preOccupyUseAmt);
                            }
                            budgetRegValue.setBizDateValue(Date.from(zonedDateTime.toInstant()));
                            budgetRegValue.setAmountValue(lastYearAvailableBalance);
                            this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
                        }
                        BigDecimal diffAmt = amount.subtract(lastYearAvailableBalance);
                        if (yBudgetCtrlDetail != null) {
                            BigDecimal newYearBudgetCtrlDetailPreUsageAmt = yBudgetCtrlDetail.getBigDecimal("preoccupyusageamt").add(diffAmt);
                            yBudgetCtrlDetail.set("preoccupyusageamt", (Object)newYearBudgetCtrlDetailPreUsageAmt);
                        }
                        if (yBudgetCtrl != null) {
                            BigDecimal newYBudgetCtrlPreUsageAmt = yBudgetCtrl.getBigDecimal("ypreoccupyusageamt").add(diffAmt);
                            yBudgetCtrl.set("ypreoccupyusageamt", (Object)newYBudgetCtrlPreUsageAmt);
                        }
                        budgetRegValue.setAmountValue(diffAmt);
                        budgetRegValue.setBizDateValue(bizDate);
                        this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{lastYearBudgetCtrlDetail});
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{lastYearBudgetCtrl});
                } else {
                    if (yBudgetCtrlDetail != null) {
                        BigDecimal yearBudgetCtrlDetailPreUsageAmt = yBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                        BigDecimal newYearBudgetCtrlDetailPreUsageAmt = yearBudgetCtrlDetailPreUsageAmt.add(amount);
                        yBudgetCtrlDetail.set("preoccupyusageamt", (Object)newYearBudgetCtrlDetailPreUsageAmt);
                    }
                    if (yBudgetCtrl != null) {
                        BigDecimal newYBudgetCtrlPreUsageAmt = yBudgetCtrl.getBigDecimal("ypreoccupyusageamt").add(amount);
                        yBudgetCtrl.set("ypreoccupyusageamt", (Object)newYBudgetCtrlPreUsageAmt);
                    }
                    this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
                }
            } else if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue())) {
                if (yBudgetCtrlDetail != null) {
                    BigDecimal yearBudgetCtrlDetailPreUsageAmt = yBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                    BigDecimal newYearBudgetCtrlDetailPreUsageAmt = yearBudgetCtrlDetailPreUsageAmt.add(amount);
                    yBudgetCtrlDetail.set("preoccupyusageamt", (Object)newYearBudgetCtrlDetailPreUsageAmt);
                }
                if (yBudgetCtrl != null) {
                    BigDecimal newYBudgetCtrlPreUsageAmt = yBudgetCtrl.getBigDecimal("ypreoccupyusageamt").add(amount);
                    yBudgetCtrl.set("ypreoccupyusageamt", (Object)newYBudgetCtrlPreUsageAmt);
                }
                this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
            } else {
                this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.TAKE_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
            }
            if (yBudgetCtrlDetail != null) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yBudgetCtrlDetail});
            }
            if (yBudgetCtrl == null) continue;
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yBudgetCtrl});
        }
    }

    @Override
    public void executeEffect(BudgetParam budgetParam) {
        String ctrlTarget = budgetParam.regBillInfo.getString("controltarget");
        BudgetControlTargetEnum ctrlTargetEnum = BudgetControlTargetEnum.getEnumByValue((Object)ctrlTarget);
        List budgetRegValues = budgetParam.budgetRegValues;
        HashMap<String, BigDecimal> curBillTotalAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> budgetAmtMap = new HashMap<String, BigDecimal>(16);
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            boolean budgetCtrl;
            boolean isProCostControl;
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project)) || !(budgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl(Long.valueOf(project.getPkValue().toString())))) continue;
            DynamicObject[] amount = budgetRegValue.getAmountValue();
            BigDecimal curBillTotalAmt = (BigDecimal)curBillTotalAmtMap.get(project.getPkValue().toString());
            if (curBillTotalAmt == null) {
                curBillTotalAmt = BigDecimal.ZERO;
            }
            curBillTotalAmtMap.put(project.getPkValue().toString(), curBillTotalAmt.add((BigDecimal)amount));
            DynamicObject budget = budgetRegValue.getBudgetValue();
            if (budget == null) continue;
            BigDecimal budgetAmt = (BigDecimal)budgetAmtMap.get(budget.getPkValue().toString());
            if (budgetAmt == null) {
                budgetAmt = BigDecimal.ZERO;
            }
            budgetAmtMap.put(budget.getPkValue().toString(), budgetAmt.add((BigDecimal)amount));
        }
        QFilter filter = new QFilter("billid", "=", (Object)budgetParam.bill.getPkValue().toString()).and("opaction", "=", (Object)BillFieldTypeEnum.TAKE_OPERATION.getNumber()).and("iseffect", "=", (Object)true).and("optype", "=", (Object)ctrlTarget).and("controltype", "=", (Object)BudgetControlTypeEnum.EXECOPERATION.getValue());
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)"", (QFilter[])new QFilter[]{filter});
        if (records.length > 0) {
            DynamicObject[] recordList = BusinessDataServiceHelper.load((Object[])Arrays.stream(records).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_budgetexerecord"));
            HashMap<String, BigDecimal> recordTotalAmtMap = new HashMap<String, BigDecimal>(16);
            HashMap<String, BigDecimal> recordBudgetAmtMap = new HashMap<String, BigDecimal>(16);
            for (DynamicObject record : recordList) {
                boolean isProCostControl;
                DynamicObject project = record.getDynamicObject("project");
                if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project))) continue;
                BigDecimal amount = record.getBigDecimal("amount");
                BigDecimal recordTotalAmt = (BigDecimal)recordTotalAmtMap.get(project.getPkValue().toString());
                if (recordTotalAmt == null) {
                    recordTotalAmt = BigDecimal.ZERO;
                }
                recordTotalAmtMap.put(project.getPkValue().toString(), recordTotalAmt.add(amount));
                DynamicObject budget = record.getDynamicObject("probudget");
                if (budget == null) continue;
                BigDecimal recordBudgetAmt = (BigDecimal)recordBudgetAmtMap.get(budget.getPkValue().toString());
                if (recordBudgetAmt == null) {
                    recordBudgetAmt = BigDecimal.ZERO;
                }
                recordBudgetAmtMap.put(budget.getPkValue().toString(), recordBudgetAmt.add(amount));
            }
            HashMap<String, BigDecimal> proUseAmtMap = new HashMap<String, BigDecimal>(16);
            HashMap<String, BigDecimal> budUseAmtMap = new HashMap<String, BigDecimal>(16);
            HashMap<String, BigDecimal> yProUseAmtMap = new HashMap<String, BigDecimal>(16);
            HashMap<String, BigDecimal> yBudUseAmtMap = new HashMap<String, BigDecimal>(16);
            for (DynamicObject record : recordList) {
                DynamicObject budget;
                DynamicObject yearBudgetCtrl;
                boolean isProCostControl;
                String budgetType = record.getString("budgettype");
                DynamicObject project = record.getDynamicObject("project");
                if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project))) continue;
                ProBudgetCtrlEnums proBudgetCtrl = ProBudgetControlHelper.getProjectBudgetControlType(project);
                BigDecimal amount = record.getBigDecimal("amount");
                Date bizDate = record.getDate("bizdate");
                if (bizDate == null) continue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(bizDate);
                int year = calendar.get(1);
                filter = new QFilter("tproject", "=", project.getPkValue()).and("tbudgettype", "=", (Object)budgetType);
                DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{filter});
                if (totalBudgetCtrl != null) {
                    BigDecimal tPreOccupyUsageAmt = totalBudgetCtrl.getBigDecimal("tpreoccupyusageamt");
                    BigDecimal newTPreOccupyUsageAmt = tPreOccupyUsageAmt.subtract(amount);
                    totalBudgetCtrl.set("tpreoccupyusageamt", (Object)newTPreOccupyUsageAmt);
                    BigDecimal newTUsageAmt = totalBudgetCtrl.getBigDecimal("tusageamt");
                    BigDecimal newTOccupyAmt = totalBudgetCtrl.getBigDecimal("toccupyamt");
                    BigDecimal curBillTotalAmt = (BigDecimal)curBillTotalAmtMap.get(project.getPkValue().toString());
                    BigDecimal recordTotalAmt = (BigDecimal)recordTotalAmtMap.get(project.getPkValue().toString());
                    if (curBillTotalAmt != null && recordTotalAmt != null && curBillTotalAmt.compareTo(recordTotalAmt) != 0) {
                        BigDecimal proUseAmt = (BigDecimal)proUseAmtMap.get(project.getPkValue().toString());
                        if (proUseAmt == null) {
                            newTUsageAmt = newTUsageAmt.add(curBillTotalAmt);
                            if (StringUtils.equals((CharSequence)BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue(), (CharSequence)ctrlTargetEnum.getValue())) {
                                newTOccupyAmt = newTOccupyAmt.add(curBillTotalAmt.subtract(recordTotalAmt));
                            }
                            proUseAmtMap.put(project.getPkValue().toString(), curBillTotalAmt);
                        }
                    } else {
                        newTUsageAmt = newTUsageAmt.add(amount);
                    }
                    totalBudgetCtrl.set("toccupyamt", (Object)newTOccupyAmt);
                    totalBudgetCtrl.set("tusageamt", (Object)newTUsageAmt);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrl});
                }
                if (!proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue()) && (yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{filter = new QFilter("yproject", "=", project.getPkValue()).and("ybudgettype", "=", (Object)budgetType).and("YEAR(yyear)", "=", (Object)year)})) != null) {
                    BigDecimal yearPreOccupyUsageAmt = yearBudgetCtrl.getBigDecimal("ypreoccupyusageamt");
                    yearBudgetCtrl.set("ypreoccupyusageamt", (Object)yearPreOccupyUsageAmt.subtract(amount));
                    BigDecimal newYearUsageAmt = yearBudgetCtrl.getBigDecimal("yusageamt");
                    if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue())) {
                        newYearUsageAmt = newYearUsageAmt.add(amount);
                    } else {
                        BigDecimal curBillTotalAmt = (BigDecimal)curBillTotalAmtMap.get(project.getPkValue().toString());
                        BigDecimal recordTotalAmt = (BigDecimal)recordTotalAmtMap.get(project.getPkValue().toString());
                        if (curBillTotalAmt != null && recordTotalAmt != null && curBillTotalAmt.compareTo(recordTotalAmt) != 0) {
                            BigDecimal yProUseAmt = (BigDecimal)yProUseAmtMap.get(project.getPkValue().toString());
                            if (yProUseAmt == null) {
                                newYearUsageAmt = newYearUsageAmt.add(curBillTotalAmt);
                                yProUseAmtMap.put(project.getPkValue().toString(), curBillTotalAmt);
                            }
                        } else {
                            newYearUsageAmt = newYearUsageAmt.add(amount);
                        }
                    }
                    yearBudgetCtrl.set("yusageamt", (Object)newYearUsageAmt);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yearBudgetCtrl});
                }
                if ((budget = record.getDynamicObject("probudget")) != null) {
                    DynamicObject yBudgetCtrlDetail;
                    BigDecimal recordBudgetAmt;
                    BigDecimal budgetAmt;
                    filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue());
                    DynamicObject tBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{filter});
                    if (tBudgetCtrlDetail != null) {
                        BigDecimal tBudgetCtrlDetailPreOccupyUsageAmt = tBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                        BigDecimal newTBudgetCtrlDetailPreOccupyUsageAmt = tBudgetCtrlDetailPreOccupyUsageAmt.subtract(amount);
                        tBudgetCtrlDetail.set("preoccupyusageamt", (Object)newTBudgetCtrlDetailPreOccupyUsageAmt);
                        BigDecimal newTBudgetCtrlDetailUsageAmt = tBudgetCtrlDetail.getBigDecimal("usageamt");
                        BigDecimal newOccupyAmt = tBudgetCtrlDetail.getBigDecimal("occupyamt");
                        budgetAmt = (BigDecimal)budgetAmtMap.get(budget.getPkValue().toString());
                        recordBudgetAmt = (BigDecimal)recordBudgetAmtMap.get(budget.getPkValue().toString());
                        if (budgetAmt != null && recordBudgetAmt != null && budgetAmt.compareTo(recordBudgetAmt) != 0) {
                            BigDecimal budUseAmt = (BigDecimal)budUseAmtMap.get(budget.getPkValue().toString());
                            if (budUseAmt == null) {
                                newTBudgetCtrlDetailUsageAmt = newTBudgetCtrlDetailUsageAmt.add(budgetAmt);
                                if (StringUtils.equals((CharSequence)BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue(), (CharSequence)ctrlTargetEnum.getValue())) {
                                    newOccupyAmt = newOccupyAmt.add(budgetAmt.subtract(recordBudgetAmt));
                                }
                                budUseAmtMap.put(budget.getPkValue().toString(), budgetAmt);
                            }
                        } else {
                            newTBudgetCtrlDetailUsageAmt = newTBudgetCtrlDetailUsageAmt.add(amount);
                        }
                        tBudgetCtrlDetail.set("occupyamt", (Object)newOccupyAmt);
                        tBudgetCtrlDetail.set("usageamt", (Object)newTBudgetCtrlDetailUsageAmt);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tBudgetCtrlDetail});
                    }
                    if (!proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue()) && (yBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrldetail", (QFilter[])new QFilter[]{filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue()).and("YEAR(year)", "=", (Object)year)})) != null) {
                        BigDecimal yBudgetCtrlDetailPreOccupyUsageAmt = yBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                        BigDecimal newYBudgetCtrlDetailPreOccupyUsageAmt = yBudgetCtrlDetailPreOccupyUsageAmt.subtract(amount);
                        yBudgetCtrlDetail.set("preoccupyusageamt", (Object)newYBudgetCtrlDetailPreOccupyUsageAmt);
                        BigDecimal newYBudgetCtrlDetailUsageAmt = yBudgetCtrlDetail.getBigDecimal("usageamt");
                        if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue())) {
                            newYBudgetCtrlDetailUsageAmt = newYBudgetCtrlDetailUsageAmt.add(amount);
                        } else {
                            budgetAmt = (BigDecimal)budgetAmtMap.get(budget.getPkValue().toString());
                            recordBudgetAmt = (BigDecimal)recordBudgetAmtMap.get(budget.getPkValue().toString());
                            if (budgetAmt != null && recordBudgetAmt != null && budgetAmt.compareTo(recordBudgetAmt) != 0) {
                                BigDecimal yBudUseAmt = (BigDecimal)yBudUseAmtMap.get(budget.getPkValue().toString());
                                if (yBudUseAmt == null) {
                                    newYBudgetCtrlDetailUsageAmt = newYBudgetCtrlDetailUsageAmt.add(budgetAmt);
                                    yBudUseAmtMap.put(budget.getPkValue().toString(), budgetAmt);
                                }
                            } else {
                                newYBudgetCtrlDetailUsageAmt = newYBudgetCtrlDetailUsageAmt.add(amount);
                            }
                        }
                        yBudgetCtrlDetail.set("usageamt", (Object)newYBudgetCtrlDetailUsageAmt);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yBudgetCtrlDetail});
                    }
                }
                this.updateRecordIsEffectStatus(budgetParam.bill, BudgetControlTargetEnum.BUDGETUSE, BillFieldTypeEnum.EXEC_OPERATION);
            }
        }
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            boolean budgetCtrl;
            boolean isProCostControl;
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project)) || !(budgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl(Long.valueOf(project.getPkValue().toString())))) continue;
            this.logBudgetRecord(budgetParam, budgetRegValue, BillFieldTypeEnum.EXEC_OPERATION, BudgetControlTypeEnum.EXECOPERATION);
        }
    }

    @Override
    public void executeReturn(BudgetParam budgetParam) {
        String ctrlTarget = budgetParam.regBillInfo.getString("controltarget");
        QFilter filter = new QFilter("billid", "=", (Object)budgetParam.bill.getPkValue().toString()).and("opaction", "=", (Object)BillFieldTypeEnum.EXEC_OPERATION.getNumber()).and("iseffect", "=", (Object)true).and("optype", "=", (Object)ctrlTarget).and("controltype", "=", (Object)BudgetControlTypeEnum.EXECOPERATION.getValue());
        ArrayList<DynamicObject> newRecordList = new ArrayList<DynamicObject>(10);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)"", (QFilter[])new QFilter[]{filter});
        if (records.length > 0) {
            DynamicObject[] recordList = BusinessDataServiceHelper.load((Object[])Arrays.stream(records).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_budgetexerecord"));
            CloneUtils cloneUtils = new CloneUtils(true, true);
            for (DynamicObject record : recordList) {
                DynamicObject budget;
                DynamicObject yearBudgetCtrl;
                boolean isProCostControl;
                String budgetType = record.getString("budgettype");
                DynamicObject project = record.getDynamicObject("project");
                if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project))) continue;
                ProBudgetCtrlEnums proBudgetCtrl = ProBudgetControlHelper.getProjectBudgetControlType(project);
                BigDecimal amount = record.getBigDecimal("amount");
                Date bizDate = record.getDate("bizdate");
                if (bizDate == null) continue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(bizDate);
                int year = calendar.get(1);
                filter = new QFilter("tproject", "=", project.getPkValue()).and("tbudgettype", "=", (Object)budgetType);
                DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{filter});
                if (totalBudgetCtrl != null) {
                    BigDecimal tUsageAmt = totalBudgetCtrl.getBigDecimal("tusageamt");
                    BigDecimal tPreOccupyUsageAmt = totalBudgetCtrl.getBigDecimal("tpreoccupyusageamt");
                    BigDecimal newTUsageAmt = tUsageAmt.subtract(amount);
                    BigDecimal newTPreOccupyUsageAmt = tPreOccupyUsageAmt.add(amount);
                    totalBudgetCtrl.set("tusageamt", (Object)newTUsageAmt);
                    totalBudgetCtrl.set("tpreoccupyusageamt", (Object)newTPreOccupyUsageAmt);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrl});
                }
                if (!proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue()) && (yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{filter = new QFilter("yproject", "=", project.getPkValue()).and("ybudgettype", "=", (Object)budgetType).and("YEAR(yyear)", "=", (Object)year)})) != null) {
                    BigDecimal yUsageAmt = yearBudgetCtrl.getBigDecimal("yusageamt");
                    BigDecimal yPreOccupyUsageAmt = yearBudgetCtrl.getBigDecimal("ypreoccupyusageamt");
                    BigDecimal newYUsageAmt = yUsageAmt.subtract(amount);
                    BigDecimal newYPreOccupyUsageAmt = yPreOccupyUsageAmt.add(amount);
                    yearBudgetCtrl.set("yusageamt", (Object)newYUsageAmt);
                    yearBudgetCtrl.set("ypreoccupyusageamt", (Object)newYPreOccupyUsageAmt);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yearBudgetCtrl});
                }
                if ((budget = record.getDynamicObject("probudget")) != null) {
                    DynamicObject yBudgetCtrlDetail;
                    filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue());
                    DynamicObject tBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{filter});
                    if (tBudgetCtrlDetail != null) {
                        BigDecimal tBudgetCtrlDetailPreOccupyUsageAmt = tBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                        BigDecimal tBudgetCtrlDetailUsageAmt = tBudgetCtrlDetail.getBigDecimal("usageamt");
                        BigDecimal newTBudgetCtrlDetailPreOccupyUsageAmt = tBudgetCtrlDetailPreOccupyUsageAmt.add(amount);
                        BigDecimal newTBudgetCtrlDetailUsageAmt = tBudgetCtrlDetailUsageAmt.subtract(amount);
                        tBudgetCtrlDetail.set("preoccupyusageamt", (Object)newTBudgetCtrlDetailPreOccupyUsageAmt);
                        tBudgetCtrlDetail.set("usageamt", (Object)newTBudgetCtrlDetailUsageAmt);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tBudgetCtrlDetail});
                    }
                    if (!proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue()) && (yBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrldetail", (QFilter[])new QFilter[]{filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue()).and("YEAR(year)", "=", (Object)year)})) != null) {
                        BigDecimal yBudgetCtrlDetailPreOccupyUsageAmt = yBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                        BigDecimal yBudgetCtrlDetailUsageAmt = yBudgetCtrlDetail.getBigDecimal("usageamt");
                        BigDecimal newYBudgetCtrlDetailPreOccupyUsageAmt = yBudgetCtrlDetailPreOccupyUsageAmt.add(amount);
                        BigDecimal newYBudgetCtrlDetailUsageAmt = yBudgetCtrlDetailUsageAmt.subtract(amount);
                        yBudgetCtrlDetail.set("preoccupyusageamt", (Object)newYBudgetCtrlDetailPreOccupyUsageAmt);
                        yBudgetCtrlDetail.set("usageamt", (Object)newYBudgetCtrlDetailUsageAmt);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yBudgetCtrlDetail});
                    }
                }
                Date opTime = new Date();
                DynamicObject newRecord = (DynamicObject)cloneUtils.clone((IDataEntityBase)record);
                newRecord.set("opaction", (Object)BillFieldTypeEnum.RETURN_OPERATION.getNumber());
                newRecord.set("optime", (Object)opTime);
                newRecordList.add(newRecord);
                this.updateRecordIsEffectStatus(budgetParam.bill, BudgetControlTargetEnum.BUDGETUSE, BillFieldTypeEnum.RETURN_OPERATION);
            }
        }
        SaveServiceHelper.save((DynamicObject[])newRecordList.toArray(new DynamicObject[0]));
    }

    @Override
    public void executeRelease(BudgetParam budgetParam) {
        String ctrlTarget = budgetParam.regBillInfo.getString("controltarget");
        QFilter filter = new QFilter("billid", "=", (Object)budgetParam.bill.getPkValue().toString()).and("opaction", "=", (Object)BillFieldTypeEnum.TAKE_OPERATION.getNumber()).and("iseffect", "=", (Object)true).and("optype", "=", (Object)ctrlTarget).and("controltype", "=", (Object)BudgetControlTypeEnum.EXECOPERATION.getValue());
        ArrayList<DynamicObject> newRecordList = new ArrayList<DynamicObject>(10);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)"", (QFilter[])new QFilter[]{filter});
        if (records.length > 0) {
            DynamicObject[] recordList = BusinessDataServiceHelper.load((Object[])Arrays.stream(records).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_budgetexerecord"));
            CloneUtils cloneUtils = new CloneUtils(true, true);
            for (DynamicObject record : recordList) {
                DynamicObject budget;
                DynamicObject yearBudgetCtrl;
                boolean isProCostControl;
                String budgetType = record.getString("budgettype");
                DynamicObject project = record.getDynamicObject("project");
                if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project))) continue;
                ProBudgetCtrlEnums proBudgetCtrl = ProBudgetControlHelper.getProjectBudgetControlType(project);
                BigDecimal amount = record.getBigDecimal("amount");
                Date bizDate = record.getDate("bizdate");
                if (bizDate == null) continue;
                Instant instant = bizDate.toInstant();
                ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
                int year = zonedDateTime.getYear();
                filter = new QFilter("tproject", "=", project.getPkValue()).and("tbudgettype", "=", (Object)budgetType);
                DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{filter});
                if (totalBudgetCtrl != null) {
                    BigDecimal tPreOccupyUsageAmt = totalBudgetCtrl.getBigDecimal("tpreoccupyusageamt");
                    BigDecimal newTPreOccupyUsageAmt = tPreOccupyUsageAmt.subtract(amount);
                    totalBudgetCtrl.set("tpreoccupyusageamt", (Object)newTPreOccupyUsageAmt);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrl});
                }
                if (!proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue()) && (yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{filter = new QFilter("yproject", "=", project.getPkValue()).and("ybudgettype", "=", (Object)budgetType).and("YEAR(yyear)", "=", (Object)year)})) != null) {
                    BigDecimal yPreOccupyUsageAmt = yearBudgetCtrl.getBigDecimal("ypreoccupyusageamt");
                    BigDecimal newYPreOccupyUsageAmt = yPreOccupyUsageAmt.subtract(amount);
                    yearBudgetCtrl.set("ypreoccupyusageamt", (Object)newYPreOccupyUsageAmt);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yearBudgetCtrl});
                }
                if ((budget = record.getDynamicObject("probudget")) != null) {
                    DynamicObject yBudgetCtrlDetail;
                    filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue());
                    DynamicObject tBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{filter});
                    if (tBudgetCtrlDetail != null) {
                        BigDecimal tBudgetCtrlDetailPreOccupyUsageAmt = tBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                        BigDecimal newTBudgetCtrlDetailPreOccupyUsageAmt = tBudgetCtrlDetailPreOccupyUsageAmt.subtract(amount);
                        tBudgetCtrlDetail.set("preoccupyusageamt", (Object)newTBudgetCtrlDetailPreOccupyUsageAmt);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tBudgetCtrlDetail});
                    }
                    if (!proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue()) && (yBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrldetail", (QFilter[])new QFilter[]{filter = new QFilter("project", "=", project.getPkValue()).and("budgettype", "=", (Object)budgetType).and("budget", "=", budget.getPkValue()).and("YEAR(year)", "=", (Object)year)})) != null) {
                        BigDecimal yBudgetCtrlDetailPreOccupyUsageAmt = yBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                        BigDecimal newYBudgetCtrlDetailPreOccupyUsageAmt = yBudgetCtrlDetailPreOccupyUsageAmt.subtract(amount);
                        yBudgetCtrlDetail.set("preoccupyusageamt", (Object)newYBudgetCtrlDetailPreOccupyUsageAmt);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yBudgetCtrlDetail});
                    }
                }
                Date opTime = new Date();
                DynamicObject newRecord = (DynamicObject)cloneUtils.clone((IDataEntityBase)record);
                newRecord.set("opaction", (Object)BillFieldTypeEnum.CLEAR_OPERATION.getNumber());
                newRecord.set("optime", (Object)opTime);
                newRecordList.add(newRecord);
                this.updateRecordIsEffectStatus(budgetParam.bill, BudgetControlTargetEnum.BUDGETUSE, BillFieldTypeEnum.CLEAR_OPERATION);
            }
        }
        SaveServiceHelper.save((DynamicObject[])newRecordList.toArray(new DynamicObject[0]));
    }

    @Override
    public void executeReturnOccupyBudget(Map<String, Object> budgetUpdateParam) {
        Long projectId = 0L;
        Long proBudgetId = 0L;
        BigDecimal amount = BigDecimal.ZERO;
        Date period = new Date();
        String ctrlTarget = "";
        DynamicObject bill = null;
        Long entryId = 0L;
        if (budgetUpdateParam.get("projectId") instanceof Long) {
            projectId = (Long)budgetUpdateParam.get("projectId");
        }
        if (budgetUpdateParam.get("proBudgetId") instanceof Long) {
            proBudgetId = (Long)budgetUpdateParam.get("proBudgetId");
        }
        if (budgetUpdateParam.get("amount") instanceof BigDecimal) {
            amount = (BigDecimal)budgetUpdateParam.get("amount");
        }
        if (budgetUpdateParam.get("period") instanceof Date) {
            period = (Date)budgetUpdateParam.get("period");
        }
        if (budgetUpdateParam.get("budgetTarget") instanceof String) {
            ctrlTarget = budgetUpdateParam.get("budgetTarget").toString();
        }
        if (budgetUpdateParam.get("bill") instanceof DynamicObject) {
            bill = (DynamicObject)budgetUpdateParam.get("bill");
        }
        if (budgetUpdateParam.get("entryId") instanceof Long) {
            entryId = (Long)budgetUpdateParam.get("entryId");
        }
        if (projectId != 0L) {
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bd_project");
            boolean isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project);
            if (!isProCostControl) {
                return;
            }
            QFilter qFilter = new QFilter("tproject", "=", (Object)projectId);
            qFilter.and("tbudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            DynamicObject totalCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{qFilter});
            if (totalCtrl == null) {
                return;
            }
            BigDecimal occupyAmt = totalCtrl.getBigDecimal("toccupyamt");
            totalCtrl.set("toccupyamt", (Object)occupyAmt.subtract(amount));
            DynamicObjectCollection details = totalCtrl.getDynamicObjectCollection("tbudgetctrldetail");
            if (proBudgetId != 0L) {
                for (DynamicObject detail : details) {
                    long budgetId;
                    DynamicObject budget = detail.getDynamicObject("budget");
                    if (budget == null || (budgetId = Long.parseLong(budget.getPkValue().toString())) != proBudgetId) continue;
                    BigDecimal detailOccupyAmt = detail.getBigDecimal("occupyamt");
                    detail.set("occupyamt", (Object)detailOccupyAmt.subtract(amount));
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalCtrl});
            this.createBudgetRecord(ctrlTarget, bill, projectId, proBudgetId, entryId, amount, period, BudgetControlTypeEnum.TAKEOPERATION);
        }
    }

    @Override
    public void executeReturnUsageBudget(Map<String, Object> budgetUpdateParam) {
        Long projectId = 0L;
        Long proBudgetId = 0L;
        BigDecimal amount = BigDecimal.ZERO;
        Date period = new Date();
        String ctrlTarget = "";
        DynamicObject bill = null;
        Long entryId = 0L;
        if (budgetUpdateParam.get("projectId") instanceof Long) {
            projectId = (Long)budgetUpdateParam.get("projectId");
        }
        if (budgetUpdateParam.get("proBudgetId") instanceof Long) {
            proBudgetId = (Long)budgetUpdateParam.get("proBudgetId");
        }
        if (budgetUpdateParam.get("amount") instanceof BigDecimal) {
            amount = (BigDecimal)budgetUpdateParam.get("amount");
        }
        if (budgetUpdateParam.get("period") instanceof Date) {
            period = (Date)budgetUpdateParam.get("period");
        }
        if (budgetUpdateParam.get("budgetTarget") instanceof String) {
            ctrlTarget = budgetUpdateParam.get("budgetTarget").toString();
        }
        if (budgetUpdateParam.get("bill") instanceof DynamicObject) {
            bill = (DynamicObject)budgetUpdateParam.get("bill");
        }
        if (budgetUpdateParam.get("entryId") instanceof Long) {
            entryId = (Long)budgetUpdateParam.get("entryId");
        }
        if (projectId != 0L) {
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bd_project");
            boolean isProCostControl = ProBudgetControlHelper.checkIsProCostControl(project);
            if (!isProCostControl) {
                return;
            }
            QFilter qFilter = new QFilter("tproject", "=", (Object)projectId);
            qFilter.and("tbudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            DynamicObject totalCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{qFilter});
            if (totalCtrl == null) {
                return;
            }
            BigDecimal usageAmt = totalCtrl.getBigDecimal("tusageamt");
            totalCtrl.set("tusageamt", (Object)usageAmt.subtract(amount));
            DynamicObjectCollection details = totalCtrl.getDynamicObjectCollection("tbudgetctrldetail");
            if (proBudgetId != 0L) {
                for (DynamicObject detail : details) {
                    long budgetId;
                    DynamicObject budget = detail.getDynamicObject("budget");
                    if (budget == null || (budgetId = Long.parseLong(budget.getPkValue().toString())) != proBudgetId) continue;
                    BigDecimal detailUsageAmt = detail.getBigDecimal("usageamt");
                    detail.set("usageamt", (Object)detailUsageAmt.subtract(amount));
                }
            }
            if (period != null) {
                Instant instant = period.toInstant();
                ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
                int year = zonedDateTime.getYear();
                qFilter = new QFilter("yproject", "=", (Object)projectId);
                qFilter.and("ybudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
                qFilter.and("YEAR(yyear)", "=", (Object)year);
                DynamicObject yearCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{qFilter});
                if (yearCtrl == null) {
                    return;
                }
                usageAmt = yearCtrl.getBigDecimal("yusageamt");
                yearCtrl.set("yusageamt", (Object)usageAmt.subtract(amount));
                DynamicObjectCollection yDetails = yearCtrl.getDynamicObjectCollection("ybudgetctrldetail");
                if (proBudgetId != 0L) {
                    for (DynamicObject yDetail : yDetails) {
                        long budgetId;
                        DynamicObject budget = yDetail.getDynamicObject("budget");
                        if (budget == null || (budgetId = Long.parseLong(budget.getPkValue().toString())) != proBudgetId) continue;
                        BigDecimal detailUsageAmt = yDetail.getBigDecimal("usageamt");
                        yDetail.set("usageamt", (Object)detailUsageAmt.subtract(amount));
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yearCtrl});
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalCtrl});
            this.createBudgetRecord(ctrlTarget, bill, projectId, proBudgetId, entryId, amount, period, BudgetControlTypeEnum.EXECOPERATION);
        }
    }

    private void createBudgetRecord(String ctrlTarget, DynamicObject bill, Long projectId, Long proBudgetId, Long entryId, BigDecimal amount, Date period, BudgetControlTypeEnum controlType) {
        if (bill == null) {
            return;
        }
        QFilter qFilter = new QFilter("entryid", "=", (Object)entryId.toString());
        qFilter.and("controltype", "=", (Object)controlType.getValue());
        qFilter.and("opaction", "!=", (Object)BillFieldTypeEnum.RETURN_OPERATION.getNumber());
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (records.length > 0) {
            for (DynamicObject record : records = BusinessDataServiceHelper.load((Object[])Arrays.stream(records).map(o -> Long.parseLong(o.getPkValue().toString())).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_budgetexerecord"))) {
                record.set("iseffect", (Object)false);
            }
            SaveServiceHelper.update((DynamicObject[])records);
        }
        DynamicObject budgetExeRecord = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_budgetexerecord"));
        budgetExeRecord.set("optype", (Object)ctrlTarget);
        budgetExeRecord.set("opaction", (Object)BillFieldTypeEnum.RETURN_OPERATION.getNumber());
        budgetExeRecord.set("budgettype", (Object)BudgetSourceTypeEnum.OUT.getValue());
        if (projectId != 0L) {
            budgetExeRecord.set("project", (Object)BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bd_project"));
        }
        if (proBudgetId != 0L) {
            DynamicObject proBudget = BusinessDataServiceHelper.loadSingle((Object)proBudgetId, (String)"pmas_projectbudget");
            budgetExeRecord.set("probudget", (Object)proBudget);
            budgetExeRecord.set("currency", (Object)proBudget.getDynamicObject("currency"));
            budgetExeRecord.set("oricurrency", (Object)proBudget.getDynamicObject("currency"));
        }
        budgetExeRecord.set("controltype", (Object)controlType);
        if ((ctrlTarget.equals(BudgetControlTargetEnum.BUDGETUSE.getValue()) || ctrlTarget.equals(BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue())) && period != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(period);
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            LocalDate yearDate = LocalDate.of(year, 1, 1);
            ZonedDateTime zonedDateTime = yearDate.atStartOfDay(ZoneId.systemDefault());
            int quarter = (month - 1) / 3 + 1;
            budgetExeRecord.set("year", (Object)Date.from(zonedDateTime.toInstant()));
            budgetExeRecord.set("quarter", (Object)quarter);
            budgetExeRecord.set("month", (Object)month);
        }
        budgetExeRecord.set("bizdate", (Object)new Date());
        String entityNumber = bill.getDataEntityType().getName();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
        budgetExeRecord.set("bizbillmark", (Object)entityNumber);
        budgetExeRecord.set("bizbillname", (Object)dt.getDisplayName());
        DataEntityPropertyCollection properties = dt.getProperties();
        String billNameField = "";
        String billNoField = "";
        for (IDataEntityProperty item : properties) {
            DynamicProperty property = (DynamicProperty)item;
            if (Arrays.asList("billname", "name").contains(property.getName())) {
                billNameField = property.getName();
            }
            if (!Arrays.asList("billno", "number").contains(property.getName())) continue;
            billNoField = property.getName();
        }
        if (StringUtils.isEmpty((CharSequence)billNameField) && StringUtils.isNotEmpty((CharSequence)billNoField)) {
            billNameField = billNoField;
        }
        if (StringUtils.isNotEmpty((CharSequence)billNameField)) {
            budgetExeRecord.set("billname", (Object)bill.getString(billNameField));
        }
        if (StringUtils.isNotEmpty((CharSequence)billNoField)) {
            budgetExeRecord.set("billno", (Object)bill.getString(billNoField));
        }
        budgetExeRecord.set("billid", (Object)Long.parseLong(bill.getPkValue().toString()));
        budgetExeRecord.set("amount", (Object)amount);
        budgetExeRecord.set("entryid", (Object)entryId.toString());
        budgetExeRecord.set("org", (Object)bill.getDynamicObject("org"));
        budgetExeRecord.set("oriamount", (Object)amount);
        budgetExeRecord.set("bizuser", (Object)bill.getDynamicObject("creator"));
        budgetExeRecord.set("optime", (Object)new Date());
        budgetExeRecord.set("iseffect", (Object)true);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{budgetExeRecord});
    }

    private void logBudgetRecord(BudgetParam budgetParam, BudgetRegValue budgetRegValue, BillFieldTypeEnum opAction, BudgetControlTypeEnum controlType) {
        String ctrlTarget = budgetParam.regBillInfo.getString("controltarget");
        BudgetControlTargetEnum ctrlTargetEnum = BudgetControlTargetEnum.getEnumByValue((Object)ctrlTarget);
        this.updateRecordIsEffectStatus(budgetParam.bill, ctrlTargetEnum, opAction);
        String budgetAction = budgetParam.budgetAction;
        if (StringUtils.equals((CharSequence)"execProjectBudget", (CharSequence)budgetAction)) {
            this.updateRecordAmt(budgetParam.bill, budgetRegValue);
        }
        DynamicObject budgetExeRecord = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_budgetexerecord"));
        budgetExeRecord.set("optype", (Object)ctrlTarget);
        budgetExeRecord.set("opaction", (Object)opAction.getNumber());
        budgetExeRecord.set("budgettype", (Object)budgetRegValue.getBudgetTypeValue());
        budgetExeRecord.set("project", (Object)budgetRegValue.getProjectValue());
        budgetExeRecord.set("probudget", (Object)budgetRegValue.getBudgetValue());
        budgetExeRecord.set("controltype", (Object)controlType);
        if (ctrlTarget.equals(BudgetControlTargetEnum.BUDGETUSE.getValue()) || ctrlTarget.equals(BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue())) {
            Date bizDate = budgetRegValue.getBizDateValue();
            if (bizDate != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(bizDate);
                int year = calendar.get(1);
                int month = calendar.get(2) + 1;
                LocalDate yearDate = LocalDate.of(year, 1, 1);
                ZonedDateTime zonedDateTime = yearDate.atStartOfDay(ZoneId.systemDefault());
                int quarter = (month - 1) / 3 + 1;
                budgetExeRecord.set("year", (Object)Date.from(zonedDateTime.toInstant()));
                budgetExeRecord.set("quarter", (Object)quarter);
                budgetExeRecord.set("month", (Object)month);
                budgetExeRecord.set("bizdate", (Object)bizDate);
            }
        } else {
            budgetExeRecord.set("bizdate", (Object)new Date());
        }
        String entityNumber = budgetParam.getEntityNumber();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
        budgetExeRecord.set("bizbillmark", (Object)entityNumber);
        budgetExeRecord.set("bizbillname", (Object)dt.getDisplayName());
        budgetExeRecord.set("billid", (Object)budgetParam.getBillId());
        budgetExeRecord.set("billno", (Object)budgetParam.getBillNo());
        budgetExeRecord.set("billname", (Object)budgetParam.getBillName());
        budgetExeRecord.set("currency", (Object)budgetRegValue.getCurrencyValue());
        budgetExeRecord.set("amount", (Object)budgetRegValue.getAmountValue());
        budgetExeRecord.set("entryid", (Object)budgetRegValue.getEntryId());
        budgetExeRecord.set("oricurrency", (Object)budgetRegValue.getCurrencyValue());
        budgetExeRecord.set("oriamount", (Object)budgetRegValue.getAmountValue());
        budgetExeRecord.set("org", (Object)budgetParam.bill.getDynamicObject("org"));
        budgetExeRecord.set("bizuser", (Object)budgetParam.getCreator());
        budgetExeRecord.set("optime", (Object)new Date());
        budgetExeRecord.set("iseffect", (Object)true);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{budgetExeRecord});
    }

    private void updateRecordAmt(DynamicObject bill, BudgetRegValue budgetRegValue) {
        Long entryId;
        DynamicObject project = budgetRegValue.getProjectValue();
        QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        qFilter.and("iseffect", "=", (Object)true);
        qFilter.and("billid", "=", (Object)bill.getPkValue().toString());
        DynamicObject budget = budgetRegValue.getBudgetValue();
        if (budget != null) {
            qFilter.and("probudget", "=", (Object)Long.parseLong(budget.getPkValue().toString()));
        }
        if ((entryId = budgetRegValue.getEntryId()) != null && entryId != 0L) {
            qFilter.and("entryid", "=", (Object)entryId.toString());
        }
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)"", (QFilter[])new QFilter[]{qFilter});
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        if (records.length > 0) {
            DynamicObject[] recordList;
            for (DynamicObject record : recordList = BusinessDataServiceHelper.load((Object[])Arrays.stream(records).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_budgetexerecord"))) {
                record.set("amount", (Object)budgetRegValue.getAmountValue());
                record.set("oriamount", (Object)budgetRegValue.getAmountValue());
                list.add(record);
            }
        }
        SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    private void updateRecordIsEffectStatus(DynamicObject bill, BudgetControlTargetEnum ctrlTarget, BillFieldTypeEnum opAction) {
        QFilter opActionFilter = null;
        if (BillFieldTypeEnum.TAKE_OPERATION.getNumber().equals(opAction.getNumber())) {
            opActionFilter = new QFilter("opaction", "=", (Object)BillFieldTypeEnum.CLEAR_OPERATION.getNumber()).or("opaction", "=", (Object)BillFieldTypeEnum.RETURN_OPERATION.getNumber());
        } else if (BillFieldTypeEnum.CLEAR_OPERATION.getNumber().equals(opAction.getNumber())) {
            opActionFilter = new QFilter("opaction", "=", (Object)BillFieldTypeEnum.TAKE_OPERATION.getNumber());
        } else if (BillFieldTypeEnum.EXEC_OPERATION.getNumber().equals(opAction.getNumber())) {
            opActionFilter = new QFilter("opaction", "=", (Object)BillFieldTypeEnum.RETURN_OPERATION.getNumber());
        } else if (BillFieldTypeEnum.RETURN_OPERATION.getNumber().equals(opAction.getNumber())) {
            opActionFilter = new QFilter("opaction", "=", (Object)BillFieldTypeEnum.EXEC_OPERATION.getNumber());
        }
        QFilter filter = new QFilter("billid", "=", (Object)bill.getPkValue().toString()).and("optype", "=", (Object)ctrlTarget.getValue()).and("iseffect", "=", (Object)true);
        if (opActionFilter != null) {
            filter.and(opActionFilter);
        }
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)"", (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        if (records.length > 0) {
            DynamicObject[] recordList;
            for (DynamicObject record : recordList = BusinessDataServiceHelper.load((Object[])Arrays.stream(records).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_budgetexerecord"))) {
                record.set("iseffect", (Object)false);
                list.add(record);
            }
        }
        SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    private BigDecimal getLastOpAmount(String billId, DynamicObject budget, String controlTarget, DynamicObject project) {
        DynamicObject[] records;
        BigDecimal amount = BigDecimal.ZERO;
        QFilter filter = new QFilter("billid", "=", (Object)billId).and("project", "=", (Object)Long.parseLong(project.getPkValue().toString())).and("iseffect", "=", (Object)true).and("opaction", "=", (Object)BillFieldTypeEnum.TAKE_OPERATION.getNumber());
        if (budget != null) {
            filter.and("probudget", "=", (Object)Long.parseLong(budget.getPkValue().toString()));
        }
        if (BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue().equalsIgnoreCase(controlTarget)) {
            filter.and("controltype", "=", (Object)BudgetControlTypeEnum.TAKEOPERATION.getValue());
        }
        if ((records = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)"amount", (QFilter[])new QFilter[]{filter})).length > 0) {
            amount = Arrays.stream(records).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        return amount;
    }
}

