/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.dataupdate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;

public class ContractApplyPaymentDataUpdateService {
    private static final Log logger = LogFactory.getLog(ContractApplyPaymentDataUpdateService.class);

    public void doRepairContApplyPayment() {
        logger.info("ContractApplyPaymentDataUpdateService#doRepairContApplyPayment start");
        QFilter payDirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.Checked.toString());
        DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"pmct_contracttpl", (String)String.join((CharSequence)",", "id", "totalapplyamount"), (QFilter[])new QFilter[]{payDirectionFilter, billStatusFilter});
        ArrayList contractNeedUpdateList = new ArrayList();
        Arrays.stream(contracts).filter(contract -> contract.getBigDecimal("totalapplyamount").compareTo(BigDecimal.ZERO) == 0).forEach(outContract -> {
            QFilter contractPkFilter = new QFilter("contract", "=", outContract.getPkValue());
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.Checked.toString());
            DynamicObject[] applyPaymentBills = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)String.join((CharSequence)",", "id", "billno", "applypaytotal", "loantotal", "paydetailentry.curpayamt"), (QFilter[])new QFilter[]{contractPkFilter, statusFilter});
            if (applyPaymentBills != null && applyPaymentBills.length > 0) {
                for (DynamicObject applyPaymentBill : applyPaymentBills) {
                    BigDecimal applyPayTotal = applyPaymentBill.getDynamicObjectCollection("paydetailentry").stream().map(it -> it.getBigDecimal("curpayamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).subtract(applyPaymentBill.getBigDecimal("loantotal"));
                    applyPaymentBill.set("applypaytotal", (Object)applyPayTotal);
                    BigDecimal totalApplyAmount = outContract.getBigDecimal("totalapplyamount");
                    outContract.set("totalapplyamount", (Object)totalApplyAmount.add(applyPayTotal));
                }
                logger.info("ContractApplyPaymentDataUpdateService#doRepairContApplyPayment update data id: {}", outContract.getPkValue());
                SaveServiceHelper.update((DynamicObject[])applyPaymentBills);
                contractNeedUpdateList.add(outContract);
            }
        });
        SaveServiceHelper.update((DynamicObject[])contractNeedUpdateList.toArray(new DynamicObject[0]));
        logger.info("ContractApplyPaymentDataUpdateService#doRepairContApplyPayment end");
    }
}

