/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.dataupdate;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.service.ContractCollectItemService;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;

public class ContractIncomeItemDataUpdateService {
    private static final Log logger = LogFactory.getLog(ContractIncomeItemDataUpdateService.class);

    public void doRepairContractIncomeItem() {
        logger.info("\u751f\u6210\u5408\u540c\u6536\u6b3e\u6761\u76ee-\u5f00\u59cb");
        QFilter payDirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
        DynamicObject[] inContracts = BusinessDataServiceHelper.load((String)"pmct_incontract", (String)"id", (QFilter[])new QFilter[]{payDirectionFilter});
        if (inContracts.length == 0) {
            logger.info("\u65e0\u6cd5\u67e5\u8be2\u5230\u6536\u5165\u5408\u540c");
            return;
        }
        inContracts = Arrays.stream(inContracts).map(contract -> {
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
            DynamicObjectCollection inContractIncomePlanEntries = contract.getDynamicObjectCollection("incontpayplanentry");
            DynamicObject partA = contract.getDynamicObject("parta");
            inContractIncomePlanEntries.stream().filter(Objects::nonNull).filter(it -> it.getDynamicObject("customer") == null).forEach(it -> it.set("customer", (Object)partA));
            return contract;
        }).collect(Collectors.toList()).toArray(new DynamicObject[inContracts.length]);
        logger.info("\u586b\u5199\u6536\u5165\u5408\u540c\u6536\u6b3e\u8ba1\u5212\u7684\u5ba2\u6237\u5b57\u6bb5");
        SaveServiceHelper.update((DynamicObject[])inContracts);
        Arrays.stream(inContracts).filter(contract -> StringUtils.equals((CharSequence)contract.getString("billstatus"), (CharSequence)StatusEnum.Checked.toString())).forEach(contract -> {
            QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.Checked.toString());
            DynamicObject[] contractIncomeItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"id", (QFilter[])new QFilter[]{contractFilter});
            if (contractIncomeItems.length > 0) {
                logger.info("\u5408\u540cid\uff1a{}\uff0c\u5408\u540c\u5355\u53f7\uff1a{}\uff0c\u5b58\u5728\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\uff0c\u4e0d\u5347\u7ea7", contract.getPkValue(), (Object)contract.getString("billno"));
                return;
            }
            DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"id", (QFilter[])new QFilter[]{contractFilter, billStatusFilter}, (String)"versionnumber desc");
            if (contractRevisions.length > 0) {
                DynamicObject contractRevision = BusinessDataServiceHelper.loadSingle((Object)contractRevisions[0].getPkValue(), (String)"pmct_contractrevision");
                DynamicObjectCollection contractIncomePlanEntries = contractRevision.getDynamicObjectCollection("incontpayplanentry");
                contractRevision.set("incontpayplanentry", (Object)contractIncomePlanEntries);
                new ContractCollectItemService().update((DynamicObject)contract, contractRevision, PayPlanSourceEnum.REVISE);
            } else {
                new ContractCollectItemService().save((DynamicObject)contract, PayPlanSourceEnum.CONTRACT);
            }
        });
        logger.info("\u751f\u6210\u5408\u540c\u6536\u6b3e\u6761\u76ee-\u5b8c\u6210");
    }
}

