/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.dataupdate;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;

public class ContractPayItemDataUpdateService {
    private static final Log logger = LogFactory.getLog(ContractPayItemDataUpdateService.class);

    public void doRepairContractPayItem() {
        logger.info("\u751f\u6210\u5408\u540c\u4ed8\u6b3e\u6761\u76ee-\u5f00\u59cb");
        QFilter payDirectionFilter = new QFilter("paydirection", "=", (Object)"out");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.Checked.toString());
        DynamicObject[] outContracts = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)String.join((CharSequence)",", "id", "partb", "outcontpayplanentry"), (QFilter[])new QFilter[]{payDirectionFilter, statusFilter});
        if (outContracts.length == 0) {
            return;
        }
        Arrays.stream(outContracts).forEach(contract -> {
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.Checked.toString());
            DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"id", (QFilter[])new QFilter[]{contractFilter});
            if (contractPayItems.length > 0) {
                return;
            }
            DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"id", (QFilter[])new QFilter[]{contractFilter, billStatusFilter}, (String)"versionnumber desc");
            PayPlanSourceEnum payPlanSource = PayPlanSourceEnum.CONTRACT;
            if (contractRevisions.length > 0) {
                DynamicObject contractRevision = BusinessDataServiceHelper.loadSingle((Object)contractRevisions[0].getPkValue(), (String)"pmct_contractrevision");
                DynamicObjectCollection outContractPayPlanEntries = contractRevision.getDynamicObjectCollection("outcontpayplanentry");
                contract.set("outcontpayplanentry", (Object)outContractPayPlanEntries);
                payPlanSource = PayPlanSourceEnum.REVISE;
            }
            ContractPayItemHelper.save(contract, payPlanSource);
        });
        logger.info("\u751f\u6210\u5408\u540c\u4ed8\u6b3e\u6761\u76ee-\u5b8c\u6210");
    }
}

