/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.dataupdate;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;

public class ContractSupplierDataUpdateService {
    private static final Log logger = LogFactory.getLog(ContractSupplierDataUpdateService.class);

    public void doRepairContractSupplier() {
        logger.info("\u540c\u6b65\u5408\u540c\u4f9b\u5e94\u5546\u5b57\u6bb5-\u5f00\u59cb");
        QFilter isMultiContractFilter = new QFilter("ismulticontract", "=", (Object)Boolean.FALSE);
        QFilter payDirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
        DynamicObject[] outContracts = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)String.join((CharSequence)",", "id", "partb", "outcontpayplanentry"), (QFilter[])new QFilter[]{isMultiContractFilter, payDirectionFilter});
        if (outContracts.length == 0) {
            return;
        }
        DynamicObject[] newPlanEntries = (DynamicObject[])Arrays.stream(outContracts).filter(contract -> {
            DynamicObjectCollection outContPayPlanEntries = contract.getDynamicObjectCollection("outcontpayplanentry");
            return outContPayPlanEntries != null && !outContPayPlanEntries.isEmpty();
        }).map(contract -> BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).map(contract -> {
            DynamicObjectCollection outContPayPlanEntries = contract.getDynamicObjectCollection("outcontpayplanentry");
            return outContPayPlanEntries.stream().filter(plan -> plan.getDynamicObject("supplier") == null).peek(plan -> plan.set("supplier", contract.get("partb"))).collect(Collectors.toList());
        }).flatMap(Collection::stream).toArray(DynamicObject[]::new);
        List pks = Arrays.stream(newPlanEntries).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        logger.info("\u8fdb\u884c\u5347\u7ea7\u7684\u5408\u540c\u8ba1\u5212id:{}", pks);
        SaveServiceHelper.update((DynamicObject[])newPlanEntries);
        logger.info("\u540c\u6b65\u5408\u540c\u4f9b\u5e94\u5546\u5b57\u6bb5-\u5b8c\u6210");
    }
}

