/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.dataupdate;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.pmgt.pmbs.common.enums.BillTypeEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;

public class FunSourceDataUpdateService {
    private static final Log logger = LogFactory.getLog(FunSourceDataUpdateService.class);

    public void doRepairFunSourceData() throws ParseException {
        logger.info("\u5347\u7ea7\u6570\u636e-\u5f00\u59cb");
        logger.info("\u67e5\u627e\u9879\u76ee\u4e91\u751f\u6210\u7684\u5df2\u5ba1\u6838\u7684\u9879\u76ee");
        String dataColumn = String.join((CharSequence)",", "id", "project", "entryinvestperiod", "entryinvestamt", "investentry", "fundsourcetype", "formofinvest", "entryamt", "currententryamt", "investcurrency");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("systemtype", "=", (Object)"PMGT");
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)"bd_project", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (projects.length > 0) {
            Set projectSet = Arrays.stream(projects).map(project -> Long.parseLong(project.getPkValue().toString())).collect(Collectors.toSet());
            QFilter projectQFilter = new QFilter("project", "in", (Object)projectSet.toArray());
            QFilter cycleQFilter = new QFilter("entryinvestcycle", "=", (Object)"yearplan");
            QFilter validQFilter = new QFilter("isvalid", "=", (Object)Boolean.TRUE);
            validQFilter.and("islatest", "=", (Object)Boolean.TRUE);
            validQFilter.and("finalstate", "=", (Object)"pass");
            DynamicObject[] yearPlans = BusinessDataServiceHelper.load((String)"pmim_invesclaimtrecord", (String)dataColumn, (QFilter[])new QFilter[]{projectQFilter, cycleQFilter, validQFilter});
            HashMap yearDyn = new HashMap(16);
            if (yearPlans.length > 0) {
                Arrays.stream(yearPlans).forEach(plan -> {
                    DynamicObjectCollection investEntry = plan.getDynamicObjectCollection("investentry");
                    BigDecimal investAmt = plan.getBigDecimal("entryinvestamt");
                    if (investEntry.size() > 0 || investAmt.compareTo(BigDecimal.ZERO) != 0) {
                        String period = plan.getString("entryinvestperiod");
                        ArrayList<DynamicObject> planList = (ArrayList<DynamicObject>)yearDyn.get(period);
                        if (planList == null) {
                            planList = new ArrayList<DynamicObject>();
                            planList.add((DynamicObject)plan);
                            yearDyn.put(period, planList);
                        } else {
                            planList.add((DynamicObject)plan);
                        }
                    }
                });
            }
            cycleQFilter = new QFilter("entryinvestcycle", "=", (Object)"monthplan");
            DynamicObject[] monthPlans = BusinessDataServiceHelper.load((String)"pmim_invesclaimtrecord", (String)dataColumn, (QFilter[])new QFilter[]{projectQFilter, cycleQFilter, validQFilter});
            if (monthPlans.length > 0) {
                Arrays.stream(monthPlans).forEach(plan -> {
                    DynamicObjectCollection investEntry = plan.getDynamicObjectCollection("investentry");
                    BigDecimal investAmt = plan.getBigDecimal("entryinvestamt");
                    if (investEntry.size() > 0 || investAmt.compareTo(BigDecimal.ZERO) != 0) {
                        String period = plan.getString("entryinvestperiod");
                        String year = period.split("-")[0];
                        ArrayList<DynamicObject> planList = (ArrayList<DynamicObject>)yearDyn.get(year);
                        if (planList == null) {
                            planList = new ArrayList<DynamicObject>(16);
                            planList.add((DynamicObject)plan);
                            yearDyn.put(year, planList);
                        } else {
                            planList.add((DynamicObject)plan);
                        }
                    }
                });
            }
            HashSet<Long> unDeleteBill = new HashSet<Long>(16);
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"id", (QFilter[])new QFilter[]{new QFilter("billstatus", "!=", (Object)"C")});
            if (bills.length > 0) {
                for (DynamicObject bill : bills) {
                    boolean isInWorkflow = WorkflowServiceHelper.inProcess((String)ObjectUtils.nullSafeToString((Object)bill.getPkValue().toString()));
                    if (!isInWorkflow) continue;
                    unDeleteBill.add(Long.parseLong(bill.getPkValue().toString()));
                }
            }
            Set entries = yearDyn.entrySet();
            for (Map.Entry entry : entries) {
                String year = (String)entry.getKey();
                HashMap<String, ArrayList<DynamicObjectCollection>> projectMap = new HashMap<String, ArrayList<DynamicObjectCollection>>(16);
                List records = (List)entry.getValue();
                for (DynamicObject record : records) {
                    DynamicObject project2 = record.getDynamicObject("project");
                    String projectId = project2.getPkValue().toString();
                    DynamicObjectCollection investEntry = record.getDynamicObjectCollection("investentry");
                    ArrayList<DynamicObjectCollection> sourceList = (ArrayList<DynamicObjectCollection>)projectMap.get(projectId);
                    if (sourceList == null) {
                        sourceList = new ArrayList<DynamicObjectCollection>(16);
                    }
                    sourceList.add(investEntry);
                    projectMap.put(projectId, sourceList);
                }
                Set projectEntry = projectMap.entrySet();
                if (projectEntry.size() == 0) continue;
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_projfundsource");
                long[] longIds = this.gainFunSourceLongIds(dt, projectEntry.size());
                int i = 0;
                for (Map.Entry sourceEntry : projectEntry) {
                    String projectId = (String)sourceEntry.getKey();
                    List sourceList = (List)sourceEntry.getValue();
                    HashMap<String, DynamicObject> sourceTypeMap = new HashMap<String, DynamicObject>(16);
                    BigDecimal sourceSumAmt = BigDecimal.ZERO;
                    for (DynamicObjectCollection sources : sourceList) {
                        for (DynamicObject source : sources) {
                            DynamicObject sourceType = source.getDynamicObject("fundsourcetype");
                            String sourceTypeId = sourceType.getPkValue().toString();
                            DynamicObject typeObj = (DynamicObject)sourceTypeMap.get(sourceTypeId);
                            if (typeObj == null) {
                                sourceTypeMap.put(sourceTypeId, source);
                                DynamicObject srcCurrency = source.getDynamicObject("investcurrency");
                                BigDecimal entryAmt = source.getBigDecimal("entryamt");
                                if (srcCurrency != null) {
                                    entryAmt = this.convertCurrencyAmt(entryAmt, srcCurrency, projectId);
                                }
                                sourceSumAmt = sourceSumAmt.add(entryAmt);
                                continue;
                            }
                            BigDecimal lastEntryAmt = typeObj.getBigDecimal("entryamt");
                            DynamicObject currency = source.getDynamicObject("investcurrency");
                            BigDecimal entryAmt = source.getBigDecimal("entryamt");
                            if (currency != null) {
                                entryAmt = this.convertCurrencyAmt(entryAmt, currency, projectId);
                            }
                            sourceSumAmt = sourceSumAmt.add(entryAmt);
                            BigDecimal lastCurEntryAmt = typeObj.getBigDecimal("currententryamt");
                            typeObj.set("entryamt", (Object)lastEntryAmt.add(source.getBigDecimal("entryamt")));
                            typeObj.set("currententryamt", (Object)lastCurEntryAmt.add(source.getBigDecimal("currententryamt")));
                            sourceTypeMap.put(sourceTypeId, typeObj);
                        }
                    }
                    projectQFilter = new QFilter("project", "=", (Object)Long.parseLong(projectId));
                    QFilter yearQFilter = new QFilter("YEAR(year)", "=", (Object)Integer.parseInt(year));
                    QFilter unDeleteQFilter = new QFilter("id", "not in", (Object)unDeleteBill.toArray());
                    DeleteServiceHelper.delete((String)"pmas_projfundsource", (QFilter[])new QFilter[]{projectQFilter, yearQFilter, unDeleteQFilter});
                    DynamicObject funSource = new DynamicObject((DynamicObjectType)dt);
                    long sourceId = longIds[i];
                    funSource.set("id", (Object)sourceId);
                    DynamicObject project3 = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bd_project");
                    funSource.set("project", (Object)project3);
                    funSource.set("billname", (Object)String.format(ResManager.loadKDString((String)"%s_\u8d44\u91d1\u6765\u6e90", (String)"FunSourceDataUpdateService_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project3.get("name")));
                    funSource.set("billno", (Object)(project3.get("number") + "_FUND"));
                    funSource.set("org", project3.get("org"));
                    funSource.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
                    funSource.set("projkind", project3.get("group"));
                    funSource.set("issys", (Object)DefaultEnum.YES.getValue());
                    funSource.set("isvalid", (Object)DefaultEnum.YES.getValue());
                    funSource.set("type", (Object)BillTypeEnum.NEW.getValue());
                    funSource.set("createtime", (Object)new Date());
                    funSource.set("version", (Object)1.0);
                    sourceSumAmt = sourceSumAmt.setScale(4, 4);
                    funSource.set("totalamount", (Object)sourceSumAmt);
                    DynamicObject approvePro = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "budgetperiod", "budgetproname", "budgetpronumber", "currencyfield"), (QFilter[])new QFilter[]{new QFilter("pro", "=", (Object)Long.parseLong(project3.getPkValue().toString()))});
                    funSource.set("budgetperiod", approvePro.get("budgetperiod"));
                    funSource.set("budgetproname", approvePro.get("budgetproname"));
                    funSource.set("budgetpronumber", approvePro.get("budgetpronumber"));
                    funSource.set("currency", approvePro.get("currencyfield"));
                    funSource.set("year", (Object)sdf.parse(year + "-01-01"));
                    DynamicObjectCollection funSourceCollection = funSource.getDynamicObjectCollection("fundentry");
                    Set sourceMap = sourceTypeMap.entrySet();
                    for (Map.Entry sourceEntries : sourceMap) {
                        DynamicObject funSourceEntry = funSourceCollection.addNew();
                        DynamicObject item = (DynamicObject)sourceEntries.getValue();
                        funSourceEntry.set("sourcetype", (Object)item.getDynamicObject("fundsourcetype"));
                        funSourceEntry.set("amount", (Object)item.getBigDecimal("entryamt"));
                        funSourceEntry.set("investcurrency", (Object)item.getDynamicObject("investcurrency"));
                        BigDecimal entryAmt = item.getBigDecimal("entryamt");
                        BigDecimal scale = entryAmt.divide(sourceSumAmt, 2, 4).multiply(BigDecimal.valueOf(100L));
                        funSourceEntry.set("scale", (Object)scale);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{funSource});
                    ++i;
                }
            }
        }
    }

    private long[] gainFunSourceLongIds(MainEntityType dt, int entrySize) {
        return ORM.create().genLongIds((IDataEntityType)dt, entrySize);
    }

    private BigDecimal convertCurrencyAmt(BigDecimal amount, DynamicObject srcCurrency, String projectId) {
        DynamicObject org;
        DynamicObject approve = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", (Object)Long.parseLong(projectId))});
        DynamicObject tarCurrency = null;
        if (approve != null) {
            tarCurrency = approve.getDynamicObject("currencyfield");
        }
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bd_project");
        DynamicObject exRateTable = null;
        if (project != null && (org = project.getDynamicObject("org")) != null) {
            exRateTable = CurrencyHelper.getExRateTable((Long)Long.parseLong(org.getPkValue().toString()));
        }
        if (exRateTable != null && tarCurrency != null) {
            Long tarCurId = Long.parseLong(tarCurrency.getPkValue().toString());
            Long exRateTableId = Long.parseLong(exRateTable.getPkValue().toString());
            Long srcCurId = Long.parseLong(srcCurrency.getPkValue().toString());
            BigDecimal exchangeRate = CurrencyHelper.getExChangeRate((Long)srcCurId, (Long)tarCurId, (Long)exRateTableId, (Date)new Date());
            if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                exchangeRate = BigDecimal.ONE;
            }
            amount = amount.multiply(exchangeRate);
        }
        return amount;
    }
}

