/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.dataupdate;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ProBudgetUpdateService {
    private static final Log logger = LogFactory.getLog(ProBudgetUpdateService.class);

    public void doProBudgetUpdateData() throws ParseException {
        logger.info("\u5347\u7ea7\u6570\u636e-\u5f00\u59cb");
        logger.info("\u5f00\u59cb\u5347\u7ea7\uff1a\u5e74\u5ea6\u7f16\u5236\u9884\u7b97\u8bb0\u5f55");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        qFilter.and("isvalid", "=", (Object)Boolean.TRUE);
        DynamicObject[] budgetBills = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"project", (QFilter[])new QFilter[]{qFilter});
        if (budgetBills.length == 0) {
            return;
        }
        Set projectSet = Arrays.stream(budgetBills).map(budget -> Long.parseLong(budget.getDynamicObject("project").getPkValue().toString())).collect(Collectors.toSet());
        for (Long project : projectSet) {
            QFilter projectQFilter = new QFilter("project", "=", (Object)project);
            QFilter statusQFilter = new QFilter("billstatus", "=", (Object)"C");
            QFilter validQFilter = new QFilter("isvalid", "=", (Object)Boolean.TRUE);
            DynamicObject[] budgets = BusinessDataServiceHelper.load((String)"pmas_budget", (String)String.join((CharSequence)",", "id", "year", "treeentryentity", "budgetamount", "projectbudgetitem"), (QFilter[])new QFilter[]{projectQFilter, statusQFilter, validQFilter});
            HashMap proBudgetMap = new HashMap(16);
            Arrays.stream(budgets).forEach(budget -> {
                Date year = budget.getDate("year");
                DynamicObjectCollection entryEntity = budget.getDynamicObjectCollection("treeentryentity");
                if (entryEntity.size() > 0) {
                    for (DynamicObject entity : entryEntity) {
                        BigDecimal budgetAmt = entity.getBigDecimal("budgetamount");
                        DynamicObject proBudget = entity.getDynamicObject("projectbudgetitem");
                        if (proBudget == null) continue;
                        BigDecimal lastYearAmt = BigDecimal.ZERO;
                        if (!QueryServiceHelper.exists((String)"pmas_projectbudget", (Object)proBudget.getPkValue())) continue;
                        proBudget = BusinessDataServiceHelper.loadSingle((Object)proBudget.getPkValue(), (String)"pmas_projectbudget");
                        DynamicObject record = (DynamicObject)proBudgetMap.get(proBudget.getPkValue().toString());
                        DynamicObjectCollection yearRecords = proBudget.getDynamicObjectCollection("yearbudgetrecord");
                        if (record == null) {
                            yearRecords.clear();
                        }
                        if (yearRecords.size() != 0) {
                            lastYearAmt = proBudget.getBigDecimal("remainamt");
                        }
                        DynamicObject yearRecord = yearRecords.addNew();
                        yearRecord.set("year", (Object)year);
                        yearRecord.set("lastyearsurplusamt", (Object)lastYearAmt);
                        yearRecord.set("curyearamt", (Object)budgetAmt);
                        yearRecord.set("sumbudgetamt", (Object)lastYearAmt.add(budgetAmt));
                        proBudgetMap.put(proBudget.getPkValue().toString(), proBudget);
                    }
                }
            });
            if (proBudgetMap.isEmpty()) continue;
            ArrayList updateObj = new ArrayList(16);
            Set proBudgets = proBudgetMap.entrySet();
            for (Map.Entry proBudget : proBudgets) {
                updateObj.add(proBudget.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])updateObj.toArray(new DynamicObject[updateObj.size()]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        logger.info("\u5f00\u59cb\u5347\u7ea7\uff1a\u9884\u7b97\u8bb0\u5f55");
        qFilter = new QFilter("project", "!=", (Object)0L);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"pmco_budgetrecord", (String)String.join((CharSequence)",", "id", "billsource", "projectapplydate", "year", "relatebillid"), (QFilter[])new QFilter[]{qFilter});
        if (records.length > 0) {
            DynamicObject[] updateRecord = new DynamicObject[records.length];
            for (int i = 0; i < records.length; ++i) {
                DynamicObject record = records[i];
                String billFormId = record.getString("billsource");
                String relateBillId = record.getString("relatebillid");
                if (StringUtils.isNotBlank((CharSequence)relateBillId)) {
                    Date year = record.getDate("projectapplydate");
                    if ("pmas_outbudget".equals(billFormId) || "pmas_inbudget".equals(billFormId)) {
                        DynamicObject budget2;
                        if (QueryServiceHelper.exists((String)billFormId, (Object)relateBillId) && (budget2 = BusinessDataServiceHelper.loadSingle((Object)relateBillId, (String)"pmas_budget")) != null) {
                            year = budget2.getDate("year");
                        }
                        if (year != null) {
                            LocalDate localDate = year.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                            year = sdf.parse(localDate.getYear() + "-01-01");
                            record.set("year", (Object)year);
                        }
                    }
                }
                updateRecord[i] = record;
            }
            SaveServiceHelper.save((DynamicObject[])updateRecord);
        }
    }

    public void doProBudgetUpdateTree() {
        logger.info("\u5347\u7ea7\u6570\u636e-\u5f00\u59cb");
        String sql = "select fid,fparent,fname from t_pmas_projectbudget";
        List dataList = (List)DB.query((DBRoute)DBRoute.of((String)"cr"), (String)sql, rs -> {
            ArrayList result = new ArrayList(32);
            while (rs.next()) {
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("id", rs.getString("fid"));
                dataMap.put("parentId", rs.getString("fparent"));
                dataMap.put("name", rs.getString("fname"));
                result.add(dataMap);
            }
            return result;
        });
        this.buildTree(dataList);
        String updateSql = "update t_pmas_projectbudget  set fleaf = ?,flevel = ?, ffullname = ? where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(32);
        for (Map map : dataList) {
            Object[] param = new Object[]{map.get("isLeaf"), map.get("level"), map.get("fullName"), Long.parseLong(map.get("id").toString())};
            paramList.add(param);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)updateSql, paramList);
    }

    private void buildTree(List<Map<String, Object>> allList) {
        for (Map<String, Object> entry : allList) {
            String id = (String)entry.get("id");
            ArrayList<Map<String, Object>> childrenList = new ArrayList<Map<String, Object>>();
            this.getChildrenList(childrenList, allList, id);
            if (childrenList.isEmpty()) {
                entry.put("isLeaf", true);
            } else {
                entry.put("isLeaf", false);
            }
            String parentId = (String)entry.get("parentId");
            int level = 1;
            level = this.getLevel(allList, level, parentId);
            entry.put("level", level);
            String fullName = this.getFullName(allList, entry.get("id").toString());
            entry.put("fullName", fullName);
        }
    }

    private int getLevel(List<Map<String, Object>> allList, int level, String parentId) {
        Map<String, Object> parent = this.getParent(allList, parentId);
        if (parent != null) {
            return this.getLevel(allList, ++level, parent.get("parentId").toString());
        }
        return level;
    }

    private Map<String, Object> getParent(List<Map<String, Object>> allList, String parentId) {
        for (Map<String, Object> entry : allList) {
            if (!entry.get("id").equals(parentId)) continue;
            return entry;
        }
        return null;
    }

    private void getParentList(List<Map<String, Object>> parentList, List<Map<String, Object>> allList, String currentId) {
        for (Map<String, Object> node : allList) {
            if (!node.get("id").toString().equals(currentId)) continue;
            this.getParentList(parentList, allList, node.get("parentId").toString());
            parentList.add(node);
        }
    }

    private void getChildrenList(List<Map<String, Object>> childrenList, List<Map<String, Object>> allList, String id) {
        for (Map<String, Object> node : allList) {
            if (!node.get("parentId").toString().equals(id)) continue;
            this.getChildrenList(childrenList, allList, node.get("id").toString());
            childrenList.add(node);
        }
    }

    private String getFullName(List<Map<String, Object>> allList, String id) {
        ArrayList<Map<String, Object>> parentList = new ArrayList<Map<String, Object>>();
        this.getParentList(parentList, allList, id);
        return parentList.stream().map(parent -> parent.get("name").toString()).collect(Collectors.joining("."));
    }
}

