/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.dataupdate;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class ProjectExecStatusDataUpdateService {
    private static final Log LOG = LogFactory.getLog(ProjectExecStatusDataUpdateService.class);
    public static final String BUDGET_CONTROL_MODE = "budgetcontrolmode";
    public static final String PERIOD_BALANCE = "periodBalance";

    public void updateByDate(Date updateDataTime) {
        DynamicObject[] projects;
        if (updateDataTime == null) {
            return;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        QFilter createTime = new QFilter("createtime", "<=", (Object)updateDataTime);
        for (DynamicObject project : projects = BusinessDataServiceHelper.load((String)"bd_project", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,createorg,org,useorg,ctrlstrategy,group,planbegindate,planenddate,prostatus,proaddress", (QFilter[])new QFilter[]{createTime})) {
            Date period;
            DynamicObject projectApproval = this.getProjectApproval(project);
            if (projectApproval == null) continue;
            QFilter projectFilter = new QFilter("project", "=", projectApproval.getDynamicObject("pro").getPkValue());
            QFilter queryTypeFilter = new QFilter("budgetquerytype", "=", (Object)"");
            DynamicObject projectExecstatusId = BusinessDataServiceHelper.loadSingle((String)"pmsc_projectexecstatus", (String)"id", (QFilter[])new QFilter[]{projectFilter, queryTypeFilter});
            if (projectExecstatusId == null) continue;
            DynamicObject projectExecstatusInfo = BusinessDataServiceHelper.loadSingle((Object)projectExecstatusId.getPkValue(), (String)"pmsc_projectexecstatus");
            DynamicObjectCollection budgetEntries = projectExecstatusInfo.getDynamicObjectCollection("budgetentry");
            DynamicObject org = projectApproval.getDynamicObject("org");
            if (org == null) {
                LOG.info("org is null, projectApproval id is : " + projectApproval.getPkValue());
            }
            if ((period = projectApproval.getDate("budgetperiod")) == null) {
                LOG.info("period is null, projectApproval id is : " + projectApproval.getPkValue());
            }
            long budgetProId = projectExecstatusInfo.getLong("budgetpro");
            String budgetProNumber = projectExecstatusInfo.getString("budgetpronumber");
            String budgetProName = projectExecstatusInfo.getString("budgetproname");
            budgetEntries.forEach(budgetEntry -> {
                budgetEntry.set("undertakeorg", (Object)org);
                budgetEntry.set("undertakeperiod", (Object)period);
                budgetEntry.set("entryproid", (Object)budgetProId);
                budgetEntry.set("entrypronumber", (Object)budgetProNumber);
                budgetEntry.set("entryproname", (Object)budgetProName);
            });
            projectExecstatusInfo.set("splittype", (Object)projectApproval.getString("splittype"));
            projectExecstatusInfo.set("budgetquerytype", (Object)PERIOD_BALANCE);
            LOG.info("waiting for updating data id: " + projectExecstatusInfo.getPkValue());
            result.add(projectExecstatusInfo);
        }
        SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
    }

    private DynamicObject getProjectApproval(DynamicObject project) {
        if (project == null) {
            return null;
        }
        QFilter projectFilter = new QFilter("pro", "=", project.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter splitTypeFilter = new QFilter("splittype", "=", (Object)BudgetCtlModeEnum.CONTROLANDADJUST.getValue());
        DynamicObject[] projectApprovalArray = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id", (QFilter[])new QFilter[]{projectFilter, billStatusFilter, splitTypeFilter});
        if (projectApprovalArray.length == 0) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)projectApprovalArray[0].getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_pro_approval"));
    }
}

