/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ConstructorTreeDataHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import org.apache.commons.collections.CollectionUtils;

public class AuthProjectKindHelper {
    private static final Log logger = LogFactory.getLog(AuthProjectKindHelper.class);
    public static final String PROJECT_KIND_ORG_LIST = "PROJECT_KIND_ORG_LIST";
    public static final String ROOT_NODE_ID = "001";
    private static final String FIELD_NUMBER = "number";

    public static String buildProjectKindTree(IFormView view, String treeKey, String rootNodeName, List<QFilter> filterList, boolean showNumber) {
        return AuthProjectKindHelper.buildProjectKindTree(view, treeKey, rootNodeName, filterList, showNumber, null);
    }

    public static String buildProjectKindTree(IFormView view, String treeKey, String rootNodeId, String rootNodeName, List<QFilter> filterList, boolean showNumber, List<String> orgPkList) {
        List<DynamicObject> treeData = orgPkList != null ? AuthProjectKindHelper.getProjectKinds(filterList, orgPkList) : AuthProjectKindHelper.getProjectKinds(filterList);
        if (CollectionUtils.isEmpty(treeData)) {
            return "";
        }
        ConstructorTreeDataHelper tree = new ConstructorTreeDataHelper(view, treeKey, rootNodeId, rootNodeName, treeData.toArray(new DynamicObject[0]));
        return tree.constructorTreeData(showNumber);
    }

    public static String buildProjectKindTree(IFormView view, String treeKey, String rootNodeName, List<QFilter> filterList, boolean showNumber, List<String> orgPkList) {
        List<DynamicObject> treeData = orgPkList != null ? AuthProjectKindHelper.getProjectKinds(filterList, orgPkList) : AuthProjectKindHelper.getProjectKinds(filterList);
        if (CollectionUtils.isEmpty(treeData)) {
            return "";
        }
        ConstructorTreeDataHelper tree = new ConstructorTreeDataHelper(view, treeKey, ROOT_NODE_ID, rootNodeName, treeData.toArray(new DynamicObject[0]));
        return tree.constructorTreeData(showNumber);
    }

    public static String buildCloudProjectKindTree(IFormView view, String treeKey, String rootNodeName, List<QFilter> filterList, boolean showNumber, Long orgId) {
        DynamicObject[] pmgtProKinds;
        if (filterList == null) {
            filterList = new ArrayList<QFilter>(10);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        filterList.add(enableFilter);
        filterList.add(statusFilter);
        ArrayList<Object> pmgtProKindIdList = new ArrayList<Object>(10);
        for (DynamicObject pmgtProKind : pmgtProKinds = BusinessDataServiceHelper.load((String)"pmbs_projectkind", (String)FIELD_NUMBER, (QFilter[])filterList.toArray(new QFilter[0]))) {
            pmgtProKindIdList.add(pmgtProKind.getPkValue());
        }
        QFilter proKindIdFilter = new QFilter("id", "in", pmgtProKindIdList);
        QFilter ctrlStrategyFilter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"bd_projectkind", (Long)orgId);
        proKindIdFilter.and(ctrlStrategyFilter);
        String queryProperties = String.join((CharSequence)",", "id", "parent", "isleaf", "level");
        DynamicObject[] authorizedProjectKinds = BusinessDataServiceHelper.load((String)"bd_projectkind", (String)queryProperties, (QFilter[])new QFilter[]{statusFilter, enableFilter, proKindIdFilter});
        Arrays.sort(authorizedProjectKinds, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Collator instance = Collator.getInstance();
                String source = o1.getLocaleString("name").getLocaleValue() != null ? o1.getLocaleString("name").getLocaleValue() : "";
                String target = o2.getLocaleString("name").getLocaleValue() != null ? o2.getLocaleString("name").getLocaleValue() : "";
                return instance.compare(source, target);
            }
        });
        List<DynamicObject> treeData = Arrays.asList(authorizedProjectKinds);
        if (CollectionUtils.isEmpty(treeData)) {
            return "";
        }
        ConstructorTreeDataHelper tree = new ConstructorTreeDataHelper(view, treeKey, ROOT_NODE_ID, rootNodeName, treeData.toArray(new DynamicObject[0]));
        return tree.constructorTreeData(showNumber);
    }

    public static void cacheChildNodes(IFormView view, List<QFilter> filterList, boolean showNumber, List<String> orgPkList) {
        List<DynamicObject> treeData = AuthProjectKindHelper.getProjectKinds(filterList, orgPkList);
        if (CollectionUtils.isEmpty(treeData)) {
            return;
        }
        logger.info(String.format("cacheChildNodes for orgs: %s, treeData: %s", orgPkList, treeData));
        ConstructorTreeDataHelper tree = new ConstructorTreeDataHelper(view, null, null, null, treeData.toArray(new DynamicObject[0]));
        List<TreeNode> childNodes = tree.getChildNodes(treeData.toArray(new DynamicObject[0]), showNumber);
        view.getPageCache().put("PROJECT_KIND_LIST_CACHE_KEY", SerializationUtils.toJsonString(childNodes));
    }

    public static List<DynamicObject> getProjectKinds(List<QFilter> filterList, List<String> orgPkList) {
        List<DynamicObject> authorizedProjectKindList = AuthProjectKindHelper.getAuthorizedProjectKindList(filterList, orgPkList);
        if (CollectionUtils.isEmpty(authorizedProjectKindList)) {
            return new ArrayList<DynamicObject>();
        }
        return authorizedProjectKindList;
    }

    public static List<DynamicObject> getProjectKinds(List<QFilter> filterList) {
        List<DynamicObject> authorizedProjectKindList = AuthProjectKindHelper.getPmbsProjectKindList(filterList);
        if (CollectionUtils.isEmpty(authorizedProjectKindList)) {
            return new ArrayList<DynamicObject>();
        }
        return authorizedProjectKindList;
    }

    private static List<DynamicObject> getPmbsProjectKindList(List<QFilter> filterList) {
        if (filterList == null) {
            filterList = new ArrayList<QFilter>(10);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        filterList.add(enableFilter);
        filterList.add(statusFilter);
        DynamicObject[] projectCloudProKinds = BusinessDataServiceHelper.load((String)"pmbs_projectkind", (String)FIELD_NUMBER, (QFilter[])filterList.toArray(new QFilter[0]));
        Set projectCloudProKindIdList = Arrays.stream(projectCloudProKinds).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter projectCloudProKindIdFilter = new QFilter("id", "in", projectCloudProKindIdList);
        DynamicObject[] authorizedProjectKinds = BusinessDataServiceHelper.load((String)"bd_projectkind", (String)String.join((CharSequence)",", "id", "parent", "isleaf", "level"), (QFilter[])new QFilter[]{statusFilter, enableFilter, projectCloudProKindIdFilter});
        Arrays.sort(authorizedProjectKinds, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Collator instance = Collator.getInstance();
                String source = o1.getLocaleString("name").getLocaleValue() != null ? o1.getLocaleString("name").getLocaleValue() : "";
                String target = o2.getLocaleString("name").getLocaleValue() != null ? o2.getLocaleString("name").getLocaleValue() : "";
                return instance.compare(source, target);
            }
        });
        return Arrays.asList(authorizedProjectKinds);
    }

    private static List<DynamicObject> getAuthorizedProjectKindList(List<QFilter> filterList, List<String> orgPkList) {
        if (filterList == null) {
            filterList = new ArrayList<QFilter>(10);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        filterList.add(enableFilter);
        filterList.add(statusFilter);
        long start1 = System.currentTimeMillis();
        DynamicObject[] projectCloudProKinds = BusinessDataServiceHelper.load((String)"pmbs_projectkind", (String)FIELD_NUMBER, (QFilter[])filterList.toArray(new QFilter[0]));
        long end1 = System.currentTimeMillis();
        logger.info("\u67e5\u8be2\u9879\u76ee\u4e91\u7684\u9879\u76ee\u5206\u7c7b\uff0c\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(end1 - start1));
        Set projectCloudProKindIdList = Arrays.stream(projectCloudProKinds).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(orgPkList)) {
            orgPkList.add(String.valueOf(RequestContext.get().getOrgId()));
        }
        long start2 = System.currentTimeMillis();
        logger.info("\u51c6\u5907\u5f00\u59cb\u8c03\u7528BaseDataServiceHelper.getBaseDataIdInFilter\u63a5\u53e3\uff0c\u5c06\u67e5\u8be2{}\u4e2a\u7ec4\u7ec7\u4e0b\u53d7\u7ba1\u63a7\u7b56\u7565\u63a7\u5236\u7684\u9879\u76ee\u5206\u7c7b", (Object)orgPkList.size());
        for (String userOrgId : orgPkList) {
            if (!StringUtils.isNotBlank((CharSequence)userOrgId)) continue;
            long startX = System.currentTimeMillis();
            QFilter qFilter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"bd_projectkind", (Long)Long.parseLong(userOrgId));
            long endX = System.currentTimeMillis();
            logger.info("\u8c03\u7528\u57fa\u7840\u670d\u52a1BaseDataServiceHelper.getBaseDataIdInFilter\u63a5\u53e3\u67e5\u8be2\u7ec4\u7ec7[{}]\u7cfb\u7edf\u670d\u52a1\u4e91\u7684\u53d7\u7ba1\u63a7\u7b56\u7565\u63a7\u5236\u7684\u9879\u76ee\u5206\u7c7b\uff0c\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)userOrgId, (Object)(endX - startX));
            if (qFilter == null) continue;
            projectCloudProKindIdList.addAll((HashSet)qFilter.getValue());
        }
        long end2 = System.currentTimeMillis();
        logger.info("\u8c03\u7528\u57fa\u7840\u670d\u52a1BaseDataServiceHelper.getBaseDataIdInFilter\u63a5\u53e3\u67e5\u8be2\u7cfb\u7edf\u670d\u52a1\u4e91\u7684\u53d7\u7ba1\u63a7\u7b56\u7565\u63a7\u5236\u7684\u9879\u76ee\u5206\u7c7b\uff0c\u603b\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(end2 - start2));
        QFilter proKindIdFilter = new QFilter("id", "in", projectCloudProKindIdList);
        long start3 = System.currentTimeMillis();
        DynamicObject[] authorizedProjectKinds = BusinessDataServiceHelper.load((String)"bd_projectkind", (String)String.join((CharSequence)",", "id", "parent", "isleaf", "level"), (QFilter[])new QFilter[]{statusFilter, enableFilter, proKindIdFilter});
        Arrays.sort(authorizedProjectKinds, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Collator instance = Collator.getInstance();
                String source = o1.getLocaleString("name").getLocaleValue() != null ? o1.getLocaleString("name").getLocaleValue() : "";
                String target = o2.getLocaleString("name").getLocaleValue() != null ? o2.getLocaleString("name").getLocaleValue() : "";
                return instance.compare(source, target);
            }
        });
        long end3 = System.currentTimeMillis();
        logger.info("\u67e5\u8be2\u7b26\u5408\u6761\u4ef6\u7684\u9879\u76ee\u5206\u7c7b\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object)(end3 - start3));
        return Arrays.asList(authorizedProjectKinds);
    }
}

