/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.kit.StringTemplateParser;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.earlywarn.warnschedule.WarnMessageConfig;
import kd.bos.entity.earlywarn.warnschedule.WarnSchedule;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class CommonWarnMessageHelper {
    public void commonWarnMessageWriteOut(String dataSourceId, WarnSchedule schedule, DynamicObjectCollection list) {
        Set dataIdSet = list.stream().map(obj -> obj.getString("id")).collect(Collectors.toSet());
        QFilter solutionFilter = new QFilter("warnsolution.id", "=", (Object)schedule.getId());
        QFilter dataIdFilter = new QFilter("dataid", "in", dataIdSet);
        QFilter dataSourceFilter = new QFilter("datasource", "=", (Object)dataSourceId);
        DynamicObject[] updateWarnMessages = BusinessDataServiceHelper.load((String)"pmbs_warnmessage", (String)"createtime,message,enable,project,dataid,warnlevel", (QFilter[])new QFilter[]{solutionFilter, dataIdFilter, dataSourceFilter});
        Set existWarnIdSet = Arrays.stream(updateWarnMessages).map(obj -> obj.getString("dataid")).collect(Collectors.toSet());
        Map<String, List<DynamicObject>> dataIdToWarnMap = Arrays.stream(updateWarnMessages).collect(Collectors.groupingBy(obj -> obj.getString("dataid")));
        dataIdSet.removeAll(existWarnIdSet);
        dataIdFilter = new QFilter("dataid", "not in", existWarnIdSet);
        DynamicObject[] deleteWarnMessages = BusinessDataServiceHelper.load((String)"pmbs_warnmessage", (String)"", (QFilter[])new QFilter[]{solutionFilter, dataIdFilter});
        Set deleteWarnIdSet = Arrays.stream(deleteWarnMessages).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        WarnMessageConfig messageConfig = schedule.getMessageConfig();
        boolean mergeSendMessage = messageConfig.isMergeSendMessage();
        String templateMessage = mergeSendMessage ? messageConfig.getMergeContent() : messageConfig.getSingleContent();
        ArrayList messageFields = new ArrayList();
        StringTemplateParser parser = new StringTemplateParser();
        parser.parse(templateMessage, macroName -> {
            messageFields.add(macroName);
            return "";
        });
        HashMap<String, String> fieldToValueMap = new HashMap<String, String>(16);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_warnmessage");
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(updateWarnMessages.length);
        ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>(dataIdSet.size());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
        DynamicObject warnmonitor = BusinessDataServiceHelper.loadSingle((String)"pmbs_warnmonitor", (String)"enable,warnlevel", (QFilter[])new QFilter[]{statusFilter, solutionFilter, enableFilter});
        String warnLevel = "";
        boolean enable = false;
        if (warnmonitor != null) {
            warnLevel = warnmonitor.getString("warnlevel");
            enable = warnmonitor.getBoolean("enable");
        }
        Date sendDate = new Date();
        for (DynamicObject data : list) {
            DynamicObject warnMessage;
            List<DynamicObject> warnDataList = dataIdToWarnMap.get(data.getString("id"));
            if (warnDataList == null || warnDataList.isEmpty()) {
                warnMessage = new DynamicObject((DynamicObjectType)dt);
                warnMessage.set("warnsolution", (Object)schedule.getId());
                DynamicProperty project = dt.getProperty("project");
                if (project == null) {
                    DynamicProperty pro = dt.getProperty("pro");
                    if (pro != null && data.containsProperty("pro")) {
                        warnMessage.set("project", (Object)data.getDynamicObject("pro"));
                    }
                } else if (data.containsProperty("project")) {
                    warnMessage.set("project", (Object)data.getDynamicObject("project"));
                }
                warnMessage.set("datasource", (Object)dataSourceId);
                warnMessage.set("dataid", (Object)data.getString("id"));
                addList.add(warnMessage);
            } else {
                warnMessage = warnDataList.get(0);
                updateList.add(warnMessage);
            }
            for (String field : messageFields) {
                String[] arr = StringUtils.split((String)field, (String)".");
                String objValue = this.getValue(data, arr);
                String value = objValue == null ? "" : objValue.toString();
                fieldToValueMap.put(field, value);
            }
            String parseMessage = parser.parse(templateMessage, macroName -> (String)fieldToValueMap.get(macroName));
            warnMessage.set("warnlevel", (Object)warnLevel);
            warnMessage.set("message", (Object)parseMessage);
            warnMessage.set("enable", (Object)enable);
            warnMessage.set("createtime", (Object)sendDate);
        }
        SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[addList.size()]));
        SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])deleteWarnIdSet.toArray());
    }

    protected String getValue(DynamicObject data, String[] arr) {
        if (null == arr || arr.length == 0) {
            return "";
        }
        Object obj = data.get(arr[0]);
        if (obj instanceof DynamicObject) {
            return this.getValue((DynamicObject)obj, Arrays.copyOfRange(arr, 1, arr.length));
        }
        String valueStr = StringUtil.toSafeString((Object)obj);
        if (StringUtils.equals((CharSequence)valueStr, (CharSequence)"0E-10")) {
            valueStr = "0.00";
        }
        return valueStr;
    }
}

