/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.TreeNodeSearchHelper;
import org.jetbrains.annotations.NotNull;

public class ConstructorTreeDataHelper {
    private static final Log logger = LogFactory.getLog(ConstructorTreeDataHelper.class);
    private static final String FIELD_PARENT = "parent";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_IS_LEAF = "isleaf";
    public static final String ROOT_NODE_ID = "001";
    private String dataResourceFormId;
    private IFormView view;
    private String treeKey;
    private String selectProperties;
    private String parentField = "parent";
    private String nodeNameField = "name";
    private String sortType = "name";
    private QFilter[] qFilters = new QFilter[0];
    private String rootNodeId = "001";
    private String rootNodeName = ResManager.loadKDString((String)"\u5168\u90e8", (String)"ConstructorTreeDataHelper_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]);
    private DynamicObject[] treeData;
    public static final String PROJECT_KIND_LIST_CACHE_KEY = "PROJECT_KIND_LIST_CACHE_KEY";

    public ConstructorTreeDataHelper(IFormView view) {
        this.view = view;
    }

    public ConstructorTreeDataHelper(IFormView view, String treeKey, String dataResourceFormId, String rootNodeName) {
        this.init(view, treeKey, dataResourceFormId, null, rootNodeName, null);
    }

    public ConstructorTreeDataHelper(IFormView view, String treeKey, String rootNodeId, String rootNodeName, DynamicObject[] treeData) {
        this.init(view, treeKey, null, rootNodeId, rootNodeName, treeData);
    }

    private void init(IFormView view, String treeKey, String dataResourceFormId, String rootNodeId, String rootNodeName, DynamicObject[] treeData) {
        this.view = view;
        this.treeKey = treeKey;
        this.dataResourceFormId = dataResourceFormId;
        this.treeData = treeData;
        if (StringUtils.isNotBlank((CharSequence)rootNodeId)) {
            this.rootNodeId = rootNodeId;
        }
        if (StringUtils.isNotBlank((CharSequence)rootNodeName)) {
            this.rootNodeName = rootNodeName;
        }
        this.selectProperties = String.join((CharSequence)",", FIELD_NUMBER, FIELD_NAME, this.parentField, FIELD_IS_LEAF);
    }

    public String getParentField() {
        return this.parentField;
    }

    public void setParentField(String parentField) {
        this.parentField = parentField;
    }

    public String getNodeNameField() {
        return this.nodeNameField;
    }

    public void setNodeNameField(String nodeNameField) {
        this.nodeNameField = nodeNameField;
    }

    public QFilter[] getQFilters() {
        return this.qFilters;
    }

    public void setQFilters(QFilter[] qFilters) {
        this.qFilters = qFilters;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSelectProperties() {
        return this.selectProperties;
    }

    public void setSelectProperties(String selectProperties) {
        this.selectProperties = selectProperties;
    }

    public String constructorTreeData(boolean showNumber) {
        DynamicObject[] treeDataCol = this.getTreeData();
        this.initTreeData(treeDataCol, (TreeView)this.view.getControl(this.treeKey), showNumber, null);
        return this.getTreeNodeIds(treeDataCol);
    }

    public String constructorTreeData(boolean showNumber, String searchText) {
        DynamicObject[] treeDataCol = this.getTreeData();
        this.initTreeData(treeDataCol, (TreeView)this.view.getControl(this.treeKey), showNumber, searchText);
        return this.getTreeNodeIds(treeDataCol);
    }

    private String getTreeNodeIds(DynamicObject[] treeDataCol) {
        StringBuilder sb = new StringBuilder();
        String ids = "";
        for (DynamicObject dynamicObject : treeDataCol) {
            sb.append(dynamicObject.getPkValue().toString()).append(",");
        }
        if (treeDataCol.length > 0) {
            ids = sb.substring(0, sb.length() - 1);
        }
        return ids;
    }

    protected DynamicObject[] getTreeData() {
        if (this.treeData != null && this.treeData.length > 0) {
            return this.treeData;
        }
        return BusinessDataServiceHelper.load((String)this.dataResourceFormId, (String)this.selectProperties, (QFilter[])this.qFilters, (String)this.sortType);
    }

    protected void initTreeData(DynamicObject[] treeDataCol, TreeView treeView, boolean showNumber, String searchText) {
        TreeNode rootTreeNode = new TreeNode(null, this.rootNodeId, this.rootNodeName, true);
        List<TreeNode> treeNodeList = this.getChildNodes(treeDataCol, showNumber);
        rootTreeNode.addChildren(treeNodeList);
        treeView.deleteAllNodes();
        treeView.addNode(rootTreeNode);
        treeView.expand(this.rootNodeId);
        treeView.focusNode(rootTreeNode);
        if (searchText != null && !searchText.isEmpty()) {
            block0: for (DynamicObject data : treeDataCol) {
                if (data.getBoolean(FIELD_IS_LEAF)) continue;
                List<DynamicObject> children = TreeNodeSearchHelper.findChildTreeNode(treeDataCol, data);
                for (DynamicObject child : children) {
                    String name = child.getLocaleString(FIELD_NAME).toString();
                    String number = child.getString(FIELD_NUMBER);
                    if (!name.contains(searchText) && (!showNumber || !number.contains(searchText))) continue;
                    treeView.expand(data.getPkValue().toString());
                    continue block0;
                }
            }
        }
    }

    @NotNull
    public List<TreeNode> getChildNodes(DynamicObject[] treeDataCol, boolean showNumber) {
        Map<Long, DynamicObjectCollection> childMap = ConstructorTreeDataHelper.getChildMap(treeDataCol);
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(10);
        Set treeIdSet = Arrays.stream(treeDataCol).map(o -> o.getPkValue()).collect(Collectors.toSet());
        for (DynamicObject data : treeDataCol) {
            boolean hasParent;
            DynamicObject parent = (DynamicObject)data.get(this.parentField);
            boolean bl = hasParent = parent != null;
            if (hasParent) {
                hasParent = treeIdSet.contains(parent.getPkValue());
            }
            if (hasParent) continue;
            TreeNode treeNode = this.constructTreeNode(data, childMap, null, showNumber);
            treeNode.setExpend(true);
            treeNodeList.add(treeNode);
        }
        this.view.getPageCache().put(PROJECT_KIND_LIST_CACHE_KEY, SerializationUtils.toJsonString(treeNodeList));
        return treeNodeList;
    }

    @Deprecated
    public static Map<Long, DynamicObjectCollection> getChildMap(DynamicObject[] allNodes) {
        HashMap<Long, DynamicObjectCollection> childMap = new HashMap<Long, DynamicObjectCollection>();
        for (DynamicObject treeData : allNodes) {
            DynamicObject parent = (DynamicObject)treeData.get(FIELD_PARENT);
            if (null == parent) continue;
            Long parentId = (Long)parent.getPkValue();
            DynamicObjectCollection col = null != childMap.get(parentId) ? (DynamicObjectCollection)childMap.get(parentId) : new DynamicObjectCollection();
            col.add((Object)treeData);
            childMap.put((Long)parent.getPkValue(), col);
        }
        return childMap;
    }

    private TreeNode constructTreeNode(DynamicObject treeData, Map<Long, DynamicObjectCollection> childMap, String parentId, boolean showNumber) {
        String treeNodeName = showNumber ? String.format("%s\uff08%s\uff09", treeData.get(FIELD_NAME).toString(), treeData.get(FIELD_NUMBER).toString()) : treeData.get(FIELD_NAME).toString();
        TreeNode treeNode = new TreeNode(parentId, treeData.getPkValue().toString(), treeNodeName, true);
        Long dataId = (Long)treeData.getPkValue();
        DynamicObjectCollection childDataCol = childMap.get(dataId);
        if (null == childDataCol) {
            treeNode.setChildren(null);
            return treeNode;
        }
        for (DynamicObject childData : childDataCol) {
            TreeNode childNode = this.constructTreeNode(childData, childMap, treeNode.getId(), showNumber);
            treeNode.addChild(childNode);
        }
        return treeNode;
    }
}

