/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.ContractPayTypeEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.utils.ComboItemHelper;

public class ContractCollectItemHelper {
    private static final Log logger = LogFactory.getLog(ContractCollectItemHelper.class);
    public static final int PERCENT_OK = 100;

    public Object[] doSave(DynamicObject currentBill, PayPlanSourceEnum source) {
        String currentFormId;
        Object contractPk = currentBill.getPkValue();
        switch (currentFormId = currentBill.getDataEntityType().getName()) {
            case "pmct_contractrevision": {
                contractPk = currentBill.getDynamicObject("contract").getPkValue();
                break;
            }
            case "pmct_incontractrevision": {
                contractPk = currentBill.getDynamicObject("contract").getPkValue();
                break;
            }
            case "pmct_inaddagreement": {
                contractPk = currentBill.getDynamicObject("contract").getPkValue();
                break;
            }
            case "pmct_inclaimbill": {
                contractPk = currentBill.getDynamicObject("contract").getPkValue();
                break;
            }
            case "pmct_inperformrecords": {
                contractPk = currentBill.getDynamicObject("contract").getPkValue();
                break;
            }
        }
        return ContractCollectItemHelper.doUpdateCollectItems(currentBill, contractPk, source);
    }

    public Object[] doSave(DynamicObject currentBill, PayPlanSourceEnum source, Object contractPk) {
        return ContractCollectItemHelper.doCreateCollectItems(currentBill, source, contractPk);
    }

    private static Object[] doCreateCollectItems(DynamicObject currentBill, PayPlanSourceEnum source, Object contractPk) {
        try {
            String currentFormId = currentBill.getDataEntityType().getName();
            logger.info("\u5f53\u524d\u5355\u636eid\u3001\u5355\u636e\u6807\u8bc6:{},{}", currentBill.getPkValue(), (Object)currentFormId);
            DynamicObjectCollection collectPlanEntries = null;
            switch (currentFormId) {
                case "pmct_incontract": {
                    collectPlanEntries = currentBill.getDynamicObjectCollection("incontpayplanentry");
                    break;
                }
                case "pmct_contractrevision": {
                    collectPlanEntries = currentBill.getDynamicObjectCollection("incontpayplanentry");
                    break;
                }
                case "pmct_incontractrevision": {
                    collectPlanEntries = currentBill.getDynamicObjectCollection("incomeplanentry");
                    break;
                }
                case "pmct_inaddagreement": {
                    collectPlanEntries = currentBill.getDynamicObjectCollection("incomeplanentry");
                    break;
                }
                case "pmct_inclaimbill": {
                    collectPlanEntries = currentBill.getDynamicObjectCollection("claimincomeplanentry");
                    break;
                }
                case "pmct_inperformrecords": {
                    collectPlanEntries = currentBill.getDynamicObjectCollection("entryentity");
                    break;
                }
            }
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_incontract");
            Object[] contractPayItems = null;
            if (collectPlanEntries == null || collectPlanEntries.isEmpty()) {
                if (!StringUtils.equals((CharSequence)currentFormId, (CharSequence)"pmct_inperformrecords")) {
                    DynamicObject contractCollectItem = ContractCollectItemHelper.createDefaultCollectItem(currentBill, contract, source);
                    contractPayItems = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contractCollectItem});
                }
            } else {
                contractPayItems = SaveServiceHelper.save((DynamicObject[])((DynamicObject[])collectPlanEntries.stream().map(collectPlanEntry -> ContractCollectItemHelper.createCollectItemByCollectPlan(contract, currentBill, collectPlanEntry, source)).toArray(DynamicObject[]::new)));
                SaveServiceHelper.update((DynamicObject)currentBill);
            }
            return contractPayItems;
        }
        catch (Exception e) {
            logger.info("\u6536\u6b3e\u6761\u76ee\u65b0\u589e\u5931\u8d25,\u5f53\u524d\u5355\u636eid: {}, : \u5355\u636eformId\uff1a{}", currentBill.getPkValue(), (Object)currentBill.getDataEntityType().getName());
            throw e;
        }
    }

    private static DynamicObject[] doUpdateCollectItems(DynamicObject currentBill, Object contractPk, PayPlanSourceEnum source) {
        String currentFormId = currentBill.getDataEntityType().getName();
        logger.info("\u5f53\u524d\u5355\u636eid\u3001\u5355\u636e\u6807\u8bc6:{},{}", currentBill.getPkValue(), (Object)currentFormId);
        BigDecimal latestAmountOfTax = BigDecimal.ZERO;
        DynamicObjectCollection collectPlanEntries = null;
        String collectEntryRelateItemIdKey = null;
        switch (currentFormId) {
            case "pmct_incontract": {
                currentBill = BusinessDataServiceHelper.loadSingle((Object)currentBill.getPkValue(), (String)"pmct_incontract");
                collectPlanEntries = currentBill.getDynamicObjectCollection("incontpayplanentry");
                latestAmountOfTax = currentBill.getBigDecimal("originaloftaxamount");
                collectEntryRelateItemIdKey = "conplanitemid";
                break;
            }
            case "pmct_contractrevision": {
                currentBill = BusinessDataServiceHelper.loadSingle((Object)currentBill.getPkValue(), (String)"pmct_contractrevision");
                collectPlanEntries = currentBill.getDynamicObjectCollection("incontpayplanentry");
                latestAmountOfTax = currentBill.getBigDecimal("originaloftaxamount");
                collectEntryRelateItemIdKey = "conincomeitemid";
                break;
            }
            case "pmct_incontractrevision": {
                currentBill = BusinessDataServiceHelper.loadSingle((Object)currentBill.getPkValue(), (String)"pmct_incontractrevision");
                collectPlanEntries = currentBill.getDynamicObjectCollection("incomeplanentry");
                latestAmountOfTax = currentBill.getBigDecimal("latestamountoftax");
                collectEntryRelateItemIdKey = "conplanitemid";
                break;
            }
            case "pmct_inaddagreement": {
                currentBill = BusinessDataServiceHelper.loadSingle((Object)currentBill.getPkValue(), (String)"pmct_inaddagreement");
                collectPlanEntries = currentBill.getDynamicObjectCollection("incomeplanentry");
                latestAmountOfTax = currentBill.getBigDecimal("latestamountoftax");
                collectEntryRelateItemIdKey = "conplanitemid";
                break;
            }
            case "pmct_inclaimbill": {
                currentBill = BusinessDataServiceHelper.loadSingle((Object)currentBill.getPkValue(), (String)"pmct_inclaimbill");
                collectPlanEntries = currentBill.getDynamicObjectCollection("claimincomeplanentry");
                latestAmountOfTax = currentBill.getBigDecimal("afteroftaxamount");
                collectEntryRelateItemIdKey = "conplanitemid";
                break;
            }
            case "pmct_inperformrecords": {
                collectPlanEntries = currentBill.getDynamicObjectCollection("entryentity");
                break;
            }
        }
        ContractCollectItemHelper.updateCollectItem(contractPk, currentBill, collectPlanEntries, latestAmountOfTax, collectEntryRelateItemIdKey, source);
        QFilter contractFilter = new QFilter("contract", "=", contractPk);
        QFilter sourceFilter = new QFilter("sourcebilltype", "!=", (Object)PayPlanSourceEnum.PERFORM.getValue());
        return BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"", (QFilter[])new QFilter[]{contractFilter, sourceFilter});
    }

    private static void updateCollectItem(Object contractPk, DynamicObject currentBill, DynamicObjectCollection collectPlanEntries, BigDecimal latestAmountOfTax, String collectEntryRelateItemIdKey, PayPlanSourceEnum source) {
        QFilter contractIdFilter = new QFilter("contract", "=", contractPk);
        QFilter perFormFilter = new QFilter("sourcebilltype", "!=", (Object)PayPlanSourceEnum.PERFORM.getValue());
        DynamicObjectCollection contractCollectItems = QueryServiceHelper.query((String)"pmbs_contractcollectitem", (String)String.join((CharSequence)",", "id", "billno", "name", "collectamount", "autogenerated", "sourcebilltype", "sourcebill"), (QFilter[])new QFilter[]{contractIdFilter, perFormFilter});
        Iterator iterator = contractCollectItems.iterator();
        while (iterator.hasNext()) {
            long sourceBillId;
            DynamicObject inClaim;
            DynamicObject item2 = (DynamicObject)iterator.next();
            boolean autoCreate = item2.getBoolean("autogenerated");
            String sourceBillType = item2.getString("sourcebilltype");
            if (!autoCreate || !StringUtils.equals((CharSequence)sourceBillType, (CharSequence)PayPlanSourceEnum.CLAIM.getValue()) || (inClaim = BusinessDataServiceHelper.loadSingle((Object)(sourceBillId = item2.getLong("sourcebill")), (String)"pmct_inclaimbill")).getBoolean("isneedsettle")) continue;
            iterator.remove();
        }
        List oldItemIds = contractCollectItems.stream().map(item -> item.get("id")).collect(Collectors.toList());
        ArrayList deleteItemIds = new ArrayList(10);
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_incontract");
        if (collectPlanEntries == null || collectPlanEntries.isEmpty()) {
            if (contractCollectItems.size() == 1 && ((DynamicObject)contractCollectItems.get(0)).getBoolean("autogenerated")) {
                DynamicObject contractPayItem = (DynamicObject)contractCollectItems.get(0);
                String selectProperties = String.join((CharSequence)",", "billno", "name", "collectamount");
                contractPayItem = BusinessDataServiceHelper.loadSingle((Object)contractPayItem.getLong("id"), (String)"pmbs_contractcollectitem", (String)selectProperties);
                String collectTypeName = ComboItemHelper.getName((String)"pmbs_contractcollectitem", null, null, (String)"collecttype", (String)ContractPayTypeEnum.CONTRACT_COLLECT.getValue());
                String itemNumber = ContractCollectItemHelper.setBillNumber(contract.getDynamicObject("org").getString("number"), collectTypeName, source.getName(), currentBill.getString("billno"), null);
                String itemName = ContractCollectItemHelper.setBillName(collectTypeName, source.getName(), currentBill.getString("billno"), null);
                String currentFormId = currentBill.getDataEntityType().getName();
                contractPayItem.set("billno", (Object)itemNumber);
                contractPayItem.set("name", (Object)itemName);
                contractPayItem.set("collectamount", (Object)latestAmountOfTax);
                SaveServiceHelper.update((DynamicObject)contractPayItem);
            } else {
                deleteItemIds.addAll(oldItemIds);
            }
        } else {
            ArrayList<Long> updateItemIds = new ArrayList<Long>(10);
            ArrayList<DynamicObject> newItem = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> updateItem = new ArrayList<DynamicObject>(10);
            for (DynamicObject collectPlanEntry : collectPlanEntries) {
                Long relateItemId = null;
                if (collectPlanEntry.get(collectEntryRelateItemIdKey) instanceof String && !StringUtils.isEmpty((CharSequence)collectPlanEntry.getString(collectEntryRelateItemIdKey))) {
                    relateItemId = Long.parseLong(collectPlanEntry.getString(collectEntryRelateItemIdKey));
                } else if (collectPlanEntry.get(collectEntryRelateItemIdKey) instanceof Long) {
                    relateItemId = collectPlanEntry.getLong(collectEntryRelateItemIdKey);
                }
                if (relateItemId == null || relateItemId.equals(0L) || !QueryServiceHelper.exists((String)"pmbs_contractcollectitem", (Object)relateItemId)) {
                    newItem.add(ContractCollectItemHelper.createCollectItemByCollectPlan(contract, currentBill, collectPlanEntry, source));
                    continue;
                }
                if (!QueryServiceHelper.exists((String)"pmbs_contractcollectitem", (Object)relateItemId)) continue;
                DynamicObject contractCollectItem = BusinessDataServiceHelper.loadSingle((Object)relateItemId, (String)"pmbs_contractcollectitem");
                updateItem.add(ContractCollectItemHelper.updateContractCollectItem(contractCollectItem, collectPlanEntry, currentBill, source));
                updateItemIds.add(relateItemId);
            }
            deleteItemIds.addAll(oldItemIds);
            deleteItemIds.removeAll(updateItemIds);
            if (!newItem.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])newItem.toArray(new DynamicObject[0]));
                SaveServiceHelper.update((DynamicObject)currentBill);
            }
            if (!updateItem.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updateItem.toArray(new DynamicObject[0]));
            }
        }
        if (!deleteItemIds.isEmpty()) {
            QFilter deleteItemIdsFilter = new QFilter("id", "in", deleteItemIds);
            DeleteServiceHelper.delete((String)"pmbs_contractcollectitem", (QFilter[])new QFilter[]{deleteItemIdsFilter});
        }
    }

    private static DynamicObject updateContractCollectItem(DynamicObject contractCollectItem, DynamicObject collectEntry, DynamicObject currentBill, PayPlanSourceEnum source) {
        String currentFormId = currentBill.getDataEntityType().getName();
        DynamicObject contract = contractCollectItem.getDynamicObject("contract");
        String incomePlanSource = null;
        switch (currentFormId) {
            case "pmct_incontract": {
                contractCollectItem.set("customer", collectEntry.get("customer"));
                contractCollectItem.set("collecttype", collectEntry.get("paytype"));
                contractCollectItem.set("collectfeq", collectEntry.get("paymethod"));
                contractCollectItem.set("collectway", collectEntry.get("payway"));
                contractCollectItem.set("collectpercent", collectEntry.get("paypercent"));
                contractCollectItem.set("collectamount", (Object)collectEntry.getBigDecimal("payamount"));
                contractCollectItem.set("plancollecttime", collectEntry.get("planpaytime"));
                contractCollectItem.set("remarks", collectEntry.get("remarks"));
                collectEntry.set("conplanitemid", (Object)contractCollectItem.getPkValue().toString());
                break;
            }
            case "pmct_contractrevision": {
                incomePlanSource = "incomeplansourceid";
                contractCollectItem.set("customer", collectEntry.get("customer"));
                contractCollectItem.set("collecttype", collectEntry.get("incometype"));
                contractCollectItem.set("collectfeq", collectEntry.get("incomemethod"));
                contractCollectItem.set("collectway", collectEntry.get("incomeway"));
                contractCollectItem.set("collectpercent", collectEntry.get("incomepercent"));
                contractCollectItem.set("collectamount", (Object)collectEntry.getBigDecimal("incomeamount"));
                contractCollectItem.set("plancollecttime", collectEntry.get("planincometime"));
                contractCollectItem.set("remarks", collectEntry.get("incomedescription"));
                contractCollectItem.set("ctrlstrategy", collectEntry.get("incomectrlstrategy"));
                contractCollectItem.set("nodesettingsource", collectEntry.get("incomesource"));
                contractCollectItem.set("nodesetting", collectEntry.get("incomenodesetting"));
                collectEntry.set("conincomeitemid", (Object)Long.parseLong(contractCollectItem.getPkValue().toString()));
                break;
            }
            case "pmct_incontractrevision": {
                incomePlanSource = "incomeplansourceid";
                contractCollectItem.set("customer", collectEntry.get("customer"));
                contractCollectItem.set("collecttype", collectEntry.get("incometype"));
                contractCollectItem.set("collectfeq", collectEntry.get("incomefeq"));
                contractCollectItem.set("collectway", collectEntry.get("incomeway"));
                contractCollectItem.set("collectpercent", collectEntry.get("incomepercent"));
                contractCollectItem.set("collectamount", (Object)collectEntry.getBigDecimal("incomeamountoftax"));
                contractCollectItem.set("plancollecttime", collectEntry.get("planincometime"));
                contractCollectItem.set("remarks", collectEntry.get("remarks"));
                collectEntry.set("conplanitemid", (Object)contractCollectItem.getPkValue().toString());
                break;
            }
            case "pmct_inaddagreement": {
                incomePlanSource = "incomeplansourceid";
                contractCollectItem.set("customer", collectEntry.get("customer"));
                contractCollectItem.set("collecttype", collectEntry.get("incometype"));
                contractCollectItem.set("collectfeq", collectEntry.get("incomefeq"));
                contractCollectItem.set("collectway", collectEntry.get("incomeway"));
                contractCollectItem.set("collectpercent", collectEntry.get("incomepercent"));
                contractCollectItem.set("collectamount", (Object)collectEntry.getBigDecimal("incomeamountoftax"));
                contractCollectItem.set("plancollecttime", collectEntry.get("planincometime"));
                contractCollectItem.set("remarks", collectEntry.get("remarks"));
                collectEntry.set("conplanitemid", (Object)contractCollectItem.getPkValue().toString());
                break;
            }
            case "pmct_inclaimbill": {
                incomePlanSource = "incomeplansourceid";
                contractCollectItem.set("customer", collectEntry.get("customer"));
                contractCollectItem.set("collecttype", collectEntry.get("incometype"));
                contractCollectItem.set("collectfeq", collectEntry.get("incomefeq"));
                contractCollectItem.set("collectway", collectEntry.get("incomeway"));
                contractCollectItem.set("collectpercent", collectEntry.get("incomepercent"));
                contractCollectItem.set("collectamount", (Object)collectEntry.getBigDecimal("incomeamountoftax"));
                contractCollectItem.set("plancollecttime", collectEntry.get("planincometime"));
                contractCollectItem.set("remarks", collectEntry.get("remarks"));
                collectEntry.set("conplanitemid", (Object)contractCollectItem.getPkValue().toString());
                break;
            }
        }
        String collectType = contractCollectItem.getString("collecttype");
        String incomePlanSourceId = null;
        if (incomePlanSource != null) {
            incomePlanSourceId = collectEntry.getString(incomePlanSource);
        }
        if (incomePlanSourceId == null || incomePlanSourceId.isEmpty()) {
            contractCollectItem.set("name", (Object)ContractCollectItemHelper.setBillName(ComboItemHelper.getName((String)"pmbs_contractcollectitem", null, null, (String)"collecttype", (String)collectType), source.getName(), currentBill.getString("billno"), collectEntry.getString("seq")));
            contractCollectItem.set("billno", (Object)ContractCollectItemHelper.setBillNumber(contract.getDynamicObject("org").getString("number"), collectType, source.getValue(), currentBill.getString("billno"), collectEntry.getString("seq")));
        }
        contractCollectItem.set("autogenerated", (Object)Boolean.FALSE);
        contractCollectItem.set("currency", currentBill.get("currency"));
        BigDecimal collectAmount = contractCollectItem.getBigDecimal("collectamount");
        contractCollectItem.set("uncollectedamt", (Object)collectAmount.subtract(contractCollectItem.getBigDecimal("collectedcomamt")));
        contractCollectItem.set("appliableamt", (Object)contractCollectItem.getBigDecimal("collectamount").subtract(contractCollectItem.getBigDecimal("appliedcomamt")));
        contractCollectItem.set("contract", (Object)contract);
        if (!StringUtils.equals((CharSequence)currentFormId, (CharSequence)"pmct_contractrevision")) {
            contractCollectItem.set("ctrlstrategy", collectEntry.get("ctrlstrategy"));
            contractCollectItem.set("nodesettingsource", collectEntry.get("nodesettingsource"));
            contractCollectItem.set("nodesetting", (Object)collectEntry.getDynamicObject("nodesetting"));
        }
        contractCollectItem.set("sourcebilltype", (Object)source.getValue());
        contractCollectItem.set("paydirection", (Object)PayDirectionEnum.IN.getValue());
        Date now = new Date();
        contractCollectItem.set("createtime", (Object)now);
        contractCollectItem.set("modifytime", (Object)now);
        contractCollectItem.set("creator", (Object)RequestContext.get().getUserId());
        contractCollectItem.set("modifier", (Object)RequestContext.get().getUserId());
        contractCollectItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
        contractCollectItem.set("status", (Object)StatusEnum.CHECKED.getValue());
        return contractCollectItem;
    }

    private static DynamicObject createDefaultCollectItem(DynamicObject currentBill, DynamicObject contract, PayPlanSourceEnum source) {
        String currentFormId;
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_contractcollectitem");
        DynamicObject contractCollectItem = new DynamicObject((DynamicObjectType)dt);
        long pk = ORM.create().genLongId("pmbs_contractcollectitem");
        contractCollectItem.set("id", (Object)pk);
        contractCollectItem.set("masterid", (Object)pk);
        contractCollectItem.set("autogenerated", (Object)Boolean.TRUE);
        contractCollectItem.set("currency", contract.get("currency"));
        ContractPayTypeEnum collectType = ContractPayTypeEnum.CONTRACT_COLLECT;
        BigDecimal latestAmountOfTax = BigDecimal.ZERO;
        switch (currentFormId = currentBill.getDynamicObjectType().getName()) {
            case "pmct_incontract": {
                latestAmountOfTax = currentBill.getBigDecimal("originaloftaxamount");
                break;
            }
            case "pmct_contractrevision": {
                latestAmountOfTax = currentBill.getBigDecimal("originaloftaxamount");
                break;
            }
            case "pmct_incontractrevision": {
                latestAmountOfTax = currentBill.getBigDecimal("latestamountoftax");
                break;
            }
            case "pmct_inaddagreement": {
                latestAmountOfTax = currentBill.getBigDecimal("latestamountoftax");
                break;
            }
            case "pmct_inclaimbill": {
                latestAmountOfTax = currentBill.getBigDecimal("afteroftaxamount");
                if (!currentBill.getBoolean("isneedsettle")) {
                    latestAmountOfTax = currentBill.getBigDecimal("claimoftaxamount");
                }
                collectType = ContractPayTypeEnum.CLAIM_PAYMENT;
                break;
            }
        }
        contractCollectItem.set("collecttype", (Object)collectType.getValue());
        contractCollectItem.set("collectamount", (Object)latestAmountOfTax);
        contractCollectItem.set("uncollectedamt", (Object)latestAmountOfTax);
        contractCollectItem.set("appliableamt", (Object)latestAmountOfTax);
        contractCollectItem.set("contract", (Object)contract);
        DynamicObject customer = contract.getDynamicObject("parta");
        contractCollectItem.set("customer", (Object)customer);
        contractCollectItem.set("collectpercent", (Object)100);
        contractCollectItem.set("sourcebill", currentBill.getPkValue());
        contractCollectItem.set("sourcebilltype", (Object)source.getValue());
        contractCollectItem.set("paydirection", (Object)PayDirectionEnum.IN.getValue());
        String itemName = ContractCollectItemHelper.setBillName(ComboItemHelper.getName((String)"pmbs_contractcollectitem", null, null, (String)"collecttype", (String)collectType.getValue()), source.getName(), currentBill.getString("billno"), null);
        String itemNumber = ContractCollectItemHelper.setBillNumber(contract.getDynamicObject("org").getString("number"), collectType.getValue(), source.getValue(), currentBill.getString("billno"), null);
        contractCollectItem.set("name", (Object)itemName);
        contractCollectItem.set("billno", (Object)itemNumber);
        Date now = new Date();
        contractCollectItem.set("createtime", (Object)now);
        contractCollectItem.set("modifytime", (Object)now);
        contractCollectItem.set("creator", (Object)RequestContext.get().getUserId());
        contractCollectItem.set("modifier", (Object)RequestContext.get().getUserId());
        contractCollectItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
        contractCollectItem.set("status", (Object)StatusEnum.CHECKED.getValue());
        return contractCollectItem;
    }

    private static DynamicObject createCollectItemByCollectPlan(DynamicObject contract, DynamicObject currentBill, DynamicObject collectPlanEntry, PayPlanSourceEnum source) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_contractcollectitem");
        DynamicObject contractCollectItem = new DynamicObject((DynamicObjectType)dt);
        long pk = ORM.create().genLongId("pmbs_contractcollectitem");
        contractCollectItem.set("id", (Object)pk);
        contractCollectItem.set("masterid", (Object)pk);
        String currentFormId = currentBill.getDataEntityType().getName();
        String collectTypeName = null;
        String collectTypeValue = null;
        switch (currentFormId) {
            case "pmct_incontract": {
                collectTypeValue = collectPlanEntry.getString("paytype");
                collectTypeName = ComboItemHelper.getName((String)"pmct_incontract", (String)"incontpayplanentry", null, (String)"paytype", (String)collectTypeValue);
                contractCollectItem.set("customer", collectPlanEntry.get("customer"));
                contractCollectItem.set("collectfeq", collectPlanEntry.get("paymethod"));
                contractCollectItem.set("collectway", collectPlanEntry.get("payway"));
                contractCollectItem.set("collectpercent", collectPlanEntry.get("paypercent"));
                contractCollectItem.set("collectamount", (Object)collectPlanEntry.getBigDecimal("payamount"));
                contractCollectItem.set("plancollecttime", collectPlanEntry.get("planpaytime"));
                contractCollectItem.set("remarks", collectPlanEntry.get("remarks"));
                collectPlanEntry.set("conplanitemid", (Object)pk);
                break;
            }
            case "pmct_contractrevision": {
                collectTypeValue = collectPlanEntry.getString("incometype");
                collectTypeName = ComboItemHelper.getName((String)"pmct_contractrevision", (String)"incontpayplanentry", null, (String)"incometype", (String)collectTypeValue);
                contractCollectItem.set("customer", collectPlanEntry.get("customer"));
                contractCollectItem.set("collectfeq", collectPlanEntry.get("incomemethod"));
                contractCollectItem.set("collectway", collectPlanEntry.get("incomeway"));
                contractCollectItem.set("collectpercent", collectPlanEntry.get("incomepercent"));
                contractCollectItem.set("collectamount", (Object)collectPlanEntry.getBigDecimal("incomeamount"));
                contractCollectItem.set("plancollecttime", collectPlanEntry.get("planincometime"));
                contractCollectItem.set("remarks", collectPlanEntry.get("incomedescription"));
                contractCollectItem.set("ctrlstrategy", collectPlanEntry.get("incomectrlstrategy"));
                contractCollectItem.set("nodesetting", collectPlanEntry.get("incomenodesetting"));
                contractCollectItem.set("nodesettingsource", collectPlanEntry.get("incomesource"));
                collectPlanEntry.set("conincomeitemid", (Object)pk);
                break;
            }
            case "pmct_incontractrevision": {
                collectTypeValue = collectPlanEntry.getString("incometype");
                collectTypeName = ComboItemHelper.getName((String)"pmct_incontractrevision", (String)"incomeplanentry", null, (String)"incometype", (String)collectTypeValue);
                contractCollectItem.set("customer", collectPlanEntry.get("customer"));
                contractCollectItem.set("collectfeq", collectPlanEntry.get("incomefeq"));
                contractCollectItem.set("collectway", collectPlanEntry.get("incomeway"));
                contractCollectItem.set("collectpercent", collectPlanEntry.get("incomepercent"));
                contractCollectItem.set("collectamount", (Object)collectPlanEntry.getBigDecimal("incomeamountoftax"));
                contractCollectItem.set("plancollecttime", collectPlanEntry.get("planincometime"));
                contractCollectItem.set("remarks", collectPlanEntry.get("remarks"));
                collectPlanEntry.set("conplanitemid", (Object)pk);
                break;
            }
            case "pmct_inaddagreement": {
                collectTypeValue = collectPlanEntry.getString("incometype");
                collectTypeName = ComboItemHelper.getName((String)"pmct_inaddagreement", (String)"incomeplanentry", null, (String)"incometype", (String)collectTypeValue);
                contractCollectItem.set("customer", collectPlanEntry.get("customer"));
                contractCollectItem.set("collectfeq", collectPlanEntry.get("incomefeq"));
                contractCollectItem.set("collectway", collectPlanEntry.get("incomeway"));
                contractCollectItem.set("collectpercent", collectPlanEntry.get("incomepercent"));
                contractCollectItem.set("collectamount", (Object)collectPlanEntry.getBigDecimal("incomeamountoftax"));
                contractCollectItem.set("plancollecttime", collectPlanEntry.get("planincometime"));
                contractCollectItem.set("remarks", collectPlanEntry.get("remarks"));
                collectPlanEntry.set("conplanitemid", (Object)pk);
                break;
            }
            case "pmct_inclaimbill": {
                collectTypeValue = collectPlanEntry.getString("incometype");
                collectTypeName = ComboItemHelper.getName((String)"pmct_inclaimbill", (String)"claimincomeplanentry", null, (String)"incometype", (String)collectTypeValue);
                contractCollectItem.set("customer", collectPlanEntry.get("customer"));
                contractCollectItem.set("collectfeq", collectPlanEntry.get("incomefeq"));
                contractCollectItem.set("collectway", collectPlanEntry.get("incomeway"));
                contractCollectItem.set("collectpercent", collectPlanEntry.get("incomepercent"));
                contractCollectItem.set("collectamount", (Object)collectPlanEntry.getBigDecimal("incomeamountoftax"));
                contractCollectItem.set("plancollecttime", collectPlanEntry.get("planincometime"));
                contractCollectItem.set("remarks", collectPlanEntry.get("remarks"));
                collectPlanEntry.set("conplanitemid", (Object)pk);
                break;
            }
            case "pmct_inperformrecords": {
                contractCollectItem.set("sourcebilltype", (Object)PayPlanSourceEnum.PERFORM.getValue());
                collectTypeValue = ContractPayTypeEnum.PERFORM_PAYMENT.getValue();
                collectTypeName = ComboItemHelper.getName((String)"pmbs_contractcollectitem", null, null, (String)"collecttype", (String)collectTypeValue);
                BigDecimal amount = collectPlanEntry.getBigDecimal("amount");
                if (collectPlanEntry.getDynamicObject("contpayitem") != null && collectPlanEntry.getDynamicObject("contpayitem").getString("direction") != null && "01".equals(collectPlanEntry.getDynamicObject("contpayitem").getString("direction"))) {
                    contractCollectItem.set("uncollectedamt", (Object)amount.negate());
                    contractCollectItem.set("collectamount", (Object)amount.negate());
                    break;
                }
                contractCollectItem.set("uncollectedamt", (Object)amount);
                contractCollectItem.set("collectamount", (Object)amount);
                break;
            }
        }
        String itemName = ContractCollectItemHelper.setBillName(collectTypeName, source.getName(), currentBill.getString("billno"), collectPlanEntry.getString("seq"));
        String itemNumber = ContractCollectItemHelper.setBillNumber(contract.getDynamicObject("org").getString("number"), collectTypeValue, source.getValue(), currentBill.getString("billno"), collectPlanEntry.getString("seq"));
        contractCollectItem.set("name", (Object)itemName);
        contractCollectItem.set("billno", (Object)itemNumber);
        contractCollectItem.set("collecttype", (Object)collectTypeValue);
        contractCollectItem.set("autogenerated", (Object)Boolean.FALSE);
        contractCollectItem.set("currency", contract.get("currency"));
        contractCollectItem.set("uncollectedamt", (Object)contractCollectItem.getBigDecimal("collectamount"));
        contractCollectItem.set("appliableamt", (Object)contractCollectItem.getBigDecimal("collectamount"));
        contractCollectItem.set("contract", (Object)contract);
        if (!StringUtils.equals((CharSequence)currentFormId, (CharSequence)"pmct_inperformrecords") && !StringUtils.equals((CharSequence)currentFormId, (CharSequence)"pmct_contractrevision")) {
            contractCollectItem.set("ctrlstrategy", (Object)collectPlanEntry.getString("ctrlstrategy"));
            contractCollectItem.set("nodesettingsource", (Object)collectPlanEntry.getString("nodesettingsource"));
            contractCollectItem.set("nodesetting", (Object)collectPlanEntry.getDynamicObject("nodesetting"));
        }
        contractCollectItem.set("sourcebill", collectPlanEntry.getPkValue());
        contractCollectItem.set("sourcebilltype", (Object)source.getValue());
        contractCollectItem.set("paydirection", (Object)PayDirectionEnum.IN.getValue());
        Date now = new Date();
        contractCollectItem.set("createtime", (Object)now);
        contractCollectItem.set("modifytime", (Object)now);
        contractCollectItem.set("creator", (Object)RequestContext.get().getUserId());
        contractCollectItem.set("modifier", (Object)RequestContext.get().getUserId());
        contractCollectItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
        contractCollectItem.set("status", (Object)StatusEnum.CHECKED.getValue());
        return contractCollectItem;
    }

    public static String setBillName(String collectType, String sourceBillType, String billNo, String seq) {
        if (StringUtils.isNotBlank((CharSequence)seq)) {
            return String.format("%s_%s_%s_%s", collectType, sourceBillType, billNo, seq);
        }
        return String.format("%s_%s_%s", collectType, sourceBillType, billNo);
    }

    public static String setBillNumber(String orgNumber, String collectType, String sourceBillType, String billNo, String seq) {
        if (StringUtils.isNotBlank((CharSequence)seq)) {
            return String.format("%s_%s_%s_%s_%s", orgNumber, collectType, sourceBillType, billNo, seq);
        }
        return String.format("%s_%s_%s_%s", orgNumber, collectType, sourceBillType, billNo);
    }

    public static void setBillNameInContractCollectEntry(IDataModel model) {
        DynamicObjectCollection planEntry = null;
        String formBillId = model.getDataEntityType().getName();
        String sourceName = null;
        String incomeType = "incometype";
        String incomeIdKey = null;
        String incomePlanSourceIdKey = null;
        String incomePlanEntryId = null;
        if (!QueryServiceHelper.exists((String)formBillId, (Object)model.getDataEntity().getPkValue())) {
            return;
        }
        DynamicObject curBill = model.getDataEntity();
        String billNo = curBill.getString("billno");
        switch (formBillId) {
            case "pmct_incontract": {
                planEntry = curBill.getDynamicObjectCollection("incontpayplanentry");
                sourceName = PayPlanSourceEnum.CONTRACT.getName();
                incomeIdKey = "conplanitemid";
                incomeType = "paytype";
                incomePlanEntryId = "incontpayplanentry";
                break;
            }
            case "pmct_contractrevision": {
                planEntry = curBill.getDynamicObjectCollection("incontpayplanentry");
                sourceName = PayPlanSourceEnum.REVISE.getName();
                incomeIdKey = "conincomeitemid";
                incomeType = "incometype";
                incomePlanSourceIdKey = "incomeplansourceid";
                incomePlanEntryId = "incontpayplanentry";
                break;
            }
            case "pmct_incontractrevision": {
                planEntry = curBill.getDynamicObjectCollection("incomeplanentry");
                sourceName = PayPlanSourceEnum.MODIFY.getName();
                incomeIdKey = "conplanitemid";
                incomeType = "incometype";
                incomePlanSourceIdKey = "incomeplansourceid";
                incomePlanEntryId = "incomeplanentry";
                break;
            }
            case "pmct_inclaimbill": {
                planEntry = curBill.getDynamicObjectCollection("claimincomeplanentry");
                sourceName = PayPlanSourceEnum.CLAIM.getName();
                incomeIdKey = "conplanitemid";
                incomeType = "incometype";
                incomePlanSourceIdKey = "incomeplansourceid";
                incomePlanEntryId = "claimincomeplanentry";
                break;
            }
            case "pmct_inaddagreement": {
                planEntry = curBill.getDynamicObjectCollection("incomeplanentry");
                sourceName = PayPlanSourceEnum.ADDITION.getName();
                incomeIdKey = "conplanitemid";
                incomeType = "incometype";
                incomePlanSourceIdKey = "incomeplansourceid";
                incomePlanEntryId = "incomeplanentry";
                break;
            }
        }
        if (planEntry != null) {
            String billStatus = curBill.getString("billstatus");
            for (int index = 0; index < planEntry.size(); ++index) {
                String incomeItemName;
                Object planItem = ((DynamicObject)planEntry.get(index)).get(incomeIdKey);
                long incomeItemId = 0L;
                if (planItem instanceof String && StringUtils.isNotEmpty((CharSequence)String.valueOf(planItem))) {
                    incomeItemId = Long.parseLong(String.valueOf(planItem));
                }
                if (planItem instanceof Long) {
                    incomeItemId = (Long)planItem;
                }
                QFilter idFilter = new QFilter("id", "=", (Object)incomeItemId);
                DynamicObject incomeItem = BusinessDataServiceHelper.loadSingle((String)"pmbs_contractcollectitem", (String)"name", (QFilter[])new QFilter[]{idFilter});
                if (StatusEnum.TEMPSAVE.getValue().equals(billStatus)) {
                    if (incomeItem != null) {
                        incomeItemName = incomeItem.getLocaleString("name").getLocaleValue();
                        if (StringUtils.isBlank((CharSequence)incomeItemName)) {
                            incomeItemName = incomeItem.getString("name");
                        }
                        model.setValue("incomeitemname", (Object)incomeItemName, index);
                        continue;
                    }
                    model.setValue("incomeitemname", null, index);
                    continue;
                }
                if (incomeItem != null) {
                    incomeItemName = incomeItem.getLocaleString("name").getLocaleValue();
                    if (StringUtils.isBlank((CharSequence)incomeItemName)) {
                        incomeItemName = incomeItem.getString("name");
                    }
                    model.setValue("incomeitemname", (Object)incomeItemName, index);
                    continue;
                }
                String type = ((DynamicObject)planEntry.get(index)).getString(incomeType);
                String billName = ContractCollectItemHelper.setBillName(ComboItemHelper.getName((String)formBillId, (String)incomePlanEntryId, null, (String)incomeType, (String)type), sourceName, billNo, String.valueOf(index + 1));
                if (incomeItemId != 0L) {
                    Map<String, String> sourcePayPlanData;
                    String incomePlanSourceId;
                    if (incomePlanSourceIdKey != null && StringUtils.isNotBlank((CharSequence)(incomePlanSourceId = ((DynamicObject)planEntry.get(index)).getString(incomePlanSourceIdKey))) && !(sourcePayPlanData = ContractCollectItemHelper.gainSourcePayPlan(incomePlanSourceId)).isEmpty()) {
                        String sourceIncomeType = sourcePayPlanData.get("incometype");
                        String sourceIncomeName = sourcePayPlanData.get("sourcename");
                        String sourceBillNo = sourcePayPlanData.get("billno");
                        billName = ContractCollectItemHelper.setBillName(ComboItemHelper.getName((String)formBillId, (String)incomePlanEntryId, null, (String)incomeType, (String)sourceIncomeType), sourceIncomeName, sourceBillNo, String.valueOf(index + 1));
                    }
                    billName = String.format(ResManager.loadKDString((String)"%s_\u5df2\u5220\u9664", (String)"ContractCollectItemHelper_1", (String)"pmgt-pmbs-business", (Object[])new Object[0]), billName);
                }
                model.setValue("incomeitemname", (Object)billName, index);
            }
        }
    }

    private static Map<String, String> gainSourcePayPlan(String incomePlanSourceId) {
        HashMap<String, String> sourcePayPlanData = new HashMap<String, String>(16);
        if (StringUtils.isNotBlank((CharSequence)incomePlanSourceId)) {
            QFilter qFilter = new QFilter("incontpayplanentry.id", "=", (Object)Long.parseLong(incomePlanSourceId));
            DynamicObject sourcePayPlanObj = BusinessDataServiceHelper.loadSingle((String)"pmct_incontract", (String)String.join((CharSequence)",", "billno", "paytype"), (QFilter[])new QFilter[]{qFilter});
            if (sourcePayPlanObj == null) {
                sourcePayPlanObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractrevision", (String)String.join((CharSequence)",", "billno", "incometype"), (QFilter[])new QFilter[]{qFilter});
            }
            if (sourcePayPlanObj == null) {
                qFilter = new QFilter("incomeplanentry.id", "=", (Object)Long.parseLong(incomePlanSourceId));
                sourcePayPlanObj = BusinessDataServiceHelper.loadSingle((String)"pmct_incontractrevision", (String)String.join((CharSequence)",", "billno", "incometype"), (QFilter[])new QFilter[]{qFilter});
            }
            if (sourcePayPlanObj == null) {
                qFilter = new QFilter("claimincomeplanentry.id", "=", (Object)Long.parseLong(incomePlanSourceId));
                sourcePayPlanObj = BusinessDataServiceHelper.loadSingle((String)"pmct_inclaimbill", (String)String.join((CharSequence)",", "billno", "incometype"), (QFilter[])new QFilter[]{qFilter});
            }
            if (sourcePayPlanObj == null) {
                qFilter = new QFilter("incomeplanentry.id", "=", (Object)Long.parseLong(incomePlanSourceId));
                sourcePayPlanObj = BusinessDataServiceHelper.loadSingle((String)"pmct_inaddagreement", (String)String.join((CharSequence)",", "billno", "incometype"), (QFilter[])new QFilter[]{qFilter});
            }
            if (sourcePayPlanObj != null) {
                String formBillId = sourcePayPlanObj.getDataEntityType().getName();
                String sourceName = null;
                String billNo = null;
                String incomeType = null;
                switch (formBillId) {
                    case "pmct_incontract": {
                        sourceName = PayPlanSourceEnum.CONTRACT.getName();
                        billNo = sourcePayPlanObj.getString("billno");
                        DynamicObjectCollection incomePlanEntry = sourcePayPlanObj.getDynamicObjectCollection("incontpayplanentry");
                        if (incomePlanEntry.size() <= 0) break;
                        Optional<DynamicObject> first = incomePlanEntry.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)incomePlanSourceId)).findFirst();
                        DynamicObject entry2 = new DynamicObject();
                        if (first.isPresent()) {
                            entry2 = first.get();
                        }
                        incomeType = entry2.getString("paytype");
                        break;
                    }
                    case "pmct_contractrevision": {
                        sourceName = PayPlanSourceEnum.REVISE.getName();
                        billNo = sourcePayPlanObj.getString("billno");
                        DynamicObjectCollection incomePlanEntry = sourcePayPlanObj.getDynamicObjectCollection("incontpayplanentry");
                        if (incomePlanEntry.size() <= 0) break;
                        Optional<DynamicObject> first = incomePlanEntry.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)incomePlanSourceId)).findFirst();
                        DynamicObject entry3 = new DynamicObject();
                        if (first.isPresent()) {
                            entry3 = first.get();
                        }
                        incomeType = entry3.getString("incometype");
                        break;
                    }
                    case "pmct_incontractrevision": {
                        sourceName = PayPlanSourceEnum.MODIFY.getName();
                        billNo = sourcePayPlanObj.getString("billno");
                        DynamicObjectCollection incomePlanEntry = sourcePayPlanObj.getDynamicObjectCollection("incomeplanentry");
                        if (incomePlanEntry.size() <= 0) break;
                        Optional<DynamicObject> first = incomePlanEntry.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)incomePlanSourceId)).findFirst();
                        DynamicObject entry4 = new DynamicObject();
                        if (first.isPresent()) {
                            entry4 = first.get();
                        }
                        incomeType = entry4.getString("incometype");
                        break;
                    }
                    case "pmct_inclaimbill": {
                        sourceName = PayPlanSourceEnum.CLAIM.getName();
                        billNo = sourcePayPlanObj.getString("billno");
                        DynamicObjectCollection incomePlanEntry = sourcePayPlanObj.getDynamicObjectCollection("claimincomeplanentry");
                        if (incomePlanEntry.size() <= 0) break;
                        Optional<DynamicObject> first = incomePlanEntry.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)incomePlanSourceId)).findFirst();
                        DynamicObject entry5 = new DynamicObject();
                        if (first.isPresent()) {
                            entry5 = first.get();
                        }
                        incomeType = entry5.getString("incometype");
                        break;
                    }
                    case "pmct_inaddagreement": {
                        sourceName = PayPlanSourceEnum.ADDITION.getName();
                        billNo = sourcePayPlanObj.getString("billno");
                        DynamicObjectCollection incomePlanEntry = sourcePayPlanObj.getDynamicObjectCollection("incomeplanentry");
                        if (incomePlanEntry.size() <= 0) break;
                        Optional<DynamicObject> first = incomePlanEntry.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)incomePlanSourceId)).findFirst();
                        DynamicObject entry6 = new DynamicObject();
                        if (first.isPresent()) {
                            entry6 = first.get();
                        }
                        incomeType = entry6.getString("incometype");
                        break;
                    }
                }
                sourcePayPlanData.put("sourcename", sourceName);
                sourcePayPlanData.put("billno", billNo);
                sourcePayPlanData.put("incometype", incomeType);
            }
        }
        return sourcePayPlanData;
    }

    public static void updateLastIncomePlan(DynamicObject bill, DynamicObjectCollection curCollectPlanEntry, DynamicObject[] claims, DynamicObject[] contractRevisions, DynamicObject[] contractChanges, DynamicObject[] contAddAgreements) {
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contract.getPkValue().toString()), (String)"pmct_incontract");
        Date auditDate = bill.getDate("auditdate");
        DynamicObject lastObject = null;
        String formId = null;
        Date maxDate = auditDate;
        if (claims.length > 0) {
            DynamicObject inClaim = claims[0];
            maxDate = inClaim.getDate("auditdate");
            lastObject = inClaim;
            formId = "pmct_inclaimbill";
        }
        if (contractRevisions.length > 0) {
            DynamicObject contractRevision = contractRevisions[0];
            Date revisionDate = contractRevision.getDate("auditdate");
            if (maxDate.compareTo(auditDate) != 0) {
                if (maxDate.compareTo(revisionDate) < 0) {
                    maxDate = revisionDate;
                    lastObject = contractRevision;
                    formId = "pmct_contractrevision";
                }
            } else {
                maxDate = revisionDate;
                lastObject = contractRevision;
                formId = "pmct_contractrevision";
            }
        }
        if (contractChanges.length > 0) {
            DynamicObject contractChange = contractChanges[0];
            Date inContractChangeDate = contractChange.getDate("auditdate");
            if (maxDate.compareTo(auditDate) != 0) {
                if (maxDate.compareTo(inContractChangeDate) < 0) {
                    maxDate = inContractChangeDate;
                    lastObject = contractChange;
                    formId = "pmct_incontractrevision";
                }
            } else {
                maxDate = inContractChangeDate;
                lastObject = contractChange;
                formId = "pmct_incontractrevision";
            }
        }
        if (contAddAgreements.length > 0) {
            DynamicObject contAddAgreement = contAddAgreements[0];
            Date contAddAgreementDate = contAddAgreement.getDate("auditdate");
            if (maxDate.compareTo(auditDate) != 0) {
                if (maxDate.compareTo(contAddAgreementDate) < 0) {
                    lastObject = contAddAgreement;
                    formId = "pmct_inaddagreement";
                }
            } else {
                lastObject = contAddAgreement;
                formId = "pmct_inaddagreement";
            }
        }
        DynamicObjectCollection collectPlanEntry = new DynamicObjectCollection();
        PayPlanSourceEnum sourceBill = PayPlanSourceEnum.CONTRACT;
        if (formId != null) {
            lastObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(lastObject.getPkValue().toString()), (String)formId);
            String collectEntryRelateItemIdKey = null;
            BigDecimal latestAmountOfTax = BigDecimal.ZERO;
            if ("pmct_inclaimbill".equals(formId)) {
                collectPlanEntry = lastObject.getDynamicObjectCollection("claimincomeplanentry");
                sourceBill = PayPlanSourceEnum.CLAIM;
                collectEntryRelateItemIdKey = "conplanitemid";
                latestAmountOfTax = lastObject.getBigDecimal("afteroftaxamount");
            } else if ("pmct_contractrevision".equals(formId)) {
                collectPlanEntry = lastObject.getDynamicObjectCollection("incontpayplanentry");
                sourceBill = PayPlanSourceEnum.REVISE;
                collectEntryRelateItemIdKey = "conincomeitemid";
                latestAmountOfTax = lastObject.getBigDecimal("originaloftaxamount");
            } else if ("pmct_incontractrevision".equals(formId)) {
                collectPlanEntry = lastObject.getDynamicObjectCollection("incomeplanentry");
                sourceBill = PayPlanSourceEnum.MODIFY;
                collectEntryRelateItemIdKey = "conplanitemid";
                latestAmountOfTax = lastObject.getBigDecimal("latestamountoftax");
            } else if ("pmct_inaddagreement".equals(formId)) {
                collectPlanEntry = lastObject.getDynamicObjectCollection("incomeplanentry");
                sourceBill = PayPlanSourceEnum.ADDITION;
                collectEntryRelateItemIdKey = "conplanitemid";
                latestAmountOfTax = lastObject.getBigDecimal("latestamountoftax");
            }
            ContractCollectItemHelper.updateCollectItem(contract.getPkValue(), lastObject, collectPlanEntry, latestAmountOfTax, collectEntryRelateItemIdKey, sourceBill);
            ContractCollectItemHelper.handleCollectEntryRelateItemId(contract.getPkValue(), bill, curCollectPlanEntry);
        } else {
            lastObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contract.getPkValue().toString()), (String)"pmct_incontract");
            collectPlanEntry = lastObject.getDynamicObjectCollection("incontpayplanentry");
            BigDecimal latestAmountOfTax = lastObject.getBigDecimal("originaloftaxamount");
            ContractCollectItemHelper.updateCollectItem(contract.getPkValue(), lastObject, collectPlanEntry, latestAmountOfTax, "conplanitemid", PayPlanSourceEnum.CONTRACT);
            ContractCollectItemHelper.handleCollectEntryRelateItemId(contract.getPkValue(), bill, curCollectPlanEntry);
        }
    }

    public static void handleCollectEntryRelateItemId(Object contractPk, DynamicObject currentbill, DynamicObjectCollection currentPlanEntry) {
        String currentCollectEntryRelateItemIdKey = "conplanitemid";
        String currentBillFormId = currentbill.getDataEntityType().getName();
        if ("pmct_contractrevision".equals(currentBillFormId)) {
            currentCollectEntryRelateItemIdKey = "conincomeitemid";
        }
        for (DynamicObject collectPlanEntry : currentPlanEntry) {
            Long relateItemId = null;
            if (collectPlanEntry.get(currentCollectEntryRelateItemIdKey) instanceof String && !StringUtils.isEmpty((CharSequence)collectPlanEntry.getString(currentCollectEntryRelateItemIdKey))) {
                relateItemId = Long.parseLong(collectPlanEntry.getString(currentCollectEntryRelateItemIdKey));
            } else if (collectPlanEntry.get(currentCollectEntryRelateItemIdKey) instanceof Long) {
                relateItemId = collectPlanEntry.getLong(currentCollectEntryRelateItemIdKey);
            }
            if (QueryServiceHelper.exists((String)"pmbs_contractpayitem", relateItemId)) continue;
            collectPlanEntry.set(currentCollectEntryRelateItemIdKey, null);
        }
        SaveServiceHelper.update((DynamicObject)currentbill);
    }

    public static void createContractCollectItem(DynamicObjectCollection collectPlanEntry, String formId, DynamicObject lastObject, PayPlanSourceEnum source) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_contractcollectitem");
        DynamicObject contract = lastObject;
        if (!"pmct_incontract".equals(formId)) {
            contract = lastObject.getDynamicObject("contract");
        }
        if (contract != null) {
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract");
        }
        String collectFeq = "incomefeq";
        String remarks = "remarks";
        String amountIdentity = "incomeamountoftax";
        String incomeType = "incometype";
        String incomeWay = "incomeway";
        String incomePercent = "incomepercent";
        String planIncomeTime = "planincometime";
        String incomePlanSource = "incomeplansourceid";
        String collectPlanEntryId = null;
        if ("pmct_contractrevision".equals(formId)) {
            amountIdentity = "incomeamount";
            collectFeq = "incomemethod";
            remarks = "incomedescription";
            incomeType = "incometype";
            collectPlanEntryId = "incontpayplanentry";
        } else if ("pmct_incontract".equals(formId)) {
            incomeWay = "payway";
            incomePercent = "paypercent";
            planIncomeTime = "planpaytime";
            incomeType = "paytype";
            collectFeq = "paymethod";
            amountIdentity = "payamount";
            collectPlanEntryId = "incontpayplanentry";
        } else if ("pmct_inclaimbill".equals(formId)) {
            collectPlanEntryId = "claimincomeplanentry";
            incomeType = "incometype";
        } else if ("pmct_incontractrevision".equals(formId)) {
            collectPlanEntryId = "incomeplanentry";
            incomeType = "incometype";
        } else if ("pmct_inaddagreement".equals(formId)) {
            collectPlanEntryId = "incomeplanentry";
            incomeType = "incometype";
        }
        ArrayList<DynamicObject> contractCollectItemList = new ArrayList<DynamicObject>(16);
        String conPlanItemId = "pmct_contractrevision".equals(formId) ? "conincomeitemid" : "conplanitemid";
        for (DynamicObject planObject : collectPlanEntry) {
            DynamicObject contractCollectItem;
            if (planObject.getString(conPlanItemId).isEmpty()) continue;
            DynamicObject[] contractCollectItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(planObject.getString(conPlanItemId)))});
            if (contractCollectItems.length == 0) {
                contractCollectItem = new DynamicObject((DynamicObjectType)dt);
                contractCollectItem.set("id", (Object)Long.parseLong(planObject.getString(conPlanItemId)));
                contractCollectItem.set("masterid", (Object)Long.parseLong(planObject.getString(conPlanItemId)));
            } else {
                contractCollectItem = contractCollectItems[0];
                contractCollectItem = BusinessDataServiceHelper.loadSingle((Object)contractCollectItem.getPkValue(), (String)"pmbs_contractcollectitem");
            }
            contractCollectItem.set("collecttype", planObject.get(incomeType));
            contractCollectItem.set("collectfeq", planObject.get(collectFeq));
            contractCollectItem.set("collectway", planObject.get(incomeWay));
            contractCollectItem.set("collectpercent", planObject.get(incomePercent));
            contractCollectItem.set("plancollecttime", planObject.get(planIncomeTime));
            contractCollectItem.set("remarks", planObject.get(remarks));
            if ("pmct_incontract".equals(formId)) {
                String collectTypeName = ComboItemHelper.getName((String)formId, (String)collectPlanEntryId, null, (String)incomeType, (String)planObject.getString(incomeType));
                String itemName = ContractCollectItemHelper.setBillName(collectTypeName, source.getName(), lastObject.getString("billno"), planObject.getString("seq"));
                String itemNumber = ContractCollectItemHelper.setBillNumber(contract.getDynamicObject("org").getString("number"), incomeType, source.getValue(), lastObject.getString("billno"), planObject.getString("seq"));
                contractCollectItem.set("name", (Object)itemName);
                contractCollectItem.set("billno", (Object)itemNumber);
                contractCollectItem.set("sourcebill", planObject.getPkValue());
            } else {
                String incomePlanSourceId = planObject.getString(incomePlanSource);
                if (!incomePlanSourceId.isEmpty() && !"0".equals(incomePlanSourceId)) {
                    Map<String, String> numberNameMap = ContractCollectItemHelper.getSourceObject(incomePlanSourceId);
                    contractCollectItem.set("name", (Object)numberNameMap.get("billname"));
                    contractCollectItem.set("billno", (Object)numberNameMap.get("billnumber"));
                    contractCollectItem.set("sourcebill", (Object)Long.parseLong(incomePlanSourceId));
                } else {
                    String collectTypeName = ComboItemHelper.getName((String)formId, (String)collectPlanEntryId, null, (String)incomeType, (String)planObject.getString(incomeType));
                    String itemName = ContractCollectItemHelper.setBillName(collectTypeName, source.getName(), lastObject.getString("billno"), planObject.getString("seq"));
                    String itemNumber = ContractCollectItemHelper.setBillNumber(contract.getDynamicObject("org").getString("number"), incomeType, source.getValue(), lastObject.getString("billno"), planObject.getString("seq"));
                    contractCollectItem.set("name", (Object)itemName);
                    contractCollectItem.set("billno", (Object)itemNumber);
                    contractCollectItem.set("sourcebill", planObject.getPkValue());
                }
            }
            if (!StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_inperformrecords") && !StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_contractrevision")) {
                contractCollectItem.set("ctrlstrategy", (Object)planObject.getString("ctrlstrategy"));
                contractCollectItem.set("nodesettingsource", (Object)planObject.getString("nodesettingsource"));
                contractCollectItem.set("nodesetting", (Object)planObject.getDynamicObject("nodesetting"));
            }
            BigDecimal incomeAmOfTax = (BigDecimal)planObject.get(amountIdentity);
            contractCollectItem.set("collectamount", (Object)incomeAmOfTax);
            BigDecimal collectedComAmt = (BigDecimal)contractCollectItem.get("collectedcomamt");
            contractCollectItem.set("uncollectedamt", (Object)incomeAmOfTax.subtract(collectedComAmt));
            BigDecimal applicableAmt = incomeAmOfTax.subtract(contractCollectItem.getBigDecimal("appliedcomamt"));
            contractCollectItem.set("appliableamt", (Object)applicableAmt);
            contractCollectItem.set("currency", (Object)lastObject.getDynamicObject("currency"));
            contractCollectItem.set("autogenerated", (Object)Boolean.FALSE);
            contractCollectItem.set("contract", (Object)contract);
            contractCollectItem.set("customer", planObject.get("customer"));
            contractCollectItem.set("sourcebilltype", (Object)source.getValue());
            contractCollectItem.set("paydirection", (Object)PayDirectionEnum.IN.getValue());
            Date now = new Date();
            contractCollectItem.set("createtime", (Object)now);
            contractCollectItem.set("modifytime", (Object)now);
            contractCollectItem.set("creator", (Object)RequestContext.get().getUserId());
            contractCollectItem.set("modifier", (Object)RequestContext.get().getUserId());
            contractCollectItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
            contractCollectItem.set("status", (Object)StatusEnum.CHECKED.getValue());
            contractCollectItemList.add(contractCollectItem);
        }
        if (contractCollectItemList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])contractCollectItemList.toArray(new DynamicObject[contractCollectItemList.size()]));
        }
    }

    private static Map<String, String> getSourceObject(String incomePlanSourceId) {
        DynamicObjectCollection incomePlanEntry;
        DynamicObject sourceIncomePlan;
        HashMap<String, String> numberNameMap = new HashMap<String, String>();
        QFilter filter = new QFilter("incontpayplanentry.id", "=", (Object)Long.parseLong(incomePlanSourceId));
        DynamicObject incomePlanSourceObject = BusinessDataServiceHelper.loadSingle((String)"pmct_incontract", (String)"id", (QFilter[])new QFilter[]{filter});
        if (incomePlanSourceObject != null && (sourceIncomePlan = (DynamicObject)(incomePlanEntry = (incomePlanSourceObject = BusinessDataServiceHelper.loadSingle((Object)incomePlanSourceObject.getPkValue(), (String)"pmct_incontract")).getDynamicObjectCollection("incontpayplanentry")).stream().filter(entry -> incomePlanSourceId.equals(entry.getPkValue().toString())).findFirst().orElse(null)) != null) {
            String payType = sourceIncomePlan.getString("paytype");
            numberNameMap.put("billnumber", ContractCollectItemHelper.setBillNumber(incomePlanSourceObject.getDynamicObject("org").getString("number"), payType, PayPlanSourceEnum.CONTRACT.getValue(), incomePlanSourceObject.getString("billno"), sourceIncomePlan.getString("seq")));
            numberNameMap.put("billname", ContractCollectItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_incontract", (String)"incontpayplanentry", null, (String)"paytype", (String)payType), PayPlanSourceEnum.CONTRACT.getName(), incomePlanSourceObject.getString("billno"), sourceIncomePlan.getString("seq")));
            return numberNameMap;
        }
        filter = new QFilter("incontpayplanentry.id", "=", (Object)Long.parseLong(incomePlanSourceId));
        incomePlanSourceObject = BusinessDataServiceHelper.loadSingle((String)"pmct_contractrevision", (String)"id", (QFilter[])new QFilter[]{filter});
        if (incomePlanSourceObject != null && (sourceIncomePlan = (DynamicObject)(incomePlanEntry = (incomePlanSourceObject = BusinessDataServiceHelper.loadSingle((Object)incomePlanSourceObject.getPkValue(), (String)"pmct_contractrevision")).getDynamicObjectCollection("incontpayplanentry")).stream().filter(entry -> incomePlanSourceId.equals(entry.getPkValue().toString())).findFirst().orElse(null)) != null) {
            DynamicObject contract = incomePlanSourceObject.getDynamicObject("contract");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_contracttpl");
            String incomeType = sourceIncomePlan.getString("incometype");
            numberNameMap.put("billnumber", ContractCollectItemHelper.setBillNumber(contract.getDynamicObject("org").getString("number"), incomeType, PayPlanSourceEnum.REVISE.getValue(), incomePlanSourceObject.getString("billno"), sourceIncomePlan.getString("seq")));
            numberNameMap.put("billname", ContractCollectItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_contractrevision", (String)"incontpayplanentry", null, (String)"incometype", (String)incomeType), PayPlanSourceEnum.REVISE.getName(), incomePlanSourceObject.getString("billno"), sourceIncomePlan.getString("seq")));
            return numberNameMap;
        }
        filter = new QFilter("incomeplanentry.id", "=", (Object)Long.parseLong(incomePlanSourceId));
        incomePlanSourceObject = BusinessDataServiceHelper.loadSingle((String)"pmct_incontractrevision", (String)"id", (QFilter[])new QFilter[]{filter});
        if (incomePlanSourceObject != null && (sourceIncomePlan = (DynamicObject)(incomePlanEntry = (incomePlanSourceObject = BusinessDataServiceHelper.loadSingle((Object)incomePlanSourceObject.getPkValue(), (String)"pmct_incontractrevision")).getDynamicObjectCollection("incomeplanentry")).stream().filter(entry -> incomePlanSourceId.equals(entry.getPkValue().toString())).findFirst().orElse(null)) != null) {
            String incomeType = sourceIncomePlan.getString("incometype");
            numberNameMap.put("billnumber", ContractCollectItemHelper.setBillNumber(incomePlanSourceObject.getDynamicObject("org").getString("number"), incomeType, PayPlanSourceEnum.MODIFY.getValue(), incomePlanSourceObject.getString("billno"), sourceIncomePlan.getString("seq")));
            numberNameMap.put("billname", ContractCollectItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_incontractrevision", (String)"incomeplanentry", null, (String)"incometype", (String)incomeType), PayPlanSourceEnum.MODIFY.getName(), incomePlanSourceObject.getString("billno"), sourceIncomePlan.getString("seq")));
            return numberNameMap;
        }
        filter = new QFilter("incomeplanentry.id", "=", (Object)Long.parseLong(incomePlanSourceId));
        incomePlanSourceObject = BusinessDataServiceHelper.loadSingle((String)"pmct_inaddagreement", (String)"id", (QFilter[])new QFilter[]{filter});
        if (incomePlanSourceObject != null && (sourceIncomePlan = (DynamicObject)(incomePlanEntry = (incomePlanSourceObject = BusinessDataServiceHelper.loadSingle((Object)incomePlanSourceObject.getPkValue(), (String)"pmct_inaddagreement")).getDynamicObjectCollection("incomeplanentry")).stream().filter(entry -> incomePlanSourceId.equals(entry.getPkValue().toString())).findFirst().orElse(null)) != null) {
            String incomeType = sourceIncomePlan.getString("incometype");
            numberNameMap.put("billnumber", ContractCollectItemHelper.setBillNumber(incomePlanSourceObject.getDynamicObject("org").getString("number"), incomeType, PayPlanSourceEnum.ADDITION.getValue(), incomePlanSourceObject.getString("billno"), sourceIncomePlan.getString("seq")));
            numberNameMap.put("billname", ContractCollectItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_inaddagreement", (String)"incomeplanentry", null, (String)"incometype", (String)incomeType), PayPlanSourceEnum.ADDITION.getName(), incomePlanSourceObject.getString("billno"), sourceIncomePlan.getString("seq")));
            return numberNameMap;
        }
        filter = new QFilter("claimincomeplanentry.id", "=", (Object)Long.parseLong(incomePlanSourceId));
        incomePlanSourceObject = BusinessDataServiceHelper.loadSingle((String)"pmct_inclaimbill", (String)"id", (QFilter[])new QFilter[]{filter});
        if (incomePlanSourceObject != null && (sourceIncomePlan = (DynamicObject)(incomePlanEntry = (incomePlanSourceObject = BusinessDataServiceHelper.loadSingle((Object)incomePlanSourceObject.getPkValue(), (String)"pmct_inclaimbill")).getDynamicObjectCollection("claimincomeplanentry")).stream().filter(entry -> incomePlanSourceId.equals(entry.getPkValue().toString())).findFirst().orElse(null)) != null) {
            String incomeType = sourceIncomePlan.getString("incometype");
            numberNameMap.put("billnumber", ContractCollectItemHelper.setBillNumber(incomePlanSourceObject.getDynamicObject("org").getString("number"), incomeType, PayPlanSourceEnum.CLAIM.getValue(), incomePlanSourceObject.getString("billno"), sourceIncomePlan.getString("seq")));
            numberNameMap.put("billname", ContractCollectItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_inclaimbill", (String)"claimincomeplanentry", null, (String)"incometype", (String)incomeType), PayPlanSourceEnum.CLAIM.getName(), incomePlanSourceObject.getString("billno"), sourceIncomePlan.getString("seq")));
            return numberNameMap;
        }
        return numberNameMap;
    }

    public static void deleteCollectPlanItem(DynamicObject bill, DynamicObjectCollection planEntry, String currentFormId, DynamicObject contract) {
        ArrayList<Object> contractPlanItemIdList = new ArrayList<Object>(16);
        if (planEntry.size() > 0) {
            for (DynamicObject payPlan : planEntry) {
                Object contractPlanItemId;
                if ("pmct_contractrevision".equals(currentFormId)) {
                    contractPlanItemId = payPlan.getLong("conincomeitemid");
                    if ((Long)contractPlanItemId == 0L) continue;
                    contractPlanItemIdList.add(contractPlanItemId);
                    payPlan.set("conincomeitemid", (Object)0);
                    continue;
                }
                contractPlanItemId = payPlan.getString("conplanitemid");
                if (((String)contractPlanItemId).isEmpty()) continue;
                contractPlanItemIdList.add(Long.parseLong((String)contractPlanItemId));
                payPlan.set("conplanitemid", null);
            }
        } else {
            QFilter autoFilter = new QFilter("autogenerated", "=", (Object)Boolean.TRUE);
            QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
            DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"id", (QFilter[])new QFilter[]{autoFilter, contractFilter});
            if (payItems != null && payItems.length > 0) {
                for (DynamicObject payItem : payItems) {
                    DynamicObject inClaim;
                    long contractPlanItemId = Long.parseLong(payItem.getPkValue().toString());
                    DynamicObject collectItem = BusinessDataServiceHelper.loadSingle((Object)contractPlanItemId, (String)"pmbs_contractcollectitem");
                    String sourceBillType = collectItem.getString("sourcebilltype");
                    String sourceBillId = collectItem.getString("sourcebill");
                    if (PayPlanSourceEnum.CLAIM.getValue().equals(sourceBillType) && !StringUtils.equals((CharSequence)"0", (CharSequence)sourceBillId) && !(inClaim = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"pmct_claimbilltpl")).getBoolean("isneedsettle") && !StringUtils.equals((CharSequence)sourceBillId, (CharSequence)bill.getPkValue().toString())) continue;
                    contractPlanItemIdList.add(Long.parseLong(payItem.getPkValue().toString()));
                }
            }
        }
        if (contractPlanItemIdList.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractcollectitem"), (Object[])contractPlanItemIdList.toArray());
        }
    }

    public static void writeBackToCollectItemForIncomeRegister(String operationKey, Map<Object, BigDecimal> entryAmtSumMap) {
        DynamicObject[] payItems;
        for (DynamicObject payItem : payItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"collectedamt,collectedcomamt,uncollectedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", entryAmtSumMap.keySet())})) {
            BigDecimal collectedAmt = payItem.getBigDecimal("collectedamt");
            BigDecimal collectedComAmt = payItem.getBigDecimal("collectedcomamt");
            BigDecimal uncollectedAmt = payItem.getBigDecimal("uncollectedamt");
            BigDecimal entrySumAmt = entryAmtSumMap.get(payItem.getPkValue());
            switch (operationKey) {
                case "submit": {
                    collectedComAmt = collectedComAmt.add(entrySumAmt);
                    uncollectedAmt = uncollectedAmt.subtract(entrySumAmt);
                    break;
                }
                case "unsubmit": {
                    collectedComAmt = collectedComAmt.subtract(entrySumAmt);
                    uncollectedAmt = uncollectedAmt.add(entrySumAmt);
                    break;
                }
                case "audit": {
                    collectedAmt = collectedAmt.add(entrySumAmt);
                    break;
                }
                case "unaudit": {
                    collectedAmt = collectedAmt.subtract(entrySumAmt);
                    collectedComAmt = collectedComAmt.subtract(entrySumAmt);
                    uncollectedAmt = uncollectedAmt.add(entrySumAmt);
                    break;
                }
            }
            payItem.set("collectedamt", (Object)collectedAmt);
            payItem.set("collectedcomamt", (Object)collectedComAmt);
            payItem.set("uncollectedamt", (Object)uncollectedAmt);
        }
        SaveServiceHelper.update((DynamicObject[])payItems);
    }

    public static Map<String, Map<Object, String>> getSrcObjCompleteMap(DynamicObject[] collectItems) {
        HashMap<String, HashSet<Object>> sourceToObjIdsMap = new HashMap<String, HashSet<Object>>(3);
        for (DynamicObject collectItem : collectItems) {
            DynamicObject[] nodeSetting = collectItem.getDynamicObject("nodesetting");
            if (nodeSetting == null) continue;
            String nodeSettingSource = collectItem.getString("nodesettingsource");
            HashSet<Object> nodeObjSet = (HashSet<Object>)sourceToObjIdsMap.get(nodeSettingSource);
            if (nodeObjSet != null) {
                nodeObjSet.add(nodeSetting.getPkValue());
                continue;
            }
            nodeObjSet = new HashSet<Object>();
            nodeObjSet.add(nodeSetting.getPkValue());
            sourceToObjIdsMap.put(nodeSettingSource, nodeObjSet);
        }
        HashMap<String, Map<Object, String>> srcObjCompleteMap = new HashMap<String, Map<Object, String>>(3);
        Set taskSet = (Set)sourceToObjIdsMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        if (taskSet != null && !taskSet.isEmpty()) {
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)"percent,completionstatus,islatest,sourcetask", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)taskSet)});
            HashMap<Long, Object> srcToCurTaskMap = new HashMap<Long, Object>(tasks.length);
            for (DynamicObject task : tasks) {
                srcToCurTaskMap.put(task.getLong("sourcetask.id"), task.getPkValue());
            }
            taskSet = Arrays.stream(tasks).map(o -> o.getLong("sourcetask.id")).collect(Collectors.toSet());
            tasks = BusinessDataServiceHelper.load((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)"percent,completionstatus,islatest,sourcetask", (QFilter[])new QFilter[]{new QFilter("sourcetask", "in", taskSet), new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue())});
            HashMap nodeObjCompMap = new HashMap();
            for (DynamicObject task : tasks) {
                String completionStatus = task.getString("completionstatus");
                int percent = task.getInt("percent");
                if (StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue()) || StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue()) || percent == 100) {
                    nodeObjCompMap.put(srcToCurTaskMap.get(task.getLong("sourcetask.id")), TaskCompleteStateEnum.COMPLETE.getValue());
                    continue;
                }
                nodeObjCompMap.put(srcToCurTaskMap.get(task.getLong("sourcetask.id")), TaskCompleteStateEnum.INCOMPLETE.getValue());
            }
            srcObjCompleteMap.put(NodeSettingSourceEnum.PMBS_TASK.getValue(), nodeObjCompMap);
        }
        return srcObjCompleteMap;
    }

    public static DynamicObject getLatestTask(DynamicObject task) {
        if (task != null) {
            boolean islatest = task.getBoolean("islatest");
            if (islatest) {
                return task;
            }
            task = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)"islatest,sourcetask", (QFilter[])new QFilter[]{new QFilter("sourcetask", "in", task.get("sourcetask.id")), new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue())});
            if (task != null) {
                return task;
            }
        }
        return null;
    }
}

