/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.utils.ContractTypeUtils;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.ContractPayItemSourceEnum;
import kd.pmgt.pmbs.common.enums.ContractPayTypeEnum;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.InvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.OutInvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class ContractHelper {
    private static final Log logger = LogFactory.getLog(ContractHelper.class);
    private static final String PAYDIRECTION = "paydirection";
    private static final int FILTERSTATUS_ONE = 1;
    private static final int FILTERSTATUS_TWO = 2;
    private static final int FILTERSTATUS_THREE = 3;
    private static final int FILTERSTATUS_FOUR = 4;
    private static Map<Integer, Set<Object>> contStatusMap = new HashMap<Integer, Set<Object>>(3);
    private static final String InvoiceSellerParam = "invoicesellerparam";

    public static void initListCardEntry(IFormView view, String cardEntryKey, DynamicObject contract) {
        IDataModel model = view.getModel();
        model.deleteEntryData(cardEntryKey);
        DynamicObjectCollection listConfigs = ContractHelper.getListConfigsByContract(contract);
        if (listConfigs == null) {
            return;
        }
        for (DynamicObject listConfig : listConfigs) {
            String tabName = listConfig.getString("tabname");
            String cmpRule = listConfig.getString("computerule");
            int rowIndex = model.createNewEntryRow(cardEntryKey);
            model.setValue("modelname", (Object)tabName, rowIndex);
            model.setValue("listmodelid", listConfig.getPkValue(), rowIndex);
            if (StringUtils.equals((CharSequence)"00", (CharSequence)cmpRule)) {
                model.setValue("cmptype", (Object)"(+)", rowIndex);
                continue;
            }
            if (StringUtils.equals((CharSequence)"01", (CharSequence)cmpRule)) {
                model.setValue("cmptype", (Object)"(-)", rowIndex);
                continue;
            }
            if (!StringUtils.equals((CharSequence)"02", (CharSequence)cmpRule)) continue;
            model.setValue("cmptype", (Object)"(0)", rowIndex);
        }
        CardEntry cardEntry = (CardEntry)view.getControl(cardEntryKey);
        cardEntry.selectRows(0);
    }

    public static DynamicObjectCollection getListConfigsByContract(DynamicObject contract) {
        if (contract == null) {
            return null;
        }
        DynamicObject contType = contract.getDynamicObject("contracttype");
        if (contType == null) {
            return null;
        }
        boolean isOnList = (contType = BusinessDataServiceHelper.loadSingle((Object)contType.getPkValue(), (String)"pmct_conttype")).getBoolean("isonlist");
        if (!isOnList) {
            return null;
        }
        return ContractTypeUtils.getListConfigs(contType);
    }

    public static void showPayPlanEntry(IFormView view, DynamicObject contract, String panelKey, String payPlanKey) {
        boolean isNeedSettle;
        if (contract == null) {
            view.getModel().deleteEntryData(payPlanKey);
            view.setVisible(Boolean.FALSE, new String[]{panelKey});
            return;
        }
        String formId = view.getFormShowParameter().getFormId();
        boolean bl = isNeedSettle = StringUtils.equals((CharSequence)"pmct_outclaimbill", (CharSequence)formId) ? (Boolean)view.getModel().getValue("isneedsettle") : true;
        if (!isNeedSettle) {
            view.setVisible(Boolean.FALSE, new String[]{panelKey});
        } else {
            DynamicObjectCollection outContPayplanEntry = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract")).getDynamicObjectCollection("outcontpayplanentry");
            if (outContPayplanEntry != null && !outContPayplanEntry.isEmpty()) {
                view.setVisible(Boolean.TRUE, new String[]{panelKey});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{panelKey});
            }
        }
    }

    public static void showIncomePlanEntry(IFormView view, DynamicObject contract, String panelKey, String incomePlanKey) {
        boolean isNeedSettle;
        if (contract == null) {
            view.getModel().deleteEntryData(incomePlanKey);
            view.setVisible(Boolean.FALSE, new String[]{panelKey});
            return;
        }
        String formId = view.getFormShowParameter().getFormId();
        boolean bl = isNeedSettle = StringUtils.equals((CharSequence)"pmct_inclaimbill", (CharSequence)formId) ? (Boolean)view.getModel().getValue("isneedsettle") : true;
        if (!isNeedSettle) {
            view.setVisible(Boolean.FALSE, new String[]{panelKey});
        } else {
            DynamicObjectCollection inContPayplanEntry = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract")).getDynamicObjectCollection("incontpayplanentry");
            if (inContPayplanEntry != null && !inContPayplanEntry.isEmpty()) {
                view.setVisible(Boolean.TRUE, new String[]{panelKey});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{panelKey});
            }
        }
    }

    public static void loadPayPlanEntry(IFormView view, DynamicObject contract, String payPlanKey) {
        if (contract == null) {
            view.getModel().deleteEntryData("claimpayplanentry");
            view.setVisible(Boolean.FALSE, new String[]{payPlanKey});
            return;
        }
        Boolean isNeedSettle = (Boolean)view.getModel().getValue("isneedsettle");
        if (!isNeedSettle.booleanValue()) {
            view.getModel().deleteEntryData("claimpayplanentry");
            view.setVisible(Boolean.FALSE, new String[]{payPlanKey});
            return;
        }
        DynamicObject[] payItems = ContractHelper.getManualPayItemByContract(contract.getPkValue());
        if (payItems.length <= 0) {
            view.getModel().deleteEntryData("claimpayplanentry");
            view.setVisible(Boolean.FALSE, new String[]{payPlanKey});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{payPlanKey});
        DynamicObjectCollection changePayPlanEntryEntity = view.getModel().getEntryEntity("claimpayplanentry");
        changePayPlanEntryEntity.clear();
        DynamicObjectType entryDt = changePayPlanEntryEntity.getDynamicObjectType();
        for (DynamicObject payItem : payItems) {
            DynamicObject changePayPlanObj = new DynamicObject(entryDt);
            changePayPlanObj.set("supplier", payItem.get("supplier"));
            changePayPlanObj.set("paytype", (Object)payItem.getString("paytype"));
            changePayPlanObj.set("payfeq", (Object)payItem.getString("payfeq"));
            changePayPlanObj.set("payway", (Object)payItem.getDynamicObject("payway"));
            changePayPlanObj.set("paypercent", (Object)payItem.getBigDecimal("paypercent"));
            changePayPlanObj.set("payamountoftax", (Object)payItem.getBigDecimal("payamount"));
            changePayPlanObj.set("planpaytime", (Object)payItem.getDate("planpaytime"));
            changePayPlanObj.set("remarks", (Object)payItem.getString("remarks"));
            changePayPlanObj.set("conplanitemid", (Object)payItem.getString("id"));
            changePayPlanObj.set("payplansourceid", (Object)payItem.getString("payplanentryid"));
            DynamicObject nodeSetting = payItem.getDynamicObject("nodesetting");
            changePayPlanObj.set("nodesetting", (Object)nodeSetting);
            if (null != nodeSetting) {
                nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                String completionStatus = nodeSetting.getString("completionstatus");
                String status = CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                changePayPlanObj.set("taskcompletestate", (Object)status);
            }
            changePayPlanObj.set("nodesettingsource", (Object)payItem.getString("nodesettingsource"));
            changePayPlanObj.set("ctrlstrategy", (Object)payItem.getString("ctrlstrategy"));
            changePayPlanObj.set("conplanitemid", (Object)payItem.getPkValue().toString());
            String payItemName = payItem.getLocaleString("name").getLocaleValue();
            if (StringUtils.isBlank((CharSequence)payItemName)) {
                payItemName = payItem.getString("name");
            }
            changePayPlanObj.set("payitemname", (Object)payItemName);
            changePayPlanEntryEntity.add((Object)changePayPlanObj);
        }
        view.getModel().updateEntryCache(changePayPlanEntryEntity);
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
        view.updateView("claimpayplanentry");
        boolean isMultiContract = contract.getBoolean("ismulticontract");
        if (!isMultiContract && (changePayPlanEntryEntity = view.getModel().getEntryEntity("claimpayplanentry")) != null && changePayPlanEntryEntity.size() > 0) {
            view.setEnable(Boolean.valueOf(false), new String[]{"supplier"});
        }
    }

    public static void loadIncomePlanEntry(IFormView view, DynamicObject contract, String payPlanKey) {
        if (contract == null) {
            view.getModel().deleteEntryData("claimincomeplanentry");
            view.setVisible(Boolean.FALSE, new String[]{payPlanKey});
            return;
        }
        Boolean isNeedSettle = (Boolean)view.getModel().getValue("isneedsettle");
        if (!isNeedSettle.booleanValue()) {
            view.getModel().deleteEntryData("claimincomeplanentry");
            view.setVisible(Boolean.FALSE, new String[]{payPlanKey});
            return;
        }
        DynamicObject[] incomeItems = ContractHelper.getManualIncomeItemByContract(contract.getPkValue());
        if (incomeItems.length <= 0) {
            view.getModel().deleteEntryData("claimincomeplanentry");
            view.setVisible(Boolean.FALSE, new String[]{payPlanKey});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{payPlanKey});
        DynamicObjectCollection changeIncomePlanEntryEntity = view.getModel().getEntryEntity("claimincomeplanentry");
        changeIncomePlanEntryEntity.clear();
        DynamicObjectType entryDt = changeIncomePlanEntryEntity.getDynamicObjectType();
        for (DynamicObject incomeItem : incomeItems) {
            DynamicObject incomePlanObj = new DynamicObject(entryDt);
            incomePlanObj.set("customer", (Object)incomeItem.getDynamicObject("customer"));
            incomePlanObj.set("incometype", (Object)incomeItem.getString("collecttype"));
            incomePlanObj.set("incomefeq", (Object)incomeItem.getString("collectfeq"));
            incomePlanObj.set("incomeway", (Object)incomeItem.getDynamicObject("collectway"));
            incomePlanObj.set("incomepercent", (Object)incomeItem.getBigDecimal("collectpercent"));
            incomePlanObj.set("incomeamountoftax", (Object)incomeItem.getBigDecimal("collectamount"));
            incomePlanObj.set("planincometime", (Object)incomeItem.getDate("plancollecttime"));
            incomePlanObj.set("remarks", (Object)incomeItem.getString("remarks"));
            incomePlanObj.set("incomeplansourceid", (Object)String.valueOf(incomeItem.getLong("sourcebill")));
            incomePlanObj.set("conplanitemid", (Object)String.valueOf(incomeItem.getPkValue()));
            DynamicObject nodeSetting = incomeItem.getDynamicObject("nodesetting");
            incomePlanObj.set("nodesetting", (Object)nodeSetting);
            if (null != nodeSetting) {
                nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
                String completionStatus = nodeSetting.getString("completionstatus");
                String status = CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
                incomePlanObj.set("taskcompletestate", (Object)status);
            }
            incomePlanObj.set("nodesettingsource", (Object)incomeItem.getString("nodesettingsource"));
            incomePlanObj.set("ctrlstrategy", (Object)incomeItem.getString("ctrlstrategy"));
            incomePlanObj.set("incomeitemname", (Object)incomeItem.getString("name"));
            changeIncomePlanEntryEntity.add((Object)incomePlanObj);
        }
        view.getModel().updateEntryCache(changeIncomePlanEntryEntity);
        view.updateView("claimincomeplanentry");
    }

    public static boolean isOutContract(IDataModel model) {
        String payDirection = model.getDataEntity().getString(PAYDIRECTION);
        return StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue());
    }

    public static DynamicObject[] getManualIncomeItemByContract(Object contractId) {
        QFilter contractFilter = new QFilter("contract", "=", contractId);
        QFilter autogenFilter = new QFilter("autogenerated", "=", (Object)DefaultEnum.NO.getValue());
        QFilter sourceBillTypeFilter = new QFilter("sourcebilltype", "!=", (Object)PayPlanSourceEnum.PERFORM.getValue());
        String selectProperties = String.join((CharSequence)",", "customer", "collecttype", "collectfeq", "collectway", "collectpercent", "collectamount", "plancollecttime", "remarks", "sourcebill", "nodesetting", "ctrlstrategy", "nodesettingsource", "name");
        return BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)selectProperties, (QFilter[])new QFilter[]{contractFilter, autogenFilter, sourceBillTypeFilter});
    }

    public static DynamicObject[] getManualPayItemByContract(Object contractId) {
        QFilter contractFilter = new QFilter("contract", "=", contractId);
        QFilter autogenFilter = new QFilter("autogenerated", "=", (Object)DefaultEnum.NO.getValue());
        QFilter sourceFilter = new QFilter("source", "=", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
        String selectProperties = String.join((CharSequence)",", "supplier", "paytype", "payfeq", "payway", "paypercent", "payamount", "planpaytime", "remarks", "payplanentryid", "nodesetting", "ctrlstrategy", "nodesettingsource", "name");
        return BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)selectProperties, (QFilter[])new QFilter[]{contractFilter, autogenFilter, sourceFilter});
    }

    public static void showContractList(IFormView view) {
        DynamicObject contract = (DynamicObject)view.getModel().getValue("contract");
        if (contract == null) {
            return;
        }
        DynamicObjectCollection listConfigs = ContractHelper.getListConfigsByContract(contract);
        if (listConfigs == null || listConfigs.isEmpty()) {
            return;
        }
        CardEntry cardEntry = (CardEntry)view.getControl("kapianentry");
        cardEntry.selectRows(0, true);
        if (listConfigs.size() == 1) {
            view.setVisible(Boolean.FALSE, new String[]{"kapianentry"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"kapianentry"});
        }
    }

    public static DynamicObject[] getContractByMultiPartSettle(Long proPk, Long orgPk) {
        logger.info("getContractByMultiPartSettle params value, orgPk: {}, proPk: {}", (Object)orgPk, (Object)proPk);
        if (orgPk == null && proPk == null) {
            return null;
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()).and("contractstatus.number", "=", (Object)ContractStatusEnum.RUNNING.getValue());
        if (proPk != null) {
            QFilter proFilter = new QFilter("contproscope.multisettlepro", "=", (Object)proPk);
            proFilter.and(statusFilter);
            return BusinessDataServiceHelper.load((String)"pmct_contracttpl", (String)"billno,billname", (QFilter[])new QFilter[]{proFilter});
        }
        QFilter orgFilter = new QFilter("contorgscope.multisettleorg", "=", (Object)orgPk);
        orgFilter.and(statusFilter);
        return BusinessDataServiceHelper.load((String)"pmct_contracttpl", (String)"billno,billname", (QFilter[])new QFilter[]{orgFilter});
    }

    public static DynamicObject[] getContractByMultiPartSettle(List<Long> proPks, List<Long> orgPks) {
        logger.info("getContractByMultiPartSettle params value, orgPks: {}, proPks: {}", orgPks, proPks);
        if (CollectionUtils.isEmpty(orgPks) && CollectionUtils.isEmpty(proPks)) {
            return null;
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()).and("contractstatus.number", "=", (Object)ContractStatusEnum.RUNNING.getValue());
        if (proPks != null && !proPks.isEmpty()) {
            QFilter proFilter = new QFilter("contproscope.multisettlepro", "in", proPks);
            proFilter.and(statusFilter);
            return BusinessDataServiceHelper.load((String)"pmct_contracttpl", (String)"billno,billname", (QFilter[])new QFilter[]{proFilter});
        }
        QFilter orgFilter = new QFilter("contorgscope.multisettleorg", "in", orgPks);
        orgFilter.and(statusFilter);
        return BusinessDataServiceHelper.load((String)"pmct_contracttpl", (String)"billno,billname", (QFilter[])new QFilter[]{orgFilter});
    }

    public static DynamicObject[] getMultiPartSettleContracts(List<Long> proPks) {
        logger.info("getMultiPartSettleContracts params value, proPks: {}", proPks);
        if (proPks == null || proPks.isEmpty()) {
            return null;
        }
        HashSet<String> billStatusSet = new HashSet<String>(4);
        billStatusSet.add(StatusEnum.UNCHECKED.getValue());
        billStatusSet.add(StatusEnum.CHECKED.getValue());
        QFilter statusFilter = new QFilter("billstatus", "in", billStatusSet);
        QFilter proFilter = new QFilter("contproscope.multisettlepro", "in", proPks);
        statusFilter.and(proFilter);
        return BusinessDataServiceHelper.load((String)"pmct_contracttpl", (String)"billno,billname", (QFilter[])new QFilter[]{statusFilter});
    }

    private static Set<Object> getContStatusIds(int filterStatusType) {
        Set<Object> contStatusIdSet = contStatusMap.get(filterStatusType);
        HashSet<String> contStatusNumSet = null;
        if (contStatusIdSet == null) {
            if (filterStatusType == 1) {
                DynamicObject[] contStatusObjs;
                contStatusIdSet = new HashSet<Object>(4);
                contStatusNumSet = new HashSet<String>(4);
                contStatusNumSet.add(ContractStatusEnum.INDRAFT.getValue());
                contStatusNumSet.add(ContractStatusEnum.INAUDIT.getValue());
                contStatusNumSet.add(ContractStatusEnum.APPROVED.getValue());
                contStatusNumSet.add(ContractStatusEnum.CLOSED.getValue());
                QFilter contStatusFilter = new QFilter("number", "not in", contStatusNumSet);
                for (DynamicObject contStatusObj : contStatusObjs = BusinessDataServiceHelper.load((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter})) {
                    contStatusIdSet.add(contStatusObj.getPkValue());
                }
                contStatusMap.put(1, contStatusIdSet);
            } else if (filterStatusType == 2) {
                DynamicObject[] contStatusObjs;
                contStatusIdSet = new HashSet<Object>(3);
                contStatusNumSet = new HashSet(3);
                contStatusNumSet.add(ContractStatusEnum.INDRAFT.getValue());
                contStatusNumSet.add(ContractStatusEnum.INAUDIT.getValue());
                contStatusNumSet.add(ContractStatusEnum.APPROVED.getValue());
                QFilter contStatusFilter = new QFilter("number", "not in", contStatusNumSet);
                for (DynamicObject contStatusObj : contStatusObjs = BusinessDataServiceHelper.load((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter})) {
                    contStatusIdSet.add(contStatusObj.getPkValue());
                }
                contStatusMap.put(2, contStatusIdSet);
            } else if (filterStatusType == 4) {
                DynamicObject[] contStatusObjs;
                contStatusIdSet = new HashSet<Object>(3);
                contStatusNumSet = new HashSet(3);
                contStatusNumSet.add(ContractStatusEnum.INDRAFT.getValue());
                contStatusNumSet.add(ContractStatusEnum.INAUDIT.getValue());
                contStatusNumSet.add(ContractStatusEnum.APPROVED.getValue());
                QFilter contStatusFilter = new QFilter("number", "not in", contStatusNumSet);
                for (DynamicObject contStatusObj : contStatusObjs = BusinessDataServiceHelper.load((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter})) {
                    contStatusIdSet.add(contStatusObj.getPkValue());
                }
                contStatusMap.put(4, contStatusIdSet);
            }
        }
        return contStatusIdSet;
    }

    public static void getContractByStatus(String formid, ListShowParameter showParameter, String paydirection) {
        if (StringUtils.equals((CharSequence)paydirection, (CharSequence)PayDirectionEnum.IN.getValue())) {
            if (StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_incontractrevision") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_inclarificbill") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_inclaimbill") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_inperformrecords") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_incontract_settle") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_infinalsettle") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_inaddagreement")) {
                Set<Object> contStatusIdSet = ContractHelper.getContStatusIds(1);
                QFilter contStatusFilter = new QFilter("contractstatus", "in", contStatusIdSet);
                QFilter payDirectionFilter = new QFilter(PAYDIRECTION, "=", (Object)paydirection);
                contStatusFilter.and(payDirectionFilter);
                showParameter.getListFilterParameter().getQFilters().add(contStatusFilter);
                return;
            }
            if (StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_incomeapply") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_incomeregister") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_outinvoice")) {
                Set<Object> contStatusIdSet = ContractHelper.getContStatusIds(2);
                QFilter contStatusFilter = new QFilter("contractstatus", "in", contStatusIdSet);
                QFilter payDirectionFilter = new QFilter(PAYDIRECTION, "=", (Object)paydirection);
                contStatusFilter.and(payDirectionFilter);
                showParameter.getListFilterParameter().getQFilters().add(contStatusFilter);
                return;
            }
        } else if (StringUtils.equals((CharSequence)paydirection, (CharSequence)PayDirectionEnum.OUT.getValue())) {
            if (StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_outcontractrevision") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_outclarificbill") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_outclaimbill") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_outperformrecords") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_outcontract_settle") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_outfinalsettle") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_outaddagreement")) {
                Set<Object> contStatusIdSet = ContractHelper.getContStatusIds(1);
                QFilter contStatusFilter = new QFilter("contractstatus", "in", contStatusIdSet);
                QFilter payDirectionFilter = new QFilter(PAYDIRECTION, "=", (Object)paydirection);
                contStatusFilter.and(payDirectionFilter);
                showParameter.getListFilterParameter().getQFilters().add(contStatusFilter);
                return;
            }
            if (StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_paymentapply") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_paymentregister") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_ininvoice") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_applymentpay")) {
                Set<Object> contStatusIdSet = ContractHelper.getContStatusIds(2);
                QFilter contStatusFilter = new QFilter("contractstatus", "in", contStatusIdSet);
                QFilter payDirectionFilter = new QFilter(PAYDIRECTION, "=", (Object)paydirection);
                contStatusFilter.and(payDirectionFilter);
                showParameter.getListFilterParameter().getQFilters().add(contStatusFilter);
                return;
            }
        } else {
            if (StringUtils.equals((CharSequence)formid, (CharSequence)"pmco_contractcost") || StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_contractkanban")) {
                Set<Object> contStatusIdSet = ContractHelper.getContStatusIds(2);
                QFilter contStatusFilter = new QFilter("contractstatus", "in", contStatusIdSet);
                showParameter.getListFilterParameter().getQFilters().add(contStatusFilter);
                return;
            }
            if (StringUtils.equals((CharSequence)formid, (CharSequence)"pmct_contract")) {
                Set<Object> contStatusIdSet = ContractHelper.getContStatusIds(4);
                QFilter contStatusFilter = new QFilter("contractstatus", "in", contStatusIdSet);
                showParameter.getListFilterParameter().getQFilters().add(contStatusFilter);
                return;
            }
        }
    }

    public static QFilter getContractByStatus(String formId, String payDirection) {
        if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue())) {
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_incontractrevision") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_inclarificbill") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_inclaimbill") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_inperformrecords") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_incontract_settle") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_infinalsettle") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_inaddagreement")) {
                Set<Object> contStatusIdSet = ContractHelper.getContStatusIds(1);
                QFilter contStatusFilter = new QFilter("contractstatus", "in", contStatusIdSet);
                QFilter payDirectionFilter = new QFilter(PAYDIRECTION, "=", (Object)payDirection);
                contStatusFilter.and(payDirectionFilter);
                return contStatusFilter;
            }
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_incomeapply") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_incomeregister") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outinvoice") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_monthlyfundplan") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_fundplanning")) {
                Set<Object> contStatusIdSet = ContractHelper.getContStatusIds(2);
                QFilter contStatusFilter = new QFilter("contractstatus", "in", contStatusIdSet);
                QFilter payDirectionFilter = new QFilter(PAYDIRECTION, "=", (Object)payDirection);
                contStatusFilter.and(payDirectionFilter);
                return contStatusFilter;
            }
        } else if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue())) {
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outcontractrevision") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outclarificbill") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outclaimbill") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outperformrecords") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outcontract_settle") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outfinalsettle") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_outaddagreement")) {
                Set<Object> contStatusIdSet = ContractHelper.getContStatusIds(1);
                QFilter contStatusFilter = new QFilter("contractstatus", "in", contStatusIdSet);
                QFilter payDirectionFilter = new QFilter(PAYDIRECTION, "=", (Object)payDirection);
                contStatusFilter.and(payDirectionFilter);
                return contStatusFilter;
            }
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_paymentapply") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_paymentregister") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_ininvoice") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_applymentpay") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_monthlyfundplan") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_fundplanning")) {
                Set<Object> contStatusIdSet = ContractHelper.getContStatusIds(2);
                QFilter contStatusFilter = new QFilter("contractstatus", "in", contStatusIdSet);
                QFilter payDirectionFilter = new QFilter(PAYDIRECTION, "=", (Object)payDirection);
                contStatusFilter.and(payDirectionFilter);
                return contStatusFilter;
            }
        } else {
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmco_contractcost") || StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_contractkanban")) {
                Set<Object> contStatusIdSet = ContractHelper.getContStatusIds(2);
                return new QFilter("contractstatus", "in", contStatusIdSet);
            }
            if (StringUtils.equals((CharSequence)formId, (CharSequence)"pmct_contract")) {
                Set<Object> contStatusIdSet = ContractHelper.getContStatusIds(4);
                return new QFilter("contractstatus", "in", contStatusIdSet);
            }
        }
        return null;
    }

    public static Set<Object> getSharePermPros(IFormView view, DynamicObject contract) {
        String[] excludeStatusIds = new String[]{ProjectStatusEnum.FINANCIAL_CLOSE.getId()};
        List orgList = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)view.getFormShowParameter().getAppId(), (String)view.getEntityId(), (String)"view");
        DynamicObject[] permProjects = ProjectPermissionHelper.getPermProjectByStatus((List)orgList, (boolean)true, (String)view.getEntityId(), (String)"view", (String[])excludeStatusIds);
        HashSet<Object> proIdSet = null;
        if (permProjects != null && permProjects.length > 0) {
            Set permProIdSet = Arrays.stream(permProjects).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            DynamicObjectCollection contShareProScope = contract.getDynamicObjectCollection("contproscope");
            proIdSet = new HashSet<Object>(contShareProScope.size());
            for (DynamicObject contShareProRow : contShareProScope) {
                DynamicObject multiSettlePro = contShareProRow.getDynamicObject("multisettlepro");
                if (!permProIdSet.contains(multiSettlePro.getPkValue())) continue;
                proIdSet.add(multiSettlePro.getPkValue());
            }
        }
        return proIdSet;
    }

    public static Boolean checkProPerm(String appId, String entityId, DynamicObject project) {
        Set permProIdSet;
        if (project == null) {
            return false;
        }
        String[] excludeStatusIds = new String[]{ProjectStatusEnum.FINANCIAL_CLOSE.getId()};
        List orgList = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)appId, (String)entityId, (String)"view");
        DynamicObject[] permProjects = ProjectPermissionHelper.getPermProjectByStatus((List)orgList, (boolean)true, (String)entityId, (String)"view", (String[])excludeStatusIds);
        if (permProjects != null && permProjects.length > 0 && (permProIdSet = Arrays.stream(permProjects).map(DataEntityBase::getPkValue).collect(Collectors.toSet())).contains(Long.parseLong(String.valueOf(project.getPkValue())))) {
            return true;
        }
        return false;
    }

    public static DynamicObject getContractProject(String appId, String entityId, DynamicObject project, DynamicObject entryContract) {
        if (project != null) {
            return project;
        }
        if (entryContract.getBoolean("multipartsettlement")) {
            DynamicObjectCollection proScopes = entryContract.getDynamicObjectCollection("contproscope");
            if (proScopes.size() > 0) {
                String[] excludeStatusIds = new String[]{ProjectStatusEnum.FINANCIAL_CLOSE.getId()};
                List orgList = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)appId, (String)entityId, (String)"view");
                DynamicObject[] permProjects = ProjectPermissionHelper.getPermProjectByStatus((List)orgList, (boolean)true, (String)entityId, (String)"view", (String[])excludeStatusIds);
                Set permProIdSet = Arrays.stream(permProjects).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                for (DynamicObject proScope : proScopes) {
                    DynamicObject sharepro = proScope.getDynamicObject("multisettlepro");
                    if (!permProIdSet.contains(sharepro.getPkValue())) continue;
                    return sharepro;
                }
            }
            return null;
        }
        return entryContract.getDynamicObject("project");
    }

    public static Boolean getContractProjectEnable(DynamicObject project, DynamicObject entryContract) {
        if (entryContract == null) {
            return false;
        }
        if (project != null || !entryContract.getBoolean("multipartsettlement")) {
            return false;
        }
        return true;
    }

    public static QFilter getEntryProFilter(String appId, String entityId, DynamicObject contract) {
        HashSet<Object> proIdSet = new HashSet<Object>(16);
        if (contract.getBoolean("multipartsettlement")) {
            for (DynamicObject proEntry : contract.getDynamicObjectCollection("contproscope")) {
                DynamicObject sharePro = proEntry.getDynamicObject("multisettlepro");
                proIdSet.add(sharePro.getPkValue());
            }
        }
        return new QFilter("id", "in", proIdSet);
    }

    public static BigDecimal getFinishInvestmentAmt(Long projectId) {
        DynamicObject[] contracts;
        BigDecimal finishInvestmentAmt = BigDecimal.ZERO;
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        qFilter.and(PAYDIRECTION, "=", (Object)PayDirectionEnum.OUT.getValue());
        Set<Object> contStatusIds = ContractHelper.getContStatusIds(1);
        if (contStatusIds != null && contStatusIds.size() > 0) {
            qFilter.and("contractstatus", "in", contStatusIds);
        }
        if ((contracts = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)String.join((CharSequence)",", "billno", "totaloftaxamount", "totalsettleoftaxamount", "totalapplyoftaxamount", "totalrealoftaxamount"), (QFilter[])new QFilter[]{qFilter})).length > 0) {
            for (DynamicObject contract : contracts) {
                BigDecimal maxAmt = contract.getBigDecimal("totaloftaxamount");
                if (maxAmt.compareTo(contract.getBigDecimal("totalsettleoftaxamount")) < 0) {
                    maxAmt = contract.getBigDecimal("totalsettleoftaxamount");
                }
                if (maxAmt.compareTo(contract.getBigDecimal("totalapplyoftaxamount")) < 0) {
                    maxAmt = contract.getBigDecimal("totalapplyoftaxamount");
                }
                if (maxAmt.compareTo(contract.getBigDecimal("totalrealoftaxamount")) < 0) {
                    maxAmt = contract.getBigDecimal("totalrealoftaxamount");
                }
                finishInvestmentAmt = finishInvestmentAmt.add(maxAmt);
            }
        }
        qFilter = new QFilter("project", "=", (Object)projectId);
        qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] proCostSplits = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)"totalcostamt", (QFilter[])new QFilter[]{qFilter});
        if (proCostSplits.length > 0) {
            for (DynamicObject proCostSplit : proCostSplits) {
                finishInvestmentAmt = finishInvestmentAmt.add(proCostSplit.getBigDecimal("totalcostamt"));
            }
        }
        qFilter = new QFilter("procostsplitentry.entryproject", "=", (Object)projectId);
        qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        proCostSplits = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)"procostsplitentry,procostsplitentry.entryproject,procostsplitentry.costamt", (QFilter[])new QFilter[]{qFilter});
        if (proCostSplits.length > 0) {
            ArrayList splits = new ArrayList(16);
            for (DynamicObject proCostSplit : proCostSplits) {
                DynamicObjectCollection entries = proCostSplit.getDynamicObjectCollection("procostsplitentry");
                List projectSplit = entries.stream().filter(entry -> entry.getDynamicObject("entryproject") != null && Long.parseLong(entry.getDynamicObject("entryproject").getPkValue().toString()) == projectId).collect(Collectors.toList());
                if (projectSplit.size() <= 0) continue;
                splits.addAll(projectSplit);
            }
            if (splits.size() > 0) {
                for (DynamicObject proCostSplit : splits) {
                    finishInvestmentAmt = finishInvestmentAmt.add(proCostSplit.getBigDecimal("costamt"));
                }
            }
        }
        return finishInvestmentAmt;
    }

    public static BigDecimal getPaymentApplyThisPayableAmount(Object contractId, Object projectId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        if (projectId != null) {
            filterList.add(new QFilter("entryentity.contpro", "=", projectId));
        }
        filterList.add(new QFilter("entryentity.entrycontract", "=", contractId));
        filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        DynamicObject[] paymentApplies = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"entryentity.contpro,entryentity.entrycontract,entryentity.thispayableamount", (QFilter[])filterList.toArray(new QFilter[filterList.size()]));
        BigDecimal thisPayableAmount = BigDecimal.ZERO;
        for (DynamicObject paymentApply : paymentApplies) {
            DynamicObjectCollection entries = paymentApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObject entryCont = entry.getDynamicObject("entrycontract");
                DynamicObject entryContPro = entry.getDynamicObject("contpro");
                if (!contractId.equals(entryCont.getPkValue()) || projectId != null && (projectId == null || !projectId.equals(entryContPro.getPkValue()))) continue;
                thisPayableAmount = thisPayableAmount.add(entry.getBigDecimal("thispayableamount"));
            }
        }
        return thisPayableAmount;
    }

    public static BigDecimal getSingleContractPaymentApplyCurPayAmount(Object contractId) {
        QFilter contractFilter = new QFilter("contract", "=", contractId);
        contractFilter.and(new QFilter("billStatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        DynamicObject[] applyBills = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"paydetailentry,paydetailentry.curpayamt", (QFilter[])new QFilter[]{contractFilter});
        BigDecimal curPayAmount = BigDecimal.ZERO;
        for (DynamicObject billInfo : applyBills) {
            DynamicObjectCollection entries = billInfo.getDynamicObjectCollection("paydetailentry");
            for (DynamicObject entry : entries) {
                curPayAmount = curPayAmount.add(entry.getBigDecimal("curpayamt"));
            }
        }
        return curPayAmount;
    }

    public static BigDecimal getSingleContractPaymentApplyTax(Object contractId) {
        QFilter contractFilter = new QFilter("contract", "=", contractId);
        contractFilter.and(new QFilter("billStatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        DynamicObject[] applyBills = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"paydetailentry,paydetailentry.tax", (QFilter[])new QFilter[]{contractFilter});
        BigDecimal tax = BigDecimal.ZERO;
        for (DynamicObject billInfo : applyBills) {
            DynamicObjectCollection entries = billInfo.getDynamicObjectCollection("paydetailentry");
            for (DynamicObject entry : entries) {
                tax = tax.add(entry.getBigDecimal("tax"));
            }
        }
        return tax;
    }

    public static BigDecimal getInComeApplyApplyOfTaxAmount(Object contractId, Object projectId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        if (projectId != null) {
            filterList.add(new QFilter("entryentity.contpro", "=", projectId));
        }
        filterList.add(new QFilter("entryentity.entrycontract", "=", contractId));
        filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        DynamicObject[] paymentApplies = BusinessDataServiceHelper.load((String)"pmct_incomeapply", (String)"entryentity.contpro,entryentity.entrycontract,entryentity.applyoftaxamount", (QFilter[])filterList.toArray(new QFilter[filterList.size()]));
        BigDecimal applyOfTaxAmount = BigDecimal.ZERO;
        for (DynamicObject paymentApply : paymentApplies) {
            DynamicObjectCollection entries = paymentApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObject entryCont = entry.getDynamicObject("entrycontract");
                DynamicObject entryContPro = entry.getDynamicObject("contpro");
                if (!contractId.equals(entryCont.getPkValue()) || projectId != null && !projectId.equals(entryContPro.getPkValue())) continue;
                applyOfTaxAmount = applyOfTaxAmount.add(entry.getBigDecimal("applyoftaxamount"));
            }
        }
        return applyOfTaxAmount;
    }

    public static DynamicObject[] getSuppliers(Object bizPartnerId, Long orgId) {
        String sql = "id,number,name,tx_register_no";
        return BusinessDataServiceHelper.load((String)"bd_supplier", (String)sql, (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", bizPartnerId), new QFilter("createorg", "=", (Object)orgId), new QFilter("supplier_status", "in", ContractHelper.getSupplierStatusPk())});
    }

    public static DynamicObject[] getSuppliers(Object bizPartnerId) {
        String sql = "id,number,name,tx_register_no";
        return BusinessDataServiceHelper.load((String)"bd_supplier", (String)sql, (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", bizPartnerId), new QFilter("supplier_status", "in", ContractHelper.getSupplierStatusPk())});
    }

    public static List<Long> getSupplierStatusPk() {
        ArrayList<Long> ids = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT FID FROM T_BD_SUPPLIERSTATUS A WHERE(SELECT COUNT(1) FROM T_BD_SUPPLIERSTATUSEXCLUD B WHERE A.FID=B.FSUPPLIERSTATUS)=0 ");
        DataSet ds = DB.queryDataSet((String)(ContractHelper.class.getName() + UUID.randomUUID()), (DBRoute)DBRoute.basedata, (String)sql.toString(), null);
        if (ds != null) {
            ids = new ArrayList<Long>();
            for (Row row : ds) {
                ids.add(row.getLong("FID"));
            }
        }
        return ids;
    }

    public static boolean isProjectCostControl(DynamicObject bill, DynamicObject contractEntry, String entryContractKey, String splitSubEntryKey, String budgetItemKey) {
        DynamicObjectCollection splitEntry = contractEntry.getDynamicObjectCollection(splitSubEntryKey);
        if (splitEntry.isEmpty()) {
            return false;
        }
        DynamicObject contract = contractEntry.getDynamicObject(entryContractKey);
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((String)"pmct_outcontract", (String)"multipartsettlement,project", (QFilter[])new QFilter[]{new QFilter("id", "=", contract.getPkValue())})).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            DynamicObject project = bill.getDynamicObject("project");
            if (project != null) {
                DynamicObject[] proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
                if (proApps != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
                    return true;
                }
            } else {
                DynamicObject[] proApps;
                HashSet<Object> proIdSet = new HashSet<Object>(splitEntry.size());
                for (DynamicObject split : splitEntry) {
                    DynamicObject budgetItem = split.getDynamicObject(budgetItemKey);
                    if (budgetItem == null) continue;
                    DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                    proIdSet.add(budgetProject.getPkValue());
                }
                for (DynamicObject proApp : proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)})) {
                    boolean projectCostControl = proApp.getBoolean("projectcostcontrol");
                    if (!projectCostControl) continue;
                    return true;
                }
            }
        } else {
            DynamicObject[] proApps;
            DynamicObject contPro = contract.getDynamicObject("project");
            if (contPro != null && (proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", contPro.getPkValue())})) != null && proApps.length > 0 && proApps[0].getBoolean("projectcostcontrol")) {
                return true;
            }
        }
        return false;
    }

    public static void applyOfTaxAmountChanged(IDataModel model, IFormView view, BigDecimal applyOfTaxAmount, int rowIndex) {
        BigDecimal amount;
        BigDecimal applyAmount;
        String paymentType;
        String string = paymentType = model.getValue("paymenttype", rowIndex) == null ? "" : (String)model.getValue("paymenttype", rowIndex);
        if (StringUtils.equals((CharSequence)paymentType, (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue())) {
            applyAmount = applyOfTaxAmount;
            model.beginInit();
            model.setValue("thispayableamount", (Object)applyOfTaxAmount, rowIndex);
            model.setValue("thispayableexcltaxamount", (Object)applyOfTaxAmount, rowIndex);
            model.setValue("applytaxamount", null, rowIndex);
            model.setValue("thisprepaydeduction", null, rowIndex);
            model.endInit();
            view.updateView("thispayableamount", rowIndex);
            view.updateView("thispayableexcltaxamount", rowIndex);
            view.updateView("applytaxamount", rowIndex);
            view.updateView("thisprepaydeduction", rowIndex);
        } else {
            BigDecimal taxRate = (BigDecimal)model.getValue("conttaxrate", rowIndex);
            applyAmount = applyOfTaxAmount.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), 6, 5);
            BigDecimal applyTaxAmount = applyOfTaxAmount.subtract(applyAmount);
            model.setValue("applytaxamount", (Object)applyTaxAmount, rowIndex);
            BigDecimal thisPrePayDeduction = (BigDecimal)model.getValue("thisprepaydeduction", rowIndex);
            BigDecimal thisPayAbleAmount = applyOfTaxAmount.subtract(thisPrePayDeduction);
            model.setValue("thispayableamount", (Object)thisPayAbleAmount, rowIndex);
            model.setValue("thispayableexcltaxamount", (Object)thisPayAbleAmount.subtract(applyTaxAmount), rowIndex);
        }
        model.beginInit();
        model.setValue("applyamount", (Object)applyAmount, rowIndex);
        model.endInit();
        view.updateView("applyamount", rowIndex);
        BigDecimal payAbleAmount = BigDecimal.ZERO;
        DynamicObjectCollection contractEntry = model.getEntryEntity("entryentity");
        if (contractEntry != null) {
            for (DynamicObject entry : contractEntry) {
                payAbleAmount = payAbleAmount.add(entry.getBigDecimal("thispayableamount"));
            }
        }
        model.setValue("payableamount", (Object)payAbleAmount);
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        BigDecimal sumAmount = entryGrid.getSum("applyoftaxamount");
        BigDecimal totalSettleOfTaxAmount = (BigDecimal)model.getValue("totalsettleoftaxamount", rowIndex);
        BigDecimal totalRealOfTaxAmount = (BigDecimal)model.getValue("totalrealoftaxamount", rowIndex);
        if (totalSettleOfTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal rate = applyOfTaxAmount.add(totalRealOfTaxAmount).divide(totalSettleOfTaxAmount, 6, 5).multiply(BigDecimal.valueOf(100L));
            model.setValue("endpaymentrate", (Object)rate, rowIndex);
        }
        model.setValue("sumamount", (Object)sumAmount);
        CellStyle cs = new CellStyle();
        cs.setRow(rowIndex);
        boolean setRedByPayItem = false;
        DynamicObject payItem = (DynamicObject)model.getValue("payitem");
        BigDecimal thisPayableAmount = (BigDecimal)model.getValue("thispayableamount");
        if (payItem != null) {
            BigDecimal appliedComAmt = payItem.getBigDecimal("appliedcomamt");
            BigDecimal payAmount = payItem.getBigDecimal("payamount");
            if (thisPayableAmount.add(appliedComAmt).compareTo(payAmount) > 0) {
                setRedByPayItem = true;
            }
        }
        if (applyOfTaxAmount.compareTo(amount = (BigDecimal)model.getValue("amount", rowIndex)) > 0 || setRedByPayItem) {
            cs.setForeColor("red");
        } else {
            cs.setForeColor("black");
        }
        cs.setFieldKey("applyoftaxamount");
        entryGrid.setCellStyle(Collections.singletonList(cs));
    }

    public static void updateContractListData(DynamicObject contract) {
        DynamicObjectCollection ListModelEntry = contract.getDynamicObjectCollection("listmodelentry");
        if (ListModelEntry != null && ListModelEntry.size() > 0) {
            DynamicObject[] contractList;
            ArrayList listingIdList = new ArrayList(10);
            for (DynamicObject listModel : ListModelEntry) {
                DynamicObjectCollection subListEntry = listModel.getDynamicObjectCollection("sublistentry");
                if (subListEntry == null || subListEntry.size() <= 0) continue;
                subListEntry.forEach(subList -> listingIdList.add(Long.valueOf(subList.getPkValue().toString())));
            }
            if (listingIdList.size() > 0 && (contractList = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)String.join((CharSequence)",", "contractid", "qty", "taxprice", "oftax", "amount", "listparentid", "totalqty", "curtaxprice", "lstoftaxamount", "avgtaxprice", "latestamount", "parent", "currency", PAYDIRECTION), (QFilter[])new QFilter[]{new QFilter("id", "in", listingIdList)})).length > 0) {
                for (DynamicObject listing : contractList) {
                    listing.set("contractid", contract.getPkValue());
                    listing.set("totalqty", (Object)listing.getBigDecimal("qty"));
                    listing.set("curtaxprice", (Object)listing.getBigDecimal("taxprice"));
                    listing.set("lstoftaxamount", (Object)listing.getBigDecimal("oftax"));
                    listing.set("avgtaxprice", (Object)listing.getBigDecimal("taxprice"));
                    listing.set("latestamount", (Object)listing.getBigDecimal("amount"));
                    if (listing.getString("listparentid") != null && !"".equals(listing.getString("listparentid").trim()) && !"0".equals(listing.getString("listparentid"))) {
                        DynamicObject parentListing = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(listing.getString("listparentid")), (String)"pmct_contractlist");
                        listing.set("parent", (Object)parentListing);
                    }
                    listing.set("currency", (Object)contract.getDynamicObject("currency"));
                    listing.set(PAYDIRECTION, (Object)contract.getString(PAYDIRECTION));
                }
                SaveServiceHelper.save((DynamicObject[])contractList);
            }
        }
    }

    public static BigDecimal getContractSettleAmountBySupplier(Object contractId, Object supplierId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        filterList.add(new QFilter("contract", "=", contractId));
        filterList.add(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        filterList.add(new QFilter("contpartb", "=", supplierId));
        DynamicObjectCollection contractSettles = QueryServiceHelper.query((String)"pmct_outcontract_settle", (String)String.join((CharSequence)",", "id", "settleoftaxamount"), (QFilter[])filterList.toArray(new QFilter[0]));
        return contractSettles.stream().map(bill -> bill.getBigDecimal("settleoftaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public static void updateContractInvoiceAmount(DynamicObject contract, DynamicObject currentInvoice, String operateKey) {
        boolean accumulate;
        DynamicObjectCollection invoices;
        QFilter invoiceStatusFilter;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(5);
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter claimStatusFilter = new QFilter("isclaimed", "=", (Object)Boolean.TRUE);
        QFilter idFilter = new QFilter("id", "!=", currentInvoice.getPkValue());
        filterList.add(contractFilter);
        filterList.add(billStatusFilter);
        filterList.add(claimStatusFilter);
        filterList.add(idFilter);
        String payDirection = contract.getString(PAYDIRECTION);
        String selectFields = String.join((CharSequence)",", "totalamount", "totaloftaxamount");
        if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.OUT.getValue())) {
            invoiceStatusFilter = new QFilter("invoicestatus", "!=", (Object)InvoiceStatusEnum.CANCEL_2.getValue());
            filterList.add(invoiceStatusFilter);
            invoices = QueryServiceHelper.query((String)"pmct_ininvoice", (String)selectFields, (QFilter[])filterList.toArray(new QFilter[0]));
        } else {
            invoiceStatusFilter = new QFilter("invoicestatus", "!=", (Object)OutInvoiceStatusEnum.CANCEL_6.getValue());
            filterList.add(invoiceStatusFilter);
            invoices = QueryServiceHelper.query((String)"pmct_outinvoice", (String)selectFields, (QFilter[])filterList.toArray(new QFilter[0]));
        }
        BigDecimal totalinvoiceamount = invoices.stream().map(invoice -> invoice.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalinvoiceoftaxamount = invoices.stream().map(invoice -> invoice.getBigDecimal("totaloftaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        String invoiceStatus = currentInvoice.getString("invoicestatus");
        String billStatus = currentInvoice.getString("billstatus");
        boolean isclaimed = currentInvoice.getBoolean("isclaimed");
        boolean bl = accumulate = !StringUtils.equals((CharSequence)invoiceStatus, (CharSequence)InvoiceStatusEnum.CANCEL_2.getValue()) && StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue()) && isclaimed;
        if (accumulate) {
            totalinvoiceamount = totalinvoiceamount.add(currentInvoice.getBigDecimal("totalamount"));
            totalinvoiceoftaxamount = totalinvoiceoftaxamount.add(currentInvoice.getBigDecimal("totaloftaxamount"));
        }
        contract.set("totalinvoiceamount", (Object)totalinvoiceamount);
        contract.set("totalinvoiceoftaxamount", (Object)totalinvoiceoftaxamount);
        SaveServiceHelper.update((DynamicObject)contract);
    }

    public static String getInvoiceSellerParam() {
        String ctrlParam = "unctrl";
        QFilter qFilter = new QFilter("appid", "=", (Object)"0AF=HWDE07B0");
        qFilter.and("key", "=", (Object)InvoiceSellerParam);
        Map customParamAppMap = BusinessDataServiceHelper.loadFromCache((String)"bos_customparam_app", (String)"id,value", (QFilter[])new QFilter[]{qFilter});
        if (!customParamAppMap.isEmpty()) {
            Set customParamApps = customParamAppMap.entrySet();
            for (Map.Entry customParamApp : customParamApps) {
                DynamicObject dyObj = (DynamicObject)customParamApp.getValue();
                Object value = dyObj.get("value");
                if (value == null) continue;
                if (value.toString().equalsIgnoreCase("remindctrl")) {
                    ctrlParam = "remindctrl";
                    continue;
                }
                if (!value.toString().equalsIgnoreCase("strictctrl")) continue;
                ctrlParam = "strictctrl";
            }
        }
        return ctrlParam;
    }
}

