/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.ContractPayItemSourceEnum;
import kd.pmgt.pmbs.common.enums.ContractPayTypeEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.utils.ComboItemHelper;

public class ContractPayItemHelper {
    private static final Log logger = LogFactory.getLog(ContractPayItemHelper.class);
    public static final int PERCENT_OK = 100;

    @Deprecated
    public static Object[] save(DynamicObject contract, DynamicObject currentBill, ContractPayItemSourceEnum source, String billType, StatusEnum status) {
        return ContractPayItemHelper.save(currentBill, PayPlanSourceEnum.CONTRACT);
    }

    @Deprecated
    public static Object[] save(DynamicObject contract, ContractPayItemSourceEnum source, String billType) {
        return ContractPayItemHelper.save(contract, PayPlanSourceEnum.CONTRACT);
    }

    @Deprecated
    public static Object[] save(DynamicObject contract, ContractPayItemSourceEnum source, String billType, StatusEnum status) {
        return ContractPayItemHelper.doSave(contract, PayPlanSourceEnum.CONTRACT, contract.getPkValue());
    }

    public static Object[] save(DynamicObject currentBill, PayPlanSourceEnum source) {
        String currentFormId;
        Object contractPk = currentBill.getPkValue();
        switch (currentFormId = currentBill.getDataEntityType().getName()) {
            case "pmct_contractrevision": {
                currentBill = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_contractrevision");
                contractPk = currentBill.getDynamicObject("contract").getPkValue();
                break;
            }
            case "pmct_outcontractrevision": {
                currentBill = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_outcontractrevision");
                contractPk = currentBill.getDynamicObject("contract").getPkValue();
                break;
            }
            case "pmct_outaddagreement": {
                currentBill = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_outaddagreement");
                contractPk = currentBill.getDynamicObject("contract").getPkValue();
                break;
            }
            case "pmct_outclaimbill": {
                currentBill = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_outclaimbill");
                contractPk = currentBill.getDynamicObject("contract").getPkValue();
                break;
            }
            case "pmct_outperformrecords": {
                currentBill = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_outperformrecords");
                contractPk = currentBill.getDynamicObject("contract").getPkValue();
                break;
            }
        }
        return ContractPayItemHelper.doUpdate(currentBill, contractPk, source);
    }

    public static Object[] save(DynamicObject currentBill, PayPlanSourceEnum source, Object contractPk) {
        return ContractPayItemHelper.doSave(currentBill, source, contractPk);
    }

    private static Object[] doSave(DynamicObject currentBill, PayPlanSourceEnum source, Object contractPk) {
        try {
            String currentFormId = currentBill.getDataEntityType().getName();
            logger.info("\u5f53\u524d\u5355\u636eid\u3001\u5355\u636e\u6807\u8bc6:{},{}", currentBill.getPkValue(), (Object)currentFormId);
            DynamicObjectCollection payPlanEntries = null;
            switch (currentFormId) {
                case "pmct_outcontract": {
                    payPlanEntries = currentBill.getDynamicObjectCollection("outcontpayplanentry");
                    break;
                }
                case "pmct_contractrevision": {
                    payPlanEntries = currentBill.getDynamicObjectCollection("outcontpayplanentry");
                    break;
                }
                case "pmct_outcontractrevision": {
                    payPlanEntries = currentBill.getDynamicObjectCollection("changepayplanentry");
                    break;
                }
                case "pmct_outaddagreement": {
                    payPlanEntries = currentBill.getDynamicObjectCollection("payplanentry");
                    break;
                }
                case "pmct_outclaimbill": {
                    payPlanEntries = currentBill.getDynamicObjectCollection("claimpayplanentry");
                    break;
                }
                case "pmct_outperformrecords": {
                    payPlanEntries = currentBill.getDynamicObjectCollection("entryentity");
                    break;
                }
            }
            Object[] contractPayItems = null;
            if (payPlanEntries == null || payPlanEntries.isEmpty()) {
                if (!StringUtils.equals((CharSequence)currentFormId, (CharSequence)"pmct_outperformrecords")) {
                    DynamicObject contractPayItem = ContractPayItemHelper.defaultContractPayItem(currentBill, source, contractPk);
                    contractPayItems = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contractPayItem});
                }
            } else {
                DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_outcontract");
                contractPayItems = SaveServiceHelper.save((DynamicObject[])((DynamicObject[])payPlanEntries.stream().map(payPlanEntry -> ContractPayItemHelper.contractPayItemByPayPlan(contract, currentBill, payPlanEntry, source)).toArray(DynamicObject[]::new)));
                SaveServiceHelper.update((DynamicObject)currentBill);
            }
            return contractPayItems;
        }
        catch (Exception e) {
            logger.info("\u4ed8\u6b3e\u6761\u76ee\u65b0\u589e\u5931\u8d25,\u5f53\u524d\u5355\u636eid\u3001\u5355\u636e\u6807\u8bc6:{},{}", currentBill.getPkValue(), (Object)currentBill.getDataEntityType().getName());
            throw e;
        }
    }

    private static DynamicObject contractPayItemByPayPlan(DynamicObject contract, DynamicObject currentBill, DynamicObject payPlanEntry, PayPlanSourceEnum source) {
        String payType;
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem");
        DynamicObject contractPayItem = new DynamicObject((DynamicObjectType)dt);
        long pk = ORM.create().genLongId("pmbs_contractpayitem");
        contractPayItem.set("id", (Object)pk);
        contractPayItem.set("masterid", (Object)pk);
        contractPayItem.set("source", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
        contractPayItem.set("payplansource", (Object)source.getValue());
        String currentFormId = currentBill.getDataEntityType().getName();
        String payTypeName = null;
        String payTypeValue = null;
        if (StringUtils.equals((CharSequence)currentFormId, (CharSequence)"pmct_outperformrecords")) {
            payTypeName = ContractPayTypeEnum.PERFORM_PAYMENT.getName();
            payTypeValue = ContractPayTypeEnum.PERFORM_PAYMENT.getValue();
        } else if (StringUtils.equals((CharSequence)currentFormId, (CharSequence)"pmct_outcontract")) {
            payType = payPlanEntry.getString("paytype");
            payTypeName = ComboItemHelper.getName((String)"pmct_outcontract", (String)"outcontpayplanentry", null, (String)"paytype", (String)payType);
            payTypeValue = payType;
        } else if (StringUtils.equals((CharSequence)currentFormId, (CharSequence)"pmct_contractrevision")) {
            payType = payPlanEntry.getString("paytype");
            payTypeName = ComboItemHelper.getName((String)"pmct_contractrevision", (String)"outcontpayplanentry", null, (String)"paytype", (String)payType);
            payTypeValue = payType;
        } else if (StringUtils.equals((CharSequence)currentFormId, (CharSequence)"pmct_outcontractrevision")) {
            payType = payPlanEntry.getString("paytype");
            payTypeName = ComboItemHelper.getName((String)"pmct_outcontractrevision", (String)"changepayplanentry", null, (String)"paytype", (String)payType);
            payTypeValue = payType;
        } else if (StringUtils.equals((CharSequence)currentFormId, (CharSequence)"pmct_outclaimbill")) {
            payType = payPlanEntry.getString("paytype");
            payTypeName = ComboItemHelper.getName((String)"pmct_outclaimbill", (String)"claimpayplanentry", null, (String)"paytype", (String)payType);
            payTypeValue = payType;
        } else if (StringUtils.equals((CharSequence)currentFormId, (CharSequence)"pmct_outaddagreement")) {
            payType = payPlanEntry.getString("paytype");
            payTypeName = ComboItemHelper.getName((String)"pmct_outaddagreement", (String)"payplanentry", null, (String)"paytype", (String)payType);
            payTypeValue = payType;
        }
        contractPayItem.set("name", (Object)ContractPayItemHelper.setBillName(payTypeName, source.getName(), currentBill.getString("billno"), payPlanEntry.getString("seq")));
        contractPayItem.set("billno", (Object)ContractPayItemHelper.setBillNumber(contract.getDynamicObject("org").getString("number"), payTypeValue, source.getValue(), currentBill.getString("billno"), payPlanEntry.getString("seq")));
        contractPayItem.set("autogenerated", (Object)Boolean.FALSE);
        contractPayItem.set("currency", contract.get("currency"));
        switch (currentFormId) {
            case "pmct_outcontract": {
                contractPayItem.set("remarks", payPlanEntry.get("remarks"));
                contractPayItem.set("payfeq", payPlanEntry.get("paymethod"));
                contractPayItem.set("payway", payPlanEntry.get("payway"));
                contractPayItem.set("payamount", payPlanEntry.get("payamount"));
                payPlanEntry.set("conplanitemid", (Object)pk);
                break;
            }
            case "pmct_contractrevision": {
                contractPayItem.set("remarks", payPlanEntry.get("paydescription"));
                contractPayItem.set("payfeq", payPlanEntry.get("paymethod"));
                contractPayItem.set("payway", payPlanEntry.get("payway"));
                contractPayItem.set("payamount", payPlanEntry.get("payamount"));
                payPlanEntry.set("conpayitemid", (Object)pk);
                break;
            }
            case "pmct_outcontractrevision": {
                contractPayItem.set("remarks", payPlanEntry.get("remarks"));
                contractPayItem.set("payfeq", payPlanEntry.get("payfeq"));
                contractPayItem.set("payway", payPlanEntry.get("payway"));
                contractPayItem.set("payamount", payPlanEntry.get("payamountoftax"));
                payPlanEntry.set("conplanitemid", (Object)pk);
                break;
            }
            case "pmct_outaddagreement": {
                contractPayItem.set("remarks", payPlanEntry.get("remarks"));
                contractPayItem.set("payfeq", payPlanEntry.get("payfeq"));
                contractPayItem.set("payway", payPlanEntry.get("payway"));
                contractPayItem.set("payamount", (Object)payPlanEntry.getBigDecimal("payamountoftax"));
                payPlanEntry.set("conplanitemid", (Object)pk);
                break;
            }
            case "pmct_outclaimbill": {
                contractPayItem.set("remarks", payPlanEntry.get("remarks"));
                contractPayItem.set("payfeq", payPlanEntry.get("payfeq"));
                contractPayItem.set("payway", payPlanEntry.get("payway"));
                contractPayItem.set("payamount", (Object)payPlanEntry.getBigDecimal("payamountoftax"));
                payPlanEntry.set("conplanitemid", (Object)pk);
                break;
            }
            case "pmct_outperformrecords": {
                contractPayItem.set("source", (Object)ContractPayItemSourceEnum.PERFORMANCEISSUE.getValue());
                contractPayItem.set("supplier", (Object)contract.getDynamicObject("partb"));
                contractPayItem.set("performentryid", payPlanEntry.getPkValue());
                contractPayItem.set("paytype", (Object)ContractPayTypeEnum.PERFORM_PAYMENT.getValue());
                BigDecimal amount = payPlanEntry.getBigDecimal("amount");
                if (payPlanEntry.getDynamicObject("contpayitem") != null && payPlanEntry.getDynamicObject("contpayitem").getString("direction") != null && "01".equals(payPlanEntry.getDynamicObject("contpayitem").getString("direction"))) {
                    contractPayItem.set("payamount", (Object)amount.negate());
                    contractPayItem.set("unpaidamt", (Object)amount.negate());
                    contractPayItem.set("reimbursableamt", (Object)amount.negate());
                    break;
                }
                contractPayItem.set("payamount", (Object)amount);
                contractPayItem.set("unpaidamt", (Object)amount);
                contractPayItem.set("reimbursableamt", (Object)amount);
                break;
            }
        }
        if (!StringUtils.equals((CharSequence)currentFormId, (CharSequence)"pmct_outperformrecords")) {
            contractPayItem.set("supplier", (Object)payPlanEntry.getDynamicObject("supplier"));
            contractPayItem.set("payplanentryid", payPlanEntry.getPkValue());
            contractPayItem.set("paytype", payPlanEntry.get("paytype"));
            contractPayItem.set("paypercent", payPlanEntry.get("paypercent"));
            contractPayItem.set("reimbursableamt", (Object)contractPayItem.getBigDecimal("payamount"));
            contractPayItem.set("unpaidamt", (Object)contractPayItem.getBigDecimal("reimbursableamt"));
            contractPayItem.set("planpaytime", payPlanEntry.get("planpaytime"));
            contractPayItem.set("ctrlstrategy", payPlanEntry.get("ctrlstrategy"));
            contractPayItem.set("nodesettingsource", payPlanEntry.get("nodesettingsource"));
            contractPayItem.set("nodesetting", payPlanEntry.get("nodesetting"));
        }
        contractPayItem.set("appliableamt", (Object)contractPayItem.getBigDecimal("payamount"));
        contractPayItem.set("contract", contract.getPkValue());
        contractPayItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
        contractPayItem.set("status", (Object)StatusEnum.CHECKED.getValue());
        Date now = new Date();
        contractPayItem.set("createtime", (Object)now);
        contractPayItem.set("modifytime", (Object)now);
        contractPayItem.set("creator", (Object)currentBill.getDynamicObject("creator"));
        contractPayItem.set("modifier", (Object)currentBill.getDynamicObject("modifier"));
        contractPayItem.set("paydirection", (Object)PayDirectionEnum.OUT.getValue());
        return contractPayItem;
    }

    private static DynamicObject defaultContractPayItem(DynamicObject currentBill, PayPlanSourceEnum source, Object contractPk) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem");
        DynamicObject contractPayItem = new DynamicObject((DynamicObjectType)dt);
        long pk = ORM.create().genLongId("pmbs_contractpayitem");
        contractPayItem.set("id", (Object)pk);
        contractPayItem.set("masterid", (Object)pk);
        contractPayItem.set("payplanentryid", (Object)Long.parseLong(currentBill.getPkValue().toString()));
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_outcontract");
        String dataSource = source.getValue();
        ContractPayTypeEnum payType = StringUtils.equals((CharSequence)dataSource, (CharSequence)PayPlanSourceEnum.CLAIM.getValue()) ? ContractPayTypeEnum.CLAIM_PAYMENT : ContractPayTypeEnum.CONTRACT_PAY;
        String itemName = ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)"pmbs_contractpayitem", null, null, (String)"paytype", (String)ContractPayTypeEnum.CONTRACT_PAY.getValue()), source.getName(), currentBill.getString("billno"), null);
        contractPayItem.set("name", (Object)itemName);
        contractPayItem.set("billno", (Object)ContractPayItemHelper.setBillNumber(contract.getDynamicObject("org").getString("number"), payType.getValue(), source.getValue(), currentBill.getString("billno"), null));
        contractPayItem.set("autogenerated", (Object)Boolean.TRUE);
        contractPayItem.set("currency", currentBill.get("currency"));
        String currentFormId = currentBill.getDataEntityType().getName();
        ContractPayItemSourceEnum itemSource = ContractPayItemSourceEnum.PAYPLAN;
        switch (currentFormId) {
            case "pmct_outcontract": {
                contractPayItem.set("payamount", currentBill.get("originaloftaxamount"));
                contractPayItem.set("paytype", (Object)ContractPayTypeEnum.CONTRACT_PAY.getValue());
                break;
            }
            case "pmct_contractrevision": {
                contractPayItem.set("payamount", currentBill.get("originaloftaxamount"));
                contractPayItem.set("paytype", (Object)ContractPayTypeEnum.CONTRACT_PAY.getValue());
                break;
            }
            case "pmct_outcontractrevision": {
                contractPayItem.set("payamount", currentBill.get("latestamountoftax"));
                contractPayItem.set("paytype", (Object)ContractPayTypeEnum.CONTRACT_PAY.getValue());
                break;
            }
            case "pmct_outaddagreement": {
                contractPayItem.set("payamount", currentBill.get("latestamountoftax"));
                contractPayItem.set("paytype", (Object)ContractPayTypeEnum.CONTRACT_PAY.getValue());
                break;
            }
            case "pmct_outclaimbill": {
                contractPayItem.set("payamount", currentBill.get("afteroftaxamount"));
                contractPayItem.set("paytype", (Object)ContractPayTypeEnum.CLAIM_PAYMENT.getValue());
                if (currentBill.getBoolean("isneedsettle")) break;
                itemSource = ContractPayItemSourceEnum.CLAIM;
                contractPayItem.set("payamount", currentBill.get("claimoftaxamount"));
                break;
            }
        }
        contractPayItem.set("source", (Object)itemSource);
        contractPayItem.set("supplier", (Object)contract.getDynamicObject("partb"));
        contractPayItem.set("paypercent", (Object)100);
        contractPayItem.set("reimbursableamt", contractPayItem.get("payamount"));
        contractPayItem.set("unpaidamt", contractPayItem.get("payamount"));
        contractPayItem.set("appliableamt", contractPayItem.get("payamount"));
        contractPayItem.set("contract", contractPk);
        contractPayItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
        contractPayItem.set("status", (Object)StatusEnum.CHECKED.getValue());
        Date now = new Date();
        contractPayItem.set("createtime", (Object)now);
        contractPayItem.set("modifytime", (Object)now);
        contractPayItem.set("creator", (Object)RequestContext.get().getUserId());
        contractPayItem.set("modifier", (Object)RequestContext.get().getUserId());
        contractPayItem.set("paydirection", (Object)PayDirectionEnum.OUT.getValue());
        return contractPayItem;
    }

    public static void doUpdate(DynamicObject currentBill, DynamicObject[] payDetailEntry, String operation) {
        String currentFormId = currentBill.getDynamicObjectType().getName();
        if (payDetailEntry != null && payDetailEntry.length > 0) {
            DynamicObject[] contractPayItems = (DynamicObject[])Arrays.stream(payDetailEntry).map(item -> {
                DynamicObject contractPayItem = null;
                switch (currentFormId) {
                    case "pmct_applymentpay": {
                        contractPayItem = ContractPayItemHelper.calculationAmount(currentFormId, item, operation);
                        break;
                    }
                    case "pmct_paymentapply": {
                        contractPayItem = ContractPayItemHelper.calculationAmount(currentFormId, item, operation);
                        break;
                    }
                    case "pmct_incomeapply": {
                        contractPayItem = ContractPayItemHelper.calculateIncomeApplyAmt(item, operation);
                        break;
                    }
                }
                return contractPayItem;
            }).toArray(DynamicObject[]::new);
            SaveServiceHelper.update((DynamicObject[])contractPayItems);
        }
    }

    private static DynamicObject calculateIncomeApplyAmt(DynamicObject item, String operation) {
        DynamicObject contractPayItem = item.getDynamicObject("incomeitem");
        contractPayItem = BusinessDataServiceHelper.loadSingle((Object)contractPayItem.getPkValue(), (String)"pmbs_contractpayitem");
        BigDecimal applyOfTaxAmt = item.getBigDecimal("applyoftaxamount");
        BigDecimal appliedamt = contractPayItem.getBigDecimal("appliedamt");
        BigDecimal appliedcomamt = contractPayItem.getBigDecimal("appliedcomamt");
        BigDecimal appliableamt = contractPayItem.getBigDecimal("appliableamt");
        if (StringUtils.equals((CharSequence)operation, (CharSequence)OperationEnum.SUBMIT.getValue())) {
            appliedcomamt = appliedcomamt.add(applyOfTaxAmt);
            appliableamt = appliableamt.subtract(applyOfTaxAmt);
        } else if (StringUtils.equals((CharSequence)operation, (CharSequence)OperationEnum.UNSUBMIT.getValue())) {
            appliedcomamt = appliedcomamt.subtract(applyOfTaxAmt);
            appliableamt = appliableamt.add(applyOfTaxAmt);
        } else if (StringUtils.equals((CharSequence)operation, (CharSequence)OperationEnum.AUDIT.getValue())) {
            appliedamt = appliedamt.add(applyOfTaxAmt);
        } else {
            appliedamt = appliedamt.subtract(applyOfTaxAmt);
            appliedcomamt = appliedcomamt.subtract(applyOfTaxAmt);
            appliableamt = appliableamt.add(applyOfTaxAmt);
        }
        contractPayItem.set("appliableamt", (Object)appliableamt);
        contractPayItem.set("appliedcomamt", (Object)appliedcomamt);
        contractPayItem.set("appliedamt", (Object)appliedamt);
        return contractPayItem;
    }

    private static DynamicObject calculationAmount(String currentFormId, DynamicObject item, String operation) {
        BigDecimal amtOfTax;
        DynamicObject contractPayItem = item.getDynamicObject("payitem");
        contractPayItem = BusinessDataServiceHelper.loadSingle((Object)contractPayItem.getPkValue(), (String)"pmbs_contractpayitem");
        BigDecimal applyAmt = contractPayItem.getBigDecimal("appliableamt");
        BigDecimal applyingAmt = contractPayItem.getBigDecimal("appliedcomamt");
        BigDecimal appliedAmt = contractPayItem.getBigDecimal("appliedamt");
        if ("pmct_applymentpay".equals(currentFormId)) {
            amtOfTax = item.getBigDecimal("curpayamtoftax");
        } else {
            BigDecimal bigDecimal = amtOfTax = item.getBigDecimal("thispayableamount") == null ? BigDecimal.ZERO : item.getBigDecimal("thispayableamount");
        }
        if (StringUtils.equals((CharSequence)operation, (CharSequence)OperationEnum.SUBMIT.getValue())) {
            applyAmt = applyAmt.subtract(amtOfTax);
            applyingAmt = applyingAmt.add(amtOfTax);
        } else if (StringUtils.equals((CharSequence)operation, (CharSequence)OperationEnum.UNSUBMIT.getValue())) {
            applyAmt = applyAmt.add(amtOfTax);
            applyingAmt = applyingAmt.subtract(amtOfTax);
        } else if (StringUtils.equals((CharSequence)operation, (CharSequence)OperationEnum.AUDIT.getValue())) {
            appliedAmt = appliedAmt.add(amtOfTax);
        } else {
            applyAmt = applyAmt.add(amtOfTax);
            applyingAmt = applyingAmt.subtract(amtOfTax);
            appliedAmt = appliedAmt.subtract(amtOfTax);
        }
        contractPayItem.set("appliableamt", (Object)applyAmt);
        contractPayItem.set("appliedcomamt", (Object)applyingAmt);
        contractPayItem.set("appliedamt", (Object)appliedAmt);
        return contractPayItem;
    }

    private static DynamicObject[] doUpdate(DynamicObject currentBill, Object contractPk, PayPlanSourceEnum source) {
        String currentFormId = currentBill.getDataEntityType().getName();
        logger.info("\u5f53\u524d\u5355\u636eid\u3001\u5355\u636e\u6807\u8bc6:{},{}", currentBill.getPkValue(), (Object)currentFormId);
        BigDecimal latestAmountOfTax = BigDecimal.ZERO;
        DynamicObjectCollection payPlanEntries = null;
        String payEntryRelateItemIdKey = null;
        switch (currentFormId) {
            case "pmct_outcontract": {
                latestAmountOfTax = currentBill.getBigDecimal("originaloftaxamount");
                payPlanEntries = currentBill.getDynamicObjectCollection("outcontpayplanentry");
                payEntryRelateItemIdKey = "conplanitemid";
                break;
            }
            case "pmct_contractrevision": {
                latestAmountOfTax = currentBill.getBigDecimal("originaloftaxamount");
                payPlanEntries = currentBill.getDynamicObjectCollection("outcontpayplanentry");
                payEntryRelateItemIdKey = "conpayitemid";
                break;
            }
            case "pmct_outcontractrevision": {
                latestAmountOfTax = currentBill.getBigDecimal("latestamountoftax");
                payPlanEntries = currentBill.getDynamicObjectCollection("changepayplanentry");
                payEntryRelateItemIdKey = "conplanitemid";
                break;
            }
            case "pmct_outaddagreement": {
                latestAmountOfTax = currentBill.getBigDecimal("latestamountoftax");
                payPlanEntries = currentBill.getDynamicObjectCollection("payplanentry");
                payEntryRelateItemIdKey = "conplanitemid";
                break;
            }
            case "pmct_outclaimbill": {
                latestAmountOfTax = currentBill.getBigDecimal("afteroftaxamount");
                payPlanEntries = currentBill.getDynamicObjectCollection("claimpayplanentry");
                payEntryRelateItemIdKey = "conplanitemid";
                break;
            }
        }
        ContractPayItemHelper.updatePayItem(contractPk, currentBill, payPlanEntries, latestAmountOfTax, payEntryRelateItemIdKey, source);
        QFilter contractIdFilter = new QFilter("contract", "=", contractPk);
        QFilter sourceFilter = new QFilter("source", "!=", (Object)PayPlanSourceEnum.PERFORM.getValue());
        return BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)String.join((CharSequence)",", "id", "autogenerated"), (QFilter[])new QFilter[]{contractIdFilter, sourceFilter});
    }

    private static void updatePayItem(Object contractPk, DynamicObject currentBill, DynamicObjectCollection payPlanEntries, BigDecimal latestAmountOfTax, String payEntryRelateItemIdKey, PayPlanSourceEnum source) {
        QFilter contractIdFilter = new QFilter("contract", "=", contractPk);
        QFilter sourceFilter = new QFilter("source", "=", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
        DynamicObjectCollection contractPayItems = QueryServiceHelper.query((String)"pmbs_contractpayitem", (String)String.join((CharSequence)",", "id", "billno", "name", "payamount", "autogenerated"), (QFilter[])new QFilter[]{contractIdFilter, sourceFilter});
        List oldItemIds = contractPayItems.stream().map(item -> item.get("id")).collect(Collectors.toList());
        ArrayList deleteItemIds = new ArrayList(10);
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_outcontract");
        if (payPlanEntries == null || payPlanEntries.isEmpty()) {
            if (contractPayItems.size() == 1 && ((DynamicObject)contractPayItems.get(0)).getBoolean("autogenerated")) {
                DynamicObject contractPayItem = (DynamicObject)contractPayItems.get(0);
                String selectProperties = String.join((CharSequence)",", "billno", "name", "payamount");
                contractPayItem = BusinessDataServiceHelper.loadSingle((Object)contractPayItem.getLong("id"), (String)"pmbs_contractpayitem", (String)selectProperties);
                String payTypeName = ComboItemHelper.getName((String)"pmbs_contractpayitem", null, null, (String)"paytype", (String)ContractPayTypeEnum.CONTRACT_PAY.getValue());
                String itemNumber = ContractPayItemHelper.setBillNumber(contract.getDynamicObject("org").getString("number"), payTypeName, source.getName(), currentBill.getString("billno"), null);
                String itemName = ContractPayItemHelper.setBillName(payTypeName, source.getName(), currentBill.getString("billno"), null);
                contractPayItem.set("billno", (Object)itemNumber);
                contractPayItem.set("name", (Object)itemName);
                contractPayItem.set("payamount", (Object)latestAmountOfTax);
                SaveServiceHelper.update((DynamicObject)contractPayItem);
            } else {
                deleteItemIds.addAll(oldItemIds);
            }
        } else {
            ArrayList<Long> updateItemIds = new ArrayList<Long>(10);
            ArrayList<DynamicObject> newPayItem = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> updatePayItem = new ArrayList<DynamicObject>(10);
            for (DynamicObject payPlanEntry : payPlanEntries) {
                Long relateItemId = null;
                if (payPlanEntry.get(payEntryRelateItemIdKey) instanceof String && !StringUtils.isEmpty((CharSequence)payPlanEntry.getString(payEntryRelateItemIdKey))) {
                    relateItemId = Long.parseLong(payPlanEntry.getString(payEntryRelateItemIdKey));
                } else if (payPlanEntry.get(payEntryRelateItemIdKey) instanceof Long) {
                    relateItemId = payPlanEntry.getLong(payEntryRelateItemIdKey);
                }
                if (relateItemId == null || relateItemId.equals(0L) || !QueryServiceHelper.exists((String)"pmbs_contractpayitem", (Object)relateItemId)) {
                    newPayItem.add(ContractPayItemHelper.contractPayItemByPayPlan(contract, currentBill, payPlanEntry, source));
                    continue;
                }
                if (!QueryServiceHelper.exists((String)"pmbs_contractpayitem", (Object)relateItemId)) continue;
                DynamicObject contractPayItem = BusinessDataServiceHelper.loadSingle((Object)relateItemId, (String)"pmbs_contractpayitem");
                updatePayItem.add(ContractPayItemHelper.updateContractPayItem(contractPayItem, payPlanEntry, currentBill, source));
                updateItemIds.add(relateItemId);
            }
            deleteItemIds.addAll(oldItemIds);
            deleteItemIds.removeAll(updateItemIds);
            if (!newPayItem.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])newPayItem.toArray(new DynamicObject[0]));
                SaveServiceHelper.update((DynamicObject)currentBill);
            }
            if (!updatePayItem.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updatePayItem.toArray(new DynamicObject[0]));
            }
        }
        if (!deleteItemIds.isEmpty()) {
            QFilter deleteItemIdsFilter = new QFilter("id", "in", deleteItemIds);
            DeleteServiceHelper.delete((String)"pmbs_contractpayitem", (QFilter[])new QFilter[]{deleteItemIdsFilter});
        }
    }

    private static DynamicObject updateContractPayItem(DynamicObject contractPayItem, DynamicObject payPlanEntry, DynamicObject currentBill, PayPlanSourceEnum source) {
        String currentFormId = currentBill.getDataEntityType().getName();
        DynamicObject contract = contractPayItem.getDynamicObject("contract");
        contractPayItem.set("supplier", payPlanEntry.get("supplier"));
        contractPayItem.set("paytype", payPlanEntry.get("paytype"));
        switch (currentFormId) {
            case "pmct_outcontract": {
                contractPayItem.set("remarks", payPlanEntry.get("remarks"));
                contractPayItem.set("payfeq", payPlanEntry.get("paymethod"));
                contractPayItem.set("payway", payPlanEntry.get("payway"));
                contractPayItem.set("payamount", payPlanEntry.get("payamount"));
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.CONTRACT.getValue());
                break;
            }
            case "pmct_contractrevision": {
                contractPayItem.set("remarks", payPlanEntry.get("paydescription"));
                contractPayItem.set("payfeq", payPlanEntry.get("paymethod"));
                contractPayItem.set("payway", payPlanEntry.get("payway"));
                contractPayItem.set("payamount", payPlanEntry.get("payamount"));
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.REVISE.getValue());
                break;
            }
            case "pmct_outcontractrevision": {
                contractPayItem.set("remarks", payPlanEntry.get("remarks"));
                contractPayItem.set("payfeq", payPlanEntry.get("payfeq"));
                contractPayItem.set("payway", payPlanEntry.get("payway"));
                contractPayItem.set("payamount", payPlanEntry.get("payamountoftax"));
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.MODIFY.getValue());
                break;
            }
            case "pmct_outaddagreement": {
                contractPayItem.set("remarks", payPlanEntry.get("remarks"));
                contractPayItem.set("payfeq", payPlanEntry.get("payfeq"));
                contractPayItem.set("payway", payPlanEntry.get("payway"));
                contractPayItem.set("payamount", (Object)payPlanEntry.getBigDecimal("payamountoftax"));
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.ADDITION.getValue());
                break;
            }
            case "pmct_outclaimbill": {
                contractPayItem.set("remarks", payPlanEntry.get("remarks"));
                contractPayItem.set("payfeq", payPlanEntry.get("payfeq"));
                contractPayItem.set("payway", payPlanEntry.get("payway"));
                contractPayItem.set("payamount", (Object)payPlanEntry.getBigDecimal("payamountoftax"));
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.CLAIM.getValue());
                break;
            }
        }
        contractPayItem.set("paypercent", payPlanEntry.get("paypercent"));
        contractPayItem.set("planpaytime", payPlanEntry.get("planpaytime"));
        contractPayItem.set("currency", (Object)currentBill.getDynamicObject("currency"));
        BigDecimal payAmount = contractPayItem.getBigDecimal("payamount");
        contractPayItem.set("reimbursableamt", (Object)payAmount.subtract(contractPayItem.getBigDecimal("reimbursedcomamt")));
        contractPayItem.set("unpaidamt", (Object)payAmount.subtract(contractPayItem.getBigDecimal("paidcomamt")));
        contractPayItem.set("appliableamt", (Object)payAmount.subtract(contractPayItem.getBigDecimal("appliedcomamt")));
        contractPayItem.set("ctrlstrategy", payPlanEntry.get("ctrlstrategy"));
        contractPayItem.set("nodesettingsource", payPlanEntry.get("nodesettingsource"));
        contractPayItem.set("nodesetting", payPlanEntry.get("nodesetting"));
        contractPayItem.set("status", (Object)StatusEnum.CHECKED.getValue());
        Date now = new Date();
        contractPayItem.set("modifytime", (Object)now);
        contractPayItem.set("modifier", (Object)RequestContext.get().getUserId());
        contractPayItem.set("paydirection", (Object)PayDirectionEnum.OUT.getValue());
        return contractPayItem;
    }

    public static int delete(DynamicObject contract) {
        int count = 0;
        Object contractPk = contract.getPkValue();
        logger.info("delete#contract#id:{}", contractPk);
        try (TXHandle h = TX.required();){
            try {
                count = DeleteServiceHelper.delete((String)"pmbs_contractpayitem", (QFilter[])new QFilter[]{new QFilter("contract", "=", contractPk)});
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        return count;
    }

    public static void deletePayPlanItem(DynamicObjectCollection payPlanEntry, String currentFormId, DynamicObject contract) {
        ArrayList<Object> contractPlanItemIdList = new ArrayList<Object>(16);
        if (!payPlanEntry.isEmpty()) {
            for (DynamicObject payPlan : payPlanEntry) {
                Object contractPlanItemId;
                if ("pmct_contractrevision".equals(currentFormId)) {
                    contractPlanItemId = payPlan.getLong("conpayitemid");
                    if ((Long)contractPlanItemId == 0L) continue;
                    contractPlanItemIdList.add(contractPlanItemId);
                    payPlan.set("conpayitemid", (Object)0);
                    continue;
                }
                contractPlanItemId = payPlan.getString("conplanitemid");
                if (((String)contractPlanItemId).isEmpty()) continue;
                contractPlanItemIdList.add(Long.parseLong((String)contractPlanItemId));
                payPlan.set("conplanitemid", null);
            }
        } else {
            QFilter autoFilter = new QFilter("autogenerated", "=", (Object)Boolean.TRUE);
            QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
            DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"id", (QFilter[])new QFilter[]{autoFilter, contractFilter});
            if (payItems != null && payItems.length > 0) {
                contractPlanItemIdList.add(Long.parseLong(payItems[0].getPkValue().toString()));
            }
        }
        if (!contractPlanItemIdList.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem"), (Object[])contractPlanItemIdList.toArray());
        }
    }

    public static void updateLastPayPaln(DynamicObject bill, DynamicObjectCollection currentPlanEntry, DynamicObject[] claims, DynamicObject[] contractRevisions, DynamicObject[] contractChanges, DynamicObject[] contAddAgreements) {
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contract.getPkValue().toString()), (String)"pmct_outcontract");
        Date auditDate = bill.getDate("auditdate");
        DynamicObject lastObject = null;
        String formId = null;
        DynamicObjectCollection payPlanEntry = null;
        Date maxDate = auditDate;
        if (claims.length > 0) {
            DynamicObject outClaim = claims[0];
            maxDate = outClaim.getDate("auditdate");
            lastObject = outClaim;
            formId = "pmct_outclaimbill";
        }
        if (contractRevisions.length > 0) {
            DynamicObject contractRevision = contractRevisions[0];
            Date revisionDate = contractRevision.getDate("auditdate");
            if (maxDate.compareTo(auditDate) != 0) {
                if (maxDate.compareTo(revisionDate) < 0) {
                    maxDate = revisionDate;
                    lastObject = contractRevision;
                    formId = "pmct_contractrevision";
                }
            } else {
                maxDate = revisionDate;
                lastObject = contractRevision;
                formId = "pmct_contractrevision";
            }
        }
        if (contractChanges.length > 0) {
            DynamicObject outContractRevision = contractChanges[0];
            Date outContractRevisionDate = outContractRevision.getDate("auditdate");
            if (maxDate.compareTo(auditDate) != 0) {
                if (maxDate.compareTo(outContractRevisionDate) < 0) {
                    maxDate = outContractRevisionDate;
                    lastObject = outContractRevision;
                    formId = "pmct_outcontractrevision";
                }
            } else {
                maxDate = outContractRevisionDate;
                lastObject = outContractRevision;
                formId = "pmct_outcontractrevision";
            }
        }
        if (contAddAgreements.length > 0) {
            DynamicObject outContAddAgreement = contAddAgreements[0];
            Date contAddAgreementDate = outContAddAgreement.getDate("auditdate");
            if (maxDate.compareTo(auditDate) != 0) {
                if (maxDate.compareTo(contAddAgreementDate) < 0) {
                    lastObject = outContAddAgreement;
                    formId = "pmct_outaddagreement";
                }
            } else {
                lastObject = outContAddAgreement;
                formId = "pmct_outaddagreement";
            }
        }
        if (formId != null) {
            lastObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(lastObject.getPkValue().toString()), (String)formId);
            DynamicObject currency = lastObject.getDynamicObject("currency");
            PayPlanSourceEnum payPlanSource = null;
            String payEntryRelateItemIdKey = null;
            BigDecimal latestAmountOfTax = BigDecimal.ZERO;
            if ("pmct_outclaimbill".equals(formId)) {
                payPlanEntry = lastObject.getDynamicObjectCollection("claimpayplanentry");
                payPlanSource = PayPlanSourceEnum.CLAIM;
                payEntryRelateItemIdKey = "conplanitemid";
                latestAmountOfTax = lastObject.getBigDecimal("afteroftaxamount");
            } else if ("pmct_contractrevision".equals(formId)) {
                payPlanEntry = lastObject.getDynamicObjectCollection("outcontpayplanentry");
                payPlanSource = PayPlanSourceEnum.REVISE;
                payEntryRelateItemIdKey = "conpayitemid";
                latestAmountOfTax = lastObject.getBigDecimal("originaloftaxamount");
            } else if ("pmct_outcontractrevision".equals(formId)) {
                payPlanEntry = lastObject.getDynamicObjectCollection("changepayplanentry");
                payPlanSource = PayPlanSourceEnum.MODIFY;
                payEntryRelateItemIdKey = "conplanitemid";
                latestAmountOfTax = lastObject.getBigDecimal("latestamountoftax");
            } else if ("pmct_outaddagreement".equals(formId)) {
                payPlanEntry = lastObject.getDynamicObjectCollection("payplanentry");
                payPlanSource = PayPlanSourceEnum.ADDITION;
                payEntryRelateItemIdKey = "conplanitemid";
                latestAmountOfTax = lastObject.getBigDecimal("latestamountoftax");
            }
            ContractPayItemHelper.updatePayItem(contract.getPkValue(), lastObject, payPlanEntry, latestAmountOfTax, payEntryRelateItemIdKey, payPlanSource);
            ContractPayItemHelper.handlePayEntryRelateItemId(contract.getPkValue(), bill, currentPlanEntry);
        } else {
            lastObject = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"));
            payPlanEntry = lastObject.getDynamicObjectCollection("outcontpayplanentry");
            BigDecimal latestAmountOfTax = lastObject.getBigDecimal("originaloftaxamount");
            ContractPayItemHelper.updatePayItem(contract.getPkValue(), lastObject, payPlanEntry, latestAmountOfTax, "conplanitemid", PayPlanSourceEnum.CONTRACT);
            ContractPayItemHelper.handlePayEntryRelateItemId(contract.getPkValue(), bill, currentPlanEntry);
        }
    }

    public static void handlePayEntryRelateItemId(Object contractPk, DynamicObject currentbill, DynamicObjectCollection currentPlanEntry) {
        String currentPayEntryRelateItemIdKey = "conplanitemid";
        String currentBillFormId = currentbill.getDataEntityType().getName();
        if ("pmct_contractrevision".equals(currentBillFormId)) {
            currentPayEntryRelateItemIdKey = "conpayitemid";
        }
        for (DynamicObject payPlanEntry : currentPlanEntry) {
            Long relateItemId = null;
            if (payPlanEntry.get(currentPayEntryRelateItemIdKey) instanceof String && !StringUtils.isEmpty((CharSequence)payPlanEntry.getString(currentPayEntryRelateItemIdKey))) {
                relateItemId = Long.parseLong(payPlanEntry.getString(currentPayEntryRelateItemIdKey));
            } else if (payPlanEntry.get(currentPayEntryRelateItemIdKey) instanceof Long) {
                relateItemId = payPlanEntry.getLong(currentPayEntryRelateItemIdKey);
            }
            if (QueryServiceHelper.exists((String)"pmbs_contractpayitem", relateItemId)) continue;
            payPlanEntry.set(currentPayEntryRelateItemIdKey, null);
        }
        SaveServiceHelper.update((DynamicObject)currentbill);
    }

    public static void createConPayItem(DynamicObjectCollection payPlanEntry, String formId, DynamicObject lastObject, DynamicObject currency) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem");
        DynamicObject contract = lastObject;
        if (!"pmct_outcontract".equals(formId)) {
            contract = lastObject.getDynamicObject("contract");
        }
        if (contract != null) {
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        }
        ArrayList<DynamicObject> contractPayItemList = new ArrayList<DynamicObject>(16);
        if ("pmct_outclaimbill".equals(formId)) {
            for (DynamicObject payPlanObject : payPlanEntry) {
                DynamicObject contractPayItem;
                if (payPlanObject.getString("conplanitemid").isEmpty()) continue;
                DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(payPlanObject.getString("conplanitemid")))});
                if (contractPayItems.length == 0) {
                    contractPayItem = new DynamicObject((DynamicObjectType)dt);
                    contractPayItem.set("id", (Object)Long.parseLong(payPlanObject.getString("conplanitemid")));
                    contractPayItem.set("masterid", (Object)Long.parseLong(payPlanObject.getString("conplanitemid")));
                } else {
                    contractPayItem = contractPayItems[0];
                    contractPayItem = BusinessDataServiceHelper.loadSingle((Object)contractPayItem.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem"));
                }
                contractPayItem.set("source", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.CLAIM.getValue());
                String payPlanSourceId = payPlanObject.getString("payplansourceid");
                if (!payPlanSourceId.isEmpty() && !"0".equals(payPlanSourceId)) {
                    Map<String, String> numberNameMap = ContractPayItemHelper.getSourceObject(payPlanSourceId);
                    contractPayItem.set("name", (Object)numberNameMap.get("billname"));
                    contractPayItem.set("billno", (Object)numberNameMap.get("billnumber"));
                    contractPayItem.set("payplanentryid", (Object)payPlanSourceId);
                } else {
                    String payType = payPlanObject.getString("paytype");
                    contractPayItem.set("name", (Object)ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_outclaimbill", (String)"claimpayplanentry", null, (String)"paytype", (String)payType), PayPlanSourceEnum.CLAIM.getName(), lastObject.getString("billno"), payPlanObject.getString("seq")));
                    contractPayItem.set("billno", (Object)ContractPayItemHelper.setBillNumber(lastObject.getDynamicObject("org").getString("number"), payType, PayPlanSourceEnum.CLAIM.getValue(), lastObject.getString("billno"), payPlanObject.getString("seq")));
                    contractPayItem.set("payplanentryid", payPlanObject.getPkValue());
                }
                contractPayItem.set("autogenerated", (Object)Boolean.FALSE);
                contractPayItem.set("ctrlstrategy", payPlanObject.get("ctrlstrategy"));
                contractPayItem.set("nodesettingsource", payPlanObject.get("nodesettingsource"));
                contractPayItem.set("nodesetting", payPlanObject.get("nodesetting"));
                BigDecimal payAmountOfTax = (BigDecimal)payPlanObject.get("payamountoftax");
                BigDecimal reimbursedComAmt = (BigDecimal)contractPayItem.get("reimbursedcomamt");
                contractPayItem.set("reimbursableamt", (Object)payAmountOfTax.subtract(reimbursedComAmt));
                BigDecimal paidComAmt = (BigDecimal)contractPayItem.get("paidcomamt");
                contractPayItem.set("currency", (Object)currency);
                contractPayItem.set("unpaidamt", (Object)payAmountOfTax.subtract(paidComAmt));
                contractPayItem.set("appliableamt", (Object)payAmountOfTax.subtract(contractPayItem.getBigDecimal("appliedcomamt")));
                contractPayItem.set("contract", (Object)contract);
                contractPayItem.set("supplier", payPlanObject.get("supplier"));
                contractPayItem.set("paytype", payPlanObject.get("paytype"));
                contractPayItem.set("payfeq", payPlanObject.get("payfeq"));
                contractPayItem.set("payway", payPlanObject.get("payway"));
                contractPayItem.set("paypercent", payPlanObject.get("paypercent"));
                contractPayItem.set("payamount", (Object)payAmountOfTax);
                contractPayItem.set("planpaytime", payPlanObject.get("planpaytime"));
                contractPayItem.set("remarks", payPlanObject.get("remarks"));
                Date now = new Date();
                contractPayItem.set("createtime", (Object)now);
                contractPayItem.set("modifytime", (Object)now);
                contractPayItem.set("creator", (Object)RequestContext.get().getUserId());
                contractPayItem.set("modifier", (Object)RequestContext.get().getUserId());
                contractPayItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
                contractPayItem.set("status", (Object)StatusEnum.CHECKED.getValue());
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.CLAIM.getValue());
                contractPayItem.set("paydirection", (Object)PayDirectionEnum.OUT.getValue());
                contractPayItemList.add(contractPayItem);
            }
        } else if ("pmct_contractrevision".equals(formId)) {
            for (DynamicObject payPlanObject : payPlanEntry) {
                DynamicObject contractPayItem;
                if (payPlanObject.getLong("conpayitemid") == 0L) continue;
                DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payPlanObject.getLong("conpayitemid"))});
                if (contractPayItems.length == 0) {
                    contractPayItem = new DynamicObject((DynamicObjectType)dt);
                    contractPayItem.set("id", (Object)Long.parseLong(payPlanObject.getString("conpayitemid")));
                    contractPayItem.set("masterid", (Object)Long.parseLong(payPlanObject.getString("conpayitemid")));
                } else {
                    contractPayItem = contractPayItems[0];
                    contractPayItem = BusinessDataServiceHelper.loadSingle((Object)contractPayItem.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem"));
                }
                contractPayItem.set("source", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.REVISE.getValue());
                String payPlanSourceId = payPlanObject.getString("paysourceid");
                if (!payPlanSourceId.isEmpty() && !"0".equals(payPlanSourceId)) {
                    Map<String, String> numberNameMap = ContractPayItemHelper.getSourceObject(payPlanSourceId);
                    contractPayItem.set("name", (Object)numberNameMap.get("billname"));
                    contractPayItem.set("billno", (Object)numberNameMap.get("billnumber"));
                    contractPayItem.set("payplanentryid", (Object)payPlanSourceId);
                } else {
                    String payType = payPlanObject.getString("paytype");
                    contractPayItem.set("name", (Object)ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_contractrevision", (String)"outcontpayplanentry", null, (String)"paytype", (String)payType), PayPlanSourceEnum.REVISE.getName(), lastObject.getString("billno"), payPlanObject.getString("seq")));
                    contractPayItem.set("billno", (Object)ContractPayItemHelper.setBillNumber(contract.getDynamicObject("org").getString("number"), payType, PayPlanSourceEnum.REVISE.getValue(), lastObject.getString("billno"), payPlanObject.getString("seq")));
                    contractPayItem.set("payplanentryid", payPlanObject.getPkValue());
                }
                contractPayItem.set("autogenerated", (Object)Boolean.FALSE);
                contractPayItem.set("ctrlstrategy", payPlanObject.get("ctrlstrategy"));
                contractPayItem.set("nodesettingsource", payPlanObject.get("nodesettingsource"));
                contractPayItem.set("nodesetting", payPlanObject.get("nodesetting"));
                BigDecimal payAmountOfTax = (BigDecimal)payPlanObject.get("payamount");
                BigDecimal reimbursedComAmt = (BigDecimal)contractPayItem.get("reimbursedcomamt");
                contractPayItem.set("reimbursableamt", (Object)payAmountOfTax.subtract(reimbursedComAmt));
                BigDecimal paidComAmt = (BigDecimal)contractPayItem.get("paidcomamt");
                contractPayItem.set("currency", (Object)currency);
                contractPayItem.set("unpaidamt", (Object)payAmountOfTax.subtract(paidComAmt));
                contractPayItem.set("appliableamt", (Object)payAmountOfTax.subtract(contractPayItem.getBigDecimal("appliedcomamt")));
                contractPayItem.set("contract", (Object)contract);
                contractPayItem.set("supplier", (Object)payPlanObject.getDynamicObject("supplier"));
                contractPayItem.set("paytype", payPlanObject.get("paytype"));
                contractPayItem.set("payfeq", payPlanObject.get("paymethod"));
                contractPayItem.set("payway", payPlanObject.get("payway"));
                contractPayItem.set("paypercent", payPlanObject.get("paypercent"));
                contractPayItem.set("payamount", (Object)payAmountOfTax);
                contractPayItem.set("planpaytime", payPlanObject.get("planpaytime"));
                contractPayItem.set("remarks", payPlanObject.get("paydescription"));
                Date now = new Date();
                contractPayItem.set("createtime", (Object)now);
                contractPayItem.set("modifytime", (Object)now);
                contractPayItem.set("creator", (Object)RequestContext.get().getUserId());
                contractPayItem.set("modifier", (Object)RequestContext.get().getUserId());
                contractPayItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
                contractPayItem.set("status", (Object)StatusEnum.CHECKED.getValue());
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.REVISE.getValue());
                contractPayItem.set("paydirection", (Object)PayDirectionEnum.OUT.getValue());
                contractPayItemList.add(contractPayItem);
            }
        } else if ("pmct_outcontractrevision".equals(formId)) {
            for (DynamicObject payPlanObject : payPlanEntry) {
                DynamicObject contractPayItem;
                if (payPlanObject.getString("conplanitemid").isEmpty()) continue;
                DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(payPlanObject.getString("conplanitemid")))});
                if (contractPayItems.length == 0) {
                    contractPayItem = new DynamicObject((DynamicObjectType)dt);
                    contractPayItem.set("id", (Object)Long.parseLong(payPlanObject.getString("conplanitemid")));
                    contractPayItem.set("masterid", (Object)Long.parseLong(payPlanObject.getString("conplanitemid")));
                } else {
                    contractPayItem = contractPayItems[0];
                    contractPayItem = BusinessDataServiceHelper.loadSingle((Object)contractPayItem.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem"));
                }
                contractPayItem.set("source", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.MODIFY.getValue());
                String payPlanSourceId = payPlanObject.getString("payplansourceid");
                if (!payPlanSourceId.isEmpty() && !"0".equals(payPlanSourceId)) {
                    Map<String, String> numberNameMap = ContractPayItemHelper.getSourceObject(payPlanSourceId);
                    contractPayItem.set("name", (Object)numberNameMap.get("billname"));
                    contractPayItem.set("billno", (Object)numberNameMap.get("billnumber"));
                    contractPayItem.set("payplanentryid", (Object)payPlanSourceId);
                } else {
                    String payType = payPlanObject.getString("paytype");
                    contractPayItem.set("name", (Object)ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_outcontractrevision", (String)"changepayplanentry", null, (String)"paytype", (String)payType), PayPlanSourceEnum.MODIFY.getName(), lastObject.getString("billno"), payPlanObject.getString("seq")));
                    contractPayItem.set("billno", (Object)ContractPayItemHelper.setBillNumber(lastObject.getDynamicObject("org").getString("number"), payType, PayPlanSourceEnum.MODIFY.getValue(), lastObject.getString("billno"), payPlanObject.getString("seq")));
                    contractPayItem.set("payplanentryid", payPlanObject.getPkValue());
                }
                contractPayItem.set("autogenerated", (Object)Boolean.FALSE);
                contractPayItem.set("ctrlstrategy", payPlanObject.get("ctrlstrategy"));
                contractPayItem.set("nodesettingsource", payPlanObject.get("nodesettingsource"));
                contractPayItem.set("nodesetting", payPlanObject.get("nodesetting"));
                BigDecimal payAmountOfTax = (BigDecimal)payPlanObject.get("payamountoftax");
                BigDecimal reimbursedComAmt = (BigDecimal)contractPayItem.get("reimbursedcomamt");
                contractPayItem.set("reimbursableamt", (Object)payAmountOfTax.subtract(reimbursedComAmt));
                BigDecimal paidComAmt = (BigDecimal)contractPayItem.get("paidcomamt");
                contractPayItem.set("currency", (Object)currency);
                contractPayItem.set("unpaidamt", (Object)payAmountOfTax.subtract(paidComAmt));
                contractPayItem.set("appliableamt", (Object)payAmountOfTax.subtract(contractPayItem.getBigDecimal("appliedcomamt")));
                contractPayItem.set("contract", (Object)contract);
                contractPayItem.set("supplier", (Object)payPlanObject.getDynamicObject("supplier"));
                contractPayItem.set("paytype", payPlanObject.get("paytype"));
                contractPayItem.set("payfeq", payPlanObject.get("payfeq"));
                contractPayItem.set("payway", payPlanObject.get("payway"));
                contractPayItem.set("paypercent", payPlanObject.get("paypercent"));
                contractPayItem.set("payamount", (Object)payAmountOfTax);
                contractPayItem.set("planpaytime", payPlanObject.get("planpaytime"));
                contractPayItem.set("remarks", payPlanObject.get("remarks"));
                Date now = new Date();
                contractPayItem.set("createtime", (Object)now);
                contractPayItem.set("modifytime", (Object)now);
                contractPayItem.set("creator", (Object)RequestContext.get().getUserId());
                contractPayItem.set("modifier", (Object)RequestContext.get().getUserId());
                contractPayItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
                contractPayItem.set("status", (Object)StatusEnum.CHECKED.getValue());
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.MODIFY.getValue());
                contractPayItem.set("paydirection", (Object)PayDirectionEnum.OUT.getValue());
                contractPayItemList.add(contractPayItem);
            }
        } else if ("pmct_outaddagreement".equals(formId)) {
            for (DynamicObject payPlanObject : payPlanEntry) {
                DynamicObject contractPayItem;
                if (payPlanObject.getString("conplanitemid").isEmpty()) continue;
                DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(payPlanObject.getString("conplanitemid")))});
                if (contractPayItems.length == 0) {
                    contractPayItem = new DynamicObject((DynamicObjectType)dt);
                    contractPayItem.set("id", (Object)Long.parseLong(payPlanObject.getString("conplanitemid")));
                    contractPayItem.set("masterid", (Object)Long.parseLong(payPlanObject.getString("conplanitemid")));
                } else {
                    contractPayItem = contractPayItems[0];
                    contractPayItem = BusinessDataServiceHelper.loadSingle((Object)contractPayItem.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem"));
                }
                contractPayItem.set("source", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.ADDITION.getValue());
                String payPlanSourceId = payPlanObject.getString("payplansourceid");
                if (!payPlanSourceId.isEmpty() && !"0".equals(payPlanSourceId)) {
                    Map<String, String> numberNameMap = ContractPayItemHelper.getSourceObject(payPlanSourceId);
                    contractPayItem.set("name", (Object)numberNameMap.get("billname"));
                    contractPayItem.set("billno", (Object)numberNameMap.get("billnumber"));
                    contractPayItem.set("payplanentryid", (Object)payPlanSourceId);
                } else {
                    String payType = payPlanObject.getString("paytype");
                    contractPayItem.set("name", (Object)ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_outaddagreement", (String)"payplanentry", null, (String)"paytype", (String)payType), PayPlanSourceEnum.ADDITION.getName(), lastObject.getString("billno"), payPlanObject.getString("seq")));
                    contractPayItem.set("billno", (Object)ContractPayItemHelper.setBillNumber(lastObject.getDynamicObject("org").getString("number"), payType, PayPlanSourceEnum.ADDITION.getValue(), lastObject.getString("billno"), payPlanObject.getString("seq")));
                    contractPayItem.set("payplanentryid", payPlanObject.getPkValue());
                }
                contractPayItem.set("autogenerated", (Object)Boolean.FALSE);
                contractPayItem.set("ctrlstrategy", payPlanObject.get("ctrlstrategy"));
                contractPayItem.set("nodesettingsource", payPlanObject.get("nodesettingsource"));
                contractPayItem.set("nodesetting", payPlanObject.get("nodesetting"));
                BigDecimal payAmountOfTax = (BigDecimal)payPlanObject.get("payamountoftax");
                BigDecimal reimbursedComAmt = (BigDecimal)contractPayItem.get("reimbursedcomamt");
                contractPayItem.set("reimbursableamt", (Object)payAmountOfTax.subtract(reimbursedComAmt));
                contractPayItem.set("currency", (Object)currency);
                BigDecimal paidComAmt = (BigDecimal)contractPayItem.get("paidcomamt");
                contractPayItem.set("unpaidamt", (Object)payAmountOfTax.subtract(paidComAmt));
                contractPayItem.set("appliableamt", (Object)payAmountOfTax.subtract(contractPayItem.getBigDecimal("appliedcomamt")));
                contractPayItem.set("contract", (Object)contract);
                contractPayItem.set("supplier", (Object)payPlanObject.getDynamicObject("supplier"));
                contractPayItem.set("paytype", payPlanObject.get("paytype"));
                contractPayItem.set("payfeq", payPlanObject.get("payfeq"));
                contractPayItem.set("payway", payPlanObject.get("payway"));
                contractPayItem.set("paypercent", payPlanObject.get("paypercent"));
                contractPayItem.set("payamount", (Object)payAmountOfTax);
                contractPayItem.set("planpaytime", payPlanObject.get("planpaytime"));
                contractPayItem.set("remarks", payPlanObject.get("remarks"));
                Date now = new Date();
                contractPayItem.set("createtime", (Object)now);
                contractPayItem.set("modifytime", (Object)now);
                contractPayItem.set("creator", (Object)RequestContext.get().getUserId());
                contractPayItem.set("modifier", (Object)RequestContext.get().getUserId());
                contractPayItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
                contractPayItem.set("status", (Object)StatusEnum.CHECKED.getValue());
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.ADDITION.getValue());
                contractPayItem.set("paydirection", (Object)PayDirectionEnum.OUT.getValue());
                contractPayItemList.add(contractPayItem);
            }
        } else {
            for (DynamicObject payPlanObject : payPlanEntry) {
                DynamicObject contractPayItem;
                if (payPlanObject.getString("conplanitemid").isEmpty()) continue;
                DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(payPlanObject.getString("conplanitemid")))});
                if (contractPayItems.length == 0) {
                    contractPayItem = new DynamicObject((DynamicObjectType)dt);
                    contractPayItem.set("id", (Object)Long.parseLong(payPlanObject.getString("conplanitemid")));
                    contractPayItem.set("masterid", (Object)Long.parseLong(payPlanObject.getString("conplanitemid")));
                } else {
                    contractPayItem = contractPayItems[0];
                    contractPayItem = BusinessDataServiceHelper.loadSingle((Object)contractPayItem.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_contractpayitem"));
                }
                contractPayItem.set("source", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.CONTRACT.getValue());
                String payType = payPlanObject.getString("paytype");
                contractPayItem.set("name", (Object)ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_outcontract", (String)"outcontpayplanentry", null, (String)"paytype", (String)payType), PayPlanSourceEnum.CONTRACT.getName(), lastObject.getString("billno"), payPlanObject.getString("seq")));
                contractPayItem.set("billno", (Object)ContractPayItemHelper.setBillNumber(lastObject.getDynamicObject("org").getString("number"), payType, PayPlanSourceEnum.CONTRACT.getValue(), lastObject.getString("billno"), payPlanObject.getString("seq")));
                contractPayItem.set("autogenerated", (Object)Boolean.FALSE);
                contractPayItem.set("ctrlstrategy", payPlanObject.get("ctrlstrategy"));
                contractPayItem.set("nodesettingsource", payPlanObject.get("nodesettingsource"));
                contractPayItem.set("nodesetting", payPlanObject.get("nodesetting"));
                BigDecimal payAmountOfTax = payPlanObject.getBigDecimal("payamount");
                BigDecimal reimbursedComAmt = (BigDecimal)contractPayItem.get("reimbursedcomamt");
                contractPayItem.set("reimbursableamt", (Object)payAmountOfTax.subtract(reimbursedComAmt));
                contractPayItem.set("currency", (Object)currency);
                BigDecimal paidComAmt = (BigDecimal)contractPayItem.get("paidcomamt");
                contractPayItem.set("unpaidamt", (Object)payAmountOfTax.subtract(paidComAmt));
                contractPayItem.set("appliableamt", (Object)payAmountOfTax.subtract(contractPayItem.getBigDecimal("appliedcomamt")));
                contractPayItem.set("contract", (Object)contract);
                contractPayItem.set("supplier", (Object)payPlanObject.getDynamicObject("supplier"));
                contractPayItem.set("paytype", payPlanObject.get("paytype"));
                contractPayItem.set("payfeq", payPlanObject.get("paymethod"));
                contractPayItem.set("payway", payPlanObject.get("payway"));
                contractPayItem.set("paypercent", payPlanObject.get("paypercent"));
                contractPayItem.set("payamount", (Object)payAmountOfTax);
                contractPayItem.set("planpaytime", payPlanObject.get("planpaytime"));
                contractPayItem.set("remarks", payPlanObject.get("remarks"));
                Date now = new Date();
                contractPayItem.set("createtime", (Object)now);
                contractPayItem.set("modifytime", (Object)now);
                contractPayItem.set("creator", (Object)RequestContext.get().getUserId());
                contractPayItem.set("modifier", (Object)RequestContext.get().getUserId());
                contractPayItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
                contractPayItem.set("status", (Object)StatusEnum.CHECKED.getValue());
                contractPayItem.set("payplanentryid", payPlanObject.getPkValue());
                contractPayItem.set("payplansource", (Object)PayPlanSourceEnum.CONTRACT.getValue());
                contractPayItem.set("paydirection", (Object)PayDirectionEnum.OUT.getValue());
                contractPayItemList.add(contractPayItem);
            }
        }
        if (!contractPayItemList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])contractPayItemList.toArray(new DynamicObject[0]));
        }
    }

    private static Map<String, String> getSourceObject(String payPlanSourceId) {
        DynamicObjectCollection payPlanEntry;
        DynamicObject sourcePayPlan;
        HashMap<String, String> numberNameMap = new HashMap<String, String>();
        QFilter filter = new QFilter("outcontpayplanentry.id", "=", (Object)Long.parseLong(payPlanSourceId));
        DynamicObject payPlanSourceObject = BusinessDataServiceHelper.loadSingle((String)"pmct_outcontract", (String)"id", (QFilter[])new QFilter[]{filter});
        if (payPlanSourceObject != null && (sourcePayPlan = (DynamicObject)(payPlanEntry = (payPlanSourceObject = BusinessDataServiceHelper.loadSingle((Object)payPlanSourceObject.getPkValue(), (String)"pmct_outcontract")).getDynamicObjectCollection("outcontpayplanentry")).stream().filter(entry -> payPlanSourceId.equals(entry.getPkValue().toString())).findFirst().orElse(null)) != null) {
            String payType = sourcePayPlan.getString("paytype");
            numberNameMap.put("billnumber", ContractPayItemHelper.setBillNumber(payPlanSourceObject.getDynamicObject("org").getString("number"), payType, PayPlanSourceEnum.CONTRACT.getValue(), payPlanSourceObject.getString("billno"), sourcePayPlan.getString("seq")));
            numberNameMap.put("billname", ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_outcontract", (String)"outcontpayplanentry", null, (String)"paytype", (String)payType), PayPlanSourceEnum.CONTRACT.getName(), payPlanSourceObject.getString("billno"), sourcePayPlan.getString("seq")));
            return numberNameMap;
        }
        filter = new QFilter("outcontpayplanentry.id", "=", (Object)Long.parseLong(payPlanSourceId));
        payPlanSourceObject = BusinessDataServiceHelper.loadSingle((String)"pmct_contractrevision", (String)"id", (QFilter[])new QFilter[]{filter});
        if (payPlanSourceObject != null && (sourcePayPlan = (DynamicObject)(payPlanEntry = (payPlanSourceObject = BusinessDataServiceHelper.loadSingle((Object)payPlanSourceObject.getPkValue(), (String)"pmct_contractrevision")).getDynamicObjectCollection("outcontpayplanentry")).stream().filter(entry -> payPlanSourceId.equals(entry.getPkValue().toString())).findFirst().orElse(null)) != null) {
            DynamicObject contract = payPlanSourceObject.getDynamicObject("contract");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            String payType = sourcePayPlan.getString("paytype");
            numberNameMap.put("billnumber", ContractPayItemHelper.setBillNumber(contract.getDynamicObject("org").getString("number"), payType, PayPlanSourceEnum.REVISE.getValue(), payPlanSourceObject.getString("billno"), sourcePayPlan.getString("seq")));
            numberNameMap.put("billname", ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_contractrevision", (String)"outcontpayplanentry", null, (String)"paytype", (String)payType), PayPlanSourceEnum.REVISE.getName(), payPlanSourceObject.getString("billno"), sourcePayPlan.getString("seq")));
            return numberNameMap;
        }
        filter = new QFilter("changepayplanentry.id", "=", (Object)Long.parseLong(payPlanSourceId));
        payPlanSourceObject = BusinessDataServiceHelper.loadSingle((String)"pmct_outcontractrevision", (String)"id", (QFilter[])new QFilter[]{filter});
        if (payPlanSourceObject != null && (sourcePayPlan = (DynamicObject)(payPlanEntry = (payPlanSourceObject = BusinessDataServiceHelper.loadSingle((Object)payPlanSourceObject.getPkValue(), (String)"pmct_outcontractrevision")).getDynamicObjectCollection("changepayplanentry")).stream().filter(entry -> payPlanSourceId.equals(entry.getPkValue().toString())).findFirst().orElse(null)) != null) {
            String payType = sourcePayPlan.getString("paytype");
            numberNameMap.put("billnumber", ContractPayItemHelper.setBillNumber(payPlanSourceObject.getDynamicObject("org").getString("number"), payType, PayPlanSourceEnum.MODIFY.getValue(), payPlanSourceObject.getString("billno"), sourcePayPlan.getString("seq")));
            numberNameMap.put("billname", ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_outcontractrevision", (String)"changepayplanentry", null, (String)"paytype", (String)payType), PayPlanSourceEnum.MODIFY.getName(), payPlanSourceObject.getString("billno"), sourcePayPlan.getString("seq")));
            return numberNameMap;
        }
        filter = new QFilter("payplanentry.id", "=", (Object)Long.parseLong(payPlanSourceId));
        payPlanSourceObject = BusinessDataServiceHelper.loadSingle((String)"pmct_outaddagreement", (String)"id", (QFilter[])new QFilter[]{filter});
        if (payPlanSourceObject != null && (sourcePayPlan = (DynamicObject)(payPlanEntry = (payPlanSourceObject = BusinessDataServiceHelper.loadSingle((Object)payPlanSourceObject.getPkValue(), (String)"pmct_outaddagreement")).getDynamicObjectCollection("payplanentry")).stream().filter(entry -> payPlanSourceId.equals(entry.getPkValue().toString())).findFirst().orElse(null)) != null) {
            String payType = sourcePayPlan.getString("paytype");
            numberNameMap.put("billnumber", ContractPayItemHelper.setBillNumber(payPlanSourceObject.getDynamicObject("org").getString("number"), payType, PayPlanSourceEnum.ADDITION.getValue(), payPlanSourceObject.getString("billno"), sourcePayPlan.getString("seq")));
            numberNameMap.put("billname", ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_outaddagreement", (String)"payplanentry", null, (String)"paytype", (String)payType), PayPlanSourceEnum.ADDITION.getName(), payPlanSourceObject.getString("billno"), sourcePayPlan.getString("seq")));
            return numberNameMap;
        }
        filter = new QFilter("claimpayplanentry.id", "=", (Object)Long.parseLong(payPlanSourceId));
        payPlanSourceObject = BusinessDataServiceHelper.loadSingle((String)"pmct_outclaimbill", (String)"id", (QFilter[])new QFilter[]{filter});
        if (payPlanSourceObject != null && (sourcePayPlan = (DynamicObject)(payPlanEntry = (payPlanSourceObject = BusinessDataServiceHelper.loadSingle((Object)payPlanSourceObject.getPkValue(), (String)"pmct_outclaimbill")).getDynamicObjectCollection("claimpayplanentry")).stream().filter(entry -> payPlanSourceId.equals(entry.getPkValue().toString())).findFirst().orElse(null)) != null) {
            String payType = sourcePayPlan.getString("paytype");
            numberNameMap.put("billnumber", ContractPayItemHelper.setBillNumber(payPlanSourceObject.getDynamicObject("org").getString("number"), payType, PayPlanSourceEnum.CLAIM.getValue(), payPlanSourceObject.getString("billno"), sourcePayPlan.getString("seq")));
            numberNameMap.put("billname", ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)"pmct_outclaimbill", (String)"claimpayplanentry", null, (String)"paytype", (String)payType), PayPlanSourceEnum.CLAIM.getName(), payPlanSourceObject.getString("billno"), sourcePayPlan.getString("seq")));
            return numberNameMap;
        }
        return numberNameMap;
    }

    @Deprecated
    public static void createContractPayItem(DynamicObjectCollection payPlanEntry, String formId, DynamicObject lastObject, DynamicObject currency) {
        ContractPayItemHelper.createConPayItem(payPlanEntry, formId, lastObject, currency);
    }

    public static void setBillNameInPayPlanEntry(IDataModel model) {
        DynamicObjectCollection payPlanEntry = null;
        String formBillId = model.getDataEntityType().getName();
        String sourceName = null;
        String payItemIdKey = null;
        String payPlanSourceIdKey = null;
        if (!QueryServiceHelper.exists((String)formBillId, (Object)model.getDataEntity().getPkValue())) {
            return;
        }
        DynamicObject curBill = BusinessDataServiceHelper.loadSingle((Object)model.getDataEntity().getPkValue(), (String)formBillId);
        String billNo = curBill.getString("billno");
        String planEntryId = null;
        switch (formBillId) {
            case "pmct_outcontract": {
                payPlanEntry = curBill.getDynamicObjectCollection("outcontpayplanentry");
                sourceName = PayPlanSourceEnum.CONTRACT.getName();
                payItemIdKey = "conplanitemid";
                planEntryId = "outcontpayplanentry";
                break;
            }
            case "pmct_contractrevision": {
                payPlanEntry = curBill.getDynamicObjectCollection("outcontpayplanentry");
                sourceName = PayPlanSourceEnum.REVISE.getName();
                payItemIdKey = "conpayitemid";
                payPlanSourceIdKey = "payplansourceid";
                planEntryId = "outcontpayplanentry";
                break;
            }
            case "pmct_outcontractrevision": {
                payPlanEntry = curBill.getDynamicObjectCollection("changepayplanentry");
                sourceName = PayPlanSourceEnum.MODIFY.getName();
                payItemIdKey = "conplanitemid";
                payPlanSourceIdKey = "payplansourceid";
                planEntryId = "changepayplanentry";
                break;
            }
            case "pmct_outclaimbill": {
                payPlanEntry = curBill.getDynamicObjectCollection("claimpayplanentry");
                sourceName = PayPlanSourceEnum.CLAIM.getName();
                payItemIdKey = "conplanitemid";
                payPlanSourceIdKey = "payplansourceid";
                planEntryId = "claimpayplanentry";
                break;
            }
            case "pmct_outaddagreement": {
                payPlanEntry = curBill.getDynamicObjectCollection("payplanentry");
                sourceName = PayPlanSourceEnum.ADDITION.getName();
                payItemIdKey = "conplanitemid";
                payPlanSourceIdKey = "payplansourceid";
                planEntryId = "payplanentry";
                break;
            }
        }
        if (payPlanEntry != null && payPlanEntry.size() > 0) {
            String billStatus = curBill.getString("billstatus");
            for (int index = 0; index < payPlanEntry.size(); ++index) {
                String payItemName;
                Object planItem = ((DynamicObject)payPlanEntry.get(index)).get(payItemIdKey);
                long conPlanItemId = 0L;
                if (planItem instanceof String && StringUtils.isNotEmpty((CharSequence)String.valueOf(planItem))) {
                    conPlanItemId = Long.parseLong(String.valueOf(planItem));
                }
                if (planItem instanceof Long) {
                    conPlanItemId = (Long)planItem;
                }
                QFilter idFilter = new QFilter("id", "=", (Object)conPlanItemId);
                DynamicObject payItem = BusinessDataServiceHelper.loadSingle((String)"pmbs_contractpayitem", (String)"name", (QFilter[])new QFilter[]{idFilter});
                if (StatusEnum.TEMPSAVE.getValue().equals(billStatus)) {
                    if (payItem != null) {
                        payItemName = payItem.getLocaleString("name").getLocaleValue();
                        if (StringUtils.isBlank((CharSequence)payItemName)) {
                            payItemName = payItem.getString("name");
                        }
                        model.setValue("payitemname", (Object)payItemName, index);
                        continue;
                    }
                    model.setValue("payitemname", null, index);
                    model.setValue(payItemIdKey, null, index);
                    continue;
                }
                if (payItem != null) {
                    payItemName = payItem.getLocaleString("name").getLocaleValue();
                    if (StringUtils.isBlank((CharSequence)payItemName)) {
                        payItemName = payItem.getString("name");
                    }
                    model.setValue("payitemname", (Object)payItemName, index);
                    continue;
                }
                String payType = ((DynamicObject)payPlanEntry.get(index)).getString("paytype");
                String billName = ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)formBillId, (String)planEntryId, null, (String)"paytype", (String)payType), sourceName, billNo, String.valueOf(index + 1));
                if (conPlanItemId != 0L) {
                    Map<String, String> sourcePayPlanData;
                    String payPlanSourceId;
                    if (payPlanSourceIdKey != null && StringUtils.isNotBlank((CharSequence)(payPlanSourceId = ((DynamicObject)payPlanEntry.get(index)).getString(payPlanSourceIdKey))) && !(sourcePayPlanData = ContractPayItemHelper.gainSourcePayPlan(payPlanSourceId)).isEmpty()) {
                        String sourcePayType = sourcePayPlanData.get("paytype");
                        String sourcePayName = sourcePayPlanData.get("sourcename");
                        String sourceBillNo = sourcePayPlanData.get("billno");
                        billName = ContractPayItemHelper.setBillName(ComboItemHelper.getName((String)formBillId, (String)planEntryId, null, (String)"paytype", (String)sourcePayType), sourcePayName, sourceBillNo, String.valueOf(index + 1));
                    }
                    billName = String.format(ResManager.loadKDString((String)"%s_\u5df2\u5220\u9664", (String)"ContractPayItemHelper_1", (String)"pmgt-pmbs-business", (Object[])new Object[0]), billName);
                }
                model.setValue("payitemname", (Object)billName, index);
            }
        }
    }

    private static Map<String, String> gainSourcePayPlan(String payPlanSourceId) {
        HashMap<String, String> sourcePayPlanData = new HashMap<String, String>(16);
        if (StringUtils.isNotBlank((CharSequence)payPlanSourceId)) {
            QFilter qFilter = new QFilter("outcontpayplanentry.id", "=", (Object)Long.parseLong(payPlanSourceId));
            DynamicObject sourcePayPlanObj = BusinessDataServiceHelper.loadSingle((String)"pmct_outcontract", (String)String.join((CharSequence)",", "billno", "paytype"), (QFilter[])new QFilter[]{qFilter});
            if (sourcePayPlanObj == null) {
                sourcePayPlanObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractrevision", (String)String.join((CharSequence)",", "billno", "paytype"), (QFilter[])new QFilter[]{qFilter});
            }
            if (sourcePayPlanObj == null) {
                qFilter = new QFilter("changepayplanentry.id", "=", (Object)Long.parseLong(payPlanSourceId));
                sourcePayPlanObj = BusinessDataServiceHelper.loadSingle((String)"pmct_outcontractrevision", (String)String.join((CharSequence)",", "billno", "paytype"), (QFilter[])new QFilter[]{qFilter});
            }
            if (sourcePayPlanObj == null) {
                qFilter = new QFilter("claimpayplanentry.id", "=", (Object)Long.parseLong(payPlanSourceId));
                sourcePayPlanObj = BusinessDataServiceHelper.loadSingle((String)"pmct_outclaimbill", (String)String.join((CharSequence)",", "billno", "paytype"), (QFilter[])new QFilter[]{qFilter});
            }
            if (sourcePayPlanObj == null) {
                qFilter = new QFilter("payplanentry.id", "=", (Object)Long.parseLong(payPlanSourceId));
                sourcePayPlanObj = BusinessDataServiceHelper.loadSingle((String)"pmct_outaddagreement", (String)String.join((CharSequence)",", "billno", "paytype"), (QFilter[])new QFilter[]{qFilter});
            }
            if (sourcePayPlanObj != null) {
                String formBillId = sourcePayPlanObj.getDataEntityType().getName();
                String sourceName = null;
                String billNo = null;
                String payType = null;
                switch (formBillId) {
                    case "pmct_outcontract": {
                        sourceName = PayPlanSourceEnum.CONTRACT.getName();
                        billNo = sourcePayPlanObj.getString("billno");
                        DynamicObjectCollection payPlanEntry = sourcePayPlanObj.getDynamicObjectCollection("outcontpayplanentry");
                        if (payPlanEntry.size() <= 0) break;
                        Optional<DynamicObject> first = payPlanEntry.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)payPlanSourceId)).findFirst();
                        DynamicObject entry2 = new DynamicObject();
                        if (first.isPresent()) {
                            entry2 = first.get();
                        }
                        payType = entry2.getString("paytype");
                        break;
                    }
                    case "pmct_contractrevision": {
                        sourceName = PayPlanSourceEnum.REVISE.getName();
                        billNo = sourcePayPlanObj.getString("billno");
                        DynamicObjectCollection payPlanEntry = sourcePayPlanObj.getDynamicObjectCollection("outcontpayplanentry");
                        if (payPlanEntry.size() <= 0) break;
                        Optional<DynamicObject> first = payPlanEntry.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)payPlanSourceId)).findFirst();
                        DynamicObject entry3 = new DynamicObject();
                        if (first.isPresent()) {
                            entry3 = first.get();
                        }
                        payType = entry3.getString("paytype");
                        break;
                    }
                    case "pmct_outcontractrevision": {
                        sourceName = PayPlanSourceEnum.MODIFY.getName();
                        billNo = sourcePayPlanObj.getString("billno");
                        DynamicObjectCollection payPlanEntry = sourcePayPlanObj.getDynamicObjectCollection("changepayplanentry");
                        if (payPlanEntry.size() <= 0) break;
                        Optional<DynamicObject> first = payPlanEntry.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)payPlanSourceId)).findFirst();
                        DynamicObject entry4 = new DynamicObject();
                        if (first.isPresent()) {
                            entry4 = first.get();
                        }
                        payType = entry4.getString("paytype");
                        break;
                    }
                    case "pmct_outclaimbill": {
                        sourceName = PayPlanSourceEnum.CLAIM.getName();
                        billNo = sourcePayPlanObj.getString("billno");
                        DynamicObjectCollection payPlanEntry = sourcePayPlanObj.getDynamicObjectCollection("claimpayplanentry");
                        if (payPlanEntry.size() <= 0) break;
                        Optional<DynamicObject> first = payPlanEntry.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)payPlanSourceId)).findFirst();
                        DynamicObject entry5 = new DynamicObject();
                        if (first.isPresent()) {
                            entry5 = first.get();
                        }
                        payType = entry5.getString("paytype");
                        break;
                    }
                    case "pmct_outaddagreement": {
                        sourceName = PayPlanSourceEnum.ADDITION.getName();
                        billNo = sourcePayPlanObj.getString("billno");
                        DynamicObjectCollection payPlanEntry = sourcePayPlanObj.getDynamicObjectCollection("payplanentry");
                        if (payPlanEntry.size() <= 0) break;
                        Optional<DynamicObject> first = payPlanEntry.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)payPlanSourceId)).findFirst();
                        DynamicObject entry6 = new DynamicObject();
                        if (first.isPresent()) {
                            entry6 = first.get();
                        }
                        payType = entry6.getString("paytype");
                        break;
                    }
                }
                sourcePayPlanData.put("sourcename", sourceName);
                sourcePayPlanData.put("billno", billNo);
                sourcePayPlanData.put("paytype", payType);
            }
        }
        return sourcePayPlanData;
    }

    public static String setBillName(String payType, String sourceName, String billNo, String seq) {
        if (StringUtils.isNotBlank((CharSequence)seq)) {
            return String.format("%s_%s_%s_%s", payType, sourceName, billNo, seq);
        }
        return String.format("%s_%s_%s", payType, sourceName, billNo);
    }

    public static String setBillNumber(String orgNumber, String payType, String sourceName, String billNo, String seq) {
        if (StringUtils.isNotBlank((CharSequence)seq)) {
            return String.format("%s_%s_%s_%s_%s", orgNumber, payType, sourceName, billNo, seq);
        }
        return String.format("%s_%s_%s_%s", orgNumber, payType, sourceName, billNo);
    }

    public static Map<String, Map<Object, String>> getSrcObjCompleteMap(DynamicObject[] payItems) {
        HashMap<String, HashSet<Object>> sourceToObjIdsMap = new HashMap<String, HashSet<Object>>(3);
        for (DynamicObject payItem : payItems) {
            DynamicObject[] payNodeSetting = payItem.getDynamicObject("nodesetting");
            if (payNodeSetting == null) continue;
            String nodeSettingSource = payItem.getString("nodesettingsource");
            HashSet<Object> nodeObjSet = (HashSet<Object>)sourceToObjIdsMap.get(nodeSettingSource);
            if (nodeObjSet != null) {
                nodeObjSet.add(payNodeSetting.getPkValue());
                continue;
            }
            nodeObjSet = new HashSet<Object>();
            nodeObjSet.add(payNodeSetting.getPkValue());
            sourceToObjIdsMap.put(nodeSettingSource, nodeObjSet);
        }
        HashMap<String, Map<Object, String>> srcObjCompleteMap = new HashMap<String, Map<Object, String>>(3);
        Set taskSet = (Set)sourceToObjIdsMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        if (taskSet != null && !taskSet.isEmpty()) {
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)"percent,completionstatus,islatest,sourcetask", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)taskSet)});
            HashMap<Long, Object> srcToCurTaskMap = new HashMap<Long, Object>(tasks.length);
            for (DynamicObject task : tasks) {
                srcToCurTaskMap.put(task.getLong("sourcetask.id"), task.getPkValue());
            }
            taskSet = Arrays.stream(tasks).map(o -> o.getLong("sourcetask.id")).collect(Collectors.toSet());
            tasks = BusinessDataServiceHelper.load((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)"percent,completionstatus,islatest,sourcetask", (QFilter[])new QFilter[]{new QFilter("sourcetask", "in", taskSet), new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue())});
            HashMap nodeObjCompMap = new HashMap();
            for (DynamicObject task : tasks) {
                String completionStatus = task.getString("completionstatus");
                int percent = task.getInt("percent");
                if (StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue()) || StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue()) || percent == 100) {
                    nodeObjCompMap.put(srcToCurTaskMap.get(task.getLong("sourcetask.id")), TaskCompleteStateEnum.COMPLETE.getValue());
                    continue;
                }
                nodeObjCompMap.put(srcToCurTaskMap.get(task.getLong("sourcetask.id")), TaskCompleteStateEnum.INCOMPLETE.getValue());
            }
            srcObjCompleteMap.put(NodeSettingSourceEnum.PMBS_TASK.getValue(), nodeObjCompMap);
        }
        return srcObjCompleteMap;
    }

    public static void writeBackToPayItemForPayRegister(String operationKey, Map<Object, BigDecimal> entryAmtSumMap) {
        DynamicObject[] payItems;
        for (DynamicObject payItem : payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"payamount,paidcomamt,paidamt,unpaidamt", (QFilter[])new QFilter[]{new QFilter("id", "in", entryAmtSumMap.keySet())})) {
            BigDecimal payAmount = payItem.getBigDecimal("payamount");
            BigDecimal paidAmt = payItem.getBigDecimal("paidamt");
            BigDecimal paidComAmt = payItem.getBigDecimal("paidcomamt");
            BigDecimal newPaidAmt = paidAmt;
            BigDecimal newPaidComAmt = paidComAmt;
            BigDecimal newUnpaidAmt = payItem.getBigDecimal("unpaidamt");
            BigDecimal entrySumAmt = entryAmtSumMap.get(payItem.getPkValue());
            switch (operationKey) {
                case "submit": {
                    newPaidComAmt = paidAmt.add(entrySumAmt);
                    newUnpaidAmt = payAmount.subtract(newPaidComAmt);
                    break;
                }
                case "unsubmit": {
                    newPaidComAmt = paidComAmt.subtract(entrySumAmt);
                    newUnpaidAmt = payAmount.subtract(newPaidComAmt);
                    break;
                }
                case "audit": {
                    newPaidAmt = paidAmt.add(entrySumAmt);
                    break;
                }
                case "unaudit": {
                    newPaidAmt = paidAmt.subtract(entrySumAmt);
                    newPaidComAmt = paidComAmt.subtract(entrySumAmt);
                    newUnpaidAmt = payAmount.subtract(newPaidComAmt);
                    break;
                }
            }
            payItem.set("paidamt", (Object)newPaidAmt);
            payItem.set("paidcomamt", (Object)newPaidComAmt);
            payItem.set("unpaidamt", (Object)newUnpaidAmt);
        }
        SaveServiceHelper.update((DynamicObject[])payItems);
    }
}

