/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.web.actions.utils.FilePathUtil;

public class FileAttachmentHelper {
    private static final Log LOG = LogFactory.getLog(FileAttachmentHelper.class);
    private static final FileService fileService = FileServiceFactory.getAttachmentFileService();
    private static final TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
    private static final String ID = "ID";
    private static final String FNUMBER = "ID";
    private static final String FATTACHMENTNAME = "FAttachmentName";
    private static final String FINTERID = "FInterID";
    private static final String BOS_ATTACHMENT = "bos_attachment";
    private static final String FMODIFYTIME = "FModifyTime";
    private static final String FCREATETIME = "fcreatetime";
    private static final String FALIASFILENAME = "FaliasFileName";
    private static final String FEXTNAME = "FExtName";
    private static final String FATTACHMENTSIZE = "FATTACHMENTSIZE";
    private static final String FCREATEMEN = "FCREATEMEN";
    private static final String FATTACHMENTPANEL = "fattachmentpanel";
    private static final String FDESCRIPTION = "fdescription";
    private static final String FFILEID = "FFileId";
    private static final String FBILLTYPE = "FBillType";
    private static final Log logger = LogFactory.getLog(FileAttachmentHelper.class);

    public static void copyFileFromAToB(String sourceBillFormId, Object sourceBillId, String sourceAttachKey, String destinationBillFormId, Object destinationBillId, String destinationAttachKey) {
        LOG.info("copyFileFromAToB:sourceBillFormId\uff1a{}", (Object)sourceBillFormId);
        LOG.info("copyFileFromAToB:sourceBillId\uff1a{}", sourceBillId);
        LOG.info("copyFileFromAToB:sourceAttachKey\uff1a{}", (Object)sourceAttachKey);
        List sourceFileList = AttachmentServiceHelper.getAttachments((String)sourceBillFormId, (Object)sourceBillId, (String)sourceAttachKey);
        FileAttachmentHelper.copyFileToBillByPk(destinationBillFormId, destinationBillId, destinationAttachKey, sourceFileList);
    }

    public static void copyFileFromAToB(String sourceBillFormId, Object sourceBillId, String sourceAttachKey, String destinationBillFormId, Object destinationBillId, String destinationAttachKey, IFormView destinationView) {
        List attachmentData = AttachmentServiceHelper.getAttachments((String)sourceBillFormId, (Object)sourceBillId, (String)sourceAttachKey);
        attachmentData.forEach(attach -> {
            try {
                attach.put("lastModified", null);
                attach.put("url", FileAttachmentHelper.getPathFromDownloadUrl(URLDecoder.decode(String.valueOf(attach.get("url")), "UTF-8")));
            }
            catch (IOException var2) {
                logger.error((Throwable)var2);
            }
        });
        AttachmentServiceHelper.upload((String)destinationBillFormId, (Object)destinationBillId, (String)destinationAttachKey, (List)attachmentData);
    }

    public static void copyFileToBillByPk(String destinationBillFormId, Object destinationBillId, String destinationAttachKey, List<Map<String, Object>> attachments) {
        LOG.info("copyFileToBillByPk:destinationBillFormId\uff1a{}", (Object)destinationBillFormId);
        LOG.info("copyFileToBillByPk:destinationBillId\uff1a{}", destinationBillId);
        LOG.info("copyFileToBillByPk:destinationAttachKey\uff1a{}", (Object)destinationAttachKey);
        LOG.info("copyFileToBillByPk:attachments\uff1a{}", attachments);
        ORM orm = ORM.create();
        HashSet uidSet = Sets.newHashSetWithExpectedSize((int)attachments.size());
        HashMap attachMap = Maps.newHashMapWithExpectedSize((int)attachments.size());
        for (Map<String, Object> attach : attachments) {
            String uid = attach.get("uid").toString();
            uidSet.add(uid);
            attachMap.put(uid, attach);
        }
        QFilter[] filters = new QFilter[]{new QFilter("FNUMBER", "in", (Object)uidSet), new QFilter(FINTERID, "=", (Object)destinationBillId.toString()), new QFilter(FBILLTYPE, "=", (Object)destinationBillFormId)};
        DynamicObjectCollection dynColl = orm.getByFilter(BOS_ATTACHMENT, filters);
        if (dynColl != null && !dynColl.isEmpty()) {
            for (DynamicObject dyn : dynColl) {
                Map attach = (Map)attachMap.get(dyn.getString("fnumber"));
                Timestamp lastModified = (Timestamp)attach.get("lastModified");
                if (lastModified != null) {
                    dyn.set(FMODIFYTIME, (Object)new Date(lastModified.getTime()));
                } else {
                    dyn.set(FMODIFYTIME, (Object)new Date());
                }
                String name = (String)attach.get("name");
                dyn.set(FALIASFILENAME, (Object)name);
                dyn.set(FATTACHMENTNAME, (Object)name);
                dyn.set(FEXTNAME, (Object)(name != null ? name.substring(name.lastIndexOf(46) + 1) : ""));
                dyn.set(FATTACHMENTSIZE, attach.get("size"));
                String url = String.valueOf(attach.get("url"));
                dyn.set(FFILEID, (Object)FileAttachmentHelper.getUrlPath(url));
                dyn.set(FATTACHMENTPANEL, (Object)destinationAttachKey);
            }
            orm.update((List)dynColl);
        } else {
            long[] ids = orm.genLongIds(BOS_ATTACHMENT, attachments.size());
            int idIndex = 0;
            ArrayList<DynamicObject> newAttachObjList = new ArrayList<DynamicObject>(attachments.size());
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)BOS_ATTACHMENT);
            for (Map<String, Object> attach : attachments) {
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dt);
                dynamicObject.set("id", (Object)ids[idIndex++]);
                dynamicObject.set("FNUMBER", attach.get("uid"));
                dynamicObject.set(FBILLTYPE, (Object)destinationBillFormId);
                dynamicObject.set(FINTERID, destinationBillId);
                Date today = new Date();
                Timestamp lastModified = (Timestamp)attach.get("lastModified");
                if (lastModified != null) {
                    dynamicObject.set(FMODIFYTIME, (Object)new Date(lastModified.getTime()));
                } else {
                    dynamicObject.set(FMODIFYTIME, (Object)today);
                }
                dynamicObject.set(FCREATETIME, (Object)new Date((Long)attach.get("createdate")));
                String name = (String)attach.get("name");
                dynamicObject.set(FALIASFILENAME, (Object)name);
                dynamicObject.set(FATTACHMENTNAME, (Object)name);
                dynamicObject.set(FEXTNAME, (Object)(name != null ? name.substring(name.lastIndexOf(46) + 1) : ""));
                dynamicObject.set(FATTACHMENTSIZE, attach.get("size"));
                String url = String.valueOf(attach.get("url"));
                dynamicObject.set(FFILEID, (Object)FileAttachmentHelper.getUrlPath(url));
                dynamicObject.set(FCREATEMEN, attach.get(FCREATEMEN));
                dynamicObject.set(FDESCRIPTION, attach.get("description"));
                dynamicObject.set(FATTACHMENTPANEL, (Object)destinationAttachKey);
                newAttachObjList.add(dynamicObject);
            }
            orm.insert(newAttachObjList);
        }
    }

    public static Map<String, Object> fileDynamicObjectTransFormToMap(DynamicObject file, String finterid, String formId) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)BOS_ATTACHMENT);
        map.put("id", ORM.create().genLongId((IDataEntityType)dynamicObjectType));
        map.put("finterid", finterid);
        map.put("fbilltype", formId);
        map.put("fattachmentsize", file.get("size"));
        map.put("size", file.get("size"));
        map.put("fattachmentname", file.get("name"));
        map.put("faliasfilename", file.get("name"));
        map.put("name", ((OrmLocaleValue)file.get("name")).getLocaleValue());
        map.put("fnumber", file.get("uid"));
        map.put("uid", file.get("uid"));
        map.put("ffileid", file.get("url"));
        map.put("url", file.get("url"));
        map.put("fextname", file.get("type"));
        map.put(FCREATETIME, file.get("createtime"));
        map.put("createdate", ((Timestamp)file.get("createtime")).getTime());
        map.put("fcreatemen", file.get("creator"));
        map.put("fmodifytime", file.get("modifytime"));
        return map;
    }

    private static String getUrlPath(String url) {
        String[] urlArr = url.split("path=/");
        try {
            if (urlArr.length > 1) {
                String[] desUrlArr = urlArr[1].split("&kdedcba");
                return URLDecoder.decode(desUrlArr[0], "UTF-8");
            }
            String[] desUrlArr = urlArr[0].split("&kdedcba");
            return URLDecoder.decode(desUrlArr[0], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setAttachmentUrl(List<Map<String, Object>> attachments) {
        attachments.forEach(attachment -> {
            String url = (String)attachment.get("url");
            String name = (String)attachment.get("name");
            String tempUrl = FileAttachmentHelper.saveAsTempFile(url, name);
            attachment.put("url", tempUrl);
        });
    }

    private static String saveAsTempFile(String url, String name) {
        String path = url.split("download.do\\?path=")[1];
        path = path.substring(0, path.lastIndexOf("&kdedcba"));
        InputStream inputStream = fileService.getInputStream(path);
        String tempUrl = tempFileCache.saveAsUrl(name, inputStream, 7200);
        String address = RequestContext.get().getClientFullContextPath();
        if (!address.endsWith("/")) {
            address = address + "/";
        }
        tempUrl = address + tempUrl;
        return tempUrl;
    }

    public static String getPathFromDownloadUrl(String url) throws IOException {
        String path = StringUtils.substringAfter((String)url, (String)"path=");
        path = URLDecoder.decode(path, "UTF-8");
        return FilePathUtil.dealPath((String)path, (String)"attach");
    }

    public static DynamicObject setFileInAttachmentPanel(Object pkId, String billType, String aliasFileName, String attachmentName, String url, int fileSize, String attachmentpanel) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_ATTACHMENT);
        long id = ORM.create().genLongId(BOS_ATTACHMENT);
        dynamicObject.set("ID", (Object)id);
        dynamicObject.set("ID", (Object)FileAttachmentHelper.getFileNumberString());
        dynamicObject.set(FBILLTYPE, (Object)billType);
        dynamicObject.set(FATTACHMENTPANEL, (Object)attachmentpanel);
        dynamicObject.set(FINTERID, pkId);
        Date now = new Date();
        dynamicObject.set(FMODIFYTIME, (Object)now);
        dynamicObject.set(FCREATETIME, (Object)now);
        dynamicObject.set(FALIASFILENAME, (Object)aliasFileName);
        dynamicObject.set(FATTACHMENTNAME, (Object)attachmentName);
        dynamicObject.set(FEXTNAME, (Object)(aliasFileName != null ? aliasFileName.substring(aliasFileName.lastIndexOf(46) + 1) : ""));
        dynamicObject.set(FATTACHMENTSIZE, (Object)fileSize);
        dynamicObject.set(FCREATEMEN, (Object)RequestContext.get().getUserId());
        dynamicObject.set(FFILEID, (Object)url);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }

    public static String getFileNumberString() {
        StringBuilder prefixStr = new StringBuilder("rc-upload-");
        long currentTimeMillis = System.currentTimeMillis();
        SecureRandom r = new SecureRandom();
        int suffix = r.nextInt(99) + 1;
        String fileNumber = prefixStr.append(currentTimeMillis).append('-').append(suffix).toString();
        return fileNumber;
    }

    public static InputStream wordToPdf(String path, String filename) {
        InputStream in = null;
        try {
            LOG.info("wordToPdf,path:{},filename:{}", (Object)path, (Object)filename);
            String subfix = filename.substring(filename.lastIndexOf(46) + 1, filename.length());
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream doc = service.getInputStream(path);
            Map preview = service.preview(filename, path, RequestContext.get().getUserAgent());
            LOG.info("wordToPdf,preview:{}", (Object)preview);
            String status = (String)preview.get(PreviewParams.STATUS.getEnumName());
            if (!PreviewParams.ERROR.getEnumName().equals(status) && !PreviewParams.XLSX_SUCCESS.getEnumName().equals(status) && (PreviewParams.PDF_SUCCESS.getEnumName().equals(status) || PreviewParams.NOT_NEED_CHANGE.getEnumName().equals(status))) {
                in = (InputStream)preview.get(PreviewParams.RESULT.getEnumName());
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
        return in;
    }

    public static String uploadFile(InputStream in, String fileName, String path) {
        FileItem fileItem = new FileItem(fileName, path, in);
        fileItem.setCreateNewFileWhenExists(false);
        FileService service = FileServiceFactory.getAttachmentFileService();
        return service.upload(fileItem);
    }
}

