/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.business.invoicecloud.InvoiceCloudReturnVO;
import kd.pmgt.pmbs.business.invoicecloud.InvoiceDateFormatDeserializer;
import kd.pmgt.pmbs.business.invoicecloud.InvoiceDetailReturnVO;
import kd.pmgt.pmbs.business.invoicecloud.InvoiceItemVO;
import kd.pmgt.pmbs.business.invoicecloud.InvoiceVO;
import kd.pmgt.pmbs.business.invoicecloud.exception.InvoiceCloudException;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.InvoiceInterfaceEnum;
import kd.pmgt.pmbs.common.enums.InvoiceSourceEnum;
import kd.pmgt.pmbs.common.enums.InvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.TextHelper;
import kd.pmgt.pmbs.common.utils.invoicecloud.HttpURLConnectionHelper;
import kd.pmgt.pmbs.common.utils.invoicecloud.InvoiceCloudConfigHelper;
import kd.pmgt.pmbs.common.utils.invoicecloud.MD5;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class InvoiceImportHelper {
    private static final Log log = LogFactory.getLog(InvoiceImportHelper.class);
    private final HttpURLConnectionHelper connect = new HttpURLConnectionHelper();

    public List<InvoiceVO> analysisInvoiceData(Map<String, Object> paramsMap) {
        Object returnData = paramsMap.get("returnData");
        String invoiceInterface = paramsMap.get("invoiceinterface").toString();
        String companyId = paramsMap.get("companyid").toString();
        if (InvoiceInterfaceEnum.AWS.getValue().equals(invoiceInterface)) {
            JSONObject jsonObjectData = JSONObject.fromObject((Object)returnData);
            return this.closedCallBackFromAws(jsonObjectData, invoiceInterface, companyId);
        }
        return this.closedCallBackFromInvoiceCloud(returnData.toString(), invoiceInterface);
    }

    private List<InvoiceVO> closedCallBackFromInvoiceCloud(String returnData, String invoiceInterface) {
        List<InvoiceVO> dataList;
        try {
            dataList = this.parseInvoiceVO(returnData, invoiceInterface);
        }
        catch (InvoiceCloudException e) {
            log.error("\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968\u8be6\u60c5\u89e3\u6790\u5f02\u5e38\uff0c\u9519\u8bef\u65e5\u5fd7\u5982\u4e0b\uff1a%s", (Object)e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968\u8be6\u60c5\u89e3\u6790\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceImportHelper_4", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        }
        return dataList;
    }

    private List<InvoiceVO> closedCallBackFromAws(JSONObject jsonData, String invoiceInterface, String companyId) {
        List<InvoiceVO> dataList;
        log.info(String.format("\u5173\u95ed\u53d1\u7968\u4e91\u754c\u9762\u540e\u56de\u8c03\u65f6\u8fd4\u56de\u7684\u6570\u636e\u4e3a\uff1a%s", jsonData));
        Boolean isSuccess = (Boolean)jsonData.get("success");
        if (!isSuccess.booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6c42\u53d1\u7968\u4e91\u53d1\u751f\u5f02\u5e38\u3002", (String)"InvoiceImportHelper_1", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        }
        String url = InvoiceCloudConfigHelper.getQueryByInvoiceSerialNoUrl();
        HashMap<String, String> params = new HashMap<String, String>(10);
        params.put("userKey", "");
        String timestamp = String.valueOf(System.currentTimeMillis());
        params.put("timestamp", timestamp);
        if (StringUtils.isNotBlank((CharSequence)companyId)) {
            DynamicObject accountOrg = BusinessDataServiceHelper.loadSingle((Object)companyId, (String)"bos_org");
            DynamicObject config = InvoiceCloudConfigHelper.getConfigByAws((DynamicObject)accountOrg);
            String clientId = config.getString("client_id");
            String clientSecret = config.getString("client_secret");
            params.put("client_id", clientId);
            params.put("sign", MD5.md5crypt((String)(clientId + clientSecret + timestamp)));
        }
        params.put("fid", jsonData.getString("serialNo"));
        log.info(String.format("\u6839\u636e\u53d1\u7968\u5e8f\u5217\u53f7\u8bf7\u6c42\u53d1\u7968\u4e91\u63a5\u53e3\u65f6\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\uff1a%s\uff0c%s", url, params));
        String data = this.connect.doPost(url, params);
        if (data == null || StringUtils.isBlank((CharSequence)data)) {
            log.error(String.format("\u5bfc\u5165\u5931\u8d25\uff0c\u6839\u636e\u53d1\u7968\u5e8f\u5217\u53f7\u672a\u83b7\u53d6\u5230\u53d1\u7968\u8be6\u7ec6\u4fe1\u606f\u3002HTTP\u8bf7\u6c42\u53d1\u7968\u4e91\u8fd4\u56de\u6570\u636e\u4e3a\uff1a%s", data));
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u53d1\u7968\u8be6\u7ec6\u4fe1\u606f\u3002", (String)"InvoiceImportHelper_2", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        }
        JSONObject dataObject = JSONObject.fromObject((Object)data);
        JSONArray dataArray = dataObject.optJSONArray("data");
        if (dataArray == null || dataArray.isEmpty()) {
            log.error(String.format("\u5bfc\u5165\u5931\u8d25\uff0c\u6839\u636e\u53d1\u7968\u5e8f\u5217\u53f7\u672a\u83b7\u53d6\u5230\u53d1\u7968\u8be6\u7ec6\u4fe1\u606f\u3002HTTP\u8bf7\u6c42\u53d1\u7968\u4e91\u8fd4\u56de\u6570\u636edata\u4e3a\uff1a%s", data));
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u53d1\u7968\u8be6\u7ec6\u4fe1\u606f\u3002", (String)"InvoiceImportHelper_2", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        }
        log.info(String.format("\u6839\u636e\u53d1\u7968\u5e8f\u5217\u53f7\u83b7\u53d6\u5230\u53d1\u7968\u8be6\u7ec6\u4fe1\u606f\u5982\u4e0b\uff1a%s", data));
        try {
            dataList = this.parseInvoiceVO(data, invoiceInterface);
        }
        catch (InvoiceCloudException e) {
            log.error(String.format("\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968\u8be6\u60c5\u89e3\u6790\u5f02\u5e38\uff0c\u9519\u8bef\u65e5\u5fd7\u5982\u4e0b\uff1a%s", e.getMessage()));
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968\u8be6\u60c5\u89e3\u6790\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"InvoiceImportHelper_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        }
        return dataList;
    }

    private List<InvoiceVO> parseInvoiceVO(String apiReturnJson, String invoiceInterface) throws InvoiceCloudException {
        if (InvoiceInterfaceEnum.AWS.getValue().equals(invoiceInterface)) {
            InvoiceDetailReturnVO returnVO = InvoiceImportHelper.parseInvoiceDetailReturnVO(apiReturnJson);
            return returnVO.getData();
        }
        InvoiceCloudReturnVO returnVO = InvoiceImportHelper.parseInvoiceCloudReturnVO(apiReturnJson);
        return returnVO.getInvoiceData();
    }

    private static InvoiceDetailReturnVO parseInvoiceDetailReturnVO(String apiReturnJson) throws InvoiceCloudException {
        InvoiceDetailReturnVO invoiceDetailVO;
        try {
            ParserConfig config = new ParserConfig();
            log.info(String.format("\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968\u8be6\u60c5\u89e3\u6790\u6570\u636e\u5982\u4e0b(AWS)\uff1a%s", apiReturnJson));
            config.putDeserializer(Date.class, (ObjectDeserializer)InvoiceDateFormatDeserializer.getInstance());
            invoiceDetailVO = (InvoiceDetailReturnVO)JSON.parseObject((String)apiReturnJson, InvoiceDetailReturnVO.class, (ParserConfig)config, (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            log.error(String.format("\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968\u8be6\u60c5\u89e3\u6790\u5f02\u5e38\uff0c\u9519\u8bef\u65e5\u5fd7\u5982\u4e0b\uff1a%s", apiReturnJson));
            throw new InvoiceCloudException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968\u8be6\u60c5\u89e3\u6790\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"InvoiceImportHelper_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]), e);
        }
        return invoiceDetailVO;
    }

    private static InvoiceCloudReturnVO parseInvoiceCloudReturnVO(String apiReturnJson) throws InvoiceCloudException {
        InvoiceCloudReturnVO invoiceDetailVO;
        try {
            log.info(String.format("\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968\u8be6\u60c5\u89e3\u6790\u6570\u636e\u5982\u4e0b(CLOUD)\uff1a%s", apiReturnJson));
            ParserConfig config = new ParserConfig();
            config.putDeserializer(Date.class, (ObjectDeserializer)InvoiceDateFormatDeserializer.getInstance());
            invoiceDetailVO = (InvoiceCloudReturnVO)JSON.parseObject((String)apiReturnJson, InvoiceCloudReturnVO.class, (ParserConfig)config, (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            log.error(String.format("\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968\u8be6\u60c5\u89e3\u6790\u5f02\u5e38\uff0c\u9519\u8bef\u65e5\u5fd7\u5982\u4e0b\uff1a%s", apiReturnJson));
            throw new InvoiceCloudException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968\u8be6\u60c5\u89e3\u6790\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"InvoiceImportHelper_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]), e);
        }
        return invoiceDetailVO;
    }

    public List<InvoiceVO> checkInvoice(List<InvoiceVO> list, IFormView view) {
        Iterator<InvoiceVO> iterator = list.iterator();
        while (iterator.hasNext()) {
            QFilter invoiceStatusFilter;
            boolean exists;
            InvoiceVO invoice = iterator.next();
            QFilter invoiceFilter = new QFilter("invoiceno", "=", (Object)invoice.getInvoiceNo());
            String invoiceCode = invoice.getInvoiceCode();
            if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                invoiceFilter.and("invoicecode", "=", (Object)invoice.getInvoiceCode());
            }
            if (!(exists = QueryServiceHelper.exists((String)"pmct_ininvoice", (QFilter[])new QFilter[]{invoiceFilter, invoiceStatusFilter = new QFilter("invoicestatus", "!=", (Object)InvoiceStatusEnum.CANCEL_2.getValue())}))) continue;
            String errorTip = !StringUtils.isEmpty((CharSequence)invoiceCode) ? String.format(ResManager.loadKDStringExt((String)"\u53d1\u7968\u4ee3\u7801\u4e3a[%1$s],\u53d1\u7968\u53f7\u7801\u4e3a[%2$s]\u7684\u53d1\u7968\u5df2\u7ecf\u5728\u8fdb\u9879\u53d1\u7968\u6c60\u4e2d\u5b58\u5728\u3002", (String)"InvoiceImportHelper_3", (String)"pmgt-pmbs-business", (Object[])new Object[0]), invoice.getInvoiceCode(), invoice.getInvoiceNo()) : String.format(ResManager.loadKDStringExt((String)"\u53d1\u7968\u53f7\u7801\u4e3a[%1$s]\u7684\u53d1\u7968\u5df2\u7ecf\u5728\u8fdb\u9879\u53d1\u7968\u6c60\u4e2d\u5b58\u5728\u3002", (String)"InvoiceImportHelper_5", (String)"pmgt-pmbs-business", (Object[])new Object[0]), invoice.getInvoiceNo());
            view.showErrorNotification(errorTip);
            iterator.remove();
        }
        return list;
    }

    public DynamicObject[] syncIntoInvoicePool(List<InvoiceVO> list, String accountOrgId) {
        DynamicObject createOrg;
        if (list == null || list.isEmpty()) {
            return null;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getOrgId(), (String)"bos_org");
        DynamicObject accountOrg = BusinessDataServiceHelper.loadSingle((Object)accountOrgId, (String)"bos_org");
        long currentUserId = RequestContext.get().getCurrUserId();
        List userDepartment = UserServiceHelper.getUserDepartment((long)currentUserId, (boolean)false);
        if (userDepartment.contains(RequestContext.get().getOrgId())) {
            createOrg = org;
        } else {
            long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)currentUserId);
            createOrg = BusinessDataServiceHelper.loadSingle((Object)userMainOrgId, (String)"bos_org");
        }
        DynamicObject[] invoiceEntities = new DynamicObject[list.size()];
        QFilter numberFilter = new QFilter("number", "=", (Object)"CNY");
        DynamicObject currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"", (QFilter[])new QFilter[]{numberFilter});
        for (int i = 0; i < list.size(); ++i) {
            DynamicObjectType dt;
            InvoiceVO invoiceVo = list.get(i);
            DynamicObject invoice = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_ininvoice"));
            invoice.set("serialno", (Object)invoiceVo.getSerialNo());
            invoice.set("source", (Object)InvoiceSourceEnum.SOURCE_04.getValue());
            QFilter qFilter = new QFilter("number", "=", (Object)invoiceVo.getInvoiceType());
            DynamicObject invoiceType = BusinessDataServiceHelper.loadSingle((String)"bd_invoicetype", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (invoiceType != null) {
                invoice.set("invoicetypeid", (Object)invoiceType);
            }
            invoice.set("invoicecode", (Object)invoiceVo.getInvoiceCode());
            invoice.set("invoiceno", (Object)invoiceVo.getInvoiceNo());
            invoice.set("creator", (Object)RequestContext.get().getCurrUserId());
            invoice.set("invoicedate", (Object)invoiceVo.getInvoiceDate());
            invoice.set("receivedate", (Object)new Date());
            invoice.set("receiver", (Object)RequestContext.get().getCurrUserId());
            invoice.set("currency", (Object)currency);
            invoice.set("totaloftaxamount", (Object)invoiceVo.getTotalAmount());
            invoice.set("totaltax", (Object)invoiceVo.getTaxAmount());
            invoice.set("totalamount", (Object)invoiceVo.getAmount());
            invoice.set("availableamt", (Object)invoiceVo.getTotalAmount());
            invoice.set("totaluseamt", (Object)BigDecimal.ZERO);
            invoice.set("buyertaxno", (Object)invoiceVo.getBuyerTaxNo());
            invoice.set("buyerbank", (Object)TextHelper.getBankName((String)invoiceVo.getBuyerAccount()));
            invoice.set("buyeraccount", (Object)TextHelper.getBankNum((String)invoiceVo.getBuyerAccount()));
            invoice.set("buyerphone", (Object)TextHelper.getPhoneNum((String)invoiceVo.getBuyerAddressPhone()));
            invoice.set("buyeraddress", (Object)TextHelper.getAddress((String)invoiceVo.getBuyerAddressPhone()));
            QFilter buyerFilter = new QFilter("name", "=", (Object)invoiceVo.getBuyerName());
            DynamicObject buyer = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"", (QFilter[])new QFilter[]{buyerFilter});
            invoice.set("buyer", (Object)buyer);
            invoice.set("sellertaxno", (Object)invoiceVo.getSalerTaxNo());
            invoice.set("sellerbank", (Object)TextHelper.getBankName((String)invoiceVo.getSalerAccount()));
            invoice.set("selleraccount", (Object)TextHelper.getBankNum((String)invoiceVo.getSalerAccount()));
            invoice.set("sellerphone", (Object)TextHelper.getPhoneNum((String)invoiceVo.getSalerAddressPhone()));
            invoice.set("selleraddress", (Object)TextHelper.getAddress((String)invoiceVo.getSalerAddressPhone()));
            invoice.set("invoicestatus", (Object)invoiceVo.getInvoiceStatus());
            QFilter sellerFilter = new QFilter("tx_register_no", "=", (Object)invoiceVo.getSalerTaxNo());
            sellerFilter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObject seller = BusinessDataServiceHelper.loadSingle((String)"bd_bizpartner", (String)"", (QFilter[])new QFilter[]{sellerFilter});
            invoice.set("seller", (Object)seller);
            invoice.set("billstatus", (Object)StatusEnum.UNCHECKED.getValue());
            invoice.set("org", (Object)org);
            invoice.set("accountorg", (Object)accountOrg);
            invoice.set("createorg", (Object)createOrg);
            invoice.set("isclaimed", (Object)Boolean.FALSE);
            invoice.set("isused", (Object)Boolean.FALSE);
            String nowTime = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            SecureRandom secureRandom = new SecureRandom();
            String randomNum = String.format("%04d", secureRandom.nextInt(9999));
            boolean existCodeRule = CodeRuleServiceHelper.isExist((String)"pmct_ininvoice", (DynamicObject)invoice, (String)String.valueOf(RequestContext.get().getOrgId()));
            if (existCodeRule) {
                String number = CodeRuleServiceHelper.getNumber((String)"pmct_ininvoice", (DynamicObject)invoice, (String)String.valueOf(RequestContext.get().getOrgId()));
                invoice.set("billno", (Object)number);
            } else {
                invoice.set("billno", (Object)("Input_" + nowTime + "_" + randomNum));
            }
            List<InvoiceItemVO> detailEntries = invoiceVo.getItems();
            if (detailEntries != null && !detailEntries.isEmpty()) {
                DynamicObjectCollection invoiceEntries = invoice.getDynamicObjectCollection("entryentity");
                invoiceEntries.clear();
                dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_ininvoice")).getDynamicObjectCollection("entryentity").getDynamicObjectType();
                for (InvoiceItemVO item : detailEntries) {
                    QFilter validFilter;
                    QFilter unitFilter;
                    DynamicObject unit;
                    DynamicObject entry = new DynamicObject(dt);
                    entry.set("name", (Object)item.getGoodsName());
                    entry.set("model", (Object)item.getSpecModel());
                    String unitName = item.getUnit();
                    if (unitName != null && !unitName.isEmpty() && (unit = BusinessDataServiceHelper.loadSingle((String)"bd_measureunits", (String)"name", (QFilter[])new QFilter[]{unitFilter = new QFilter("name", "=", (Object)unitName).or("number", "=", (Object)unitName).or("number", "=", (Object)unitName.toLowerCase()).or("number", "=", (Object)unitName.toUpperCase()), validFilter = new QFilter("enable", "=", (Object)Character.valueOf(DefaultEnum.YES.getValue().charAt(0))).and("status", "=", (Object)Character.valueOf(StatusEnum.CHECKED.getValue().charAt(0)))})) != null) {
                        entry.set("unit", (Object)unit);
                    }
                    entry.set("qty", (Object)item.getNum());
                    BigDecimal price = item.getUnitPrice();
                    entry.set("price", (Object)item.getUnitPrice());
                    entry.set("amount", (Object)item.getDetailAmount());
                    BigDecimal ofTaxPrice = price;
                    BigDecimal tax = item.getTaxRate();
                    if (tax != null) {
                        BigDecimal taxRateHundred = tax.multiply(BigDecimal.TEN.multiply(BigDecimal.TEN));
                        QFilter taxFilter = new QFilter("taxrate", "=", (Object)taxRateHundred);
                        DynamicObject[] taxRate = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"name", (QFilter[])new QFilter[]{taxFilter});
                        if (taxRate != null && taxRate.length == 1) {
                            entry.set("taxrate", (Object)taxRate[0]);
                        }
                        entry.set("taxvalue", (Object)taxRateHundred);
                        if (price != null) {
                            ofTaxPrice = price.multiply(BigDecimal.ONE.add(tax));
                        }
                    }
                    entry.set("oftaxprice", (Object)ofTaxPrice);
                    entry.set("tax", (Object)item.getTaxAmount());
                    entry.set("oftaxamount", (Object)item.getDetailAmount().add(item.getTaxAmount() == null ? BigDecimal.ZERO : item.getTaxAmount()));
                    invoiceEntries.add((Object)entry);
                }
            }
            DynamicObjectCollection pictureEntries = invoice.getDynamicObjectCollection("pictureentry");
            dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_ininvoice")).getDynamicObjectCollection("pictureentry").getDynamicObjectType();
            DynamicObject item = new DynamicObject(dt);
            item.set("filename", (Object)invoiceVo.getInvoiceNo());
            if (StringUtils.isBlank((CharSequence)invoiceVo.getSnapshotUrl())) {
                ArrayList<String> invoices = new ArrayList<String>(1);
                invoices.add(invoiceVo.getSerialNo());
                Map invoiceMap = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"query", (Object[])new Object[]{invoices});
                if (invoiceMap != null) {
                    com.alibaba.fastjson.JSONArray invoiceData = (com.alibaba.fastjson.JSONArray)invoiceMap.get("data");
                    com.alibaba.fastjson.JSONObject invoiceInfo = invoiceData.getJSONObject(0);
                    item.set("imageurl", (Object)invoiceInfo.getString("snapshotUrl"));
                }
            } else {
                String realPath = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(invoiceVo.getSnapshotUrl());
                item.set("imageurl", (Object)realPath);
            }
            item.set("uploaddate", (Object)new Date());
            pictureEntries.add((Object)item);
            invoiceEntities[i] = invoice;
        }
        SaveServiceHelper.save((DynamicObject[])invoiceEntities);
        return invoiceEntities;
    }

    public void doAuditInvoice(DynamicObject[] invoices) {
        StringBuilder errors = new StringBuilder();
        OperationResult operationResultAudit = OperationServiceHelper.executeOperate((String)OperationEnum.AUDIT.getValue(), (String)"pmct_ininvoice", (DynamicObject[])invoices, (OperateOption)this.create(OperateOption.create()));
        if (!operationResultAudit.isSuccess()) {
            ValidateResultCollection validateResult = operationResultAudit.getValidateResult();
            List validateErrors = validateResult.getValidateErrors();
            for (ValidateResult errorInfo : validateErrors) {
                errorInfo.getAllErrorInfo().forEach(error -> errors.append(error.getMessage()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)errors.toString())) {
            List invoiceIds = Arrays.stream(invoices).map(o -> Long.parseLong(o.getPkValue().toString())).collect(Collectors.toList());
            DeleteServiceHelper.delete((String)"pmct_ininvoice", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
            throw new KDBizException(errors.toString());
        }
    }

    private OperateOption create(OperateOption option) {
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        return option;
    }
}

