/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ControlStrategyEnum;
import kd.pmgt.pmbs.common.enums.ControlTypeEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.common.utils.BudgetControlHelper;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;

public class ProBudgetControlHelper {
    private static final Log logger = LogFactory.getLog(ProBudgetControlHelper.class);

    public static void updateTotalBudgetCtrlData(DynamicObject totalBudgetBill) {
        DynamicObject project = totalBudgetBill.getDynamicObject("project");
        if (project != null) {
            DynamicObjectCollection treeEntryEntity;
            QFilter qFilter = new QFilter("tproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            String sourceType = StringUtils.equals((CharSequence)"IN", (CharSequence)totalBudgetBill.getString("sourcetype")) ? "IN" : "OUT";
            qFilter.and("tbudgettype", "=", (Object)sourceType);
            DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{qFilter});
            if (totalBudgetCtrl == null) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_totalbudgetctrl");
                totalBudgetCtrl = new DynamicObject((DynamicObjectType)dt);
            }
            totalBudgetCtrl.set("tproject", (Object)project);
            totalBudgetCtrl.set("tbudgettype", (Object)sourceType);
            totalBudgetCtrl.set("tcurrency", (Object)totalBudgetBill.getDynamicObject("currency"));
            totalBudgetCtrl.set("proappamt", (Object)totalBudgetBill.getBigDecimal("proapprovalamt"));
            totalBudgetCtrl.set("tbudgetamt", (Object)totalBudgetBill.getBigDecimal("totalamount"));
            totalBudgetCtrl.set("toricurrency", (Object)totalBudgetBill.getDynamicObject("currency"));
            totalBudgetCtrl.set("proapporiamt", (Object)totalBudgetBill.getBigDecimal("proapprovalamt"));
            totalBudgetCtrl.set("tbudgetoriamt", (Object)totalBudgetBill.getBigDecimal("totalamount"));
            Map<Long, BigDecimal> countMap = ProBudgetControlHelper.countYearAddUpAmt(project, sourceType);
            if (countMap.isEmpty()) {
                totalBudgetCtrl.set("tsumbudamt", (Object)totalBudgetBill.getBigDecimal("totalamount"));
                totalBudgetCtrl.set("tsumbudoriamt", (Object)totalBudgetBill.getBigDecimal("totalamount"));
            } else if (countMap.get(Long.parseLong(project.getPkValue().toString())) != null) {
                totalBudgetCtrl.set("tsumbudamt", (Object)countMap.get(Long.parseLong(project.getPkValue().toString())));
                totalBudgetCtrl.set("tsumbudoriamt", (Object)countMap.get(Long.parseLong(project.getPkValue().toString())));
            }
            if (!StringUtils.equals((CharSequence)"IN", (CharSequence)sourceType)) {
                Map<String, BigDecimal> budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(null, null, true, project);
                BigDecimal totalRemindRate = budgetParamMap.get("remindrate");
                BigDecimal totalControlRate = budgetParamMap.get("controlrate");
                totalBudgetCtrl.set("tremindrate", (Object)totalRemindRate);
                totalBudgetCtrl.set("tcontrolrate", (Object)totalControlRate);
            }
            if (!(treeEntryEntity = totalBudgetBill.getDynamicObjectCollection("treeentryentity")).isEmpty()) {
                Map controlRateMap = BudgetControlHelper.getControlRateMap((Long)project.getLong("id"));
                DynamicObjectCollection budgetCtrlDetails = totalBudgetCtrl.getDynamicObjectCollection("tbudgetctrldetail");
                DynamicObjectCollection budgetCtrlDetailClones = (DynamicObjectCollection)budgetCtrlDetails.clone();
                DynamicObjectType dt = budgetCtrlDetails.getDynamicObjectType();
                budgetCtrlDetails.clear();
                for (DynamicObject budgetEntryObj : treeEntryEntity) {
                    DynamicObject budgetCtrlDetail;
                    Object proBudgetItemObj = budgetEntryObj.get("projectbudgetitem");
                    if (proBudgetItemObj == null) continue;
                    DynamicObject projectBudgetItem = proBudgetItemObj instanceof DynamicObject ? budgetEntryObj.getDynamicObject("projectbudgetitem") : BusinessDataServiceHelper.loadSingle((Object)proBudgetItemObj, (String)"pmas_projectbudget");
                    long projectBudgetItemId = Long.parseLong(projectBudgetItem.getPkValue().toString());
                    if (budgetCtrlDetailClones.isEmpty()) {
                        budgetCtrlDetail = new DynamicObject(dt);
                    } else {
                        Optional<DynamicObject> first = budgetCtrlDetailClones.stream().filter(o -> o.getDynamicObject("budget") != null).filter(o -> Long.parseLong(o.getDynamicObject("budget").getPkValue().toString()) == projectBudgetItemId).findFirst();
                        budgetCtrlDetail = first.orElseGet(() -> new DynamicObject(dt));
                    }
                    budgetCtrlDetail.set("budget", (Object)projectBudgetItem);
                    budgetCtrlDetail.set("budgettype", (Object)sourceType);
                    budgetCtrlDetail.set("project", (Object)project);
                    budgetCtrlDetail.set("budgetitem", (Object)budgetEntryObj.getDynamicObject("budgetitem"));
                    budgetCtrlDetail.set("oricurrency", (Object)totalBudgetBill.getDynamicObject("currency"));
                    budgetCtrlDetail.set("budgetoriamt", (Object)budgetEntryObj.getBigDecimal("budgetamount"));
                    budgetCtrlDetail.set("currency", (Object)totalBudgetBill.getDynamicObject("currency"));
                    budgetCtrlDetail.set("budgetamt", (Object)budgetEntryObj.getBigDecimal("budgetamount"));
                    if (countMap.isEmpty()) {
                        budgetCtrlDetail.set("sumbudamt", (Object)budgetEntryObj.getBigDecimal("budgetamount"));
                        budgetCtrlDetail.set("sumbudoriamt", (Object)budgetEntryObj.getBigDecimal("budgetamount"));
                    } else if (countMap.get(projectBudgetItemId) != null) {
                        budgetCtrlDetail.set("sumbudamt", (Object)countMap.get(projectBudgetItemId));
                        budgetCtrlDetail.set("sumbudoriamt", (Object)countMap.get(projectBudgetItemId));
                    }
                    if (!StringUtils.equals((CharSequence)"IN", (CharSequence)sourceType)) {
                        Map<String, BigDecimal> budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(controlRateMap, projectBudgetItem, false, project);
                        BigDecimal remindRate = budgetParamMap.get("remindrate");
                        budgetCtrlDetail.set("remindrate", (Object)remindRate);
                        BigDecimal controlRate = budgetParamMap.get("controlrate");
                        budgetCtrlDetail.set("controlrate", (Object)controlRate);
                    }
                    budgetCtrlDetails.add((Object)budgetCtrlDetail);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrl});
        }
    }

    public static void updateYearBudgetCtrlData(DynamicObject yearBudgetBill) {
        DynamicObject project = yearBudgetBill.getDynamicObject("project");
        if (project != null) {
            DynamicObjectCollection treeEntryEntity;
            QFilter qFilter = new QFilter("yproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            String sourceType = StringUtils.equals((CharSequence)"IN", (CharSequence)yearBudgetBill.getString("sourcetype")) ? "IN" : "OUT";
            qFilter.and("ybudgettype", "=", (Object)sourceType);
            qFilter.and("yyear", "=", (Object)yearBudgetBill.getDate("year"));
            DynamicObject yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{qFilter});
            if (yearBudgetCtrl == null) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_ybudgetctrl");
                yearBudgetCtrl = new DynamicObject((DynamicObjectType)dt);
            }
            yearBudgetCtrl.set("ybudgettype", (Object)sourceType);
            yearBudgetCtrl.set("yproject", (Object)project);
            yearBudgetCtrl.set("yyear", (Object)yearBudgetBill.getDate("year"));
            yearBudgetCtrl.set("yoricurrency", (Object)yearBudgetBill.getDynamicObject("currency"));
            yearBudgetCtrl.set("yearprooriamt", (Object)yearBudgetBill.getBigDecimal("totalyearamt"));
            yearBudgetCtrl.set("ybudgetoriamt", (Object)yearBudgetBill.getBigDecimal("totalamount"));
            yearBudgetCtrl.set("ycurrency", (Object)yearBudgetBill.getDynamicObject("currency"));
            yearBudgetCtrl.set("yearproamt", (Object)yearBudgetBill.getBigDecimal("totalyearamt"));
            yearBudgetCtrl.set("ybudgetamt", (Object)yearBudgetBill.getBigDecimal("totalamount"));
            if (!StringUtils.equals((CharSequence)"IN", (CharSequence)sourceType)) {
                Map<String, BigDecimal> budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(null, null, true, project);
                BigDecimal remindRate = budgetParamMap.get("remindrate");
                BigDecimal controlRate = budgetParamMap.get("controlrate");
                yearBudgetCtrl.set("yremindrate", (Object)remindRate);
                yearBudgetCtrl.set("ycontrolrate", (Object)controlRate);
            }
            if (!(treeEntryEntity = yearBudgetBill.getDynamicObjectCollection("treeentryentity")).isEmpty()) {
                Map controlRateMap = BudgetControlHelper.getControlRateMap((Long)project.getLong("id"));
                DynamicObjectCollection budgetCtrlDetails = yearBudgetCtrl.getDynamicObjectCollection("ybudgetctrldetail");
                DynamicObjectCollection budgetCtrlDetailClones = (DynamicObjectCollection)budgetCtrlDetails.clone();
                DynamicObjectType dt = budgetCtrlDetails.getDynamicObjectType();
                budgetCtrlDetails.clear();
                for (DynamicObject budgetEntryObj : treeEntryEntity) {
                    DynamicObject budgetCtrlDetail;
                    Object proBudgetItemObj = budgetEntryObj.get("projectbudgetitem");
                    if (proBudgetItemObj == null) continue;
                    DynamicObject projectBudgetItem = proBudgetItemObj instanceof DynamicObject ? budgetEntryObj.getDynamicObject("projectbudgetitem") : BusinessDataServiceHelper.loadSingle((Object)proBudgetItemObj, (String)"pmas_projectbudget");
                    long projectBudgetItemId = Long.parseLong(projectBudgetItem.getPkValue().toString());
                    if (budgetCtrlDetailClones.isEmpty()) {
                        budgetCtrlDetail = new DynamicObject(dt);
                    } else {
                        Optional<DynamicObject> first = budgetCtrlDetailClones.stream().filter(o -> o.getDynamicObject("budget") != null).filter(o -> Long.parseLong(o.getDynamicObject("budget").getPkValue().toString()) == projectBudgetItemId).findFirst();
                        budgetCtrlDetail = first.orElseGet(() -> new DynamicObject(dt));
                    }
                    budgetCtrlDetail.set("budget", (Object)projectBudgetItem);
                    budgetCtrlDetail.set("budgettype", (Object)sourceType);
                    budgetCtrlDetail.set("project", (Object)project);
                    budgetCtrlDetail.set("budgetitem", (Object)budgetEntryObj.getDynamicObject("budgetitem"));
                    budgetCtrlDetail.set("year", (Object)yearBudgetBill.getDate("year"));
                    budgetCtrlDetail.set("oricurrency", (Object)yearBudgetBill.getDynamicObject("currency"));
                    budgetCtrlDetail.set("budgetoriamt", (Object)budgetEntryObj.getBigDecimal("budgetamount"));
                    budgetCtrlDetail.set("currency", (Object)yearBudgetBill.getDynamicObject("currency"));
                    budgetCtrlDetail.set("budgetamt", (Object)budgetEntryObj.getBigDecimal("budgetamount"));
                    if (!StringUtils.equals((CharSequence)"IN", (CharSequence)sourceType)) {
                        Map<String, BigDecimal> budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(controlRateMap, projectBudgetItem, false, project);
                        BigDecimal remindRate = budgetParamMap.get("remindrate");
                        budgetCtrlDetail.set("remindrate", (Object)remindRate);
                        BigDecimal controlRate = budgetParamMap.get("controlrate");
                        budgetCtrlDetail.set("controlrate", (Object)controlRate);
                    }
                    budgetCtrlDetails.add((Object)budgetCtrlDetail);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yearBudgetCtrl});
        }
    }

    public static void updateYearBudgetCtrlByTotalBudget(DynamicObject totalBudgetBill) {
        DynamicObject project = totalBudgetBill.getDynamicObject("project");
        if (project != null) {
            String sourceType = StringUtils.equals((CharSequence)"IN", (CharSequence)totalBudgetBill.getString("sourcetype")) ? "IN" : "OUT";
            DynamicObject lastYearBudgetBill = ProBudgetControlHelper.checkExistValidYearBudget(Long.parseLong(project.getPkValue().toString()), sourceType, null);
            if (lastYearBudgetBill != null) {
                return;
            }
            QFilter qFilter = new QFilter("yproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            qFilter.and("ybudgettype", "=", (Object)sourceType);
            DynamicObject yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{qFilter});
            if (yearBudgetCtrl == null) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_ybudgetctrl");
                yearBudgetCtrl = new DynamicObject((DynamicObjectType)dt);
            }
            yearBudgetCtrl.set("yproject", (Object)project);
            yearBudgetCtrl.set("ybudgettype", (Object)sourceType);
            Date applyDate = totalBudgetBill.getDate("projectapplydate");
            if (applyDate != null) {
                LocalDate localDate = applyDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    yearBudgetCtrl.set("yyear", (Object)sdf.parse(localDate.getYear() + "-01-01"));
                }
                catch (ParseException e) {
                    logger.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a{}", (Object)e.getMessage());
                }
            }
            DynamicObject currency = totalBudgetBill.getDynamicObject("currency");
            yearBudgetCtrl.set("yoricurrency", (Object)currency);
            yearBudgetCtrl.set("ycurrency", (Object)currency);
            qFilter = new QFilter("pro", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            DynamicObject proApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{qFilter});
            BigDecimal proAppYearAmt = proApproval.getBigDecimal("proyearbudgetamt");
            if (proAppYearAmt.compareTo(BigDecimal.ZERO) == 0) {
                proAppYearAmt = totalBudgetBill.getBigDecimal("totalamount");
            }
            yearBudgetCtrl.set("yearproamt", (Object)proAppYearAmt);
            yearBudgetCtrl.set("yearprooriamt", (Object)proAppYearAmt);
            yearBudgetCtrl.set("ybudgetamt", (Object)totalBudgetBill.getBigDecimal("totalamount"));
            yearBudgetCtrl.set("ybudgetoriamt", (Object)totalBudgetBill.getBigDecimal("totalamount"));
            if (!StringUtils.equals((CharSequence)"IN", (CharSequence)sourceType)) {
                Map<String, BigDecimal> budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(null, null, true, project);
                BigDecimal yearRemindRate = budgetParamMap.get("remindrate");
                BigDecimal yearControlRate = budgetParamMap.get("controlrate");
                yearBudgetCtrl.set("yremindrate", (Object)yearRemindRate);
                yearBudgetCtrl.set("ycontrolrate", (Object)yearControlRate);
            }
            DynamicObjectCollection treeEntryEntity = totalBudgetBill.getDynamicObjectCollection("treeentryentity");
            Map controlRateMap = BudgetControlHelper.getControlRateMap((Long)project.getLong("id"));
            DynamicObjectCollection budgetCtrlDetails = yearBudgetCtrl.getDynamicObjectCollection("ybudgetctrldetail");
            DynamicObjectCollection budgetCtrlDetailClones = (DynamicObjectCollection)budgetCtrlDetails.clone();
            DynamicObjectType entryDt = budgetCtrlDetails.getDynamicObjectType();
            budgetCtrlDetails.clear();
            for (DynamicObject entry : treeEntryEntity) {
                DynamicObject budgetCtrlDetail;
                Object proBudgetItemObj = entry.get("projectbudgetitem");
                if (proBudgetItemObj == null) continue;
                DynamicObject projectBudgetItem = proBudgetItemObj instanceof DynamicObject ? entry.getDynamicObject("projectbudgetitem") : BusinessDataServiceHelper.loadSingle((Object)proBudgetItemObj, (String)"pmas_projectbudget");
                if (budgetCtrlDetailClones.isEmpty()) {
                    budgetCtrlDetail = new DynamicObject(entryDt);
                } else {
                    long proBudgetItemId = Long.parseLong(projectBudgetItem.getPkValue().toString());
                    Optional<DynamicObject> first = budgetCtrlDetailClones.stream().filter(o -> o.getDynamicObject("budget") != null).filter(o -> Long.parseLong(o.getDynamicObject("budget").getPkValue().toString()) == proBudgetItemId).findFirst();
                    budgetCtrlDetail = first.orElseGet(() -> new DynamicObject(entryDt));
                }
                budgetCtrlDetail.set("budget", (Object)projectBudgetItem);
                budgetCtrlDetail.set("project", (Object)project);
                budgetCtrlDetail.set("budgettype", (Object)sourceType);
                budgetCtrlDetail.set("budgetitem", (Object)entry.getDynamicObject("budgetitem"));
                budgetCtrlDetail.set("year", (Object)yearBudgetCtrl.getDate("yyear"));
                budgetCtrlDetail.set("currency", (Object)currency);
                budgetCtrlDetail.set("oricurrency", (Object)currency);
                budgetCtrlDetail.set("budgetamt", (Object)entry.getBigDecimal("budgetamount"));
                budgetCtrlDetail.set("budgetoriamt", (Object)entry.getBigDecimal("budgetamount"));
                if (!StringUtils.equals((CharSequence)"IN", (CharSequence)sourceType)) {
                    Map<String, BigDecimal> budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(controlRateMap, projectBudgetItem, false, project);
                    BigDecimal remindRate = budgetParamMap.get("remindrate");
                    budgetCtrlDetail.set("remindrate", (Object)remindRate);
                    BigDecimal controlRate = budgetParamMap.get("controlrate");
                    budgetCtrlDetail.set("controlrate", (Object)controlRate);
                }
                budgetCtrlDetails.add((Object)budgetCtrlDetail);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yearBudgetCtrl});
        }
    }

    public static void updateTotalBudgetCtrlByYearBudget(DynamicObject yearBudgetBill) {
        DynamicObject project = yearBudgetBill.getDynamicObject("project");
        if (project != null) {
            BigDecimal budgetAmt;
            DynamicObject proApproval;
            BigDecimal sumBudgetAmt;
            String sourceType = StringUtils.equals((CharSequence)"IN", (CharSequence)yearBudgetBill.getString("sourcetype")) ? "IN" : "OUT";
            DynamicObject lastYearBudgetBill = ProBudgetControlHelper.checkExistValidYearBudget(Long.parseLong(project.getPkValue().toString()), sourceType, yearBudgetBill.getPkValue());
            QFilter qFilter = new QFilter("tproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            qFilter.and("tbudgettype", "=", (Object)sourceType);
            DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{qFilter});
            if (totalBudgetCtrl == null) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_totalbudgetctrl");
                totalBudgetCtrl = new DynamicObject((DynamicObjectType)dt);
                sumBudgetAmt = yearBudgetBill.getBigDecimal("totalamount");
            } else {
                String type;
                sumBudgetAmt = totalBudgetCtrl.getBigDecimal("tsumbudamt");
                sumBudgetAmt = sumBudgetAmt.compareTo(BigDecimal.ZERO) == 0 ? yearBudgetBill.getBigDecimal("totalamount") : (lastYearBudgetBill != null ? ("NEW".equals(type = yearBudgetBill.getString("type")) ? sumBudgetAmt.add(yearBudgetBill.getBigDecimal("schangeamount")) : sumBudgetAmt.add(yearBudgetBill.getBigDecimal("vchangeamount"))) : yearBudgetBill.getBigDecimal("totalamount"));
            }
            totalBudgetCtrl.set("tsumbudamt", (Object)sumBudgetAmt);
            totalBudgetCtrl.set("tsumbudoriamt", (Object)sumBudgetAmt);
            DynamicObject currency = yearBudgetBill.getDynamicObject("currency");
            totalBudgetCtrl.set("toricurrency", (Object)currency);
            totalBudgetCtrl.set("tcurrency", (Object)currency);
            BigDecimal proAppAmt = totalBudgetCtrl.getBigDecimal("proappamt");
            if (proAppAmt.compareTo(BigDecimal.ZERO) == 0 && (proAppAmt = (proApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{qFilter = new QFilter("pro", "=", (Object)Long.parseLong(project.getPkValue().toString()))})).getBigDecimal("projcetbugamt")).compareTo(sumBudgetAmt) < 0) {
                proAppAmt = sumBudgetAmt;
            }
            totalBudgetCtrl.set("proappamt", (Object)proAppAmt);
            totalBudgetCtrl.set("proapporiamt", (Object)proAppAmt);
            totalBudgetCtrl.set("tproject", (Object)project);
            totalBudgetCtrl.set("tbudgettype", (Object)sourceType);
            DynamicObjectCollection treeEntryEntity = yearBudgetBill.getDynamicObjectCollection("treeentryentity");
            BigDecimal itemTotalAmt = BigDecimal.ZERO;
            if (!treeEntryEntity.isEmpty()) {
                Map controlRateMap = BudgetControlHelper.getControlRateMap((Long)project.getLong("id"));
                DynamicObjectCollection budgetCtrlDetails = totalBudgetCtrl.getDynamicObjectCollection("tbudgetctrldetail");
                DynamicObjectCollection budgetCtrlDetailClones = (DynamicObjectCollection)budgetCtrlDetails.clone();
                DynamicObjectType dt = budgetCtrlDetails.getDynamicObjectType();
                budgetCtrlDetails.clear();
                for (DynamicObject budgetEntryObj : treeEntryEntity) {
                    long pid;
                    BigDecimal sumYearBudAmt;
                    DynamicObject budgetCtrlDetail;
                    Object proBudgetItemObj = budgetEntryObj.get("projectbudgetitem");
                    if (proBudgetItemObj == null) continue;
                    DynamicObject projectBudgetItem = proBudgetItemObj instanceof DynamicObject ? budgetEntryObj.getDynamicObject("projectbudgetitem") : BusinessDataServiceHelper.loadSingle((Object)proBudgetItemObj, (String)"pmas_projectbudget");
                    long projectBudgetItemId = Long.parseLong(projectBudgetItem.getPkValue().toString());
                    if (budgetCtrlDetailClones.isEmpty()) {
                        budgetCtrlDetail = new DynamicObject(dt);
                        sumYearBudAmt = budgetEntryObj.getBigDecimal("budgetamount");
                    } else {
                        String type;
                        Optional<DynamicObject> first = budgetCtrlDetailClones.stream().filter(o -> o.getDynamicObject("budget") != null).filter(o -> Long.parseLong(o.getDynamicObject("budget").getPkValue().toString()) == projectBudgetItemId).findFirst();
                        budgetCtrlDetail = first.orElseGet(() -> new DynamicObject(dt));
                        sumYearBudAmt = budgetCtrlDetail.getBigDecimal("sumbudamt");
                        sumYearBudAmt = sumYearBudAmt.compareTo(BigDecimal.ZERO) == 0 ? budgetEntryObj.getBigDecimal("budgetamount") : (lastYearBudgetBill != null ? ("NEW".equals(type = yearBudgetBill.getString("type")) ? sumYearBudAmt.add(budgetEntryObj.getBigDecimal("sichangeamount")) : sumYearBudAmt.add(budgetEntryObj.getBigDecimal("vichangeamount"))) : budgetEntryObj.getBigDecimal("budgetamount"));
                    }
                    budgetCtrlDetail.set("sumbudamt", (Object)sumYearBudAmt);
                    budgetCtrlDetail.set("sumbudoriamt", (Object)sumYearBudAmt);
                    budgetCtrlDetail.set("budget", (Object)projectBudgetItem);
                    budgetCtrlDetail.set("budgettype", (Object)sourceType);
                    budgetCtrlDetail.set("project", (Object)project);
                    budgetCtrlDetail.set("budgetitem", (Object)budgetEntryObj.getDynamicObject("budgetitem"));
                    budgetCtrlDetail.set("oricurrency", (Object)yearBudgetBill.getDynamicObject("currency"));
                    budgetCtrlDetail.set("currency", (Object)yearBudgetBill.getDynamicObject("currency"));
                    BigDecimal budgetItemAmt = budgetCtrlDetail.getBigDecimal("budgetamt");
                    BigDecimal totalAmount = budgetEntryObj.getBigDecimal("itemtotalamount");
                    if (budgetItemAmt.compareTo(BigDecimal.ZERO) == 0) {
                        budgetCtrlDetail.set("budgetoriamt", (Object)totalAmount);
                        budgetCtrlDetail.set("budgetamt", (Object)totalAmount);
                    }
                    if ((pid = budgetEntryObj.getLong("pid")) == 0L) {
                        itemTotalAmt = itemTotalAmt.add(totalAmount);
                    }
                    if (!StringUtils.equals((CharSequence)"IN", (CharSequence)sourceType)) {
                        Map<String, BigDecimal> budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(controlRateMap, projectBudgetItem, false, project);
                        BigDecimal remindRate = budgetParamMap.get("remindrate");
                        budgetCtrlDetail.set("remindrate", (Object)remindRate);
                        BigDecimal controlRate = budgetParamMap.get("controlrate");
                        budgetCtrlDetail.set("controlrate", (Object)controlRate);
                    }
                    budgetCtrlDetails.add((Object)budgetCtrlDetail);
                }
            } else {
                itemTotalAmt = sumBudgetAmt;
            }
            if ((budgetAmt = totalBudgetCtrl.getBigDecimal("tbudgetamt")).compareTo(BigDecimal.ZERO) == 0) {
                totalBudgetCtrl.set("tbudgetamt", (Object)itemTotalAmt);
                totalBudgetCtrl.set("tbudgetoriamt", (Object)itemTotalAmt);
            }
            if (!StringUtils.equals((CharSequence)"IN", (CharSequence)sourceType)) {
                Map<String, BigDecimal> budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(null, null, true, project);
                BigDecimal totalRemindRate = budgetParamMap.get("remindrate");
                BigDecimal totalControlRate = budgetParamMap.get("controlrate");
                totalBudgetCtrl.set("tremindrate", (Object)totalRemindRate);
                totalBudgetCtrl.set("tcontrolrate", (Object)totalControlRate);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrl});
        }
    }

    public static Map<String, BigDecimal> getProjectBudgetControlRate(Map<String, Map<String, DynamicObject>> controlRateMap, DynamicObject projectBudget, boolean proCtrl, DynamicObject project) {
        HashMap<String, BigDecimal> budgetParamMap = new HashMap<String, BigDecimal>();
        BigDecimal remindRate = BigDecimal.valueOf(100L);
        BigDecimal controlRate = BigDecimal.valueOf(100L);
        if (proCtrl) {
            DynamicObject budgetControlRatio = ProBudgetControlHelper.getBudgetControlRatio(project);
            if (budgetControlRatio != null) {
                remindRate = budgetControlRatio.getBigDecimal("totalremindrate");
                controlRate = budgetControlRatio.getBigDecimal("totalcontrolrate");
            }
        } else if (controlRateMap != null && projectBudget != null) {
            DynamicObject budgetParam;
            Map<String, DynamicObject> projectBudgetMap = controlRateMap.get("proBudgetItemMap");
            Map<String, DynamicObject> standardBudgetMap = controlRateMap.get("budgetItemMap");
            DynamicObject standardBudget = projectBudget.getDynamicObject("budgetitem");
            DynamicObject dynamicObject = budgetParam = projectBudgetMap == null ? null : projectBudgetMap.get(projectBudget.getString("id"));
            if (budgetParam == null && standardBudget != null && standardBudgetMap != null && standardBudgetMap.get(standardBudget.getPkValue().toString()) != null) {
                budgetParam = standardBudgetMap.get(standardBudget.getPkValue().toString());
            }
            if (budgetParam != null && !StringUtils.equals((CharSequence)projectBudget.getString("sourcetype"), (CharSequence)BudgetSourceTypeEnum.IN.getValue())) {
                remindRate = budgetParam.getBigDecimal("remindrate");
                controlRate = budgetParam.getBigDecimal("controlrate");
            }
        }
        budgetParamMap.put("remindrate", remindRate);
        budgetParamMap.put("controlrate", controlRate);
        return budgetParamMap;
    }

    public static DynamicObject getBudgetControlRatio(DynamicObject project) {
        QFilter statusFilter = new QFilter("enable", "=", (Object)true);
        QFilter controlTypeFilter = new QFilter("controltype", "=", (Object)ControlTypeEnum.PROJECT.getValue());
        QFilter projectFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        DynamicObject budgetControlRatio = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetcontrol", (QFilter[])new QFilter[]{statusFilter, controlTypeFilter, projectFilter});
        if (budgetControlRatio == null) {
            project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(project.getDynamicObject("useorg").getPkValue().toString()));
            controlTypeFilter = new QFilter("controltype", "=", (Object)ControlTypeEnum.ORG.getValue());
            QFilter controlStrategyFilter = new QFilter("controlstrategy", "in", (Object)new String[]{ControlStrategyEnum.SELF.getValue(), ControlStrategyEnum.SELFANDSUB.getValue()});
            budgetControlRatio = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetcontrol", (QFilter[])new QFilter[]{statusFilter, controlTypeFilter, orgFilter, controlStrategyFilter});
            if (budgetControlRatio == null) {
                List parentOrgList = OrgTreeUtils.getParentByOrgId((Long)Long.parseLong(project.getDynamicObject("useorg").getPkValue().toString()), (String)"15");
                orgFilter = new QFilter("org", "in", (Object)parentOrgList);
                controlStrategyFilter = new QFilter("controlstrategy", "=", (Object)ControlStrategyEnum.SELFANDSUB.getValue());
                DynamicObject[] budgetCtlList = BusinessDataServiceHelper.load((String)"pmco_budgetcontrol", (String)"org,totalremindrate,totalcontrolrate", (QFilter[])new QFilter[]{statusFilter, controlTypeFilter, orgFilter, controlStrategyFilter});
                if (budgetCtlList.length > 0) {
                    for (Long org : parentOrgList) {
                        Optional<DynamicObject> optional = Arrays.stream(budgetCtlList).filter(dyn -> dyn.getDynamicObject("org").getLong("id") == org.longValue()).findFirst();
                        if (!optional.isPresent()) continue;
                        budgetControlRatio = optional.get();
                        break;
                    }
                }
            }
        }
        return budgetControlRatio;
    }

    public static Map<Long, BigDecimal> countYearAddUpAmt(DynamicObject project, String sourceType) {
        HashMap<Long, BigDecimal> countMap = new HashMap<Long, BigDecimal>();
        if (project != null) {
            QFilter qFilter = new QFilter("yproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            qFilter.and("ybudgettype", "=", (Object)sourceType);
            DynamicObject[] yearBudgetControls = BusinessDataServiceHelper.load((String)"pmas_ybudgetctrl", (String)String.join((CharSequence)",", "ybudgetamt", "budgetamt", "budget"), (QFilter[])new QFilter[]{qFilter});
            BigDecimal sumBudgetAmt = BigDecimal.ZERO;
            if (yearBudgetControls.length > 0) {
                for (DynamicObject yearBudgetControl : yearBudgetControls) {
                    sumBudgetAmt = sumBudgetAmt.add(yearBudgetControl.getBigDecimal("ybudgetamt"));
                    DynamicObjectCollection details = yearBudgetControl.getDynamicObjectCollection("ybudgetctrldetail");
                    for (DynamicObject detail : details) {
                        DynamicObject proBudget = detail.getDynamicObject("budget");
                        if (proBudget == null) continue;
                        long proBudgetId = Long.parseLong(proBudget.getPkValue().toString());
                        BigDecimal budgetAmt = detail.getBigDecimal("budgetamt");
                        BigDecimal sumBudgetItemAmt = countMap.get(proBudgetId) == null ? BigDecimal.ZERO : (BigDecimal)countMap.get(proBudgetId);
                        countMap.put(proBudgetId, sumBudgetItemAmt.add(budgetAmt));
                    }
                }
                countMap.put(Long.parseLong(project.getPkValue().toString()), sumBudgetAmt);
            }
        }
        return countMap;
    }

    public static DynamicObject checkExistValidYearBudget(Long projectId, String sourceType, Object curBillId) {
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        qFilter.and("sourcetype", "=", (Object)sourceType);
        qFilter.and("isvalid", "=", (Object)DefaultEnum.YES.getValue());
        if (curBillId != null) {
            qFilter.and("id", "!=", (Object)Long.parseLong(curBillId.toString()));
        }
        return BusinessDataServiceHelper.loadSingle((String)"pmas_outbudget", (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean checkIsNewProBudgetCtrl(Long projectId) {
        boolean isNew = false;
        QFilter totalQFilter = new QFilter("tproject", "=", (Object)projectId);
        QFilter yearQFilter = new QFilter("yproject", "=", (Object)projectId);
        boolean isTotal = QueryServiceHelper.exists((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{totalQFilter});
        boolean isYear = QueryServiceHelper.exists((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{yearQFilter});
        if (isTotal || isYear) {
            isNew = true;
        }
        return isNew;
    }

    public static boolean checkBudgetItemIsUsage(DynamicObject proBudget) {
        QFilter qFilter;
        DynamicObject tBudgetCtrlDetail;
        if (proBudget != null && (tBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{qFilter = new QFilter("budget", "=", (Object)Long.parseLong(proBudget.getPkValue().toString()))})) != null) {
            BigDecimal budgetAmt = tBudgetCtrlDetail.getBigDecimal("budgetamt");
            BigDecimal preOccupyAmt = tBudgetCtrlDetail.getBigDecimal("preoccupyamt");
            BigDecimal occupyAmt = tBudgetCtrlDetail.getBigDecimal("occupyamt");
            BigDecimal balanceAmt = budgetAmt.subtract(preOccupyAmt).subtract(occupyAmt);
            return budgetAmt.compareTo(balanceAmt) != 0;
        }
        return false;
    }

    public static void dealCtrlDetailToTree(DynamicObjectCollection budgetDetails, Long projectId, String sourceType) {
        QFilter qFilter = new QFilter("tproject", "=", (Object)projectId);
        qFilter.and("tbudgettype", "=", (Object)sourceType);
        DynamicObject totalCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{qFilter});
        if (totalCtrl == null) {
            return;
        }
        DynamicObjectCollection budgetCtrlDetails = totalCtrl.getDynamicObjectCollection("tbudgetctrldetail");
        if (budgetCtrlDetails.isEmpty()) {
            return;
        }
        DynamicObjectType dt = budgetDetails.getDynamicObjectType();
        HashMap<Object, Long> detailNewPk = new HashMap<Object, Long>(16);
        HashMap<Object, DynamicObject> proBudgetMap = new HashMap<Object, DynamicObject>(16);
        Set proBudgetIds = budgetCtrlDetails.stream().filter(o -> o.getDynamicObject("budget") != null).map(o -> o.getDynamicObject("budget").getPkValue()).collect(Collectors.toSet());
        if (proBudgetIds.size() > 0) {
            DynamicObject[] projectBudgets;
            ORM orm = ORM.create();
            long[] newIds = orm.genLongIds((IDataEntityType)dt, proBudgetIds.size());
            int index = 0;
            for (DynamicObject projectBudget : projectBudgets = BusinessDataServiceHelper.load((Object[])proBudgetIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projectbudget"))) {
                proBudgetMap.put(projectBudget.getPkValue(), projectBudget);
                detailNewPk.put(projectBudget.getPkValue(), newIds[index++]);
            }
        }
        for (DynamicObject budgetCtrlDetail : budgetCtrlDetails) {
            DynamicObject proBudget = budgetCtrlDetail.getDynamicObject("budget");
            if (proBudget == null) continue;
            DynamicObject detail = new DynamicObject(dt);
            proBudget = (DynamicObject)proBudgetMap.get(proBudget.getPkValue());
            detail.set("budgetitemname", (Object)proBudget.getString("name"));
            detail.set("budgetitemnum", (Object)proBudget.getString("number"));
            detail.set("projectbudgetitem", (Object)proBudget);
            detail.set("budgetitem", (Object)proBudget.getDynamicObject("budgetitem"));
            detail.set("itemtotalamount", (Object)budgetCtrlDetail.getBigDecimal("budgetamt"));
            detail.set("istotal", (Object)true);
            Long pid = proBudget.getLong("parent");
            Long newPid = 0L;
            if (!pid.equals(0L)) {
                newPid = (Long)detailNewPk.get(pid);
            }
            detail.set("pid", (Object)newPid);
            detail.set("id", detailNewPk.get(proBudget.getPkValue()));
            budgetDetails.add((Object)detail);
        }
    }

    public static void synCtrlDetailToBill(DynamicObjectCollection budgetDetails, DynamicObjectCollection lastBudgetDetails, boolean isAdjust) {
        if (lastBudgetDetails.isEmpty()) {
            return;
        }
        for (DynamicObject budgetDetail : budgetDetails) {
            DynamicObject proBudget = budgetDetail.getDynamicObject("projectbudgetitem");
            if (proBudget == null) continue;
            long proBudgetId = Long.parseLong(proBudget.getPkValue().toString());
            Optional<DynamicObject> first = lastBudgetDetails.stream().filter(o -> o.getDynamicObject("projectbudgetitem") != null).filter(o -> Long.parseLong(o.getDynamicObject("projectbudgetitem").getPkValue().toString()) == proBudgetId).findFirst();
            if (!first.isPresent()) continue;
            DynamicObject lastDetail = first.get();
            if (isAdjust) {
                budgetDetail.set("viamount", (Object)lastDetail.getBigDecimal("budgetamount"));
                budgetDetail.set("isprev", (Object)Boolean.TRUE);
                budgetDetail.set("budgetamount", (Object)lastDetail.getBigDecimal("budgetamount"));
                BigDecimal siAmount = lastDetail.getBigDecimal("siamount");
                if (BigDecimal.ZERO.compareTo(siAmount) == 0) continue;
                budgetDetail.set("siamount", (Object)siAmount);
                budgetDetail.set("ispres", (Object)Boolean.TRUE);
                continue;
            }
            BigDecimal budgetAmt = lastDetail.getBigDecimal("budgetamount");
            budgetDetail.set("siamount", (Object)budgetAmt);
            budgetDetail.set("budgetamount", (Object)budgetAmt);
            budgetDetail.set("ispres", (Object)(BigDecimal.ZERO.compareTo(budgetAmt) != 0 ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    public static ProBudgetCtrlEnums getProjectBudgetControlType(DynamicObject project) {
        QFilter proKindQFilter;
        DynamicObject projectKindSetting;
        Object group;
        ProBudgetCtrlEnums proBudgetCtrl = ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET;
        QFilter projectFilter = new QFilter("pro", "=", project.getPkValue());
        DynamicObject approval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"probudgetctrl", (QFilter[])new QFilter[]{projectFilter});
        if (approval != null) {
            proBudgetCtrl = ProBudgetCtrlEnums.getEnumByValue((Object)approval.getString("probudgetctrl"));
        } else if ((project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project")) != null && project.getDynamicObject("group") != null && (group = project.getDynamicObject("group").getPkValue()) != null && StringUtils.isNotEmpty((CharSequence)group.toString()) && (projectKindSetting = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (QFilter[])new QFilter[]{proKindQFilter = new QFilter("projectkind", "=", (Object)Long.parseLong(group.toString()))})) != null) {
            proBudgetCtrl = ProBudgetCtrlEnums.getEnumByValue((Object)projectKindSetting.getString("probudgetctrl"));
        }
        if (proBudgetCtrl == null) {
            proBudgetCtrl = ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET;
        }
        return proBudgetCtrl;
    }

    public static boolean checkIsProCostControl(DynamicObject project) {
        boolean projectCostControlFlag = false;
        if (project != null) {
            QFilter qFilter;
            DynamicObject projectKindSetting;
            Object group;
            DynamicObject[] proApp = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"projectcostcontrol", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            if (proApp != null && proApp.length > 0) {
                projectCostControlFlag = proApp[0].getBoolean("projectcostcontrol");
            } else if ((project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project")) != null && project.getDynamicObject("group") != null && (group = project.getDynamicObject("group").getPkValue()) != null && StringUtils.isNotEmpty((CharSequence)group.toString()) && (projectKindSetting = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (QFilter[])new QFilter[]{qFilter = new QFilter("projectkind", "=", (Object)Long.parseLong(group.toString()))})) != null) {
                projectCostControlFlag = projectKindSetting.getBoolean("projectcostcontrol");
            }
        }
        return projectCostControlFlag;
    }

    public static void updateTotalCtrlRate(DynamicObject project) {
        DynamicObject detail;
        ProBudgetCtrlEnums budgetControlType = ProBudgetControlHelper.getProjectBudgetControlType(project);
        QFilter qFilter = new QFilter("tproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        qFilter.and("tbudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{qFilter});
        if (totalBudgetCtrl == null) {
            return;
        }
        ProBudgetControlHelper.resetTotalBudgetCtrlRatio(budgetControlType, totalBudgetCtrl);
        DynamicObject controlRatio = ProBudgetControlHelper.getBudgetControlRatio(project);
        DynamicObject currency = totalBudgetCtrl.getDynamicObject("tcurrency");
        int amtPrecision = 10;
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        if (controlRatio != null) {
            BigDecimal totalRemindRate = controlRatio.getBigDecimal("totalremindrate");
            BigDecimal totalControlRate = controlRatio.getBigDecimal("totalcontrolrate");
            totalBudgetCtrl.set("tremindrate", (Object)(totalRemindRate.compareTo(BigDecimal.ZERO) > 0 ? totalRemindRate : new BigDecimal("100")));
            totalBudgetCtrl.set("tcontrolrate", (Object)(totalControlRate.compareTo(BigDecimal.ZERO) > 0 ? totalControlRate : new BigDecimal("100")));
        }
        DynamicObjectCollection details = totalBudgetCtrl.getDynamicObjectCollection("tbudgetctrldetail");
        QFilter statusFilter = new QFilter("enable", "=", (Object)true);
        QFilter controlTypeFilter = new QFilter("controltype", "=", (Object)ControlTypeEnum.PROJECT.getValue());
        QFilter projectFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        DynamicObject ctrlRatioByProject = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetcontrol", (QFilter[])new QFilter[]{statusFilter, controlTypeFilter, projectFilter});
        HashMap<Long, DynamicObject> detailsMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject detail2 : details) {
            Long key = detail2.getDynamicObject("budget").getLong("id");
            detailsMap.put(key, detail2);
        }
        if (ctrlRatioByProject != null) {
            DynamicObjectCollection budgetRatioEntry = ctrlRatioByProject.getDynamicObjectCollection("budgetcontrolentry");
            for (DynamicObject ratio : budgetRatioEntry) {
                DynamicObject proBudget = ratio.getDynamicObject("probudgetitem");
                Long proBudgetId = proBudget.getLong("id");
                if (!detailsMap.containsKey(proBudgetId)) continue;
                detail = (DynamicObject)detailsMap.get(proBudgetId);
                detail.set("remindrate", ratio.get("remindrate"));
                detail.set("controlrate", ratio.get("controlrate"));
                detailsMap.remove(proBudgetId);
            }
        }
        long org = Long.parseLong(project.getDynamicObject("useorg").getPkValue().toString());
        HashMap<Long, Map> queriedBudgetItemMap = new HashMap<Long, Map>(16);
        for (Map.Entry entry : detailsMap.entrySet()) {
            Map ratio;
            detail = (DynamicObject)entry.getValue();
            DynamicObject budgetItem = detail.getDynamicObject("budgetitem");
            if (budgetItem == null) continue;
            long budgetItemId = budgetItem.getLong("id");
            if (queriedBudgetItemMap.containsKey(budgetItemId)) {
                ratio = (Map)queriedBudgetItemMap.get(budgetItemId);
                detail.set("remindrate", ratio.get("remindrate"));
                detail.set("controlrate", ratio.get("controlrate"));
                continue;
            }
            ratio = BudgetControlHelper.getControlByOrgAndBudgetItem((Long)org, (Long)budgetItemId);
            if (ratio == null) continue;
            detail.set("remindrate", ratio.get("remindrate"));
            detail.set("controlrate", ratio.get("controlrate"));
            queriedBudgetItemMap.put(budgetItemId, ratio);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrl});
    }

    public static void resetTotalBudgetCtrlRatio(ProBudgetCtrlEnums budgetControlType, DynamicObject ctrl) {
        if (budgetControlType == null) {
            return;
        }
        ctrl.set("tremindrate", (Object)new BigDecimal(100));
        ctrl.set("tcontrolrate", (Object)new BigDecimal(100));
        DynamicObjectCollection details = ctrl.getDynamicObjectCollection("tbudgetctrldetail");
        for (DynamicObject detail : details) {
            detail.set("remindrate", (Object)new BigDecimal(100));
            detail.set("controlrate", (Object)new BigDecimal(100));
        }
    }

    public static void updateYearCtrlRate(DynamicObject project) {
        QFilter qFilter = new QFilter("yproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        qFilter.and("ybudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject[] yearBudgetCtrls = BusinessDataServiceHelper.load((String)"pmas_ybudgetctrl", (String)"id", (QFilter[])new QFilter[]{qFilter});
        Object[] idArrays = Arrays.stream(yearBudgetCtrls).map(dyn -> dyn.getLong("id")).toArray();
        if (idArrays.length == 0) {
            return;
        }
        for (DynamicObject yearBudgetCtrl : yearBudgetCtrls = BusinessDataServiceHelper.load((Object[])idArrays, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_ybudgetctrl"))) {
            DynamicObject detail;
            ProBudgetControlHelper.resetYearBudgetCtrlRatio(yearBudgetCtrl);
            DynamicObject controlRatio = ProBudgetControlHelper.getBudgetControlRatio(project);
            if (controlRatio != null) {
                BigDecimal yearRemindRate = controlRatio.getBigDecimal("totalremindrate");
                BigDecimal yearControlRate = controlRatio.getBigDecimal("totalcontrolrate");
                yearBudgetCtrl.set("yremindrate", (Object)(yearRemindRate.compareTo(BigDecimal.ZERO) > 0 ? yearRemindRate : new BigDecimal("100")));
                yearBudgetCtrl.set("ycontrolrate", (Object)(yearControlRate.compareTo(BigDecimal.ZERO) > 0 ? yearControlRate : new BigDecimal("100")));
            }
            DynamicObjectCollection details = yearBudgetCtrl.getDynamicObjectCollection("ybudgetctrldetail");
            QFilter statusFilter = new QFilter("enable", "=", (Object)true);
            QFilter controlTypeFilter = new QFilter("controltype", "=", (Object)ControlTypeEnum.PROJECT.getValue());
            QFilter projectFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            DynamicObject ctrlRatioByProject = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetcontrol", (QFilter[])new QFilter[]{statusFilter, controlTypeFilter, projectFilter});
            HashMap<Long, DynamicObject> detailsMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject detail2 : details) {
                Long key = detail2.getDynamicObject("budget").getLong("id");
                detailsMap.put(key, detail2);
            }
            if (ctrlRatioByProject != null) {
                DynamicObjectCollection budgetRatioEntry = ctrlRatioByProject.getDynamicObjectCollection("budgetcontrolentry");
                for (DynamicObject ratio : budgetRatioEntry) {
                    DynamicObject proBudget = ratio.getDynamicObject("probudgetitem");
                    Long proBudgetId = proBudget.getLong("id");
                    if (!detailsMap.containsKey(proBudgetId)) continue;
                    detail = (DynamicObject)detailsMap.get(proBudgetId);
                    detail.set("remindrate", ratio.get("remindrate"));
                    detail.set("controlrate", ratio.get("controlrate"));
                    detailsMap.remove(proBudgetId);
                }
            }
            long org = Long.parseLong(project.getDynamicObject("useorg").getPkValue().toString());
            HashMap<Long, Map> queriedBudgetItemMap = new HashMap<Long, Map>(16);
            for (Map.Entry entry : detailsMap.entrySet()) {
                Map ratio;
                detail = (DynamicObject)entry.getValue();
                DynamicObject budgetItem = detail.getDynamicObject("budgetitem");
                if (budgetItem == null) continue;
                long budgetItemId = budgetItem.getLong("id");
                if (queriedBudgetItemMap.containsKey(budgetItemId)) {
                    ratio = (Map)queriedBudgetItemMap.get(budgetItemId);
                    detail.set("remindrate", ratio.get("remindrate"));
                    detail.set("controlrate", ratio.get("controlrate"));
                    continue;
                }
                ratio = BudgetControlHelper.getControlByOrgAndBudgetItem((Long)org, (Long)budgetItemId);
                if (ratio == null) continue;
                detail.set("remindrate", ratio.get("remindrate"));
                detail.set("controlrate", ratio.get("controlrate"));
                queriedBudgetItemMap.put(budgetItemId, ratio);
            }
        }
        SaveServiceHelper.save((DynamicObject[])yearBudgetCtrls);
    }

    public static void resetYearBudgetCtrlRatio(DynamicObject ctrl) {
        ctrl.set("yremindrate", (Object)new BigDecimal(100));
        ctrl.set("ycontrolrate", (Object)new BigDecimal(100));
        DynamicObjectCollection details = ctrl.getDynamicObjectCollection("ybudgetctrldetail");
        for (DynamicObject detail : details) {
            detail.set("remindrate", (Object)new BigDecimal(100));
            detail.set("controlrate", (Object)new BigDecimal(100));
        }
    }

    public static DynamicObject getApproval(Long projectId) {
        QFilter projectFilter = new QFilter("pro", "=", (Object)projectId);
        return BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{projectFilter});
    }
}

