/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class ProjectInitiationHelper {
    public BigDecimal obtainLastApprovalAmt(Date year, DynamicObject project) {
        BigDecimal yearApprovalAmt = BigDecimal.ZERO;
        if (project != null && year != null) {
            int organizationYear = year.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
            QFilter qFilter = new QFilter("pro", "=", (Object)Long.parseLong(project.getPkValue().toString()));
            qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            qFilter.and("YEAR(projectapplydate)", "=", (Object)organizationYear);
            DynamicObject approval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "proyearbudgetamt", "projectapplydate", "createtime"), (QFilter[])new QFilter[]{qFilter});
            if (approval != null) {
                yearApprovalAmt = approval.getBigDecimal("proyearbudgetamt");
            } else {
                qFilter = new QFilter("yproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                qFilter.and("ybudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
                qFilter.and("YEAR(yyear)", "=", (Object)organizationYear);
                DynamicObject yBudgetCtrlBill = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{qFilter});
                if (yBudgetCtrlBill != null) {
                    yearApprovalAmt = yBudgetCtrlBill.getBigDecimal("yearproamt");
                } else {
                    qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                    qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                    qFilter.and("YEAR(year)", "=", (Object)organizationYear);
                    DynamicObject[] amtModifyBills = BusinessDataServiceHelper.load((String)"pmas_approval_amtmodify", (String)"id,afterproyearamt,year", (QFilter[])new QFilter[]{qFilter}, (String)" auditdate desc");
                    if (amtModifyBills.length > 0) {
                        yearApprovalAmt = amtModifyBills[0].getBigDecimal("afterproyearamt");
                    }
                }
            }
        }
        return yearApprovalAmt;
    }

    public BigDecimal getLastApprovalAmt(Date year, Object projectId, BigDecimal approvalAmt) {
        QFilter qFilter = new QFilter("project", "=", projectId);
        qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] amtModifyBills = BusinessDataServiceHelper.load((String)"pmas_approval_amtmodify", (String)"id,afterproyearamt,year,afterproamt", (QFilter[])new QFilter[]{qFilter}, (String)" auditdate desc");
        if (amtModifyBills.length > 0) {
            approvalAmt = amtModifyBills[0].getBigDecimal("afterproamt");
        }
        return approvalAmt;
    }
}

