/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ConstructorTreeDataHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetStageEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.InvestBudgetEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;

public class ProjectKindHelper {
    public static QFilter projectKindIdFilter() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        DynamicObject[] pmbsProkinds = BusinessDataServiceHelper.load((String)"pmbs_projectkind", (String)"id", (QFilter[])new QFilter[]{enableFilter});
        List ids = Arrays.stream(pmbsProkinds).map(kind -> Long.parseLong(kind.getPkValue().toString())).collect(Collectors.toList());
        return new QFilter("id", "in", ids);
    }

    public static String buildProjectKindTree(IFormView view, String treeKey, String rootNodeName, QFilter idFilter, boolean showNumber) {
        List<QFilter> filterList = ProjectKindHelper.getProjectKindFilter(idFilter);
        ConstructorTreeDataHelper tree = new ConstructorTreeDataHelper(view, treeKey, "bd_projectkind", rootNodeName);
        tree.setQFilters(filterList.toArray(new QFilter[filterList.size()]));
        return tree.constructorTreeData(showNumber);
    }

    public static List<QFilter> getProjectKindFilter(QFilter idFilter) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (idFilter == null) {
            DynamicObject[] pmasProkinds = BusinessDataServiceHelper.load((String)"pmbs_projectkind", (String)"number", (QFilter[])new QFilter[]{enableFilter});
            ArrayList<Long> ids = new ArrayList<Long>(10);
            for (DynamicObject kind : pmasProkinds) {
                ids.add(Long.parseLong(kind.getPkValue().toString()));
            }
            idFilter = new QFilter("id", "in", ids);
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(idFilter);
        filterList.add(enableFilter);
        filterList.add(statusFilter);
        return filterList;
    }

    public static List<TreeNode> getProjectKindTreeNodeWithoutRoot(IFormView view) {
        List<QFilter> filterList = ProjectKindHelper.getProjectKindFilter(null);
        DynamicObject[] projectKinds = BusinessDataServiceHelper.load((String)"bd_projectkind", (String)"number,parent,name", (QFilter[])filterList.toArray(new QFilter[filterList.size()]));
        ConstructorTreeDataHelper helper = new ConstructorTreeDataHelper(view);
        return helper.getChildNodes(projectKinds, false);
    }

    public static void syncToPMGT(Set<Long> pmgtNewIds, Set<Long> deleteIds) {
        QFilter qFilter;
        DynamicObject[] projectKindCtls;
        DynamicObject pmbsProjectKind;
        ArrayList<DynamicObject> pmbsProjectKindList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> proKindCtrlSettingList = new ArrayList<DynamicObject>();
        MainEntityType proKindCtrlSettingtype = EntityMetadataCache.getDataEntityType((String)"pmbs_prokindctrlsetting");
        MainEntityType projectKindtype = EntityMetadataCache.getDataEntityType((String)"pmbs_projectkind");
        for (Long id : pmgtNewIds) {
            DynamicObject proApplyBillType;
            DynamicObject proposalBillType;
            pmbsProjectKind = BusinessDataServiceHelper.loadSingle((String)"pmbs_projectkind", (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (pmbsProjectKind == null) {
                DynamicObject bdProjectKind = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_projectkind");
                pmbsProjectKind = new DynamicObject((DynamicObjectType)projectKindtype);
                pmbsProjectKind.set("id", bdProjectKind.get("id"));
                pmbsProjectKind.set("createorg", bdProjectKind.get("createorg"));
                pmbsProjectKind.set("number", bdProjectKind.get("number"));
                pmbsProjectKind.set("name", bdProjectKind.get("name"));
                pmbsProjectKind.set("parent", bdProjectKind.get("parent"));
                pmbsProjectKind.set("ctrlstrategy", bdProjectKind.get("ctrlstrategy"));
                pmbsProjectKind.set("createtime", bdProjectKind.get("createtime"));
                pmbsProjectKind.set("modifytime", bdProjectKind.get("modifytime"));
                pmbsProjectKind.set("modifier", bdProjectKind.get("modifier"));
                pmbsProjectKind.set("org", bdProjectKind.get("org"));
                pmbsProjectKind.set("masterid", bdProjectKind.get("masterid"));
                pmbsProjectKind.set("enable", bdProjectKind.get("enable"));
                pmbsProjectKind.set("level", bdProjectKind.get("level"));
                pmbsProjectKind.set("creator", bdProjectKind.get("creator"));
                pmbsProjectKind.set("longnumber", bdProjectKind.get("longnumber"));
                pmbsProjectKind.set("fullname", bdProjectKind.get("fullname"));
                pmbsProjectKind.set("isleaf", bdProjectKind.get("isleaf"));
                pmbsProjectKind.set("status", (Object)"C");
                pmbsProjectKind.set("useorg", bdProjectKind.get("useorg"));
                pmbsProjectKindList.add(pmbsProjectKind);
            } else if (pmbsProjectKind.getString("enable").equals("0")) {
                pmbsProjectKind = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmbs_projectkind");
                pmbsProjectKind.set("enable", (Object)"1");
                pmbsProjectKindList.add(pmbsProjectKind);
            }
            if (null != (projectKindCtls = BusinessDataServiceHelper.load((String)"pmbs_prokindctrlsetting", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("projectkind", "=", (Object)id)})) && projectKindCtls.length >= 1) continue;
            DynamicObject[] proStages = BusinessDataServiceHelper.load((String)"pmbs_projectstage", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)ProjectStageEnum.PROPOSALSTAGE_S.getValue())});
            DynamicObject[] budgetStages = BusinessDataServiceHelper.load((String)"pmbs_budgetstage", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)BudgetStageEnum.PREINSTALL_4.getValue())});
            if (proStages == null || proStages.length <= 0 || null == budgetStages || budgetStages.length <= 0) continue;
            DynamicObject proStage = proStages[0];
            DynamicObject budgetStage = budgetStages[0];
            DynamicObject setting = new DynamicObject((DynamicObjectType)proKindCtrlSettingtype);
            setting.set("enable", (Object)true);
            setting.set("projectkind", (Object)pmbsProjectKind);
            setting.set("budgetcontrolmode", (Object)BudgetCtlModeEnum.NOTCONTROL.getValue());
            DynamicObjectCollection projextStageEntity = setting.getDynamicObjectCollection("projectstageentry");
            DynamicObject proEntry = new DynamicObject(projextStageEntity.getDynamicObjectType());
            proEntry.set("projectstage", proStage.getPkValue());
            projextStageEntity.add((Object)proEntry);
            DynamicObjectCollection budgetStageEntity = setting.getDynamicObjectCollection("budgetstageentry");
            DynamicObject budgetentry = new DynamicObject(budgetStageEntity.getDynamicObjectType());
            budgetentry.set("budgetstage", budgetStage.getPkValue());
            budgetStageEntity.add((Object)budgetentry);
            setting.set("budgetcontrolmode", (Object)"0");
            setting.set("projectcostcontrol", (Object)"0");
            DynamicObject proBillType = ProjectKindHelper.getDefProApprovalBillType();
            if (proBillType != null) {
                setting.set("probilltype", (Object)proBillType);
            }
            if ((proposalBillType = ProjectKindHelper.getDefProjectProposalBillType()) != null) {
                setting.set("proposalbilltype", (Object)proposalBillType);
            }
            if ((proApplyBillType = ProjectKindHelper.getDefProApplyBillType()) != null) {
                setting.set("proapplybilltype", (Object)proApplyBillType);
            }
            setting.set("proposalctrlapplyamt", (Object)InvestBudgetEnum.REMINDER_CONTROL.getValue());
            setting.set("applyctrlapprovalamt", (Object)InvestBudgetEnum.REMINDER_CONTROL.getValue());
            setting.set("budgetauditctrldrawupamt", (Object)InvestBudgetEnum.REMINDER_CONTROL.getValue());
            proKindCtrlSettingList.add(setting);
        }
        for (Long id : deleteIds) {
            pmbsProjectKind = BusinessDataServiceHelper.loadSingle((String)"pmbs_projectkind", (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (pmbsProjectKind.getString("enable").equals("1")) {
                pmbsProjectKind = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmbs_projectkind");
                pmbsProjectKind.set("enable", (Object)"0");
                pmbsProjectKindList.add(pmbsProjectKind);
            }
            if ((projectKindCtls = BusinessDataServiceHelper.load((String)"pmbs_prokindctrlsetting", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("projectkind", "=", (Object)id)})) == null || projectKindCtls.length <= 0) continue;
            DeleteServiceHelper.delete((String)"pmbs_prokindctrlsetting", (QFilter[])new QFilter[]{qFilter});
        }
        if (!pmbsProjectKindList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])pmbsProjectKindList.toArray(new DynamicObject[pmbsProjectKindList.size()]));
        }
        if (!proKindCtrlSettingList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])proKindCtrlSettingList.toArray(new DynamicObject[proKindCtrlSettingList.size()]));
        }
    }

    public static DynamicObject getDefProApprovalBillType() {
        QFilter numberFilter = new QFilter("number", "=", (Object)"pmas_pro_approval_general");
        return BusinessDataServiceHelper.loadSingle((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{numberFilter});
    }

    public static DynamicObject getDefProjectProposalBillType() {
        QFilter numberFilter = new QFilter("number", "=", (Object)"pmim_projectproposal_general");
        return BusinessDataServiceHelper.loadSingle((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{numberFilter});
    }

    public static DynamicObject getDefProApplyBillType() {
        QFilter numberFilter = new QFilter("number", "=", (Object)"pmas_approval_apply_BT_S");
        return BusinessDataServiceHelper.loadSingle((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{numberFilter});
    }
}

