/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.business.model.pmbs.SupervisePropModel;

public class SupervisionPropDBHelper {
    private static final Log logger = LogFactory.getLog(SupervisionPropDBHelper.class);

    public static List<Long> batchSave(List<SupervisePropModel> spvProps) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            List<Long> list = spvProps.stream().map(SupervisionPropDBHelper::save).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static Long save(SupervisePropModel spvProp) {
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            String conditionJson = spvProp.getConditionJson();
            if (StringUtils.isBlank((CharSequence)conditionJson)) {
                conditionJson = SerializationUtils.toJsonString((Object)spvProp.getCondition());
            }
            String sql = "insert into T_PMBS_SUPERVISEPROPCOND(fid,fbillnumber,fpropdesc,fdata) values(?,?,?,?)";
            long pk = ID.genLongId();
            Object[] params = new Object[]{pk, spvProp.getBillNumber(), spvProp.getPropDesc(), conditionJson};
            DB.execute((DBRoute)DBRoute.of((String)"cr"), (String)sql, (Object[])params);
            logger.info("SupervisePropModel#save pk: {}, spvProp: {}", (Object)pk, (Object)spvProp);
            Long l = pk;
            return l;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static List<SupervisePropModel> getByIds(List<Long> pks) {
        return pks.stream().map(SupervisionPropDBHelper::getById).collect(Collectors.toList());
    }

    public static SupervisePropModel getById(Long pk) {
        String querySql = "select fid,fbillnumber,fpropdesc,fdata from T_PMBS_SUPERVISEPROPCOND where fid = ?";
        logger.info("SupervisePropModel#getById beginselect pk: {}", (Object)pk);
        Object[] params = new Object[]{pk};
        List formList = (List)DB.query((DBRoute)DBRoute.of((String)"cr"), (String)querySql, (Object[])params, rs -> {
            ArrayList<SupervisePropModel> list = new ArrayList<SupervisePropModel>(1);
            try {
                while (rs.next()) {
                    long fid = rs.getLong("fid");
                    String billNumber = rs.getString("fbillnumber");
                    String propDesc = rs.getString("fpropdesc");
                    String conditionJson = rs.getString("fdata");
                    SupervisePropModel spvPropModel = new SupervisePropModel(billNumber, propDesc, conditionJson);
                    spvPropModel.setId(fid);
                    list.add(spvPropModel);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return list;
        });
        SupervisePropModel result = null;
        if (!formList.isEmpty()) {
            result = (SupervisePropModel)formList.get(0);
        }
        logger.info("SupervisePropModel#getById pk: {}, result: {}", (Object)pk, (Object)result);
        return result;
    }
}

