/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.pmgt.pmbs.business.helper.SupervisionPropDBHelper;
import kd.pmgt.pmbs.business.model.pmbs.SupervisePropModel;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import org.jetbrains.annotations.Nullable;

public class SupervisionPropertyHelper {
    private static final Log logger = LogFactory.getLog(SupervisionPropertyHelper.class);

    public static QFilter spv2QFilter(Long spvPk) {
        QFilter qFilter = null;
        if (spvPk == null || spvPk == 0L) {
            return null;
        }
        SupervisePropModel spvProp = SupervisionPropDBHelper.getById(spvPk);
        String billNumber = spvProp.getBillNumber();
        if (spvProp != null) {
            FilterCondition condition = spvProp.getCondition();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, condition);
            filterBuilder.buildFilter();
            qFilter = filterBuilder.getQFilter();
        }
        logger.info("spvPk: {}, qFilter: {}", (Object)spvPk, qFilter);
        return qFilter;
    }

    @Nullable
    public static QFilter getSpecialBillFilter(String billNumber) {
        QFilter speciFilter = null;
        switch (billNumber) {
            case "pmct_incontract": {
                speciFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
                break;
            }
            case "pmct_outcontract": {
                speciFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
                break;
            }
            case "pmas_inbudget": {
                speciFilter = new QFilter("sourcetype", "=", (Object)"IN");
                break;
            }
            case "pmas_outbudget": {
                speciFilter = new QFilter("sourcetype", "=", (Object)"OUT");
            }
        }
        return speciFilter;
    }
}

