/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TreeNodeSearchHelper {
    private static final Log logger = LogFactory.getLog(TreeNodeSearchHelper.class);
    private static final String FIELD_PARENT = "parent";

    public static Map<Long, DynamicObjectCollection> getChildMap(DynamicObject[] allNodes) {
        HashMap<Long, DynamicObjectCollection> childMap = new HashMap<Long, DynamicObjectCollection>();
        for (DynamicObject treeData : allNodes) {
            if (null == treeData.get(FIELD_PARENT)) continue;
            DynamicObject parent = (DynamicObject)treeData.get(FIELD_PARENT);
            Long parentId = (Long)parent.getPkValue();
            DynamicObjectCollection col = null != childMap.get(parentId) ? (DynamicObjectCollection)childMap.get(parentId) : new DynamicObjectCollection();
            col.add((Object)treeData);
            childMap.put((Long)parent.getPkValue(), col);
        }
        return childMap;
    }

    public static List<TreeNode> getTreeNodes(DynamicObject[] dynamicObjects) {
        Map<Long, DynamicObjectCollection> childMap = TreeNodeSearchHelper.getChildMap(dynamicObjects);
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(10);
        for (DynamicObject treeData : dynamicObjects) {
            boolean hasParent = treeData.get(FIELD_PARENT) != null;
            boolean bl = hasParent = hasParent && Arrays.stream(dynamicObjects).anyMatch(entry -> StringUtils.equals((CharSequence)((DynamicObject)treeData.get(FIELD_PARENT)).getPkValue().toString(), (CharSequence)entry.getPkValue().toString()));
            if (hasParent) continue;
            TreeNode treeNode = TreeNodeSearchHelper.constructTreeNode(treeData, childMap, null);
            treeNodeList.add(treeNode);
        }
        return treeNodeList;
    }

    public static TreeNode constructTreeNode(DynamicObject treeData, Map<Long, DynamicObjectCollection> childMap, String parentId) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)"bd_projectkind");
        String nameProperty = ((BasedataEntityType)refMainType).getNameProperty();
        nameProperty = StringUtils.isBlank((CharSequence)nameProperty) ? "name" : nameProperty;
        String treeNodeName = treeData.get(nameProperty).toString();
        TreeNode treeNode = new TreeNode(parentId, treeData.getPkValue().toString(), treeNodeName, true);
        Long dataId = (Long)treeData.getPkValue();
        if (null == childMap.get(dataId)) {
            treeNode.setChildren(null);
            return treeNode;
        }
        DynamicObjectCollection childDataCol = childMap.get(dataId);
        for (DynamicObject childData : childDataCol) {
            TreeNode childNode = TreeNodeSearchHelper.constructTreeNode(childData, childMap, treeNode.getId());
            treeNode.addChild(childNode);
        }
        return treeNode;
    }

    public static List<DynamicObject> findChildTreeNode(DynamicObject[] allNodes, DynamicObject currentNode) {
        ArrayList<DynamicObject> childTreeNodes = new ArrayList<DynamicObject>(10);
        Map<Long, DynamicObjectCollection> childMap = TreeNodeSearchHelper.getChildMap(allNodes);
        DynamicObjectCollection childNodes = childMap.get(currentNode.getPkValue());
        if (childNodes == null) {
            return childTreeNodes;
        }
        for (DynamicObject childNode : childNodes) {
            childTreeNodes.add(childNode);
            TreeNodeSearchHelper.addChildNodes(childMap, childNode, childTreeNodes);
        }
        return childTreeNodes;
    }

    private static void addChildNodes(Map<Long, DynamicObjectCollection> childMap, DynamicObject node, List<DynamicObject> childTreeNodes) {
        DynamicObjectCollection childNodes = childMap.get(node.getPkValue());
        if (childNodes == null) {
            return;
        }
        for (DynamicObject childNode : childNodes) {
            childTreeNodes.add(childNode);
            if (!childMap.containsKey(childNode.getPkValue())) continue;
            TreeNodeSearchHelper.addChildNodes(childMap, childNode, childTreeNodes);
        }
    }

    public static List<DynamicObject> findParentNode(DynamicObject[] allNodes, DynamicObject currentNode) {
        ArrayList<DynamicObject> parentNodes = new ArrayList<DynamicObject>(10);
        for (DynamicObject node : allNodes) {
            DynamicObject parent = currentNode.getDynamicObject(FIELD_PARENT);
            if (parent == null) {
                return parentNodes;
            }
            if (!parent.getPkValue().equals(node.getPkValue())) continue;
            parentNodes.add(node);
            TreeNodeSearchHelper.addParentNode(allNodes, node, parentNodes);
        }
        return parentNodes;
    }

    private static void addParentNode(DynamicObject[] allNodes, DynamicObject currentNode, List<DynamicObject> parentNodes) {
        DynamicObject parent = currentNode.getDynamicObject(FIELD_PARENT);
        if (parent == null) {
            return;
        }
        for (DynamicObject node : allNodes) {
            if (!parent.getPkValue().equals(node.getPkValue())) continue;
            parentNodes.add(node);
            TreeNodeSearchHelper.addParentNode(allNodes, node, parentNodes);
        }
    }

    public static TreeNode searchTreeNode(IFormView view, TreeView treeView, TreeNode rootNode, String searchText) {
        List treeNodes;
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String searchNodesCacheKey = view.getPageId() + "_searchNodes";
        String matchNodesCacheKey = view.getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = view.getPageId() + "_oldSearchText";
        String searchIndexCacheKey = view.getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if ((oldSearchText == null || oldSearchText.equals(searchText)) && !StringUtils.isBlank((CharSequence)matchNodesCache)) {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        } else {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, TreeNodeSearchHelper::loadChildNodes, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        }
        TreeNode targetTreeNode = null;
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, TreeNodeSearchHelper::loadChildNodes, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            view.showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"TreeNodeSearchHelper_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        } else {
            int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                TreeNodeSearchHelper.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                TreeNodeSearchHelper.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            targetTreeNode = (TreeNode)treeNodes.get(indexCache - 1);
            treeView.focusNode(targetTreeNode);
        }
        return targetTreeNode;
    }

    private static void loadChildNodes(TreeNode node) {
    }

    private static void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        TreeNodeSearchHelper.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private static void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentId = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            TreeNode p = rootNode.getTreeNode(parentId, 20);
            if (p != null) {
                TreeNodeSearchHelper.expandParents(treeView, rootNode, p);
                treeView.expand(parentId);
                if (p == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    public static TreeNode rebuildProjectKindTreeRoot(String rootName) {
        TreeNode root = new TreeNode();
        root.setId("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
        root.setText(rootName);
        return root;
    }
}

