/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class UserOrgRangeHelper {
    public static List<Long> getUserOrgRanges(Long userId) {
        List<Long> orgRanges = new ArrayList<Long>();
        boolean isAdmin = OrgUnitServiceHelper.checkOrgFunction((Long)RequestContext.get().getOrgId(), (String)"01");
        if (!isAdmin) {
            orgRanges = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(RequestContext.get().getOrgId()), (boolean)true);
        } else {
            orgRanges.add(RequestContext.get().getOrgId());
        }
        String pattern = ProjectPermissionHelper.getPatternIdByParam((Long)RequestContext.get().getOrgId(), (String)"personseparate");
        orgRanges = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, orgRanges, (String)"01");
        if (orgRanges.size() == 0) {
            orgRanges.add(OrgUnitServiceHelper.getRootOrgId());
        }
        return orgRanges;
    }

    public static QFilter loadUserOrgRanges(Long userId, Long projectId) {
        List<Long> userList;
        QFilter qFilter = null;
        List<Long> userOrgRanges = UserOrgRangeHelper.getUserOrgRanges(userId);
        if (userOrgRanges.size() > 0) {
            qFilter = new QFilter("entryentity.dpt.id", "in", userOrgRanges);
        }
        if (projectId != 0L && (userList = UserOrgRangeHelper.loadTeamUserByProject(projectId)).size() > 0) {
            if (qFilter == null) {
                qFilter = new QFilter("id", "in", userList);
            } else {
                qFilter.or(new QFilter("id", "in", userList));
            }
        }
        return qFilter;
    }

    public static QFilter loadUserOrgRangesByPermOrg(String userId, String appId, String entityNum) {
        DynamicObjectCollection entryEntity;
        ArrayList orgRanges = new ArrayList();
        List<Long> userOrgList = new ArrayList<Long>();
        HashSet<Long> orgUnitOrgSet = new HashSet<Long>();
        DynamicObject curUser = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        if (curUser != null && !(entryEntity = curUser.getDynamicObjectCollection("entryentity")).isEmpty()) {
            userOrgList = entryEntity.stream().filter(o -> o.getDynamicObject("dpt") != null).map(o -> Long.parseLong(o.getDynamicObject("dpt").getPkValue().toString())).collect(Collectors.toList());
        }
        if (userOrgList.isEmpty()) {
            orgRanges.addAll(OrgUnitServiceHelper.getAllOrg((String)"01"));
            return new QFilter("entryentity.dpt.id", "in", orgRanges);
        }
        UserOrgRangeHelper.getParentOrgUnitsByAdminOrg(userOrgList, orgUnitOrgSet);
        if (orgUnitOrgSet.isEmpty()) {
            orgRanges.addAll(OrgUnitServiceHelper.getAllOrg((String)"01"));
            return new QFilter("entryentity.dpt.id", "in", orgRanges);
        }
        Map patternIdMap = ProjectPermissionHelper.getBatchPatternIdByOrgIds(new ArrayList<Long>(orgUnitOrgSet), (String)"personseparate", (String)"15");
        HashMap<String, ArrayList<Long>> adminOrgMap = new HashMap<String, ArrayList<Long>>(16);
        for (Long adminOrg : userOrgList) {
            ArrayList<Long> adminOrgList;
            if (patternIdMap.isEmpty()) continue;
            String pattern = (String)patternIdMap.get(String.valueOf(adminOrg));
            if (StringUtils.isEmpty((CharSequence)pattern)) {
                List superOrgList = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"01", (long)adminOrg);
                if (superOrgList.isEmpty()) {
                    orgRanges.addAll(OrgUnitServiceHelper.getAllOrg((String)"01"));
                    break;
                }
                Optional<Long> first = (superOrgList = superOrgList.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList())).stream().sorted().filter(o -> patternIdMap.get(String.valueOf(o)) != null).findFirst();
                if (!first.isPresent()) {
                    orgRanges.addAll(OrgUnitServiceHelper.getAllOrg((String)"01"));
                    break;
                }
                pattern = (String)patternIdMap.get(String.valueOf(first.get()));
            }
            if ((adminOrgList = (ArrayList<Long>)adminOrgMap.get(pattern)) == null) {
                adminOrgList = new ArrayList<Long>();
            }
            adminOrgList.add(adminOrg);
            adminOrgMap.put(pattern, adminOrgList);
        }
        if (orgRanges.contains(OrgUnitServiceHelper.getRootOrgId())) {
            return new QFilter("entryentity.dpt.id", "in", orgRanges);
        }
        if (!adminOrgMap.isEmpty()) {
            Set adminOrgListSet = adminOrgMap.entrySet();
            for (Map.Entry adminOrg : adminOrgListSet) {
                String pattern = (String)adminOrg.getKey();
                if (StringUtils.isEmpty((CharSequence)pattern)) continue;
                List adminOrgList = (List)adminOrg.getValue();
                List allSubOrgUnits = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, (List)adminOrgList, (String)"01");
                if (allSubOrgUnits.size() == 0) {
                    orgRanges.addAll(adminOrgList);
                    continue;
                }
                orgRanges.addAll(allSubOrgUnits);
            }
        }
        if (orgRanges.size() == 0) {
            orgRanges.addAll(OrgUnitServiceHelper.getAllOrg((String)"01"));
        }
        return new QFilter("entryentity.dpt.id", "in", orgRanges);
    }

    public static void getParentOrgUnitsByAdminOrg(List<Long> adminOrgList, Set<Long> orgUnits) {
        String selectFields = "id,org.id,parent,view";
        QFilter qFilter = new QFilter("org.id", "in", adminOrgList);
        qFilter.and("isfreeze", "=", (Object)false);
        DynamicObjectCollection structures = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (structures.size() > 0) {
            Set orgIdsByOrgViewType = structures.stream().filter(o -> o.getLong("view") == Long.parseLong("15")).map(o -> o.getLong("org.id")).collect(Collectors.toSet());
            if (orgIdsByOrgViewType.size() > 0) {
                orgUnits.addAll(orgIdsByOrgViewType);
            }
            long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            adminOrgList = structures.stream().filter(o -> o.getLong("org.id") != rootOrgId).filter(o -> o.getLong("view") != Long.parseLong("15")).filter(o -> o.getLong("parent") != 0L).map(o -> o.getLong("parent")).collect(Collectors.toList());
            if (!adminOrgList.isEmpty()) {
                UserOrgRangeHelper.getParentOrgUnitsByAdminOrg(adminOrgList, orgUnits);
            }
        }
    }

    public static List<Long> loadTeamUserByProject(Long projectId) {
        List<Long> userList = new ArrayList<Long>(10);
        QFilter proQFilter = new QFilter("project", "=", (Object)projectId);
        DynamicObject[] teamUsers = BusinessDataServiceHelper.load((String)"pmas_nowteam", (String)"member", (QFilter[])new QFilter[]{proQFilter});
        if (teamUsers.length > 0) {
            userList = Arrays.stream(teamUsers).filter(o -> o.getDynamicObject("member") != null).map(o -> Long.parseLong(o.getDynamicObject("member").getPkValue().toString())).collect(Collectors.toList());
        }
        return userList;
    }
}

