/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper.dataupgrade;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.business.helper.dataupgrade.ExcelUtil;
import kd.pmgt.pmbs.common.enums.BudgetControlTargetEnum;
import kd.pmgt.pmbs.common.enums.BudgetControlTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;
import kd.pmgt.pmbs.common.enums.dataupgrade.UpgradeTypeEnum;
import kd.pmgt.pmbs.common.utils.BudgetControlHelper;

public class DataUpgradeHelper {
    public static final String COST_ITEM = "cost_item";
    public static final String ONE_TO_MANY = "one_to_many";
    public static final String EXPORT_EXCEL = "export_excel";

    public static List<ExcelUtil.ExcelVo> updateProBudgetData(List<Long> projectIds) {
        ArrayList<ExcelUtil.ExcelVo> resultList = new ArrayList<ExcelUtil.ExcelVo>();
        try (TXHandle h = TX.requiresNew();){
            try {
                List<ExcelUtil.ExcelVo> doResultList;
                ArrayList<Long> oldProjects = new ArrayList<Long>(projectIds);
                Set<Long> allNewProjectIds = DataUpgradeHelper.getAllNewProjectIds();
                if (!allNewProjectIds.isEmpty()) {
                    projectIds.retainAll(new ArrayList<Long>(allNewProjectIds));
                }
                oldProjects.removeAll(projectIds);
                if (!oldProjects.isEmpty()) {
                    DataUpgradeHelper.checkBudgetBill(oldProjects);
                    doResultList = DataUpgradeHelper.doUpdateOldBudget(oldProjects);
                    if (!doResultList.isEmpty()) {
                        resultList.addAll(doResultList);
                    }
                }
                if (!projectIds.isEmpty() && !(doResultList = DataUpgradeHelper.doUpdateNewBudget(projectIds)).isEmpty()) {
                    resultList.addAll(doResultList);
                }
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
        return resultList;
    }

    private static void checkBudgetBill(List<Long> projectIds) {
        String selectProperties = String.join((CharSequence)",", "project", "performentry", "billtype", "billno", "billstatus");
        QFilter qFilter = new QFilter("project", "in", projectIds);
        DynamicObject[] projectBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        if (projectBudgets.length == 0) {
            return;
        }
        HashMap<String, ArrayList<DynamicObject>> projectBudgetMap = new HashMap<String, ArrayList<DynamicObject>>();
        for (DynamicObject projectBudget : projectBudgets) {
            DynamicObject project = projectBudget.getDynamicObject("project");
            if (project == null) continue;
            String projectId = project.getPkValue().toString();
            ArrayList<DynamicObject> projectBudgetList = (ArrayList<DynamicObject>)projectBudgetMap.get(projectId);
            if (projectBudgetList == null) {
                projectBudgetList = new ArrayList<DynamicObject>();
            }
            projectBudgetList.add(projectBudget);
            projectBudgetMap.put(projectId, projectBudgetList);
        }
        if (!projectBudgetMap.isEmpty()) {
            Set projectBudgetSet = projectBudgetMap.entrySet();
            StringBuilder errorTip = new StringBuilder();
            for (Map.Entry entry : projectBudgetSet) {
                List projectBudgetList = (List)entry.getValue();
                List performEntryList = projectBudgetList.stream().filter(o -> o.getDynamicObjectCollection("performentry").size() > 0).map(o -> o.getDynamicObjectCollection("performentry")).collect(Collectors.toList());
                ArrayList uncheckPerformList = new ArrayList();
                for (DynamicObjectCollection performEntry : performEntryList) {
                    List performList = performEntry.stream().filter(o -> StringUtils.equals((CharSequence)o.getString("billstatus"), (CharSequence)StatusEnum.UNCHECKED.getValue())).collect(Collectors.toList());
                    if (performList.size() <= 0) continue;
                    uncheckPerformList.addAll(performList);
                }
                if (uncheckPerformList.isEmpty()) continue;
                DynamicObject project = ((DynamicObject)projectBudgetList.get(0)).getDynamicObject("project");
                if (StringUtils.isNotEmpty((CharSequence)errorTip)) {
                    errorTip.append("\r\n");
                }
                errorTip.append(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d,", (String)"DataUpgradeHelper_16", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project.getString("name")));
                for (DynamicObject uncheckPerform : uncheckPerformList) {
                    DynamicObject billType = uncheckPerform.getDynamicObject("billtype");
                    String billNo = uncheckPerform.getString("billno");
                    String tip = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%1$s\u7684%2$s\u5c1a\u672a\u5ba1\u6279\u3002", (String)"DataUpgradeHelper_14", (String)"pmgt-pmbs-business", (Object[])new Object[0]), billNo, billType.getLocaleString("name"));
                    errorTip.append(tip);
                }
                errorTip.append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"DataUpgradeHelper_15", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty((CharSequence)errorTip.toString())) {
                throw new KDBizException(errorTip.toString());
            }
        }
    }

    public static List<ExcelUtil.ExcelVo> doUpdateOldBudget(List<Long> projectIds) {
        ArrayList<String> useBudgetBillType = new ArrayList<String>();
        useBudgetBillType.add("pmct_outfinalsettle");
        useBudgetBillType.add("pmct_paymentapply");
        useBudgetBillType.add("pmct_paymentregister");
        ArrayList<ExcelUtil.ExcelVo> resultList = new ArrayList<ExcelUtil.ExcelVo>();
        ArrayList<DynamicObject> excRecords = new ArrayList<DynamicObject>();
        HashMap<String, List<DynamicObject>> budgetExcMap = new HashMap<String, List<DynamicObject>>();
        String selectProperties = String.join((CharSequence)",", "id", "project", "sourcetype", "remindrate", "remainamt", "controlrate", "controlamt", "currency", "occupyamt", "performamt", "performentry", "performtype", "billtype", "billno", "billname", "billamt", "billstatus", "billcreator", "billcreatedate", "billauditdate", "billid");
        QFilter qFilter = new QFilter("project", "in", projectIds);
        DynamicObject[] projectBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        if (projectBudgets.length == 0) {
            return resultList;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_budgetexerecord");
        for (DynamicObject projectBudget : projectBudgets) {
            DynamicObjectCollection performEntry;
            DynamicObject project = projectBudget.getDynamicObject("project");
            if (project == null || (performEntry = projectBudget.getDynamicObjectCollection("performentry")).isEmpty()) continue;
            DynamicObject occupyPerform = null;
            DynamicObject usePerform = null;
            BigDecimal maxAmt = BigDecimal.ZERO;
            for (DynamicObject perform : performEntry) {
                String performType;
                BigDecimal billAmt = perform.getBigDecimal("billamt");
                DynamicObject billType = perform.getDynamicObject("billtype");
                if (billType != null) {
                    String formId = billType.getPkValue().toString();
                    if (StringUtils.equals((CharSequence)"pmco_procostsplit", (CharSequence)formId)) continue;
                    if (useBudgetBillType.contains(formId) && billAmt.compareTo(maxAmt) > 0) {
                        usePerform = perform;
                    }
                }
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)(performType = perform.getString("performtype")))) continue;
                occupyPerform = perform;
            }
            String projectId = project.getPkValue().toString();
            ArrayList<DynamicObject> curProExcRecords = (ArrayList<DynamicObject>)budgetExcMap.get(projectId);
            if (curProExcRecords == null) {
                curProExcRecords = new ArrayList<DynamicObject>();
            }
            for (DynamicObject perform : performEntry) {
                DynamicObject bill;
                DynamicObject record = new DynamicObject((DynamicObjectType)dt);
                String budgetControlTarget = null;
                if (occupyPerform != null && StringUtils.equals((CharSequence)perform.getPkValue().toString(), (CharSequence)occupyPerform.getPkValue().toString())) {
                    budgetControlTarget = BudgetControlTargetEnum.BUDGETOCCUPY.getValue();
                }
                if (usePerform != null && StringUtils.equals((CharSequence)perform.getPkValue().toString(), (CharSequence)usePerform.getPkValue().toString())) {
                    budgetControlTarget = BudgetControlTargetEnum.BUDGETUSE.getValue();
                }
                if (occupyPerform != null && usePerform != null && StringUtils.equals((CharSequence)perform.getPkValue().toString(), (CharSequence)occupyPerform.getPkValue().toString()) && StringUtils.equals((CharSequence)occupyPerform.getPkValue().toString(), (CharSequence)usePerform.getPkValue().toString())) {
                    budgetControlTarget = BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue();
                }
                DynamicObject billType = perform.getDynamicObject("billtype");
                if (budgetControlTarget == null && billType != null && StringUtils.equals((CharSequence)"pmco_procostsplit", (CharSequence)billType.getPkValue().toString())) {
                    budgetControlTarget = BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue();
                }
                if (budgetControlTarget == null) continue;
                if (billType != null) {
                    record.set("bizbillmark", (Object)billType.getPkValue().toString());
                    record.set("bizbillname", (Object)billType.getLocaleString("name"));
                }
                record.set("optype", (Object)budgetControlTarget);
                record.set("opaction", (Object)BillFieldTypeEnum.EXEC_OPERATION.getNumber());
                record.set("project", (Object)project);
                record.set("probudget", (Object)projectBudget);
                record.set("billid", (Object)perform.getString("billid"));
                record.set("billno", (Object)perform.getString("billno"));
                record.set("billname", (Object)perform.getString("billname"));
                Date budgetDate = perform.getDate("billauditdate");
                if (budgetDate == null) {
                    budgetDate = perform.getDate("billcreatedate");
                }
                if (budgetDate != null) {
                    int year = budgetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                    int month = budgetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getMonthValue();
                    LocalDate yearDate = LocalDate.of(year, 1, 1);
                    ZonedDateTime zonedDateTime = yearDate.atStartOfDay(ZoneId.systemDefault());
                    record.set("year", (Object)Date.from(zonedDateTime.toInstant()));
                    record.set("month", (Object)String.valueOf(month));
                }
                String bizBillMark = record.getString("bizbillmark");
                String billId = record.getString("billid");
                if (StringUtils.isNotEmpty((CharSequence)bizBillMark) && StringUtils.isNotEmpty((CharSequence)billId) && QueryServiceHelper.exists((String)bizBillMark, (Object)billId) && (bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)bizBillMark)).getDynamicObjectType().getProperties().containsKey((Object)"org")) {
                    record.set("org", (Object)bill.getDynamicObject("org"));
                }
                record.set("currency", (Object)projectBudget.getDynamicObject("currency"));
                record.set("oricurrency", (Object)projectBudget.getDynamicObject("currency"));
                record.set("amount", (Object)perform.getBigDecimal("billamt"));
                record.set("oriamount", (Object)perform.getBigDecimal("billamt"));
                record.set("bizdate", (Object)budgetDate);
                record.set("bizuser", (Object)perform.getDynamicObject("billcreator"));
                record.set("optime", (Object)budgetDate);
                record.set("iseffect", (Object)true);
                record.set("budgettype", (Object)projectBudget.getString("sourcetype"));
                String controlType = StringUtils.equals((CharSequence)budgetControlTarget, (CharSequence)BudgetControlTargetEnum.BUDGETOCCUPY.getValue()) ? BudgetControlTypeEnum.TAKEOPERATION.getValue() : BudgetControlTypeEnum.EXECOPERATION.getValue();
                record.set("controltype", (Object)controlType);
                excRecords.add(record);
                curProExcRecords.add(record);
            }
            budgetExcMap.put(projectId, curProExcRecords);
        }
        DataUpgradeHelper.doUpdateBudgetCtrlInfo(projectIds, budgetExcMap, resultList);
        if (!excRecords.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])excRecords.toArray(new DynamicObject[excRecords.size()]));
        }
        return resultList;
    }

    public static List<ExcelUtil.ExcelVo> doUpdateNewBudget(List<Long> projectIds) {
        ArrayList<ExcelUtil.ExcelVo> resultList = new ArrayList<ExcelUtil.ExcelVo>();
        QFilter qFilter = new QFilter("yproject", "in", projectIds);
        DeleteServiceHelper.delete((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{qFilter});
        qFilter = new QFilter("tproject", "in", projectIds);
        DeleteServiceHelper.delete((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{qFilter});
        String selectProperties = String.join((CharSequence)",", "opaction", "project", "probudget", "year", "currency", "amount", "budgettype", "controltype");
        qFilter = new QFilter("project", "in", projectIds);
        qFilter.and("iseffect", "=", (Object)true);
        DynamicObject[] budgetExcRecords = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        HashMap<String, List<DynamicObject>> budgetExcMap = new HashMap<String, List<DynamicObject>>();
        for (DynamicObject budgetExcRecord : budgetExcRecords) {
            if (budgetExcRecord.getDynamicObject("project").getPkValue() == null) continue;
            String projectId = budgetExcRecord.getDynamicObject("project").getPkValue().toString();
            ArrayList<DynamicObject> budgetExcList = (ArrayList<DynamicObject>)budgetExcMap.get(projectId);
            if (budgetExcList == null) {
                budgetExcList = new ArrayList<DynamicObject>();
            }
            budgetExcList.add(budgetExcRecord);
            budgetExcMap.put(projectId, budgetExcList);
        }
        DataUpgradeHelper.doUpdateBudgetCtrlInfo(projectIds, budgetExcMap, resultList);
        return resultList;
    }

    public static void doUpdateBudgetCtrlInfo(List<Long> projectIds, Map<String, List<DynamicObject>> budgetExcMap, List<ExcelUtil.ExcelVo> resultList) {
        List totalBudgetPros;
        List outBudgetPros;
        List inBudgetPros;
        ArrayList<Long> budgetProIds = new ArrayList<Long>(projectIds);
        QFilter qFilter = new QFilter("project", "in", projectIds);
        qFilter.and("isvalid", "=", (Object)true);
        qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.IN.getValue());
        DynamicObject[] inYearBudgetBills = BusinessDataServiceHelper.load((String)"pmas_inbudget", (String)"project", (QFilter[])new QFilter[]{qFilter});
        if (inYearBudgetBills.length > 0 && !(inBudgetPros = Arrays.stream(inYearBudgetBills).map(o -> Long.parseLong(o.getDynamicObject("project").getPkValue().toString())).collect(Collectors.toList())).isEmpty()) {
            budgetProIds.removeAll(inBudgetPros);
        }
        if (!budgetProIds.isEmpty()) {
            DynamicObject[] projects;
            qFilter = new QFilter("id", "in", budgetProIds);
            for (DynamicObject project : projects = BusinessDataServiceHelper.load((String)"bd_project", (String)"number", (QFilter[])new QFilter[]{qFilter})) {
                ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
                vo.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
                vo.setBillNo(project.getString("number"));
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230%1$s\u9879\u76ee\u7684\u201c\u9879\u76ee\u6536\u5165\u9884\u7b97\u7f16\u5236\u201d\u8bb0\u5f55,\u5e74\u5ea6\u6536\u5165\u9884\u7b97\u5347\u7ea7\u5931\u8d25\u3002", (String)"DataUpgradeHelper_19", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project.getString("number")));
                resultList.add(vo);
            }
        }
        budgetProIds = new ArrayList<Long>(projectIds);
        qFilter = new QFilter("project", "in", projectIds);
        qFilter.and("isvalid", "=", (Object)true);
        qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject[] outYearBudgetBills = BusinessDataServiceHelper.load((String)"pmas_outbudget", (String)"project", (QFilter[])new QFilter[]{qFilter});
        if (outYearBudgetBills.length > 0 && !(outBudgetPros = Arrays.stream(outYearBudgetBills).map(o -> Long.parseLong(o.getDynamicObject("project").getPkValue().toString())).collect(Collectors.toList())).isEmpty()) {
            budgetProIds.removeAll(outBudgetPros);
        }
        if (!budgetProIds.isEmpty()) {
            DynamicObject[] projects;
            qFilter = new QFilter("id", "in", budgetProIds);
            for (DynamicObject project : projects = BusinessDataServiceHelper.load((String)"bd_project", (String)"number", (QFilter[])new QFilter[]{qFilter})) {
                ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
                vo.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
                vo.setBillNo(project.getString("number"));
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230%1$s\u9879\u76ee\u7684\u201c\u9879\u76ee\u5e74\u5ea6\u652f\u51fa\u9884\u7b97\u7f16\u5236\u201d\u8bb0\u5f55\uff0c\u5e74\u5ea6\u652f\u51fa\u9884\u7b97\u5347\u7ea7\u5931\u8d25\u3002", (String)"DataUpgradeHelper_20", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project.getString("number")));
                resultList.add(vo);
            }
        }
        budgetProIds = new ArrayList<Long>(projectIds);
        qFilter = new QFilter("project", "in", projectIds);
        qFilter.and("isvalid", "=", (Object)true);
        qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
        DynamicObject[] totalBudgetBills = BusinessDataServiceHelper.load((String)"pmas_totalbudget", (String)"project", (QFilter[])new QFilter[]{qFilter});
        if (totalBudgetBills.length > 0 && !(totalBudgetPros = Arrays.stream(totalBudgetBills).map(o -> Long.parseLong(o.getDynamicObject("project").getPkValue().toString())).collect(Collectors.toList())).isEmpty()) {
            budgetProIds.removeAll(totalBudgetPros);
        }
        if (!budgetProIds.isEmpty()) {
            DynamicObject[] projects;
            qFilter = new QFilter("id", "in", budgetProIds);
            for (DynamicObject project : projects = BusinessDataServiceHelper.load((String)"bd_project", (String)"number", (QFilter[])new QFilter[]{qFilter})) {
                ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
                vo.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
                vo.setBillNo(project.getString("number"));
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230%1$s\u9879\u76ee\u7684\u201c\u603b\u4f53\u652f\u51fa\u9884\u7b97\u7f16\u5236\u201d\u8bb0\u5f55\uff0c\u603b\u4f53\u652f\u51fa\u9884\u7b97\u5347\u7ea7\u5931\u8d25\u3002", (String)"DataUpgradeHelper_21", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project.getString("number")));
                resultList.add(vo);
            }
        }
        List<DynamicObject> yearBudgetCtrlList = DataUpgradeHelper.doUpdateYearBudgetCtrlInfo(projectIds, budgetExcMap, resultList);
        List<DynamicObject> totalBudgetCtrlList = DataUpgradeHelper.doUpdateTotalBudgetCtrlInfo(projectIds, budgetExcMap, yearBudgetCtrlList, resultList);
        if (!yearBudgetCtrlList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])yearBudgetCtrlList.toArray(new DynamicObject[yearBudgetCtrlList.size()]));
        }
        if (!totalBudgetCtrlList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])totalBudgetCtrlList.toArray(new DynamicObject[totalBudgetCtrlList.size()]));
        }
    }

    public static List<DynamicObject> doUpdateTotalBudgetCtrlInfo(List<Long> projectIds, Map<String, List<DynamicObject>> budgetExcMap, List<DynamicObject> yearBudgetCtrlList, List<ExcelUtil.ExcelVo> resultList) {
        List<DynamicObject> totalInBudgetCtrlList;
        List<DynamicObject> tBudgetCtrlList;
        QFilter qFilter = new QFilter("pro", "in", projectIds);
        DynamicObject[] proApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "pro", "currencyfield", "projcetbugamt", "probudgetctrl"), (QFilter[])new QFilter[]{qFilter});
        String selectProperties = String.join((CharSequence)",", "project", "currency", "proapprovalamt", "totalamount", "treeentryentity", "projectbudgetitem", "budgetitem", "budgetamount");
        Set<Object> totalBudgetPros = new HashSet();
        qFilter = new QFilter("project", "in", projectIds);
        qFilter.and("isvalid", "=", (Object)true);
        qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
        DynamicObject[] totalBudgetBills = BusinessDataServiceHelper.load((String)"pmas_totalbudget", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        if (totalBudgetBills.length > 0) {
            totalBudgetPros = Arrays.stream(totalBudgetBills).map(o -> Long.parseLong(o.getDynamicObject("project").getPkValue().toString())).collect(Collectors.toSet());
        }
        List<DynamicObject> totalBudgetCtrlList = DataUpgradeHelper.doUpdateTBudgetCtrlByTBudgetBill(totalBudgetBills, budgetExcMap, yearBudgetCtrlList, resultList);
        Set<Long> yearBudgetProIds = new HashSet<Long>();
        qFilter = new QFilter("project", "in", projectIds);
        qFilter.and("isvalid", "=", (Object)true);
        qFilter.and("sourcetype", "!=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
        DynamicObject[] yearBudgetBills = BusinessDataServiceHelper.load((String)"pmas_totalbudget", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        if (yearBudgetBills.length > 0) {
            yearBudgetProIds = Arrays.stream(yearBudgetBills).map(o -> Long.parseLong(o.getDynamicObject("project").getPkValue().toString())).collect(Collectors.toSet());
        }
        if (!totalBudgetPros.isEmpty() && !yearBudgetProIds.isEmpty()) {
            yearBudgetProIds.removeAll(totalBudgetPros);
        }
        if (!(tBudgetCtrlList = DataUpgradeHelper.doUpdateTBudgetCtrlByYBudgetCtrl(proApprovals, yearBudgetProIds, budgetExcMap, yearBudgetCtrlList, resultList)).isEmpty()) {
            totalBudgetCtrlList.addAll(tBudgetCtrlList);
        }
        Set<Long> inBudgetProIds = new HashSet<Long>();
        qFilter = new QFilter("project", "in", projectIds);
        qFilter.and("isvalid", "=", (Object)true);
        qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.IN.getValue());
        DynamicObject[] inBudgetBills = BusinessDataServiceHelper.load((String)"pmas_inbudget", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        if (inBudgetBills.length > 0) {
            inBudgetProIds = Arrays.stream(inBudgetBills).map(o -> Long.parseLong(o.getDynamicObject("project").getPkValue().toString())).collect(Collectors.toSet());
        }
        if (!totalBudgetPros.isEmpty() && !inBudgetProIds.isEmpty()) {
            inBudgetProIds.retainAll(totalBudgetPros);
        }
        if (!(totalInBudgetCtrlList = DataUpgradeHelper.doUpdateInTBudgetCtrlByYBudgetCtrl(proApprovals, inBudgetProIds, budgetExcMap, yearBudgetCtrlList, resultList)).isEmpty()) {
            totalBudgetCtrlList.addAll(totalInBudgetCtrlList);
        }
        return totalBudgetCtrlList;
    }

    public static List<DynamicObject> doUpdateYearBudgetCtrlInfo(List<Long> projectIds, Map<String, List<DynamicObject>> budgetExcMap, List<ExcelUtil.ExcelVo> resultList) {
        ArrayList<DynamicObject> yearBudgetCtrlList = new ArrayList<DynamicObject>();
        String selectProperties = String.join((CharSequence)",", "project", "sourcetype", "year", "currency", "totalyearamt", "totalamount", "treeentryentity", "projectbudgetitem", "budgetamount", "budgetitem");
        QFilter qFilter = new QFilter("project", "in", projectIds);
        qFilter.and("isvalid", "=", (Object)true);
        qFilter.and("sourcetype", "!=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
        DynamicObject[] yearBudgetBills = BusinessDataServiceHelper.load((String)"pmas_budget", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        if (yearBudgetBills.length == 0) {
            return yearBudgetCtrlList;
        }
        qFilter = new QFilter("pro", "in", projectIds);
        DynamicObject[] approvals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "proyearbudgetamt", "pro"), (QFilter[])new QFilter[]{qFilter});
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_ybudgetctrl");
        for (DynamicObject yearBudgetBill : yearBudgetBills) {
            Date yearDate;
            List<DynamicObject> excRecords;
            boolean allowUpdate = true;
            DynamicObject yearBudgetCtrl = new DynamicObject((DynamicObjectType)dt);
            yearBudgetCtrl.set("ybudgettype", (Object)yearBudgetBill.getString("sourcetype"));
            DynamicObject project = yearBudgetBill.getDynamicObject("project");
            yearBudgetCtrl.set("yproject", (Object)project);
            yearBudgetCtrl.set("yyear", (Object)yearBudgetBill.getDate("year"));
            yearBudgetCtrl.set("ycurrency", (Object)yearBudgetBill.getDynamicObject("currency"));
            if (approvals.length > 0) {
                String projectId = project.getPkValue().toString();
                Optional<DynamicObject> approval = Arrays.stream(approvals).filter(o -> StringUtils.equals((CharSequence)projectId, (CharSequence)o.getDynamicObject("pro").getPkValue().toString())).findFirst();
                if (approval.isPresent()) {
                    BigDecimal totalYearAmt = approval.get().getBigDecimal("proyearbudgetamt");
                    yearBudgetCtrl.set("yearproamt", (Object)totalYearAmt);
                }
            }
            yearBudgetCtrl.set("ybudgetamt", (Object)yearBudgetBill.getBigDecimal("totalamount"));
            yearBudgetCtrl.set("yoricurrency", (Object)yearBudgetBill.getDynamicObject("currency"));
            yearBudgetCtrl.set("yearprooriamt", (Object)yearBudgetCtrl.getBigDecimal("yearproamt"));
            yearBudgetCtrl.set("ybudgetoriamt", (Object)yearBudgetBill.getBigDecimal("totalamount"));
            String sourceType = yearBudgetBill.getString("sourcetype");
            if (!budgetExcMap.isEmpty() && (excRecords = budgetExcMap.get(yearBudgetBill.getDynamicObject("project").getPkValue().toString())) != null && !excRecords.isEmpty() && (yearDate = yearBudgetBill.getDate("year")) != null) {
                int year = yearDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                BigDecimal preOccupyUsageAmt = excRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)sourceType, (CharSequence)o.getString("budgettype"))).filter(o -> o.getDate("year") != null && o.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear() == year).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                yearBudgetCtrl.set("ypreoccupyusageamt", (Object)preOccupyUsageAmt);
                BigDecimal usageAmt = excRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)sourceType, (CharSequence)o.getString("budgettype"))).filter(o -> o.getDate("year") != null && o.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear() == year).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                yearBudgetCtrl.set("yusageamt", (Object)usageAmt);
            }
            if (!StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)sourceType)) {
                Map<String, BigDecimal> budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(null, null, true, project);
                BigDecimal remindRate = budgetParamMap.get("remindrate");
                BigDecimal controlRate = budgetParamMap.get("controlrate");
                yearBudgetCtrl.set("yremindrate", (Object)remindRate);
                yearBudgetCtrl.set("ycontrolrate", (Object)controlRate);
            }
            BigDecimal sumUseAmt = BigDecimal.ZERO;
            DynamicObjectCollection treeEntryEntity = yearBudgetBill.getDynamicObjectCollection("treeentryentity");
            if (!treeEntryEntity.isEmpty()) {
                Map controlRateMap = BudgetControlHelper.getControlRateMap((Long)project.getLong("id"));
                DynamicObjectCollection budgetCtrlDetails = yearBudgetCtrl.getDynamicObjectCollection("ybudgetctrldetail");
                DynamicObjectType detailDt = budgetCtrlDetails.getDynamicObjectType();
                for (DynamicObject budgetEntryObj : treeEntryEntity) {
                    DynamicObject projectBudgetItem = budgetEntryObj.getDynamicObject("projectbudgetitem");
                    if (projectBudgetItem == null) {
                        DynamicObject budgetItem = budgetEntryObj.getDynamicObject("budgetitem");
                        if (budgetItem == null) {
                            allowUpdate = false;
                            DataUpgradeHelper.updateResultInfo(resultList, project);
                            break;
                        }
                        String proBudgetType = StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)sourceType) ? "IN" : "OUT";
                        String budgetItemId = budgetItem.getPkValue().toString();
                        qFilter = new QFilter("budgetitem", "=", (Object)Long.parseLong(budgetItemId));
                        qFilter.and("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                        qFilter.and("sourcetype", "=", (Object)proBudgetType);
                        DynamicObject[] proBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"id", (QFilter[])new QFilter[]{qFilter});
                        if (proBudgets.length != 1) {
                            allowUpdate = false;
                            DataUpgradeHelper.updateResultInfo(resultList, project);
                            break;
                        }
                        projectBudgetItem = proBudgets[0];
                    }
                    if (projectBudgetItem != null) {
                        projectBudgetItem = BusinessDataServiceHelper.loadSingle((Object)projectBudgetItem.getPkValue(), (String)"pmas_projectbudget");
                    }
                    DynamicObject budgetCtrlDetail = new DynamicObject(detailDt);
                    budgetCtrlDetail.set("budget", (Object)projectBudgetItem);
                    budgetCtrlDetail.set("budgettype", (Object)sourceType);
                    budgetCtrlDetail.set("project", (Object)project);
                    budgetCtrlDetail.set("budgetitem", (Object)budgetEntryObj.getDynamicObject("budgetitem"));
                    budgetCtrlDetail.set("year", (Object)yearBudgetBill.getDate("year"));
                    budgetCtrlDetail.set("oricurrency", (Object)yearBudgetBill.getDynamicObject("currency"));
                    budgetCtrlDetail.set("budgetoriamt", (Object)budgetEntryObj.getBigDecimal("budgetamount"));
                    budgetCtrlDetail.set("currency", (Object)yearBudgetBill.getDynamicObject("currency"));
                    budgetCtrlDetail.set("budgetamt", (Object)budgetEntryObj.getBigDecimal("budgetamount"));
                    if (projectBudgetItem != null) {
                        Date yearDate2;
                        List<DynamicObject> excRecords2;
                        long projectBudgetItemId = Long.parseLong(projectBudgetItem.getPkValue().toString());
                        if (!budgetExcMap.isEmpty() && (excRecords2 = budgetExcMap.get(yearBudgetBill.getDynamicObject("project").getPkValue().toString())) != null && !excRecords2.isEmpty() && (yearDate2 = yearBudgetBill.getDate("year")) != null) {
                            int year = yearDate2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                            BigDecimal preOccupyUsageAmt = excRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)sourceType, (CharSequence)o.getString("budgettype"))).filter(o -> o.getDate("year") != null && o.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear() == year).filter(o -> o.getDynamicObject("probudget") != null && Long.parseLong(o.getDynamicObject("probudget").getPkValue().toString()) == projectBudgetItemId).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                            budgetCtrlDetail.set("preoccupyusageamt", (Object)preOccupyUsageAmt);
                            BigDecimal usageAmt = excRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)sourceType, (CharSequence)o.getString("budgettype"))).filter(o -> o.getDate("year") != null && o.getDate("year").toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear() == year).filter(o -> o.getDynamicObject("probudget") != null && Long.parseLong(o.getDynamicObject("probudget").getPkValue().toString()) == projectBudgetItemId).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                            budgetCtrlDetail.set("usageamt", (Object)usageAmt);
                            sumUseAmt = sumUseAmt.add(usageAmt);
                        }
                    }
                    if (!StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)sourceType)) {
                        Map<String, BigDecimal> budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(controlRateMap, projectBudgetItem, false, project);
                        BigDecimal remindRate = budgetParamMap.get("remindrate");
                        budgetCtrlDetail.set("remindrate", (Object)remindRate);
                        BigDecimal controlRate = budgetParamMap.get("controlrate");
                        budgetCtrlDetail.set("controlrate", (Object)controlRate);
                    }
                    budgetCtrlDetails.add((Object)budgetCtrlDetail);
                }
            }
            ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
            vo.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
            vo.setBillNo(project.getString("number"));
            BigDecimal usageAmt = yearBudgetCtrl.getBigDecimal("yusageamt");
            if (usageAmt.compareTo(sumUseAmt) != 0) {
                allowUpdate = false;
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9879\u76ee\u5e74\u5ea6\u9884\u7b97\u63a7\u5236\u660e\u7ec6\u8868\u4f7f\u7528\u6570\u636e\u4e0e\u9879\u76ee\u5e74\u5ea6\u9884\u7b97\u63a7\u5236\u8868\u4f7f\u7528\u6570\u636e\u4e0d\u76f8\u7b26\uff0c\u6570\u636e\u53ef\u80fd\u5b58\u5728\u504f\u5dee\uff0c\u8bf7\u6392\u67e5\u3002", (String)"DataUpgradeHelper_8", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                resultList.add(vo);
            }
            if (!allowUpdate) continue;
            Optional<ExcelUtil.ExcelVo> first = resultList.stream().filter(o -> StringUtils.equals((CharSequence)o.getType(), (CharSequence)UpgradeTypeEnum.SUCCESS.getName())).filter(o -> StringUtils.equals((CharSequence)o.getBillNo(), (CharSequence)project.getString("number"))).findFirst();
            if (!first.isPresent()) {
                vo.setType(UpgradeTypeEnum.SUCCESS);
                String messageTip = StringUtils.equals((CharSequence)sourceType, (CharSequence)"IN") ? ResManager.loadKDString((String)"\u5e74\u5ea6\u6536\u5165\u9884\u7b97\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"DataUpgradeHelper_27", (String)"pmgt-pmbs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e74\u5ea6\u652f\u51fa\u9884\u7b97\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"DataUpgradeHelper_28", (String)"pmgt-pmbs-business", (Object[])new Object[0]);
                vo.setMessage(messageTip);
                resultList.add(vo);
            }
            yearBudgetCtrlList.add(yearBudgetCtrl);
        }
        return yearBudgetCtrlList;
    }

    private static void updateResultInfo(List<ExcelUtil.ExcelVo> resultList, DynamicObject project) {
        ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
        vo.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
        vo.setBillNo(project.getString("number"));
        vo.setType(UpgradeTypeEnum.ERROR);
        vo.setMessage(ResManager.loadKDString((String)"\u9879\u76ee\u9700\u8981\u5148\u8fdb\u884c\u9879\u76ee\u9884\u7b97\u9879\u5173\u7cfb\u6620\u5c04\uff0c\u624d\u80fd\u8fdb\u884c\u9884\u7b97\u5347\u7ea7\u3002", (String)"DataUpgradeHelper_17", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        resultList.add(vo);
    }

    private static void rejectYearBudgetCtrl(DynamicObject project, List<DynamicObject> yearBudgetCtrlList, List<ExcelUtil.ExcelVo> resultList) {
        if (resultList.size() > 0) {
            for (ExcelUtil.ExcelVo vo : resultList) {
                if (!StringUtils.equals((CharSequence)vo.getType(), (CharSequence)UpgradeTypeEnum.SUCCESS.getName()) || !StringUtils.equals((CharSequence)vo.getBillNo(), (CharSequence)project.getString("number"))) continue;
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(ResManager.loadKDString((String)"\u5e74\u5ea6\u652f\u51fa\u9884\u7b97\u6570\u636e\u5347\u7ea7\u5931\u8d25\u3002", (String)"DataUpgradeHelper_24", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
            }
        }
        String projectId = project.getPkValue().toString();
        if (!yearBudgetCtrlList.isEmpty()) {
            Iterator<DynamicObject> iterator = yearBudgetCtrlList.iterator();
            while (iterator.hasNext()) {
                DynamicObject yearBudgetCtrl = iterator.next();
                DynamicObject budgetPro = yearBudgetCtrl.getDynamicObject("yproject");
                if (budgetPro == null || !StringUtils.equals((CharSequence)projectId, (CharSequence)budgetPro.getPkValue().toString())) continue;
                iterator.remove();
            }
        }
    }

    public static List<DynamicObject> doUpdateTBudgetCtrlByTBudgetBill(DynamicObject[] totalBudgetBills, Map<String, List<DynamicObject>> budgetExcMap, List<DynamicObject> yearBudgetCtrlList, List<ExcelUtil.ExcelVo> resultList) {
        ArrayList<DynamicObject> totalBudgetCtrlList = new ArrayList<DynamicObject>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_totalbudgetctrl");
        for (DynamicObject totalBudgetBill : totalBudgetBills) {
            ExcelUtil.ExcelVo vo;
            List<DynamicObject> budgetExcRecords;
            DynamicObject totalBudgetCtrl = new DynamicObject((DynamicObjectType)dt);
            DynamicObject project = totalBudgetBill.getDynamicObject("project");
            if (project == null) continue;
            boolean allowUpdate = true;
            totalBudgetCtrl.set("tbudgettype", (Object)BudgetSourceTypeEnum.OUT.getValue());
            totalBudgetCtrl.set("tproject", (Object)project);
            totalBudgetCtrl.set("tcurrency", (Object)totalBudgetBill.getDynamicObject("currency"));
            totalBudgetCtrl.set("proappamt", (Object)totalBudgetBill.getBigDecimal("proapprovalamt"));
            totalBudgetCtrl.set("tbudgetamt", (Object)totalBudgetBill.getBigDecimal("totalamount"));
            BigDecimal sumBudAmt = BigDecimal.ZERO;
            if (!yearBudgetCtrlList.isEmpty()) {
                String projectId = project.getPkValue().toString();
                sumBudAmt = yearBudgetCtrlList.stream().filter(o -> StringUtils.equals((CharSequence)projectId, (CharSequence)o.getDynamicObject("yproject").getPkValue().toString())).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("ybudgettype"))).map(o -> o.getBigDecimal("ybudgetamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            totalBudgetCtrl.set("tsumbudamt", (Object)sumBudAmt);
            totalBudgetCtrl.set("toricurrency", (Object)totalBudgetBill.getDynamicObject("currency"));
            totalBudgetCtrl.set("proapporiamt", (Object)totalBudgetBill.getBigDecimal("proapprovalamt"));
            totalBudgetCtrl.set("tbudgetoriamt", (Object)totalBudgetBill.getBigDecimal("totalamount"));
            totalBudgetCtrl.set("tsumbudoriamt", (Object)sumBudAmt);
            BigDecimal preOccupyAmt = BigDecimal.ZERO;
            BigDecimal occupyAmt = BigDecimal.ZERO;
            BigDecimal preOccupyUsageAmt = BigDecimal.ZERO;
            BigDecimal usageAmt = BigDecimal.ZERO;
            String projectId = project.getPkValue().toString();
            if (!budgetExcMap.isEmpty() && (budgetExcRecords = budgetExcMap.get(projectId)) != null && !budgetExcRecords.isEmpty()) {
                preOccupyAmt = budgetExcRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.TAKEOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                occupyAmt = budgetExcRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.TAKEOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                preOccupyUsageAmt = budgetExcRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                usageAmt = budgetExcRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            totalBudgetCtrl.set("tpreoccupyamt", (Object)preOccupyAmt);
            totalBudgetCtrl.set("toccupyamt", (Object)occupyAmt);
            totalBudgetCtrl.set("tpreoccupyusageamt", (Object)preOccupyUsageAmt);
            totalBudgetCtrl.set("tusageamt", (Object)usageAmt);
            ProBudgetCtrlEnums budgetControlType = ProBudgetControlHelper.getProjectBudgetControlType(project);
            Map<String, BigDecimal> budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(null, null, true, project);
            if (!budgetParamMap.isEmpty()) {
                BigDecimal totalRemindRate = budgetParamMap.get("remindrate");
                BigDecimal totalControlRate = budgetParamMap.get("controlrate");
                totalBudgetCtrl.set("tremindrate", (Object)totalRemindRate);
                totalBudgetCtrl.set("tcontrolrate", (Object)totalControlRate);
            }
            BigDecimal sumOccupyAmt = BigDecimal.ZERO;
            BigDecimal sumUseAmt = BigDecimal.ZERO;
            DynamicObjectCollection treeEntryEntity = totalBudgetBill.getDynamicObjectCollection("treeentryentity");
            if (treeEntryEntity.isEmpty()) continue;
            Map controlRateMap = BudgetControlHelper.getControlRateMap((Long)project.getLong("id"));
            DynamicObjectCollection budgetCtrlDetails = totalBudgetCtrl.getDynamicObjectCollection("tbudgetctrldetail");
            DynamicObjectType detailDt = budgetCtrlDetails.getDynamicObjectType();
            for (DynamicObject budgetEntryObj : treeEntryEntity) {
                DynamicObject projectBudgetItem = budgetEntryObj.getDynamicObject("projectbudgetitem");
                if (projectBudgetItem == null) {
                    DynamicObject budgetItem = budgetEntryObj.getDynamicObject("budgetitem");
                    if (budgetItem == null) {
                        allowUpdate = false;
                        DataUpgradeHelper.updateResultInfo(resultList, project);
                        DataUpgradeHelper.rejectYearBudgetCtrl(project, yearBudgetCtrlList, resultList);
                        break;
                    }
                    String budgetItemId = budgetItem.getPkValue().toString();
                    QFilter qFilter = new QFilter("budgetitem", "=", (Object)Long.parseLong(budgetItemId));
                    qFilter.and("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                    qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
                    DynamicObject[] proBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (proBudgets.length != 1) {
                        allowUpdate = false;
                        DataUpgradeHelper.updateResultInfo(resultList, project);
                        DataUpgradeHelper.rejectYearBudgetCtrl(project, yearBudgetCtrlList, resultList);
                        break;
                    }
                    projectBudgetItem = proBudgets[0];
                }
                if (projectBudgetItem != null) {
                    projectBudgetItem = BusinessDataServiceHelper.loadSingle((Object)projectBudgetItem.getPkValue(), (String)"pmas_projectbudget");
                }
                DynamicObject budgetCtrlDetail = new DynamicObject(detailDt);
                budgetCtrlDetail.set("budget", (Object)projectBudgetItem);
                budgetCtrlDetail.set("budgettype", (Object)BudgetSourceTypeEnum.OUT.getValue());
                budgetCtrlDetail.set("project", (Object)project);
                budgetCtrlDetail.set("budgetitem", (Object)budgetEntryObj.getDynamicObject("budgetitem"));
                budgetCtrlDetail.set("oricurrency", (Object)totalBudgetBill.getDynamicObject("currency"));
                budgetCtrlDetail.set("budgetoriamt", (Object)budgetEntryObj.getBigDecimal("budgetamount"));
                budgetCtrlDetail.set("currency", (Object)totalBudgetBill.getDynamicObject("currency"));
                budgetCtrlDetail.set("budgetamt", (Object)budgetEntryObj.getBigDecimal("budgetamount"));
                BigDecimal detailPreOccupyAmt = BigDecimal.ZERO;
                BigDecimal detailOccupyAmt = BigDecimal.ZERO;
                BigDecimal detailPreUsageAmt = BigDecimal.ZERO;
                BigDecimal detailUsageAmt = BigDecimal.ZERO;
                if (projectBudgetItem != null) {
                    List<DynamicObject> budgetExcRecords2;
                    String projectBudgetItemId = projectBudgetItem.getPkValue().toString();
                    sumBudAmt = BigDecimal.ZERO;
                    if (!yearBudgetCtrlList.isEmpty()) {
                        for (DynamicObject yearBudgetCtrl : yearBudgetCtrlList) {
                            DynamicObjectCollection details = yearBudgetCtrl.getDynamicObjectCollection("ybudgetctrldetail");
                            if (details.isEmpty()) continue;
                            BigDecimal proBudgetAmt = details.stream().filter(o -> o.getDynamicObject("budget") != null).filter(o -> o.getDynamicObject("budget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("budget").getPkValue().toString())).map(o -> o.getBigDecimal("budgetamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                            sumBudAmt = sumBudAmt.add(proBudgetAmt);
                        }
                    }
                    budgetCtrlDetail.set("sumbudamt", (Object)sumBudAmt);
                    budgetCtrlDetail.set("sumbudoriamt", (Object)sumBudAmt);
                    if (!budgetExcMap.isEmpty() && (budgetExcRecords2 = budgetExcMap.get(projectId)) != null && !budgetExcRecords2.isEmpty()) {
                        detailPreOccupyAmt = budgetExcRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.TAKEOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).filter(o -> o.getDynamicObject("probudget") != null).filter(o -> o.getDynamicObject("probudget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("probudget").getPkValue().toString())).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        detailOccupyAmt = budgetExcRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.TAKEOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).filter(o -> o.getDynamicObject("probudget") != null).filter(o -> o.getDynamicObject("probudget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("probudget").getPkValue().toString())).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        detailPreUsageAmt = budgetExcRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).filter(o -> o.getDynamicObject("probudget") != null).filter(o -> o.getDynamicObject("probudget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("probudget").getPkValue().toString())).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        detailUsageAmt = budgetExcRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).filter(o -> o.getDynamicObject("probudget") != null).filter(o -> o.getDynamicObject("probudget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("probudget").getPkValue().toString())).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    }
                }
                budgetCtrlDetail.set("preoccupyamt", (Object)detailPreOccupyAmt);
                budgetCtrlDetail.set("occupyamt", (Object)detailOccupyAmt);
                budgetCtrlDetail.set("preoccupyusageamt", (Object)detailPreUsageAmt);
                budgetCtrlDetail.set("usageamt", (Object)detailUsageAmt);
                sumOccupyAmt = sumOccupyAmt.add(detailOccupyAmt);
                sumUseAmt = sumUseAmt.add(detailUsageAmt);
                budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(controlRateMap, projectBudgetItem, false, project);
                BigDecimal remindRate = budgetParamMap.get("remindrate");
                budgetCtrlDetail.set("remindrate", (Object)remindRate);
                BigDecimal controlRate = budgetParamMap.get("controlrate");
                budgetCtrlDetail.set("controlrate", (Object)controlRate);
                budgetCtrlDetails.add((Object)budgetCtrlDetail);
            }
            if (occupyAmt.compareTo(sumOccupyAmt) != 0) {
                allowUpdate = false;
                vo = new ExcelUtil.ExcelVo();
                vo.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
                vo.setBillNo(project.getString("number"));
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9879\u76ee\u603b\u4f53\u9884\u7b97\u63a7\u5236\u660e\u7ec6\u8868\u5360\u7528\u6570\u636e\u4e0e\u9879\u76ee\u603b\u4f53\u9884\u7b97\u63a7\u5236\u8868\u5360\u7528\u6570\u636e\u4e0d\u76f8\u7b26\uff0c\u6570\u636e\u53ef\u80fd\u5b58\u5728\u504f\u5dee\uff0c\u8bf7\u6392\u67e5\u3002", (String)"DataUpgradeHelper_10", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                resultList.add(vo);
                DataUpgradeHelper.rejectYearBudgetCtrl(project, yearBudgetCtrlList, resultList);
            }
            if (usageAmt.compareTo(sumUseAmt) != 0) {
                allowUpdate = false;
                vo = new ExcelUtil.ExcelVo();
                vo.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
                vo.setBillNo(project.getString("number"));
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9879\u76ee\u603b\u4f53\u9884\u7b97\u63a7\u5236\u660e\u7ec6\u8868\u4f7f\u7528\u6570\u636e\u4e0e\u9879\u76ee\u603b\u4f53\u9884\u7b97\u63a7\u5236\u8868\u4f7f\u7528\u6570\u636e\u4e0d\u76f8\u7b26\uff0c\u6570\u636e\u53ef\u80fd\u5b58\u5728\u504f\u5dee\uff0c\u8bf7\u6392\u67e5\u3002", (String)"DataUpgradeHelper_11", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                resultList.add(vo);
                DataUpgradeHelper.rejectYearBudgetCtrl(project, yearBudgetCtrlList, resultList);
            }
            if (!allowUpdate) continue;
            Optional<ExcelUtil.ExcelVo> first = resultList.stream().filter(o -> StringUtils.equals((CharSequence)o.getType(), (CharSequence)UpgradeTypeEnum.SUCCESS.getName())).filter(o -> StringUtils.equals((CharSequence)o.getBillNo(), (CharSequence)project.getString("number"))).findFirst();
            if (!first.isPresent()) {
                ExcelUtil.ExcelVo vo2 = new ExcelUtil.ExcelVo();
                vo2.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
                vo2.setBillNo(project.getString("number"));
                vo2.setType(UpgradeTypeEnum.SUCCESS);
                vo2.setMessage(ResManager.loadKDString((String)"\u603b\u4f53\u652f\u51fa\u9884\u7b97\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"DataUpgradeHelper_25", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                resultList.add(vo2);
            }
            totalBudgetCtrlList.add(totalBudgetCtrl);
        }
        return totalBudgetCtrlList;
    }

    public static List<DynamicObject> doUpdateTBudgetCtrlByYBudgetCtrl(DynamicObject[] proApprovals, Set<Long> yearBudgetProIds, Map<String, List<DynamicObject>> budgetExcMap, List<DynamicObject> yearBudgetCtrlList, List<ExcelUtil.ExcelVo> resultList) {
        List<DynamicObject> inTBudgetCtrlList;
        ArrayList<DynamicObject> totalBudgetCtrlList = new ArrayList<DynamicObject>();
        if (yearBudgetCtrlList.isEmpty()) {
            return totalBudgetCtrlList;
        }
        List<DynamicObject> outTBudgetCtrlList = DataUpgradeHelper.doUpdateOutTBudgetCtrlByYBudgetCtrl(proApprovals, yearBudgetProIds, budgetExcMap, yearBudgetCtrlList, resultList);
        if (!outTBudgetCtrlList.isEmpty()) {
            totalBudgetCtrlList.addAll(outTBudgetCtrlList);
        }
        if (!(inTBudgetCtrlList = DataUpgradeHelper.doUpdateInTBudgetCtrlByYBudgetCtrl(proApprovals, yearBudgetProIds, budgetExcMap, yearBudgetCtrlList, resultList)).isEmpty()) {
            totalBudgetCtrlList.addAll(inTBudgetCtrlList);
        }
        return totalBudgetCtrlList;
    }

    public static List<DynamicObject> doUpdateOutTBudgetCtrlByYBudgetCtrl(DynamicObject[] proApprovals, Set<Long> yearBudgetProIds, Map<String, List<DynamicObject>> budgetExcMap, List<DynamicObject> yearBudgetCtrlList, List<ExcelUtil.ExcelVo> resultList) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_totalbudgetctrl");
        ArrayList<DynamicObject> totalBudgetCtrlList = new ArrayList<DynamicObject>();
        for (Long yearBudgetProId : yearBudgetProIds) {
            ExcelUtil.ExcelVo vo;
            List<DynamicObject> budgetExcRecords;
            Optional<DynamicObject> first;
            List curProOutYBudgetCtrlList = yearBudgetCtrlList.stream().filter(o -> o.getDynamicObject("yproject").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("ybudgettype"))).filter(o -> yearBudgetProId == Long.parseLong(o.getDynamicObject("yproject").getPkValue().toString())).collect(Collectors.toList());
            if (curProOutYBudgetCtrlList.isEmpty()) continue;
            boolean allowUpdate = true;
            DynamicObject totalBudgetCtrl = new DynamicObject((DynamicObjectType)dt);
            totalBudgetCtrl.set("tbudgettype", (Object)BudgetSourceTypeEnum.OUT.getValue());
            totalBudgetCtrl.set("tproject", (Object)((DynamicObject)curProOutYBudgetCtrlList.get(0)).getDynamicObject("yproject"));
            totalBudgetCtrl.set("tcurrency", (Object)((DynamicObject)curProOutYBudgetCtrlList.get(0)).getDynamicObject("ycurrency"));
            if (proApprovals.length > 0 && (first = Arrays.stream(proApprovals).filter(o -> yearBudgetProId == Long.parseLong(o.getDynamicObject("pro").getPkValue().toString())).findFirst()).isPresent()) {
                totalBudgetCtrl.set("proappamt", (Object)first.get().getBigDecimal("projcetbugamt"));
                totalBudgetCtrl.set("tproject", (Object)first.get().getDynamicObject("pro"));
                totalBudgetCtrl.set("tcurrency", (Object)first.get().getDynamicObject("currencyfield"));
            }
            BigDecimal sumBudgetAmt = curProOutYBudgetCtrlList.stream().map(o -> o.getBigDecimal("ybudgetamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            totalBudgetCtrl.set("tsumbudamt", (Object)sumBudgetAmt);
            totalBudgetCtrl.set("tbudgetamt", (Object)sumBudgetAmt);
            totalBudgetCtrl.set("toricurrency", (Object)totalBudgetCtrl.getDynamicObject("tcurrency"));
            totalBudgetCtrl.set("proapporiamt", (Object)totalBudgetCtrl.getBigDecimal("proappamt"));
            totalBudgetCtrl.set("tbudgetoriamt", (Object)sumBudgetAmt);
            totalBudgetCtrl.set("tbudgetoriamt", (Object)sumBudgetAmt);
            BigDecimal preOccupyAmt = BigDecimal.ZERO;
            BigDecimal occupyAmt = BigDecimal.ZERO;
            BigDecimal preOccupyUsageAmt = BigDecimal.ZERO;
            BigDecimal usageAmt = BigDecimal.ZERO;
            if (!budgetExcMap.isEmpty() && (budgetExcRecords = budgetExcMap.get(String.valueOf(yearBudgetProId))) != null && !budgetExcRecords.isEmpty()) {
                preOccupyAmt = budgetExcRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.TAKEOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                occupyAmt = budgetExcRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.TAKEOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                preOccupyUsageAmt = budgetExcRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                usageAmt = budgetExcRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            totalBudgetCtrl.set("tpreoccupyamt", (Object)preOccupyAmt);
            totalBudgetCtrl.set("toccupyamt", (Object)occupyAmt);
            totalBudgetCtrl.set("tpreoccupyusageamt", (Object)preOccupyUsageAmt);
            totalBudgetCtrl.set("tusageamt", (Object)usageAmt);
            DynamicObject currency = totalBudgetCtrl.getDynamicObject("tcurrency");
            Map<String, BigDecimal> budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(null, null, true, totalBudgetCtrl.getDynamicObject("tproject"));
            if (!budgetParamMap.isEmpty()) {
                BigDecimal totalRemindRate = budgetParamMap.get("remindrate");
                BigDecimal totalControlRate = budgetParamMap.get("controlrate");
                totalBudgetCtrl.set("tremindrate", (Object)totalRemindRate);
                totalBudgetCtrl.set("tcontrolrate", (Object)totalControlRate);
            }
            HashMap<String, ArrayList<DynamicObject>> yBudgetDetailMap = new HashMap<String, ArrayList<DynamicObject>>();
            for (DynamicObject curProOutYBudgetCtrl : curProOutYBudgetCtrlList) {
                DynamicObjectCollection details = curProOutYBudgetCtrl.getDynamicObjectCollection("ybudgetctrldetail");
                if (details.isEmpty()) continue;
                for (DynamicObject detail : details) {
                    DynamicObject budget = detail.getDynamicObject("budget");
                    if (budget == null) continue;
                    String budgetId = budget.getPkValue().toString();
                    ArrayList<DynamicObject> yBudgetDetailList = (ArrayList<DynamicObject>)yBudgetDetailMap.get(budgetId);
                    if (yBudgetDetailList == null) {
                        yBudgetDetailList = new ArrayList<DynamicObject>();
                    }
                    yBudgetDetailList.add(detail);
                    yBudgetDetailMap.put(budgetId, yBudgetDetailList);
                }
            }
            BigDecimal sumOccupyAmt = BigDecimal.ZERO;
            BigDecimal sumUseAmt = BigDecimal.ZERO;
            DynamicObject project = totalBudgetCtrl.getDynamicObject("tproject");
            Map controlRateMap = BudgetControlHelper.getControlRateMap((Long)project.getLong("id"));
            if (!yBudgetDetailMap.isEmpty()) {
                DynamicObjectCollection budgetCtrlDetails = totalBudgetCtrl.getDynamicObjectCollection("tbudgetctrldetail");
                DynamicObjectType entryDt = budgetCtrlDetails.getDynamicObjectType();
                Set entries = yBudgetDetailMap.entrySet();
                for (Map.Entry yBudgetDetail : entries) {
                    List<DynamicObject> budgetExcRecords2;
                    List yBudgetDetailList = (List)yBudgetDetail.getValue();
                    if (yBudgetDetailList.isEmpty()) continue;
                    DynamicObject budgetCtrlDetail = new DynamicObject(entryDt);
                    budgetCtrlDetail.set("budget", (Object)((DynamicObject)yBudgetDetailList.get(0)).getDynamicObject("budget"));
                    budgetCtrlDetail.set("budgetitem", (Object)((DynamicObject)yBudgetDetailList.get(0)).getDynamicObject("budgetitem"));
                    budgetCtrlDetail.set("budgettype", (Object)BudgetSourceTypeEnum.OUT.getValue());
                    budgetCtrlDetail.set("project", (Object)totalBudgetCtrl.getDynamicObject("tproject"));
                    budgetCtrlDetail.set("currency", (Object)totalBudgetCtrl.getDynamicObject("tcurrency"));
                    budgetCtrlDetail.set("oricurrency", (Object)totalBudgetCtrl.getDynamicObject("toricurrency"));
                    sumBudgetAmt = yBudgetDetailList.stream().map(o -> o.getBigDecimal("budgetamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    budgetCtrlDetail.set("sumbudamt", (Object)sumBudgetAmt);
                    budgetCtrlDetail.set("sumbudoriamt", (Object)sumBudgetAmt);
                    budgetCtrlDetail.set("budgetamt", (Object)sumBudgetAmt);
                    budgetCtrlDetail.set("budgetoriamt", (Object)sumBudgetAmt);
                    BigDecimal detailPreOccupyAmt = BigDecimal.ZERO;
                    BigDecimal detailOccupyAmt = BigDecimal.ZERO;
                    BigDecimal detailPreUsageAmt = BigDecimal.ZERO;
                    BigDecimal detailUsageAmt = BigDecimal.ZERO;
                    String projectBudgetItemId = budgetCtrlDetail.getDynamicObject("budget").getPkValue().toString();
                    if (!budgetExcMap.isEmpty() && (budgetExcRecords2 = budgetExcMap.get(String.valueOf(yearBudgetProId))) != null && !budgetExcRecords2.isEmpty()) {
                        detailPreOccupyAmt = budgetExcRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.TAKEOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).filter(o -> o.getDynamicObject("probudget") != null).filter(o -> o.getDynamicObject("probudget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("probudget").getPkValue().toString())).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        detailOccupyAmt = budgetExcRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.TAKEOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).filter(o -> o.getDynamicObject("probudget") != null).filter(o -> o.getDynamicObject("probudget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("probudget").getPkValue().toString())).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        detailPreUsageAmt = budgetExcRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).filter(o -> o.getDynamicObject("probudget") != null).filter(o -> o.getDynamicObject("probudget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("probudget").getPkValue().toString())).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        detailUsageAmt = budgetExcRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.OUT.getValue(), (CharSequence)o.getString("budgettype"))).filter(o -> o.getDynamicObject("probudget") != null).filter(o -> o.getDynamicObject("probudget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("probudget").getPkValue().toString())).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    }
                    budgetCtrlDetail.set("preoccupyamt", (Object)detailPreOccupyAmt);
                    budgetCtrlDetail.set("occupyamt", (Object)detailOccupyAmt);
                    budgetCtrlDetail.set("preoccupyusageamt", (Object)detailPreUsageAmt);
                    budgetCtrlDetail.set("usageamt", (Object)detailUsageAmt);
                    sumOccupyAmt = sumOccupyAmt.add(detailOccupyAmt);
                    sumUseAmt = sumUseAmt.add(detailUsageAmt);
                    DynamicObject projectBudgetItem = budgetCtrlDetail.getDynamicObject("budget");
                    budgetParamMap = ProBudgetControlHelper.getProjectBudgetControlRate(controlRateMap, projectBudgetItem, false, project);
                    BigDecimal remindRate = budgetParamMap.get("remindrate");
                    budgetCtrlDetail.set("remindrate", (Object)remindRate);
                    BigDecimal controlRate = budgetParamMap.get("controlrate");
                    budgetCtrlDetail.set("controlrate", (Object)controlRate);
                    budgetCtrlDetails.add((Object)budgetCtrlDetail);
                }
            }
            if (occupyAmt.compareTo(sumOccupyAmt) != 0) {
                allowUpdate = false;
                vo = new ExcelUtil.ExcelVo();
                vo.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
                vo.setBillNo(project.getString("number"));
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9879\u76ee\u603b\u4f53\u9884\u7b97\u63a7\u5236\u660e\u7ec6\u8868\u5360\u7528\u6570\u636e\u4e0e\u9879\u76ee\u603b\u4f53\u9884\u7b97\u63a7\u5236\u8868\u5360\u7528\u6570\u636e\u4e0d\u76f8\u7b26\uff0c\u6570\u636e\u53ef\u80fd\u5b58\u5728\u504f\u5dee\uff0c\u8bf7\u6392\u67e5\u3002", (String)"DataUpgradeHelper_10", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                resultList.add(vo);
                DataUpgradeHelper.rejectYearBudgetCtrl(project, yearBudgetCtrlList, resultList);
            }
            if (usageAmt.compareTo(sumUseAmt) != 0) {
                allowUpdate = false;
                vo = new ExcelUtil.ExcelVo();
                vo.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
                vo.setBillNo(project.getString("number"));
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9879\u76ee\u603b\u4f53\u9884\u7b97\u63a7\u5236\u660e\u7ec6\u8868\u4f7f\u7528\u6570\u636e\u4e0e\u9879\u76ee\u603b\u4f53\u9884\u7b97\u63a7\u5236\u8868\u4f7f\u7528\u6570\u636e\u4e0d\u76f8\u7b26\uff0c\u6570\u636e\u53ef\u80fd\u5b58\u5728\u504f\u5dee\uff0c\u8bf7\u6392\u67e5\u3002", (String)"DataUpgradeHelper_11", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                resultList.add(vo);
            }
            if (!allowUpdate) continue;
            Optional<ExcelUtil.ExcelVo> first2 = resultList.stream().filter(o -> StringUtils.equals((CharSequence)o.getType(), (CharSequence)UpgradeTypeEnum.SUCCESS.getName())).filter(o -> StringUtils.equals((CharSequence)o.getBillNo(), (CharSequence)project.getString("number"))).findFirst();
            if (!first2.isPresent()) {
                ExcelUtil.ExcelVo vo2 = new ExcelUtil.ExcelVo();
                vo2.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
                vo2.setBillNo(project.getString("number"));
                vo2.setType(UpgradeTypeEnum.SUCCESS);
                vo2.setMessage(ResManager.loadKDString((String)"\u603b\u4f53\u652f\u51fa\u9884\u7b97\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"DataUpgradeHelper_25", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                resultList.add(vo2);
            }
            totalBudgetCtrlList.add(totalBudgetCtrl);
        }
        return totalBudgetCtrlList;
    }

    public static List<DynamicObject> doUpdateInTBudgetCtrlByYBudgetCtrl(DynamicObject[] proApprovals, Set<Long> yearBudgetProIds, Map<String, List<DynamicObject>> budgetExcMap, List<DynamicObject> yearBudgetCtrlList, List<ExcelUtil.ExcelVo> resultList) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_totalbudgetctrl");
        ArrayList<DynamicObject> totalBudgetCtrlList = new ArrayList<DynamicObject>();
        for (Long yearBudgetProId : yearBudgetProIds) {
            ExcelUtil.ExcelVo vo;
            List<Object> yBudgetDetailList;
            List<DynamicObject> budgetExcRecords;
            Optional<DynamicObject> first;
            List curProInYBudgetCtrlList = yearBudgetCtrlList.stream().filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)o.getString("ybudgettype"))).filter(o -> o.getDynamicObject("yproject").getPkValue() != null).filter(o -> yearBudgetProId == Long.parseLong(o.getDynamicObject("yproject").getPkValue().toString())).collect(Collectors.toList());
            if (curProInYBudgetCtrlList.isEmpty()) continue;
            boolean allowUpdate = true;
            DynamicObject totalBudgetCtrl = new DynamicObject((DynamicObjectType)dt);
            totalBudgetCtrl.set("tbudgettype", (Object)BudgetSourceTypeEnum.IN.getValue());
            totalBudgetCtrl.set("tproject", (Object)((DynamicObject)curProInYBudgetCtrlList.get(0)).getDynamicObject("yproject"));
            totalBudgetCtrl.set("tcurrency", (Object)((DynamicObject)curProInYBudgetCtrlList.get(0)).getDynamicObject("ycurrency"));
            DynamicObject proApproval = null;
            if (proApprovals.length > 0 && (first = Arrays.stream(proApprovals).filter(o -> yearBudgetProId == Long.parseLong(o.getDynamicObject("pro").getPkValue().toString())).findFirst()).isPresent()) {
                proApproval = first.get();
                totalBudgetCtrl.set("proappamt", (Object)proApproval.getBigDecimal("projcetbugamt"));
            }
            BigDecimal sumBudgetAmt = curProInYBudgetCtrlList.stream().map(o -> o.getBigDecimal("ybudgetamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            totalBudgetCtrl.set("tsumbudamt", (Object)sumBudgetAmt);
            totalBudgetCtrl.set("tbudgetamt", (Object)sumBudgetAmt);
            if (proApproval != null) {
                totalBudgetCtrl.set("tproject", (Object)proApproval.getDynamicObject("pro"));
                totalBudgetCtrl.set("tcurrency", (Object)proApproval.getDynamicObject("currencyfield"));
            }
            totalBudgetCtrl.set("toricurrency", (Object)totalBudgetCtrl.getDynamicObject("tcurrency"));
            totalBudgetCtrl.set("proapporiamt", (Object)totalBudgetCtrl.getBigDecimal("proappamt"));
            totalBudgetCtrl.set("tbudgetoriamt", (Object)sumBudgetAmt);
            totalBudgetCtrl.set("tsumbudoriamt", (Object)sumBudgetAmt);
            BigDecimal preOccupyAmt = BigDecimal.ZERO;
            BigDecimal occupyAmt = BigDecimal.ZERO;
            BigDecimal preOccupyUsageAmt = BigDecimal.ZERO;
            BigDecimal usageAmt = BigDecimal.ZERO;
            if (!budgetExcMap.isEmpty() && (budgetExcRecords = budgetExcMap.get(String.valueOf(yearBudgetProId))) != null && !budgetExcRecords.isEmpty()) {
                preOccupyAmt = budgetExcRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.TAKEOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)o.getString("budgettype"))).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                occupyAmt = budgetExcRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.TAKEOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)o.getString("budgettype"))).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                preOccupyUsageAmt = budgetExcRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)o.getString("budgettype"))).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                usageAmt = budgetExcRecords.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)o.getString("budgettype"))).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            totalBudgetCtrl.set("tpreoccupyamt", (Object)preOccupyAmt);
            totalBudgetCtrl.set("toccupyamt", (Object)occupyAmt);
            totalBudgetCtrl.set("tpreoccupyusageamt", (Object)preOccupyUsageAmt);
            totalBudgetCtrl.set("tusageamt", (Object)usageAmt);
            totalBudgetCtrl.set("tremindrate", (Object)BigDecimal.valueOf(100L));
            totalBudgetCtrl.set("tcontrolrate", (Object)BigDecimal.valueOf(100L));
            HashMap<String, ArrayList<DynamicObject>> yBudgetDetailMap = new HashMap<String, ArrayList<DynamicObject>>();
            for (DynamicObject curProOutYBudgetCtrl : curProInYBudgetCtrlList) {
                DynamicObjectCollection details = curProOutYBudgetCtrl.getDynamicObjectCollection("ybudgetctrldetail");
                if (details.isEmpty()) continue;
                for (DynamicObject detail : details) {
                    DynamicObject budget = detail.getDynamicObject("budget");
                    if (budget == null) continue;
                    String budgetId = budget.getPkValue().toString();
                    yBudgetDetailList = (List)yBudgetDetailMap.get(budgetId);
                    if (yBudgetDetailList == null) {
                        yBudgetDetailList = new ArrayList<DynamicObject>();
                    }
                    yBudgetDetailList.add(detail);
                    yBudgetDetailMap.put(budgetId, (ArrayList<DynamicObject>)yBudgetDetailList);
                }
            }
            BigDecimal sumOccupyAmt = BigDecimal.ZERO;
            BigDecimal sumUseAmt = BigDecimal.ZERO;
            if (!yBudgetDetailMap.isEmpty()) {
                DynamicObjectCollection budgetCtrlDetails = totalBudgetCtrl.getDynamicObjectCollection("tbudgetctrldetail");
                DynamicObjectType entryDt = budgetCtrlDetails.getDynamicObjectType();
                Set entries = yBudgetDetailMap.entrySet();
                for (Map.Entry yBudgetDetail : entries) {
                    List<DynamicObject> budgetExcRecords2;
                    yBudgetDetailList = (ArrayList<DynamicObject>)yBudgetDetail.getValue();
                    if (yBudgetDetailList.isEmpty()) continue;
                    DynamicObject budgetCtrlDetail = new DynamicObject(entryDt);
                    budgetCtrlDetail.set("budget", (Object)((DynamicObject)yBudgetDetailList.get(0)).getDynamicObject("budget"));
                    budgetCtrlDetail.set("budgetitem", (Object)((DynamicObject)yBudgetDetailList.get(0)).getDynamicObject("budgetitem"));
                    budgetCtrlDetail.set("budgettype", (Object)BudgetSourceTypeEnum.IN.getValue());
                    budgetCtrlDetail.set("project", (Object)totalBudgetCtrl.getDynamicObject("tproject"));
                    budgetCtrlDetail.set("currency", (Object)totalBudgetCtrl.getDynamicObject("tcurrency"));
                    budgetCtrlDetail.set("oricurrency", (Object)totalBudgetCtrl.getDynamicObject("toricurrency"));
                    sumBudgetAmt = yBudgetDetailList.stream().map(o -> o.getBigDecimal("budgetamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    budgetCtrlDetail.set("sumbudamt", (Object)sumBudgetAmt);
                    budgetCtrlDetail.set("sumbudoriamt", (Object)sumBudgetAmt);
                    budgetCtrlDetail.set("budgetamt", (Object)sumBudgetAmt);
                    budgetCtrlDetail.set("budgetoriamt", (Object)sumBudgetAmt);
                    BigDecimal detailPreOccupyAmt = BigDecimal.ZERO;
                    BigDecimal detailOccupyAmt = BigDecimal.ZERO;
                    BigDecimal detailPreUsageAmt = BigDecimal.ZERO;
                    BigDecimal detailUsageAmt = BigDecimal.ZERO;
                    String projectBudgetItemId = budgetCtrlDetail.getDynamicObject("budget").getPkValue().toString();
                    if (!budgetExcMap.isEmpty() && (budgetExcRecords2 = budgetExcMap.get(String.valueOf(yearBudgetProId))) != null && !budgetExcRecords2.isEmpty()) {
                        detailPreOccupyAmt = budgetExcRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.TAKEOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)o.getString("budgettype"))).filter(o -> o.getDynamicObject("probudget") != null).filter(o -> o.getDynamicObject("probudget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("probudget").getPkValue().toString())).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        detailOccupyAmt = budgetExcRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.TAKEOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)o.getString("budgettype"))).filter(o -> o.getDynamicObject("probudget") != null).filter(o -> o.getDynamicObject("probudget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("probudget").getPkValue().toString())).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        detailPreUsageAmt = budgetExcRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.TAKE_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)o.getString("budgettype"))).filter(o -> o.getDynamicObject("probudget") != null).filter(o -> o.getDynamicObject("probudget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("probudget").getPkValue().toString())).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        detailUsageAmt = budgetExcRecords2.stream().filter(o -> StringUtils.equals((CharSequence)BudgetControlTypeEnum.EXECOPERATION.getValue(), (CharSequence)o.getString("controltype"))).filter(o -> StringUtils.equals((CharSequence)BillFieldTypeEnum.EXEC_OPERATION.getNumber(), (CharSequence)o.getString("opaction"))).filter(o -> StringUtils.equals((CharSequence)BudgetSourceTypeEnum.IN.getValue(), (CharSequence)o.getString("budgettype"))).filter(o -> o.getDynamicObject("probudget") != null).filter(o -> o.getDynamicObject("probudget").getPkValue() != null).filter(o -> StringUtils.equals((CharSequence)projectBudgetItemId, (CharSequence)o.getDynamicObject("probudget").getPkValue().toString())).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    }
                    budgetCtrlDetail.set("preoccupyamt", (Object)detailPreOccupyAmt);
                    budgetCtrlDetail.set("occupyamt", (Object)detailOccupyAmt);
                    budgetCtrlDetail.set("preoccupyusageamt", (Object)detailPreUsageAmt);
                    budgetCtrlDetail.set("usageamt", (Object)detailUsageAmt);
                    sumOccupyAmt = sumOccupyAmt.add(detailOccupyAmt);
                    sumUseAmt = sumUseAmt.add(detailUsageAmt);
                    budgetCtrlDetail.set("remindrate", (Object)String.valueOf(100));
                    budgetCtrlDetail.set("controlrate", (Object)String.valueOf(100));
                    budgetCtrlDetails.add((Object)budgetCtrlDetail);
                }
            }
            DynamicObject project = totalBudgetCtrl.getDynamicObject("tproject");
            if (occupyAmt.compareTo(sumOccupyAmt) != 0) {
                allowUpdate = false;
                vo = new ExcelUtil.ExcelVo();
                vo.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
                vo.setBillNo(project.getString("number"));
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9879\u76ee\u603b\u4f53\u9884\u7b97\u63a7\u5236\u660e\u7ec6\u8868\u5360\u7528\u6570\u636e\u4e0e\u9879\u76ee\u603b\u4f53\u9884\u7b97\u63a7\u5236\u8868\u5360\u7528\u6570\u636e\u4e0d\u76f8\u7b26\uff0c\u6570\u636e\u53ef\u80fd\u5b58\u5728\u504f\u5dee\uff0c\u8bf7\u6392\u67e5\u3002", (String)"DataUpgradeHelper_10", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                resultList.add(vo);
                DataUpgradeHelper.rejectYearBudgetCtrl(project, yearBudgetCtrlList, resultList);
            }
            if (usageAmt.compareTo(sumUseAmt) != 0) {
                allowUpdate = false;
                vo = new ExcelUtil.ExcelVo();
                vo.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
                vo.setBillNo(project.getString("number"));
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9879\u76ee\u603b\u4f53\u9884\u7b97\u63a7\u5236\u660e\u7ec6\u8868\u4f7f\u7528\u6570\u636e\u4e0e\u9879\u76ee\u603b\u4f53\u9884\u7b97\u63a7\u5236\u8868\u4f7f\u7528\u6570\u636e\u4e0d\u76f8\u7b26\uff0c\u6570\u636e\u53ef\u80fd\u5b58\u5728\u504f\u5dee\uff0c\u8bf7\u6392\u67e5\u3002", (String)"DataUpgradeHelper_11", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                resultList.add(vo);
                DataUpgradeHelper.rejectYearBudgetCtrl(project, yearBudgetCtrlList, resultList);
            }
            if (!allowUpdate) continue;
            Optional<ExcelUtil.ExcelVo> first2 = resultList.stream().filter(o -> StringUtils.equals((CharSequence)o.getType(), (CharSequence)UpgradeTypeEnum.SUCCESS.getName())).filter(o -> StringUtils.equals((CharSequence)o.getBillNo(), (CharSequence)project.getString("number"))).findFirst();
            if (!first2.isPresent()) {
                ExcelUtil.ExcelVo vo2 = new ExcelUtil.ExcelVo();
                vo2.setBillType(project.getDataEntityType().getDisplayName().getLocaleValue());
                vo2.setBillNo(project.getString("number"));
                vo2.setType(UpgradeTypeEnum.SUCCESS);
                vo2.setMessage(ResManager.loadKDString((String)"\u603b\u4f53\u6536\u5165\u9884\u7b97\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"DataUpgradeHelper_26", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                resultList.add(vo2);
            }
            totalBudgetCtrlList.add(totalBudgetCtrl);
        }
        return totalBudgetCtrlList;
    }

    private static Set<Long> getAllNewProjectIds() {
        Set proIds;
        Set proIds2;
        HashSet<Long> projectIds = new HashSet<Long>();
        QFilter qFilter = new QFilter("tproject", "!=", (Object)0L);
        DynamicObject[] totalBudgetCtrl = BusinessDataServiceHelper.load((String)"pmas_totalbudgetctrl", (String)"tproject", (QFilter[])new QFilter[]{qFilter});
        if (totalBudgetCtrl.length > 0 && !(proIds2 = Arrays.stream(totalBudgetCtrl).filter(o -> o.getDynamicObject("tproject") != null).map(o -> Long.parseLong(o.getDynamicObject("tproject").getPkValue().toString())).collect(Collectors.toSet())).isEmpty()) {
            projectIds.addAll(proIds2);
        }
        qFilter = new QFilter("yproject", "!=", (Object)0L);
        DynamicObject[] yearBudgetCtrl = BusinessDataServiceHelper.load((String)"pmas_ybudgetctrl", (String)"yproject", (QFilter[])new QFilter[]{qFilter});
        if (totalBudgetCtrl.length > 0 && !(proIds = Arrays.stream(yearBudgetCtrl).filter(o -> o.getDynamicObject("yproject") != null).map(o -> Long.parseLong(o.getDynamicObject("yproject").getPkValue().toString())).collect(Collectors.toSet())).isEmpty()) {
            projectIds.addAll(proIds);
        }
        return projectIds;
    }

    public static List<ExcelUtil.ExcelVo> updateCostItemData(List<Long> projectIds) {
        ArrayList<ExcelUtil.ExcelVo> resultList = new ArrayList<ExcelUtil.ExcelVo>();
        try (TXHandle h = TX.requiresNew();){
            try {
                List<ExcelUtil.ExcelVo> updateContractCost = DataUpgradeHelper.updateContractCost(projectIds);
                List<ExcelUtil.ExcelVo> updatePayApplyCostSplit = DataUpgradeHelper.updatePayApplyCostSplit(projectIds);
                resultList.addAll(updateContractCost);
                resultList.addAll(updatePayApplyCostSplit);
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
        return resultList;
    }

    public static List<ExcelUtil.ExcelVo> updatePayApplyCostSplit(List<Long> projectIds) {
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.TEMPSAVE.getValue());
        DynamicObject[] pkList = BusinessDataServiceHelper.load((String)"pmco_payapplycostsplit", (String)"id", (QFilter[])new QFilter[]{statusFilter});
        Object[] pkArray = Arrays.stream(pkList).map(dyn -> dyn.getLong("id")).toArray();
        DynamicObject[] payApplyCostSplitList = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmco_payapplycostsplit"));
        List<DynamicObject> selectedData = Arrays.stream(payApplyCostSplitList).filter(dyn -> dyn.getDynamicObject("project") != null).filter(dyn -> projectIds.contains(dyn.getDynamicObject("project").getLong("id"))).collect(Collectors.toList());
        ArrayList<ExcelUtil.ExcelVo> resultList = new ArrayList<ExcelUtil.ExcelVo>();
        for (DynamicObject data : selectedData) {
            DynamicObject costDimension = data.getDynamicObject("costdimension");
            DynamicObject project = data.getDynamicObject("project");
            if (costDimension == null) {
                ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
                vo.setBillType(data.getDataEntityType().getDisplayName().getLocaleValue());
                vo.setBillNo(data.getString("billno"));
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6210\u672c\u7ef4\u5ea6\uff0c\u65e0\u6cd5\u8ba1\u7b97\u6210\u672c\u9879\u3002", (String)"DataUpgradeHelper_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                resultList.add(vo);
                continue;
            }
            DynamicObjectCollection costDetails = data.getDynamicObjectCollection("costdetails");
            for (DynamicObject costDetail : costDetails) {
                DynamicObjectCollection details = costDetail.getDynamicObjectCollection("costsplitdetails");
                for (DynamicObject detail : details) {
                    DynamicObject proBudget = detail.getDynamicObject("probudget");
                    if (proBudget == null) {
                        ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
                        vo.setBillType(data.getDataEntityType().getDisplayName().getLocaleValue());
                        vo.setBillNo(data.getString("billno"));
                        vo.setType(UpgradeTypeEnum.ERROR);
                        vo.setMessage(ResManager.loadKDString((String)"\u6210\u672c\u5206\u644a\u660e\u7ec6\u9884\u7b97\u9879\u5b58\u5728\u7a7a\u503c\uff0c\u65e0\u6cd5\u8ba1\u7b97\u6210\u672c\u9879\u3002", (String)"DataUpgradeHelper_1", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                        resultList.add(vo);
                        continue;
                    }
                    DynamicObject costItem = detail.getDynamicObject("costitem");
                    if (costItem != null) continue;
                    Map<String, Object> costItemByProbudget = DataUpgradeHelper.getCostItemByProbudget(proBudget, project.getLong("id"), costDimension);
                    if (costItemByProbudget == null) {
                        ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
                        vo.setBillType(data.getDataEntityType().getDisplayName().getLocaleValue());
                        vo.setBillNo(data.getString("billno"));
                        vo.setType(UpgradeTypeEnum.ERROR);
                        vo.setMessage(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u9879\u76ee\u201c%2$s\u201d\u9884\u7b97\u9879\u65e0\u6210\u672c\u9879\u6620\u5c04\u4fe1\u606f\uff0c\u65e0\u6cd5\u8ba1\u7b97\u6210\u672c\u9879\u3002", (String)"DataUpgradeHelper_2", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project.getString("name"), proBudget.getString("name")));
                        resultList.add(vo);
                        continue;
                    }
                    DynamicObject costItemByMapping = (DynamicObject)costItemByProbudget.get(COST_ITEM);
                    detail.set("costitem", (Object)costItemByMapping);
                    detail.set("subcostdimension", (Object)costItemByMapping.getDynamicObject("costdimension"));
                    Boolean oneToMany = (Boolean)costItemByProbudget.get(ONE_TO_MANY);
                    ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
                    vo.setBillType(data.getDataEntityType().getDisplayName().getLocaleValue());
                    vo.setBillNo(data.getString("billno"));
                    if (oneToMany.booleanValue()) {
                        vo.setType(UpgradeTypeEnum.WARNING);
                        vo.setMessage(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u9879\u76ee\u201c%2$s\u201d\u9884\u7b97\u9879\u6709\u591a\u4e2a\u6210\u672c\u9879\u6620\u5c04\u4fe1\u606f\uff0c\u5df2\u9884\u7f6e\u201c%3$s\u201d\u6210\u672c\u9879\uff0c\u8bf7\u4eba\u5de5\u6838\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"DataUpgradeHelper_3", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project.getString("name"), proBudget.getString("name"), costItemByMapping.getString("name")));
                    } else {
                        vo.setType(UpgradeTypeEnum.SUCCESS);
                        vo.setMessage(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u9879\u76ee\u201c%2$s\u201d\u9884\u7b97\u9879\u5df2\u8bbe\u7f6e\u201c%3$s\u201d\u6210\u672c\u9879\u3002", (String)"DataUpgradeHelper_4", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project.getString("name"), proBudget.getString("name"), costItemByMapping.getString("name")));
                    }
                    resultList.add(vo);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])selectedData.toArray(new DynamicObject[selectedData.size()]));
        return resultList;
    }

    public static List<ExcelUtil.ExcelVo> updateContractCost(List<Long> projectIds) {
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.TEMPSAVE.getValue());
        DynamicObject[] pkList = BusinessDataServiceHelper.load((String)"pmco_contractcost", (String)"id", (QFilter[])new QFilter[]{statusFilter});
        Object[] pkArray = Arrays.stream(pkList).map(dyn -> dyn.getLong("id")).toArray();
        DynamicObject[] payApplyCostSplitList = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmco_contractcost"));
        List<DynamicObject> selectedData = Arrays.stream(payApplyCostSplitList).filter(dyn -> dyn.getDynamicObject("project") != null).filter(dyn -> projectIds.contains(dyn.getDynamicObject("project").getLong("id"))).collect(Collectors.toList());
        ArrayList<ExcelUtil.ExcelVo> resultList = new ArrayList<ExcelUtil.ExcelVo>();
        for (DynamicObject data : selectedData) {
            DynamicObject costDimension = data.getDynamicObject("costdimension");
            DynamicObject project = data.getDynamicObject("project");
            if (costDimension == null) {
                ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
                vo.setBillType(data.getDataEntityType().getDisplayName().getLocaleValue());
                vo.setBillNo(data.getString("billno"));
                vo.setType(UpgradeTypeEnum.ERROR);
                vo.setMessage(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6210\u672c\u7ef4\u5ea6\uff0c\u65e0\u6cd5\u8ba1\u7b97\u6210\u672c\u9879\u3002", (String)"DataUpgradeHelper_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                resultList.add(vo);
                continue;
            }
            DynamicObjectCollection costDetails = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject costDetail : costDetails) {
                DynamicObjectCollection details = costDetail.getDynamicObjectCollection("subentryentity");
                for (DynamicObject detail : details) {
                    DynamicObject proBudget = detail.getDynamicObject("budgetitem");
                    if (proBudget == null) {
                        ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
                        vo.setBillType(data.getDataEntityType().getDisplayName().getLocaleValue());
                        vo.setBillNo(data.getString("billno"));
                        vo.setType(UpgradeTypeEnum.ERROR);
                        vo.setMessage(ResManager.loadKDString((String)"\u6210\u672c\u5206\u644a\u660e\u7ec6\u9884\u7b97\u9879\u5b58\u5728\u7a7a\u503c\uff0c\u65e0\u6cd5\u8ba1\u7b97\u6210\u672c\u9879\u3002", (String)"DataUpgradeHelper_1", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
                        resultList.add(vo);
                        continue;
                    }
                    DynamicObject costItem = detail.getDynamicObject("costitem");
                    if (costItem != null) continue;
                    Map<String, Object> costItemByProbudget = DataUpgradeHelper.getCostItemByProbudget(proBudget, project.getLong("id"), costDimension);
                    if (costItemByProbudget == null) {
                        ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
                        vo.setBillType(data.getDataEntityType().getDisplayName().getLocaleValue());
                        vo.setBillNo(data.getString("billno"));
                        vo.setType(UpgradeTypeEnum.ERROR);
                        vo.setMessage(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u9879\u76ee\u201c%2$s\u201d\u9884\u7b97\u9879\u65e0\u6210\u672c\u9879\u6620\u5c04\u4fe1\u606f\uff0c\u65e0\u6cd5\u8ba1\u7b97\u6210\u672c\u9879\u3002", (String)"DataUpgradeHelper_2", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project.getString("name"), proBudget.getString("name")));
                        resultList.add(vo);
                        continue;
                    }
                    DynamicObject costItemByMapping = (DynamicObject)costItemByProbudget.get(COST_ITEM);
                    detail.set("costitem", (Object)costItemByMapping);
                    Boolean oneToMany = (Boolean)costItemByProbudget.get(ONE_TO_MANY);
                    ExcelUtil.ExcelVo vo = new ExcelUtil.ExcelVo();
                    vo.setBillType(data.getDataEntityType().getDisplayName().getLocaleValue());
                    vo.setBillNo(data.getString("billno"));
                    if (oneToMany.booleanValue()) {
                        vo.setType(UpgradeTypeEnum.WARNING);
                        vo.setMessage(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u9879\u76ee\u201c%2$s\u201d\u9884\u7b97\u9879\u6709\u591a\u4e2a\u6210\u672c\u9879\u6620\u5c04\u4fe1\u606f\uff0c\u5df2\u9884\u7f6e\u201c%3$s\u201d\u6210\u672c\u9879\uff0c\u8bf7\u4eba\u5de5\u6838\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"DataUpgradeHelper_3", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project.getString("name"), proBudget.getString("name"), costItemByMapping.getString("name")));
                    } else {
                        vo.setType(UpgradeTypeEnum.SUCCESS);
                        vo.setMessage(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u9879\u76ee\u201c%2$s\u201d\u9884\u7b97\u9879\u5df2\u8bbe\u7f6e\u201c%3$s\u201d\u6210\u672c\u9879\u3002", (String)"DataUpgradeHelper_4", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project.getString("name"), proBudget.getString("name"), costItemByMapping.getString("name")));
                    }
                    resultList.add(vo);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])selectedData.toArray(new DynamicObject[selectedData.size()]));
        return resultList;
    }

    public static Map<String, Object> getCostItemByProbudget(DynamicObject proBudget, Long projectId, DynamicObject costDimension) {
        QFilter projectFilter;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        boolean oneToMany = false;
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject proBudgetMapping = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetmapcost", (QFilter[])new QFilter[]{statusFilter, projectFilter = new QFilter("project", "=", (Object)projectId)});
        if (proBudgetMapping != null) {
            DynamicObjectCollection details = proBudgetMapping.getDynamicObjectCollection("costsplitdetails");
            details = details.stream().filter(dyn -> dyn.getDynamicObject("costdimension") != null).filter(dyn -> dyn.getDynamicObject("costdimension").getLong("id") == costDimension.getLong("id")).collect(Collectors.toCollection(DynamicObjectCollection::new));
            for (DynamicObject detail : details) {
                DynamicObject budget = detail.getDynamicObject("probudget");
                DynamicObject costItem = detail.getDynamicObject("costitem");
                if (proBudget.getLong("id") != budget.getLong("id") || costItem == null) continue;
                if (resultMap.containsKey(COST_ITEM)) {
                    oneToMany = true;
                    continue;
                }
                resultMap.put(COST_ITEM, costItem);
            }
        }
        if (resultMap.containsKey(COST_ITEM)) {
            resultMap.put(ONE_TO_MANY, oneToMany);
            return resultMap;
        }
        DynamicObject budgetItem = (proBudget = BusinessDataServiceHelper.loadSingle((Object)proBudget.getPkValue(), (String)"pmas_projectbudget")).getDynamicObject("budgetItem");
        if (budgetItem == null) {
            return null;
        }
        budgetItem = BusinessDataServiceHelper.loadSingle((Object)budgetItem.getPkValue(), (String)"pmbs_budgetitem");
        DynamicObjectCollection costitemList = budgetItem.getDynamicObjectCollection("costitem");
        if (!(costitemList = costitemList.stream().filter(dyn -> dyn.getDynamicObject("fbasedataid").getLong("costdimension.id") == costDimension.getLong("id")).collect(Collectors.toCollection(DynamicObjectCollection::new))).isEmpty()) {
            resultMap.put(COST_ITEM, ((DynamicObject)costitemList.get(0)).getDynamicObject("fbasedataid"));
            if (costitemList.size() > 1) {
                resultMap.put(ONE_TO_MANY, true);
            } else {
                resultMap.put(ONE_TO_MANY, false);
            }
            return resultMap;
        }
        return null;
    }

    public static void fillTreeEntryByEntryEntity(DynamicObjectCollection entryEntity, IFormView formView) {
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        IDataModel dataModel = formView.getModel();
        Object projectObj = dataModel.getValue("project");
        if (projectObj == null) {
            return;
        }
        DynamicObject project = (DynamicObject)projectObj;
        QFilter qFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        qFilter.and("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject[] proBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"budgetitem", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection details = dataModel.getEntryEntity("budgetmappingdetail");
        DynamicObjectType dt = details.getDynamicObjectType();
        for (DynamicObject entry : entryEntity) {
            DynamicObject newTreeEntryData = new DynamicObject(dt);
            newTreeEntryData.set("buagetname", entry.get("budgetitemname"));
            newTreeEntryData.set("budgetnumber", entry.get("budgetitemnum"));
            DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
            if (budgetItem != null) {
                newTreeEntryData.set("budgetitem", (Object)budgetItem);
                String budgetItemId = budgetItem.getPkValue().toString();
                if (proBudgets.length > 0) {
                    Optional<DynamicObject> first = Arrays.stream(proBudgets).filter(o -> o.getDynamicObject("budgetitem") != null).filter(o -> StringUtils.equals((CharSequence)budgetItemId, (CharSequence)o.getDynamicObject("budgetitem").getPkValue().toString())).findFirst();
                    first.ifPresent(dynamicObject -> newTreeEntryData.set("probudget", dynamicObject));
                }
            }
            newTreeEntryData.set("pid", entry.get("pid"));
            newTreeEntryData.set("id", entry.getPkValue());
            details.add((Object)newTreeEntryData);
        }
        dataModel.updateEntryCache(details);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)formView.getControl("budgetmappingdetail");
        treeEntryGrid.setCollapse(false);
        formView.updateView("budgetmappingdetail");
    }

    public static Set<Long> getUpdatedProject() {
        Set proIds;
        DynamicObject[] outBudgetCtrls;
        Set proIds2;
        HashSet<Long> projectIdSet = new HashSet<Long>();
        QFilter qfilter = new QFilter("tbudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject[] totalBudgetCtrls = BusinessDataServiceHelper.load((String)"pmas_totalbudgetctrl", (String)"tproject", (QFilter[])new QFilter[]{qfilter});
        if (totalBudgetCtrls.length > 0 && (proIds2 = Arrays.stream(totalBudgetCtrls).filter(o -> o.getDynamicObject("tproject") != null).map(o -> Long.parseLong(o.getDynamicObject("tproject").getPkValue().toString())).collect(Collectors.toSet())).size() > 0) {
            projectIdSet.addAll(proIds2);
        }
        if ((outBudgetCtrls = BusinessDataServiceHelper.load((String)"pmas_ybudgetctrl", (String)"yproject", (QFilter[])new QFilter[]{qfilter = new QFilter("ybudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue())})).length > 0 && (proIds = Arrays.stream(outBudgetCtrls).filter(o -> o.getDynamicObject("yproject") != null).map(o -> Long.parseLong(o.getDynamicObject("yproject").getPkValue().toString())).collect(Collectors.toSet())).size() > 0) {
            projectIdSet.addAll(proIds);
        }
        return projectIdSet;
    }
}

