/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper.dataupgrade;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.common.enums.dataupgrade.UpgradeTypeEnum;
import kd.pmgt.pmbs.common.param.PermCheckParam;
import kd.pmgt.pmbs.common.utils.CheckPermissionHelper;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.jetbrains.annotations.NotNull;

public class ExcelUtil {
    private static final Log logger = LogFactory.getLog(ExcelUtil.class);

    public static void exportExcel(IFormView formView, List<ExcelVo> voList) {
        HSSFWorkbook wb = ExcelUtil.setWorkbook(formView, voList);
        ExcelUtil.writeAndDownLoad(formView, wb);
    }

    @NotNull
    private static HSSFWorkbook setWorkbook(IFormView formView, List<ExcelVo> voList) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER_SELECTION);
        HSSFDataFormat format = sheet.getWorkbook().createDataFormat();
        HSSFRow row = sheet.createRow(0);
        HSSFCell titleCell0 = row.createCell(0);
        titleCell0.setCellValue(ResManager.loadKDString((String)"\u7ed3\u679c\u7c7b\u578b", (String)"ExcelUtil_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        titleCell0.setCellStyle(style);
        titleCell0.getCellStyle().setDataFormat(format.getFormat("TEXT"));
        sheet.setColumnWidth(0, 4024);
        HSSFCell titleCell1 = row.createCell(1);
        titleCell1.setCellValue(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"ExcelUtil_1", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        titleCell1.setCellStyle(style);
        titleCell1.getCellStyle().setDataFormat(format.getFormat("TEXT"));
        sheet.setColumnWidth(0, 4024);
        HSSFCell titleCell2 = row.createCell(2);
        titleCell2.setCellValue(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"ExcelUtil_2", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        titleCell2.setCellStyle(style);
        titleCell2.getCellStyle().setDataFormat(format.getFormat("TEXT"));
        sheet.setColumnWidth(0, 4024);
        HSSFCell titleCell3 = row.createCell(3);
        titleCell3.setCellValue(ResManager.loadKDString((String)"\u5347\u7ea7\u4fe1\u606f", (String)"ExcelUtil_3", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        titleCell3.setCellStyle(style);
        titleCell3.getCellStyle().setDataFormat(format.getFormat("TEXT"));
        sheet.setColumnWidth(1, 4024);
        int index = 1;
        for (ExcelVo vo : voList) {
            HSSFRow cur = sheet.createRow(index);
            Cell cell0 = cur.createCell(0);
            cell0.getCellStyle().setDataFormat(format.getFormat("TEXT"));
            cell0.setCellValue(vo.getType());
            Cell cell1 = cur.createCell(1);
            cell1.getCellStyle().setDataFormat(format.getFormat("TEXT"));
            cell1.setCellValue(vo.getBillType());
            Cell cell2 = cur.createCell(2);
            cell2.getCellStyle().setDataFormat(format.getFormat("TEXT"));
            cell2.setCellValue(vo.getBillNo());
            Cell cell3 = cur.createCell(3);
            cell3.getCellStyle().setDataFormat(format.getFormat("TEXT"));
            cell3.setCellValue(vo.getMessage());
            ++index;
        }
        return wb;
    }

    private static void writeAndDownLoad(IFormView formView, HSSFWorkbook wb) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(ResManager.loadKDString((String)"\u5347\u7ea7\u7ed3\u679c.xls", (String)"ExcelUtil_4", (String)"pmgt-pmbs-business", (Object[])new Object[0]), (InputStream)in, 5000);
        PermCheckParam permCheckParam = new PermCheckParam(url, formView.getEntityId(), formView.getFormShowParameter().getAppId(), "47150e89000000ac");
        CheckPermissionHelper.setFileUrlPermCheckParam((PermCheckParam)permCheckParam);
        formView.download(url);
        if (wb != null) {
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static class ExcelVo {
        private UpgradeTypeEnum type;
        private String billType;
        private String billNo;
        private String message;

        public String getType() {
            return this.type.getName();
        }

        public void setType(UpgradeTypeEnum type) {
            this.type = type;
        }

        public String getBillType() {
            return this.billType;
        }

        public void setBillType(String billType) {
            this.billType = billType;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

