/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper.project;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectPermFilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectTeamPermissionHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class ProjectF7FilterHelper {
    private static final Log logger = LogFactory.getLog(ProjectF7FilterHelper.class);

    public static Set<Long> loadHasPermProjectList(IFormView view, List<Long> orgList) {
        long userId = RequestContext.get().getCurrUserId();
        String appId = view.getFormShowParameter().getAppId();
        String billFormId = view.getEntityId();
        QFilter filter = ProjectF7FilterHelper.getProjectQFilter();
        boolean isTeamPerm = ProjectPermFilterHelper.getTeamPermSysParam();
        Set<Long> projectTeamProList = ProjectTeamPermissionHelper.loadHasPermProjects(filter, isTeamPerm, Boolean.TRUE, userId, orgList, appId, billFormId);
        Set<Long> otherCloudProjectIdList = ProjectF7FilterHelper.getOtherCloudProjectIdList(orgList);
        projectTeamProList.addAll(otherCloudProjectIdList);
        return projectTeamProList;
    }

    public static void setProjectF7QFilter(IFormView view, ListShowParameter listFormShowParameter, List<Long> orgList) {
        Set<Long> hasPermProjectIdList = ProjectF7FilterHelper.loadHasPermProjectList(view, orgList);
        QFilter idFilter = new QFilter("id", "in", hasPermProjectIdList);
        listFormShowParameter.getListFilterParameter().getQFilters().add(idFilter);
    }

    public static Set<Long> getProjectF7QFilterByOrgList(IFormView view, List<Long> orgIds) {
        long userId = RequestContext.get().getCurrUserId();
        String billFormId = view.getEntityId();
        String appId = view.getFormShowParameter().getAppId();
        boolean isTeamPerm = ProjectPermFilterHelper.getTeamPermSysParam();
        return ProjectTeamPermissionHelper.loadHasPermProjects(ProjectF7FilterHelper.getProjectQFilter(), isTeamPerm, Boolean.TRUE, userId, orgIds, appId, billFormId);
    }

    public static Set<Long> getProjectF7QFilterByAllPermOrgList(IFormView view) {
        long userId = RequestContext.get().getCurrUserId();
        String billFormId = view.getEntityId();
        String appId = view.getFormShowParameter().getAppId();
        List allPermOrgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(userId), (String)appId, (String)billFormId, (String)"47150e89000000ac");
        return ProjectF7FilterHelper.getProjectF7QFilterByOrgList(view, allPermOrgList);
    }

    public static Set<Long> getPMGTProjectIds() {
        QFilter proApprovalFilter = new QFilter("pro", "!=", (Object)0L);
        DynamicObjectCollection proApprovalCollection = QueryServiceHelper.query((String)"pmas_pro_approval", (String)"pro", (QFilter[])proApprovalFilter.toArray());
        return proApprovalCollection.stream().map(proApp -> proApp.getLong("pro")).collect(Collectors.toSet());
    }

    public static Set<Long> getOtherCloudProjectIdList(List<Long> permOrgList) {
        List cloudNumberList = ProjectPermissionHelper.getCloudNumberListProjectRangeBySysParameter();
        cloudNumberList.remove("PMGT");
        return ProjectF7FilterHelper.getOtherCloudsProjectIdList(cloudNumberList, permOrgList);
    }

    public static Set<Long> getOtherCloudsProjectIdList(List<String> cloudNumberList, List<Long> permOrgList) {
        DynamicObjectCollection projectList;
        Set<Long> projectIdList = new HashSet<Long>();
        QFilter qFilter = new QFilter("systemtype", "in", cloudNumberList);
        if (permOrgList.size() > 0) {
            qFilter.and(new QFilter("pmascreateorg", "in", permOrgList));
        }
        if ((projectList = QueryServiceHelper.query((String)"bd_project", (String)"id", (QFilter[])new QFilter[]{qFilter})) != null && !projectList.isEmpty()) {
            projectIdList = projectList.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        }
        return projectIdList;
    }

    public static QFilter getProjectQFilter() {
        QFilter filter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        filter.and("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        return filter;
    }
}

