/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper.project;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.Control;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectTeamPermissionHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class ProjectPermFilterHelper {
    private static final Log logger = LogFactory.getLog(ProjectPermFilterHelper.class);

    public static boolean isFilterFieldSelectedNoLimit(IListView listView, String fieldKey) {
        ControlFilter fieldFilter = (ControlFilter)listView.getControlFilters().getFilters().get(fieldKey);
        return fieldFilter == null || fieldFilter.getValue().size() == 0 || StringUtils.isBlank(fieldFilter.getValue().get(0));
    }

    public static Set<Long> getHasPermProjectList(IListView listView, Map<String, Set<Long>> permOrgMap, String orgKey, String projectKey) {
        String formId = listView.getBillFormId();
        HashSet orgList = new HashSet(2000);
        for (Map.Entry<String, Set<Long>> item : permOrgMap.entrySet()) {
            orgList.addAll(item.getValue());
        }
        QFilter orgFilter = new QFilter(orgKey, "in", orgList);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(orgFilter);
        if ("pmct_outcontract".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"out"));
        } else if ("pmct_incontract".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"in"));
        } else if ("pmct_outaddagreement".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"out"));
        } else if ("pmct_inaddagreement".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"in"));
        } else if ("pmct_outclaimbill".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"out"));
        } else if ("pmct_inclaimbill".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"in"));
        } else if ("pmct_outclarificbill".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"out"));
        } else if ("pmct_inclarificbill".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"in"));
        } else if ("pmct_outcontract_settle".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"out"));
        } else if ("pmct_incontract_settle".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"in"));
        } else if ("pmct_outcontractrevision".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"out"));
        } else if ("pmct_incontractrevision".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"in"));
        } else if ("pmct_outfinalsettle".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"out"));
        } else if ("pmct_infinalsettle".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"in"));
        } else if ("pmct_outperformrecords".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"out"));
        } else if ("pmct_inperformrecords".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("paydirection", "=", (Object)"in"));
        } else if ("pmas_outbudget".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("sourcetype", "=", (Object)"OUT"));
        } else if ("pmas_inbudget".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("sourcetype", "=", (Object)"IN"));
        } else if ("pmas_totalbudget".equalsIgnoreCase(formId)) {
            filterList.add(new QFilter("sourcetype", "=", (Object)"TOTAL"));
        }
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a\u5f00\u59cb\u83b7\u53d6\u5355\u636e\u5217\u8868\u6570\u636e\uff0c\u6761\u4ef6\u5165\u53c2{}\uff0c\u9879\u76ee\u5b57\u6bb5\u6807\u8bc6{}\uff0c\u5b9e\u4f53\u6807\u8bc6{}", new Object[]{filterList, projectKey, formId});
        Set<Long> projectList = ProjectTeamPermissionHelper.loadProjectsByBizBill(filterList, projectKey, formId);
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a\u5b8c\u6210\u5355\u636e\u5217\u8868\u6570\u636e\u83b7\u53d6\uff0c\u9879\u76ee\u6570\u91cf{}", (Object)projectList.size());
        Map<Long, Boolean> longBooleanMap = ProjectTeamPermissionHelper.judgeIsHasProOpPerm(projectList, formId, "view", RequestContext.get().getCurrUserId(), permOrgMap);
        projectList.clear();
        for (Map.Entry<Long, Boolean> entry : longBooleanMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            projectList.add(entry.getKey());
        }
        return projectList;
    }

    public static Map<String, Set<Long>> getHasPermOrgMap(IListView listView, String orgKey, String orgFilterKey) {
        Map<String, Set<Long>> otherSpecialOrgMap = ProjectTeamPermissionHelper.getOtherSpecialOrgMap(RequestContext.get().getCurrUserId());
        otherSpecialOrgMap.put("permOrgList", new HashSet<Long>(ProjectPermFilterHelper.getOrgFilterIdList(listView, orgKey, orgFilterKey)));
        return otherSpecialOrgMap;
    }

    public static List<Long> getOrgFilterIdList(IListView listView, String orgKey, String orgFilterKey) {
        List<Object> orgIds = new ArrayList(2000);
        ControlFilters filters = listView.getControlFilters();
        if (filters != null) {
            Map commonFilters = filters.getFilters();
            Set entrySet = commonFilters.entrySet();
            int index = 0;
            for (Map.Entry entry : entrySet) {
                if (((String)entry.getKey()).contains(orgFilterKey)) {
                    List defaultValues;
                    List orgFilters = filters.getFilter((String)entry.getKey());
                    if (orgFilters.size() > 0 && !orgFilters.get(0).equals("")) {
                        orgIds = orgFilters.stream().filter(StringUtils::isNotBlank).map(o -> Long.valueOf(o.toString())).collect(Collectors.toList());
                        CommonFilterColumn orgFilter = ProjectPermFilterHelper.getOrgFilter(listView, orgKey);
                        if (orgFilter == null || orgFilter.getDefaultValues() == null || orgFilter.getDefaultValues().isEmpty() || orgFilter.getDefaultValues().get(0).toString().equals(((Long)orgIds.get(0)).toString())) break;
                        orgFilter.getDefaultValues().clear();
                        List collect = orgIds.stream().map(Object::toString).collect(Collectors.toList());
                        orgFilter.getDefaultValues().addAll(collect);
                        break;
                    }
                    CommonFilterColumn orgFilter = ProjectPermFilterHelper.getOrgFilter(listView, orgKey);
                    if (orgFilter != null && (defaultValues = orgFilter.getDefaultValues()) != null) {
                        defaultValues.clear();
                    }
                    orgIds = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)listView.getFormShowParameter().getAppId(), (String)listView.getBillFormId(), (String)"view");
                    break;
                }
                ++index;
            }
            if (index == entrySet.size()) {
                List defaultValues;
                CommonFilterColumn orgFilter = ProjectPermFilterHelper.getOrgFilter(listView, orgKey);
                if (orgFilter != null && (defaultValues = orgFilter.getDefaultValues()) != null) {
                    defaultValues.clear();
                }
                orgIds = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)listView.getFormShowParameter().getAppId(), (String)listView.getBillFormId(), (String)"view");
            }
        } else {
            CommonFilterColumn orgFilterColumn = ProjectPermFilterHelper.getOrgFilter(listView, orgKey);
            if (orgFilterColumn != null) {
                List orgList = orgFilterColumn.getDefaultValues();
                if (orgList.size() > 0) {
                    orgIds.addAll(orgList.stream().filter(StringUtils::isNotBlank).map(o -> Long.valueOf(o.toString())).collect(Collectors.toList()));
                } else {
                    orgIds = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)listView.getFormShowParameter().getAppId(), (String)listView.getBillFormId(), (String)"view");
                }
            } else {
                orgIds = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(RequestContext.get().getCurrUserId()), (String)listView.getFormShowParameter().getAppId(), (String)listView.getBillFormId(), (String)"view");
            }
        }
        HashSet orgIdList = new HashSet(orgIds);
        return new ArrayList<Long>(orgIdList);
    }

    public static String getOrgFilterKey(String formId) {
        return ProjectPermFilterHelper.getOrgKey(formId).concat(".id");
    }

    public static String getOrgKey(String formId) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        String entityTypeId = formConfig.getEntityTypeId();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        String mainOrg = mainType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrg)) {
            mainOrg = "org";
            if ("pmpt_promeettaskmonitor".equalsIgnoreCase(formId)) {
                mainOrg = "project.pmascreateorg";
            }
        }
        return mainOrg;
    }

    public static CommonFilterColumn getOrgFilter(IListView listView, String orgField) {
        FilterGridView filterGridView;
        List items;
        Optional<CommonFilterColumn> result;
        FilterContainer filterContainer = (FilterContainer)listView.getControl("filtercontainerap");
        List filterControlList = filterContainer.getItems();
        Optional<Control> isFindGridView = filterControlList.stream().filter(control -> control instanceof FilterGridView).findAny();
        if (isFindGridView.isPresent() && (result = (items = (filterGridView = (FilterGridView)isFindGridView.get()).getItems()).stream().filter(item -> StringUtils.startsWith((CharSequence)((CommonFilterColumn)item).getFilterField().getFieldName(), (CharSequence)orgField)).map(item -> (CommonFilterColumn)item).findAny()).isPresent()) {
            return result.get();
        }
        return null;
    }

    public static String getProjectFilterKey(String formId) {
        String projectKey = ProjectPermFilterHelper.getProjectKey(formId);
        return projectKey.concat(".id");
    }

    public static String getProjectKey(String formId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        String projectKey = "project";
        for (IDataEntityProperty property : properties) {
            String baseEntityId = null;
            if (property.getPropertyType() == null || !DynamicObject.class.equals((Object)property.getPropertyType())) continue;
            if (property instanceof BasedataProp) {
                baseEntityId = ((BasedataProp)property).getBaseEntityId();
            } else if (property instanceof MulBasedataProp) {
                baseEntityId = ((MulBasedataProp)property).getBaseEntityId();
            }
            if (!StringUtils.equals((CharSequence)baseEntityId, (CharSequence)"bd_project")) continue;
            projectKey = property.getName();
            break;
        }
        return projectKey;
    }

    public static CommonFilterColumn getProjectFilter(IListView listView) {
        FilterContainer filterContainer = (FilterContainer)listView.getControl("filtercontainerap");
        List filterControlList = filterContainer.getItems();
        CommonFilterColumn projectCommonFilterColumn = null;
        FilterGridView filterGridView = filterControlList.stream().filter(control -> control instanceof FilterGridView).findFirst().orElse(null);
        if (filterGridView != null) {
            List items = filterGridView.getItems();
            projectCommonFilterColumn = items.stream().filter(item -> StringUtils.equals((CharSequence)((CommonFilterColumn)item).getFilterField().getRefEntityId(), (CharSequence)"bd_project")).map(item -> (CommonFilterColumn)item).collect(Collectors.toList()).stream().findFirst().orElse(null);
        }
        return projectCommonFilterColumn;
    }

    public static boolean getTeamPermSysParam() {
        boolean isProTeamCtrl = true;
        QFilter qFilter = new QFilter("appid", "=", (Object)"03PF22H/7KKW");
        qFilter.and("key", "=", (Object)"isteamperm");
        Map customParamAppMap = BusinessDataServiceHelper.loadFromCache((String)"bos_customparam_app", (String)"id,value", (QFilter[])new QFilter[]{qFilter});
        if (!customParamAppMap.isEmpty()) {
            Set customParamApps = customParamAppMap.entrySet();
            for (Map.Entry customParamApp : customParamApps) {
                DynamicObject dyObj = (DynamicObject)customParamApp.getValue();
                Object value = dyObj.get("value");
                if (value == null || !value.toString().equalsIgnoreCase("true") && !value.toString().equalsIgnoreCase("false")) continue;
                isProTeamCtrl = Boolean.parseBoolean(value.toString());
            }
        }
        return isProTeamCtrl;
    }

    public static boolean getProApprovalAsyncAuditSysParam() {
        boolean isProAppAsyncAudit = false;
        QFilter qFilter = new QFilter("appid", "=", (Object)"03PF22H/7KKW");
        qFilter.and("key", "=", (Object)"isproasyncaudit");
        Map customParamAppMap = BusinessDataServiceHelper.loadFromCache((String)"bos_customparam_app", (String)"id,value", (QFilter[])new QFilter[]{qFilter});
        if (!customParamAppMap.isEmpty()) {
            Set customParamApps = customParamAppMap.entrySet();
            for (Map.Entry customParamApp : customParamApps) {
                DynamicObject dyObj = (DynamicObject)customParamApp.getValue();
                Object value = dyObj.get("value");
                if (value == null || !value.toString().equalsIgnoreCase("true") && !value.toString().equalsIgnoreCase("false")) continue;
                isProAppAsyncAudit = Boolean.parseBoolean(value.toString());
            }
        }
        return isProAppAsyncAudit;
    }
}

