/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper.publish;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;

public class AutoPublishConstHelper {
    private String classsrc;
    private String infoname;
    private String entityid;
    private boolean isSeparate;
    private String appId;
    private StringBuilder outputEntityConstantJavaFile;

    public AutoPublishConstHelper(String classsrc, String infoname, String entityid, String appId) {
        this.classsrc = classsrc;
        this.infoname = infoname;
        this.entityid = entityid;
        this.appId = appId;
        this.outputEntityConstantJavaFile = new StringBuilder();
    }

    public AutoPublishConstHelper(String classsrc, String infoname, String entityid, boolean isSeparate, String appId) {
        this.classsrc = classsrc;
        this.infoname = infoname;
        this.entityid = entityid;
        this.isSeparate = isSeparate;
        this.appId = appId;
        this.outputEntityConstantJavaFile = new StringBuilder();
    }

    public void initEntityConstantJavaFile() {
        this.outPutEntityConstantJavaFileHead();
        this.outPutEntityConstantJavaFileField();
        this.outPutEntityConstantJAVAFile();
    }

    public String outPutEntityConstantJavaFileHead() {
        StringBuilder sb = new StringBuilder();
        sb.append("package ");
        sb.append(this.classsrc);
        sb.append(";\n\n");
        if (!this.isSeparate) {
            sb.append("import kd.bos.dataentity.entity.DynamicObject;\n");
            sb.append("import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;\n");
            sb.append("import kd.bos.entity.EntityMetadataCache;\n");
        }
        if (this.appId != null && this.appId.startsWith("pm")) {
            sb.append("import kd.pmgt.pmbs.common.model.BaseConstant;\n\n");
        }
        sb.append("/** @date ");
        sb.append(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
        sb.append(" */\n");
        sb.append("public class ").append(this.getFirstLetterUpperCase(this.infoname)).append("Constant extends BaseConstant{\n");
        this.outputEntityConstantJavaFile.append((CharSequence)sb);
        return sb.toString();
    }

    public String outPutEntityConstantJavaFileField() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\t/** \u5143\u6570\u636e\u6807\u8bc6 */");
        if (this.isSeparate) {
            sb.append("\n\tpublic static final String EntityId = \"");
            sb.append(this.entityid.substring(this.entityid.indexOf("_") + 1));
            sb.append("\";");
        } else {
            sb.append("\n\tpublic static final String formBillId = \"");
            sb.append(this.entityid);
            sb.append("\";");
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entityid);
        DataEntityPropertyCollection properties = dt.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            DynamicProperty property = (DynamicProperty)properties.get(i);
            if (property.getPropertyType() != null) {
                sb.append(this.headInfo(property, ""));
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            sb.append(this.entryInfo(property));
        }
        this.outputEntityConstantJavaFile.append((CharSequence)sb);
        return sb.toString();
    }

    public String entryInfo(DynamicProperty property) {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        String commentName = property.getDisplayName() == null ? property.getName() : property.getDisplayName().toString();
        sb.append("\n\t/** entry\"");
        sb.append(commentName);
        sb.append("\"formId */");
        sb.append("\n\tpublic static final String EntryEntityId_");
        sb.append(property.getName());
        sb.append("= \"");
        sb.append(property.getName());
        sb.append("\";");
        EntryType entryDT = (EntryType)((EntryProp)property).getDynamicCollectionItemPropertyType();
        DataEntityPropertyCollection entryProperties = entryDT.getProperties();
        for (int j = 0; j < entryProperties.size(); ++j) {
            DynamicProperty entryProperty = (DynamicProperty)entryProperties.get(j);
            if (entryProperty instanceof EntryProp) {
                sb.append(this.subEntryInfo(entryProperty));
                continue;
            }
            sb.append(this.headInfo(entryProperty, this.getFirstLetterUpperCase(property.getName() + "_")));
        }
        sb.append('\n');
        return sb.toString();
    }

    public String subEntryInfo(DynamicProperty entryProperty) {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        if (entryProperty instanceof EntryProp) {
            sb.append("\n\t/** subEntry");
            sb.append(entryProperty.getName());
            sb.append("formId */");
            sb.append("\n\tpublic static final String SubEntryEntityId_");
            sb.append(entryProperty.getName());
            sb.append("=\"");
            sb.append(entryProperty.getName());
            sb.append("\";");
            EntryType subEntryDT = (EntryType)((EntryProp)entryProperty).getDynamicCollectionItemPropertyType();
            DataEntityPropertyCollection subEntryPropertys = subEntryDT.getProperties();
            for (int k = 0; k < subEntryPropertys.size(); ++k) {
                DynamicProperty subEntryProperty = (DynamicProperty)subEntryPropertys.get(k);
                sb.append(this.headInfo(subEntryProperty, this.getFirstLetterUpperCase(entryProperty.getName() + "_")));
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public String headInfo(DynamicProperty property, String prefix) {
        String commentName;
        StringBuilder sb = new StringBuilder();
        if (property.getName() == null) {
            return sb.toString();
        }
        if (property.getName().indexOf("_id") != -1 || "id".equalsIgnoreCase(property.getName())) {
            return sb.toString();
        }
        if ("entityid".equalsIgnoreCase(property.getName()) || "multilanguagetext".equalsIgnoreCase(property.getName())) {
            return sb.toString();
        }
        String string = commentName = property.getDisplayName() == null ? property.getName() : property.getDisplayName().toString();
        if (property.getPropertyType().equals(LocaleString.class)) {
            sb.append("\n\t/** ");
            sb.append(commentName);
            sb.append(",Type:");
            sb.append(property.getPropertyType().getName());
            sb.append(" */");
            sb.append("\n\tpublic static final String ");
            sb.append(prefix);
            sb.append(this.getFirstLetterUpperCase(property.getName()));
            sb.append(" = \"");
            sb.append(property.getName());
            sb.append("\";");
        } else if (property.getPropertyType().equals(DynamicObject.class)) {
            String baseType = "";
            if (property instanceof BasedataProp) {
                baseType = "BaseEntityId:" + ((BasedataProp)property).getBaseEntityId();
            }
            sb.append("\n\t/** ");
            sb.append(commentName);
            sb.append(",Type:");
            sb.append(property.getPropertyType().getName());
            sb.append(',');
            sb.append(baseType);
            sb.append(" */");
            sb.append("\n\tpublic static final String ");
            sb.append(prefix);
            sb.append(this.getFirstLetterUpperCase(property.getName()));
            sb.append(" = \"");
            sb.append(property.getName());
            sb.append("\";");
        } else {
            sb.append("\n\t/** ");
            sb.append(commentName);
            sb.append(",Type:");
            sb.append(property.getPropertyType().getName());
            sb.append(" */");
            sb.append("\n\tpublic static final String ");
            sb.append(prefix);
            sb.append(this.getFirstLetterUpperCase(property.getName()));
            sb.append(" = \"");
            sb.append(property.getName());
            sb.append("\";");
        }
        return sb.toString();
    }

    public String getFirstLetterUpperCase(String str) {
        if (str == null) {
            return null;
        }
        char[] ch = str.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] - 32);
        }
        return new String(ch);
    }

    public String outPutEntityConstantJAVAFile() {
        this.outputEntityConstantJavaFile.append('}');
        return this.outputEntityConstantJavaFile.toString();
    }

    public StringBuilder getOutputEntityConstantJavaFile() {
        return this.outputEntityConstantJavaFile;
    }

    public String getInfoname() {
        return this.infoname;
    }
}

