/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper.reference;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BaseDataReferenceCheckHelper {
    private static final Log logger = LogFactory.getLog(BaseDataReferenceCheckHelper.class);
    private static final String REF_ENTITY_INFO = "refentityinffo";
    private static final String REF_ENTITY_COLUMN_INFO = "refentitycolumninffo";

    public static Set<Map<String, String>> checkReference(DynamicObject baseData, FormOperate operate) {
        BaseDataCheckRefrence checkRef = new BaseDataCheckRefrence();
        return BaseDataReferenceCheckHelper.checkReference(checkRef, baseData, operate);
    }

    public static Set<Map<String, String>> checkReference(BaseDataCheckRefrence checkRef, DynamicObject baseData, FormOperate operate) {
        HashSet<Map<String, String>> refInfoLSet = new HashSet<Map<String, String>>(10);
        List refList = checkRef.getAllRefs((BasedataEntityType)baseData.getDataEntityType(), baseData.getPkValue());
        String baseDataName = baseData.getDynamicObjectType().getDisplayName().getLocaleValue();
        String operateName = operate.getOperateName().getLocaleValue();
        for (BaseDataRefenceKey baseDataReferenceKey : refList) {
            String refEntityKey = baseDataReferenceKey.getRefEntityKey();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)refEntityKey);
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)dt.getBizAppNumber());
            QFilter cloudPkQFilter = new QFilter("id", "=", (Object)appInfo.getCloudId());
            DynamicObject cloudInfo = QueryServiceHelper.queryOne((String)"bos_devportal_bizcloud", (String)"", (QFilter[])new QFilter[]{cloudPkQFilter});
            String cloudName = cloudInfo.getString("name");
            String billInfoName = dt.getDisplayName().getLocaleValue();
            String appInfoName = appInfo.getName().getLocaleValue();
            String filedName = "";
            DataEntityPropertyCollection depCollection = dt.getProperties();
            for (IDataEntityProperty dep : depCollection) {
                if (dep.getPropertyType() != null) {
                    BasedataProp filedInfo;
                    String baseDataEntityId;
                    if (!dep.getPropertyType().equals(DynamicObject.class) || !(dep instanceof BasedataProp) || !(baseDataEntityId = (filedInfo = (BasedataProp)dep).getBaseEntityId()).equalsIgnoreCase(baseDataReferenceKey.getBaseEntityKey())) continue;
                    filedName = filedInfo.getDisplayName().getLocaleValue();
                    continue;
                }
                if (!(dep instanceof EntryProp)) continue;
                EntryProp entryProp = (EntryProp)dep;
                DataEntityPropertyCollection entryDepCollection = entryProp.getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty entryDep : entryDepCollection) {
                    BasedataProp filedInfo;
                    String baseDataEntityId;
                    if (entryDep.getPropertyType() == null || !entryDep.getPropertyType().equals(DynamicObject.class) || !(entryDep instanceof BasedataProp) || !(baseDataEntityId = (filedInfo = (BasedataProp)entryDep).getName()).equalsIgnoreCase(baseDataReferenceKey.getBaseEntityKey())) continue;
                    filedName = filedInfo.getDisplayName().getLocaleValue();
                }
            }
            HashMap<String, String> refInfoMap = new HashMap<String, String>(10);
            refInfoMap.put(REF_ENTITY_INFO, String.format("%s>%s>%s", cloudName, appInfoName, billInfoName));
            refInfoMap.put(REF_ENTITY_COLUMN_INFO, filedName);
            refInfoLSet.add(refInfoMap);
        }
        logger.warn("{}\u5931\u8d25\uff0c\u7f16\u7801\u4e3a[{}]\uff0c\u540d\u79f0\u4e3a[{}]\u7684\u201c{}\u201d\u57fa\u7840\u8d44\u6599,\u603b\u5171\u5b58\u5728[{}]\u5904\u5f15\u7528\uff0c\u5f15\u7528\u5217\u8868\u5982\u4e0b\uff1a{}", new Object[]{operateName, baseData.get("number"), baseData.get("name"), baseDataName, refList.size(), refList.stream().map(BaseDataRefenceKey::getRefEntityKey).collect(Collectors.toList())});
        return refInfoLSet;
    }

    public static String checkReferenceOnPmCloud(DynamicObject baseData, FormOperate operate, List<String> ignoreRefEntityIdList) {
        ArrayList<String> cloudIdList = new ArrayList<String>(1);
        cloudIdList.add("PMGT");
        Set<Map<String, String>> refDetailSet = BaseDataReferenceCheckHelper.checkReference(baseData, operate, cloudIdList, ignoreRefEntityIdList);
        if (refDetailSet.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map<String, String> refDetail : refDetailSet) {
                sb.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\n", (String)"BaseDataReferenceCheckHelper_2", (String)"pmgt-pmbs-business", (Object[])new Object[0]), refDetail.get(REF_ENTITY_INFO), refDetail.get(REF_ENTITY_COLUMN_INFO)));
            }
            sb.append(ResManager.loadKDString((String)"\u5f15\u7528\u4e86\u6b64\u6570\u636e\u3002", (String)"BaseDataReferenceCheckHelper_3", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
            return sb.toString();
        }
        return null;
    }

    public static Set<Map<String, String>> checkReference(DynamicObject baseData, FormOperate operate, List<String> cloudIdList, List<String> ignoreRefEntityIdList) {
        BaseDataCheckRefrence checkRef = new BaseDataCheckRefrence();
        checkRef.getIgnoreRefEntityIds().addAll(ignoreRefEntityIdList);
        QFilter cloudIdListQFilter = new QFilter("number", "in", cloudIdList);
        DynamicObjectCollection cloudList = QueryServiceHelper.query((String)"bos_devportal_bizcloud", (String)"", (QFilter[])new QFilter[]{cloudIdListQFilter});
        List cloudPkList = cloudList.stream().map(o -> o.get("id")).collect(Collectors.toList());
        QFilter cloudPkListQFilter = new QFilter("bizcloud", "in", cloudPkList);
        DynamicObjectCollection appList = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"", (QFilter[])new QFilter[]{cloudPkListQFilter});
        List appPkList = appList.stream().map(o -> o.get("id")).collect(Collectors.toList());
        QFilter appPkListQFilter = new QFilter("bizapp", "in", appPkList);
        DynamicObjectCollection entityIdList = QueryServiceHelper.query((String)"bos_devportal_unitrelform", (String)"form", (QFilter[])new QFilter[]{appPkListQFilter});
        List formIdLst = entityIdList.stream().map(t -> t.getString("form")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", formIdLst);
        DynamicObjectCollection formNumberList = QueryServiceHelper.query((String)"bos_formmeta", (String)"number", (QFilter[])new QFilter[]{filter});
        Set checkRefEntityIdList = formNumberList.stream().map(t -> t.getString("number")).collect(Collectors.toSet());
        checkRef.getCheckRefEntityIds().addAll(checkRefEntityIdList);
        return BaseDataReferenceCheckHelper.checkReference(checkRef, baseData, operate);
    }
}

