/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper.unaudit;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.unaudit.DownStreamRebuildInfo;
import kd.pmgt.pmbs.business.helper.unaudit.PreviousBillFinder;
import kd.pmgt.pmbs.business.helper.unaudit.ReferenceResult;
import kd.pmgt.pmbs.business.helper.unaudit.UpstreamReferenceChecker;

public class UnAuditOperation {
    private static final Log logger = LogFactory.getLog(UnAuditOperation.class);
    private String upstreamFormId;
    private Long upstreamFormPk;
    private PreviousBillFinder previousBillFinder;
    private UpstreamReferenceChecker upstreamReferenceChecker;
    private List<DownStreamRebuildInfo> downStreamReBuildInfoList;
    private DynamicObject previousBill;
    private ReferenceResult upstreamReferenceResult;
    private List<ReferenceResult> downstreamReferenceResults;

    public UnAuditOperation(String upstreamFormId, Long upStreamBillPk, PreviousBillFinder previousBillFinder, UpstreamReferenceChecker upstreamReferenceChecker, List<DownStreamRebuildInfo> downStreamRebuildInfoList) {
        this.upstreamFormId = upstreamFormId;
        this.upstreamFormPk = upStreamBillPk;
        this.previousBillFinder = previousBillFinder;
        this.upstreamReferenceChecker = upstreamReferenceChecker;
        this.downStreamReBuildInfoList = downStreamRebuildInfoList;
    }

    public boolean doUnAudit() {
        this.upstreamReferenceResult = this.upstreamReferenceChecker.check(this.upstreamFormPk);
        if (this.upstreamReferenceResult.isReferenced()) {
            logger.info("upstream bill had been referenced");
            return false;
        }
        this.downstreamReferenceResults = this.downStreamReBuildInfoList.stream().map(downstreamRebuildInfo -> downstreamRebuildInfo.getChecker().check(downstreamRebuildInfo.getFormId(), downstreamRebuildInfo.getFormIdPk())).collect(Collectors.toList());
        boolean hasFalse = this.downstreamReferenceResults.stream().map(ReferenceResult::isReferenced).anyMatch(it -> it == false);
        if (hasFalse) {
            logger.info("downstream bill had been referenced");
            return false;
        }
        this.deleteDownstreamBills();
        this.previousBill = this.previousBillFinder.find(this.upstreamFormPk);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])this.downStreamReBuildInfoList.stream().map(downstreamRebuildInfo -> downstreamRebuildInfo.getGenerator().generate(this.previousBill, EntityMetadataCache.getDataEntityType((String)downstreamRebuildInfo.getFormId()))).toArray(DynamicObject[]::new)));
        return true;
    }

    private void deleteDownstreamBills() {
        this.downStreamReBuildInfoList.forEach(downStreamRebuildInfo -> DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)downStreamRebuildInfo.getFormId()), (Object[])new Object[]{downStreamRebuildInfo.getFormIdPk()}));
    }

    public ReferenceResult getUpstreamReferenceResult() {
        return this.upstreamReferenceResult;
    }

    public List<ReferenceResult> getDownstreamReferenceResults() {
        return this.downstreamReferenceResults;
    }
}

