/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.manage;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class MonthlyFundPlanEditService {
    private static final Log logger = LogFactory.getLog(MonthlyFundPlanEditService.class);

    public DynamicObject getPeriodFundPlanAmount(DynamicObject period, DynamicObject contract, DynamicObject org, DynamicObject project) {
        QFilter orgFilter;
        QFilter contractFilter;
        String periodFundPlanAmtFormId;
        String contractFormId;
        String projectFormId;
        String orgFormId;
        String entityFormId;
        if (contract == null) {
            return null;
        }
        String payDirection = contract.getString("paydirection");
        String billFormId = "pmct_monthlyfundplan";
        String periodFormId = "period";
        if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue())) {
            entityFormId = "incontractplanentity";
            orgFormId = "inorg";
            projectFormId = "inproject";
            contractFormId = "incontract";
            periodFundPlanAmtFormId = "inperiodplanamt";
        } else {
            entityFormId = "outcontractplanentity";
            orgFormId = "outorg";
            projectFormId = "outproject";
            contractFormId = "outcontract";
            periodFundPlanAmtFormId = "outperiodplanamt";
        }
        QFilter filter = new QFilter(periodFormId, "=", period == null ? period : period.getPkValue());
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        String multiPayType = contract.getString("multipaytype");
        boolean isSeparatePay = StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay");
        if (!multiPartSettlement) {
            contractFilter = new QFilter(String.join((CharSequence)".", entityFormId, contractFormId), "=", contract.getPkValue());
            orgFilter = new QFilter(String.join((CharSequence)".", entityFormId, orgFormId), "=", org == null ? org : org.getPkValue());
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            filter.and(contractFilter).and(orgFilter).and(statusFilter);
            if (project != null) {
                QFilter projectFilter = new QFilter(String.join((CharSequence)".", entityFormId, projectFormId), "=", project.getPkValue());
                filter.and(projectFilter);
            }
        } else if (!isSeparatePay) {
            contractFilter = new QFilter(String.join((CharSequence)".", entityFormId, contractFormId), "=", contract.getPkValue());
            DynamicObjectCollection contractSharedOrgList = contract.getDynamicObjectCollection("contorgscope");
            QFilter orgFilter2 = new QFilter(String.join((CharSequence)".", entityFormId, orgFormId), "in", contractSharedOrgList.stream().map(it -> it.getDynamicObject("multisettleorg")).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
            orgFilter2.or(new QFilter("org", "=", org == null ? org : org.getPkValue()));
            if (project != null) {
                DynamicObjectCollection contractSharedProjectList = contract.getDynamicObjectCollection("contproscope");
                List sharedProjectPks = contractSharedProjectList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                DynamicObject contractProject = contract.getDynamicObject("project");
                if (contractProject != null) {
                    sharedProjectPks.add(contractProject.getPkValue());
                }
                QFilter projectFilter = new QFilter(String.join((CharSequence)".", entityFormId, projectFormId), "in", sharedProjectPks);
                orgFilter2.or(projectFilter);
            }
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            filter.and(contractFilter).and(orgFilter2).and(statusFilter);
        } else {
            contractFilter = new QFilter(String.join((CharSequence)".", entityFormId, contractFormId), "=", contract.getPkValue());
            orgFilter = new QFilter("org", "=", org == null ? org : org.getPkValue());
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            filter.and(contractFilter).and(orgFilter).and(statusFilter);
            if (project != null) {
                QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
                filter.and(projectFilter);
            }
        }
        logger.info("MonthlyFundPlanEditService#getPeriodFundPlanAmount filter:{}", (Object)filter);
        String selectProperties = String.join((CharSequence)".", entityFormId, periodFundPlanAmtFormId) + "," + String.join((CharSequence)".", entityFormId, contractFormId);
        DynamicObject[] fundPlans = BusinessDataServiceHelper.load((String)billFormId, (String)selectProperties, (QFilter[])new QFilter[]{filter}, (String)"auditdate desc");
        if (fundPlans.length > 0) {
            return fundPlans[0];
        }
        return null;
    }

    public DynamicObject[] getSameOrgAndPeriodBill(DynamicObject org, DynamicObject period) {
        QFilter filter = new QFilter("period", "=", period.getPkValue());
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        filter.and(orgFilter).and(statusFilter);
        logger.info("MonthlyFundPlanEditService#getSameOrgAndPeriodBill filter:{}", (Object)filter);
        return BusinessDataServiceHelper.load((String)"pmct_monthlyfundplan", (String)"id", (QFilter[])new QFilter[]{filter});
    }
}

