/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.projectkind;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ProjectKindCtrlService {
    private static final String FORM_ID = "bd_projectkind";
    private static final String ENTITY_BDDEFCTRLSTRTGY = "bd_bddefctrlstrtgy";
    private static final String ENTITY_BDBASEDATAVIEW = "bd_basedataview";
    private static final String STRATEGY_GLOBAL = "5";
    private static final Log logger = LogFactory.getLog(ProjectKindCtrlService.class);

    public boolean needCtrlStrategyTree() {
        boolean need = false;
        QFilter baseDataIdFilter = new QFilter("basedataid", "=", (Object)FORM_ID);
        DynamicObject defaultStrategy = BusinessDataServiceHelper.loadSingle((String)ENTITY_BDDEFCTRLSTRTGY, (String)"defaultctrlstrategy", (QFilter[])new QFilter[]{baseDataIdFilter});
        if (defaultStrategy != null) {
            need = !StringUtils.equals((CharSequence)defaultStrategy.getString("defaultctrlstrategy"), (CharSequence)STRATEGY_GLOBAL) || this.getNonGlobalStrategyCountByViewId() > 0L || this.getNonGlobalStrategyCountInTenant() > 0L;
        }
        logger.info("ProjectKindCtrlService#needCtrlStrategyTree#result: {}", (Object)need);
        return need;
    }

    private long getNonGlobalStrategyCountByViewId() {
        QFilter baseDataFilter = new QFilter("basedata", "=", (Object)FORM_ID);
        DynamicObject baseView = BusinessDataServiceHelper.loadSingle((String)ENTITY_BDBASEDATAVIEW, (String)"basedata,ctrlview", (QFilter[])new QFilter[]{baseDataFilter});
        if (baseView == null) {
            return 0L;
        }
        String sql = "select count(1) count from  t_bd_ctrlstrategydetail l ,t_bd_ctrlstrategy a where a.fid=l.fid and a.fcuid=l.FCREATEORGID and  a.FBASEDATAVIEWID=? and l.FCtrlStrategy !=?";
        Object[] filters = new String[]{baseView.getString("id"), STRATEGY_GLOBAL};
        return (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])filters, rs -> {
            if (rs.next()) {
                return rs.getLong("count");
            }
            return 0L;
        });
    }

    private long getNonGlobalStrategyCountInTenant() {
        String sql = "select count(1) count from t_bd_projectkind a where a.fctrlstrategy !=?";
        Object[] filters = new String[]{STRATEGY_GLOBAL};
        return (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])filters, rs -> {
            if (rs.next()) {
                return rs.getLong("count");
            }
            return 0L;
        });
    }
}

