/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.projectkind;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.pmgt.pmbs.business.projectkind.ProjectKindCtrlService;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class ProjectKindService {
    public static final String ROOT_NODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    protected ProjectKindCtrlService projectKindCtrlService = new ProjectKindCtrlService();
    private static final Log logger = LogFactory.getLog(ProjectKindService.class);

    public boolean needCtrlStrategyTree() {
        return this.projectKindCtrlService.needCtrlStrategyTree();
    }

    public List<TreeNode> getAuthorizedProjectKindNodeList(Long orgId) {
        return this.getNodes(this.getAuthorizedProjectKindList(null, orgId));
    }

    public List<TreeNode> getNodes(DynamicObject[] kinds) {
        Map<Long, DynamicObjectCollection> childMap = this.getChildMap(kinds);
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(10);
        for (DynamicObject treeData : kinds) {
            boolean hasParent = treeData.get("parent") != null;
            boolean bl = hasParent = hasParent && Arrays.stream(kinds).anyMatch(entry -> StringUtils.equals((CharSequence)((DynamicObject)treeData.get("parent")).getPkValue().toString(), (CharSequence)entry.getPkValue().toString()));
            if (hasParent) continue;
            TreeNode treeNode = this.constructTreeNode(treeData, childMap, null);
            treeNodeList.add(treeNode);
        }
        return treeNodeList;
    }

    private TreeNode constructTreeNode(DynamicObject treeData, Map<Long, DynamicObjectCollection> childMap, String parentId) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)"bd_projectkind");
        String nameProperty = ((BasedataEntityType)refMainType).getNameProperty();
        nameProperty = StringUtils.isBlank((CharSequence)nameProperty) ? "name" : nameProperty;
        String treeNodeName = treeData.get(nameProperty).toString();
        TreeNode treeNode = new TreeNode(parentId, treeData.getPkValue().toString(), treeNodeName, true);
        Long dataId = (Long)treeData.getPkValue();
        if (null == childMap.get(dataId)) {
            treeNode.setChildren(null);
            return treeNode;
        }
        DynamicObjectCollection childDataCol = childMap.get(dataId);
        for (DynamicObject childData : childDataCol) {
            TreeNode childNode = this.constructTreeNode(childData, childMap, treeNode.getId());
            treeNode.addChild(childNode);
        }
        return treeNode;
    }

    private Map<Long, DynamicObjectCollection> getChildMap(DynamicObject[] allNodes) {
        HashMap<Long, DynamicObjectCollection> childMap = new HashMap<Long, DynamicObjectCollection>();
        for (DynamicObject treeData : allNodes) {
            if (treeData.get("parent") == null) continue;
            DynamicObject parent = (DynamicObject)treeData.get("parent");
            Long parentId = (Long)parent.getPkValue();
            DynamicObjectCollection col = childMap.get(parentId) != null ? (DynamicObjectCollection)childMap.get(parentId) : new DynamicObjectCollection();
            col.add((Object)treeData);
            childMap.put((Long)parent.getPkValue(), col);
        }
        return childMap;
    }

    public DynamicObject[] getAuthorizedProjectKindList(List<QFilter> filterList, Long orgId) {
        DynamicObject[] pmgtProKinds;
        if (filterList == null) {
            filterList = new ArrayList<QFilter>(10);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        filterList.add(enableFilter);
        filterList.add(statusFilter);
        ArrayList<Object> pmgtProKindIdList = new ArrayList<Object>(10);
        for (DynamicObject pmgtProKind : pmgtProKinds = BusinessDataServiceHelper.load((String)"pmbs_projectkind", (String)"number", (QFilter[])filterList.toArray(new QFilter[0]))) {
            pmgtProKindIdList.add(pmgtProKind.getPkValue());
        }
        QFilter proKindIdFilter = new QFilter("id", "in", pmgtProKindIdList);
        boolean needCtrlStrategyTree = this.needCtrlStrategyTree();
        if (needCtrlStrategyTree) {
            QFilter ctrlStrategyFilter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"bd_projectkind", (Long)orgId);
            proKindIdFilter.and(ctrlStrategyFilter);
            logger.info("getAuthorizedProjectKindList_ctrlStrategyFilter: {}", (Object)ctrlStrategyFilter);
        }
        logger.info("getAuthorizedProjectKindList_proKindIdFilter: {}", (Object)proKindIdFilter);
        String queryProperties = String.join((CharSequence)",", "id", "parent", "isleaf", "level");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_projectkind", (String)queryProperties, (QFilter[])new QFilter[]{statusFilter, enableFilter, proKindIdFilter});
        Arrays.sort(dynamicObjects, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Collator instance = Collator.getInstance();
                String source = o1.getLocaleString("name").getLocaleValue() != null ? o1.getLocaleString("name").getLocaleValue() : "";
                String target = o2.getLocaleString("name").getLocaleValue() != null ? o2.getLocaleString("name").getLocaleValue() : "";
                return instance.compare(source, target);
            }
        });
        return dynamicObjects;
    }
}

