/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.BudgetControlTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;
import kd.pmgt.pmbs.common.tree.Tree;
import kd.pmgt.pmbs.common.tree.TreeNode;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;

public class OutBudgetReportHelper {
    protected static String[] proBudgetColumnKeys = new String[]{"name", "number", "budgetsumamount", "sumbudamt", "budgetamount", "remindamt", "controlamt", "remindrate", "controlrate", "occupyamt", "performamt", "actualpayamount", "budgetusedamt", "costamt", "remainamt", "remainrate"};
    protected static String[] proBudgetHeaders = new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u9879\u540d\u79f0", (String)"OutBudgetReportHelper_1", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9884\u7b97\u9879\u7f16\u7801", (String)"OutBudgetReportHelper_2", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u603b\u4f53\u9884\u7b97\u91d1\u989d", (String)"OutBudgetReportHelper_3", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e74\u5ea6\u7d2f\u8ba1\u9884\u7b97\u91d1\u989d", (String)"OutBudgetReportHelper_4", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e74\u5ea6\u9884\u7b97\u91d1\u989d", (String)"OutBudgetReportHelper_5", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u63d0\u9192\u9650\u989d", (String)"OutBudgetReportHelper_6", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f3a\u63a7\u9650\u989d", (String)"OutBudgetReportHelper_7", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u63d0\u9192\u5360\u6bd4\uff08%\uff09", (String)"OutBudgetReportHelper_33", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f3a\u63a7\u5360\u6bd4\uff08%\uff09", (String)"OutBudgetReportHelper_34", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5360\u7528\u91d1\u989d", (String)"OutBudgetReportHelper_8", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d", (String)"OutBudgetReportHelper_9", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b9e\u4ed8\u91d1\u989d", (String)"OutBudgetReportHelper_10", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9884\u7b97\u4f7f\u7528\u91d1\u989d", (String)"OutBudgetReportHelper_11", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6210\u672c\u786e\u8ba4\u91d1\u989d", (String)"OutBudgetReportHelper_12", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5269\u4f59\u91d1\u989d", (String)"OutBudgetReportHelper_13", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5269\u4f59\u6bd4\u4f8b\uff08%\uff09", (String)"OutBudgetReportHelper_14", (String)"pmgt-pmbs-business", (Object[])new Object[0])};
    protected static String[] contBudgetColumnKeys = new String[]{"name", "contbillno", "contbillname", "contbillstatus", "occupyamount", "contractsubmitamt", "settlesubmitamt", "applysubmitamt", "paysubmitamt", "contcostsplitamt"};
    protected static String[] contBudgetHeaders = new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u9879\u540d\u79f0", (String)"OutBudgetReportHelper_1", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"OutBudgetReportHelper_15", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0", (String)"OutBudgetReportHelper_16", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"OutBudgetReportHelper_17", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672c\u5408\u540c\u5df2\u5360\u7528\u9884\u7b97\u91d1\u989d", (String)"OutBudgetReportHelper_18", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u2460", (String)"OutBudgetReportHelper_19", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u2461", (String)"OutBudgetReportHelper_20", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u2462", (String)"OutBudgetReportHelper_21", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b9e\u4ed8\u7d2f\u8ba1\u9884\u7b97\u5360\u7528\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u2463", (String)"OutBudgetReportHelper_22", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7d2f\u8ba1\u5408\u540c\u6210\u672c\u5206\u644a\u91d1\u989d", (String)"OutBudgetReportHelper_23", (String)"pmgt-pmbs-business", (Object[])new Object[0])};
    protected static String[] budgetRecordColumnKeys = new String[]{"name", "contbillno", "contbillname", "billtype", "billno", "billname", "billamt", "billstatus", "billcreator", "billcreatedate", "billauditor", "billauditdate"};
    protected static String[] budgetRecordHeaders = new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u9879\u540d\u79f0", (String)"OutBudgetReportHelper_1", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u7f16\u7801", (String)"OutBudgetReportHelper_24", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0", (String)"OutBudgetReportHelper_25", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7c7b\u578b", (String)"OutBudgetReportHelper_26", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"OutBudgetReportHelper_15", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0", (String)"OutBudgetReportHelper_16", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d\uff08\u9879\u76ee\u5e01\uff09", (String)"OutBudgetReportHelper_27", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"OutBudgetReportHelper_17", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"OutBudgetReportHelper_28", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u65e5\u671f", (String)"OutBudgetReportHelper_29", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6838\u4eba", (String)"OutBudgetReportHelper_30", (String)"pmgt-pmbs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6838\u65e5\u671f", (String)"OutBudgetReportHelper_31", (String)"pmgt-pmbs-business", (Object[])new Object[0])};

    public static DynamicObject buildBudgetEntry(DynamicObject budget, DynamicObjectType dt, Set<Long> parentIdSet, Map<Object, BigDecimal> budgetToCostAmtMap) {
        DynamicObject budgetEntry = new DynamicObject(dt);
        budgetEntry.set("id", budget.getPkValue());
        if (budget.get("parent") != null) {
            budgetEntry.set("pid", (Object)budget.getLong("parent"));
        }
        budgetEntry.set("name", budget.get("name"));
        budgetEntry.set("number", budget.get("number"));
        BigDecimal budgetAmount = budget.getBigDecimal("budgetamount");
        budgetEntry.set("budgetamount", (Object)budgetAmount);
        budgetEntry.set("remindamt", budget.get("remindamt"));
        budgetEntry.set("controlamt", budget.get("controlamt"));
        budgetEntry.set("preoccupyamt", budget.get("preoccupyamt"));
        budgetEntry.set("occupyamt", budget.get("occupyamt"));
        budgetEntry.set("performamt", budget.get("performamt"));
        budgetEntry.set("actualpayamount", (Object)budget.getBigDecimal("actualamt"));
        BigDecimal remainAmt = budgetAmount.subtract(budget.getBigDecimal("occupyamt"));
        budgetEntry.set("remainamt", (Object)remainAmt);
        if (budgetAmount.compareTo(BigDecimal.ZERO) != 0) {
            budgetEntry.set("remainrate", (Object)remainAmt.divide(budgetAmount, 10, RoundingMode.HALF_UP));
        }
        BigDecimal maxUsedAmt = OutBudgetReportHelper.getMaxUsedAmt(budget);
        budgetEntry.set("budgetusedamt", (Object)maxUsedAmt.add(budget.getBigDecimal("procostamt")));
        BigDecimal costAmt = budgetToCostAmtMap.get(budget.getPkValue());
        if (costAmt != null) {
            budgetEntry.set("costamt", (Object)costAmt.add(budget.getBigDecimal("procostamt")));
        } else {
            budgetEntry.set("costamt", (Object)budget.getBigDecimal("procostamt"));
        }
        budgetEntry.set("budgetcurrency", budget.get("currency"));
        if (!parentIdSet.contains(budget.getLong("id"))) {
            budgetEntry.set("isleaf", (Object)true);
            budgetEntry.set("checkbill", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u5355\u636e", (String)"OutBudgetReportHelper_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        }
        return budgetEntry;
    }

    public static Map<Object, BigDecimal> getBudgetCostAmtByPro(DynamicObject project) {
        HashMap<Object, BigDecimal> budgetCostAmtMap = new HashMap<Object, BigDecimal>(16);
        if (project != null) {
            DynamicObject[] payApplyCostBills;
            QFilter proFilter;
            QFilter statusFilter;
            String selectProperties = String.join((CharSequence)",", "costamount", "entryentity", "subentryentity", "budgetitem", "amount", "currency");
            DynamicObject[] contractCostBills = BusinessDataServiceHelper.load((String)"pmco_contractcost", (String)selectProperties, (QFilter[])new QFilter[]{statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()), proFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()))});
            if (contractCostBills.length != 0) {
                BigDecimal costAmt = Arrays.stream(contractCostBills).map(o -> o.getBigDecimal("costamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                budgetCostAmtMap.put(project.getPkValue(), costAmt);
                OutBudgetReportHelper.getBudgetCostAmtByConCost(contractCostBills, budgetCostAmtMap, project.getPkValue().toString());
            }
            if ((payApplyCostBills = BusinessDataServiceHelper.load((String)"pmco_payapplycostsplit", (String)(selectProperties = String.join((CharSequence)",", "costamount", "costdetails", "costsplitdetails", "probudget", "splitamount", "curreney")), (QFilter[])new QFilter[]{statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()), proFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()))})).length == 0) {
                return budgetCostAmtMap;
            }
            BigDecimal costAmt = Arrays.stream(payApplyCostBills).map(o -> o.getBigDecimal("costamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal totalCostAmt = (BigDecimal)budgetCostAmtMap.get(project.getPkValue());
            totalCostAmt = totalCostAmt != null ? totalCostAmt.add(costAmt) : costAmt;
            budgetCostAmtMap.put(project.getPkValue(), totalCostAmt);
            OutBudgetReportHelper.getBudgetCostAmtByPayApplyCost(payApplyCostBills, budgetCostAmtMap, project.getPkValue().toString());
        }
        return budgetCostAmtMap;
    }

    protected static void getBudgetCostAmtByConCost(DynamicObject[] contractCostBills, Map<Object, BigDecimal> budgetCostAmtMap, String projectId) {
        DynamicObject proApp;
        DynamicObject project = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(projectId))});
        DynamicObject proCurrency = null;
        if (project != null && (proApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())})) != null) {
            proCurrency = proApp.getDynamicObject("currencyfield");
        }
        for (DynamicObject contractCostObj : contractCostBills) {
            DynamicObject stdCurrency = contractCostObj.getDynamicObject("currency");
            BigDecimal exchangeRate = OutBudgetReportHelper.getExchangeRate(stdCurrency, proCurrency, Long.parseLong(projectId));
            DynamicObjectCollection contCostEntryEntity = contractCostObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject contCostEntryRow : contCostEntryEntity) {
                DynamicObjectCollection contCostSubEntryEntity = contCostEntryRow.getDynamicObjectCollection("subentryentity");
                for (DynamicObject contCostSubEntryRow : contCostSubEntryEntity) {
                    DynamicObject budgetItem = contCostSubEntryRow.getDynamicObject("budgetitem");
                    if (budgetItem == null) continue;
                    BigDecimal costAmt = budgetCostAmtMap.get(budgetItem.getPkValue());
                    costAmt = costAmt != null ? costAmt.add(contCostSubEntryRow.getBigDecimal("amount").multiply(exchangeRate)) : contCostSubEntryRow.getBigDecimal("amount").multiply(exchangeRate);
                    budgetCostAmtMap.put(budgetItem.getPkValue(), costAmt);
                }
            }
        }
    }

    public static void getBudgetCostAmtByPayApplyCost(DynamicObject[] payApplyCostBills, Map<Object, BigDecimal> budgetCostAmtMap, String projectId) {
        DynamicObject proApp;
        DynamicObject project = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(projectId))});
        DynamicObject proCurrency = null;
        if (project != null && (proApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())})) != null) {
            proCurrency = proApp.getDynamicObject("currencyfield");
        }
        for (DynamicObject payApplyCostBill : payApplyCostBills) {
            DynamicObject stdCurrency = payApplyCostBill.getDynamicObject("curreney");
            BigDecimal exchangeRate = OutBudgetReportHelper.getExchangeRate(stdCurrency, proCurrency, Long.parseLong(projectId));
            DynamicObjectCollection costEntryEntity = payApplyCostBill.getDynamicObjectCollection("costdetails");
            for (DynamicObject costEntryRow : costEntryEntity) {
                DynamicObjectCollection costSubEntryEntity = costEntryRow.getDynamicObjectCollection("costsplitdetails");
                for (DynamicObject costSubEntry : costSubEntryEntity) {
                    DynamicObject proBudget = costSubEntry.getDynamicObject("probudget");
                    if (proBudget == null) continue;
                    BigDecimal costAmt = budgetCostAmtMap.get(proBudget.getPkValue());
                    costAmt = costAmt != null ? costAmt.add(costSubEntry.getBigDecimal("splitamount").multiply(exchangeRate)) : costSubEntry.getBigDecimal("splitamount").multiply(exchangeRate);
                    budgetCostAmtMap.put(proBudget.getPkValue(), costAmt);
                }
            }
        }
    }

    private static BigDecimal getMaxUsedAmt(DynamicObject budget) {
        DynamicObjectCollection performEntry = budget.getDynamicObjectCollection("performentry");
        BigDecimal settledAmt = BigDecimal.ZERO;
        for (DynamicObject performEntryRow : performEntry) {
            String performAmtType = performEntryRow.getString("performamttype");
            String billStatus = performEntryRow.getString("billstatus");
            if (!StringUtils.equals((CharSequence)performAmtType, (CharSequence)PerformAmountTypeEnum.SETTLE.getValue()) || !StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue())) continue;
            BigDecimal billamt = performEntryRow.getBigDecimal("billamt");
            settledAmt = settledAmt.add(billamt);
        }
        BigDecimal performAmt = budget.getBigDecimal("performamt");
        BigDecimal actualAmt = budget.getBigDecimal("actualamt");
        BigDecimal maxUsedAmt = settledAmt.compareTo(performAmt) > 0 ? settledAmt : performAmt;
        maxUsedAmt = maxUsedAmt.compareTo(actualAmt) > 0 ? maxUsedAmt : actualAmt;
        return maxUsedAmt;
    }

    public static void fillPerformBillEntry(Long proBudgetId, String billId, DynamicObjectCollection entryEntity, String columnName) {
        String performAmtType = null;
        if (StringUtils.equals((CharSequence)columnName, (CharSequence)"contractsubmitamt")) {
            performAmtType = PerformAmountTypeEnum.CONTRACT.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"settlesubmitamt")) {
            performAmtType = PerformAmountTypeEnum.SETTLE.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"applysubmitamt")) {
            performAmtType = PerformAmountTypeEnum.PAY.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"paysubmitamt")) {
            performAmtType = PerformAmountTypeEnum.ACTUAL_PAY.getValue();
        } else if (StringUtils.equals((CharSequence)columnName, (CharSequence)"occupyamount")) {
            performAmtType = "";
        }
        DynamicObject budgetPerform = BusinessDataServiceHelper.loadSingle((Object)proBudgetId, (String)"pmas_projectbudgetperform");
        if (budgetPerform != null) {
            DynamicObject proCurrency = budgetPerform.getDynamicObject("currency");
            DynamicObject pro = budgetPerform.getDynamicObject("project");
            DynamicObjectType dt = entryEntity.getDynamicObjectType();
            DynamicObjectCollection performEntry = budgetPerform.getDynamicObjectCollection("performentry");
            for (DynamicObject performEntryObj : performEntry) {
                DynamicObject performEntryObject = OutBudgetReportHelper.buildPerformBillEntry(performEntryObj, dt, proCurrency, performAmtType, billId);
                if (performEntryObject == null) continue;
                entryEntity.add((Object)performEntryObject);
            }
            if (StringUtils.equals((CharSequence)columnName, (CharSequence)"contcostsplitamt")) {
                OutBudgetReportHelper.buildContCostSplitEntry(proBudgetId, billId, pro.getPkValue(), proCurrency, entryEntity);
            }
        }
    }

    public static DynamicObject buildPerformBillEntry(DynamicObject performEntryObj, DynamicObjectType dt, DynamicObject proCurrency, String performAmtType, String billId) {
        DynamicObject budgetEntry = null;
        DynamicObject contract = performEntryObj.getDynamicObject("contract");
        String curPerformAmtType = performEntryObj.getString("performamttype");
        if (contract != null) {
            if (StringUtils.equals((CharSequence)contract.getString("id"), (CharSequence)billId) && (StringUtils.equals((CharSequence)"", (CharSequence)performAmtType) || StringUtils.equals((CharSequence)curPerformAmtType, (CharSequence)performAmtType))) {
                budgetEntry = OutBudgetReportHelper.buildBudgetEntry(performEntryObj, dt, proCurrency);
            }
        } else {
            Long relateBillId = performEntryObj.getLong("billid");
            if (StringUtils.isNotEmpty((CharSequence)billId) && relateBillId.equals(Long.parseLong(billId)) && StringUtils.equalsIgnoreCase((CharSequence)performEntryObj.getString("performamttype"), (CharSequence)PerformAmountTypeEnum.OTHER.getValue())) {
                budgetEntry = OutBudgetReportHelper.buildBudgetEntry(performEntryObj, dt, proCurrency);
            }
        }
        return budgetEntry;
    }

    public static DynamicObject buildBudgetEntry(DynamicObject performEntryObj, DynamicObjectType dt, DynamicObject proCurrency) {
        DynamicObject budgetEntry = new DynamicObject(dt);
        budgetEntry.set("id", performEntryObj.getPkValue());
        budgetEntry.set("performtype", performEntryObj.get("performtype"));
        budgetEntry.set("billtype", (Object)performEntryObj.getDynamicObject("billtype"));
        budgetEntry.set("billno", (Object)performEntryObj.getString("billno"));
        budgetEntry.set("billname", (Object)performEntryObj.getString("billname"));
        budgetEntry.set("billamt", (Object)performEntryObj.getBigDecimal("billamt"));
        budgetEntry.set("billstatus", (Object)performEntryObj.getString("billstatus"));
        budgetEntry.set("billcreator", (Object)performEntryObj.getDynamicObject("billcreator"));
        budgetEntry.set("billcreatedate", (Object)performEntryObj.getDate("billcreatedate"));
        budgetEntry.set("billauditor", (Object)performEntryObj.getDynamicObject("billauditor"));
        budgetEntry.set("billauditdate", (Object)performEntryObj.getDate("billauditdate"));
        budgetEntry.set("billid", (Object)performEntryObj.getLong("billid"));
        if (proCurrency != null) {
            budgetEntry.set("billcurrency", (Object)proCurrency);
        }
        return budgetEntry;
    }

    private static void buildContCostSplitEntry(Long proBudgetId, String contractId, Object proPk, DynamicObject proCurrency, DynamicObjectCollection entryEntity) {
        DynamicObjectType dt = entryEntity.getDynamicObjectType();
        QFilter proFilter = new QFilter("project", "=", (Object)Long.parseLong(proPk.toString()));
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter entryContFilter = new QFilter("entryentity.contract", "=", (Object)Long.parseLong(contractId));
        DynamicObject[] costObjs = BusinessDataServiceHelper.load((String)"pmco_contractcost", (String)"billno,billname,billstatus,creator,createtime,auditor,auditdate,entryentity,contract,subentryentity,budgetitem,amount,currency", (QFilter[])new QFilter[]{proFilter, statusFilter, entryContFilter});
        HashMap<Object, BigDecimal> contToCostAmtMap = new HashMap<Object, BigDecimal>(costObjs.length);
        HashSet<DynamicObject> contCostSet = new HashSet<DynamicObject>(costObjs.length);
        for (DynamicObject costObj : costObjs) {
            DynamicObject stdCurrency = costObj.getDynamicObject("currency");
            BigDecimal exchangeRate = OutBudgetReportHelper.getExchangeRate(stdCurrency, proCurrency, Long.parseLong(proPk.toString()));
            DynamicObjectCollection contSettleEntry = costObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject contSettleEntryRow : contSettleEntry) {
                long entryContId = contSettleEntryRow.getLong("contract.id");
                if (entryContId != Long.parseLong(contractId)) continue;
                DynamicObjectCollection costSplitSubEntry = contSettleEntryRow.getDynamicObjectCollection("subentryentity");
                for (DynamicObject costSplitSubEntryRow : costSplitSubEntry) {
                    DynamicObject budgetItem = costSplitSubEntryRow.getDynamicObject("budgetitem");
                    if (budgetItem == null || budgetItem.getLong("id") != proBudgetId.longValue()) continue;
                    contCostSet.add(costObj);
                    BigDecimal costAmt = (BigDecimal)contToCostAmtMap.get(costObj.getPkValue());
                    costAmt = costAmt != null ? costAmt.add(costSplitSubEntryRow.getBigDecimal("amount").multiply(exchangeRate)) : costSplitSubEntryRow.getBigDecimal("amount").multiply(exchangeRate);
                    contToCostAmtMap.put(costObj.getPkValue(), costAmt);
                }
            }
        }
        QFilter filter = new QFilter("number", "=", (Object)"pmco_contractcost");
        DynamicObject objectType = BusinessDataServiceHelper.loadSingle((String)"bos_objecttype", (String)"", (QFilter[])new QFilter[]{filter});
        if (!contCostSet.isEmpty()) {
            for (DynamicObject contCostObj : contCostSet) {
                DynamicObject budgetEntry = new DynamicObject(dt);
                budgetEntry.set("id", contCostObj.getPkValue());
                budgetEntry.set("billtype", (Object)objectType);
                budgetEntry.set("billno", (Object)contCostObj.getString("billno"));
                budgetEntry.set("billname", (Object)contCostObj.getString("billname"));
                budgetEntry.set("billamt", contToCostAmtMap.get(contCostObj.getPkValue()));
                budgetEntry.set("billstatus", (Object)contCostObj.getString("billstatus"));
                budgetEntry.set("billcreator", (Object)contCostObj.getDynamicObject("creator"));
                budgetEntry.set("billcreatedate", (Object)contCostObj.getDate("createtime"));
                budgetEntry.set("billauditor", (Object)contCostObj.getDynamicObject("auditor"));
                budgetEntry.set("billauditdate", (Object)contCostObj.getDate("auditdate"));
                budgetEntry.set("billid", contCostObj.getPkValue());
                if (proCurrency != null) {
                    budgetEntry.set("billcurrency", (Object)proCurrency);
                }
                entryEntity.add((Object)budgetEntry);
            }
        }
    }

    public static BigDecimal getExchangeRate(DynamicObject stdCurrency, DynamicObject targetCurrency, Long projectId) {
        DynamicObject exRateTable;
        DynamicObject pmasCreateOrg;
        QFilter idFilter;
        DynamicObject project;
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (stdCurrency != null && targetCurrency != null && (project = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)"pmascreateorg", (QFilter[])new QFilter[]{idFilter = new QFilter("id", "=", (Object)projectId)})) != null && (pmasCreateOrg = project.getDynamicObject("pmascreateorg")) != null && (exRateTable = CurrencyHelper.getExRateTable((Long)pmasCreateOrg.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)stdCurrency.getLong("id"), (Long)targetCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)Date.from(Instant.now()));
        }
        return exchangeRate;
    }

    public static void buildNewBudgetEntry(DynamicObjectCollection budgetEntryEntity, DynamicObject project, DynamicObject[] budgets, String budgetControlType) {
        if (budgets.length == 0 || project == null) {
            return;
        }
        Set<Long> budgetIds = Arrays.stream(budgets).map(o -> Long.parseLong(o.getPkValue().toString())).collect(Collectors.toSet());
        Map<Object, DynamicObject> totalBudgetCtrlMap = OutBudgetReportHelper.getTotalBudgetCtrlInfo(budgetIds, project);
        Map<Object, DynamicObject> yearBudgetCtrlMap = OutBudgetReportHelper.getYearBudgetCtrlInfo(budgetIds, project);
        Map<Object, BigDecimal> paidApplicationAmtByPro = OutBudgetReportHelper.getPaidApplicationAmtByPro(project);
        Map<Object, BigDecimal> actualPaidAmtByPro = OutBudgetReportHelper.getActualPaidAmtByPro(project);
        BigDecimal oneHundred = new BigDecimal("100");
        for (DynamicObject budgetEntry : budgetEntryEntity) {
            DynamicObject tBudgetControl;
            Object budgetId = budgetEntry.get("id");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)budgetId.toString()) && (tBudgetControl = totalBudgetCtrlMap.get(project.getPkValue())) != null) {
                BigDecimal remindRate = tBudgetControl.getBigDecimal("tremindrate").divide(oneHundred, 10, RoundingMode.HALF_UP);
                budgetEntry.set("remindrate", (Object)remindRate);
                BigDecimal controlRate = tBudgetControl.getBigDecimal("tcontrolrate").divide(oneHundred, 10, RoundingMode.HALF_UP);
                budgetEntry.set("controlrate", (Object)controlRate);
            }
            BigDecimal totalBudgetItemAmt = BigDecimal.ZERO;
            BigDecimal sumBudAmt = BigDecimal.ZERO;
            BigDecimal preOccupyAmt = BigDecimal.ZERO;
            BigDecimal budgetOccupyAmt = BigDecimal.ZERO;
            BigDecimal budgetUsedAmt = BigDecimal.ZERO;
            BigDecimal remindRate = BigDecimal.ZERO;
            BigDecimal controlRate = BigDecimal.ZERO;
            if (!totalBudgetCtrlMap.isEmpty() && totalBudgetCtrlMap.get(budgetId) != null) {
                DynamicObject tBudgetControl2 = totalBudgetCtrlMap.get(budgetId);
                totalBudgetItemAmt = tBudgetControl2.getBigDecimal("budgetamt");
                sumBudAmt = tBudgetControl2.getBigDecimal("sumbudamt");
                preOccupyAmt = tBudgetControl2.getBigDecimal("preoccupyamt");
                budgetOccupyAmt = tBudgetControl2.getBigDecimal("occupyamt");
                budgetUsedAmt = tBudgetControl2.getBigDecimal("usageamt");
                budgetEntry.set("budgetcurrency", (Object)tBudgetControl2.getDynamicObject("currency"));
                if (!ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue().equals(budgetControlType)) {
                    remindRate = tBudgetControl2.getBigDecimal("remindrate");
                    controlRate = tBudgetControl2.getBigDecimal("controlrate");
                }
            }
            budgetEntry.set("budgetsumamount", (Object)totalBudgetItemAmt);
            budgetEntry.set("sumbudamt", (Object)sumBudAmt);
            budgetEntry.set("preoccupyamt", (Object)preOccupyAmt);
            budgetEntry.set("occupyamt", (Object)budgetOccupyAmt);
            budgetEntry.set("budgetusedamt", (Object)budgetUsedAmt);
            if (!ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue().equals(budgetControlType)) {
                budgetEntry.set("remindrate", (Object)remindRate.divide(oneHundred, 10, RoundingMode.HALF_UP));
                budgetEntry.set("controlrate", (Object)controlRate.divide(oneHundred, 10, RoundingMode.HALF_UP));
            }
            budgetEntry.set("remainamt", (Object)totalBudgetItemAmt.subtract(budgetOccupyAmt));
            BigDecimal remainAmt = totalBudgetItemAmt.subtract(budgetOccupyAmt);
            if (totalBudgetItemAmt.compareTo(BigDecimal.ZERO) != 0) {
                budgetEntry.set("remainrate", (Object)remainAmt.divide(totalBudgetItemAmt, 10, RoundingMode.HALF_UP));
            }
            BigDecimal budgetAmount = BigDecimal.ZERO;
            if (!yearBudgetCtrlMap.isEmpty() && yearBudgetCtrlMap.get(budgetId) != null) {
                DynamicObject yBudgetControl = yearBudgetCtrlMap.get(budgetId);
                budgetAmount = yBudgetControl.getBigDecimal("budgetamt");
                if (ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue().equals(budgetControlType)) {
                    remindRate = yBudgetControl.getBigDecimal("remindrate");
                    controlRate = yBudgetControl.getBigDecimal("controlrate");
                }
            }
            budgetEntry.set("budgetamount", (Object)budgetAmount);
            budgetEntry.set("remindrate", (Object)remindRate.divide(oneHundred, 10, RoundingMode.HALF_UP));
            budgetEntry.set("controlrate", (Object)controlRate.divide(oneHundred, 10, RoundingMode.HALF_UP));
            BigDecimal paidApplicationAmt = BigDecimal.ZERO;
            if (!paidApplicationAmtByPro.isEmpty() && paidApplicationAmtByPro.get(budgetId) != null) {
                paidApplicationAmt = paidApplicationAmtByPro.get(budgetId);
            }
            budgetEntry.set("performamt", (Object)paidApplicationAmt);
            BigDecimal actualPaidAmt = BigDecimal.ZERO;
            if (!actualPaidAmtByPro.isEmpty() && actualPaidAmtByPro.get(budgetId) != null) {
                actualPaidAmt = actualPaidAmtByPro.get(budgetId);
            }
            budgetEntry.set("actualpayamount", (Object)actualPaidAmt);
        }
    }

    private static Map<Object, DynamicObject> getTotalBudgetCtrlInfo(Set<Long> budgetIds, DynamicObject project) {
        HashMap<Object, DynamicObject> totalBudgetCtrlMap = new HashMap<Object, DynamicObject>();
        if (budgetIds != null && budgetIds.size() > 0) {
            DynamicObject[] tBudgetControls;
            String selectProperties = String.join((CharSequence)",", "budget", "budgetamt", "sumbudamt", "occupyamt", "preoccupyamt", "usageamt", "remindamt", "controlamt", "remindrate", "controlrate", "currency");
            QFilter qFilter = new QFilter("budget", "in", budgetIds);
            qFilter.and("budgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            for (DynamicObject tBudgetControl : tBudgetControls = BusinessDataServiceHelper.load((String)"pmas_tbudgetctrldetail", (String)selectProperties, (QFilter[])new QFilter[]{qFilter})) {
                DynamicObject budget = tBudgetControl.getDynamicObject("budget");
                if (budget == null) continue;
                totalBudgetCtrlMap.put(budget.getPkValue(), tBudgetControl);
            }
        }
        QFilter qFilter = new QFilter("tproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        qFilter.and("tbudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject tBudgetControl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{qFilter});
        if (tBudgetControl != null) {
            totalBudgetCtrlMap.put(project.getPkValue(), tBudgetControl);
        }
        return totalBudgetCtrlMap;
    }

    private static Map<Object, DynamicObject> getYearBudgetCtrlInfo(Set<Long> budgetIds, DynamicObject project) {
        HashMap<Object, DynamicObject> yearBudgetCtrlMap = new HashMap<Object, DynamicObject>();
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        if (budgetIds != null && budgetIds.size() > 0) {
            DynamicObject[] yBudgetControls;
            String selectProperties = String.join((CharSequence)",", "budget", "budgetamt", "remindamt", "controlamt", "remindrate", "controlrate", "currency");
            QFilter qFilter = new QFilter("budget", "in", budgetIds);
            qFilter.and("YEAR(year)", "=", (Object)year);
            qFilter.and("budgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            for (DynamicObject yBudgetControl : yBudgetControls = BusinessDataServiceHelper.load((String)"pmas_ybudgetctrldetail", (String)selectProperties, (QFilter[])new QFilter[]{qFilter})) {
                DynamicObject budget = yBudgetControl.getDynamicObject("budget");
                if (budget == null) continue;
                yearBudgetCtrlMap.put(budget.getPkValue(), yBudgetControl);
            }
        }
        QFilter qFilter = new QFilter("yproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        qFilter.and("YEAR(yyear)", "=", (Object)year);
        qFilter.and("ybudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject yBudgetControl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{qFilter});
        if (yBudgetControl != null) {
            yearBudgetCtrlMap.put(project.getPkValue(), yBudgetControl);
        }
        return yearBudgetCtrlMap;
    }

    private static Map<Object, BigDecimal> getPaidApplicationAmtByPro(DynamicObject project) {
        HashMap<Object, BigDecimal> paidApplicationAmtMap = new HashMap<Object, BigDecimal>(16);
        if (project != null) {
            BigDecimal totalApplyAmt;
            QFilter proFilter;
            QFilter statusFilter;
            String selectProperties = String.join((CharSequence)",", "sumamount", "entryentity", "payapplysplitentry", "bugdetitem", "cursplitamt", "prepaysplit");
            DynamicObject[] paymentApplyBills = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)selectProperties, (QFilter[])new QFilter[]{statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()), proFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()))});
            if (paymentApplyBills.length != 0) {
                totalApplyAmt = Arrays.stream(paymentApplyBills).map(o -> o.getBigDecimal("sumamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                paidApplicationAmtMap.put(project.getPkValue(), totalApplyAmt);
                for (DynamicObject paymentApplyBill : paymentApplyBills) {
                    DynamicObjectCollection conPayEntry = paymentApplyBill.getDynamicObjectCollection("entryentity");
                    if (conPayEntry.isEmpty()) continue;
                    for (DynamicObject conPay : conPayEntry) {
                        DynamicObjectCollection splitEntry = conPay.getDynamicObjectCollection("payapplysplitentry");
                        if (splitEntry.isEmpty()) continue;
                        for (DynamicObject split : splitEntry) {
                            boolean prePaySplit;
                            DynamicObject budget = split.getDynamicObject("bugdetitem");
                            if (budget == null || (prePaySplit = split.getBoolean("prepaysplit"))) continue;
                            BigDecimal splitAmt = split.getBigDecimal("cursplitamt");
                            Object budgetId = budget.getPkValue();
                            BigDecimal sumSplitAmt = (BigDecimal)paidApplicationAmtMap.get(budgetId);
                            sumSplitAmt = sumSplitAmt == null ? splitAmt : sumSplitAmt.add(splitAmt);
                            paidApplicationAmtMap.put(budgetId, sumSplitAmt);
                        }
                    }
                }
            }
            if ((paymentApplyBills = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)(selectProperties = String.join((CharSequence)",", "curpaytotal", "splitentry", "bugdetitem", "cursplitamt")), (QFilter[])new QFilter[]{statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()), proFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()))})).length != 0) {
                totalApplyAmt = Arrays.stream(paymentApplyBills).map(o -> o.getBigDecimal("curpaytotal")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal proApplyAmt = (BigDecimal)paidApplicationAmtMap.get(project.getPkValue());
                proApplyAmt = proApplyAmt == null ? totalApplyAmt : proApplyAmt.add(totalApplyAmt);
                paidApplicationAmtMap.put(project.getPkValue(), proApplyAmt);
                for (DynamicObject paymentApplyBill : paymentApplyBills) {
                    DynamicObjectCollection splitEntry = paymentApplyBill.getDynamicObjectCollection("splitentry");
                    if (splitEntry.isEmpty()) continue;
                    for (DynamicObject split : splitEntry) {
                        DynamicObject budget = split.getDynamicObject("bugdetitem");
                        if (budget == null) continue;
                        BigDecimal splitAmt = split.getBigDecimal("cursplitamt");
                        Object budgetId = budget.getPkValue();
                        BigDecimal sumSplitAmt = (BigDecimal)paidApplicationAmtMap.get(budgetId);
                        sumSplitAmt = sumSplitAmt == null ? splitAmt : sumSplitAmt.add(splitAmt);
                        paidApplicationAmtMap.put(budgetId, sumSplitAmt);
                    }
                }
            }
            OutBudgetReportHelper.getProCostSplit(project, paidApplicationAmtMap);
        }
        return paidApplicationAmtMap;
    }

    private static Map<Object, BigDecimal> getActualPaidAmtByPro(DynamicObject project) {
        HashMap<Object, BigDecimal> actualPaidAmtMap = new HashMap<Object, BigDecimal>(16);
        if (project != null) {
            QFilter proFilter;
            QFilter statusFilter;
            String selectProperties = String.join((CharSequence)",", "entryentity", "thispaymentoftaxamount", "subentryentity", "budgetitem", "curactualpaysplitamt");
            DynamicObject[] paymentRegisterBills = BusinessDataServiceHelper.load((String)"pmct_paymentregister", (String)selectProperties, (QFilter[])new QFilter[]{statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()), proFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()))});
            if (paymentRegisterBills.length != 0) {
                BigDecimal sumRegisterAmt = BigDecimal.ZERO;
                for (DynamicObject paymentRegisterBill : paymentRegisterBills) {
                    DynamicObjectCollection payInfoColl = paymentRegisterBill.getDynamicObjectCollection("entryentity");
                    if (payInfoColl.isEmpty()) continue;
                    BigDecimal curPayInfoAmt = payInfoColl.stream().map(o -> o.getBigDecimal("thispaymentoftaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    sumRegisterAmt = sumRegisterAmt.add(curPayInfoAmt);
                    for (DynamicObject payInfo : payInfoColl) {
                        DynamicObjectCollection paySplit = payInfo.getDynamicObjectCollection("subentryentity");
                        if (paySplit.isEmpty()) continue;
                        for (DynamicObject split : paySplit) {
                            DynamicObject budget = split.getDynamicObject("budgetitem");
                            if (budget == null) continue;
                            BigDecimal splitAmt = split.getBigDecimal("curactualpaysplitamt");
                            Object budgetId = budget.getPkValue();
                            BigDecimal sumSplitAmt = (BigDecimal)actualPaidAmtMap.get(budgetId);
                            sumSplitAmt = sumSplitAmt == null ? splitAmt : sumSplitAmt.add(splitAmt);
                            actualPaidAmtMap.put(budgetId, sumSplitAmt);
                        }
                    }
                }
                actualPaidAmtMap.put(project.getPkValue(), sumRegisterAmt);
            }
            OutBudgetReportHelper.getProCostSplit(project, actualPaidAmtMap);
        }
        return actualPaidAmtMap;
    }

    private static void getProCostSplit(DynamicObject project, Map<Object, BigDecimal> sumAmtMap) {
        QFilter proFilter;
        QFilter statusFilter;
        String selectProperties;
        DynamicObject[] proCostSplitBills;
        if (project != null && (proCostSplitBills = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)(selectProperties = String.join((CharSequence)",", "totalcostamt", "procostsplitentry", "budgetitem", "costamt")), (QFilter[])new QFilter[]{statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()), proFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()))})).length != 0) {
            BigDecimal totalProCostSplitAmt = Arrays.stream(proCostSplitBills).map(o -> o.getBigDecimal("totalcostamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal totalAmt = sumAmtMap.get(project.getPkValue());
            totalAmt = totalAmt == null ? totalProCostSplitAmt : totalAmt.add(totalProCostSplitAmt);
            sumAmtMap.put(project.getPkValue(), totalAmt);
            for (DynamicObject proCostSplitBill : proCostSplitBills) {
                DynamicObjectCollection splitEntry = proCostSplitBill.getDynamicObjectCollection("procostsplitentry");
                if (splitEntry.isEmpty()) continue;
                for (DynamicObject split : splitEntry) {
                    DynamicObject budget = split.getDynamicObject("budgetitem");
                    if (budget == null) continue;
                    BigDecimal splitAmt = split.getBigDecimal("costamt");
                    Object budgetId = budget.getPkValue();
                    BigDecimal sumSplitAmt = sumAmtMap.get(budgetId);
                    sumSplitAmt = sumSplitAmt == null ? splitAmt : sumSplitAmt.add(splitAmt);
                    sumAmtMap.put(budgetId, sumSplitAmt);
                }
            }
        }
    }

    public static void fillFirstEntryByNoBudget(DynamicObjectCollection budgetEntryEntity, DynamicObject project) {
        BigDecimal budgetCostAmt;
        BigDecimal actualPaidAmt;
        BigDecimal paidApplicationAmt;
        DynamicObject yearBudgetCtrl;
        if (project == null) {
            return;
        }
        Map<Object, DynamicObject> totalBudgetCtrlMap = OutBudgetReportHelper.getTotalBudgetCtrlInfo(null, project);
        Map<Object, DynamicObject> yearBudgetCtrlMap = OutBudgetReportHelper.getYearBudgetCtrlInfo(null, project);
        Map<Object, BigDecimal> paidApplicationAmtByPro = OutBudgetReportHelper.getPaidApplicationAmtByPro(project);
        Map<Object, BigDecimal> actualPaidAmtByPro = OutBudgetReportHelper.getActualPaidAmtByPro(project);
        Map<Object, BigDecimal> budgetCostAmtMap = OutBudgetReportHelper.getBudgetCostAmtByPro(project);
        ProBudgetCtrlEnums budgetControlType = ProBudgetControlHelper.getProjectBudgetControlType(project);
        DynamicObject budgetEntry = (DynamicObject)budgetEntryEntity.get(0);
        DynamicObject tBudgetControl = totalBudgetCtrlMap.get(project.getPkValue());
        if (tBudgetControl != null) {
            BigDecimal tBudgetAmt = tBudgetControl.getBigDecimal("tbudgetamt");
            budgetEntry.set("budgetsumamount", (Object)tBudgetAmt);
            budgetEntry.set("sumbudamt", (Object)tBudgetControl.getBigDecimal("tsumbudamt"));
            budgetEntry.set("preoccupyamt", (Object)tBudgetControl.getBigDecimal("tpreoccupyamt"));
            BigDecimal tOccupyAmt = tBudgetControl.getBigDecimal("toccupyamt");
            budgetEntry.set("occupyamt", (Object)tOccupyAmt);
            budgetEntry.set("budgetusedamt", (Object)tBudgetControl.getBigDecimal("tusageamt"));
            budgetEntry.set("budgetcurrency", (Object)tBudgetControl.getDynamicObject("tcurrency"));
            if (!ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue().equals(budgetControlType.getValue())) {
                budgetEntry.set("remindrate", (Object)tBudgetControl.getBigDecimal("tremindrate"));
                budgetEntry.set("controlrate", (Object)tBudgetControl.getBigDecimal("tcontrolrate"));
            }
            budgetEntry.set("remainamt", (Object)tBudgetAmt.subtract(tOccupyAmt));
            BigDecimal remainAmt = tBudgetAmt.subtract(tOccupyAmt);
            if (tBudgetAmt.compareTo(BigDecimal.ZERO) != 0) {
                budgetEntry.set("remainrate", (Object)remainAmt.divide(tBudgetAmt, 10, RoundingMode.HALF_UP));
            }
        }
        if ((yearBudgetCtrl = yearBudgetCtrlMap.get(project.getPkValue())) != null) {
            budgetEntry.set("budgetamount", (Object)yearBudgetCtrl.getBigDecimal("ybudgetamt"));
            if (ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue().equals(budgetControlType.getValue())) {
                budgetEntry.set("remindrate", (Object)yearBudgetCtrl.getBigDecimal("yremindrate"));
                budgetEntry.set("controlrate", (Object)yearBudgetCtrl.getBigDecimal("ycontrolrate"));
            }
        }
        if ((paidApplicationAmt = paidApplicationAmtByPro.get(project.getPkValue())) != null) {
            budgetEntry.set("performamt", (Object)paidApplicationAmt);
        }
        if ((actualPaidAmt = actualPaidAmtByPro.get(project.getPkValue())) != null) {
            budgetEntry.set("actualpayamount", (Object)actualPaidAmt);
        }
        if ((budgetCostAmt = budgetCostAmtMap.get(project.getPkValue())) != null) {
            budgetEntry.set("costamt", (Object)budgetCostAmt);
        }
    }

    public static void buildParentBudgetEntry(Set<Long> parentIdSet, DynamicObjectCollection budgetEntryEntity) {
        HashMap<Long, BigDecimal> occupyAmtMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> performAmtMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> actualPaidAmtMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> budgetUseAmtMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> costAmtMap = new HashMap<Long, BigDecimal>();
        int size = budgetEntryEntity.size();
        for (int i = size - 1; i >= 0; --i) {
            DynamicObject entry = (DynamicObject)budgetEntryEntity.get(i);
            long id = entry.getLong("id");
            long parentId = entry.getLong("pid");
            BigDecimal occupyAmt = entry.getBigDecimal("occupyamt");
            BigDecimal performAmt = entry.getBigDecimal("performamt");
            BigDecimal actualPaidAmt = entry.getBigDecimal("actualpayamount");
            BigDecimal budgetUseAmt = entry.getBigDecimal("budgetusedamt");
            BigDecimal costAmt = entry.getBigDecimal("costamt");
            BigDecimal parentOccupyAmt = (BigDecimal)occupyAmtMap.get(id);
            BigDecimal parentPerformAmt = (BigDecimal)performAmtMap.get(id);
            BigDecimal parentActualPaidAmt = (BigDecimal)actualPaidAmtMap.get(id);
            BigDecimal parentBudgetUseAmt = (BigDecimal)budgetUseAmtMap.get(id);
            BigDecimal parentCostAmt = (BigDecimal)costAmtMap.get(id);
            if (parentIdSet.contains(id)) {
                if (parentOccupyAmt != null) {
                    entry.set("occupyamt", (Object)parentOccupyAmt);
                    BigDecimal totalBudgetAmt = entry.getBigDecimal("budgetsumamount");
                    entry.set("remainamt", (Object)totalBudgetAmt.subtract(parentOccupyAmt));
                    BigDecimal remainAmt = totalBudgetAmt.subtract(parentOccupyAmt);
                    if (totalBudgetAmt.compareTo(BigDecimal.ZERO) != 0) {
                        entry.set("remainrate", (Object)remainAmt.divide(totalBudgetAmt, 10, RoundingMode.HALF_UP));
                    }
                    occupyAmt = parentOccupyAmt;
                }
                if (parentPerformAmt != null) {
                    entry.set("performamt", (Object)parentPerformAmt);
                    performAmt = parentPerformAmt;
                }
                if (parentActualPaidAmt != null) {
                    entry.set("actualpayamount", (Object)parentActualPaidAmt);
                    actualPaidAmt = parentActualPaidAmt;
                }
                if (parentBudgetUseAmt != null) {
                    entry.set("budgetusedamt", (Object)parentBudgetUseAmt);
                    budgetUseAmt = parentBudgetUseAmt;
                }
                if (parentCostAmt != null) {
                    entry.set("costamt", (Object)parentCostAmt);
                    costAmt = parentCostAmt;
                }
            }
            if (!parentIdSet.contains(parentId)) continue;
            if (occupyAmtMap.get(parentId) == null) {
                occupyAmtMap.put(parentId, occupyAmt);
            } else {
                parentOccupyAmt = occupyAmt.add((BigDecimal)occupyAmtMap.get(parentId));
                occupyAmtMap.put(parentId, parentOccupyAmt);
            }
            if (performAmtMap.get(parentId) == null) {
                performAmtMap.put(parentId, performAmt);
            } else {
                parentPerformAmt = performAmt.add((BigDecimal)performAmtMap.get(parentId));
                performAmtMap.put(parentId, parentPerformAmt);
            }
            if (actualPaidAmtMap.get(parentId) == null) {
                actualPaidAmtMap.put(parentId, actualPaidAmt);
            } else {
                parentActualPaidAmt = actualPaidAmt.add((BigDecimal)actualPaidAmtMap.get(parentId));
                actualPaidAmtMap.put(parentId, parentActualPaidAmt);
            }
            if (budgetUseAmtMap.get(parentId) == null) {
                budgetUseAmtMap.put(parentId, budgetUseAmt);
            } else {
                parentBudgetUseAmt = budgetUseAmt.add((BigDecimal)budgetUseAmtMap.get(parentId));
                budgetUseAmtMap.put(parentId, parentBudgetUseAmt);
            }
            if (costAmtMap.get(parentId) == null) {
                costAmtMap.put(parentId, costAmt);
                continue;
            }
            parentCostAmt = costAmt.add((BigDecimal)costAmtMap.get(parentId));
            costAmtMap.put(parentId, parentCostAmt);
        }
    }

    public static void mergeBudgetEntryDataToRow(DynamicObjectCollection budgetEntryEntity) {
        BigDecimal sumBudgetAmt = BigDecimal.ZERO;
        BigDecimal totalOccupyAmt = BigDecimal.ZERO;
        BigDecimal totalPerformAmt = BigDecimal.ZERO;
        BigDecimal totalRemainAmt = BigDecimal.ZERO;
        BigDecimal totalActualPayAmt = BigDecimal.ZERO;
        BigDecimal totalActualIncomeAmt = BigDecimal.ZERO;
        BigDecimal totalRemainActualIncomeAmt = BigDecimal.ZERO;
        BigDecimal totalBudgetUsedAmt = BigDecimal.ZERO;
        BigDecimal totalCostAmt = BigDecimal.ZERO;
        BigDecimal totalBudgetSumAmt = BigDecimal.ZERO;
        BigDecimal yearBudgetSumAmt = BigDecimal.ZERO;
        for (DynamicObject rowEntity : budgetEntryEntity) {
            if (!StringUtils.equals((CharSequence)rowEntity.getString("pid"), (CharSequence)"0") || StringUtils.equals((CharSequence)rowEntity.getString("id"), (CharSequence)"1")) continue;
            sumBudgetAmt = sumBudgetAmt.add(rowEntity.getBigDecimal("budgetamount"));
            totalOccupyAmt = totalOccupyAmt.add(rowEntity.getBigDecimal("occupyamt"));
            totalPerformAmt = totalPerformAmt.add(rowEntity.getBigDecimal("performamt"));
            totalRemainAmt = totalRemainAmt.add(rowEntity.getBigDecimal("remainamt"));
            totalActualPayAmt = totalActualPayAmt.add(rowEntity.getBigDecimal("actualpayamount"));
            totalActualIncomeAmt = totalActualIncomeAmt.add(rowEntity.getBigDecimal("incomeamount"));
            totalRemainActualIncomeAmt = totalRemainActualIncomeAmt.add(rowEntity.getBigDecimal("remainincomeamt"));
            totalBudgetUsedAmt = totalBudgetUsedAmt.add(rowEntity.getBigDecimal("budgetusedamt"));
            totalCostAmt = totalCostAmt.add(rowEntity.getBigDecimal("costamt"));
            totalBudgetSumAmt = totalBudgetSumAmt.add(rowEntity.getBigDecimal("budgetsumamount"));
            yearBudgetSumAmt = yearBudgetSumAmt.add(rowEntity.getBigDecimal("sumbudamt"));
        }
        DynamicObject firstEntry = (DynamicObject)budgetEntryEntity.get(0);
        firstEntry.set("budgetamount", (Object)sumBudgetAmt);
        firstEntry.set("occupyamt", (Object)totalOccupyAmt);
        firstEntry.set("performamt", (Object)totalPerformAmt);
        firstEntry.set("remainamt", (Object)totalRemainAmt);
        firstEntry.set("actualpayamount", (Object)totalActualPayAmt);
        firstEntry.set("incomeamount", (Object)totalActualIncomeAmt);
        firstEntry.set("remainincomeamt", (Object)totalRemainActualIncomeAmt);
        firstEntry.set("budgetusedamt", (Object)totalBudgetUsedAmt);
        firstEntry.set("costamt", (Object)totalCostAmt);
        firstEntry.set("budgetsumamount", (Object)totalBudgetSumAmt);
        firstEntry.set("sumbudamt", (Object)yearBudgetSumAmt);
        BigDecimal remainRate = BigDecimal.ZERO;
        BigDecimal actualInRate = BigDecimal.ZERO;
        if (totalBudgetSumAmt.compareTo(BigDecimal.ZERO) != 0) {
            remainRate = totalRemainAmt.divide(totalBudgetSumAmt, 10, RoundingMode.HALF_UP);
            actualInRate = totalActualIncomeAmt.divide(totalBudgetSumAmt, 10, RoundingMode.HALF_UP);
        }
        firstEntry.set("remainrate", (Object)remainRate);
        firstEntry.set("actualinrate", (Object)actualInRate);
    }

    public static void fillOccupyOrUseBill(Long budgetPk, Long projectId, String fieldName, DynamicObjectCollection performBillEntry) {
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        if (budgetPk != 1L) {
            qFilter.and("probudget", "=", (Object)budgetPk);
        }
        qFilter.and("iseffect", "=", (Object)true);
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"occupyamt")) {
            qFilter.and("controltype", "=", (Object)BudgetControlTypeEnum.TAKEOPERATION);
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"budgetusedamt")) {
            qFilter.and("controltype", "=", (Object)BudgetControlTypeEnum.EXECOPERATION);
        }
        qFilter.and("opaction", "=", (Object)BillFieldTypeEnum.EXEC_OPERATION.getNumber());
        String fields = String.join((CharSequence)",", "bizbillmark", "bizbillname", "billno", "billname", "billid", "currency", "oricurrency", "oriamount", "amount", "bizuser", "optime");
        DynamicObject[] exeRecords = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)fields, (QFilter[])new QFilter[]{qFilter});
        if (exeRecords.length == 0) {
            return;
        }
        DynamicObjectType dt = performBillEntry.getDynamicObjectType();
        for (DynamicObject exeRecord : exeRecords) {
            DynamicObject entryObj = new DynamicObject(dt);
            entryObj.set("bizbillid", (Object)exeRecord.getString("billid"));
            entryObj.set("bizbillmark", (Object)exeRecord.getString("bizbillmark"));
            entryObj.set("bizbilltype", (Object)exeRecord.getString("bizbillname"));
            entryObj.set("bizbillno", (Object)exeRecord.getString("billno"));
            entryObj.set("bizbillname", (Object)exeRecord.getString("billname"));
            entryObj.set("oricurrency", (Object)exeRecord.getDynamicObject("oricurrency"));
            entryObj.set("oriamount", (Object)exeRecord.getBigDecimal("oriamount"));
            entryObj.set("currency", (Object)exeRecord.getDynamicObject("currency"));
            entryObj.set("amount", (Object)exeRecord.getBigDecimal("amount"));
            entryObj.set("bizuser", (Object)exeRecord.getDynamicObject("bizuser"));
            entryObj.set("optime", (Object)exeRecord.getDate("optime"));
            performBillEntry.add((Object)entryObj);
        }
    }

    public static void fillPaymentApply(Long projectId, String budgetPk, DynamicObjectCollection performBillEntry) {
        DynamicObject[] paymentApplyBills;
        DynamicObjectType dt = performBillEntry.getDynamicObjectType();
        String selectProperties = String.join((CharSequence)",", "id", "billname", "billno", "currency", "creator", "auditdate", "entryentity", "payapplysplitentry", "bugdetitem", "cursplitamt", "prepaysplit");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter proFilter = new QFilter("project", "=", (Object)projectId);
        for (DynamicObject paymentApplyBill : paymentApplyBills = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)selectProperties, (QFilter[])new QFilter[]{statusFilter, proFilter})) {
            DynamicObjectCollection entryEntity = paymentApplyBill.getDynamicObjectCollection("entryentity");
            if (entryEntity.size() == 0) continue;
            ArrayList splitObjList = new ArrayList();
            for (DynamicObject conPaidEntry : entryEntity) {
                List splits;
                DynamicObjectCollection splitEntry = conPaidEntry.getDynamicObjectCollection("payapplysplitentry");
                if (splitEntry.size() == 0 || (splits = Long.parseLong(budgetPk) != 1L ? splitEntry.stream().filter(o -> o.getDynamicObject("bugdetitem") != null && StringUtils.equals((CharSequence)o.getDynamicObject("bugdetitem").getPkValue().toString(), (CharSequence)budgetPk)).filter(o -> o.getBigDecimal("cursplitamt").compareTo(BigDecimal.ZERO) != 0).filter(o -> !o.getBoolean("prepaysplit")).collect(Collectors.toList()) : splitEntry.stream().filter(o -> o.getBigDecimal("cursplitamt").compareTo(BigDecimal.ZERO) != 0).filter(o -> !o.getBoolean("prepaysplit")).collect(Collectors.toList())).size() <= 0) continue;
                splitObjList.addAll(splits);
            }
            if (splitObjList.size() == 0) continue;
            DynamicObject entryObj = new DynamicObject(dt);
            entryObj.set("bizbillid", (Object)paymentApplyBill.getPkValue().toString());
            entryObj.set("bizbillmark", (Object)paymentApplyBill.getDataEntityType().getName());
            entryObj.set("bizbilltype", (Object)paymentApplyBill.getDataEntityType().getDisplayName().getLocaleValue());
            entryObj.set("bizbillno", (Object)paymentApplyBill.getString("billno"));
            entryObj.set("bizbillname", (Object)paymentApplyBill.getString("billname"));
            entryObj.set("oricurrency", (Object)paymentApplyBill.getDynamicObject("currency"));
            entryObj.set("currency", (Object)paymentApplyBill.getDynamicObject("currency"));
            entryObj.set("bizuser", (Object)paymentApplyBill.getDynamicObject("creator"));
            entryObj.set("optime", (Object)paymentApplyBill.getDate("auditdate"));
            BigDecimal splitAmt = splitObjList.stream().map(o -> o.getBigDecimal("cursplitamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            entryObj.set("oriamount", (Object)splitAmt);
            entryObj.set("amount", (Object)splitAmt);
            performBillEntry.add((Object)entryObj);
        }
        selectProperties = String.join((CharSequence)",", "id", "billname", "billno", "currency", "creator", "auditdate", "splitentry", "bugdetitem", "cursplitamt");
        statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        proFilter = new QFilter("project", "=", (Object)projectId);
        for (DynamicObject paymentApplyBill : paymentApplyBills = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)selectProperties, (QFilter[])new QFilter[]{statusFilter, proFilter})) {
            Optional<DynamicObject> first;
            DynamicObjectCollection splitEntry = paymentApplyBill.getDynamicObjectCollection("splitentry");
            if (splitEntry.size() == 0 || !(first = Long.parseLong(budgetPk) != 1L ? splitEntry.stream().filter(o -> o.getDynamicObject("bugdetitem") != null && StringUtils.equals((CharSequence)o.getDynamicObject("bugdetitem").getPkValue().toString(), (CharSequence)budgetPk)).filter(o -> o.getBigDecimal("cursplitamt").compareTo(BigDecimal.ZERO) != 0).findFirst() : splitEntry.stream().filter(o -> o.getBigDecimal("cursplitamt").compareTo(BigDecimal.ZERO) != 0).findFirst()).isPresent()) continue;
            DynamicObject split = first.get();
            DynamicObject entryObj = new DynamicObject(dt);
            entryObj.set("bizbillid", (Object)paymentApplyBill.getPkValue().toString());
            entryObj.set("bizbillmark", (Object)paymentApplyBill.getDataEntityType().getName());
            entryObj.set("bizbilltype", (Object)paymentApplyBill.getDataEntityType().getDisplayName().getLocaleValue());
            entryObj.set("bizbillno", (Object)paymentApplyBill.getString("billno"));
            entryObj.set("bizbillname", (Object)paymentApplyBill.getString("billname"));
            entryObj.set("oricurrency", (Object)paymentApplyBill.getDynamicObject("currency"));
            entryObj.set("currency", (Object)paymentApplyBill.getDynamicObject("currency"));
            entryObj.set("bizuser", (Object)paymentApplyBill.getDynamicObject("creator"));
            entryObj.set("optime", (Object)paymentApplyBill.getDate("auditdate"));
            entryObj.set("oriamount", (Object)split.getBigDecimal("cursplitamt"));
            entryObj.set("amount", (Object)split.getBigDecimal("cursplitamt"));
            performBillEntry.add((Object)entryObj);
        }
    }

    public static void fillProCostSplit(Long projectId, String budgetPk, DynamicObjectCollection performBillEntry) {
        ArrayList proCostSplitBillList = new ArrayList(16);
        DynamicObjectType dt = performBillEntry.getDynamicObjectType();
        String selectProperties = String.join((CharSequence)",", "id", "billname", "billno", "enablemultipro", "currency", "creator", "auditdate", "procostsplitentry", "entryproject", "budgetitem", "costamt");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter proFilter = new QFilter("project", "=", (Object)projectId);
        DynamicObject[] proCostSplitBills = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)selectProperties, (QFilter[])new QFilter[]{statusFilter, proFilter});
        if (proCostSplitBills.length != 0) {
            proCostSplitBillList.addAll(Arrays.stream(proCostSplitBills).collect(Collectors.toList()));
        }
        QFilter multiProQFilter = new QFilter("enablemultipro", "=", (Object)true);
        proFilter = new QFilter("procostsplitentry.entryproject", "=", (Object)projectId);
        proCostSplitBills = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)selectProperties, (QFilter[])new QFilter[]{statusFilter, multiProQFilter, proFilter});
        if (proCostSplitBills.length != 0) {
            proCostSplitBillList.addAll(Arrays.stream(proCostSplitBills).collect(Collectors.toList()));
        }
        for (DynamicObject proCostSplitBill : proCostSplitBillList) {
            BigDecimal totalCostAmt;
            Optional<DynamicObject> first;
            DynamicObjectCollection costSplitEntry = proCostSplitBill.getDynamicObjectCollection("procostsplitentry");
            if (costSplitEntry.size() == 0) continue;
            if (Long.parseLong(budgetPk) != 1L) {
                first = costSplitEntry.stream().filter(o -> o.getDynamicObject("budgetitem") != null && StringUtils.equals((CharSequence)o.getDynamicObject("budgetitem").getPkValue().toString(), (CharSequence)budgetPk)).filter(o -> o.getBigDecimal("costamt").compareTo(BigDecimal.ZERO) != 0).findFirst();
                totalCostAmt = costSplitEntry.stream().filter(o -> o.getDynamicObject("budgetitem") != null && StringUtils.equals((CharSequence)o.getDynamicObject("budgetitem").getPkValue().toString(), (CharSequence)budgetPk)).filter(o -> o.getBigDecimal("costamt").compareTo(BigDecimal.ZERO) != 0).map(o -> o.getBigDecimal("costamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            } else if (proCostSplitBill.getBoolean("enablemultipro")) {
                first = costSplitEntry.stream().filter(o -> o.getDynamicObject("entryproject") != null).filter(o -> Long.parseLong(o.getDynamicObject("entryproject").getPkValue().toString()) == projectId).filter(o -> o.getBigDecimal("costamt").compareTo(BigDecimal.ZERO) != 0).findFirst();
                totalCostAmt = costSplitEntry.stream().filter(o -> o.getDynamicObject("entryproject") != null).filter(o -> Long.parseLong(o.getDynamicObject("entryproject").getPkValue().toString()) == projectId).filter(o -> o.getBigDecimal("costamt").compareTo(BigDecimal.ZERO) != 0).map(o -> o.getBigDecimal("costamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            } else {
                first = costSplitEntry.stream().filter(o -> o.getBigDecimal("costamt").compareTo(BigDecimal.ZERO) != 0).findFirst();
                totalCostAmt = costSplitEntry.stream().filter(o -> o.getBigDecimal("costamt").compareTo(BigDecimal.ZERO) != 0).map(o -> o.getBigDecimal("costamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            if (!first.isPresent()) continue;
            DynamicObject entryObj = new DynamicObject(dt);
            entryObj.set("bizbillid", (Object)proCostSplitBill.getPkValue().toString());
            entryObj.set("bizbillmark", (Object)proCostSplitBill.getDataEntityType().getName());
            entryObj.set("bizbilltype", (Object)proCostSplitBill.getDataEntityType().getDisplayName().getLocaleValue());
            entryObj.set("bizbillno", (Object)proCostSplitBill.getString("billno"));
            entryObj.set("bizbillname", (Object)proCostSplitBill.getString("billname"));
            entryObj.set("oricurrency", (Object)proCostSplitBill.getDynamicObject("currency"));
            entryObj.set("currency", (Object)proCostSplitBill.getDynamicObject("currency"));
            entryObj.set("bizuser", (Object)proCostSplitBill.getDynamicObject("creator"));
            entryObj.set("optime", (Object)proCostSplitBill.getDate("auditdate"));
            entryObj.set("oriamount", (Object)totalCostAmt);
            entryObj.set("amount", (Object)totalCostAmt);
            performBillEntry.add((Object)entryObj);
        }
    }

    public static void fillPayRegistration(Long projectId, String budgetPk, DynamicObjectCollection performBillEntry) {
        DynamicObject[] paymentRegisters;
        DynamicObjectType dt = performBillEntry.getDynamicObjectType();
        String selectProperties = String.join((CharSequence)",", "id", "billname", "billno", "currency", "creator", "auditdate", "entryentity", "subentryentity", "budgetitem", "curactualpaysplitamt");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter proFilter = new QFilter("project", "=", (Object)projectId);
        for (DynamicObject paymentRegister : paymentRegisters = BusinessDataServiceHelper.load((String)"pmct_paymentregister", (String)selectProperties, (QFilter[])new QFilter[]{statusFilter, proFilter})) {
            DynamicObjectCollection entryEntity = paymentRegister.getDynamicObjectCollection("entryentity");
            if (entryEntity.size() == 0) continue;
            ArrayList<DynamicObject> splitObjList = new ArrayList<DynamicObject>();
            for (DynamicObject paidInfoEntry : entryEntity) {
                Optional<DynamicObject> first;
                DynamicObjectCollection splitEntry = paidInfoEntry.getDynamicObjectCollection("subentryentity");
                if (splitEntry.size() == 0 || !(first = Long.parseLong(budgetPk) != 1L ? splitEntry.stream().filter(o -> o.getDynamicObject("budgetitem") != null && StringUtils.equals((CharSequence)o.getDynamicObject("budgetitem").getPkValue().toString(), (CharSequence)budgetPk)).filter(o -> o.getBigDecimal("curactualpaysplitamt").compareTo(BigDecimal.ZERO) != 0).findFirst() : splitEntry.stream().filter(o -> o.getBigDecimal("curactualpaysplitamt").compareTo(BigDecimal.ZERO) != 0).findFirst()).isPresent()) continue;
                splitObjList.add(first.get());
            }
            if (splitObjList.size() == 0) continue;
            DynamicObject entryObj = new DynamicObject(dt);
            entryObj.set("bizbillid", (Object)paymentRegister.getPkValue().toString());
            entryObj.set("bizbillmark", (Object)paymentRegister.getDataEntityType().getName());
            entryObj.set("bizbilltype", (Object)paymentRegister.getDataEntityType().getDisplayName().getLocaleValue());
            entryObj.set("bizbillno", (Object)paymentRegister.getString("billno"));
            entryObj.set("bizbillname", (Object)paymentRegister.getString("billname"));
            entryObj.set("oricurrency", (Object)paymentRegister.getDynamicObject("currency"));
            entryObj.set("currency", (Object)paymentRegister.getDynamicObject("currency"));
            entryObj.set("bizuser", (Object)paymentRegister.getDynamicObject("creator"));
            entryObj.set("optime", (Object)paymentRegister.getDate("auditdate"));
            BigDecimal splitAmt = splitObjList.stream().map(o -> o.getBigDecimal("curactualpaysplitamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            entryObj.set("oriamount", (Object)splitAmt);
            entryObj.set("amount", (Object)splitAmt);
            performBillEntry.add((Object)entryObj);
        }
    }

    public static void fillPayApplyCostSplit(Long projectId, String budgetPk, DynamicObjectCollection performBillEntry) {
        DynamicObject[] payApplyCostSplits;
        DynamicObjectType dt = performBillEntry.getDynamicObjectType();
        String selectProperties = String.join((CharSequence)",", "id", "billname", "billno", "curreney", "creator", "auditdate", "costdetails", "costsplitdetails", "probudget", "splitamount");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter proFilter = new QFilter("project", "=", (Object)projectId);
        for (DynamicObject payApplyCostSplit : payApplyCostSplits = BusinessDataServiceHelper.load((String)"pmco_payapplycostsplit", (String)selectProperties, (QFilter[])new QFilter[]{statusFilter, proFilter})) {
            DynamicObjectCollection entryEntity = payApplyCostSplit.getDynamicObjectCollection("costdetails");
            if (entryEntity.size() == 0) continue;
            ArrayList<DynamicObject> splitObjList = new ArrayList<DynamicObject>();
            for (DynamicObject paidInfoEntry : entryEntity) {
                Optional<DynamicObject> first;
                DynamicObjectCollection splitEntry = paidInfoEntry.getDynamicObjectCollection("costsplitdetails");
                if (splitEntry.size() == 0 || !(first = Long.parseLong(budgetPk) != 1L ? splitEntry.stream().filter(o -> o.getDynamicObject("probudget") != null && StringUtils.equals((CharSequence)o.getDynamicObject("probudget").getPkValue().toString(), (CharSequence)budgetPk)).filter(o -> o.getBigDecimal("splitamount").compareTo(BigDecimal.ZERO) != 0).findFirst() : splitEntry.stream().filter(o -> o.getBigDecimal("splitamount").compareTo(BigDecimal.ZERO) != 0).findFirst()).isPresent()) continue;
                splitObjList.add(first.get());
            }
            if (splitObjList.size() == 0) continue;
            DynamicObject entryObj = new DynamicObject(dt);
            entryObj.set("bizbillid", (Object)payApplyCostSplit.getPkValue().toString());
            entryObj.set("bizbillmark", (Object)payApplyCostSplit.getDataEntityType().getName());
            entryObj.set("bizbilltype", (Object)payApplyCostSplit.getDataEntityType().getDisplayName().getLocaleValue());
            entryObj.set("bizbillno", (Object)payApplyCostSplit.getString("billno"));
            entryObj.set("bizbillname", (Object)payApplyCostSplit.getString("billname"));
            entryObj.set("oricurrency", (Object)payApplyCostSplit.getDynamicObject("curreney"));
            entryObj.set("currency", (Object)payApplyCostSplit.getDynamicObject("curreney"));
            entryObj.set("bizuser", (Object)payApplyCostSplit.getDynamicObject("creator"));
            entryObj.set("optime", (Object)payApplyCostSplit.getDate("auditdate"));
            BigDecimal splitAmt = splitObjList.stream().map(o -> o.getBigDecimal("splitamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            entryObj.set("oriamount", (Object)splitAmt);
            entryObj.set("amount", (Object)splitAmt);
            performBillEntry.add((Object)entryObj);
        }
    }

    public static void fillContractCostSplit(Long projectId, String budgetPk, DynamicObjectCollection performBillEntry) {
        DynamicObject[] contractCostSplits;
        DynamicObjectType dt = performBillEntry.getDynamicObjectType();
        String selectProperties = String.join((CharSequence)",", "id", "billname", "billno", "currency", "creator", "auditdate", "entryentity", "subentryentity", "budgetitem", "amount");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter proFilter = new QFilter("project", "=", (Object)projectId);
        for (DynamicObject contractCostSplit : contractCostSplits = BusinessDataServiceHelper.load((String)"pmco_contractcost", (String)selectProperties, (QFilter[])new QFilter[]{statusFilter, proFilter})) {
            DynamicObjectCollection entryEntity = contractCostSplit.getDynamicObjectCollection("entryentity");
            if (entryEntity.size() == 0) continue;
            ArrayList<DynamicObject> splitObjList = new ArrayList<DynamicObject>();
            for (DynamicObject paidInfoEntry : entryEntity) {
                Optional<DynamicObject> first;
                DynamicObjectCollection splitEntry = paidInfoEntry.getDynamicObjectCollection("subentryentity");
                if (splitEntry.size() == 0 || !(first = Long.parseLong(budgetPk) != 1L ? splitEntry.stream().filter(o -> o.getDynamicObject("budgetitem") != null && StringUtils.equals((CharSequence)o.getDynamicObject("budgetitem").getPkValue().toString(), (CharSequence)budgetPk)).filter(o -> o.getBigDecimal("amount").compareTo(BigDecimal.ZERO) != 0).findFirst() : splitEntry.stream().filter(o -> o.getBigDecimal("amount").compareTo(BigDecimal.ZERO) != 0).findFirst()).isPresent()) continue;
                splitObjList.add(first.get());
            }
            if (splitObjList.size() == 0) continue;
            DynamicObject entryObj = new DynamicObject(dt);
            entryObj.set("bizbillid", (Object)contractCostSplit.getPkValue().toString());
            entryObj.set("bizbillmark", (Object)contractCostSplit.getDataEntityType().getName());
            entryObj.set("bizbilltype", (Object)contractCostSplit.getDataEntityType().getDisplayName().getLocaleValue());
            entryObj.set("bizbillno", (Object)contractCostSplit.getString("billno"));
            entryObj.set("bizbillname", (Object)contractCostSplit.getString("billname"));
            entryObj.set("oricurrency", (Object)contractCostSplit.getDynamicObject("currency"));
            entryObj.set("currency", (Object)contractCostSplit.getDynamicObject("currency"));
            entryObj.set("bizuser", (Object)contractCostSplit.getDynamicObject("creator"));
            entryObj.set("optime", (Object)contractCostSplit.getDate("auditdate"));
            BigDecimal splitAmt = splitObjList.stream().map(o -> o.getBigDecimal("splitamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            entryObj.set("oriamount", (Object)splitAmt);
            entryObj.set("amount", (Object)splitAmt);
            performBillEntry.add((Object)entryObj);
        }
    }

    public static void exportProBudgetExcelData(DynamicObjectCollection budgetEntryEntity, List<String[]> headerList, List<String[]> columnList, List<JSONArray> jsonDataList, String isNew, String cache) {
        DynamicObject[] budgetPerforms;
        JSONArray jsonArray = new JSONArray();
        HashSet<DynamicObject> detailBudgetRowSet = new HashSet<DynamicObject>(budgetEntryEntity.size());
        Tree tree = OutBudgetReportHelper.buildTree(budgetEntryEntity);
        List treeNodeList = tree.getList();
        BigDecimal oneHundred = new BigDecimal("100");
        Object[] oldProBudgetColumnKeys = null;
        Object[] newProBudgetColumnKeys = null;
        if (StringUtils.isNotEmpty((CharSequence)isNew) && Boolean.parseBoolean(isNew)) {
            Object[] newProBudgetHeaders = (String[])ArrayUtils.remove((Object[])proBudgetHeaders, (int)5);
            newProBudgetHeaders = (String[])ArrayUtils.remove((Object[])newProBudgetHeaders, (int)5);
            headerList.add((String[])newProBudgetHeaders);
            newProBudgetColumnKeys = (String[])ArrayUtils.remove((Object[])proBudgetColumnKeys, (int)5);
            newProBudgetColumnKeys = (String[])ArrayUtils.remove((Object[])newProBudgetColumnKeys, (int)5);
            columnList.add((String[])newProBudgetColumnKeys);
        } else {
            Object oldProBudgetHeaders = (String[])ArrayUtils.remove((Object[])proBudgetHeaders, (int)1);
            oldProBudgetHeaders = (String[])ArrayUtils.remove((Object[])oldProBudgetHeaders, (int)1);
            oldProBudgetHeaders = (String[])ArrayUtils.remove((Object[])oldProBudgetHeaders, (int)1);
            oldProBudgetHeaders = (String[])ArrayUtils.remove((Object[])oldProBudgetHeaders, (int)4);
            oldProBudgetHeaders = (String[])ArrayUtils.remove((Object[])oldProBudgetHeaders, (int)4);
            oldProBudgetHeaders = (String[])ArrayUtils.remove((Object[])oldProBudgetHeaders, (int)6);
            oldProBudgetHeaders[1] = ResManager.loadKDString((String)"\u9884\u7b97\u91d1\u989d", (String)"OutBudgetReportHelper_32", (String)"pmgt-pmbs-business", (Object[])new Object[0]);
            headerList.add((String[])oldProBudgetHeaders);
            oldProBudgetColumnKeys = (String[])ArrayUtils.remove((Object[])proBudgetColumnKeys, (int)1);
            oldProBudgetColumnKeys = (String[])ArrayUtils.remove((Object[])oldProBudgetColumnKeys, (int)1);
            oldProBudgetColumnKeys = (String[])ArrayUtils.remove((Object[])oldProBudgetColumnKeys, (int)1);
            oldProBudgetColumnKeys = (String[])ArrayUtils.remove((Object[])oldProBudgetColumnKeys, (int)4);
            oldProBudgetColumnKeys = (String[])ArrayUtils.remove((Object[])oldProBudgetColumnKeys, (int)4);
            oldProBudgetColumnKeys = (String[])ArrayUtils.remove((Object[])oldProBudgetColumnKeys, (int)6);
            columnList.add((String[])oldProBudgetColumnKeys);
        }
        for (TreeNode node : treeNodeList) {
            StringBuilder blank = new StringBuilder();
            int level = node.getLevel();
            while (--level > 0) {
                blank.append("    ");
            }
            DynamicObject budgetEntryRow = node.getData();
            JSONObject jsonObject = new JSONObject();
            DynamicObject currency = budgetEntryRow.getDynamicObject("budgetcurrency");
            int precision = currency == null ? 10 : currency.getInt("amtprecision");
            String checkBill = budgetEntryRow.getString("checkbill");
            if (StringUtils.isNotEmpty((CharSequence)checkBill)) {
                detailBudgetRowSet.add(budgetEntryRow);
            }
            if (StringUtils.isNotEmpty((CharSequence)isNew) && Boolean.parseBoolean(isNew)) {
                if (newProBudgetColumnKeys == null) continue;
                jsonObject.put((String)newProBudgetColumnKeys[0], (Object)String.format("%s%s", blank, budgetEntryRow.getString("name")));
                jsonObject.put((String)newProBudgetColumnKeys[1], (Object)budgetEntryRow.getString("number"));
                jsonObject.put((String)newProBudgetColumnKeys[2], (Object)budgetEntryRow.getBigDecimal("budgetsumamount").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put((String)newProBudgetColumnKeys[3], (Object)budgetEntryRow.getBigDecimal("sumbudamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put((String)newProBudgetColumnKeys[4], (Object)budgetEntryRow.getBigDecimal("budgetamount").setScale(precision, RoundingMode.HALF_UP));
                BigDecimal remindRate = budgetEntryRow.getBigDecimal("remindrate").multiply(oneHundred);
                jsonObject.put((String)newProBudgetColumnKeys[5], (Object)remindRate.setScale(2, RoundingMode.HALF_UP));
                BigDecimal bigDecimal = budgetEntryRow.getBigDecimal("controlrate").multiply(oneHundred);
                jsonObject.put((String)newProBudgetColumnKeys[6], (Object)bigDecimal.setScale(2, RoundingMode.HALF_UP));
                jsonObject.put((String)newProBudgetColumnKeys[7], (Object)budgetEntryRow.getBigDecimal("occupyamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put((String)newProBudgetColumnKeys[8], (Object)budgetEntryRow.getBigDecimal("performamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put((String)newProBudgetColumnKeys[9], (Object)budgetEntryRow.getBigDecimal("actualpayamount").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put((String)newProBudgetColumnKeys[10], (Object)budgetEntryRow.getBigDecimal("budgetusedamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put((String)newProBudgetColumnKeys[11], (Object)budgetEntryRow.getBigDecimal("costamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put((String)newProBudgetColumnKeys[12], (Object)budgetEntryRow.getBigDecimal("remainamt").setScale(precision, RoundingMode.HALF_UP));
                BigDecimal remainRate = budgetEntryRow.getBigDecimal("remainrate").multiply(oneHundred);
                jsonObject.put((String)newProBudgetColumnKeys[13], (Object)remainRate.setScale(2, RoundingMode.HALF_UP));
                jsonArray.add((Object)jsonObject);
                continue;
            }
            if (oldProBudgetColumnKeys == null) continue;
            jsonObject.put((String)oldProBudgetColumnKeys[0], (Object)String.format("%s%s", blank, budgetEntryRow.getString("name")));
            jsonObject.put((String)oldProBudgetColumnKeys[1], (Object)budgetEntryRow.getBigDecimal("budgetamount").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put((String)oldProBudgetColumnKeys[2], (Object)budgetEntryRow.getBigDecimal("remindamt").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put((String)oldProBudgetColumnKeys[3], (Object)budgetEntryRow.getBigDecimal("controlamt").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put((String)oldProBudgetColumnKeys[4], (Object)budgetEntryRow.getBigDecimal("occupyamt").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put((String)oldProBudgetColumnKeys[5], (Object)budgetEntryRow.getBigDecimal("performamt").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put((String)oldProBudgetColumnKeys[6], (Object)budgetEntryRow.getBigDecimal("budgetusedamt").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put((String)oldProBudgetColumnKeys[7], (Object)budgetEntryRow.getBigDecimal("costamt").setScale(precision, RoundingMode.HALF_UP));
            jsonObject.put((String)oldProBudgetColumnKeys[8], (Object)budgetEntryRow.getBigDecimal("remainamt").setScale(precision, RoundingMode.HALF_UP));
            BigDecimal remainRate = budgetEntryRow.getBigDecimal("remainrate").multiply(oneHundred);
            jsonObject.put((String)oldProBudgetColumnKeys[9], (Object)remainRate.setScale(2, RoundingMode.HALF_UP));
            jsonArray.add((Object)jsonObject);
        }
        jsonDataList.add(jsonArray);
        if (StringUtils.isNotEmpty((CharSequence)isNew) && Boolean.parseBoolean(isNew)) {
            return;
        }
        jsonArray = new JSONArray();
        for (DynamicObject detailBudgetRow : detailBudgetRowSet) {
            DynamicObject currency = detailBudgetRow.getDynamicObject("budgetcurrency");
            int precision = currency == null ? 10 : currency.getInt("amtprecision");
            QFilter budgetItemFilter = new QFilter("budgetitem", "=", detailBudgetRow.getPkValue());
            DynamicObject[] contBudgets = BusinessDataServiceHelper.load((String)"pmbs_contractbudget", (String)"contract,occupyamt,contractsubmitamt,contractauditamt,settlesubmitamt,settleauditamt,payapplysubmitamt,payapplyauditamt,actualsubmitamt,actualauditamt,projectcurrency", (QFilter[])new QFilter[]{budgetItemFilter});
            HashSet<Object> contractIdSet = new HashSet<Object>(contBudgets.length);
            for (DynamicObject dynamicObject : contBudgets) {
                DynamicObject contract = dynamicObject.getDynamicObject("contract");
                if (contract == null) continue;
                contractIdSet.add(contract.getPkValue());
            }
            DynamicObject[] contracts = BusinessDataServiceHelper.load((Object[])contractIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contracttpl"));
            HashMap<Object, DynamicObject> contractMap = new HashMap<Object, DynamicObject>(contracts.length);
            for (DynamicObject contract : contracts) {
                contractMap.put(contract.getPkValue(), contract);
            }
            for (DynamicObject contBudget3 : contBudgets) {
                DynamicObject contract = contBudget3.getDynamicObject("contract");
                if (contract == null) continue;
                JSONObject jsonObject = new JSONObject();
                contract = (DynamicObject)contractMap.get(contract.getPkValue());
                jsonObject.put(contBudgetColumnKeys[0], (Object)detailBudgetRow.getString("name"));
                jsonObject.put(contBudgetColumnKeys[1], contract.get("billno"));
                jsonObject.put(contBudgetColumnKeys[2], contract.get("billname"));
                StatusEnum statusEnum = StatusEnum.getEnumByValue((Object)contract.get("billstatus"));
                if (statusEnum != null) {
                    jsonObject.put(contBudgetColumnKeys[3], (Object)statusEnum.getName());
                }
                jsonObject.put(contBudgetColumnKeys[4], (Object)contBudget3.getBigDecimal("occupyamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put(contBudgetColumnKeys[5], (Object)contBudget3.getBigDecimal("contractsubmitamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put(contBudgetColumnKeys[6], (Object)contBudget3.getBigDecimal("settlesubmitamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put(contBudgetColumnKeys[7], (Object)contBudget3.getBigDecimal("payapplysubmitamt").setScale(precision, RoundingMode.HALF_UP));
                jsonObject.put(contBudgetColumnKeys[8], (Object)contBudget3.getBigDecimal("actualsubmitamt").setScale(precision, RoundingMode.HALF_UP));
                BigDecimal value = BigDecimal.ZERO;
                if (StringUtils.isNotEmpty((CharSequence)cache)) {
                    JSONObject json = JSON.parseObject((String)cache);
                    value = json.getBigDecimal(contBudget3.getDynamicObject("contract").getPkValue().toString());
                }
                jsonObject.put(contBudgetColumnKeys[9], (Object)value);
                jsonArray.add((Object)jsonObject);
            }
            budgetItemFilter = new QFilter("id", "=", detailBudgetRow.getPkValue());
            DynamicObject projectBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_projectbudget", (String)"currency, , performentry.billid, performentry.billno, performentry.billname, performentry.billtype, performentry.billstatus, performentry.performamttype, performentry.billamtoncont", (QFilter[])new QFilter[]{budgetItemFilter});
            for (DynamicObject otherBillBudget : projectBudget.getDynamicObjectCollection("performentry")) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)otherBillBudget.getString("performamttype"), (CharSequence)PerformAmountTypeEnum.OTHER.getValue())) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(contBudgetColumnKeys[0], (Object)detailBudgetRow.getString("name"));
                jsonObject.put(contBudgetColumnKeys[1], otherBillBudget.get("billno"));
                jsonObject.put(contBudgetColumnKeys[2], otherBillBudget.get("billname"));
                StatusEnum statusEnum = StatusEnum.getEnumByValue((Object)otherBillBudget.get("billstatus"));
                if (statusEnum != null) {
                    jsonObject.put(contBudgetColumnKeys[3], (Object)statusEnum.getName());
                }
                jsonObject.put(contBudgetColumnKeys[4], (Object)otherBillBudget.getBigDecimal("billamtoncont").setScale(precision, RoundingMode.HALF_UP));
                jsonArray.add((Object)jsonObject);
            }
        }
        headerList.add(contBudgetHeaders);
        columnList.add(contBudgetColumnKeys);
        jsonDataList.add(jsonArray);
        jsonArray = new JSONArray();
        for (DynamicObject budgetPerform : budgetPerforms = BusinessDataServiceHelper.load((Object[])detailBudgetRowSet.stream().map(DataEntityBase::getPkValue).distinct().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projectbudgetperform"))) {
            DynamicObject currency = budgetPerform.getDynamicObject("currency");
            int precision = currency == null ? 10 : currency.getInt("amtprecision");
            DynamicObjectCollection performEntry = budgetPerform.getDynamicObjectCollection("performentry");
            for (DynamicObject performEntryObj : performEntry) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(budgetRecordColumnKeys[0], budgetPerform.get("name"));
                DynamicObject contract = performEntryObj.getDynamicObject("contract");
                if (contract != null) {
                    jSONObject.put(budgetRecordColumnKeys[1], contract.get("billno"));
                    jSONObject.put(budgetRecordColumnKeys[2], contract.get("billname"));
                }
                if (performEntryObj.getDynamicObject("billtype") != null) {
                    jSONObject.put(budgetRecordColumnKeys[3], (Object)performEntryObj.getDynamicObject("billtype").getLocaleString("name"));
                }
                jSONObject.put(budgetRecordColumnKeys[4], (Object)performEntryObj.getString("billno"));
                jSONObject.put(budgetRecordColumnKeys[5], (Object)performEntryObj.getString("billname"));
                jSONObject.put(budgetRecordColumnKeys[6], (Object)performEntryObj.getBigDecimal("billamt").setScale(precision, RoundingMode.HALF_UP));
                StatusEnum statusEnum = StatusEnum.getEnumByValue((Object)performEntryObj.getString("billstatus"));
                if (statusEnum != null) {
                    jSONObject.put(budgetRecordColumnKeys[7], (Object)statusEnum.getName());
                }
                if (performEntryObj.getDynamicObject("billcreator") != null) {
                    jSONObject.put(budgetRecordColumnKeys[8], (Object)performEntryObj.getDynamicObject("billcreator").getLocaleString("name"));
                }
                jSONObject.put(budgetRecordColumnKeys[9], (Object)performEntryObj.getDate("billcreatedate"));
                if (performEntryObj.getDynamicObject("billauditor") != null) {
                    jSONObject.put(budgetRecordColumnKeys[10], (Object)performEntryObj.getDynamicObject("billauditor").getLocaleString("name"));
                }
                jSONObject.put(budgetRecordColumnKeys[11], (Object)performEntryObj.getDate("billauditdate"));
                jsonArray.add((Object)jSONObject);
            }
        }
        headerList.add(budgetRecordHeaders);
        columnList.add(budgetRecordColumnKeys);
        jsonDataList.add(jsonArray);
    }

    public static Tree buildTree(DynamicObjectCollection budgetEntryEntity) {
        ArrayList<TreeNode> nodesList = new ArrayList<TreeNode>(budgetEntryEntity.size());
        for (int i = 1; i < budgetEntryEntity.size(); ++i) {
            DynamicObject row = (DynamicObject)budgetEntryEntity.get(i);
            String id = row.getString("id");
            String pid = row.getString("pid");
            nodesList.add(new TreeNode(id, pid, "", row));
        }
        return Tree.buildTreeByPid(nodesList);
    }
}

