/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.common.enums.ContractPayTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.pmct.ContractMultiTypeEnum;

public class BudgetPrePayService {
    public Map<Object, Map<String, Object>> getPrePaySplitBudgetData(DynamicObject contract, Object projectId, Object orgId) {
        boolean separatePay;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(4);
        filterList.add(new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.UNCHECKED.getValue(), StatusEnum.CHECKED.getValue()}));
        filterList.add(new QFilter("entryentity.entrycontract", "=", contract.getPkValue()));
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        boolean bl = separatePay = multiPartSettlement && StringUtils.equals((CharSequence)contract.getString("multipaytype"), (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue());
        if (separatePay) {
            if (projectId != null) {
                filterList.add(new QFilter("entryentity.contpro", "=", projectId));
            }
            filterList.add(new QFilter("org", "=", orgId));
        }
        DynamicObject[] paymentApplies = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"project,billstatus,entryentity.contpro,entryentity.entrycontract,entryentity.paymenttype,entryentity.entrypaidamount,entryentity.thispayableamount,entryentity.payapplysplitentry,payapplysplitentry.bugdetitem,payapplysplitentry.prepaysplit,payapplysplitentry.cursplitamt", (QFilter[])filterList.toArray(new QFilter[0]));
        HashMap<Object, Map<String, Object>> prePaySplitBudgetDataMap = new HashMap<Object, Map<String, Object>>(16);
        DynamicObject currency = contract.getDynamicObject("currency");
        int amtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
        for (DynamicObject paymentApply : paymentApplies) {
            String billStatus = paymentApply.getString("billstatus");
            DynamicObjectCollection entries = paymentApply.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                boolean isProjectCostControl = ContractHelper.isProjectCostControl(paymentApply, entry, "entrycontract", "payapplysplitentry", "bugdetitem");
                DynamicObject entryContract = entry.getDynamicObject("entrycontract");
                DynamicObject contPro = entry.getDynamicObject("contpro");
                String paymentType = entry.getString("paymenttype");
                BigDecimal entryPaidAmount = entry.getBigDecimal("entrypaidamount");
                BigDecimal thisPayAbleAmount = entry.getBigDecimal("thispayableamount");
                if (!entryContract.getPkValue().equals(contract.getPkValue()) || separatePay && projectId != null && (contPro == null || !contPro.getPkValue().equals(projectId))) continue;
                DynamicObjectCollection payApplySplitEntry = entry.getDynamicObjectCollection("payapplysplitentry");
                BigDecimal sumPrePayAmount = BigDecimal.ZERO;
                for (int index = 0; index < payApplySplitEntry.size(); ++index) {
                    Map<String, Object> prePaySplitBudgetData;
                    DynamicObject budgetItem = ((DynamicObject)payApplySplitEntry.get(index)).getDynamicObject("bugdetitem");
                    Object budgetItemId = budgetItem == null ? Long.valueOf(0L) : budgetItem.getPkValue();
                    BigDecimal curSplitAmt = ((DynamicObject)payApplySplitEntry.get(index)).getBigDecimal("cursplitamt");
                    boolean prePaySplit = ((DynamicObject)payApplySplitEntry.get(index)).getBoolean("prepaysplit");
                    if (StringUtils.equals((CharSequence)paymentType, (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue()) && StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue())) {
                        BigDecimal prePayAmount;
                        BigDecimal oldPrePayAmount;
                        prePaySplitBudgetData = (HashMap<String, Object>)prePaySplitBudgetDataMap.get(budgetItemId);
                        if (prePaySplitBudgetData == null) {
                            prePaySplitBudgetData = new HashMap<String, Object>(16);
                            if (budgetItem != null) {
                                prePaySplitBudgetData.put("name", budgetItem.getString("name"));
                                prePaySplitBudgetData.put("budgetitem", budgetItem.getDynamicObject("budgetitem"));
                                prePaySplitBudgetData.put("project", budgetItem.getDynamicObject("project"));
                            }
                        }
                        BigDecimal bigDecimal = oldPrePayAmount = prePaySplitBudgetData.get("prepayamount") == null ? BigDecimal.ZERO : (BigDecimal)prePaySplitBudgetData.get("prepayamount");
                        if (isProjectCostControl && index == payApplySplitEntry.size() - 1) {
                            prePayAmount = curSplitAmt.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : entryPaidAmount.subtract(sumPrePayAmount);
                        } else {
                            prePayAmount = thisPayAbleAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : curSplitAmt.multiply(entryPaidAmount).divide(thisPayAbleAmount, amtPrecision, RoundingMode.HALF_UP);
                            sumPrePayAmount = sumPrePayAmount.add(prePayAmount);
                        }
                        prePaySplitBudgetData.put("prepayamount", oldPrePayAmount.add(prePayAmount));
                        prePaySplitBudgetDataMap.put(budgetItemId, prePaySplitBudgetData);
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)paymentType, (CharSequence)ContractPayTypeEnum.PREPAYMENT.getValue()) || !prePaySplit) continue;
                    prePaySplitBudgetData = (Map)prePaySplitBudgetDataMap.get(budgetItemId);
                    if (prePaySplitBudgetData == null) {
                        prePaySplitBudgetData = new HashMap(16);
                        if (budgetItem != null) {
                            prePaySplitBudgetData.put("name", budgetItem.getString("name"));
                            prePaySplitBudgetData.put("budgetitem", budgetItem.getDynamicObject("budgetitem"));
                            prePaySplitBudgetData.put("project", budgetItem.getDynamicObject("project"));
                        }
                    }
                    BigDecimal oldPrePayDeduction = prePaySplitBudgetData.get("prepaydeduction") == null ? BigDecimal.ZERO : (BigDecimal)prePaySplitBudgetData.get("prepaydeduction");
                    prePaySplitBudgetData.put("prepaydeduction", oldPrePayDeduction.add(curSplitAmt));
                    prePaySplitBudgetDataMap.put(budgetItemId, prePaySplitBudgetData);
                }
            }
        }
        return prePaySplitBudgetDataMap;
    }
}

