/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;

public class ContractCollectItemService {
    private static final Log logger = LogFactory.getLog(ContractCollectItemService.class);

    public Object[] save(DynamicObject contract, PayPlanSourceEnum billType) {
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            Object[] objectArray = this.doSave(contract, billType);
            return objectArray;
        }
        catch (Exception e) {
            try {
                logger.info("\u6536\u6b3e\u6761\u76ee\u65b0\u589e\u5931\u8d25,contractId: {}, billType: {}", contract.getPkValue(), (Object)billType);
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void update(DynamicObject contract, DynamicObject contractRevisionBill, PayPlanSourceEnum billType) {
        try (TXHandle h = TX.required();){
            try {
                this.doUpdate(contract, contractRevisionBill, billType);
            }
            catch (Exception e) {
                logger.info("\u6536\u6b3e\u6761\u76ee\u66f4\u65b0\u5931\u8d25,contractId: {}, contractRevisionId: {}, billType: {}", new Object[]{contract.getPkValue(), contractRevisionBill.getPkValue(), billType});
                h.markRollback();
                throw e;
            }
        }
    }

    public static void setBillNameInPayPlanEntry(IDataModel model) {
        DynamicObjectCollection planEntry = null;
        String sourceName = null;
        String formBillId = model.getDataEntityType().getName();
        String billno = (String)model.getValue("billno");
        switch (formBillId) {
            case "pmct_incontract": {
                planEntry = model.getEntryEntity("incontpayplanentry");
                sourceName = PayPlanSourceEnum.CONTRACT.getValue();
                break;
            }
            case "pmct_contractrevision": {
                planEntry = model.getEntryEntity("incontpayplanentry");
                sourceName = PayPlanSourceEnum.REVISE.getValue();
                break;
            }
            case "pmct_incontractrevision": {
                planEntry = model.getEntryEntity("incomeplanentry");
                sourceName = PayPlanSourceEnum.MODIFY.getValue();
                break;
            }
            case "pmct_inclaimbill": {
                planEntry = model.getEntryEntity("claimincomeplanentry");
                sourceName = PayPlanSourceEnum.CLAIM.getValue();
                break;
            }
            case "pmct_inaddagreement": {
                planEntry = model.getEntryEntity("incomeplanentry");
                sourceName = PayPlanSourceEnum.ADDITION.getValue();
                break;
            }
        }
        if (planEntry != null) {
            String billStatus = (String)model.getValue("billstatus");
            for (int index = 0; index < planEntry.size(); ++index) {
                if (kd.pmgt.pmbs.common.enums.StatusEnum.UNCHECKED.getValue().equals(billStatus)) {
                    String incomeType = ((DynamicObject)planEntry.get(index)).getString("incometype");
                    model.setValue("incomeitemname", (Object)ContractCollectItemService.setBillName(incomeType, sourceName, billno, String.valueOf(index)), index);
                    continue;
                }
                if (!kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue().equals(billStatus)) continue;
                String conPayItemId = (String)model.getValue("conpayitemid");
                QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(conPayItemId));
                DynamicObject payItem = BusinessDataServiceHelper.loadSingle((String)"pmbs_contractpayitem", (String)"name", (QFilter[])new QFilter[]{idFilter});
                if (payItem == null) continue;
                String payItemName = payItem.getLocaleString("name").getLocaleValue();
                if (StringUtils.isBlank((CharSequence)payItemName)) {
                    payItemName = payItem.getString("name");
                }
                model.setValue("incomeitemname", (Object)payItemName);
            }
        }
    }

    public static String setBillName(String incomeType, String sourceName, String billNo, String seq) {
        if (StringUtils.isNotBlank((CharSequence)seq)) {
            return String.format("%s_%s_%s_%s", incomeType, sourceName, billNo, seq);
        }
        return String.format("%s_%s_%s", incomeType, sourceName, billNo);
    }

    private Object[] doSave(DynamicObject contract, PayPlanSourceEnum billType) {
        Object contractPk = contract.getPkValue();
        logger.info("ContractCollectItemService#save#contract#id:{}", contractPk);
        DynamicObjectCollection inContractPayPlanEntries = contract.getDynamicObjectCollection("incontpayplanentry");
        if (inContractPayPlanEntries.isEmpty()) {
            QFilter contractPkFilter = new QFilter("contract", "=", contractPk);
            DeleteServiceHelper.delete((String)"pmbs_contractcollectitem", (QFilter[])new QFilter[]{contractPkFilter});
            DynamicObject contractPayItem = this.defaultContractPayItem(contract, billType);
            contractPayItem.set("billno", (Object)("IN_" + billType.getValue() + "#" + contract.getString("billno") + "#0"));
            return SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contractPayItem});
        }
        return SaveServiceHelper.save((DynamicObject[])((DynamicObject[])inContractPayPlanEntries.stream().map(outContractPayPlanEntry -> this.contractPayItemByPayPlan(billType, contract, (DynamicObject)outContractPayPlanEntry)).toArray(DynamicObject[]::new)));
    }

    private void doUpdate(DynamicObject contract, DynamicObject contractRevisionBill, PayPlanSourceEnum billType) {
        DynamicObject[] newContractPayItems;
        DynamicObjectCollection incomePlanEntries = contractRevisionBill.getDynamicObjectCollection("incontpayplanentry");
        Object contractPk = contract.getPkValue();
        QFilter contractIdFilter = new QFilter("contract", "=", contractPk);
        DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)String.join((CharSequence)",", "id", "autogenerated"), (QFilter[])new QFilter[]{contractIdFilter});
        List dbItemIds = Arrays.stream(contractPayItems).map(it -> Long.parseLong(it.getPkValue().toString())).collect(Collectors.toList());
        DynamicObject autoGeneratedItem = null;
        for (DynamicObject contractPayItem : contractPayItems) {
            DynamicObject claimBill;
            if (!contractPayItem.getBoolean("autogenerated")) continue;
            DynamicObject collectItem = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contractPayItem.getPkValue().toString()), (String)"pmbs_contractcollectitem");
            String sourceBillType = collectItem.getString("sourcebilltype");
            long sourceBill = collectItem.getLong("sourcebill");
            if (PayPlanSourceEnum.CLAIM.getValue().equals(sourceBillType) && !(claimBill = BusinessDataServiceHelper.loadSingle((Object)sourceBill, (String)"pmct_claimbilltpl")).getBoolean("isneedsettle")) {
                dbItemIds.remove(Long.parseLong(contractPayItem.getPkValue().toString()));
                continue;
            }
            autoGeneratedItem = contractPayItem;
        }
        if (!incomePlanEntries.isEmpty() && autoGeneratedItem != null) {
            DeleteServiceHelper.delete((String)"pmbs_contractcollectitem", (QFilter[])new QFilter[]{new QFilter("id", "=", autoGeneratedItem.getPkValue())});
        }
        if (incomePlanEntries.isEmpty()) {
            QFilter contractPkFilter = new QFilter("contract", "=", contractPk);
            DeleteServiceHelper.delete((String)"pmbs_contractcollectitem", (QFilter[])new QFilter[]{contractPkFilter});
            DynamicObject contractPayItem = this.defaultContractPayItem(contract, billType);
            contractPayItem.set("billno", (Object)("IN_" + billType.getValue() + "#" + contractRevisionBill.getString("billno") + "#0"));
            newContractPayItems = new DynamicObject[]{contractPayItem};
        } else {
            newContractPayItems = (DynamicObject[])incomePlanEntries.stream().map(incomePlanEntry -> {
                DynamicObject contractIncomeItem;
                long contractItemId = incomePlanEntry.getLong("conincomeitemid");
                dbItemIds.remove(contractItemId);
                if (contractItemId != 0L) {
                    contractIncomeItem = BusinessDataServiceHelper.loadSingle((Object)contractItemId, (String)"pmbs_contractcollectitem");
                    contractIncomeItem.set("customer", incomePlanEntry.get("customer"));
                    contractIncomeItem.set("collecttype", incomePlanEntry.get("incometype"));
                    contractIncomeItem.set("collectfeq", incomePlanEntry.get("incomemethod"));
                    contractIncomeItem.set("collectway", incomePlanEntry.get("incomeway"));
                    contractIncomeItem.set("collectpercent", incomePlanEntry.get("incomepercent"));
                    contractIncomeItem.set("collectamount", (Object)incomePlanEntry.getBigDecimal("incomeamount"));
                    contractIncomeItem.set("plancollecttime", incomePlanEntry.get("planincometime"));
                    BigDecimal unCollectedAmt = incomePlanEntry.getBigDecimal("incomeamount").subtract(contractIncomeItem.getBigDecimal("collectedcomamt"));
                    contractIncomeItem.set("uncollectedamt", (Object)unCollectedAmt);
                    contractIncomeItem.set("remarks", incomePlanEntry.get("incomedescription"));
                    contractIncomeItem.set("sourcebill", incomePlanEntry.getPkValue());
                    contractIncomeItem.set("sourcebilltype", (Object)billType.getValue());
                    contractIncomeItem.set("billno", (Object)("IN_" + billType.getValue() + "#" + contractRevisionBill.getString("billno") + "#" + incomePlanEntry.getString("seq")));
                    contractIncomeItem.set("currency", contract.get("currency"));
                    Date now = new Date();
                    contractIncomeItem.set("modifytime", (Object)now);
                    contractIncomeItem.set("modifier", (Object)RequestContext.get().getUserId());
                } else {
                    contractIncomeItem = this.contractPayItemByPayPlan(billType, contract, (DynamicObject)incomePlanEntry);
                }
                return contractIncomeItem;
            }).toArray(DynamicObject[]::new);
            SaveServiceHelper.update((DynamicObject)contractRevisionBill);
        }
        SaveServiceHelper.save((DynamicObject[])newContractPayItems);
        QFilter pksFilter = new QFilter("id", "in", dbItemIds);
        DeleteServiceHelper.delete((String)"pmbs_contractcollectitem", (QFilter[])new QFilter[]{pksFilter});
    }

    private DynamicObject contractPayItemByPayPlan(PayPlanSourceEnum billType, DynamicObject contract, DynamicObject inContractPayPlanEntry) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_contractcollectitem");
        DynamicObject contractPayItem = new DynamicObject((DynamicObjectType)dt);
        long pk = ORM.create().genLongId("pmbs_contractcollectitem");
        contractPayItem.set("id", (Object)pk);
        contractPayItem.set("masterid", (Object)pk);
        contractPayItem.set("sourcebill", inContractPayPlanEntry.getPkValue());
        contractPayItem.set("sourcebilltype", (Object)billType.getValue());
        contractPayItem.set("billno", (Object)("IN_" + billType.getValue() + "#" + contract.getString("billno") + "#" + inContractPayPlanEntry.getString("seq")));
        contractPayItem.set("autogenerated", (Object)false);
        contractPayItem.set("currency", contract.get("currency"));
        contractPayItem.set("contract", contract.getPkValue());
        contractPayItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
        contractPayItem.set("status", (Object)StatusEnum.Checked.toString());
        if (billType == PayPlanSourceEnum.REVISE) {
            DynamicObject contractRevision = (DynamicObject)inContractPayPlanEntry.getParent();
            Long contractRevisionId = Long.parseLong(contractRevision.getPkValue().toString());
            contractRevision = BusinessDataServiceHelper.loadSingle((Object)contractRevisionId, (String)"pmct_contractrevision");
            contractPayItem.set("billno", (Object)("IN_" + billType.getValue() + "#" + contractRevision.getString("billno") + "#" + inContractPayPlanEntry.getString("seq")));
            contractPayItem.set("customer", inContractPayPlanEntry.get("customer"));
            contractPayItem.set("collecttype", inContractPayPlanEntry.get("incometype"));
            contractPayItem.set("collectfeq", inContractPayPlanEntry.get("incomemethod"));
            contractPayItem.set("collectway", inContractPayPlanEntry.get("incomeway"));
            contractPayItem.set("collectpercent", inContractPayPlanEntry.get("incomepercent"));
            contractPayItem.set("collectamount", inContractPayPlanEntry.get("incomeamount"));
            contractPayItem.set("uncollectedamt", contractPayItem.get("collectamount"));
            contractPayItem.set("plancollecttime", inContractPayPlanEntry.get("planincometime"));
            contractPayItem.set("remarks", inContractPayPlanEntry.get("incomedescription"));
            contractPayItem.set("nodesetting", inContractPayPlanEntry.get("incomenodesetting"));
            contractPayItem.set("nodesettingsource", inContractPayPlanEntry.get("incomesource"));
            contractPayItem.set("ctrlstrategy", inContractPayPlanEntry.get("incomectrlstrategy"));
            inContractPayPlanEntry.set("conincomeitemid", (Object)pk);
        } else {
            contractPayItem.set("customer", inContractPayPlanEntry.get("customer"));
            contractPayItem.set("collecttype", inContractPayPlanEntry.get("paytype"));
            contractPayItem.set("collectfeq", inContractPayPlanEntry.get("paymethod"));
            contractPayItem.set("collectway", inContractPayPlanEntry.get("payway"));
            contractPayItem.set("collectpercent", inContractPayPlanEntry.get("paypercent"));
            contractPayItem.set("collectamount", inContractPayPlanEntry.get("payamount"));
            contractPayItem.set("uncollectedamt", contractPayItem.get("collectamount"));
            contractPayItem.set("plancollecttime", inContractPayPlanEntry.get("planpaytime"));
            contractPayItem.set("remarks", inContractPayPlanEntry.get("remarks"));
            contractPayItem.set("nodesetting", inContractPayPlanEntry.get("nodesetting"));
            contractPayItem.set("nodesettingsource", inContractPayPlanEntry.get("nodesettingsource"));
            contractPayItem.set("ctrlstrategy", inContractPayPlanEntry.get("ctrlstrategy"));
            inContractPayPlanEntry.set("conplanitemid", (Object)pk);
        }
        Date now = new Date();
        contractPayItem.set("createtime", (Object)now);
        contractPayItem.set("modifytime", (Object)now);
        contractPayItem.set("creator", (Object)RequestContext.get().getUserId());
        contractPayItem.set("modifier", (Object)RequestContext.get().getUserId());
        contractPayItem.set("paydirection", (Object)PayDirectionEnum.IN.getValue());
        return contractPayItem;
    }

    private DynamicObject defaultContractPayItem(DynamicObject contract, PayPlanSourceEnum billType) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_contractcollectitem");
        DynamicObject contractPayItem = new DynamicObject((DynamicObjectType)dt);
        long pk = ORM.create().genLongId("pmbs_contractcollectitem");
        contractPayItem.set("id", (Object)pk);
        contractPayItem.set("masterid", (Object)pk);
        contractPayItem.set("sourcebill", contract.getPkValue());
        contractPayItem.set("sourcebilltype", (Object)billType.getValue());
        contractPayItem.set("billno", (Object)("IN_" + billType.getValue() + "#" + contract.getString("billno") + "#0"));
        contractPayItem.set("autogenerated", (Object)true);
        contractPayItem.set("collectamount", contract.get("originaloftaxamount"));
        contractPayItem.set("uncollectedamt", contractPayItem.get("collectamount"));
        contractPayItem.set("currency", contract.get("currency"));
        contractPayItem.set("contract", contract.getPkValue());
        contractPayItem.set("enable", (Object)EnableEnum.ENABLE.getValue());
        contractPayItem.set("status", (Object)StatusEnum.Checked.toString());
        contractPayItem.set("customer", (Object)contract.getDynamicObject("parta"));
        contractPayItem.set("collectpercent", (Object)100);
        Date now = new Date();
        contractPayItem.set("createtime", (Object)now);
        contractPayItem.set("modifytime", (Object)now);
        contractPayItem.set("creator", (Object)RequestContext.get().getUserId());
        contractPayItem.set("modifier", (Object)RequestContext.get().getUserId());
        contractPayItem.set("paydirection", (Object)PayDirectionEnum.IN.getValue());
        return contractPayItem;
    }

    public int delete(DynamicObject contract) {
        int count;
        Object contractPk = contract.getPkValue();
        logger.info("ContractCollectItemService#delete#contract#id:{}", contractPk);
        try (TXHandle h = TX.required();){
            try {
                count = DeleteServiceHelper.delete((String)"pmbs_contractcollectitem", (QFilter[])new QFilter[]{new QFilter("contract", "=", contractPk)});
            }
            catch (Exception e) {
                logger.info("\u5220\u9664\u5408\u540c\u6536\u6b3e\u6761\u76ee\u5931\u8d25, contract#id:{}", contractPk);
                h.markRollback();
                throw e;
            }
        }
        return count;
    }
}

