/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.service.bizrule;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;

public class OpBizRuleSupport {
    private Set<String> ruleTypes = Sets.newHashSet();
    private Map<String, String> operationToRuleMap = new HashMap<String, String>();
    private String entityNumber;
    private Map<String, Set<String>> bizRuleMap = null;

    public OpBizRuleSupport(DynamicObjectCollection collection) {
        this.initProjectBudgetRuleTypes();
        this.initOpBizRuleParam(collection);
    }

    private void initProjectBudgetRuleTypes() {
        this.ruleTypes = Sets.newHashSet((Object[])new String[]{"requestProjectBudget", "execProjectBudget", "returnProjectBudget", "clearProjectBudget", "returnAndClearProjectBudget", "requestAndExecProjectBudget"});
        this.operationToRuleMap.put(BillFieldTypeEnum.TAKE_OPERATION.getNumber(), "requestProjectBudget");
        this.operationToRuleMap.put(BillFieldTypeEnum.RETURN_OPERATION.getNumber(), "returnProjectBudget");
        this.operationToRuleMap.put(BillFieldTypeEnum.EXEC_OPERATION.getNumber(), "execProjectBudget");
        this.operationToRuleMap.put(BillFieldTypeEnum.CLEAR_OPERATION.getNumber(), "clearProjectBudget");
        this.operationToRuleMap.put(BillFieldTypeEnum.RETURNANDCLEAR_OPERATION.getNumber(), "returnAndClearProjectBudget");
        this.operationToRuleMap.put(BillFieldTypeEnum.TAKEANDEXEC_OPERATION.getNumber(), "requestAndExecProjectBudget");
    }

    public void updateOpBizRule() {
        if (this.bizRuleMap == null) {
            return;
        }
        Map<String, Map<String, Map<String, Long>>> bosRuleMap = this.loadBosRule();
        this.removeOpRuleSet(bosRuleMap);
        this.updateOpRuleSet(this.bizRuleMap);
    }

    public void deleteOpBizRule(String entityNumber, Set<String> opKeyList) {
        opKeyList.addAll(Sets.newHashSet((Object[])new String[]{"requestProjectBudget", "execProjectBudget", "returnProjectBudget", "clearProjectBudget", "returnAndClearProjectBudget", "requestAndExecProjectBudget"}));
        for (String opKey : opKeyList) {
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entityNumber, (String)opKey);
        }
    }

    private Map<String, Set<String>> initOpBizRuleParam(DynamicObjectCollection collection) {
        this.bizRuleMap = new HashMap<String, Set<String>>();
        for (DynamicObject entry : collection) {
            String operationNumber;
            String bizRule;
            String bizOpNumber;
            if (StringUtils.isEmpty((CharSequence)this.entityNumber)) {
                this.entityNumber = entry.getDynamicObject("opbill").getString("fieldtable");
            }
            if (!StringUtils.isNotEmpty((CharSequence)(bizOpNumber = entry.getString("bizopnumber"))) || !StringUtils.isNotBlank((CharSequence)(bizRule = this.operationToRuleMap.get(operationNumber = entry.getString("budgetopactionnum"))))) continue;
            Set<String> bizOpNumberSet = this.bizRuleMap.get(bizRule);
            if (bizOpNumberSet == null) {
                bizOpNumberSet = new HashSet<String>();
            }
            bizOpNumberSet.add(bizOpNumber);
            this.bizRuleMap.put(bizRule, bizOpNumberSet);
        }
        return null;
    }

    private Map<String, Map<String, Map<String, Long>>> loadBosRule() {
        HashMap<String, Map<String, Map<String, Long>>> bosRuleMap = new HashMap<String, Map<String, Map<String, Long>>>();
        QFilter typeFilter = new QFilter("opbizrule", "in", this.ruleTypes);
        QFilter objectTypeFilter = new QFilter("objecttype", "=", (Object)this.entityNumber);
        String selectFields = "opbizrule, objecttype, entryentity.id, entryentity.operationkey";
        DynamicObjectCollection opRules = QueryServiceHelper.query((String)"bos_opbizruleset", (String)selectFields, (QFilter[])new QFilter[]{typeFilter, objectTypeFilter});
        for (DynamicObject opRule : opRules) {
            this.entityNumber = opRule.getString("objecttype");
            Map ruleMap = bosRuleMap.computeIfAbsent(this.entityNumber, k -> new HashMap());
            Map operationMap = ruleMap.computeIfAbsent(opRule.getString("opbizrule"), k -> new HashMap());
            operationMap.put(opRule.getString("entryentity.operationkey"), opRule.getLong("entryentity.id"));
        }
        return bosRuleMap;
    }

    private void updateOpRuleSet(Map<String, Set<String>> bizRuleMap) {
        if (bizRuleMap == null || bizRuleMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Set<String>> stringSetEntry : bizRuleMap.entrySet()) {
            String rule = stringSetEntry.getKey();
            Set<String> operations = stringSetEntry.getValue();
            if (this.entityNumber == null || rule == null || operations == null || operations.isEmpty()) continue;
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)this.entityNumber, (String)rule, new ArrayList<String>(operations));
        }
    }

    private void removeOpRuleSet(Map<String, Map<String, Map<String, Long>>> bosRuleMap) {
        if (bosRuleMap == null || bosRuleMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, Map<String, Long>>> entry : bosRuleMap.entrySet()) {
            for (String projectBudgetRuleType : this.ruleTypes) {
                OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entry.getKey(), (String)projectBudgetRuleType);
            }
        }
    }
}

