/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.service.budgetreg;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.EventBillTreeTypeEnum;
import kd.pmgt.pmbs.common.tree.DynamicInfoCollection;

public class OuterBillRegisterService {
    private String billType_application = EventBillTreeTypeEnum.APPLICATION.getNumber();
    private String billType_bill = EventBillTreeTypeEnum.BILL.getNumber();
    private String billType_cloud = EventBillTreeTypeEnum.CLOUD.getNumber();

    public void dealOuterBill(List<String> outerBillNums, String insideNodeId) {
        List neededCloud;
        Object appNumber;
        QFilter qBillNumFilter = new QFilter("number", "in", (Object)outerBillNums.toArray());
        DynamicObjectCollection outerBills = QueryServiceHelper.query((String)"bos_formmeta", (String)"id,number,name,bizappid", (QFilter[])new QFilter[]{qBillNumFilter});
        HashSet<String> appOrCloudInfos = new HashSet<String>(16);
        DynamicInfoCollection newEntityInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u6682\u5b58\u8981\u521b\u5efa\u884c\u7684\u6570\u636e\u4fe1\u606f", (String)"OuterBillRegisterService_3", (String)"pmgt-pmbs-business", (Object[])new Object[0]), new String[]{"name", "number", "parentNum", "billTreeNodeType", "billTreeNode"});
        for (DynamicObject outerBill : outerBills) {
            String name = outerBill.getString("name");
            String billNumber = outerBill.getString("number");
            String bizAppId = outerBill.getString("bizappid");
            newEntityInfos.addInfo(new Object[]{name, billNumber, bizAppId, this.billType_bill, null});
            appOrCloudInfos.add(bizAppId);
        }
        QFilter idFilter = new QFilter("id", "in", (Object)appOrCloudInfos.toArray());
        DynamicObjectCollection appInfos = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number,name,bizcloud.number,bizcloud.name", (QFilter[])new QFilter[]{idFilter});
        appOrCloudInfos.clear();
        for (DynamicObject app : appInfos) {
            String id = app.getString("id");
            String name = app.getString("name");
            appNumber = app.getString("number");
            String cloudNum = app.getString("bizcloud.number");
            String cloudName = app.getString("bizcloud.name");
            if (appOrCloudInfos.add(cloudNum)) {
                newEntityInfos.addInfo(new Object[]{cloudName, cloudNum, insideNodeId, this.billType_cloud, null});
            }
            newEntityInfos.getAllInfoByOneProp("parentNum", (Object)id).forEach(arg_0 -> this.lambda$dealOuterBill$0((String)appNumber, arg_0));
            newEntityInfos.addInfo(new Object[]{name, appNumber, cloudNum + "-" + this.billType_cloud, this.billType_application, null});
        }
        DynamicInfoCollection regedRowInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u5df2\u6ce8\u518c\u884c\u7684\u4fe1\u606f", (String)"OuterBillRegisterService_1", (String)"pmgt-pmbs-business", (Object[])new Object[0]), new String[]{"id", "number", "billtype"});
        QFilter qApp = new QFilter("billtype", "=", (Object)this.billType_application);
        qApp.and("number", "in", (Object)newEntityInfos.getAllValOfOnePropByAnotherProp("number", "billTreeNodeType", (Object)this.billType_application).toArray());
        QFilter qCloud = new QFilter("billtype", "=", (Object)this.billType_cloud);
        qCloud.and("number", "in", (Object)newEntityInfos.getAllValOfOnePropByAnotherProp("number", "billTreeNodeType", (Object)this.billType_cloud).toArray());
        qApp.or(qCloud);
        DataSet data = QueryServiceHelper.queryDataSet((String)"FieldRegisterList", (String)"pmbs_structofbill", (String)"id,number,billtype", (QFilter[])new QFilter[]{qApp}, null);
        appNumber = null;
        try {
            while (data.hasNext()) {
                Row rowData = data.next();
                String id = rowData.getString("id");
                String number = rowData.getString("number");
                String billType = rowData.getString("billtype");
                regedRowInfos.addInfo(new Object[]{id, number, billType});
            }
        }
        catch (Throwable rowData) {
            appNumber = rowData;
            throw rowData;
        }
        finally {
            if (data != null) {
                if (appNumber != null) {
                    try {
                        data.close();
                    }
                    catch (Throwable rowData) {
                        ((Throwable)appNumber).addSuppressed(rowData);
                    }
                } else {
                    data.close();
                }
            }
        }
        if (!regedRowInfos.isEmpty()) {
            List regAppNums = regedRowInfos.getAllValOfOnePropByAnotherProp("number", "billtype", (Object)this.billType_application);
            List regCloudNums = regedRowInfos.getAllValOfOnePropByAnotherProp("number", "billtype", (Object)this.billType_cloud);
            Iterator iterator = newEntityInfos.getValues().iterator();
            DynamicInfoCollection.InfoObject infoObject = null;
            while (iterator.hasNext()) {
                infoObject = (DynamicInfoCollection.InfoObject)iterator.next();
                String type = (String)infoObject.getValueByPropName("billTreeNodeType");
                String num = (String)infoObject.getValueByPropName("number");
                if (type.equals(this.billType_application)) {
                    if (!regAppNums.contains(num)) continue;
                    iterator.remove();
                    continue;
                }
                if (!type.equals(this.billType_cloud) || !regCloudNums.contains(num)) continue;
                iterator.remove();
            }
        }
        if ((neededCloud = newEntityInfos.getAllValOfOnePropByAnotherProp("parentNum", "billTreeNodeType", (Object)this.billType_application)) != null) {
            Iterator iterator = newEntityInfos.getValues().iterator();
            while (iterator.hasNext()) {
                DynamicInfoCollection.InfoObject infoObject = (DynamicInfoCollection.InfoObject)iterator.next();
                String type = (String)infoObject.getValueByPropName("billTreeNodeType");
                String num = infoObject.getValueByPropName("number") + "-cloud";
                if (!type.equals(this.billType_cloud) || neededCloud.contains(num)) continue;
                iterator.remove();
            }
        }
        this.batchCreateNode(newEntityInfos, regedRowInfos, this.billType_cloud);
        this.batchCreateNode(newEntityInfos, regedRowInfos, this.billType_application);
        this.batchCreateNode(newEntityInfos, null, this.billType_bill);
        List billEntities = newEntityInfos.getAllValOfOneProp("billTreeNode");
        SaveServiceHelper.save((DynamicObject[])billEntities.toArray(new DynamicObject[0]));
    }

    private void batchCreateNode(DynamicInfoCollection newBillInfo, DynamicInfoCollection regedRowInfos, String billType) {
        List newNodes = newBillInfo.getAllInfoByOneProp("billTreeNodeType", (Object)billType);
        if (!newNodes.isEmpty()) {
            newNodes.forEach(newNode -> {
                String num = (String)newNode.getValueByPropName("number");
                String name = (String)newNode.getValueByPropName("name");
                String parentId = (String)newNode.getValueByPropName("parentNum");
                DynamicObject node = this.createNode(name, num, parentId, null, null, billType, false);
                if (regedRowInfos != null) {
                    regedRowInfos.addInfo(new Object[]{node.getString("id"), num, billType});
                }
                newNode.setValueByPropName("billTreeNode", (Object)node);
            });
        }
        if (regedRowInfos != null) {
            List regNodeInfo = regedRowInfos.getAllInfoByOneProp("billtype", (Object)billType);
            regNodeInfo.forEach(node -> {
                String aid = (String)node.getValueByPropIndex(0);
                String num = (String)node.getValueByPropIndex(1);
                List newBills = newBillInfo.getAllInfoByOneProp("parentNum", (Object)(num + "-" + billType));
                newBills.forEach(bill -> bill.setValueByPropName("parentNum", (Object)aid));
            });
        }
    }

    private DynamicObject createNode(String name, String number, String parentId, String longNumber, String longName, String billType, boolean isFromOter) {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject structOfBill = BusinessDataServiceHelper.newDynamicObject((String)"pmbs_structofbill");
        structOfBill.set("id", (Object)DBServiceHelper.genGlobalLongId());
        structOfBill.set("name", (Object)new LocaleString(name));
        structOfBill.set("number", (Object)number);
        structOfBill.set("creator", (Object)userId);
        Date createTime = new Date();
        structOfBill.set("createtime", (Object)createTime);
        structOfBill.set("enable", (Object)EnableEnum.ENABLE.getValue());
        structOfBill.set("status", (Object)StatusEnum.CHECKED.getValue());
        structOfBill.set("modifytime", (Object)createTime);
        structOfBill.set("isleaf", (Object)0);
        structOfBill.set("longnumber", (Object)longNumber);
        structOfBill.set("billtype", (Object)billType);
        structOfBill.set("parent", (Object)parentId);
        structOfBill.set("isfromouter", (Object)isFromOter);
        structOfBill.set("fullname", (Object)longName);
        if (billType != null && billType.equals(this.billType_bill)) {
            structOfBill.set("fieldtable", (Object)number);
            structOfBill.set("isleaf", (Object)1);
        }
        return structOfBill;
    }

    private /* synthetic */ void lambda$dealOuterBill$0(String appNumber, DynamicInfoCollection.InfoObject info) {
        info.setValueByPropName("parentNum", (Object)(appNumber + "-" + this.billType_application));
    }
}

