/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.support;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LeftTreeRightGridBillSupport {
    private static final Log logger = LogFactory.getLog(LeftTreeRightGridBillSupport.class);
    String targetMetaDataCode;
    TreeNode treeNode;
    DynamicObjectCollection gridData;
    int[] viewSelectedIndexes;
    int viewCurrentIndex;
    String currentTreeNode;
    boolean containLower = false;

    public LeftTreeRightGridBillSupport(String targetMetaDataCode, TreeNode treeNode, int viewSelectedIndex, DynamicObjectCollection gridData, String currentTreeNode) {
        this(targetMetaDataCode, treeNode, new int[]{viewSelectedIndex}, gridData, currentTreeNode, false);
    }

    public LeftTreeRightGridBillSupport(String targetMetaDataCode, TreeNode treeNode, int viewSelectedIndex, DynamicObjectCollection gridData, String currentTreeNode, boolean containLower) {
        this(targetMetaDataCode, treeNode, new int[]{viewSelectedIndex}, gridData, currentTreeNode, containLower);
    }

    public LeftTreeRightGridBillSupport(String targetMetaDataCode, TreeNode treeNode, int[] viewSelectedIndexes, DynamicObjectCollection gridData, String currentTreeNode) {
        this(targetMetaDataCode, treeNode, viewSelectedIndexes, gridData, currentTreeNode, false);
    }

    public LeftTreeRightGridBillSupport(String targetMetaDataCode, TreeNode treeNode, int[] viewSelectedIndexes, DynamicObjectCollection gridData, String currentTreeNode, boolean containLower) {
        this.targetMetaDataCode = targetMetaDataCode;
        this.gridData = gridData;
        this.currentTreeNode = currentTreeNode;
        this.treeNode = treeNode;
        this.viewSelectedIndexes = viewSelectedIndexes;
        this.containLower = containLower;
    }

    public int[] switchSelectedViewIndex2GridIndex() {
        logger.info("LeftTreeRightGridBillSupport#switchSelectedViewIndex2GridIndex viewSelectedIndexes: {}", (Object)this.viewSelectedIndexes);
        return Arrays.stream(this.viewSelectedIndexes).map(this::switchViewIndex2GridIndex).boxed().mapToInt(Integer::valueOf).toArray();
    }

    public int switchCurrentViewIndex2GridIndex() {
        if (null != this.viewSelectedIndexes && this.viewSelectedIndexes.length > 0) {
            return this.switchViewIndex2GridIndex(this.viewSelectedIndexes[0]);
        }
        return 0;
    }

    protected int switchViewIndex2GridIndex(int viewIndex) {
        int gridIndex = 0;
        int findIndex = 0;
        int dataIndex = 0;
        for (DynamicObject entry : this.gridData) {
            DynamicObject targetObject = entry.getDynamicObject(this.targetMetaDataCode);
            if (StringUtils.equals((CharSequence)this.currentTreeNode, (CharSequence)"001")) {
                gridIndex = viewIndex;
            } else if (this.belongToCurrentTreeNode(targetObject)) {
                if (viewIndex == findIndex) {
                    gridIndex = dataIndex;
                }
                ++findIndex;
            }
            ++dataIndex;
        }
        logger.info("LeftTreeRightGridBillSupport#switchViewIndex2GridIndex viewIndex:{}, gridIndex:{}", (Object)viewIndex, (Object)gridIndex);
        return gridIndex;
    }

    private boolean belongToCurrentTreeNode(DynamicObject targetObject) {
        if (targetObject == null) {
            return false;
        }
        String targetPk = targetObject.getPkValue().toString();
        boolean isTarget = this.containLower ? this.belongToCurrentTreeNode(this.treeNode.getTreeNode(this.currentTreeNode, 100), targetPk) : this.currentTreeNode.equals(targetPk);
        return isTarget;
    }

    private boolean belongToCurrentTreeNode(TreeNode treeNode, String currentTreeNode) {
        if (StringUtils.equals((CharSequence)treeNode.getId(), (CharSequence)currentTreeNode)) {
            return true;
        }
        if (treeNode.getChildren() != null) {
            for (TreeNode child : treeNode.getChildren()) {
                if (!this.belongToCurrentTreeNode(child, currentTreeNode)) continue;
                return true;
            }
        }
        return false;
    }
}

