/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.utils.AssociatedTableModel;
import kd.pmgt.pmbs.business.utils.AutoPushUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class AutoPushOperation {
    private static final Log LOG = LogFactory.getLog(AutoPushOperation.class);
    private PushArgs pushArgs;
    private Object srcBillPk;
    private String targetBill;
    private List<AssociatedTableModel> associatedTableModels;

    public AutoPushOperation(Object srcBillPk, String sourceBill, String targetBill, String appId, String ruleId, List<AssociatedTableModel> associatedTableModels) {
        this.initPushArgs(srcBillPk, sourceBill, targetBill, appId, ruleId, associatedTableModels);
    }

    public AutoPushOperation(Object srcBillPk, String sourceBill, String targetBill, String appId, List<AssociatedTableModel> associatedTableModels) {
        this.initPushArgs(srcBillPk, sourceBill, targetBill, appId, null, associatedTableModels);
    }

    public AutoPushOperation(PushArgs pushArgs, Object srcBillPk) {
        this.pushArgs = pushArgs;
        this.srcBillPk = srcBillPk;
        this.targetBill = pushArgs.getTargetEntityNumber();
    }

    private void initPushArgs(Object srcBillPk, String sBill, String tBill, String appId, String ruleId, List<AssociatedTableModel> associatedTableModels) {
        if (srcBillPk == null || StringUtils.isEmpty((CharSequence)sBill) || StringUtils.isEmpty((CharSequence)tBill) || CollectionUtils.isEmpty(associatedTableModels)) {
            throw new IllegalArgumentException("auto push operation lose necessary param");
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sBill);
        pushArgs.setTargetEntityNumber(tBill);
        pushArgs.setHasRight(true);
        pushArgs.setAppId(appId);
        if (ruleId != null) {
            pushArgs.setRuleId(ruleId);
        }
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow srcBill = new ListSelectedRow(srcBillPk);
        selectedRows.add(srcBill);
        pushArgs.setSelectedRows(selectedRows);
        this.pushArgs = pushArgs;
        this.srcBillPk = srcBillPk;
        this.targetBill = tBill;
        this.associatedTableModels = associatedTableModels;
    }

    public DynamicObject pushAction() {
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)this.targetBill);
        String billName = targetMainType.getDisplayName().getLocaleValue();
        if (this.pushArgs == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%s\u65f6\uff0c\u4e0b\u63a8\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AutoPushOperation_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]), billName));
        }
        ConvertOperationResult pushResult = this.push(billName);
        List targetBill = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (targetBill == null) {
            return null;
        }
        DynamicObject pushObject = (DynamicObject)targetBill.get(0);
        OperationResult saveResult = this.saveOperate(billName, targetBill, pushObject);
        String exceptionMsg = ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%1$s\u65f6\uff0c\u63d0\u4ea4\u5931\u8d25\uff1a%2$s", (String)"AutoPushOperation_1", (String)"pmgt-pmbs-business", (Object[])new Object[0]);
        String logMsg = ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%s\u65f6\uff0c\u63d0\u4ea4\u6210\u529f\u3002", (String)"AutoPushOperation_13", (String)"pmgt-pmbs-business", (Object[])new Object[0]);
        this.executeOperate(billName, pushObject, saveResult, "submit", exceptionMsg, logMsg);
        exceptionMsg = ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%1$s\u65f6\uff0c\u5ba1\u6838\u5931\u8d25\uff1a%2$s", (String)"AutoPushOperation_3", (String)"pmgt-pmbs-business", (Object[])new Object[0]);
        logMsg = ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%s\u65f6\uff0c\u5ba1\u6838\u6210\u529f\u3002", (String)"AutoPushOperation_14", (String)"pmgt-pmbs-business", (Object[])new Object[0]);
        this.executeOperate(billName, pushObject, saveResult, "audit", exceptionMsg, logMsg);
        return pushObject;
    }

    @NotNull
    private ConvertOperationResult push(String billName) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)this.pushArgs);
            if (!pushResult.isSuccess()) {
                String errMessage = this.pushErrorMsgHandle(pushResult);
                LOG.error("push\uff1abillName %s\uff0cerrMessage\uff1a%s", (Object)billName, (Object)errMessage);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%1$s\u65f6\uff0c\u4e0b\u63a8\u5931\u8d25\uff1a%2$s", (String)"AutoPushOperation_5", (String)"pmgt-pmbs-business", (Object[])new Object[0]), billName, errMessage));
            }
            ConvertOperationResult convertOperationResult = pushResult;
            return convertOperationResult;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @NotNull
    protected OperationResult saveOperate(String billName, List<DynamicObject> targetBillObjs, DynamicObject pushObject) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("ignorewarn", String.valueOf(true));
            saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
            saveOption.setVariableValue("strictvalidation", String.valueOf(true));
            saveOption.setVariableValue("ishasright", String.valueOf(true));
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)this.targetBill, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)saveOption);
            if (!saveResult.isSuccess()) {
                StringBuilder errMessage = this.errorMsgHandle(saveResult);
                LOG.error("saveOperate\uff1abillName:%s\uff0cerrMessage\uff1a%s\u3002", (Object)billName, (Object)errMessage.toString());
                this.deletePushObject(pushObject);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%1$s\u65f6\uff0c\u4fdd\u5b58\u5931\u8d25\uff1a%2$s", (String)"AutoPushOperation_11", (String)"pmgt-pmbs-business", (Object[])new Object[0]), billName, errMessage.toString()));
            }
            LOG.info("saveOperate\uff1abillName %s\uff0csuccess\u3002", (Object)billName);
            OperationResult operationResult = saveResult;
            return operationResult;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected void executeOperate(String billName, DynamicObject proObject, OperationResult saveResult, String operateKey, String exceptionMsg, String logMsg) {
        try (TXHandle h = TX.requiresNew();){
            OperateOption submitOption = OperateOption.create();
            submitOption.setVariableValue("ignorewarn", String.valueOf(true));
            submitOption.setVariableValue("ignoreinteraction", String.valueOf(true));
            submitOption.setVariableValue("strictvalidation", String.valueOf(true));
            submitOption.setVariableValue("ishasright", String.valueOf(true));
            OperationResult submitResult = null;
            try {
                submitResult = OperationServiceHelper.executeOperate((String)operateKey, (String)this.targetBill, (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)submitOption);
                if (!submitResult.isSuccess()) {
                    StringBuilder errMessage = this.errorMsgHandle(submitResult);
                    String errorMsg = String.format(exceptionMsg, billName, errMessage.toString());
                    LOG.error(errorMsg);
                    this.deletePushObject(proObject);
                    throw new KDBizException(errorMsg);
                }
                LOG.info(String.format(logMsg, billName));
            }
            catch (Exception e) {
                h.markRollback();
                if (submitResult == null) {
                    this.deletePushObject(proObject);
                    LOG.error((Throwable)e);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%s\u65f6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u4e91\u73af\u5883\u662f\u5426\u6b63\u5e38\u3002", (String)"AutoPushOperation_17", (String)"pmgt-pmbs-business", (Object[])new Object[0]), billName));
                }
            }
        }
    }

    @NotNull
    private String pushErrorMsgHandle(ConvertOperationResult pushResult) {
        ArrayList<String> messageList = new ArrayList<String>();
        messageList.add(pushResult.getMessage());
        List detailMessageList = pushResult.getBillReports().stream().map(report -> report.getFailMessage()).collect(Collectors.toList());
        messageList.addAll(detailMessageList);
        String errMessage = messageList.stream().collect(Collectors.joining("\r\n"));
        return errMessage;
    }

    @NotNull
    private StringBuilder errorMsgHandle(OperationResult auditResult) {
        StringBuilder errMessage = new StringBuilder();
        errMessage.append(auditResult.getMessage());
        for (IOperateInfo errInfo : auditResult.getAllErrorOrValidateInfo()) {
            String detailMessage = errInfo.getMessage();
            LOG.error(detailMessage);
            errMessage.append(detailMessage);
        }
        return errMessage;
    }

    protected void deletePushObject(DynamicObject pushObj) {
        try (TXHandle h = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.targetBill), (Object[])new Object[]{pushObj.getPkValue()});
            }
            catch (Exception e) {
                h.markRollback();
                LOG.error("AutoPushOperation.deletePushObject error", (Throwable)e);
                throw e;
            }
        }
        AutoPushUtil.deleteAssociation(Long.valueOf(this.srcBillPk.toString()), this.associatedTableModels);
    }

    public DynamicObject pushActionWithAsyncOP() {
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)this.targetBill);
        String billName = targetMainType.getDisplayName().getLocaleValue();
        if (this.pushArgs == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%s\u65f6\uff0c\u4e0b\u63a8\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AutoPushOperation_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]), billName));
        }
        ConvertOperationResult pushResult = this.push(billName);
        List targetBill = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (targetBill == null) {
            return null;
        }
        DynamicObject pushObject = (DynamicObject)targetBill.get(0);
        OperationResult saveResult = this.saveOperate(billName, targetBill, pushObject);
        return pushObject;
    }
}

