/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.utils;

import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.business.utils.AssociatedTableModel;

public class AutoPushUtil {
    private static final Log LOG = LogFactory.getLog(AutoPushUtil.class);

    public static void deleteAssociation(Long fsbillid, List<AssociatedTableModel> associatedTableModels) {
        if (fsbillid == null || associatedTableModels == null || associatedTableModels.isEmpty()) {
            throw new KDBizException("fsbillid or associatedTableModels is null.");
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                associatedTableModels.forEach(tableModel -> {
                    String dbRoute = tableModel.getDbRoute();
                    String tableName = tableModel.getTableName();
                    String execSql = String.format("delete from %s where fsbillid = %s", tableName, fsbillid);
                    LOG.info("AutoPushUtils#deleteAssociation exec: " + execSql);
                    boolean execute = DB.execute((DBRoute)DBRoute.of((String)dbRoute), (String)execSql);
                    LOG.info("AutoPushUtils#deleteAssociation exec result: " + execute);
                });
            }
            catch (Exception e) {
                h.markRollback();
                LOG.error("AutoPushUtils.deleteAssociation error", (Throwable)e);
                throw e;
            }
        }
    }
}

