/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ContractTypeUtils {
    public static DynamicObjectCollection getListConfigs(DynamicObject contType) {
        if (contType == null) {
            return null;
        }
        contType = BusinessDataServiceHelper.loadSingle((Object)contType.getPkValue(), (String)"pmct_conttype");
        DynamicObject contAttr = contType.getDynamicObject("contattr");
        DynamicObjectCollection listConfigs = contType.getDynamicObjectCollection("listconfigentry");
        Set tabNameSet = listConfigs.stream().map(obj -> obj.getString("tabname")).collect(Collectors.toSet());
        boolean isOnList = contType.getBoolean("isonlist");
        if (contAttr != null && isOnList) {
            DynamicObjectCollection attrListConfigs = (contAttr = BusinessDataServiceHelper.loadSingle((Object)contAttr.get("id"), (String)"pmct_contattr")).getDynamicObjectCollection("listconfigentry");
            if (attrListConfigs != null) {
                ContractTypeUtils.convertListModelToId(attrListConfigs);
                for (DynamicObject attrListConfig : attrListConfigs) {
                    if (tabNameSet.contains(attrListConfig.getString("tabname"))) continue;
                    listConfigs.add((Object)attrListConfig);
                }
            }
            if (listConfigs.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u5f53\u524d\u5408\u540c\u7684\u5408\u540c\u7c7b\u578b\u91cc\u914d\u7f6e\u6e05\u5355\u6a21\u677f\u3002", (String)"ContractTypeUtils_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
            }
        }
        return listConfigs;
    }

    public static DynamicObjectCollection convertListModelToId(DynamicObjectCollection listConfigs) {
        for (DynamicObject listConfig : listConfigs) {
            listConfig.set("id", listConfig.getDynamicObject("listmodel").getPkValue());
        }
        return listConfigs;
    }

    public static Set<Object> getContTplList(Object contTypeId, QFilter contTemplateTypeFilter) {
        Set<Object> idSet = new HashSet<Object>();
        if (!QueryServiceHelper.exists((String)"pmct_conttype", (Object)contTypeId)) {
            return idSet;
        }
        QFilter effectiveFilter = new QFilter("effective", "=", (Object)Boolean.TRUE);
        DynamicObject contractType = BusinessDataServiceHelper.loadSingle((Object)contTypeId, (String)"pmct_conttype");
        DynamicObjectCollection contTplEntry = contractType.getDynamicObjectCollection("conttplentry");
        QFilter qFilter = null;
        if (contTplEntry == null || contTplEntry.size() == 0) {
            DynamicObject conAttr = contractType.getDynamicObject("contattr");
            if (conAttr != null) {
                qFilter = new QFilter("group", "=", contractType.getDynamicObject("contattr").getPkValue());
            }
        } else {
            Set tplIdSet = contTplEntry.stream().map(obj -> obj.getDynamicObject("conttemplate").getPkValue()).collect(Collectors.toSet());
            qFilter = new QFilter("id", "in", tplIdSet);
        }
        if (qFilter == null) {
            return idSet;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"pmct_conttemplate", (String)"id", (QFilter[])new QFilter[]{effectiveFilter = effectiveFilter.and(contTemplateTypeFilter).and(qFilter)});
        if (collection.size() > 0) {
            idSet = collection.stream().map(obj -> obj.get("id")).collect(Collectors.toSet());
        }
        return idSet;
    }
}

