/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.utils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.SupervisionIdentTypeEnum;
import kd.pmgt.pmbs.common.enums.supervision.FinishStatusWarningEnum;

public class ProjectSupervisionHelper {
    public static String getItemWarnLight(Date estimateEndTime, Date actualEndTime) {
        if (actualEndTime == null) {
            Date currDate = new Date();
            LocalDate localDateOfCurr = ZonedDateTime.ofInstant(currDate.toInstant(), ZoneId.systemDefault()).toLocalDate();
            if (estimateEndTime == null) {
                return FinishStatusWarningEnum.NOTFINISH.getValue();
            }
            LocalDate localDateOfEstimate = ZonedDateTime.ofInstant(estimateEndTime.toInstant(), ZoneId.systemDefault()).toLocalDate();
            if (localDateOfCurr.isBefore(localDateOfEstimate) || localDateOfCurr.equals(localDateOfEstimate)) {
                return FinishStatusWarningEnum.NOTFINISH.getValue();
            }
            return FinishStatusWarningEnum.OVERDUENOTFINISH.getValue();
        }
        if (estimateEndTime == null) {
            return FinishStatusWarningEnum.ONTIMEFINISH.getValue();
        }
        LocalDate localDateOfEstimate = ZonedDateTime.ofInstant(estimateEndTime.toInstant(), ZoneId.systemDefault()).toLocalDate();
        LocalDate localDateOfActual = ZonedDateTime.ofInstant(actualEndTime.toInstant(), ZoneId.systemDefault()).toLocalDate();
        if (localDateOfActual.isBefore(localDateOfEstimate) || localDateOfActual.equals(localDateOfEstimate)) {
            return FinishStatusWarningEnum.ONTIMEFINISH.getValue();
        }
        return FinishStatusWarningEnum.OVERDUEFINISH.getValue();
    }

    public static String getProjectWarnLight(DynamicObjectCollection entryEntity) {
        if (entryEntity == null || entryEntity.isEmpty()) {
            return "";
        }
        HashMap<String, Integer> warnStatusMap = new HashMap<String, Integer>();
        int allShowData = 0;
        for (DynamicObject entryObj : entryEntity) {
            boolean isHiddenData = entryObj.getBoolean("hiddendata");
            boolean isDeleted = entryObj.getBoolean("deleted");
            if (isHiddenData || isDeleted) continue;
            ++allShowData;
            String warnStatusValue = entryObj.getString("itemwarninglight");
            Integer statusCount = (Integer)warnStatusMap.get(warnStatusValue);
            if (statusCount == null) {
                statusCount = 1;
                warnStatusMap.put(warnStatusValue, statusCount);
                continue;
            }
            statusCount = statusCount + 1;
            warnStatusMap.put(warnStatusValue, statusCount);
        }
        Integer redLights = (Integer)warnStatusMap.get(FinishStatusWarningEnum.OVERDUENOTFINISH.getValue());
        Integer yellowLights = (Integer)warnStatusMap.get(FinishStatusWarningEnum.OVERDUEFINISH.getValue());
        Integer greenLights = (Integer)warnStatusMap.get(FinishStatusWarningEnum.ONTIMEFINISH.getValue());
        Integer greyLights = (Integer)warnStatusMap.get(FinishStatusWarningEnum.NOTFINISH.getValue());
        if (redLights != null && redLights > 0) {
            return FinishStatusWarningEnum.OVERDUENOTFINISH.getValue();
        }
        if ((redLights == null || redLights == 0) && yellowLights != null && yellowLights > 0) {
            return FinishStatusWarningEnum.OVERDUEFINISH.getValue();
        }
        if (!(redLights != null && redLights != 0 || yellowLights != null && yellowLights != 0 || greenLights == null || greenLights <= 0)) {
            return FinishStatusWarningEnum.ONTIMEFINISH.getValue();
        }
        if (greyLights != null && greyLights == allShowData) {
            return FinishStatusWarningEnum.NOTFINISH.getValue();
        }
        return null;
    }

    public static DynamicObject[] getEffectiveSupervisionFinishRecordByWorkItem(Object workItemId, Object supervisionFinishId) {
        QFilter filter = new QFilter("workitem", "=", workItemId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter identFilter = new QFilter("identificationtype", "!=", (Object)SupervisionIdentTypeEnum.UNAUDIT.getValue());
        filter.and(statusFilter).and(identFilter);
        if (supervisionFinishId != null) {
            filter.or("id", "=", supervisionFinishId);
        }
        return BusinessDataServiceHelper.load((String)"pmfs_supervisionfinish", (String)"billno,sysbill,bizbillno,bizbillid,actualendtime", (QFilter[])new QFilter[]{filter}, (String)"actualendtime");
    }

    public static QFilter getWorkItemFilterByProject(Object projectId) {
        QFilter projectFilter = new QFilter("project", "=", projectId);
        QFilter deleteFilter = new QFilter("deleted", "!=", (Object)true);
        QFilter hideFilter = new QFilter("hiddendata", "!=", (Object)true);
        return projectFilter.and(deleteFilter).and(hideFilter);
    }
}

