/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.utils;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ksql.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.DefaultEnum;

public class ReportConfigUtils {
    public static DynamicObject gainReportorg(String projectkind, String declarateorg, String formBillId) {
        QFilter billCodeFilter;
        if (projectkind == null || declarateorg == null || formBillId == null) {
            return null;
        }
        DynamicObject reportorg = null;
        DynamicObject reqOrgConf = null;
        QFilter billFilter = new QFilter("billcode", "=", (Object)formBillId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
        reqOrgConf = BusinessDataServiceHelper.loadSingle((String)"pmbs_reqorgconf", (QFilter[])new QFilter[]{billFilter, enableFilter});
        if (reqOrgConf != null) {
            reportorg = ReportConfigUtils.getReportOrgByKindAndOrg(projectkind, declarateorg, reqOrgConf);
        }
        if (reportorg == null && (reqOrgConf = BusinessDataServiceHelper.loadSingle((String)"pmbs_reqorgconf", (QFilter[])new QFilter[]{billCodeFilter = new QFilter("billcode", "=", (Object)""), enableFilter})) != null) {
            reportorg = ReportConfigUtils.getReportOrgByKindAndOrg(projectkind, declarateorg, reqOrgConf);
        }
        return reportorg;
    }

    private static DynamicObject getReportOrgByKindAndOrg(String projectkind, String declarateorg, DynamicObject reqOrgConf) {
        DynamicObject reportorg = null;
        DynamicObjectCollection entryentity = reqOrgConf.getDynamicObjectCollection("entryentity");
        if (null != entryentity && entryentity.size() > 0) {
            for (DynamicObject entry : entryentity) {
                DynamicObjectCollection declarateorgs = entry.getDynamicObjectCollection("declarateorg");
                if (null == declarateorgs || declarateorgs.size() <= 0) continue;
                HashSet<String> declarateorgids = new HashSet<String>();
                for (DynamicObject declarateorgobj : declarateorgs) {
                    declarateorgids.add(declarateorgobj.getDynamicObject("fbasedataid").getPkValue().toString());
                }
                DynamicObject projectkindConfig = entry.getDynamicObject("projectkind");
                if (!declarateorgids.contains(declarateorg)) continue;
                if (null != projectkindConfig && projectkindConfig.getPkValue() != null) {
                    boolean result = ReportConfigUtils.gainSameProjectkind(projectkind, projectkindConfig.getPkValue().toString());
                    if (!result) continue;
                    reportorg = entry.getDynamicObject("reportorg");
                    continue;
                }
                reportorg = entry.getDynamicObject("reportorg");
            }
        }
        return reportorg;
    }

    private static boolean gainSameProjectkind(String projectkind, String configKindPk) {
        boolean result = false;
        if (StringUtil.isEmpty((String)configKindPk) || StringUtil.isEmpty((String)projectkind)) {
            return false;
        }
        if (projectkind.equals(configKindPk)) {
            result = true;
        } else {
            DynamicObject projectkindObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(projectkind), (String)"bd_projectkind");
            if (projectkindObj.getDynamicObject("parent") != null) {
                result = ReportConfigUtils.gainSameProjectkind(projectkindObj.getDynamicObject("parent").getPkValue().toString(), configKindPk);
            }
        }
        return result;
    }
}

